/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs;

import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.masterfs.InvalidDummy;
import org.netbeans.modules.masterfs.MasterFileObject;
import org.netbeans.modules.masterfs.MountTable;
import org.netbeans.modules.masterfs.ResourcePath;
import org.netbeans.modules.masterfs.SpecialDelegates;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.WriteLock;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.WriteLockFactory;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.WriteLockUtils;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.WeakListeners;

final class Delegate {
    private FileObject delegate;
    private FileObject secondDelegate;
    private FileChangeListener priorityWeakListener;
    private FileChangeListener versioningWeakListener;
    private final FileChangeListener priorityListener;
    private final FileChangeListener versioningListener;
    private Reference lock = null;
    private int attribs = 0;
    static final int SECOND_DELEGATE = 1;
    static final int BEST_DELEGATE = 0;
    private final MasterFileObject mfo;

    Delegate(FileObject fileObject, FileChangeListener fileChangeListener, FileChangeListener fileChangeListener2, MasterFileObject masterFileObject) {
        this.priorityListener = fileChangeListener;
        this.versioningListener = fileChangeListener2;
        this.mfo = masterFileObject;
    }

    FileObject get() {
        ResourcePath resourcePath = this.mfo.getResource();
        FileObject fileObject = this.delegate;
        if (this.delegate instanceof InvalidDelegate) {
            fileObject = null;
        } else if (fileObject == null) {
            fileObject = Delegate.resolve(resourcePath, true);
            this.set(fileObject);
        }
        return fileObject;
    }

    FileObject get(boolean bl) {
        FileObject fileObject = this.get();
        if (bl && fileObject == null) {
            fileObject = this.delegate;
        }
        return fileObject;
    }

    static FileObject resolve(ResourcePath resourcePath) {
        return Delegate.resolve(resourcePath, true);
    }

    private static FileObject resolve(ResourcePath resourcePath, boolean bl) {
        File file;
        String string = resourcePath.getNormalizedPath();
        if (WriteLockUtils.hasActiveLockFileSigns(string) && WriteLockUtils.hasActiveLockFileSigns((file = new ResourcePath(string).getFile()).getName())) {
            return null;
        }
        FileObject fileObject = bl ? MountTable.getDefault().resolveBestDelegate(string) : MountTable.getDefault().resolveSecondDelegate(string);
        if (fileObject == null) {
            fileObject = SpecialDelegates.get(resourcePath);
        } else {
            fileObject.getAttribute("--hack--");
        }
        return fileObject;
    }

    static FileLock getLockForDelegate(FileLock fileLock, FileObject fileObject) throws IOException {
        if (fileLock == null) {
            throw new IOException();
        }
        if (!(fileLock instanceof FileLockImpl)) {
            throw new IOException();
        }
        FileLockImpl fileLockImpl = (FileLockImpl)fileLock;
        Delegate delegate = fileLockImpl.getDelegate();
        if (delegate.getFileLockImpl() != fileLockImpl) {
            throw new IOException();
        }
        FileLock fileLock2 = fileLockImpl.get(fileObject);
        if (fileLock2 == null) {
            throw new IOException();
        }
        return fileLock2;
    }

    FileObject getPrefered() {
        FileObject fileObject = this.get();
        FileObject fileObject2 = null;
        if (fileObject != null && fileObject.isRoot()) {
            fileObject2 = this.getSecond();
        }
        return fileObject2 != null ? fileObject2 : fileObject;
    }

    void reset(ResourcePath resourcePath) {
        FileObject fileObject = this.delegate;
        this.set(null);
        this.setSecond(null);
        if (this.get() == null) {
            boolean bl = fileObject != null ? fileObject.isFolder() : false;
            this.delegate = new InvalidDelegate(resourcePath, bl);
        } else {
            this.getSecond();
            this.attribs = 0;
            try {
                this.reLock();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    boolean isValid() {
        return this.delegate != null && this.delegate.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocked() {
        FileLockImpl fileLockImpl;
        String string = this.mfo.getPath();
        Class clazz = Delegate.class;
        synchronized (clazz) {
            fileLockImpl = this.getFileLockImpl();
        }
        return fileLockImpl != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileLock lock() throws IOException {
        FileLockImpl fileLockImpl;
        String string = this.mfo.getPath();
        Class clazz = Delegate.class;
        synchronized (clazz) {
            fileLockImpl = this.getFileLockImpl();
            if (fileLockImpl != null) {
                throw new FileAlreadyLockedException(string);
            }
            fileLockImpl = new FileLockImpl();
            this.lock = new WeakReference<FileLockImpl>(fileLockImpl);
        }
        fileLockImpl.initLock(this.mfo.getResource().getFile(), this.get(), this.getPrefered());
        return fileLockImpl;
    }

    boolean hasMountAbleFlag() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void set(FileObject fileObject) {
        Delegate delegate = this;
        synchronized (delegate) {
            FileChangeListener fileChangeListener = this.priorityWeakListener;
            FileChangeListener fileChangeListener2 = this.versioningWeakListener;
            FileObject fileObject2 = this.delegate;
            if (fileObject2 == fileObject) {
                return;
            }
            if (fileChangeListener != null && fileObject2 != null) {
                fileObject2.removeFileChangeListener(fileChangeListener);
            }
            if (fileChangeListener2 != null && fileObject2 != null) {
                fileObject2.removeFileChangeListener(fileChangeListener2);
            }
            this.delegate = fileObject;
            if (fileObject != null) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.openide.filesystems.FileObject$PriorityFileChangeListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw (IllegalStateException)new IllegalStateException(classNotFoundException.getMessage()).initCause(classNotFoundException);
                }
                this.priorityWeakListener = (FileChangeListener)WeakListeners.create(clazz, (Class)FileChangeListener.class, (EventListener)this.priorityListener, (Object)fileObject);
                fileObject.addFileChangeListener(this.priorityWeakListener);
                this.versioningWeakListener = (FileChangeListener)WeakListeners.create((Class)FileChangeListener.class, (Class)FileChangeListener.class, (EventListener)this.versioningListener, (Object)fileObject);
                fileObject.addFileChangeListener(this.versioningWeakListener);
            }
        }
    }

    private void reLock() throws IOException {
        FileLockImpl fileLockImpl = this.getFileLockImpl();
        if (fileLockImpl != null) {
            fileLockImpl.lock(this.delegate);
            fileLockImpl.lock(this.secondDelegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileLockImpl getFileLockImpl() {
        FileLockImpl fileLockImpl;
        Class clazz = Delegate.class;
        synchronized (clazz) {
            fileLockImpl = this.lock == null ? null : this.lock.get();
        }
        return fileLockImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSecond(FileObject fileObject) {
        Delegate delegate = this;
        synchronized (delegate) {
            this.secondDelegate = fileObject;
        }
    }

    private FileObject getSecond() {
        ResourcePath resourcePath = this.mfo.getResource();
        FileObject fileObject = this.secondDelegate;
        if (fileObject == null) {
            fileObject = Delegate.resolve(resourcePath, false);
            this.setSecond(fileObject);
        }
        return fileObject;
    }

    private static class InvalidDelegate
    extends InvalidDummy {
        private final boolean isFolder;

        protected InvalidDelegate(ResourcePath resourcePath, boolean bl) {
            super(resourcePath);
            this.isFolder = bl;
        }

        public boolean isData() {
            return !this.isFolder;
        }

        public boolean isFolder() {
            return this.isFolder;
        }
    }

    private static class TestLockException
    extends IOException {
        Map m = new HashMap();

        private TestLockException() {
        }

        void put(FileLockImpl fileLockImpl, String string) {
            this.m.put(fileLockImpl, new Exception(string));
        }

        public void printStackTrace(FileLockImpl fileLockImpl, FileLockImpl fileLockImpl2) {
            Exception exception;
            Exception exception2 = (Exception)this.m.get((Object)fileLockImpl);
            if (exception2 != null) {
                System.err.println("-------- " + exception2.getLocalizedMessage() + " ----------");
                exception2.printStackTrace();
            }
            if ((exception = (Exception)this.m.get((Object)fileLockImpl2)) != null) {
                System.err.println("-------- " + exception.getLocalizedMessage() + " ----------");
                exception.printStackTrace();
            }
        }
    }

    private final class FileLockImpl
    extends FileLock {
        private final Map lockList = new WeakHashMap();
        private FileLock mandatoryLock;

        FileLockImpl() {
        }

        private void initLock(File file, FileObject fileObject, FileObject fileObject2) throws IOException {
            try {
                this.lock(fileObject);
                this.lock(fileObject2);
                if (this.mandatoryLock == null && file != null && (fileObject != null && fileObject.isData() || fileObject2 != null && fileObject2.isData())) {
                    this.mandatoryLock = WriteLockFactory.tryLock(file, false);
                }
            }
            catch (IOException iOException) {
                this.releaseLock();
                throw iOException;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void releaseLock() {
            if (this.isValid()) {
                super.releaseLock();
                if (this.mandatoryLock != null) {
                    this.mandatoryLock.releaseLock();
                }
                Collection collection = this.lockList.values();
                Object object = collection.iterator();
                while (object.hasNext()) {
                    FileLock fileLock = (FileLock)object.next();
                    fileLock.releaseLock();
                }
                if (this.getCurrentLock() == this) {
                    object = class$org$netbeans$modules$masterfs$Delegate == null ? (class$org$netbeans$modules$masterfs$Delegate = Delegate.class$("org.netbeans.modules.masterfs.Delegate")) : class$org$netbeans$modules$masterfs$Delegate;
                    synchronized (object) {
                        Delegate.this.lock = null;
                    }
                }
            }
            Delegate.this.mfo;
            MasterFileObject.getExtensions().fileUnlocked(Delegate.this.mfo);
        }

        private FileLock getCurrentLock() {
            return Delegate.this.lock != null ? (FileLock)Delegate.this.lock.get() : null;
        }

        private void lock(FileObject fileObject) throws IOException {
            if (fileObject != null && this.get(fileObject) == null) {
                FileLock fileLock = fileObject.lock();
                if (this.mandatoryLock == null && fileLock instanceof WriteLock) {
                    this.mandatoryLock = fileLock;
                }
                this.lockList.put(fileObject, fileLock);
            }
        }

        private FileLock get(FileObject fileObject) {
            return (FileLock)this.lockList.get(fileObject);
        }

        private Delegate getDelegate() {
            return Delegate.this;
        }
    }
}

