/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.modules.appui.welcome;

import com.sun.tools.visualvm.modules.appui.welcome.Constants;
import com.sun.tools.visualvm.modules.appui.welcome.Utils;
import com.sun.tools.visualvm.modules.appui.welcome.WebLink;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.border.Border;

class ContentsPanel
extends JPanel
implements Constants {
    public ContentsPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new GridLayout(4, 2, 0, 0));
        this.addLink("Link1", false, false);
        this.addLink("Link2", false, true);
        this.addLink("Link3", false, false);
        this.addLink("Link4", false, true);
        this.addLink("Link5", false, false);
        this.addLink("Link6", false, true);
        this.addLink("Link7", true, false);
        this.addLink("Link8", true, true);
        this.setBackground(Utils.getColor("ContentBackgroundColor"));
    }

    private void addLink(String resourceKey, boolean drawBottom, boolean drawRight) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.add((Component)new WebLink(resourceKey), "Center");
        panel.setBorder(new MyBorder(drawBottom, drawRight));
        this.add(panel);
    }

    private static class MyBorder
    implements Border {
        private static final Color COLOR = Utils.getColor("BorderColor");
        private boolean drawBottom;
        private boolean drawRight;

        public MyBorder(boolean drawBottom, boolean drawRight) {
            this.drawBottom = drawBottom;
            this.drawRight = drawRight;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(COLOR);
            g.drawLine(x, y, x + width, y);
            g.drawLine(x, y, x, y + height);
            if (this.drawRight) {
                g.drawLine(x + width - 1, y, x + width - 1, y + height);
            }
            if (this.drawBottom) {
                g.drawLine(x, y + height - 1, x + width, y + height - 1);
            }
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(8, 8, 8, 8);
        }

        public boolean isBorderOpaque() {
            return false;
        }
    }
}

