/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.monitor;

import org.netbeans.lib.profiler.client.MonitoredData;
import org.netbeans.lib.profiler.results.DataManager;

public class VMTelemetryDataManager
extends DataManager {
    public long[] freeMemory;
    public long[] gcFinishs;
    public long[] gcStarts;
    public long[] lastGCPauseInMS;
    public long[] loadedClassesCount;
    public long[] nSurvivingGenerations;
    public long[] nSystemThreads;
    public long[] nTotalThreads;
    public long[] nUserThreads;
    public long[] relativeGCTimeInPerMil;
    public long[] timeStamps;
    public long[] totalMemory;
    public long[] usedMemory;
    public long maxHeapSize = Long.MAX_VALUE;
    private MonitoredData lastData = null;
    private int arrayBufferSize;
    private int currentArraysSize;
    private int currentGCArraysSize;
    private int gcItemCount;
    private int itemCount;

    public VMTelemetryDataManager() {
        this(50);
    }

    public VMTelemetryDataManager(int arrayBufferSize) {
        this.arrayBufferSize = arrayBufferSize;
        this.reset();
    }

    public synchronized void setArrayBufferSize(int arrayBufferSize) {
        this.arrayBufferSize = arrayBufferSize;
    }

    public synchronized int getArrayBufferSize() {
        return this.arrayBufferSize;
    }

    public synchronized int getGCItemCount() {
        return this.gcItemCount;
    }

    public synchronized int getItemCount() {
        return this.itemCount;
    }

    public synchronized MonitoredData getLastData() {
        return this.lastData;
    }

    public synchronized void processData(MonitoredData data) {
        this.addValuesInternal(data.getTimestamp(), data.getFreeMemory(), data.getTotalMemory(), data.getNUserThreads(), data.getNSystemThreads(), data.getNSurvivingGenerations(), data.getRelativeGCTimeInPerMil(), data.getLastGCPauseInMS(), data.getLoadedClassesCount(), data.getGCStarts(), data.getGCFinishs());
        this.lastData = data;
    }

    public synchronized void reset() {
        this.lastData = null;
        this.itemCount = 0;
        this.gcItemCount = 0;
        this.timeStamps = new long[this.arrayBufferSize];
        this.freeMemory = new long[this.arrayBufferSize];
        this.totalMemory = new long[this.arrayBufferSize];
        this.usedMemory = new long[this.arrayBufferSize];
        this.nUserThreads = new long[this.arrayBufferSize];
        this.nSystemThreads = new long[this.arrayBufferSize];
        this.nTotalThreads = new long[this.arrayBufferSize];
        this.nSurvivingGenerations = new long[this.arrayBufferSize];
        this.relativeGCTimeInPerMil = new long[this.arrayBufferSize];
        this.lastGCPauseInMS = new long[this.arrayBufferSize];
        this.loadedClassesCount = new long[this.arrayBufferSize];
        this.currentArraysSize = this.arrayBufferSize;
        this.currentGCArraysSize = this.arrayBufferSize;
        this.gcStarts = new long[this.arrayBufferSize];
        this.gcFinishs = new long[this.arrayBufferSize];
        this.fireDataReset();
    }

    private void addValuesInternal(long timeStamp, long freeMemory, long totalMemory, long nUserThreads, long nSystemThreads, long nSurvivingGenerations, long relativeGCTimeInPerMil, long lastGCPauseInMS, long loadedClassesCount, long[] gcStarts, long[] gcFinishs) {
        this.checkArraysSize();
        this.timeStamps[this.itemCount] = timeStamp;
        this.freeMemory[this.itemCount] = freeMemory;
        this.totalMemory[this.itemCount] = totalMemory;
        this.usedMemory[this.itemCount] = totalMemory - freeMemory;
        this.nUserThreads[this.itemCount] = nUserThreads;
        this.nSystemThreads[this.itemCount] = nSystemThreads;
        this.nTotalThreads[this.itemCount] = nSystemThreads + nUserThreads;
        this.nSurvivingGenerations[this.itemCount] = nSurvivingGenerations;
        this.relativeGCTimeInPerMil[this.itemCount] = relativeGCTimeInPerMil;
        this.lastGCPauseInMS[this.itemCount] = lastGCPauseInMS;
        this.loadedClassesCount[this.itemCount] = loadedClassesCount;
        ++this.itemCount;
        int gcDataCount = Math.min(gcStarts.length, gcFinishs.length);
        for (int i = 0; i < gcDataCount; ++i) {
            this.gcStarts[this.gcItemCount] = gcStarts[i];
            this.gcFinishs[this.gcItemCount] = gcFinishs[i];
            ++this.gcItemCount;
            this.checkArraysSize();
        }
        this.fireDataChanged();
    }

    private void checkArraysSize() {
        if (this.currentArraysSize == this.itemCount) {
            this.timeStamps = VMTelemetryDataManager.extendArray(this.timeStamps, this.arrayBufferSize);
            this.freeMemory = VMTelemetryDataManager.extendArray(this.freeMemory, this.arrayBufferSize);
            this.totalMemory = VMTelemetryDataManager.extendArray(this.totalMemory, this.arrayBufferSize);
            this.usedMemory = VMTelemetryDataManager.extendArray(this.usedMemory, this.arrayBufferSize);
            this.nUserThreads = VMTelemetryDataManager.extendArray(this.nUserThreads, this.arrayBufferSize);
            this.nSystemThreads = VMTelemetryDataManager.extendArray(this.nSystemThreads, this.arrayBufferSize);
            this.nTotalThreads = VMTelemetryDataManager.extendArray(this.nTotalThreads, this.arrayBufferSize);
            this.nSurvivingGenerations = VMTelemetryDataManager.extendArray(this.nSurvivingGenerations, this.arrayBufferSize);
            this.relativeGCTimeInPerMil = VMTelemetryDataManager.extendArray(this.relativeGCTimeInPerMil, this.arrayBufferSize);
            this.lastGCPauseInMS = VMTelemetryDataManager.extendArray(this.lastGCPauseInMS, this.arrayBufferSize);
            this.loadedClassesCount = VMTelemetryDataManager.extendArray(this.loadedClassesCount, this.arrayBufferSize);
            this.currentArraysSize += this.arrayBufferSize;
        }
        if (this.currentGCArraysSize == this.gcItemCount) {
            this.gcStarts = VMTelemetryDataManager.extendArray(this.gcStarts, this.arrayBufferSize);
            this.gcFinishs = VMTelemetryDataManager.extendArray(this.gcFinishs, this.arrayBufferSize);
            this.currentGCArraysSize += this.arrayBufferSize;
        }
    }

    private static long[] extendArray(long[] array, int extraLength) {
        int originalLength = array.length;
        long[] newArray = new long[originalLength + extraLength];
        System.arraycopy(array, 0, newArray, 0, originalLength);
        return newArray;
    }
}

