/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.memory;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.logging.Level;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.JMethodIdTable;
import org.netbeans.lib.profiler.results.memory.MemoryCCTProvider;
import org.netbeans.lib.profiler.results.memory.PresoObjAllocCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeMemoryCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeObjAllocTermCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeObjLivenessTermCCTNode;

public abstract class MemoryResultsSnapshot
extends ResultsSnapshot {
    private JMethodIdTable table;
    private String[] classNames;
    private long[] objectsSizePerClass;
    private RuntimeMemoryCCTNode[] stacksForClasses;
    private int nProfiledClasses;

    public MemoryResultsSnapshot() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryResultsSnapshot(long beginTime, long timeTaken, MemoryCCTProvider provider, ProfilerClient client) throws ClientUtils.TargetAppOrVMTerminated {
        super(beginTime, timeTaken);
        ProfilingSessionStatus status = client.getStatus();
        status.beginTrans(false);
        try {
            this.performInit(client, provider);
            this.nProfiledClasses = provider.getNProfiledClasses();
            int len = 0;
            if (provider.getObjectsSizePerClass() != null) {
                len = provider.getObjectsSizePerClass().length;
                this.objectsSizePerClass = new long[len];
                System.arraycopy(provider.getObjectsSizePerClass(), 0, this.objectsSizePerClass, 0, len);
            }
            String[] s_classNames = status.getClassNames();
            len = this.nProfiledClasses;
            this.classNames = new String[len];
            System.arraycopy(s_classNames, 0, this.classNames, 0, len);
            if (provider.getStacksForClasses() != null && this.checkContainsStacks(provider.getStacksForClasses())) {
                this.stacksForClasses = new RuntimeMemoryCCTNode[provider.getStacksForClasses().length];
                HashSet ids = new HashSet(10000);
                for (int i = 0; i < this.stacksForClasses.length; ++i) {
                    if (provider.getStacksForClasses()[i] == null) continue;
                    this.stacksForClasses[i] = (RuntimeMemoryCCTNode)provider.getStacksForClasses()[i].clone();
                    this.stacksForClasses[i].addAllJMethodIds(ids);
                }
                Integer[] array = new Integer[ids.size()];
                ids.toArray(array);
                int[] primArray = new int[ids.size()];
                for (int j = 0; j < array.length; ++j) {
                    primArray[j] = array[j];
                }
                String[][] methodNames = client.getMethodNamesForJMethodIds(primArray);
                this.table = new JMethodIdTable(primArray, methodNames);
            }
        }
        finally {
            status.endTrans();
            if (LOGGER.isLoggable(Level.FINEST)) {
                this.debugValues();
            }
        }
    }

    public String getClassName(int classId) {
        return this.classNames[classId];
    }

    public String[] getClassNames() {
        return this.classNames;
    }

    public JMethodIdTable getJMethodIdTable() {
        return this.table;
    }

    public int getNProfiledClasses() {
        return this.nProfiledClasses;
    }

    public long[] getObjectsSizePerClass() {
        return this.objectsSizePerClass;
    }

    public boolean containsStacks() {
        return this.stacksForClasses != null;
    }

    public PresoObjAllocCCTNode createPresentationCCT(int classId, boolean dontShowZeroLiveObjAllocPaths) {
        if (this.stacksForClasses == null) {
            return null;
        }
        RuntimeMemoryCCTNode rootNode = this.stacksForClasses[classId];
        if (rootNode == null) {
            return null;
        }
        return this.createPresentationCCT(rootNode, classId, dontShowZeroLiveObjAllocPaths);
    }

    public void readFromStream(DataInputStream in) throws IOException {
        super.readFromStream(in);
        this.nProfiledClasses = in.readInt();
        this.classNames = new String[this.nProfiledClasses];
        this.objectsSizePerClass = new long[this.nProfiledClasses];
        for (int i = 0; i < this.nProfiledClasses; ++i) {
            this.classNames[i] = in.readUTF();
            this.objectsSizePerClass[i] = in.readLong();
        }
        if (in.readBoolean()) {
            int len = in.readInt();
            this.stacksForClasses = new RuntimeMemoryCCTNode[len];
            for (int i = 0; i < len; ++i) {
                int type = in.readInt();
                if (type == 0) continue;
                this.stacksForClasses[i] = RuntimeMemoryCCTNode.create(type);
                this.stacksForClasses[i].readFromStream(in);
            }
            if (in.readBoolean()) {
                this.table = new JMethodIdTable();
                this.table.readFromStream(in);
            }
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            this.debugValues();
        }
    }

    public void writeToStream(DataOutputStream out) throws IOException {
        int i;
        super.writeToStream(out);
        out.writeInt(this.nProfiledClasses);
        for (i = 0; i < this.nProfiledClasses; ++i) {
            out.writeUTF(this.classNames[i]);
            out.writeLong(this.objectsSizePerClass[i]);
        }
        out.writeBoolean(this.stacksForClasses != null);
        if (this.stacksForClasses != null) {
            out.writeInt(this.stacksForClasses.length);
            for (i = 0; i < this.stacksForClasses.length; ++i) {
                if (this.stacksForClasses[i] == null) {
                    out.writeInt(0);
                    continue;
                }
                out.writeInt(this.stacksForClasses[i].getType());
                this.stacksForClasses[i].writeToStream(out);
            }
            out.writeBoolean(this.table != null);
            if (this.table != null) {
                this.table.writeToStream(out);
            }
        }
    }

    protected abstract PresoObjAllocCCTNode createPresentationCCT(RuntimeMemoryCCTNode var1, int var2, boolean var3);

    protected abstract void performInit(ProfilerClient var1, MemoryCCTProvider var2) throws ClientUtils.TargetAppOrVMTerminated;

    private boolean checkContainsStacks(RuntimeMemoryCCTNode[] stacksForClasses) {
        for (int i = 0; i < stacksForClasses.length; ++i) {
            RuntimeMemoryCCTNode stacksForClass = stacksForClasses[i];
            if (stacksForClass == null || stacksForClass instanceof RuntimeObjAllocTermCCTNode || stacksForClass instanceof RuntimeObjLivenessTermCCTNode) continue;
            return true;
        }
        return false;
    }

    void debugValues() {
        LOGGER.finest("nProfiledClasses: " + this.nProfiledClasses);
        LOGGER.finest("stacksForClasses.length: " + this.debugLength(this.stacksForClasses));
        LOGGER.finest("objectsSizePerClass.length: " + this.debugLength(this.objectsSizePerClass));
        LOGGER.finest("classNames.length: " + this.debugLength(this.classNames));
        LOGGER.finest("table: " + (this.table == null ? "null" : this.table.debug()));
    }
}

