/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.AllThreadsMergedCPUCCTContainer;
import org.netbeans.lib.profiler.results.cpu.CPUCCTClassContainer;
import org.netbeans.lib.profiler.results.cpu.CPUCCTContainer;
import org.netbeans.lib.profiler.results.cpu.CPUCCTProvider;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainer;
import org.netbeans.lib.profiler.results.cpu.MethodIdMap;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNodeBacked;

public class CPUResultsSnapshot
extends ResultsSnapshot {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.results.cpu.Bundle");
    private static final String CPU_MSG = messages.getString("CPUResultsSnapshot_CpuMsg");
    public static final int METHOD_LEVEL_VIEW = 0;
    public static final int CLASS_LEVEL_VIEW = 1;
    public static final int PACKAGE_LEVEL_VIEW = 2;
    private Map threadIdMap;
    private CPUCCTContainer[] allThreadsMergedCCTContainers;
    private String[][] instrMethodClassesViews;
    private String[] instrMethodNames;
    private String[] instrMethodSignatures;
    private PrestimeCPUCCTNode[] rootNode;
    private CPUCCTContainer[][] threadCCTContainers;
    private boolean collectingTwoTimeStamps;
    private boolean sortNodesOrder;
    private int nInstrMethods;
    private int sortNodesBy;

    public CPUResultsSnapshot() {
        this.threadIdMap = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CPUResultsSnapshot(long beginTime, long timeTaken, CPUCCTProvider cctProvider, ProfilingSessionStatus status) throws NoDataAvailableException {
        super(beginTime, timeTaken);
        status.beginTrans(false);
        try {
            this.collectingTwoTimeStamps = status.collectingTwoTimeStamps();
            this.instrMethodClassesViews = new String[3][];
            this.instrMethodClassesViews[0] = status.getInstrMethodClasses();
            this.instrMethodNames = status.getInstrMethodNames();
            this.instrMethodSignatures = status.getInstrMethodSignatures();
            this.nInstrMethods = status.getNInstrMethods();
        }
        finally {
            status.endTrans();
        }
        CPUCCTContainer[] methodLevelCCTs = cctProvider.createPresentationCCTs(this);
        if (methodLevelCCTs == null) {
            throw new NoDataAvailableException();
        }
        int len = methodLevelCCTs.length;
        if (len == 0) {
            throw new NoDataAvailableException();
        }
        this.threadIdMap = new HashMap(methodLevelCCTs.length);
        for (int i = 0; i < methodLevelCCTs.length; ++i) {
            this.threadIdMap.put(methodLevelCCTs[i].threadId, i);
        }
        this.threadCCTContainers = new CPUCCTContainer[3][];
        this.threadCCTContainers[0] = methodLevelCCTs;
        this.allThreadsMergedCCTContainers = new CPUCCTContainer[3];
        this.rootNode = new PrestimeCPUCCTNode[3];
        this.rootNode[0] = this.createRootNodeForAllThreads(0);
        if (LOGGER.isLoggable(Level.FINEST)) {
            this.debugValues();
        }
    }

    public boolean isCollectingTwoTimeStamps() {
        return this.collectingTwoTimeStamps;
    }

    public CPUCCTContainer getContainerForThread(int threadId, int view) {
        if (this.threadCCTContainers[view] == null) {
            this.generateDataForView(view);
        }
        return this.threadCCTContainers[view][this.getContainerIdForThreadId(threadId)];
    }

    public FlatProfileContainer getFlatProfile(int threadId, int view) {
        if (this.threadCCTContainers[view] == null) {
            this.generateDataForView(view);
        }
        if (threadId != -1) {
            return this.threadCCTContainers[view][this.getContainerIdForThreadId(threadId)].getFlatProfile();
        }
        return this.allThreadsMergedCCTContainers[view].getFlatProfile();
    }

    public String[] getInstrMethodClasses(int view) {
        return this.instrMethodClassesViews[view];
    }

    public String[] getInstrMethodNames() {
        return this.instrMethodNames;
    }

    public String[] getInstrMethodSignatures() {
        return this.instrMethodSignatures;
    }

    public String[] getMethodClassNameAndSig(int methodId, int view) {
        if (view == 0) {
            return new String[]{this.instrMethodClassesViews[0][methodId], this.instrMethodNames[methodId], this.instrMethodSignatures[methodId]};
        }
        return new String[]{this.instrMethodClassesViews[view][methodId], null, null};
    }

    public int getNInstrMethods() {
        return this.nInstrMethods;
    }

    public int getNThreads() {
        return this.threadCCTContainers[0].length;
    }

    public PrestimeCPUCCTNode getReverseCCT(int threadId, int methodId, int view) {
        if (this.threadCCTContainers[view] == null) {
            this.generateDataForView(view);
        }
        if (threadId >= 0) {
            return this.threadCCTContainers[view][this.getContainerIdForThreadId(threadId)].getReverseCCT(methodId);
        }
        if (threadId == -1) {
            return this.allThreadsMergedCCTContainers[view].getReverseCCT(methodId);
        }
        throw new IllegalArgumentException("!!! Cannot generate reverse CCT for threadId = " + threadId);
    }

    public PrestimeCPUCCTNode getRootNode(int view) {
        if (this.threadCCTContainers[view] == null) {
            this.generateDataForView(view);
        }
        return this.rootNode[view];
    }

    public int getSortBy() {
        return this.sortNodesBy;
    }

    public boolean getSortOrder() {
        return this.sortNodesOrder;
    }

    public int[] getThreadIds() {
        int[] ret = new int[this.threadCCTContainers[0].length];
        for (int i = 0; i < this.threadCCTContainers[0].length; ++i) {
            ret[i] = this.threadCCTContainers[0][i].threadId;
        }
        return ret;
    }

    public String getThreadNameForId(int threadId) {
        return this.getThreadNames()[this.getContainerIdForThreadId(threadId)];
    }

    public String[] getThreadNames() {
        String[] ret = new String[this.threadCCTContainers[0].length];
        for (int i = 0; i < this.threadCCTContainers[0].length; ++i) {
            ret[i] = this.threadCCTContainers[0][i].threadName;
        }
        return ret;
    }

    public void readFromStream(DataInputStream in) throws IOException {
        super.readFromStream(in);
        this.collectingTwoTimeStamps = in.readBoolean();
        this.nInstrMethods = in.readInt();
        this.instrMethodClassesViews = new String[3][];
        String[] classNames = new String[this.nInstrMethods];
        this.instrMethodClassesViews[0] = classNames;
        this.instrMethodNames = new String[this.nInstrMethods];
        this.instrMethodSignatures = new String[this.nInstrMethods];
        for (int i = 0; i < this.nInstrMethods; ++i) {
            classNames[i] = in.readUTF();
            this.instrMethodNames[i] = in.readUTF();
            this.instrMethodSignatures[i] = in.readUTF();
        }
        int nThreads = in.readInt();
        this.threadCCTContainers = new CPUCCTContainer[3][];
        CPUCCTContainer[] containers = new CPUCCTContainer[nThreads];
        this.threadCCTContainers[0] = containers;
        for (int i = 0; i < nThreads; ++i) {
            containers[i] = new CPUCCTContainer(this);
            containers[i].readFromStream(in);
            this.threadIdMap.put(containers[i].threadId, i);
        }
        this.allThreadsMergedCCTContainers = new CPUCCTContainer[3];
        this.rootNode = new PrestimeCPUCCTNode[3];
        this.rootNode[0] = this.createRootNodeForAllThreads(0);
        if (LOGGER.isLoggable(Level.FINEST)) {
            this.debugValues();
        }
    }

    public void saveSortParams(int sortBy, boolean sortOrder) {
        this.sortNodesBy = sortBy;
        this.sortNodesOrder = sortOrder;
    }

    public String toString() {
        return MessageFormat.format(CPU_MSG, super.toString());
    }

    public void writeToStream(DataOutputStream out) throws IOException {
        super.writeToStream(out);
        out.writeBoolean(this.collectingTwoTimeStamps);
        out.writeInt(this.nInstrMethods);
        String[] classNames = this.instrMethodClassesViews[0];
        for (int i = 0; i < this.nInstrMethods; ++i) {
            out.writeUTF(classNames[i]);
            out.writeUTF(this.instrMethodNames[i]);
            out.writeUTF(this.instrMethodSignatures[i]);
        }
        CPUCCTContainer[] containers = this.threadCCTContainers[0];
        int nThreads = containers.length;
        out.writeInt(nThreads);
        for (int i = 0; i < nThreads; ++i) {
            containers[i].writeToStream(out);
        }
    }

    private int getContainerIdForThreadId(int threadId) {
        Integer tid = threadId;
        Integer cId = null;
        if (this.threadIdMap.containsKey(tid)) {
            cId = (Integer)this.threadIdMap.get(tid);
        }
        return cId != null ? cId : 0;
    }

    private PrestimeCPUCCTNode createRootNodeForAllThreads(int view) {
        CPUCCTContainer[] ccts = this.threadCCTContainers[view];
        int len = ccts.length;
        PrestimeCPUCCTNode[] threadNodes = new PrestimeCPUCCTNode[len];
        for (int i = 0; i < len; ++i) {
            PrestimeCPUCCTNode tRootNode = ccts[i].getRootNode();
            threadNodes[i] = !tRootNode.isThreadNode() ? new PrestimeCPUCCTNodeBacked(ccts[i], new PrestimeCPUCCTNode[]{tRootNode}) : tRootNode;
        }
        this.allThreadsMergedCCTContainers[view] = new AllThreadsMergedCPUCCTContainer(this, threadNodes, view);
        return this.allThreadsMergedCCTContainers[view].getRootNode();
    }

    private void debugValues() {
        LOGGER.finest("collectingTwoTimeStamps: " + this.collectingTwoTimeStamps);
        LOGGER.finest("threadCCTContainers.length: " + this.debugLength(this.threadCCTContainers));
        LOGGER.finest("allThreadsMergedCCTContainers.length: " + this.debugLength(this.allThreadsMergedCCTContainers));
        LOGGER.finest("rootNode.length: " + this.debugLength(this.rootNode));
        LOGGER.finest("instrMethodClassesViews.length: " + this.debugLength(this.instrMethodClassesViews));
        LOGGER.finest("instrMethodNames.length: " + this.debugLength(this.instrMethodNames));
        LOGGER.finest("instrMethodSignatures.length: " + this.debugLength(this.instrMethodSignatures));
        LOGGER.finest("nInstrMethods: " + this.nInstrMethods);
        LOGGER.finest("sortNodesBy: " + this.sortNodesBy);
        LOGGER.finest("sortNodesOrder: " + this.sortNodesOrder);
    }

    private void generateDataForView(int view) {
        if (this.threadCCTContainers[view] == null) {
            MethodIdMap methodIdMap = new MethodIdMap(this.instrMethodClassesViews[0], this.nInstrMethods, view);
            int len = this.threadCCTContainers[0].length;
            this.threadCCTContainers[view] = new CPUCCTContainer[len];
            for (int i = 0; i < len; ++i) {
                this.threadCCTContainers[view][i] = new CPUCCTClassContainer(this.threadCCTContainers[0][i], methodIdMap, view);
            }
            this.rootNode[view] = this.createRootNodeForAllThreads(view);
            this.instrMethodClassesViews[view] = methodIdMap.getInstrClassesOrPackages();
        }
    }

    public static class NoDataAvailableException
    extends Exception {
    }
}

