/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.global.InstrumentationFilter;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainer;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainerBacked;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNodeBacked;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNodeFree;
import org.netbeans.lib.profiler.results.cpu.TimingAdjusterOld;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.MethodCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.RuntimeCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.TimedCPUCCTNode;

public class CPUCCTContainer {
    private static final Logger LOGGER = Logger.getLogger(CPUCCTContainer.class.getName());
    protected static final int OFS_METHODID = 0;
    protected static final int OFS_NCALLS = 2;
    protected static final int OFS_TIME0 = 6;
    protected static final int OFS_SELFTIME0 = 11;
    protected static final int OFS_TIME1 = 16;
    protected static final int OFS_SELFTIME1 = 21;
    protected static final int OFS_NSUBNODES1 = 16;
    protected static final int OFS_NSUBNODES2 = 26;
    protected static final int OFS_SUBNODE01 = 18;
    protected static final int OFS_SUBNODE02 = 28;
    protected static final int CHILD_OFS_SIZE_3 = 3;
    protected static final int CHILD_OFS_SIZE_4 = 4;
    private static double timeInInjectedCodeInMS;
    private static double wholeGraphGrossTimeAbsInMS;
    protected CPUResultsSnapshot cpuResSnapshot;
    protected FlatProfileContainer cachedFlatProfile;
    protected PrestimeCPUCCTNode rootNode;
    protected String threadName;
    protected byte[] compactData;
    protected int[] invPerMethodId;
    protected long[] timePerMethodId0;
    protected long[] timePerMethodId1;
    protected boolean collectingTwoTimeStamps;
    protected boolean displayWholeThreadCPUTime;
    protected double timeInInjectedCodeInAbsCounts;
    protected double timeInInjectedCodeInThreadCPUCounts;
    protected int childOfsSize = -1;
    protected int nodeSize;
    protected int threadId;
    protected long wholeGraphGrossTimeAbs;
    protected long wholeGraphGrossTimeThreadCPU;
    protected long wholeGraphNetTime0;
    protected long wholeGraphNetTime1;
    protected long wholeGraphPureTimeAbs;
    protected long wholeGraphPureTimeThreadCPU;
    private InstrumentationFilter filter;
    private PrestimeCPUCCTNodeFree reverseCCTRootNode;
    private ProfilingSessionStatus status;
    private int[] nodeStack;
    private int childTotalNCalls;
    private int currentNodeStackSize;
    private int nodeStackPtr;
    private int selectedMethodId;
    private long childTotalTime0InTimerUnits;
    private long childTotalTime1InTimerUnits;
    private long totalInvNo;

    public CPUCCTContainer(TimedCPUCCTNode rtRootNode, CPUResultsSnapshot cpuResSnapshot, ProfilingSessionStatus status, InstrumentationFilter usedFilter, int nNodes, double[] threadActiveTimesInCounts, int threadId, String threadName) {
        this(cpuResSnapshot);
        this.threadId = threadId;
        this.threadName = threadName;
        this.status = status;
        this.filter = usedFilter;
        this.collectingTwoTimeStamps = cpuResSnapshot.isCollectingTwoTimeStamps();
        this.generateCompactData(rtRootNode, nNodes);
        this.calculateThreadActiveTimesInMS(threadActiveTimesInCounts, status);
        this.rootNode = new PrestimeCPUCCTNodeBacked(this, null, 0);
        if (rtRootNode.isRoot()) {
            this.rootNode.setThreadNode();
        }
    }

    protected CPUCCTContainer(CPUResultsSnapshot cpuResSnapshot) {
        this.cpuResSnapshot = cpuResSnapshot;
    }

    public CPUResultsSnapshot getCPUResSnapshot() {
        return this.cpuResSnapshot;
    }

    public int getChildOfsForNodeOfs(int nodeOfs, int childIdx) {
        if (this.childOfsSize == 4) {
            return this.get4Bytes(nodeOfs + (this.collectingTwoTimeStamps ? 28 : 18) + this.childOfsSize * childIdx);
        }
        return this.get3Bytes(nodeOfs + (this.collectingTwoTimeStamps ? 28 : 18) + this.childOfsSize * childIdx);
    }

    public boolean isCollectingTwoTimeStamps() {
        return this.collectingTwoTimeStamps;
    }

    public FlatProfileContainer getFlatProfile() {
        return this.generateFlatProfile();
    }

    public String[] getMethodClassNameAndSig(int methodId) {
        return this.cpuResSnapshot.getMethodClassNameAndSig(methodId, 0);
    }

    public int getMethodIdForNodeOfs(int nodeOfs) {
        return this.get2Bytes(nodeOfs + 0);
    }

    public int getNCallsForNodeOfs(int nodeOfs) {
        return this.get4Bytes(nodeOfs + 2);
    }

    public int getNChildrenForNodeOfs(int nodeOfs) {
        return this.get2Bytes(nodeOfs + (this.collectingTwoTimeStamps ? 26 : 16));
    }

    public PrestimeCPUCCTNode getReverseCCT(int methodId) {
        return this.generateReverseCCT(methodId);
    }

    public PrestimeCPUCCTNode getRootNode() {
        return this.rootNode;
    }

    public long getSelfTime0ForNodeOfs(int nodeOfs) {
        return this.get5Bytes(nodeOfs + 11);
    }

    public long getSelfTime1ForNodeOfs(int nodeOfs) {
        return this.get5Bytes(nodeOfs + 21);
    }

    public long getSleepTime0ForNodeOfs(int nodeOfs) {
        return 0L;
    }

    public int getThreadId() {
        return this.threadId;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public static double getTimeInInjectedCodeForDisplayedThread() {
        return timeInInjectedCodeInMS;
    }

    public long getTotalTime0ForNodeOfs(int nodeOfs) {
        return this.get5Bytes(nodeOfs + 6);
    }

    public long getTotalTime1ForNodeOfs(int nodeOfs) {
        return this.get5Bytes(nodeOfs + 16);
    }

    public long getWaitTime0ForNodeOfs(int nodeOfs) {
        return 0L;
    }

    public static double getWholeGraphGrossTimeAbsForDisplayedThread() {
        return wholeGraphGrossTimeAbsInMS;
    }

    public long getWholeGraphNetTime0() {
        return this.wholeGraphNetTime0;
    }

    public long getWholeGraphNetTime1() {
        return this.wholeGraphNetTime1;
    }

    public long getWholeGraphPureTimeAbs() {
        return this.wholeGraphPureTimeAbs;
    }

    public long getWholeGraphPureTimeThreadCPU() {
        return this.wholeGraphPureTimeThreadCPU;
    }

    public boolean canDisplayWholeGraphCPUTime() {
        return this.displayWholeThreadCPUTime;
    }

    public void readFromStream(DataInputStream in) throws IOException {
        this.threadId = in.readInt();
        this.threadName = in.readUTF();
        this.collectingTwoTimeStamps = in.readBoolean();
        int len = in.readInt();
        this.compactData = new byte[len];
        this.childOfsSize = this.compactData.length > 0xFFFFFF ? 4 : 3;
        in.readFully(this.compactData);
        this.nodeSize = in.readInt();
        this.wholeGraphGrossTimeAbs = in.readLong();
        this.wholeGraphGrossTimeThreadCPU = in.readLong();
        this.timeInInjectedCodeInAbsCounts = in.readDouble();
        this.timeInInjectedCodeInThreadCPUCounts = in.readDouble();
        this.wholeGraphPureTimeAbs = in.readLong();
        this.wholeGraphPureTimeThreadCPU = in.readLong();
        this.wholeGraphNetTime0 = in.readLong();
        this.wholeGraphNetTime1 = in.readLong();
        this.totalInvNo = in.readLong();
        this.displayWholeThreadCPUTime = in.readBoolean();
        this.rootNode = new PrestimeCPUCCTNodeBacked(this, null, 0);
        if (this.getMethodIdForNodeOfs(0) == 0) {
            this.rootNode.setThreadNode();
        }
    }

    public void writeToStream(DataOutputStream out) throws IOException {
        out.writeInt(this.threadId);
        out.writeUTF(this.threadName);
        out.writeBoolean(this.collectingTwoTimeStamps);
        out.writeInt(this.compactData.length);
        out.write(this.compactData);
        out.writeInt(this.nodeSize);
        out.writeLong(this.wholeGraphGrossTimeAbs);
        out.writeLong(this.wholeGraphGrossTimeThreadCPU);
        out.writeDouble(this.timeInInjectedCodeInAbsCounts);
        out.writeDouble(this.timeInInjectedCodeInThreadCPUCounts);
        out.writeLong(this.wholeGraphPureTimeAbs);
        out.writeLong(this.wholeGraphPureTimeThreadCPU);
        out.writeLong(this.wholeGraphNetTime0);
        out.writeLong(this.wholeGraphNetTime1);
        out.writeLong(this.totalInvNo);
        out.writeBoolean(this.displayWholeThreadCPUTime);
    }

    protected void setChildOfsForNodeOfs(int nodeOfs, int childIdx, int val) {
        if (this.childOfsSize == 4) {
            this.store4Bytes(nodeOfs + (this.collectingTwoTimeStamps ? 28 : 18) + this.childOfsSize * childIdx, val);
        } else {
            this.store3Bytes(nodeOfs + (this.collectingTwoTimeStamps ? 28 : 18) + this.childOfsSize * childIdx, val);
        }
    }

    protected void setMethodIdForNodeOfs(int nodeOfs, int val) {
        this.store2Bytes(nodeOfs + 0, val);
    }

    protected void setNCallsForNodeOfs(int nodeOfs, int val) {
        this.store4Bytes(nodeOfs + 2, val);
    }

    protected void setNChildrenForNodeOfs(int nodeOfs, int val) {
        this.store2Bytes(nodeOfs + (this.collectingTwoTimeStamps ? 26 : 16), val);
    }

    protected void setSelfTime0ForNodeOfs(int nodeOfs, long val) {
        this.store5Bytes(nodeOfs + 11, val);
    }

    protected void setSelfTime1ForNodeOfs(int nodeOfs, long val) {
        this.store5Bytes(nodeOfs + 21, val);
    }

    protected void setSleepTime0ForNodeOfs(int dataOfs, long waitTime0) {
    }

    protected void setTotalTime0ForNodeOfs(int nodeOfs, long val) {
        this.store5Bytes(nodeOfs + 6, val);
    }

    protected void setTotalTime1ForNodeOfs(int nodeOfs, long val) {
        this.store5Bytes(nodeOfs + 16, val);
    }

    protected void setWaitTime0ForNodeOfs(int dataOfs, long waitTime0) {
    }

    protected void addFlatProfTimeForNode(int dataOfs) {
        int methodId;
        int nChildren = this.getNChildrenForNodeOfs(dataOfs);
        if (nChildren > 0) {
            for (int i = 0; i < nChildren; ++i) {
                int childOfs = this.getChildOfsForNodeOfs(dataOfs, i);
                this.addFlatProfTimeForNode(childOfs);
            }
        }
        int n = methodId = this.getMethodIdForNodeOfs(dataOfs);
        this.timePerMethodId0[n] = this.timePerMethodId0[n] + this.getSelfTime0ForNodeOfs(dataOfs);
        if (this.collectingTwoTimeStamps) {
            int n2 = methodId;
            this.timePerMethodId1[n2] = this.timePerMethodId1[n2] + this.getSelfTime1ForNodeOfs(dataOfs);
        }
        int n3 = methodId;
        this.invPerMethodId[n3] = this.invPerMethodId[n3] + this.getNCallsForNodeOfs(dataOfs);
    }

    protected void addToReverseCCT(PrestimeCPUCCTNodeFree reverseNode, int methodId) {
        this.selectedMethodId = methodId;
        this.reverseCCTRootNode = reverseNode;
        this.currentNodeStackSize = 320;
        this.nodeStack = new int[this.currentNodeStackSize];
        this.nodeStackPtr = 0;
        this.checkStraightGraphNode(0);
        this.nodeStack = null;
        this.reverseCCTRootNode = null;
    }

    protected void checkStraightGraphNode(int dataOfs) {
        if (this.nodeStackPtr >= this.currentNodeStackSize) {
            int[] newNodeStack = new int[this.currentNodeStackSize * 2];
            System.arraycopy(this.nodeStack, 0, newNodeStack, 0, this.currentNodeStackSize);
            this.nodeStack = newNodeStack;
            this.currentNodeStackSize *= 2;
        }
        this.nodeStack[this.nodeStackPtr++] = dataOfs;
        if (this.getMethodIdForNodeOfs(dataOfs) == this.selectedMethodId) {
            this.addReversePath();
        }
        int nChildren = this.getNChildrenForNodeOfs(dataOfs);
        for (int i = 0; i < nChildren; ++i) {
            this.checkStraightGraphNode(this.getChildOfsForNodeOfs(dataOfs, i));
        }
        --this.nodeStackPtr;
    }

    protected FlatProfileContainer generateFlatProfile() {
        this.preGenerateFlatProfile();
        this.addFlatProfTimeForNode(0);
        return this.postGenerateFlatProfile();
    }

    protected PrestimeCPUCCTNodeFree generateReverseCCT(int methodId) {
        this.selectedMethodId = methodId;
        this.currentNodeStackSize = 320;
        this.nodeStack = new int[this.currentNodeStackSize];
        this.nodeStackPtr = 0;
        this.checkStraightGraphNode(0);
        PrestimeCPUCCTNodeFree ret = this.reverseCCTRootNode;
        this.nodeStack = null;
        this.reverseCCTRootNode = null;
        return ret;
    }

    protected int get2Bytes(int ofs) {
        return (this.compactData[ofs] & 0xFF) << 8 | this.compactData[ofs + 1] & 0xFF;
    }

    protected int get3Bytes(int ofs) {
        return (this.compactData[ofs++] & 0xFF) << 16 | (this.compactData[ofs++] & 0xFF) << 8 | this.compactData[ofs++] & 0xFF;
    }

    protected int get4Bytes(int ofs) {
        return (this.compactData[ofs++] & 0xFF) << 24 | (this.compactData[ofs++] & 0xFF) << 16 | (this.compactData[ofs++] & 0xFF) << 8 | this.compactData[ofs++] & 0xFF;
    }

    protected long get5Bytes(int ofs) {
        return ((long)this.compactData[ofs++] & 0xFFL) << 32 | ((long)this.compactData[ofs++] & 0xFFL) << 24 | ((long)this.compactData[ofs++] & 0xFFL) << 16 | ((long)this.compactData[ofs++] & 0xFFL) << 8 | (long)this.compactData[ofs++] & 0xFFL;
    }

    protected FlatProfileContainer postGenerateFlatProfile() {
        FlatProfileContainerBacked fpc = new FlatProfileContainerBacked(this, this.timePerMethodId0, this.timePerMethodId1, this.invPerMethodId, this.timePerMethodId0.length);
        this.timePerMethodId1 = null;
        this.timePerMethodId0 = null;
        this.invPerMethodId = null;
        return fpc;
    }

    protected void preGenerateFlatProfile() {
        int totalMethods = this.cpuResSnapshot.getNInstrMethods();
        this.timePerMethodId0 = new long[totalMethods];
        if (this.collectingTwoTimeStamps) {
            this.timePerMethodId1 = new long[totalMethods];
        }
        this.invPerMethodId = new int[totalMethods];
        this.timePerMethodId0[0] = -1L;
    }

    protected void store2Bytes(int ofs, int data) {
        this.compactData[ofs] = (byte)(data >> 8 & 0xFF);
        this.compactData[ofs + 1] = (byte)(data & 0xFF);
    }

    protected void store3Bytes(int ofs, int data) {
        int curPos = ofs;
        this.compactData[curPos++] = (byte)(data >> 16 & 0xFF);
        this.compactData[curPos++] = (byte)(data >> 8 & 0xFF);
        this.compactData[curPos++] = (byte)(data & 0xFF);
    }

    protected void store4Bytes(int ofs, int data) {
        int curPos = ofs;
        this.compactData[curPos++] = (byte)(data >> 24 & 0xFF);
        this.compactData[curPos++] = (byte)(data >> 16 & 0xFF);
        this.compactData[curPos++] = (byte)(data >> 8 & 0xFF);
        this.compactData[curPos++] = (byte)(data & 0xFF);
    }

    protected void store5Bytes(int ofs, long data) {
        int curPos = ofs;
        this.compactData[curPos++] = (byte)(data >> 32 & 0xFFL);
        this.compactData[curPos++] = (byte)(data >> 24 & 0xFFL);
        this.compactData[curPos++] = (byte)(data >> 16 & 0xFFL);
        this.compactData[curPos++] = (byte)(data >> 8 & 0xFFL);
        this.compactData[curPos++] = (byte)(data & 0xFFL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChild(TimedCPUCCTNode node, TimedCPUCCTNode parent) {
        if (node == null || parent == null) {
            return;
        }
        TimedCPUCCTNode compParent = null;
        TimedCPUCCTNode newChild = null;
        int filterStatus = node.getFilteredStatus();
        if (!(node instanceof MethodCPUCCTNode)) {
            filterStatus = 2;
        }
        switch (filterStatus) {
            case 2: {
                compParent = parent;
                break;
            }
            case 1: {
                if (node instanceof MethodCPUCCTNode) {
                    this.status.beginTrans(false);
                    try {
                        String className = this.status.getInstrMethodClasses()[((MethodCPUCCTNode)node).getMethodId()].replace('.', '/');
                        if (!this.filter.passesFilter(className)) {
                            compParent = parent;
                            break;
                        }
                        compParent = newChild = (TimedCPUCCTNode)node.clone();
                        break;
                    }
                    finally {
                        this.status.endTrans();
                    }
                }
                compParent = parent;
                break;
            }
            case 0: {
                MethodCPUCCTNode existingChild = MethodCPUCCTNode.Locator.locate(((MethodCPUCCTNode)node).getMethodId(), parent.getChildren());
                if (existingChild == null) {
                    newChild = (TimedCPUCCTNode)node.clone();
                } else {
                    newChild = null;
                    existingChild.addNCalls(node.getNCalls());
                    existingChild.addNCallsDiff(node.getNCallsDiff());
                    existingChild.addNetTime0(node.getNetTime0());
                    existingChild.addNetTime1(node.getNetTime1());
                    existingChild.addSleepTime0(node.getSleepTime0());
                    existingChild.addWaitTime0(node.getWaitTime0());
                }
                compParent = newChild;
                break;
            }
            default: {
                ProfilerLogger.warning("Unknown filtered status (" + filterStatus + ") for " + node);
            }
        }
        int nChildren = node.getChildren() != null ? node.getChildren().size() : 0;
        for (int i = 0; i < nChildren; ++i) {
            this.addChild((TimedCPUCCTNode)node.getChildren().getChildAt(i), compParent);
        }
        if (newChild != null) {
            parent.attachNodeAsChild(newChild);
        } else if (!parent.isRoot()) {
            parent.addNetTime0(node.getNetTime0());
            parent.addNCallsDiff(node.getNCalls());
            if (this.collectingTwoTimeStamps) {
                parent.addNetTime1(node.getNetTime1());
            }
        }
    }

    private void addReversePath() {
        int stackTopIdx;
        PrestimeCPUCCTNodeFree curNode = null;
        for (int i = stackTopIdx = this.nodeStackPtr - 1; i >= 0; --i) {
            int prevSourceNodeOfs;
            int sourceNodeOfs = this.nodeStack[i];
            int sourceNodeId = this.getMethodIdForNodeOfs(sourceNodeOfs);
            if (sourceNodeId == 0) {
                return;
            }
            boolean matchingChildFound = false;
            if (i < stackTopIdx) {
                PrestimeCPUCCTNodeFree[] curNodeChildren = (PrestimeCPUCCTNodeFree[])curNode.getChildren();
                if (curNodeChildren != null) {
                    for (int j = 0; j < curNodeChildren.length; ++j) {
                        if (curNodeChildren[j].getMethodId() != sourceNodeId) continue;
                        curNode = curNodeChildren[j];
                        if (curNode.isContextCallsNode()) {
                            prevSourceNodeOfs = this.nodeStack[i + 1];
                            this.mergeBySelfTime(curNode, prevSourceNodeOfs);
                            curNode = (PrestimeCPUCCTNodeFree)curNode.getChildren()[0];
                        }
                        this.mergeBySelfTime(curNode, sourceNodeOfs);
                        matchingChildFound = true;
                        break;
                    }
                }
            } else {
                curNode = this.reverseCCTRootNode;
                if (curNode == null) {
                    this.reverseCCTRootNode = curNode = this.createChildlessCopyBySelfTime(sourceNodeOfs);
                } else {
                    this.mergeBySelfTime(curNode, sourceNodeOfs);
                }
                matchingChildFound = true;
            }
            if (matchingChildFound) continue;
            PrestimeCPUCCTNodeFree newNode = this.createChildlessCopyBySelfTime(sourceNodeOfs);
            PrestimeCPUCCTNodeFree[] curNodeChildren = (PrestimeCPUCCTNodeFree[])curNode.getChildren();
            if (curNodeChildren != null) {
                prevSourceNodeOfs = this.nodeStack[i + 1];
                if (curNodeChildren.length == 1) {
                    PrestimeCPUCCTNodeFree origFirstChild = curNodeChildren[0];
                    PrestimeCPUCCTNodeFree ccNode = curNode.createChildlessCopy();
                    this.subtractNodeDataBySelfTime(ccNode, prevSourceNodeOfs);
                    ccNode.setMethodId(origFirstChild.getMethodId());
                    ccNode.setContextCallsNode();
                    curNodeChildren[0] = ccNode;
                    ccNode.parent = curNode;
                    ccNode.addChild(origFirstChild);
                    origFirstChild.parent = ccNode;
                }
                PrestimeCPUCCTNodeFree ccNode = this.createChildlessCopyBySelfTime(prevSourceNodeOfs);
                ccNode.setMethodId(this.getMethodIdForNodeOfs(sourceNodeOfs));
                ccNode.setContextCallsNode();
                curNode.addChild(ccNode);
                ccNode.parent = curNode;
                curNode = ccNode;
            }
            curNode.addChild(newNode);
            newNode.parent = curNode;
            curNode = newNode;
        }
    }

    private void calculateThreadActiveTimesInMS(double[] threadActiveTimesInCounts, ProfilingSessionStatus status) {
        this.wholeGraphGrossTimeAbs = (long)threadActiveTimesInCounts[0];
        this.wholeGraphGrossTimeThreadCPU = (long)threadActiveTimesInCounts[1];
        this.timeInInjectedCodeInAbsCounts = threadActiveTimesInCounts[2];
        this.timeInInjectedCodeInThreadCPUCounts = threadActiveTimesInCounts[3];
        wholeGraphGrossTimeAbsInMS += (double)this.wholeGraphGrossTimeAbs * 1000.0 / (double)status.timerCountsInSecond[0];
        timeInInjectedCodeInMS += this.timeInInjectedCodeInAbsCounts * 1000.0 / (double)status.timerCountsInSecond[0];
        this.wholeGraphPureTimeAbs += (long)((int)(((double)this.wholeGraphGrossTimeAbs - this.timeInInjectedCodeInAbsCounts) * 1000000.0 / (double)status.timerCountsInSecond[0]));
        if (this.wholeGraphGrossTimeThreadCPU > 0L) {
            this.displayWholeThreadCPUTime = true;
            this.wholeGraphPureTimeThreadCPU += (long)((int)(((double)this.wholeGraphGrossTimeThreadCPU - this.timeInInjectedCodeInThreadCPUCounts) * 1000000.0 / (double)status.timerCountsInSecond[1]));
        } else {
            this.displayWholeThreadCPUTime = false;
        }
        if (this.wholeGraphPureTimeAbs < 0L) {
            this.wholeGraphPureTimeAbs = 0L;
        }
        if (this.wholeGraphPureTimeThreadCPU < 0L) {
            this.wholeGraphPureTimeThreadCPU = 0L;
        }
        this.wholeGraphNetTime0 += this.get5Bytes(6);
        if (this.collectingTwoTimeStamps) {
            this.wholeGraphNetTime1 += this.get5Bytes(16);
        }
    }

    private PrestimeCPUCCTNodeFree createChildlessCopyBySelfTime(int sourceNodeDataOfs) {
        PrestimeCPUCCTNodeFree node = new PrestimeCPUCCTNodeFree(this, null, this.getMethodIdForNodeOfs(sourceNodeDataOfs));
        this.mergeBySelfTime(node, sourceNodeDataOfs);
        return node;
    }

    private TimedCPUCCTNode filterCCT(TimedCPUCCTNode rootNode) {
        TimedCPUCCTNode newRoot = (TimedCPUCCTNode)rootNode.clone();
        int nChildren = rootNode.getChildren() != null ? rootNode.getChildren().size() : 0;
        for (int i = 0; i < nChildren; ++i) {
            this.addChild((TimedCPUCCTNode)rootNode.getChildren().getChildAt(i), newRoot);
        }
        newRoot.setNetTime0(0L);
        if (this.collectingTwoTimeStamps) {
            newRoot.setNetTime1(0L);
        }
        return newRoot;
    }

    private void generateCompactData(TimedCPUCCTNode rootNode, int nNodes) {
        this.nodeSize = this.collectingTwoTimeStamps ? 28 : 18;
        this.childOfsSize = 3;
        int arraySize = this.nodeSize * nNodes + this.childOfsSize * (nNodes - 1);
        if (arraySize > 0xFFFFFF) {
            this.childOfsSize = 4;
            arraySize = this.nodeSize * nNodes + this.childOfsSize * (nNodes - 1);
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("generateCompact data: nNodes " + nNodes);
            LOGGER.finest("generateCompact data: node size " + this.nodeSize);
            LOGGER.finest("generateCompact data: array size " + arraySize);
            LOGGER.finest("generateCompact data: child offset " + this.childOfsSize);
        }
        this.compactData = new byte[arraySize];
        rootNode = this.filterCCT(rootNode);
        this.generateMirrorNode(rootNode, 0);
    }

    private int generateMirrorNode(TimedCPUCCTNode rtNode, int dataOfs) {
        long time;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Generate mirror node for ofs: " + dataOfs + ", node: " + rtNode);
        }
        long thisNodeTotalTime0InTimerUnits = 0L;
        long thisNodeTotalTime1InTimerUnits = 0L;
        int nCallsFromThisNode = 0;
        int totalNCallsFromThisNode = 0;
        this.generateNodeBase(rtNode, dataOfs);
        this.totalInvNo += (long)rtNode.getNCalls();
        RuntimeCPUCCTNode.Children nodeChildren = rtNode.getChildren();
        int nChildren = nodeChildren != null ? nodeChildren.size() : 0;
        int nextNodeOfs = dataOfs + this.nodeSize + nChildren * this.childOfsSize;
        nCallsFromThisNode += rtNode.getNCallsDiff();
        if (nChildren > 0) {
            int childCounter = 0;
            for (int i = 0; i < nChildren; ++i) {
                RuntimeCPUCCTNode aNode = nodeChildren.getChildAt(i);
                if (!(aNode instanceof MethodCPUCCTNode)) continue;
                this.setChildOfsForNodeOfs(dataOfs, childCounter, nextNodeOfs);
                nextNodeOfs = this.generateMirrorNode((MethodCPUCCTNode)aNode, nextNodeOfs);
                thisNodeTotalTime0InTimerUnits += this.childTotalTime0InTimerUnits;
                if (this.collectingTwoTimeStamps) {
                    thisNodeTotalTime1InTimerUnits += this.childTotalTime1InTimerUnits;
                }
                nCallsFromThisNode += ((MethodCPUCCTNode)aNode).getNCalls();
                totalNCallsFromThisNode += this.childTotalNCalls;
                ++childCounter;
            }
        }
        if ((time = (long)TimingAdjusterOld.getDefault(this.status).adjustTime(rtNode.getNetTime0(), rtNode.getNCalls(), nCallsFromThisNode, false)) < 0L) {
            time = 0L;
        }
        this.setSelfTime0ForNodeOfs(dataOfs, time);
        this.setWaitTime0ForNodeOfs(dataOfs, rtNode.getWaitTime0());
        this.setSleepTime0ForNodeOfs(dataOfs, rtNode.getSleepTime0());
        this.childTotalTime0InTimerUnits = thisNodeTotalTime0InTimerUnits += rtNode.getNetTime0();
        time = (long)TimingAdjusterOld.getDefault(this.status).adjustTime(thisNodeTotalTime0InTimerUnits, rtNode.getNCalls(), totalNCallsFromThisNode, false);
        if (time < 0L) {
            time = 0L;
        }
        this.setTotalTime0ForNodeOfs(dataOfs, time);
        if (this.collectingTwoTimeStamps) {
            time = (long)TimingAdjusterOld.getDefault(this.status).adjustTime(rtNode.getNetTime1(), rtNode.getNCalls(), nCallsFromThisNode, true);
            if (time < 0L) {
                time = 0L;
            }
            this.setSelfTime1ForNodeOfs(dataOfs, time);
            this.childTotalTime1InTimerUnits = thisNodeTotalTime1InTimerUnits += rtNode.getNetTime1();
            time = (long)TimingAdjusterOld.getDefault(this.status).adjustTime(thisNodeTotalTime1InTimerUnits, rtNode.getNCalls(), totalNCallsFromThisNode, true);
            if (time < 0L) {
                time = 0L;
            }
            this.setTotalTime1ForNodeOfs(dataOfs, time);
        }
        this.childTotalNCalls = totalNCallsFromThisNode + rtNode.getNCalls();
        return nextNodeOfs;
    }

    private void generateNodeBase(TimedCPUCCTNode rtNode, int nodeDataOfs) {
        int methodId = rtNode instanceof MethodCPUCCTNode ? ((MethodCPUCCTNode)rtNode).getMethodId() : 0;
        int nCalls = rtNode.getNCalls();
        int nChildren = rtNode.getChildren() != null ? rtNode.getChildren().size() : 0;
        this.setMethodIdForNodeOfs(nodeDataOfs, methodId);
        this.setNCallsForNodeOfs(nodeDataOfs, nCalls);
        this.setNChildrenForNodeOfs(nodeDataOfs, nChildren);
    }

    private void mergeBySelfTime(PrestimeCPUCCTNodeFree curNode, int sourceNodeDataOfs) {
        curNode.addNCalls(this.getNCallsForNodeOfs(sourceNodeDataOfs));
        curNode.addTotalTime0(this.getSelfTime0ForNodeOfs(sourceNodeDataOfs));
        if (this.collectingTwoTimeStamps) {
            curNode.addTotalTime1(this.getSelfTime1ForNodeOfs(sourceNodeDataOfs));
        }
        curNode.addWaitTime0(this.getWaitTime0ForNodeOfs(sourceNodeDataOfs));
        curNode.addSleepTime0(this.getSleepTime0ForNodeOfs(sourceNodeDataOfs));
    }

    private void subtractNodeDataBySelfTime(PrestimeCPUCCTNodeFree curNode, int sourceNodeDataOfs) {
        curNode.addNCalls(-this.getNCallsForNodeOfs(sourceNodeDataOfs));
        curNode.addTotalTime0(-this.getSelfTime0ForNodeOfs(sourceNodeDataOfs));
        if (this.collectingTwoTimeStamps) {
            curNode.addTotalTime1(-this.getSelfTime1ForNodeOfs(sourceNodeDataOfs));
        }
        curNode.addWaitTime0(-this.getWaitTime0ForNodeOfs(sourceNodeDataOfs));
        curNode.addSleepTime0(-this.getSleepTime0ForNodeOfs(sourceNodeDataOfs));
    }
}

