/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.results.ProfilingResultsProvider;
import org.netbeans.lib.profiler.results.cpu.CPUDataFrameProcessor;
import org.netbeans.lib.profiler.results.cpu.CPUProfilingResultListener;
import org.netbeans.lib.profiler.results.memory.MemoryDataFrameProcessor;
import org.netbeans.lib.profiler.results.memory.MemoryProfilingResultsListener;

public final class ProfilingResultsDispatcher
implements ProfilingResultsProvider.Dispatcher {
    private static final Logger LOGGER = Logger.getLogger(ProfilingResultsDispatcher.class.getName());
    private static final int QLengthLowerBound = 13;
    private static final int QLengthUpperBound = 15;
    private static ProfilingResultsDispatcher instance;
    private final CPUDataFrameProcessor cpuDataProcessor = new CPUDataFrameProcessor();
    private final MemoryDataFrameProcessor memoryDataProcessor = new MemoryDataFrameProcessor();
    private final Object cpuDataProcessorQLengthLock = new Object();
    private final Object memDataProcessorQLengthLock = new Object();
    private ExecutorService queueProcessor;
    private volatile boolean pauseFlag = true;
    private int cpuDataProcessorQLength = 0;
    private int memDataProcessorQLength = 0;

    public static synchronized ProfilingResultsDispatcher getDefault() {
        if (instance == null) {
            instance = new ProfilingResultsDispatcher();
        }
        return instance;
    }

    public void addListener(CPUProfilingResultListener listener) {
        if (this.cpuDataProcessor != null) {
            this.cpuDataProcessor.addListener(listener);
        }
    }

    public void addListener(MemoryProfilingResultsListener listener) {
        if (this.memoryDataProcessor != null) {
            this.memoryDataProcessor.addListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dataFrameReceived(final byte[] buffer, int instrumentationType) {
        if (!this.cpuDataProcessor.hasListeners() && !this.memoryDataProcessor.hasListeners()) {
            return;
        }
        switch (instrumentationType) {
            case 2: 
            case 3: {
                Object object = this.cpuDataProcessorQLengthLock;
                synchronized (object) {
                    ++this.cpuDataProcessorQLength;
                    if (this.cpuDataProcessorQLength > 15) {
                        try {
                            this.cpuDataProcessorQLengthLock.wait();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    this.getExecutor().submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                ProfilingResultsDispatcher.this.cpuDataProcessor.processDataFrame(buffer);
                            }
                            finally {
                                Object object = ProfilingResultsDispatcher.this.cpuDataProcessorQLengthLock;
                                synchronized (object) {
                                    ProfilingResultsDispatcher.this.cpuDataProcessorQLength--;
                                    if (ProfilingResultsDispatcher.this.cpuDataProcessorQLength < 13) {
                                        ProfilingResultsDispatcher.this.cpuDataProcessorQLengthLock.notifyAll();
                                    }
                                }
                            }
                        }
                    });
                    break;
                }
            }
            case 4: 
            case 5: {
                Object object = this.memDataProcessorQLengthLock;
                synchronized (object) {
                    ++this.memDataProcessorQLength;
                    if (this.memDataProcessorQLength > 15) {
                        try {
                            this.memDataProcessorQLengthLock.wait();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    this.getExecutor().submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                ProfilingResultsDispatcher.this.memoryDataProcessor.processDataFrame(buffer);
                            }
                            finally {
                                Object object = ProfilingResultsDispatcher.this.memDataProcessorQLengthLock;
                                synchronized (object) {
                                    ProfilingResultsDispatcher.this.memDataProcessorQLength--;
                                    if (ProfilingResultsDispatcher.this.memDataProcessorQLength < 13) {
                                        ProfilingResultsDispatcher.this.memDataProcessorQLengthLock.notifyAll();
                                    }
                                }
                            }
                        }
                    });
                    break;
                }
            }
            default: {
                ProfilerLogger.warning("Unknown instrumentation type (" + instrumentationType + ") in dataframe");
            }
        }
    }

    public void pause(boolean flush) {
        this.pauseFlag = true;
    }

    public void removeAllListeners() {
        if (this.cpuDataProcessor != null) {
            this.cpuDataProcessor.removeAllListeners();
        }
        if (this.memoryDataProcessor != null) {
            this.memoryDataProcessor.removeAllListeners();
        }
    }

    public void removeListener(CPUProfilingResultListener listener) {
        if (this.cpuDataProcessor != null) {
            this.cpuDataProcessor.removeListener(listener);
        }
    }

    public void removeListener(MemoryProfilingResultsListener listener) {
        if (this.memoryDataProcessor != null) {
            this.memoryDataProcessor.removeListener(listener);
        }
    }

    public void reset() {
        this.fireReset();
    }

    public void resume() {
        this.pauseFlag = false;
    }

    public synchronized void shutdown() {
        this.fireShutdown();
        this.removeAllListeners();
    }

    public synchronized void startup(ProfilerClient client) {
        this.fireStartup(client);
        this.resume();
    }

    private synchronized ExecutorService getExecutor() {
        if (this.queueProcessor == null) {
            this.queueProcessor = Executors.newSingleThreadExecutor();
        }
        return this.queueProcessor;
    }

    private synchronized void fireReset() {
        this.cpuDataProcessor.reset();
        this.memoryDataProcessor.reset();
    }

    private synchronized void fireShutdown() {
        if (this.cpuDataProcessor != null) {
            this.cpuDataProcessor.shutdown();
        }
        if (this.memoryDataProcessor != null) {
            this.memoryDataProcessor.shutdown();
        }
    }

    private synchronized void fireStartup(ProfilerClient client) {
        this.cpuDataProcessor.startup(client);
        this.memoryDataProcessor.startup(client);
    }
}

