/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.netbeans.lib.profiler.heap.HprofByteBuffer;

class HprofLongMappedByteBuffer
extends HprofByteBuffer {
    private static int BUFFER_SIZE_BITS = 30;
    private static long BUFFER_SIZE = 1L << BUFFER_SIZE_BITS;
    private static int BUFFER_SIZE_MASK = (int)(BUFFER_SIZE - 1L);
    private static int BUFFER_EXT = 32768;
    private MappedByteBuffer[] dumpBuffer;

    HprofLongMappedByteBuffer(File dumpFile) throws IOException {
        FileInputStream fis = new FileInputStream(dumpFile);
        FileChannel channel = fis.getChannel();
        this.length = channel.size();
        this.dumpBuffer = new MappedByteBuffer[(int)((this.length + BUFFER_SIZE - 1L) / BUFFER_SIZE)];
        for (int i = 0; i < this.dumpBuffer.length; ++i) {
            long position = (long)i * BUFFER_SIZE;
            long size = Math.min(BUFFER_SIZE + (long)BUFFER_EXT, this.length - position);
            this.dumpBuffer[i] = channel.map(FileChannel.MapMode.READ_ONLY, position, size);
        }
        channel.close();
        this.readHeader();
    }

    char getChar(long index) {
        return this.dumpBuffer[this.getBufferIndex(index)].getChar(this.getBufferOffset(index));
    }

    double getDouble(long index) {
        return this.dumpBuffer[this.getBufferIndex(index)].getDouble(this.getBufferOffset(index));
    }

    float getFloat(long index) {
        return this.dumpBuffer[this.getBufferIndex(index)].getFloat(this.getBufferOffset(index));
    }

    int getInt(long index) {
        return this.dumpBuffer[this.getBufferIndex(index)].getInt(this.getBufferOffset(index));
    }

    long getLong(long index) {
        return this.dumpBuffer[this.getBufferIndex(index)].getLong(this.getBufferOffset(index));
    }

    short getShort(long index) {
        return this.dumpBuffer[this.getBufferIndex(index)].getShort(this.getBufferOffset(index));
    }

    byte get(long index) {
        return this.dumpBuffer[this.getBufferIndex(index)].get(this.getBufferOffset(index));
    }

    synchronized void get(long position, byte[] chars) {
        MappedByteBuffer buffer = this.dumpBuffer[this.getBufferIndex(position)];
        buffer.position(this.getBufferOffset(position));
        buffer.get(chars);
    }

    private int getBufferIndex(long index) {
        return (int)(index >> BUFFER_SIZE_BITS);
    }

    private int getBufferOffset(long index) {
        return (int)(index & (long)BUFFER_SIZE_MASK);
    }
}

