/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.profiler;

import com.sun.tools.visualvm.core.snapshot.Snapshot;
import com.sun.tools.visualvm.core.snapshot.SnapshotDescriptor;
import com.sun.tools.visualvm.profiler.ProfilerSnapshot;
import java.awt.Image;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfilerSnapshotDescriptor
extends SnapshotDescriptor<ProfilerSnapshot> {
    private static final Logger LOGGER = Logger.getLogger(ProfilerSnapshotDescriptor.class.getName());
    private static final Image CPU_ICON = Utilities.loadImage((String)"org/netbeans/modules/profiler/resources/cpuSmall.png", (boolean)true);
    private static final Image MEMORY_ICON = Utilities.loadImage((String)"org/netbeans/modules/profiler/resources/memorySmall.png", (boolean)true);
    private static final Image NODE_BADGE = Utilities.loadImage((String)"com/sun/tools/visualvm/core/ui/resources/snapshotBadge.png", (boolean)true);

    public ProfilerSnapshotDescriptor(ProfilerSnapshot snapshot) {
        super((Snapshot)snapshot, ProfilerSnapshotDescriptor.resolveIcon(snapshot));
    }

    private static Image resolveIcon(ProfilerSnapshot snapshot) {
        try {
            int snapshotType = snapshot.getLoadedSnapshot().getType();
            if (snapshotType == 1) {
                return Utilities.mergeImages((Image)CPU_ICON, (Image)NODE_BADGE, (int)0, (int)0);
            }
            if (snapshotType == 8 || snapshotType == 4) {
                return Utilities.mergeImages((Image)MEMORY_ICON, (Image)NODE_BADGE, (int)0, (int)0);
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to determine profiler snapshot type", e);
            return null;
        }
    }
}

