/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.ui;

import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.ui.DataSourceCaption;
import com.sun.tools.visualvm.core.ui.DataSourceView;
import com.sun.tools.visualvm.core.ui.components.DataViewComponent;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DataSourceWindowTabbedPane
extends JTabbedPane {
    private Image closeTabImage;
    private Image closeTabPressedImage;
    private Image closeTabMouseOverImage;
    static final String PROP_CLOSE = "close";
    private int pressedCloseButtonIndex = -1;
    private int mouseOverCloseButtonIndex = -1;
    private boolean draggedOut = false;

    DataSourceWindowTabbedPane() {
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                DataSourceWindowTabbedPane.this.reset();
            }
        });
        CloseButtonListener.install();
        this.setFocusable(false);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new CBTPPolicy());
    }

    private Component sel() {
        Component c = this.getSelectedComponent();
        return c == null ? this : c;
    }

    public void addViewTab(DataSource dataSource, DataSourceView view) {
        ViewContainer container = new ViewContainer(new DataSourceCaption<DataSource>(dataSource), view);
        super.add(container);
        boolean notGTK = !UIUtils.isGTKLookAndFeel();
        this.setTitleAt(this.getComponentCount() - 1, view.getName() + (view.isClosable() && notGTK ? "  " : ""));
        ImageIcon tabIcon = notGTK ? new ImageIcon(view.getImage()) : new ImageIcon(view.getImage()){

            public int getIconWidth() {
                return super.getIconWidth() + 12;
            }
        };
        super.setIconAt(this.getComponentCount() - 1, tabIcon);
    }

    @Override
    public void removeTabAt(int index) {
        ViewContainer container = (ViewContainer)this.getComponentAt(index);
        super.removeTabAt(index);
        container.getCaption().finish();
    }

    public DataSourceView getDataSourceView(ViewContainer container) {
        return container.getView();
    }

    public int indexOfView(final DataSourceView view) {
        final int[] index = new int[]{-1};
        IDEUtils.runInEventDispatchThreadAndWait((Runnable)new Runnable(){

            public void run() {
                for (int i = 0; i < DataSourceWindowTabbedPane.this.getTabCount(); ++i) {
                    if (((ViewContainer)DataSourceWindowTabbedPane.this.getComponentAt(i)).getViewComponent() != view.getView()) continue;
                    index[0] = i;
                }
            }
        });
        return index[0];
    }

    public Set<DataSourceView> getViews() {
        HashSet<DataSourceView> views = new HashSet<DataSourceView>();
        for (Component component : this.getComponents()) {
            ViewContainer container = (ViewContainer)component;
            views.add(container.getView());
        }
        return views;
    }

    @Override
    public void addTab(String title, Component component) {
        if (!(component instanceof ViewContainer)) {
            throw new RuntimeException("Not supported for this component");
        }
        super.addTab(title, component);
    }

    @Override
    public Component add(Component component) {
        throw new RuntimeException("Not supported for this component");
    }

    @Override
    public Component add(Component component, int index) {
        throw new RuntimeException("Not supported for this component");
    }

    @Override
    public void add(Component component, Object constraints) {
        throw new RuntimeException("Not supported for this component");
    }

    @Override
    public void add(Component component, Object constraints, int index) {
        throw new RuntimeException("Not supported for this component");
    }

    @Override
    public Component add(String title, Component component) {
        throw new RuntimeException("Not supported for this component");
    }

    @Override
    public void addTab(String title, Icon icon, Component component) {
        throw new RuntimeException("Not supported for this component");
    }

    @Override
    public void addTab(String title, Icon icon, Component component, String tip) {
        throw new RuntimeException("Not supported for this component");
    }

    @Override
    public void setTitleAt(int idx, String title) {
        ViewContainer container = (ViewContainer)this.getComponentAt(idx);
        if (container.getView().isClosable()) {
            String nue;
            String string = nue = title.indexOf("</html>") != -1 ? Utilities.replaceString((String)title, (String)"</html>", (String)"&nbsp;&nbsp;</html>") : title + "  ";
            if (!title.equals(this.getTitleAt(idx))) {
                super.setTitleAt(idx, nue);
            }
        } else {
            super.setTitleAt(idx, title);
        }
    }

    private void reset() {
        this.setMouseOverCloseButtonIndex(-1);
        this.setPressedCloseButtonIndex(-1);
        this.draggedOut = false;
    }

    private Rectangle getCloseButtonBoundsAt(int i) {
        Rectangle b = this.getBoundsAt(i);
        if (b == null) {
            return null;
        }
        ViewContainer container = (ViewContainer)this.getComponentAt(i);
        if (!container.getView().isClosable()) {
            return null;
        }
        b = new Rectangle(b);
        DataSourceWindowTabbedPane.fixGetBoundsAt(b);
        Dimension tabsz = this.getSize();
        if (b.x + b.width >= tabsz.width || b.y + b.height >= tabsz.height) {
            return null;
        }
        if (b.width == 0 || b.height == 0) {
            return null;
        }
        if ((this.isWindowsVistaLaF() || this.isWindowsXPLaF() || this.isWindowsLaF()) && i == this.getSelectedIndex()) {
            b.x -= 3;
            b.y -= 2;
        } else if (this.isWindowsXPLaF() || this.isWindowsLaF() || this.isAquaLaF()) {
            b.x -= 2;
        }
        if (i == this.getTabCount() - 1) {
            if (this.isMetalLaF()) {
                --b.x;
            } else if (this.isAquaLaF()) {
                b.x -= 3;
            }
        }
        return new Rectangle(b.x + b.width - (UIUtils.isGTKLookAndFeel() ? 14 : 13), b.y + b.height / 2 - 5, 12, 12);
    }

    private boolean isWindowsVistaLaF() {
        String osName = System.getProperty("os.name");
        return osName.indexOf("Vista") >= 0 || osName.equals("Windows NT (unknown)") && "6.0".equals(System.getProperty("os.version"));
    }

    private boolean isWindowsXPLaF() {
        Boolean isXP = (Boolean)Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive");
        return this.isWindowsLaF() && isXP != null && isXP != false;
    }

    private boolean isWindowsLaF() {
        String lfID = UIManager.getLookAndFeel().getID();
        return lfID.endsWith("Windows");
    }

    private boolean isAquaLaF() {
        return "Aqua".equals(UIManager.getLookAndFeel().getID());
    }

    private boolean isMetalLaF() {
        String lfID = UIManager.getLookAndFeel().getID();
        return "Metal".equals(lfID);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        int n = this.getTabCount();
        for (int i = 0; i < n; ++i) {
            Rectangle r = this.getCloseButtonBoundsAt(i);
            if (r == null) continue;
            if (i == this.mouseOverCloseButtonIndex || i == this.pressedCloseButtonIndex && this.draggedOut) {
                g.drawImage(this.getCloseTabMouseOverImage(), r.x, r.y, this);
                continue;
            }
            if (i == this.pressedCloseButtonIndex) {
                g.drawImage(this.getCloseTabPressedImage(), r.x, r.y, this);
                continue;
            }
            g.drawImage(this.getCloseTabImage(), r.x, r.y, this);
        }
    }

    private Image getCloseTabImage() {
        if (null == this.closeTabImage) {
            this.closeTabImage = this.isWindowsVistaLaF() ? Utilities.loadImage((String)"org/openide/awt/resources/vista_close_enabled.png") : (this.isWindowsXPLaF() ? Utilities.loadImage((String)"org/openide/awt/resources/xp_close_enabled.png") : (this.isWindowsLaF() ? Utilities.loadImage((String)"org/openide/awt/resources/win_close_enabled.png") : (this.isAquaLaF() ? Utilities.loadImage((String)"org/openide/awt/resources/mac_close_enabled.png") : Utilities.loadImage((String)"org/openide/awt/resources/metal_close_enabled.png"))));
        }
        return this.closeTabImage;
    }

    private Image getCloseTabPressedImage() {
        if (null == this.closeTabPressedImage) {
            this.closeTabPressedImage = this.isWindowsVistaLaF() ? Utilities.loadImage((String)"org/openide/awt/resources/vista_close_pressed.png") : (this.isWindowsXPLaF() ? Utilities.loadImage((String)"org/openide/awt/resources/xp_close_pressed.png") : (this.isWindowsLaF() ? Utilities.loadImage((String)"org/openide/awt/resources/win_close_pressed.png") : (this.isAquaLaF() ? Utilities.loadImage((String)"org/openide/awt/resources/mac_close_pressed.png") : Utilities.loadImage((String)"org/openide/awt/resources/metal_close_pressed.png"))));
        }
        return this.closeTabPressedImage;
    }

    private Image getCloseTabMouseOverImage() {
        if (null == this.closeTabMouseOverImage) {
            this.closeTabMouseOverImage = this.isWindowsVistaLaF() ? Utilities.loadImage((String)"org/openide/awt/resources/vista_close_rollover.png") : (this.isWindowsXPLaF() ? Utilities.loadImage((String)"org/openide/awt/resources/xp_close_rollover.png") : (this.isWindowsLaF() ? Utilities.loadImage((String)"org/openide/awt/resources/win_close_rollover.png") : (this.isAquaLaF() ? Utilities.loadImage((String)"org/openide/awt/resources/mac_close_rollover.png") : Utilities.loadImage((String)"org/openide/awt/resources/metal_close_rollover.png"))));
        }
        return this.closeTabMouseOverImage;
    }

    private void setPressedCloseButtonIndex(int index) {
        Rectangle r;
        if (this.pressedCloseButtonIndex == index) {
            return;
        }
        if (this.pressedCloseButtonIndex >= 0 && this.pressedCloseButtonIndex < this.getTabCount()) {
            JComponent c;
            r = this.getCloseButtonBoundsAt(this.pressedCloseButtonIndex);
            if (r != null) {
                this.repaint(r.x, r.y, r.width + 2, r.height + 2);
            }
            if ((c = this._getJComponentAt(this.pressedCloseButtonIndex)) != null) {
                this.setToolTipTextAt(this.pressedCloseButtonIndex, c.getToolTipText());
            }
        }
        this.pressedCloseButtonIndex = index;
        if (this.pressedCloseButtonIndex >= 0 && this.pressedCloseButtonIndex < this.getTabCount()) {
            r = this.getCloseButtonBoundsAt(this.pressedCloseButtonIndex);
            if (r != null) {
                this.repaint(r.x, r.y, r.width + 2, r.height + 2);
            }
            this.setMouseOverCloseButtonIndex(-1);
            this.setToolTipTextAt(this.pressedCloseButtonIndex, null);
        }
    }

    private void setMouseOverCloseButtonIndex(int index) {
        Rectangle r;
        if (this.mouseOverCloseButtonIndex == index) {
            return;
        }
        if (this.mouseOverCloseButtonIndex >= 0 && this.mouseOverCloseButtonIndex < this.getTabCount()) {
            JComponent c;
            r = this.getCloseButtonBoundsAt(this.mouseOverCloseButtonIndex);
            if (r != null) {
                this.repaint(r.x, r.y, r.width + 2, r.height + 2);
            }
            if ((c = this._getJComponentAt(this.mouseOverCloseButtonIndex)) != null) {
                this.setToolTipTextAt(this.mouseOverCloseButtonIndex, c.getToolTipText());
            }
        }
        this.mouseOverCloseButtonIndex = index;
        if (this.mouseOverCloseButtonIndex >= 0 && this.mouseOverCloseButtonIndex < this.getTabCount()) {
            r = this.getCloseButtonBoundsAt(this.mouseOverCloseButtonIndex);
            if (r != null) {
                this.repaint(r.x, r.y, r.width + 2, r.height + 2);
            }
            this.setPressedCloseButtonIndex(-1);
            this.setToolTipTextAt(this.mouseOverCloseButtonIndex, null);
        }
    }

    private JComponent _getJComponentAt(int tabIndex) {
        Component c = this.getComponentAt(tabIndex);
        return c instanceof JComponent ? (JComponent)c : null;
    }

    private void fireCloseRequest(Component c) {
        this.firePropertyChange(PROP_CLOSE, null, c);
    }

    static void fixGetBoundsAt(Rectangle b) {
        if (b.y < 0) {
            b.y = -b.y;
        }
        if (b.x < 0) {
            b.x = -b.x;
        }
    }

    static int findTabForCoordinate(JTabbedPane tab, int x, int y) {
        for (int i = 0; i < tab.getTabCount(); ++i) {
            Rectangle b = tab.getBoundsAt(i);
            if (b == null) continue;
            b = new Rectangle(b);
            DataSourceWindowTabbedPane.fixGetBoundsAt(b);
            if (!b.contains(x, y)) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected void processMouseEvent(MouseEvent me) {
        try {
            super.processMouseEvent(me);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            Exceptions.attachLocalizedMessage((Throwable)aioobe, (String)"Suppressed AIOOBE bug in BasicTabbedPaneUI");
            Logger.getAnonymousLogger().log(Level.WARNING, null, aioobe);
        }
    }

    @Override
    protected void fireStateChanged() {
        block2: {
            try {
                super.fireStateChanged();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                if (Utilities.isMac()) break block2;
                throw e;
            }
        }
    }

    static class ViewContainer
    extends JPanel {
        private DataSourceCaption caption;
        private DataSourceView view;
        private DataViewComponent viewComponent;

        public ViewContainer(DataSourceCaption caption, DataSourceView view) {
            this.caption = caption;
            this.view = view;
            this.viewComponent = view.getView();
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createMatteBorder(5, 5, 5, 5, Color.WHITE));
            this.setBackground(Color.WHITE);
            this.add((Component)this.viewComponent, "Center");
            if (caption != null) {
                caption.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
                caption.setBackground(Color.WHITE);
                this.add((Component)caption, "North");
            }
        }

        public DataSourceCaption getCaption() {
            return this.caption;
        }

        public DataSourceView getView() {
            return this.view;
        }

        public DataViewComponent getViewComponent() {
            return this.viewComponent;
        }
    }

    private static class CloseButtonListener
    implements AWTEventListener {
        private static boolean installed = false;

        private CloseButtonListener() {
        }

        private static synchronized void install() {
            if (installed) {
                return;
            }
            installed = true;
            Toolkit.getDefaultToolkit().addAWTEventListener(new CloseButtonListener(), 48L);
        }

        public void eventDispatched(AWTEvent ev) {
            Component c;
            MouseEvent e = (MouseEvent)ev;
            if (!(ev.getSource() instanceof Component)) {
                return;
            }
            for (c = (Component)e.getSource(); c != null && !(c instanceof DataSourceWindowTabbedPane); c = c.getParent()) {
            }
            if (c == null) {
                return;
            }
            DataSourceWindowTabbedPane tab = (DataSourceWindowTabbedPane)c;
            Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), tab);
            if (e.getID() == 500) {
                return;
            }
            int index = DataSourceWindowTabbedPane.findTabForCoordinate(tab, p.x, p.y);
            Rectangle r = null;
            if (index >= 0) {
                r = tab.getCloseButtonBoundsAt(index);
            }
            if (r == null) {
                r = new Rectangle(0, 0, 0, 0);
            }
            switch (e.getID()) {
                case 501: {
                    if (!r.contains(p)) break;
                    tab.setPressedCloseButtonIndex(index);
                    tab.draggedOut = false;
                    e.consume();
                    return;
                }
                case 502: {
                    if (r.contains(p) && tab.pressedCloseButtonIndex >= 0) {
                        Component tc = tab.getComponentAt(tab.pressedCloseButtonIndex);
                        tab.reset();
                        tab.fireCloseRequest(tc);
                        e.consume();
                        return;
                    }
                    tab.reset();
                    break;
                }
                case 504: {
                    break;
                }
                case 505: {
                    break;
                }
                case 503: {
                    if (r.contains(p)) {
                        tab.setMouseOverCloseButtonIndex(index);
                        tab.draggedOut = false;
                        e.consume();
                        return;
                    }
                    if (tab.mouseOverCloseButtonIndex < 0) break;
                    tab.setMouseOverCloseButtonIndex(-1);
                    tab.draggedOut = false;
                    e.consume();
                    break;
                }
                case 506: {
                    if (tab.pressedCloseButtonIndex < 0) break;
                    if (tab.draggedOut != !r.contains(p)) {
                        tab.draggedOut = !r.contains(p);
                        tab.repaint(r.x, r.y, r.width + 2 + 6, r.height + 2 + 6);
                    }
                    e.consume();
                    return;
                }
            }
        }
    }

    private class CBTPPolicy
    extends FocusTraversalPolicy {
        private CBTPPolicy() {
        }

        public Component getComponentAfter(Container aContainer, Component aComponent) {
            return DataSourceWindowTabbedPane.this.sel();
        }

        public Component getComponentBefore(Container aContainer, Component aComponent) {
            return DataSourceWindowTabbedPane.this.sel();
        }

        public Component getFirstComponent(Container aContainer) {
            return DataSourceWindowTabbedPane.this.sel();
        }

        public Component getLastComponent(Container aContainer) {
            return DataSourceWindowTabbedPane.this.sel();
        }

        public Component getDefaultComponent(Container aContainer) {
            return DataSourceWindowTabbedPane.this.sel();
        }
    }
}

