/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.ui;

import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasupport.Positionable;
import com.sun.tools.visualvm.core.ui.DataSourceViewProvider;
import com.sun.tools.visualvm.core.ui.components.DataViewComponent;
import java.awt.Image;

public abstract class DataSourceView
implements Positionable {
    private DataSource dataSource;
    private String name;
    private Image icon;
    private int preferredPosition;
    private boolean isClosable;
    private DataViewComponent component;
    private DataSourceViewProvider controller;

    public DataSourceView(DataSource dataSource, String name, Image icon, int preferredPosition, boolean isClosable) {
        if (dataSource == null) {
            throw new IllegalArgumentException("DataSource cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (icon == null) {
            throw new IllegalArgumentException("Icon cannot be null");
        }
        this.dataSource = dataSource;
        this.name = name;
        this.icon = icon;
        this.preferredPosition = preferredPosition;
        this.isClosable = isClosable;
    }

    public final DataSource getDataSource() {
        return this.dataSource;
    }

    public final String getName() {
        return this.name;
    }

    public final Image getImage() {
        return this.icon;
    }

    protected abstract DataViewComponent createComponent();

    public final int getPreferredPosition() {
        return this.preferredPosition;
    }

    public final boolean isClosable() {
        return this.isClosable;
    }

    protected void willBeAdded() {
    }

    protected void added() {
    }

    protected void removed() {
    }

    DataViewComponent getView() {
        if (this.component == null) {
            this.component = this.createComponent();
            if (this.component == null) {
                throw new NullPointerException("Null view component from " + this);
            }
            this.controller.processCreatedComponent(this, this.component);
        }
        return this.component;
    }

    void viewWillBeAdded() {
        this.willBeAdded();
        this.controller.viewWillBeAdded(this);
    }

    void viewAdded() {
        this.added();
        this.controller.viewAdded(this);
    }

    void viewRemoved() {
        this.removed();
        this.controller.viewRemoved(this);
    }

    void setController(DataSourceViewProvider controller) {
        this.controller = controller;
    }
}

