/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.explorer;

import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasource.DataSourceRepository;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptor;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import com.sun.tools.visualvm.core.datasupport.DataChangeEvent;
import com.sun.tools.visualvm.core.datasupport.DataChangeListener;
import com.sun.tools.visualvm.core.datasupport.Utils;
import com.sun.tools.visualvm.core.explorer.ExplorerNode;
import com.sun.tools.visualvm.core.explorer.ExplorerSupport;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExplorerModelBuilder
implements DataChangeListener<DataSource> {
    private static final RequestProcessor queue = new RequestProcessor("Explorer Builder Processor");
    private static ExplorerModelBuilder instance;
    private final ExplorerNode explorerRoot;
    private final DefaultTreeModel explorerModel;
    private final Map<DataSource, ExplorerNode> nodes;
    private final Map<DataSource, PropertyChangeListener> visibilityListeners = new HashMap<DataSource, PropertyChangeListener>();
    private final Map<DataSourceDescriptor, PropertyChangeListener> descriptorListeners = new HashMap<DataSourceDescriptor, PropertyChangeListener>();

    public static synchronized ExplorerModelBuilder getInstance() {
        if (instance == null) {
            instance = new ExplorerModelBuilder();
        }
        return instance;
    }

    DefaultTreeModel getModel() {
        return this.explorerModel;
    }

    ExplorerNode getNodeFor(DataSource dataSource) {
        return this.nodes.get(dataSource);
    }

    @Override
    public void dataChanged(final DataChangeEvent event) {
        queue.post(new Runnable(){

            public void run() {
                Set removed = event.getRemoved();
                Set added = event.getAdded();
                if (!removed.isEmpty()) {
                    ExplorerModelBuilder.this.processRemovedDataSources(removed);
                }
                if (!added.isEmpty()) {
                    ExplorerModelBuilder.this.processAddedDataSources(added);
                }
            }
        });
    }

    private void processAddedDataSources(Set<DataSource> added) {
        for (DataSource dataSource : added) {
            this.installVisibilityListener(dataSource);
        }
        this.processIndependentAddedDataSources(Utils.getIndependentDataSources(added));
    }

    private void processIndependentAddedDataSources(Set<DataSource> added) {
        HashSet<DataSource> addedDisplayable = new HashSet<DataSource>();
        for (DataSource dataSource : added) {
            if (this.isDisplayed(dataSource) && dataSource != DataSource.ROOT) {
                return;
            }
            if (!this.isDisplayable(dataSource)) continue;
            addedDisplayable.add(dataSource);
        }
        if (!addedDisplayable.isEmpty()) {
            this.processAddedDisplayableDataSources(addedDisplayable);
        }
    }

    private void processRemovedDataSources(Set<DataSource> removed) {
        for (DataSource dataSource : removed) {
            this.uninstallVisibilityListener(dataSource);
        }
        this.processIndependentRemovedDataSources(Utils.getIndependentDataSources(removed));
    }

    private void processIndependentRemovedDataSources(Set<DataSource> removed) {
        HashSet<DataSource> removedDisplayed = new HashSet<DataSource>();
        for (DataSource dataSource : removed) {
            if (!this.isDisplayed(dataSource)) continue;
            removedDisplayed.add(dataSource);
        }
        if (!removedDisplayed.isEmpty()) {
            this.processRemovedDisplayedDataSources(removedDisplayed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAddedDisplayableDataSources(Set<DataSource> addedDisplayable) {
        final HashSet<ExplorerNode> addedNodes = new HashSet<ExplorerNode>();
        final ProgressHandle[] pHandle = new ProgressHandle[1];
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                pHandle[0] = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ExplorerModelBuilder.class, (String)"LBL_Computing_description"));
                pHandle[0].setInitialDelay(5000);
                pHandle[0].start();
            }
        });
        try {
            for (DataSource dataSource : addedDisplayable) {
                if (dataSource == DataSource.ROOT) continue;
                final ExplorerNode node = new ExplorerNode(dataSource);
                addedNodes.add(node);
                DataSourceDescriptor descriptor = DataSourceDescriptorFactory.getDescriptor(dataSource);
                PropertyChangeListener descriptorListener = new PropertyChangeListener(){

                    public void propertyChange(final PropertyChangeEvent evt) {
                        queue.post(new Runnable(){

                            public void run() {
                                ExplorerModelBuilder.this.updateNode(node, evt);
                            }
                        });
                    }
                };
                descriptor.addPropertyChangeListener(descriptorListener);
                this.descriptorListeners.put(descriptor, descriptorListener);
                this.updateNode(node, descriptor);
            }
        }
        catch (Throwable throwable) {
            SwingUtilities.invokeLater(new Runnable(pHandle){
                final /* synthetic */ ProgressHandle[] val$pHandle;
                {
                    this.val$pHandle = progressHandleArray;
                }

                public void run() {
                    this.val$pHandle[0].finish();
                }
            });
            throw throwable;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    ExplorerModelBuilder.this.addNodes(addedNodes);
                }
            });
        }
        catch (Exception e) {
            // empty catch block
        }
        HashSet<DataSource> addedChildren = new HashSet<DataSource>();
        for (DataSource dataSource : addedDisplayable) {
            addedChildren.addAll(dataSource.getRepository().getDataSources());
        }
        if (!addedChildren.isEmpty()) {
            this.processIndependentAddedDataSources(addedChildren);
        }
    }

    private void processRemovedDisplayedDataSources(Set<DataSource> removedDisplayed) {
        HashSet<DataSource> removedChildren = new HashSet<DataSource>();
        for (DataSource dataSource : removedDisplayed) {
            removedChildren.addAll(dataSource.getRepository().getDataSources());
        }
        if (!removedChildren.isEmpty()) {
            this.processIndependentRemovedDataSources(removedChildren);
        }
        final HashSet<ExplorerNode> removedNodes = new HashSet<ExplorerNode>();
        for (DataSource dataSource : removedDisplayed) {
            DataSourceDescriptor descriptor = DataSourceDescriptorFactory.getDescriptor(dataSource);
            PropertyChangeListener descriptorListener = this.descriptorListeners.get(descriptor);
            descriptor.removePropertyChangeListener(descriptorListener);
            this.descriptorListeners.remove(descriptor);
            ExplorerNode node = this.nodes.get(dataSource);
            removedNodes.add(node);
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    ExplorerModelBuilder.this.removeNodes(removedNodes);
                }
            });
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void updateNode(ExplorerNode node, DataSourceDescriptor descriptor) {
        node.setName(descriptor.getName());
        node.setIcon(descriptor.getIcon() == null ? null : new ImageIcon(descriptor.getIcon()));
        node.setPreferredPosition(descriptor.getPreferredPosition());
        node.setAutoExpansionPolicy(descriptor.getAutoExpansionPolicy());
    }

    private void updateNode(final ExplorerNode node, PropertyChangeEvent evt) {
        String property = evt.getPropertyName();
        Object newValue = evt.getNewValue();
        if ("prop_name".equals(property)) {
            String name = (String)newValue;
            node.setName(name);
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        ExplorerModelBuilder.this.explorerModel.nodeChanged(node);
                    }
                });
            }
            catch (Exception e) {}
        } else if ("prop_icon".equals(property)) {
            Image icon = (Image)newValue;
            node.setIcon(icon == null ? null : new ImageIcon(icon));
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        ExplorerModelBuilder.this.explorerModel.nodeChanged(node);
                    }
                });
            }
            catch (Exception e) {}
        } else if ("prop_preferred_position".equals(property)) {
            Integer preferredPosition = (Integer)newValue;
            node.setPreferredPosition(preferredPosition);
            final ExplorerNode parent = (ExplorerNode)node.getParent();
            if (parent != null) {
                parent.addNode(node);
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            ExplorerModelBuilder.this.explorerModel.nodesWereInserted(parent, new int[]{parent.getIndex(node)});
                        }
                    });
                }
                catch (Exception e) {}
            }
        } else if ("prop_expansion_policy".equals(property)) {
            node.setAutoExpansionPolicy((Integer)evt.getNewValue());
        }
    }

    private void addNodes(Set<ExplorerNode> added) {
        HashMap indexes = new HashMap();
        Set<DataSource> selectedDataSources = ExplorerSupport.sharedInstance().getSelectedDataSources();
        for (ExplorerNode explorerNode : added) {
            DataSource dataSource = explorerNode.getUserObject();
            ExplorerNode nodeParent = this.getNodeFor(dataSource.getOwner());
            this.nodes.put(dataSource, explorerNode);
            nodeParent.addNode(explorerNode);
            indexes.put(nodeParent, new ArrayList());
        }
        for (ExplorerNode explorerNode : added) {
            ExplorerNode nodeParent = (ExplorerNode)explorerNode.getParent();
            ((List)indexes.get(nodeParent)).add(nodeParent.getIndex(explorerNode));
        }
        for (Map.Entry entry : indexes.entrySet()) {
            List indexesList = (List)entry.getValue();
            Collections.sort(indexesList);
            int[] indexesArr = new int[indexesList.size()];
            for (int i = 0; i < indexesArr.length; ++i) {
                indexesArr[i] = (Integer)indexesList.get(i);
            }
            this.explorerModel.nodesWereInserted((TreeNode)entry.getKey(), indexesArr);
        }
        ExplorerSupport.sharedInstance().selectDataSources(selectedDataSources);
    }

    private void removeNodes(Set<ExplorerNode> removed) {
        HashMap<ExplorerNode, ArrayList<IndexNodePair>> pairs = new HashMap<ExplorerNode, ArrayList<IndexNodePair>>();
        Set<DataSource> selectedDataSources = ExplorerSupport.sharedInstance().getSelectedDataSources();
        for (ExplorerNode explorerNode : removed) {
            ExplorerNode nodeParent = (ExplorerNode)explorerNode.getParent();
            ArrayList<IndexNodePair> list = (ArrayList<IndexNodePair>)pairs.get(nodeParent);
            if (list == null) {
                list = new ArrayList<IndexNodePair>();
                pairs.put(nodeParent, list);
            }
            list.add(new IndexNodePair(nodeParent.getIndex(explorerNode), explorerNode));
        }
        for (ExplorerNode explorerNode : removed) {
            explorerNode.removeFromParent();
            this.nodes.remove(explorerNode.getUserObject());
        }
        for (Map.Entry entry : pairs.entrySet()) {
            List indexesList = (List)entry.getValue();
            Collections.sort(indexesList);
            int[] indexesArr = new int[indexesList.size()];
            Object[] childsArr = new Object[indexesList.size()];
            for (int i = 0; i < indexesArr.length; ++i) {
                IndexNodePair pair = (IndexNodePair)indexesList.get(i);
                indexesArr[i] = pair.index;
                childsArr[i] = pair.node;
            }
            this.explorerModel.nodesWereRemoved((TreeNode)entry.getKey(), indexesArr, childsArr);
        }
        ExplorerSupport.sharedInstance().selectDataSources(selectedDataSources);
    }

    private void installVisibilityListener(final DataSource dataSource) {
        PropertyChangeListener visibilityListener = new PropertyChangeListener(){

            public void propertyChange(final PropertyChangeEvent evt) {
                queue.post(new Runnable(){

                    public void run() {
                        if (((Boolean)evt.getNewValue()).booleanValue()) {
                            if (ExplorerModelBuilder.this.isDisplayed(dataSource.getOwner()) && !ExplorerModelBuilder.this.isDisplayed(dataSource)) {
                                ExplorerModelBuilder.this.processAddedDisplayableDataSources(Collections.singleton(dataSource));
                            }
                        } else if (ExplorerModelBuilder.this.isDisplayed(dataSource)) {
                            ExplorerModelBuilder.this.processRemovedDisplayedDataSources(Collections.singleton(dataSource));
                        }
                    }
                });
            }
        };
        dataSource.addPropertyChangeListener("prop_visible", visibilityListener);
        this.visibilityListeners.put(dataSource, visibilityListener);
    }

    private void uninstallVisibilityListener(DataSource dataSource) {
        PropertyChangeListener visibilityListener = this.visibilityListeners.get(dataSource);
        dataSource.removePropertyChangeListener("prop_visible", visibilityListener);
        this.visibilityListeners.remove(dataSource);
    }

    private boolean isDisplayed(DataSource dataSource) {
        return this.nodes.get(dataSource) != null;
    }

    private boolean isDisplayable(DataSource dataSource) {
        if (dataSource == DataSource.ROOT) {
            return true;
        }
        return dataSource.isVisible() && this.isDisplayed(dataSource.getOwner());
    }

    private ExplorerModelBuilder() {
        this.explorerRoot = new ExplorerNode(DataSource.ROOT);
        this.explorerRoot.setAutoExpansionPolicy(2);
        this.explorerModel = new DefaultTreeModel(this.explorerRoot);
        this.nodes = new HashMap<DataSource, ExplorerNode>();
        this.nodes.put(DataSource.ROOT, this.explorerRoot);
        DataSourceRepository.sharedInstance().addDataChangeListener(this, DataSource.class);
    }

    private static class IndexNodePair
    implements Comparable {
        public int index;
        public ExplorerNode node;

        public IndexNodePair(int index, ExplorerNode node) {
            this.index = index;
            this.node = node;
        }

        public int compareTo(Object o) {
            IndexNodePair pair = (IndexNodePair)o;
            if (this.index == pair.index) {
                return 0;
            }
            if (this.index > pair.index) {
                return 1;
            }
            return -1;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IndexNodePair other = (IndexNodePair)obj;
            return this.index == other.index;
        }

        public int hashCode() {
            int hash = 7;
            hash = 37 * hash + this.index;
            return hash;
        }
    }
}

