/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.IOException;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.SQLExceptionFactory;

public abstract class Util {
    private static SQLExceptionFactory exceptionFactory = new SQLExceptionFactory();

    private static SQLException newEmbedSQLException(String string, Object[] objectArray, SQLException sQLException, int n, Throwable throwable) {
        String string2 = MessageService.getCompleteMessage(string, objectArray);
        return exceptionFactory.getSQLException(string2, string, sQLException, n, throwable, objectArray);
    }

    public static SQLException newEmbedSQLException(String string, Object[] objectArray, int n) {
        return Util.newEmbedSQLException(string, objectArray, null, n, null);
    }

    private static SQLException newEmbedSQLException(String string, Object[] objectArray, int n, Throwable throwable) {
        return Util.newEmbedSQLException(string, objectArray, null, n, throwable);
    }

    private static SQLException newEmbedSQLException(String string, int n) {
        return Util.newEmbedSQLException(string, null, null, n, null);
    }

    public static void ASSERT(EmbedConnection embedConnection, boolean bl, String string) throws SQLException {
    }

    static void THROWASSERT(EmbedConnection embedConnection, String string) throws SQLException {
    }

    static SQLException newException(String string, Object object, Object object2, Object object3) {
        return Util.newEmbedSQLException(string, new Object[]{object, object2, object3}, StandardException.getSeverityFromIdentifier(string));
    }

    public static SQLException generateCsSQLException(String string) {
        return Util.newEmbedSQLException(string, StandardException.getSeverityFromIdentifier(string));
    }

    public static SQLException generateCsSQLException(String string, Object object) {
        return Util.newEmbedSQLException(string, new Object[]{object}, StandardException.getSeverityFromIdentifier(string));
    }

    public static SQLException generateCsSQLException(String string, Object object, Object object2) {
        return Util.newEmbedSQLException(string, new Object[]{object, object2}, StandardException.getSeverityFromIdentifier(string));
    }

    public static SQLException generateCsSQLException(String string, Object object, Object object2, Object object3) {
        return Util.newEmbedSQLException(string, new Object[]{object, object2, object3}, StandardException.getSeverityFromIdentifier(string));
    }

    static SQLException generateCsSQLException(String string, Object object, Throwable throwable) {
        return Util.newEmbedSQLException(string, new Object[]{object}, StandardException.getSeverityFromIdentifier(string), throwable);
    }

    public static SQLException generateCsSQLException(StandardException standardException) {
        return exceptionFactory.getSQLException(standardException.getMessage(), standardException.getMessageId(), null, standardException.getSeverity(), standardException, standardException.getArguments());
    }

    public static SQLException noCurrentConnection() {
        return Util.newEmbedSQLException("08003", StandardException.getSeverityFromIdentifier("08003"));
    }

    static SQLException seeNextException(String string, Object[] objectArray, SQLException sQLException) {
        return Util.newEmbedSQLException(string, objectArray, sQLException, StandardException.getSeverityFromIdentifier(string), null);
    }

    public static SQLException javaException(Throwable throwable) {
        String string = throwable.getMessage();
        if (string == null) {
            string = "";
        }
        String string2 = throwable.getClass().getName();
        SQLException sQLException = null;
        Throwable throwable2 = throwable.getCause();
        if (throwable2 != null) {
            sQLException = throwable2 instanceof SQLException ? (SQLException)throwable2 : (throwable2 instanceof StandardException ? Util.generateCsSQLException((StandardException)throwable2) : Util.javaException(throwable2));
        }
        return Util.newEmbedSQLException("XJ001.U", new Object[]{string2, string}, sQLException, 0, throwable);
    }

    public static SQLException policyNotReloaded(Throwable throwable) {
        return Util.newEmbedSQLException("XK000.S", new Object[]{throwable.getMessage()}, StandardException.getSeverityFromIdentifier("XK000.S"), throwable);
    }

    public static SQLException notImplemented() {
        return Util.notImplemented(MessageService.getTextMessage("J008"));
    }

    public static SQLException notImplemented(String string) {
        return Util.newEmbedSQLException("0A000.S", new Object[]{string}, StandardException.getSeverityFromIdentifier("0A000.S"));
    }

    static SQLException setStreamFailure(IOException iOException) {
        String string = iOException.getMessage();
        if (string == null) {
            string = iOException.getClass().getName();
        }
        return Util.newEmbedSQLException("XJ022.S", new Object[]{string}, StandardException.getSeverityFromIdentifier("XJ022.S"));
    }

    static SQLException typeMisMatch(int n) {
        return Util.newEmbedSQLException("XJ020.S", new Object[]{Util.typeName(n)}, StandardException.getSeverityFromIdentifier("XJ020.S"));
    }

    public static void setExceptionFactory(SQLExceptionFactory sQLExceptionFactory) {
        exceptionFactory = sQLExceptionFactory;
    }

    public static SQLExceptionFactory getExceptionFactory() {
        return exceptionFactory;
    }

    public static String typeName(int n) {
        switch (n) {
            case 2003: {
                return "ARRAY";
            }
            case -7: {
                return "CHAR () FOR BIT DATA";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 70: {
                return "DATALINK";
            }
            case -6: {
                return "TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case 6: {
                return "FLOAT";
            }
            case 7: {
                return "REAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 2: {
                return "NUMERIC";
            }
            case 3: {
                return "DECIMAL";
            }
            case 1: {
                return "CHAR";
            }
            case 12: {
                return "VARCHAR";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -2: {
                return "BINARY";
            }
            case -3: {
                return "VARBINARY";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case 2004: {
                return "BLOB";
            }
            case 1111: {
                return "OTHER";
            }
            case 2000: {
                return "Types.JAVA_OBJECT";
            }
            case 2006: {
                return "REF";
            }
            case -8: {
                return "ROWID";
            }
            case 2002: {
                return "STRUCT";
            }
            case 456: {
                return "XML";
            }
            case 2009: {
                return "SQLXML";
            }
        }
        return String.valueOf(n);
    }
}

