Name: brltty
Version: 3.9
Release: 1

Group: System Environment/Daemons
License: GPL
Vendor: The BRLTTY Team
Packager: Dave Mielke <dave@mielke.cc>
URL: http://mielke.cc/brltty/
Source: http://mielke.cc/brltty/releases/%{name}-%{version}.tar.gz

BuildRequires: autoconf >= 2.53
BuildRequires: make
BuildRequires: gcc
BuildRequires: /bin/sh
BuildRequires: /bin/ln
BuildRequires: /usr/bin/ld
BuildRequires: /sbin/ldconfig
BuildRequires: /usr/bin/ranlib
BuildRequires: /usr/bin/ar
BuildRequires: /usr/bin/awk
BuildRequires: /usr/bin/bison
BuildRequires: /usr/bin/install
BuildRequires: glibc-devel
BuildRequires: Pyrex
BuildRequires: tcl
BuildRequires: gcc-java

BuildRoot: %{_tmppath}/%{name}-%{version}-InstallRoot
%define _bindir /bin
%define _sbindir /sbin
%define _libdir /lib
%define _sysconfdir /etc

AutoProv: 1

AutoReq: 1
Requires: /bin/sh

Summary: Braille display driver for Linux/Unix.
%description
BRLTTY is a background process (daemon) which provides access to
the console screen (when in text mode) for a blind person using a
refreshable braille display.  It drives the braille display, and
provides complete screen review functionality.  Some speech capability
has also been incorporated.

Install this package if you use a refreshable braille display.

%package -n brlapi
Version: 0.5.1
Group: Applications/System
License: LGPL

AutoProv: 1

AutoReq: 1

Summary: Appliation Programming Interface for BRLTTY.
%description -n brlapi
This package provides the run-time support for the Application
Programming Interface to BRLTTY.

Install this package if you have an application
which directly accesses a refreshable braille display.

%package -n brlapi-java
Version: 0.5.1
Group: Applications/System
License: LGPL

AutoProv: 1

AutoReq: 1

Summary: Java bindings for BrlAPI.
%description -n brlapi-java
This package provides the Java bindings for BrlAPI,
which is the Application Programming Interface to BRLTTY.

Install this package if you have a Java application
which directly accesses a refreshable braille display.

%package -n brlapi-python
Version: 0.5.1
Group: Applications/System
License: LGPL

AutoProv: 1

AutoReq: 1

Summary: Python bindings for BrlAPI.
%description -n brlapi-python
This package provides the Python bindings for BrlAPI,
which is the Application Programming Interface to BRLTTY.

Install this package if you have a Python application
which directly accesses a refreshable braille display.

%package -n brlapi-tcl
Version: 0.5.1
Group: Applications/System
License: LGPL

AutoProv: 1

AutoReq: 1

Summary: Tcl bindings for BrlAPI.
%description -n brlapi-tcl
This package provides the Tcl bindings for BrlAPI,
which is the Application Programming Interface to BRLTTY.

Install this package if you have a Tcl application
which directly accesses a refreshable braille display.

%package -n brlapi-devel
Version: 0.5.1
Group: Development/System
License: LGPL

AutoProv: 1

AutoReq: 1
Requires: brlapi = 0.5.1

Summary: Headers, static archive, and documentation for BrlAPI.
%description -n brlapi-devel
This package provides the header files, static archive, shared object
linker reference, and reference documentation for BrlAPI (the
Application Programming Interface to BRLTTY).  It enables the
implementation of applications which take direct advantage of a
refreshable braille display in order to present information in ways
which are more appropriate for blind users and/or to provide user
interfaces which are more specifically atuned to their needs.

Install this package if you're developing or maintaining an application
which directly accesses a refreshable braille display.

%prep
# %setup -n %{name}-%{version}
%setup -n brltty-3.9

%build
%configure --disable-relocatable-install --with-install-root="${RPM_BUILD_ROOT}" --disable-gpm --without-flite --without-mikropuhe --without-swift --without-theta --without-viavoice --without-libbraille --without-curses --without-x --with-braille-driver=-tt
make

directory="doc"
mkdir -p "${directory}"
for file in `find . \( -path "./${directory}" -o -path ./Documents \) -prune -o \( -name 'README*' -o -name '*.patch' -o -name '*.txt' -o -name '*.html' -o -name '*.sgml' -o \( -path "./Bootdisks/*" -type f -perm +ugo=x \) \) -print`
do
   mkdir -p "${directory}/${file%/*}"
   cp -rp "${file}" "${directory}/${file}"
done

%install
make install
install -m 644 Documents/brltty.conf "${RPM_BUILD_ROOT}%{_sysconfdir}"

%clean
rm -fr "${RPM_BUILD_ROOT}"

%files
%defattr(-,root,root)
%{_bindir}/brltty
%{_bindir}/brltty-*
%{_bindir}/vstp
%{_libdir}/brltty
%{_sysconfdir}/brltty
%doc %{_mandir}/man1/*
%doc Documents/Manual-BRLTTY/English/*.{sgml,txt,html}
%doc COPYING
%doc Documents/ChangeLog Documents/TODO
%doc doc/*
%config(noreplace) %verify(not size md5 mtime) %{_sysconfdir}/brltty.conf

%files -n brlapi
%defattr(-,root,root)
%{_libdir}/libbrlapi.so.*
%doc Documents/Manual-BrlAPI/English/*.{sgml,txt,html}
%doc Documents/README.Gnopernicus

%files -n brlapi-java
/usr/share/java/*
/usr/lib/java/*

%files -n brlapi-python
/usr/lib/python2.4/site-packages/brlapi.*

%files -n brlapi-tcl
/usr/lib/brlapi-0.5.1/libbrlapi_tcl.so
/usr/lib/brlapi-0.5.1/pkgIndex.tcl

%files -n brlapi-devel
%defattr(-,root,root)
%{_libdir}/libbrlapi.a
%{_libdir}/libbrlapi.so
%{_includedir}/brlapi.h
%{_includedir}/brlapi_*.h
%{_includedir}/brltty
%doc %{_mandir}/man3/*
%doc Documents/BrlAPIref

%changelog
* Wed Oct 17 2007 Dave Mielke <dave@mielke.cc> 3.9
+  Core changes:
      The startup log and initial braille display message contain the build revision.
      The -v [--verify] option identifies the screen driver.
      Failure of the braille and/or screen driver to start isn't fatal.
      Repeated retries are scheduled for each driver until it starts.
      Attempts to connect to gpm are only made when it's actually needed.
      Standalone programs no longer include support for shared objects.
      The MSDOS operating system is supported.
      MSDOS option syntax (/flag and /name:value) is supported.
      The syntax +x to clear a short option flag is supported.
      Help output groups options by function rather than lists them alphabetically.
      Needed but missing resources are created (by default) in /lib/brltty/rw/:
         command line option: -W [--writable-directory=]
         configuration file directive: writable-directory
         environment variable: BRLTTY_WRITABLE_DIRECTORY
         configure script option: --with-writable-directory=
+  BrlAPI changes:
      Version updated to 0.5.1.
      TCP sockets are more responsive.
      The -h [--host] option of xbrlapi has been changed to -b [--brlapi].
+  Baum braille driver changes:
      The autosuspend feature of Linux USB devices is disabled.
      Don't probe for emulation modes if a serial device is being used.
      Add the protocol= (all, native) parameter.
+  HandyTech braille driver changes:
      The Easy Braille is supported.
+  Papenmeier braille driver changes:
      The Trio models are supported.
      The second set of vertical status keys does vertical routing.
+  Linux changes:
      USB devices maintained by udev under /dev/bus/usb/ are supported.
+  Cygwin changes:
      The emulation layer (rather than Windows functions) is used.
      Serial devices named ttySn (rather than COMn) are used.
+  Windows changes:
      Write to the event log.
      The -I [--install-service] and -R [--remove-service] options have been added.
      The -r [--release-device] option defaults to "on".
+  Table changes:
      Corrections to Finnish braille [text.fi1.tbl, text.fi2.tbl].
      Corrections to Portuguese braille [text.pt.tbl].
      Corrections to American English grade 2 braille [en-us-g2.ctb].
      Unified English Braille table rename: uebc-g2 -> en-uebc-g2
      Chinese table renames: big5 -> zh-tw-big5, gb2312 -> zh-tw-gb2312
      New Chinese tables: zh-tw-utf8, zh-tw-ucb

