/*----------------------------------------------------------------------------

   libtunepimp -- The MusicBrainz tagging library.  
                  Let a thousand taggers bloom!
   
   Copyright (C) Robert Kaye 2003
   
   This file is part of libtunepimp.

   libtunepimp is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   libtunepimp is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with libtunepimp; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   $Id: submit.cpp,v 1.7 2003/07/25 08:37:33 robert Exp $

----------------------------------------------------------------------------*/
#ifdef WIN32
#if _MSC_VER == 1200
#pragma warning(disable:4786)
#endif
#endif

#include "submit.h"
#include "tunepimp.h"

#define DB printf("%s:%d\n", __FILE__, __LINE__);

//---------------------------------------------------------------------------

int SubmitInfo::getNumItems(void)
{
    return list.size();
}

//---------------------------------------------------------------------------

void SubmitInfo::add(const string &trackId, const string &trmId)
{
    pair<string, string> p;

    if (trmId == string("00000000-0000-0000-0000-000000000000") ||
        trmId == string("40400000-0000-0000-0000-000000000000") ||
        trmId == string("ffffffff-ffff-ffff-ffff-ffffffffffff") ||
        trmId.size() != 36 || trackId.size() != 36)
       return;

    p.first = trackId;
    p.second = trmId;
    list.push_back(p);
}

//---------------------------------------------------------------------------

void SubmitInfo::remove(const string &trackId)
{
    vector<pair<string, string> >::iterator i;

    for(i = list.begin(); i != list.end(); i++)
    {
        if (i->first == trackId)
        {
           list.erase(i);
           return;
        }
    }
}

//---------------------------------------------------------------------------

bool SubmitInfo::find(const string &trmId, string &trackId)
{
    vector<pair<string, string> >::iterator i;

    for(i = list.begin(); i != list.end(); i++)
    {
        if (i->second == trmId)
        {
           trackId = i->first;
           return true;
        }
    }
    return false;
}

//---------------------------------------------------------------------------

void SubmitInfo::getRDF(string &rdf)
{
    vector<pair<string, string> >::iterator i;

    rdf = string(
       "<mq:SubmitTRMList>\n"
       "<mm:trmidList>\n"
       "<rdf:Bag>\n");

    for(i = list.begin(); i != list.end(); i++)
    {
        rdf += string("<rdf:li>\n"
                          "<mq:trmTrackPair>\n"
                          "<mm:trmid>");

        rdf += (*i).second + "</mm:trmid>\n<mm:trackid>";
        rdf += (*i).first + "</mm:trackid>\n</mq:trmTrackPair>\n</rdf:li>\n";
    }

    rdf += string("</rdf:Bag>\n"
                      "</mm:trmidList>\n"
                      "<mq:sessionId>@SESSID@</mq:sessionId>\n"
                      "<mq:sessionKey>@SESSKEY@</mq:sessionKey>\n<mq:clientVersion>");
    rdf += appName;
    rdf += string("/");
    rdf += appVersion;
    rdf += string("</mq:clientVersion>\n"
                  "</mq:SubmitTRMList>\n");
}

//---------------------------------------------------------------------------

LookupStatus SubmitInfo::submit(void)
{
    SubmitTRM    trmSubmit(tunePimp);
    LookupStatus ret;
    string       rdf;

    if (getNumItems() == 0)
    {
        err = "No TRM ids to submit.";
        return eSubmitError;    
    }

    getRDF(rdf);
    trmSubmit.setArgs(rdf, username, password);
    ret = trmSubmit.lookup();
    if (ret != eSubmitOk)
    {
        trmSubmit.getError(err);
        return ret;
    }

    return ret;
}
