/* Generated by re2c 0.13.5 on Wed Feb 15 17:38:31 2012 */
#line 1 "Zend/zend_language_scanner.l"
/*
   +----------------------------------------------------------------------+
   | Zend Engine                                                          |
   +----------------------------------------------------------------------+
   | Copyright (c) 1998-2012 Zend Technologies Ltd. (http://www.zend.com) |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.00 of the Zend license,     |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.zend.com/license/2_00.txt.                                |
   | If you did not receive a copy of the Zend license and are unable to  |
   | obtain it through the world-wide-web, please send a note to          |
   | license@zend.com so we can mail you a copy immediately.              |
   +----------------------------------------------------------------------+
   | Authors: Marcus Boerger <helly@php.net>                              |
   |          Nuno Lopes <nlopess@php.net>                                |
   |          Scott MacVicar <scottmac@php.net>                           |
   | Flex version authors:                                                |
   |          Andi Gutmans <andi@zend.com>                                |
   |          Zeev Suraski <zeev@zend.com>                                |
   +----------------------------------------------------------------------+
*/

/* $Id$ */

#if 0
# define YYDEBUG(s, c) printf("state: %d char: %c\n", s, c)
#else
# define YYDEBUG(s, c)
#endif

#include "zend_language_scanner_defs.h"

#include <errno.h>
#include "zend.h"
#include "zend_alloc.h"
#include <zend_language_parser.h>
#include "zend_compile.h"
#include "zend_language_scanner.h"
#include "zend_highlight.h"
#include "zend_constants.h"
#include "zend_variables.h"
#include "zend_operators.h"
#include "zend_API.h"
#include "zend_strtod.h"
#include "zend_exceptions.h"
#include "tsrm_virtual_cwd.h"
#include "tsrm_config_common.h"

#define YYCTYPE   unsigned char
#define YYFILL(n) { if ((YYCURSOR + n) >= (YYLIMIT + ZEND_MMAP_AHEAD)) { return 0; } }
#define YYCURSOR  SCNG(yy_cursor)
#define YYLIMIT   SCNG(yy_limit)
#define YYMARKER  SCNG(yy_marker)

#define YYGETCONDITION()  SCNG(yy_state)
#define YYSETCONDITION(s) SCNG(yy_state) = s

#define STATE(name)  yyc##name

/* emulate flex constructs */
#define BEGIN(state) YYSETCONDITION(STATE(state))
#define YYSTATE      YYGETCONDITION()
#define yytext       ((char*)SCNG(yy_text))
#define yyleng       SCNG(yy_leng)
#define yyless(x)    do { YYCURSOR = (unsigned char*)yytext + x; \
                          yyleng   = (unsigned int)x; } while(0)
#define yymore()     goto yymore_restart

/* perform sanity check. If this message is triggered you should
   increase the ZEND_MMAP_AHEAD value in the zend_streams.h file */
#define YYMAXFILL 16
#if ZEND_MMAP_AHEAD < YYMAXFILL
# error ZEND_MMAP_AHEAD should be greater than or equal to YYMAXFILL
#endif

#ifdef HAVE_STDARG_H
# include <stdarg.h>
#endif

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif

/* Globals Macros */
#define SCNG	LANG_SCNG
#ifdef ZTS
ZEND_API ts_rsrc_id language_scanner_globals_id;
#else
ZEND_API zend_php_scanner_globals language_scanner_globals;
#endif

#define HANDLE_NEWLINES(s, l)													\
do {																			\
	char *p = (s), *boundary = p+(l);											\
																				\
	while (p<boundary) {														\
		if (*p == '\n' || (*p == '\r' && (*(p+1) != '\n'))) {					\
			CG(zend_lineno)++;													\
		}																		\
		p++;																	\
	}																			\
} while (0)

#define HANDLE_NEWLINE(c) \
{ \
	if (c == '\n' || c == '\r') { \
		CG(zend_lineno)++; \
	} \
}

/* To save initial string length after scanning to first variable, CG(doc_comment_len) can be reused */
#define SET_DOUBLE_QUOTES_SCANNED_LENGTH(len) CG(doc_comment_len) = (len)
#define GET_DOUBLE_QUOTES_SCANNED_LENGTH()    CG(doc_comment_len)

#define IS_LABEL_START(c) (((c) >= 'a' && (c) <= 'z') || ((c) >= 'A' && (c) <= 'Z') || (c) == '_' || (c) >= 0x7F)

#define ZEND_IS_OCT(c)  ((c)>='0' && (c)<='7')
#define ZEND_IS_HEX(c)  (((c)>='0' && (c)<='9') || ((c)>='a' && (c)<='f') || ((c)>='A' && (c)<='F'))

BEGIN_EXTERN_C()

static void _yy_push_state(int new_state TSRMLS_DC)
{
	zend_stack_push(&SCNG(state_stack), (void *) &YYGETCONDITION(), sizeof(int));
	YYSETCONDITION(new_state);
}

#define yy_push_state(state_and_tsrm) _yy_push_state(yyc##state_and_tsrm)

static void yy_pop_state(TSRMLS_D)
{
	int *stack_state;
	zend_stack_top(&SCNG(state_stack), (void **) &stack_state);
	YYSETCONDITION(*stack_state);
	zend_stack_del_top(&SCNG(state_stack));
}

static void yy_scan_buffer(char *str, unsigned int len TSRMLS_DC)
{
	YYCURSOR       = (YYCTYPE*)str;
	YYLIMIT        = YYCURSOR + len;
	if (!SCNG(yy_start)) {
		SCNG(yy_start) = YYCURSOR;
	}
}

void startup_scanner(TSRMLS_D)
{
	CG(heredoc) = NULL;
	CG(heredoc_len) = 0;
	CG(doc_comment) = NULL;
	CG(doc_comment_len) = 0;
	zend_stack_init(&SCNG(state_stack));
}

void shutdown_scanner(TSRMLS_D)
{
	if (CG(heredoc)) {
		efree(CG(heredoc));
		CG(heredoc_len)=0;
	}
	zend_stack_destroy(&SCNG(state_stack));
	RESET_DOC_COMMENT();
}

ZEND_API void zend_save_lexical_state(zend_lex_state *lex_state TSRMLS_DC)
{
	lex_state->yy_leng   = SCNG(yy_leng);
	lex_state->yy_start  = SCNG(yy_start);
	lex_state->yy_text   = SCNG(yy_text);
	lex_state->yy_cursor = SCNG(yy_cursor);
	lex_state->yy_marker = SCNG(yy_marker);
	lex_state->yy_limit  = SCNG(yy_limit);

	lex_state->state_stack = SCNG(state_stack);
	zend_stack_init(&SCNG(state_stack));

	lex_state->in = SCNG(yy_in);
	lex_state->yy_state = YYSTATE;
	lex_state->filename = zend_get_compiled_filename(TSRMLS_C);
	lex_state->lineno = CG(zend_lineno);

#ifdef ZEND_MULTIBYTE
	lex_state->script_org = SCNG(script_org);
	lex_state->script_org_size = SCNG(script_org_size);
	lex_state->script_filtered = SCNG(script_filtered);
	lex_state->script_filtered_size = SCNG(script_filtered_size);
	lex_state->input_filter = SCNG(input_filter);
	lex_state->output_filter = SCNG(output_filter);
	lex_state->script_encoding = SCNG(script_encoding);
	lex_state->internal_encoding = SCNG(internal_encoding);
#endif /* ZEND_MULTIBYTE */
}

ZEND_API void zend_restore_lexical_state(zend_lex_state *lex_state TSRMLS_DC)
{
	SCNG(yy_leng)   = lex_state->yy_leng;
	SCNG(yy_start)  = lex_state->yy_start;
	SCNG(yy_text)   = lex_state->yy_text;
	SCNG(yy_cursor) = lex_state->yy_cursor;
	SCNG(yy_marker) = lex_state->yy_marker;
	SCNG(yy_limit)  = lex_state->yy_limit;

	zend_stack_destroy(&SCNG(state_stack));
	SCNG(state_stack) = lex_state->state_stack;

	SCNG(yy_in) = lex_state->in;
	YYSETCONDITION(lex_state->yy_state);
	CG(zend_lineno) = lex_state->lineno;
	zend_restore_compiled_filename(lex_state->filename TSRMLS_CC);
#ifdef ZEND_MULTIBYTE
	if (SCNG(script_org)) {
		efree(SCNG(script_org));
		SCNG(script_org) = NULL;
	}
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	SCNG(script_org) = lex_state->script_org;
	SCNG(script_org_size) = lex_state->script_org_size;
	SCNG(script_filtered) = lex_state->script_filtered;
	SCNG(script_filtered_size) = lex_state->script_filtered_size;
	SCNG(input_filter) = lex_state->input_filter;
	SCNG(output_filter) = lex_state->output_filter;
	SCNG(script_encoding) = lex_state->script_encoding;
	SCNG(internal_encoding) = lex_state->internal_encoding;
#endif /* ZEND_MULTIBYTE */

	if (CG(heredoc)) {
		efree(CG(heredoc));
		CG(heredoc) = NULL;
		CG(heredoc_len) = 0;
	}
}

ZEND_API void zend_destroy_file_handle(zend_file_handle *file_handle TSRMLS_DC)
{
	zend_llist_del_element(&CG(open_files), file_handle, (int (*)(void *, void *)) zend_compare_file_handles);
	/* zend_file_handle_dtor() operates on the copy, so we have to NULLify the original here */
	file_handle->opened_path = NULL;
	if (file_handle->free_filename) {
		file_handle->filename = NULL;
	}
}


ZEND_API int open_file_for_scanning(zend_file_handle *file_handle TSRMLS_DC)
{
	char *file_path = NULL, *buf;
	size_t size, offset = 0;
	
	/* The shebang line was read, get the current position to obtain the buffer start */
	if (CG(start_lineno) == 2 && file_handle->type == ZEND_HANDLE_FP && file_handle->handle.fp) {
		if ((offset = ftell(file_handle->handle.fp)) == -1) {
			offset = 0;
		}
	}

	if (zend_stream_fixup(file_handle, &buf, &size TSRMLS_CC) == FAILURE) {
		return FAILURE;
	}

	zend_llist_add_element(&CG(open_files), file_handle);
	if (file_handle->handle.stream.handle >= (void*)file_handle && file_handle->handle.stream.handle <= (void*)(file_handle+1)) {
		zend_file_handle *fh = (zend_file_handle*)zend_llist_get_last(&CG(open_files));
		size_t diff = (char*)file_handle->handle.stream.handle - (char*)file_handle;
		fh->handle.stream.handle = (void*)(((char*)fh) + diff);
		file_handle->handle.stream.handle = fh->handle.stream.handle;
	}

	/* Reset the scanner for scanning the new file */
	SCNG(yy_in) = file_handle;
	SCNG(yy_start) = NULL;

	if (size != -1) {
#ifdef ZEND_MULTIBYTE
		if (zend_multibyte_read_script((unsigned char *)buf, size TSRMLS_CC) != 0) {
			return FAILURE;
		}

		SCNG(yy_in) = NULL;

		zend_multibyte_set_filter(NULL TSRMLS_CC);

		if (!SCNG(input_filter)) {
			SCNG(script_filtered) = (unsigned char*)emalloc(SCNG(script_org_size)+1);
			memcpy(SCNG(script_filtered), SCNG(script_org), SCNG(script_org_size)+1);
			SCNG(script_filtered_size) = SCNG(script_org_size);
		} else {
			SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size) TSRMLS_CC);
			if (SCNG(script_filtered) == NULL) {
				zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
						"encoding \"%s\" to a compatible encoding", LANG_SCNG(script_encoding)->name);
			}
		}
		SCNG(yy_start) = SCNG(script_filtered) - offset;
		yy_scan_buffer((char *)SCNG(script_filtered), SCNG(script_filtered_size) TSRMLS_CC);
#else /* !ZEND_MULTIBYTE */
		SCNG(yy_start) = buf - offset;
		yy_scan_buffer(buf, size TSRMLS_CC);
#endif /* ZEND_MULTIBYTE */
	} else {
		zend_error_noreturn(E_COMPILE_ERROR, "zend_stream_mmap() failed");
	}

	BEGIN(INITIAL);

	if (file_handle->opened_path) {
		file_path = file_handle->opened_path;
	} else {
		file_path = file_handle->filename;
	}

	zend_set_compiled_filename(file_path TSRMLS_CC);

	if (CG(start_lineno)) {
		CG(zend_lineno) = CG(start_lineno);
		CG(start_lineno) = 0;
	} else {
		CG(zend_lineno) = 1;
	}

	CG(increment_lineno) = 0;
	return SUCCESS;
}
END_EXTERN_C()


ZEND_API zend_op_array *compile_file(zend_file_handle *file_handle, int type TSRMLS_DC)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = (zend_op_array *) emalloc(sizeof(zend_op_array));
	zend_op_array *original_active_op_array = CG(active_op_array);
	zend_op_array *retval=NULL;
	int compiler_result;
	zend_bool compilation_successful=0;
	znode retval_znode;
	zend_bool original_in_compilation = CG(in_compilation);

	retval_znode.op_type = IS_CONST;
	retval_znode.u.constant.type = IS_LONG;
	retval_znode.u.constant.value.lval = 1;
	Z_UNSET_ISREF(retval_znode.u.constant);
	Z_SET_REFCOUNT(retval_znode.u.constant, 1);

	zend_save_lexical_state(&original_lex_state TSRMLS_CC);

	retval = op_array; /* success oriented */

	if (open_file_for_scanning(file_handle TSRMLS_CC)==FAILURE) {
		if (type==ZEND_REQUIRE) {
			zend_message_dispatcher(ZMSG_FAILED_REQUIRE_FOPEN, file_handle->filename TSRMLS_CC);
			zend_bailout();
		} else {
			zend_message_dispatcher(ZMSG_FAILED_INCLUDE_FOPEN, file_handle->filename TSRMLS_CC);
		}
		compilation_successful=0;
	} else {
		init_op_array(op_array, ZEND_USER_FUNCTION, INITIAL_OP_ARRAY_SIZE TSRMLS_CC);
		CG(in_compilation) = 1;
		CG(active_op_array) = op_array;
		compiler_result = zendparse(TSRMLS_C);
		zend_do_return(&retval_znode, 0 TSRMLS_CC);
		CG(in_compilation) = original_in_compilation;
		if (compiler_result==1) { /* parser error */
			zend_bailout();
		}
		compilation_successful=1;
	}

	if (retval) {
		CG(active_op_array) = original_active_op_array;
		if (compilation_successful) {
			pass_two(op_array TSRMLS_CC);
			zend_release_labels(TSRMLS_C);
		} else {
			efree(op_array);
			retval = NULL;
		}
	}
	zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
	return retval;
}


zend_op_array *compile_filename(int type, zval *filename TSRMLS_DC)
{
	zend_file_handle file_handle;
	zval tmp;
	zend_op_array *retval;
	char *opened_path = NULL;

	if (filename->type != IS_STRING) {
		tmp = *filename;
		zval_copy_ctor(&tmp);
		convert_to_string(&tmp);
		filename = &tmp;
	}
	file_handle.filename = filename->value.str.val;
	file_handle.free_filename = 0;
	file_handle.type = ZEND_HANDLE_FILENAME;
	file_handle.opened_path = NULL;
	file_handle.handle.fp = NULL;

	retval = zend_compile_file(&file_handle, type TSRMLS_CC);
	if (retval && file_handle.handle.stream.handle) {
		int dummy = 1;

		if (!file_handle.opened_path) {
			file_handle.opened_path = opened_path = estrndup(filename->value.str.val, filename->value.str.len);
		}

		zend_hash_add(&EG(included_files), file_handle.opened_path, strlen(file_handle.opened_path)+1, (void *)&dummy, sizeof(int), NULL);

		if (opened_path) {
			efree(opened_path);
		}
	}
	zend_destroy_file_handle(&file_handle TSRMLS_CC);

	if (filename==&tmp) {
		zval_dtor(&tmp);
	}
	return retval;
}

ZEND_API int zend_prepare_string_for_scanning(zval *str, char *filename TSRMLS_DC)
{
	/* enforce two trailing NULLs for flex... */
	str->value.str.val = safe_erealloc(str->value.str.val, 1, str->value.str.len, ZEND_MMAP_AHEAD);

	memset(str->value.str.val + str->value.str.len, 0, ZEND_MMAP_AHEAD);

	SCNG(yy_in)=NULL;
	SCNG(yy_start) = NULL;

#ifdef ZEND_MULTIBYTE
	SCNG(script_org) = (unsigned char *)estrdup(str->value.str.val);
	SCNG(script_org_size) = str->value.str.len;

	zend_multibyte_set_filter(CG(internal_encoding) TSRMLS_CC);

	if (!SCNG(input_filter)) {
		SCNG(script_filtered) = (unsigned char*)emalloc(SCNG(script_org_size)+1);
		memcpy(SCNG(script_filtered), SCNG(script_org), SCNG(script_org_size)+1);
		SCNG(script_filtered_size) = SCNG(script_org_size);
	} else {
		SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size) TSRMLS_CC);
	}

	yy_scan_buffer((char *)SCNG(script_filtered), SCNG(script_filtered_size) TSRMLS_CC);	
#else /* !ZEND_MULTIBYTE */
	yy_scan_buffer(str->value.str.val, str->value.str.len TSRMLS_CC);
#endif /* ZEND_MULTIBYTE */

	zend_set_compiled_filename(filename TSRMLS_CC);
	CG(zend_lineno) = 1;
	CG(increment_lineno) = 0;
	return SUCCESS;
}


ZEND_API size_t zend_get_scanned_file_offset(TSRMLS_D)
{
	size_t offset = SCNG(yy_cursor) - SCNG(yy_start);
#ifdef ZEND_MULTIBYTE
	if (SCNG(input_filter)) {
		size_t original_offset = offset, length = 0; do {
			unsigned char *p = NULL;
			SCNG(input_filter)(&p, &length, SCNG(script_org), offset TSRMLS_CC);
			if (!p) {
				break;
			}
			efree(p);
			if (length > original_offset) {
				offset--;
			} else if (length < original_offset) {
				offset++;
			}
		} while (original_offset != length);
	}
#endif
	return offset;
}


zend_op_array *compile_string(zval *source_string, char *filename TSRMLS_DC)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = (zend_op_array *) emalloc(sizeof(zend_op_array));
	zend_op_array *original_active_op_array = CG(active_op_array);
	zend_op_array *retval;
	zval tmp;
	int compiler_result;
	zend_bool original_in_compilation = CG(in_compilation);

	if (source_string->value.str.len==0) {
		efree(op_array);
		return NULL;
	}

	CG(in_compilation) = 1;

	tmp = *source_string;
	zval_copy_ctor(&tmp);
	convert_to_string(&tmp);
	source_string = &tmp;

	zend_save_lexical_state(&original_lex_state TSRMLS_CC);
	if (zend_prepare_string_for_scanning(source_string, filename TSRMLS_CC)==FAILURE) {
		efree(op_array);
		retval = NULL;
	} else {
		zend_bool orig_interactive = CG(interactive);

		CG(interactive) = 0;
		init_op_array(op_array, ZEND_EVAL_CODE, INITIAL_OP_ARRAY_SIZE TSRMLS_CC);
		CG(interactive) = orig_interactive;
		CG(active_op_array) = op_array;
		BEGIN(ST_IN_SCRIPTING);
		compiler_result = zendparse(TSRMLS_C);

#ifdef ZEND_MULTIBYTE
		if (SCNG(script_org)) {
			efree(SCNG(script_org));
			SCNG(script_org) = NULL;
		}
		if (SCNG(script_filtered)) {
			efree(SCNG(script_filtered));
			SCNG(script_filtered) = NULL;
		}
#endif /* ZEND_MULTIBYTE */

		if (compiler_result==1) {
			CG(active_op_array) = original_active_op_array;
			CG(unclean_shutdown)=1;
			destroy_op_array(op_array TSRMLS_CC);
			efree(op_array);
			retval = NULL;
		} else {
			zend_do_return(NULL, 0 TSRMLS_CC);
			CG(active_op_array) = original_active_op_array;
			pass_two(op_array TSRMLS_CC);
			zend_release_labels(TSRMLS_C);
			retval = op_array;
		}
	}
	zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
	zval_dtor(&tmp);
	CG(in_compilation) = original_in_compilation;
	return retval;
}


BEGIN_EXTERN_C()
int highlight_file(char *filename, zend_syntax_highlighter_ini *syntax_highlighter_ini TSRMLS_DC)
{
	zend_lex_state original_lex_state;
	zend_file_handle file_handle;

	file_handle.type = ZEND_HANDLE_FILENAME;
	file_handle.filename = filename;
	file_handle.free_filename = 0;
	file_handle.opened_path = NULL;
	zend_save_lexical_state(&original_lex_state TSRMLS_CC);
	if (open_file_for_scanning(&file_handle TSRMLS_CC)==FAILURE) {
		zend_message_dispatcher(ZMSG_FAILED_HIGHLIGHT_FOPEN, filename TSRMLS_CC);
		zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
		return FAILURE;
	}
	zend_highlight(syntax_highlighter_ini TSRMLS_CC);
#ifdef ZEND_MULTIBYTE
	if (SCNG(script_org)) {
		efree(SCNG(script_org));
		SCNG(script_org) = NULL;
	}
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
#endif /* ZEND_MULTIBYTE */
	zend_destroy_file_handle(&file_handle TSRMLS_CC);
	zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
	return SUCCESS;
}

int highlight_string(zval *str, zend_syntax_highlighter_ini *syntax_highlighter_ini, char *str_name TSRMLS_DC)
{
	zend_lex_state original_lex_state;
	zval tmp = *str;

	str = &tmp;
	zval_copy_ctor(str);
	zend_save_lexical_state(&original_lex_state TSRMLS_CC);
	if (zend_prepare_string_for_scanning(str, str_name TSRMLS_CC)==FAILURE) {
		zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
		return FAILURE;
	}
	BEGIN(INITIAL);
	zend_highlight(syntax_highlighter_ini TSRMLS_CC);
#ifdef ZEND_MULTIBYTE
	if (SCNG(script_org)) {
		efree(SCNG(script_org));
		SCNG(script_org) = NULL;
	}
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
#endif /* ZEND_MULTIBYTE */
	zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
	zval_dtor(str);
	return SUCCESS;
}
END_EXTERN_C()

#ifdef ZEND_MULTIBYTE

BEGIN_EXTERN_C()
ZEND_API void zend_multibyte_yyinput_again(zend_encoding_filter old_input_filter, zend_encoding *old_encoding TSRMLS_DC)
{
	size_t original_offset, offset, free_flag, new_len, length;
	unsigned char *p;

	/* calculate current position */
	offset = original_offset = YYCURSOR - SCNG(yy_start);
	if (old_input_filter && offset > 0) {
		zend_encoding *new_encoding = SCNG(script_encoding);
		zend_encoding_filter new_filter = SCNG(input_filter);
		SCNG(script_encoding) = old_encoding;
		SCNG(input_filter) = old_input_filter;
		offset = zend_get_scanned_file_offset(TSRMLS_C);
		SCNG(script_encoding) = new_encoding;
		SCNG(input_filter) = new_filter;
	}

	/* convert and set */
	if (!SCNG(input_filter)) {
		length = SCNG(script_org_size) - offset;
		p = SCNG(script_org) + offset;
		free_flag = 0;
	} else {
		SCNG(input_filter)(&p, &length, SCNG(script_org) + offset, SCNG(script_org_size) - offset TSRMLS_CC);
		free_flag = 1;
	}

	new_len = original_offset + length;

	if (new_len > YYLIMIT - SCNG(yy_start)) {
		unsigned char *new_yy_start = erealloc(SCNG(yy_start), new_len);
		SCNG(yy_cursor) = new_yy_start + (SCNG(yy_cursor) - SCNG(yy_start));
		SCNG(yy_marker) = new_yy_start + (SCNG(yy_marker) - SCNG(yy_start));
		SCNG(yy_text) = new_yy_start + (SCNG(yy_text) - SCNG(yy_start));
		SCNG(yy_start) = new_yy_start;
		SCNG(script_filtered) = new_yy_start;
		SCNG(script_filtered_size) = new_len;
	}

	SCNG(yy_limit) = SCNG(yy_start) + new_len;
	memmove(SCNG(yy_start) + original_offset, p, length);

	if (free_flag) {
		efree(p);
	}
}


ZEND_API int zend_multibyte_yyinput(zend_file_handle *file_handle, char *buf, size_t len TSRMLS_DC)
{
	size_t n;

	if (CG(interactive) == 0) {
		if (zend_stream_fixup(file_handle, &buf, &len TSRMLS_CC) == FAILURE) {
			return FAILURE;
		}
		n = len;
		return n;
	}

	/* interactive */
	if (SCNG(script_org)) {
		efree(SCNG(script_org));
	}
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
	}
	SCNG(script_org) = NULL;
	SCNG(script_org_size) = 0;

	/* TODO: support widechars */
	if (zend_stream_fixup(file_handle, &buf, &len TSRMLS_CC) == FAILURE) {
		return FAILURE;
	}
	n = len;

	SCNG(script_org_size) = n;
	SCNG(script_org) = (unsigned char*)emalloc(SCNG(script_org_size) + 1);
	memcpy(SCNG(script_org), buf, n);

	return n;
}


ZEND_API int zend_multibyte_read_script(unsigned char *buf, size_t n TSRMLS_DC)
{
	if (SCNG(script_org)) {
		efree(SCNG(script_org));
		SCNG(script_org) = NULL;
	}
	SCNG(script_org_size) = n;	
	
	SCNG(script_org) = (unsigned char*)emalloc(SCNG(script_org_size) + 1);
	memcpy(SCNG(script_org), buf, n);
	*(SCNG(script_org)+SCNG(script_org_size)) = '\0';

	return 0;
}


# define zend_copy_value(zendlval, yytext, yyleng) \
	if (SCNG(output_filter)) { \
		size_t sz = 0; \
		SCNG(output_filter)((unsigned char **)&(zendlval->value.str.val), &sz, (unsigned char *)yytext, (size_t)yyleng TSRMLS_CC); \
		zendlval->value.str.len = sz; \
	} else { \
		zendlval->value.str.val = (char *) estrndup(yytext, yyleng); \
		zendlval->value.str.len = yyleng; \
	}
#else /* ZEND_MULTIBYTE */
# define zend_copy_value(zendlval, yytext, yyleng) \
	zendlval->value.str.val = (char *)estrndup(yytext, yyleng); \
	zendlval->value.str.len = yyleng;
#endif /* ZEND_MULTIBYTE */

static void zend_scan_escape_string(zval *zendlval, char *str, int len, char quote_type TSRMLS_DC)
{
	register char *s, *t;
	char *end;

	ZVAL_STRINGL(zendlval, str, len, 1);

	/* convert escape sequences */
	s = t = zendlval->value.str.val;
	end = s+zendlval->value.str.len;
	while (s<end) {
		if (*s=='\\') {
			s++;
			if (s >= end) {
				*t++ = '\\';
				break;
			}

			switch(*s) {
				case 'n':
					*t++ = '\n';
					zendlval->value.str.len--;
					break;
				case 'r':
					*t++ = '\r';
					zendlval->value.str.len--;
					break;
				case 't':
					*t++ = '\t';
					zendlval->value.str.len--;
					break;
				case 'f':
					*t++ = '\f';
					zendlval->value.str.len--;
					break;
				case 'v':
					*t++ = '\v';
					zendlval->value.str.len--;
					break;
				case '"':
				case '`':
					if (*s != quote_type) {
						*t++ = '\\';
						*t++ = *s;
						break;
					}
				case '\\':
				case '$':
					*t++ = *s;
					zendlval->value.str.len--;
					break;
				case 'x':
				case 'X':
					if (ZEND_IS_HEX(*(s+1))) {
						char hex_buf[3] = { 0, 0, 0 };

						zendlval->value.str.len--; /* for the 'x' */

						hex_buf[0] = *(++s);
						zendlval->value.str.len--;
						if (ZEND_IS_HEX(*(s+1))) {
							hex_buf[1] = *(++s);
							zendlval->value.str.len--;
						}
						*t++ = (char) strtol(hex_buf, NULL, 16);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
				default:
					/* check for an octal */
					if (ZEND_IS_OCT(*s)) {
						char octal_buf[4] = { 0, 0, 0, 0 };

						octal_buf[0] = *s;
						zendlval->value.str.len--;
						if (ZEND_IS_OCT(*(s+1))) {
							octal_buf[1] = *(++s);
							zendlval->value.str.len--;
							if (ZEND_IS_OCT(*(s+1))) {
								octal_buf[2] = *(++s);
								zendlval->value.str.len--;
							}
						}
						*t++ = (char) strtol(octal_buf, NULL, 8);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
			}
		} else {
			*t++ = *s;
		}

		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;
#ifdef ZEND_MULTIBYTE
	if (SCNG(output_filter)) {
		size_t sz = 0;
		s = zendlval->value.str.val;
		SCNG(output_filter)((unsigned char **)&(zendlval->value.str.val), &sz, (unsigned char *)s, (size_t)zendlval->value.str.len TSRMLS_CC);
		zendlval->value.str.len = sz;
		efree(s);
	}
#endif /* ZEND_MULTIBYTE */
}


int lex_scan(zval *zendlval TSRMLS_DC)
{
restart:
	SCNG(yy_text) = YYCURSOR;

yymore_restart:


#line 862 "Zend/zend_language_scanner.c"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	if (YYGETCONDITION() < 5) {
		if (YYGETCONDITION() < 2) {
			if (YYGETCONDITION() < 1) {
				goto yyc_ST_IN_SCRIPTING;
			} else {
				goto yyc_ST_LOOKING_FOR_PROPERTY;
			}
		} else {
			if (YYGETCONDITION() < 3) {
				goto yyc_ST_BACKQUOTE;
			} else {
				if (YYGETCONDITION() < 4) {
					goto yyc_ST_DOUBLE_QUOTES;
				} else {
					goto yyc_ST_HEREDOC;
				}
			}
		}
	} else {
		if (YYGETCONDITION() < 7) {
			if (YYGETCONDITION() < 6) {
				goto yyc_ST_LOOKING_FOR_VARNAME;
			} else {
				goto yyc_ST_VAR_OFFSET;
			}
		} else {
			if (YYGETCONDITION() < 8) {
				goto yyc_INITIAL;
			} else {
				if (YYGETCONDITION() < 9) {
					goto yyc_ST_END_HEREDOC;
				} else {
					goto yyc_ST_NOWDOC;
				}
			}
		}
	}
/* *********************************** */
yyc_INITIAL:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128,   0,   0, 128,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
		};

		YYDEBUG(0, *YYCURSOR);
		YYFILL(8);
		yych = *YYCURSOR;
		if (yych != '<') goto yy4;
		YYDEBUG(2, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '?') {
			if (yych == '%') goto yy7;
			if (yych >= '?') goto yy5;
		} else {
			if (yych <= 'S') {
				if (yych >= 'S') goto yy9;
			} else {
				if (yych == 's') goto yy9;
			}
		}
yy3:
		YYDEBUG(3, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1590 "Zend/zend_language_scanner.l"
		{
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

inline_char_handler:

	while (1) {
		YYCTYPE *ptr = memchr(YYCURSOR, '<', YYLIMIT - YYCURSOR);

		YYCURSOR = ptr ? ptr + 1 : YYLIMIT;

		if (YYCURSOR < YYLIMIT) {
			switch (*YYCURSOR) {
				case '?':
					if (CG(short_tags) || !strncasecmp(YYCURSOR + 1, "php", 3)) { /* Assume [ \t\n\r] follows "php" */
						break;
					}
					continue;
				case '%':
					if (CG(asp_tags)) {
						break;
					}
					continue;
				case 's':
				case 'S':
					/* Probably NOT an opening PHP <script> tag, so don't end the HTML chunk yet
					 * If it is, the PHP <script> tag rule checks for any HTML scanned before it */
					YYCURSOR--;
					yymore();
				default:
					continue;
			}

			YYCURSOR--;
		}

		break;
	}

inline_html:
	yyleng = YYCURSOR - SCNG(yy_text);

#ifdef ZEND_MULTIBYTE
	if (SCNG(output_filter)) {
		int readsize;
		size_t sz = 0;
		readsize = SCNG(output_filter)((unsigned char **)&(zendlval->value.str.val), &sz, (unsigned char *)yytext, (size_t)yyleng TSRMLS_CC);
		zendlval->value.str.len = sz;
		if (readsize < yyleng) {
			yyless(readsize);
		}
	} else {
	  zendlval->value.str.val = (char *) estrndup(yytext, yyleng);
	  zendlval->value.str.len = yyleng;
	}
#else /* !ZEND_MULTIBYTE */
	zendlval->value.str.val = (char *) estrndup(yytext, yyleng);
 	zendlval->value.str.len = yyleng;
#endif
	zendlval->type = IS_STRING;
	HANDLE_NEWLINES(yytext, yyleng);
	return T_INLINE_HTML;
}
#line 1026 "Zend/zend_language_scanner.c"
yy4:
		YYDEBUG(4, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy3;
yy5:
		YYDEBUG(5, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'O') {
			if (yych == '=') goto yy45;
		} else {
			if (yych <= 'P') goto yy47;
			if (yych == 'p') goto yy47;
		}
yy6:
		YYDEBUG(6, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1578 "Zend/zend_language_scanner.l"
		{
	if (CG(short_tags)) {
		zendlval->value.str.val = yytext; /* no copying - intentional */
		zendlval->value.str.len = yyleng;
		zendlval->type = IS_STRING;
		BEGIN(ST_IN_SCRIPTING);
		return T_OPEN_TAG;
	} else {
		goto inline_char_handler;
	}
}
#line 1056 "Zend/zend_language_scanner.c"
yy7:
		YYDEBUG(7, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '=') goto yy43;
		YYDEBUG(8, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1555 "Zend/zend_language_scanner.l"
		{
	if (CG(asp_tags)) {
		zendlval->value.str.val = yytext; /* no copying - intentional */
		zendlval->value.str.len = yyleng;
		zendlval->type = IS_STRING;
		BEGIN(ST_IN_SCRIPTING);
		return T_OPEN_TAG;
	} else {
		goto inline_char_handler;
	}
}
#line 1075 "Zend/zend_language_scanner.c"
yy9:
		YYDEBUG(9, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy11;
		if (yych == 'c') goto yy11;
yy10:
		YYDEBUG(10, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 0) {
			goto yy3;
		} else {
			goto yy6;
		}
yy11:
		YYDEBUG(11, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy12;
		if (yych != 'r') goto yy10;
yy12:
		YYDEBUG(12, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy13;
		if (yych != 'i') goto yy10;
yy13:
		YYDEBUG(13, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy14;
		if (yych != 'p') goto yy10;
yy14:
		YYDEBUG(14, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy15;
		if (yych != 't') goto yy10;
yy15:
		YYDEBUG(15, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy10;
		if (yych == 'l') goto yy10;
		goto yy17;
yy16:
		YYDEBUG(16, *YYCURSOR);
		++YYCURSOR;
		YYFILL(8);
		yych = *YYCURSOR;
yy17:
		YYDEBUG(17, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy16;
		}
		if (yych == 'L') goto yy18;
		if (yych != 'l') goto yy10;
yy18:
		YYDEBUG(18, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy19;
		if (yych != 'a') goto yy10;
yy19:
		YYDEBUG(19, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy20;
		if (yych != 'n') goto yy10;
yy20:
		YYDEBUG(20, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy21;
		if (yych != 'g') goto yy10;
yy21:
		YYDEBUG(21, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy22;
		if (yych != 'u') goto yy10;
yy22:
		YYDEBUG(22, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy23;
		if (yych != 'a') goto yy10;
yy23:
		YYDEBUG(23, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy24;
		if (yych != 'g') goto yy10;
yy24:
		YYDEBUG(24, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy25;
		if (yych != 'e') goto yy10;
yy25:
		YYDEBUG(25, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(26, *YYCURSOR);
		if (yych <= '\r') {
			if (yych <= 0x08) goto yy10;
			if (yych <= '\n') goto yy25;
			if (yych <= '\f') goto yy10;
			goto yy25;
		} else {
			if (yych <= ' ') {
				if (yych <= 0x1F) goto yy10;
				goto yy25;
			} else {
				if (yych != '=') goto yy10;
			}
		}
yy27:
		YYDEBUG(27, *YYCURSOR);
		++YYCURSOR;
		YYFILL(5);
		yych = *YYCURSOR;
		YYDEBUG(28, *YYCURSOR);
		if (yych <= '!') {
			if (yych <= '\f') {
				if (yych <= 0x08) goto yy10;
				if (yych <= '\n') goto yy27;
				goto yy10;
			} else {
				if (yych <= '\r') goto yy27;
				if (yych == ' ') goto yy27;
				goto yy10;
			}
		} else {
			if (yych <= 'O') {
				if (yych <= '"') goto yy30;
				if (yych == '\'') goto yy31;
				goto yy10;
			} else {
				if (yych <= 'P') goto yy29;
				if (yych != 'p') goto yy10;
			}
		}
yy29:
		YYDEBUG(29, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy42;
		if (yych == 'h') goto yy42;
		goto yy10;
yy30:
		YYDEBUG(30, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy39;
		if (yych == 'p') goto yy39;
		goto yy10;
yy31:
		YYDEBUG(31, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy32;
		if (yych != 'p') goto yy10;
yy32:
		YYDEBUG(32, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy33;
		if (yych != 'h') goto yy10;
yy33:
		YYDEBUG(33, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy34;
		if (yych != 'p') goto yy10;
yy34:
		YYDEBUG(34, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '\'') goto yy10;
yy35:
		YYDEBUG(35, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(36, *YYCURSOR);
		if (yych <= '\r') {
			if (yych <= 0x08) goto yy10;
			if (yych <= '\n') goto yy35;
			if (yych <= '\f') goto yy10;
			goto yy35;
		} else {
			if (yych <= ' ') {
				if (yych <= 0x1F) goto yy10;
				goto yy35;
			} else {
				if (yych != '>') goto yy10;
			}
		}
		YYDEBUG(37, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(38, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1511 "Zend/zend_language_scanner.l"
		{
	YYCTYPE *bracket = zend_memrchr(yytext, '<', yyleng - (sizeof("script language=php>") - 1));

	if (bracket != SCNG(yy_text)) {
		/* Handle previously scanned HTML, as possible <script> tags found are assumed to not be PHP's */
		YYCURSOR = bracket;
		goto inline_html;
	}

	HANDLE_NEWLINES(yytext, yyleng);
	zendlval->value.str.val = yytext; /* no copying - intentional */
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	BEGIN(ST_IN_SCRIPTING);
	return T_OPEN_TAG;
}
#line 1278 "Zend/zend_language_scanner.c"
yy39:
		YYDEBUG(39, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy40;
		if (yych != 'h') goto yy10;
yy40:
		YYDEBUG(40, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy41;
		if (yych != 'p') goto yy10;
yy41:
		YYDEBUG(41, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '"') goto yy35;
		goto yy10;
yy42:
		YYDEBUG(42, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy35;
		if (yych == 'p') goto yy35;
		goto yy10;
yy43:
		YYDEBUG(43, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(44, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1529 "Zend/zend_language_scanner.l"
		{
	if (CG(asp_tags)) {
		zendlval->value.str.val = yytext; /* no copying - intentional */
		zendlval->value.str.len = yyleng;
		zendlval->type = IS_STRING;
		BEGIN(ST_IN_SCRIPTING);
		return T_OPEN_TAG_WITH_ECHO;
	} else {
		goto inline_char_handler;
	}
}
#line 1317 "Zend/zend_language_scanner.c"
yy45:
		YYDEBUG(45, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(46, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1542 "Zend/zend_language_scanner.l"
		{
	if (CG(short_tags)) {
		zendlval->value.str.val = yytext; /* no copying - intentional */
		zendlval->value.str.len = yyleng;
		zendlval->type = IS_STRING;
		BEGIN(ST_IN_SCRIPTING);
		return T_OPEN_TAG_WITH_ECHO;
	} else {
		goto inline_char_handler;
	}
}
#line 1335 "Zend/zend_language_scanner.c"
yy47:
		YYDEBUG(47, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy48;
		if (yych != 'h') goto yy10;
yy48:
		YYDEBUG(48, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy49;
		if (yych != 'p') goto yy10;
yy49:
		YYDEBUG(49, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy10;
			if (yych >= '\v') goto yy10;
		} else {
			if (yych <= '\r') goto yy52;
			if (yych != ' ') goto yy10;
		}
yy50:
		YYDEBUG(50, *YYCURSOR);
		++YYCURSOR;
yy51:
		YYDEBUG(51, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1568 "Zend/zend_language_scanner.l"
		{
	zendlval->value.str.val = yytext; /* no copying - intentional */
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	HANDLE_NEWLINE(yytext[yyleng-1]);
	BEGIN(ST_IN_SCRIPTING);
	return T_OPEN_TAG;
}
#line 1371 "Zend/zend_language_scanner.c"
yy52:
		YYDEBUG(52, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '\n') goto yy50;
		goto yy51;
	}
/* *********************************** */
yyc_ST_BACKQUOTE:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(53, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych != '$') goto yy60;
		} else {
			if (yych <= '`') goto yy58;
			if (yych == '{') goto yy57;
			goto yy60;
		}
		YYDEBUG(55, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '_') {
			if (yych <= '@') goto yy56;
			if (yych <= 'Z') goto yy63;
			if (yych >= '_') goto yy63;
		} else {
			if (yych <= 'z') {
				if (yych >= 'a') goto yy63;
			} else {
				if (yych <= '{') goto yy66;
				if (yych >= 0x7F) goto yy63;
			}
		}
yy56:
		YYDEBUG(56, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2048 "Zend/zend_language_scanner.l"
		{
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '`':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	zend_scan_escape_string(zendlval, yytext, yyleng, '`' TSRMLS_CC);
	return T_ENCAPSED_AND_WHITESPACE;
}
#line 1483 "Zend/zend_language_scanner.c"
yy57:
		YYDEBUG(57, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy61;
		goto yy56;
yy58:
		YYDEBUG(58, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(59, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1992 "Zend/zend_language_scanner.l"
		{
	BEGIN(ST_IN_SCRIPTING);
	return '`';
}
#line 1499 "Zend/zend_language_scanner.c"
yy60:
		YYDEBUG(60, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy56;
yy61:
		YYDEBUG(61, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(62, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1979 "Zend/zend_language_scanner.l"
		{
	zendlval->value.lval = (long) '{';
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	yyless(1);
	return T_CURLY_OPEN;
}
#line 1516 "Zend/zend_language_scanner.c"
yy63:
		YYDEBUG(63, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(64, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy63;
		}
		if (yych == '-') goto yy68;
		if (yych == '[') goto yy70;
yy65:
		YYDEBUG(65, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1677 "Zend/zend_language_scanner.l"
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
#line 1538 "Zend/zend_language_scanner.c"
yy66:
		YYDEBUG(66, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(67, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1300 "Zend/zend_language_scanner.l"
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME TSRMLS_CC);
	return T_DOLLAR_OPEN_CURLY_BRACES;
}
#line 1549 "Zend/zend_language_scanner.c"
yy68:
		YYDEBUG(68, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy72;
yy69:
		YYDEBUG(69, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy65;
yy70:
		YYDEBUG(70, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(71, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1669 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
#line 1571 "Zend/zend_language_scanner.c"
yy72:
		YYDEBUG(72, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy69;
			if (yych <= 'Z') goto yy73;
			if (yych <= '^') goto yy69;
		} else {
			if (yych <= '`') goto yy69;
			if (yych <= 'z') goto yy73;
			if (yych <= '~') goto yy69;
		}
yy73:
		YYDEBUG(73, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(74, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1659 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
#line 1597 "Zend/zend_language_scanner.c"
	}
/* *********************************** */
yyc_ST_DOUBLE_QUOTES:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(75, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '#') {
			if (yych == '"') goto yy80;
			goto yy82;
		} else {
			if (yych <= '$') goto yy77;
			if (yych == '{') goto yy79;
			goto yy82;
		}
yy77:
		YYDEBUG(77, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '_') {
			if (yych <= '@') goto yy78;
			if (yych <= 'Z') goto yy85;
			if (yych >= '_') goto yy85;
		} else {
			if (yych <= 'z') {
				if (yych >= 'a') goto yy85;
			} else {
				if (yych <= '{') goto yy88;
				if (yych >= 0x7F) goto yy85;
			}
		}
yy78:
		YYDEBUG(78, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1998 "Zend/zend_language_scanner.l"
		{
	if (GET_DOUBLE_QUOTES_SCANNED_LENGTH()) {
		YYCURSOR += GET_DOUBLE_QUOTES_SCANNED_LENGTH() - 1;
		SET_DOUBLE_QUOTES_SCANNED_LENGTH(0);

		goto double_quotes_scan_done;
	}

	if (YYCURSOR > YYLIMIT) {
		return 0;
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

double_quotes_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	zend_scan_escape_string(zendlval, yytext, yyleng, '"' TSRMLS_CC);
	return T_ENCAPSED_AND_WHITESPACE;
}
#line 1714 "Zend/zend_language_scanner.c"
yy79:
		YYDEBUG(79, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy83;
		goto yy78;
yy80:
		YYDEBUG(80, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(81, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1987 "Zend/zend_language_scanner.l"
		{
	BEGIN(ST_IN_SCRIPTING);
	return '"';
}
#line 1730 "Zend/zend_language_scanner.c"
yy82:
		YYDEBUG(82, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy78;
yy83:
		YYDEBUG(83, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(84, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1979 "Zend/zend_language_scanner.l"
		{
	zendlval->value.lval = (long) '{';
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	yyless(1);
	return T_CURLY_OPEN;
}
#line 1747 "Zend/zend_language_scanner.c"
yy85:
		YYDEBUG(85, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(86, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy85;
		}
		if (yych == '-') goto yy90;
		if (yych == '[') goto yy92;
yy87:
		YYDEBUG(87, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1677 "Zend/zend_language_scanner.l"
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
#line 1769 "Zend/zend_language_scanner.c"
yy88:
		YYDEBUG(88, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(89, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1300 "Zend/zend_language_scanner.l"
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME TSRMLS_CC);
	return T_DOLLAR_OPEN_CURLY_BRACES;
}
#line 1780 "Zend/zend_language_scanner.c"
yy90:
		YYDEBUG(90, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy94;
yy91:
		YYDEBUG(91, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy87;
yy92:
		YYDEBUG(92, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(93, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1669 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
#line 1802 "Zend/zend_language_scanner.c"
yy94:
		YYDEBUG(94, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy91;
			if (yych <= 'Z') goto yy95;
			if (yych <= '^') goto yy91;
		} else {
			if (yych <= '`') goto yy91;
			if (yych <= 'z') goto yy95;
			if (yych <= '~') goto yy91;
		}
yy95:
		YYDEBUG(95, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(96, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1659 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
#line 1828 "Zend/zend_language_scanner.c"
	}
/* *********************************** */
yyc_ST_END_HEREDOC:
	YYDEBUG(97, *YYCURSOR);
	YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(99, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(100, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
#line 1966 "Zend/zend_language_scanner.l"
	{
	YYCURSOR += CG(heredoc_len) - 1;
	yyleng = CG(heredoc_len);

	Z_STRVAL_P(zendlval) = CG(heredoc);
	Z_STRLEN_P(zendlval) = CG(heredoc_len);
	CG(heredoc) = NULL;
	CG(heredoc_len) = 0;
	BEGIN(ST_IN_SCRIPTING);
	return T_END_HEREDOC;
}
#line 1851 "Zend/zend_language_scanner.c"
/* *********************************** */
yyc_ST_HEREDOC:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(101, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych == '$') goto yy103;
		if (yych == '{') goto yy105;
		goto yy106;
yy103:
		YYDEBUG(103, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '_') {
			if (yych <= '@') goto yy104;
			if (yych <= 'Z') goto yy109;
			if (yych >= '_') goto yy109;
		} else {
			if (yych <= 'z') {
				if (yych >= 'a') goto yy109;
			} else {
				if (yych <= '{') goto yy112;
				if (yych >= 0x7F) goto yy109;
			}
		}
yy104:
		YYDEBUG(104, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2090 "Zend/zend_language_scanner.l"
		{
	int newline = 0;

	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && CG(heredoc_len) < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, CG(heredoc), CG(heredoc_len))) {
					YYCTYPE *end = YYCURSOR + CG(heredoc_len);

					if (*end == ';') {
						end++;
					}

					if (*end == '\n' || *end == '\r') {
						/* newline before label will be subtracted from returned text, but
						 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
						if (YYCURSOR[-2] == '\r' && YYCURSOR[-1] == '\n') {
							newline = 2; /* Windows newline */
						} else {
							newline = 1;
						}

						CG(increment_lineno) = 1; /* For newline before label */
						BEGIN(ST_END_HEREDOC);

						goto heredoc_scan_done;
					}
				}
				continue;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT && *YYCURSOR != '\n' && *YYCURSOR != '\r') {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

heredoc_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	zend_scan_escape_string(zendlval, yytext, yyleng - newline, 0 TSRMLS_CC);
	return T_ENCAPSED_AND_WHITESPACE;
}
#line 1984 "Zend/zend_language_scanner.c"
yy105:
		YYDEBUG(105, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy107;
		goto yy104;
yy106:
		YYDEBUG(106, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy104;
yy107:
		YYDEBUG(107, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(108, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1979 "Zend/zend_language_scanner.l"
		{
	zendlval->value.lval = (long) '{';
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	yyless(1);
	return T_CURLY_OPEN;
}
#line 2006 "Zend/zend_language_scanner.c"
yy109:
		YYDEBUG(109, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(110, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy109;
		}
		if (yych == '-') goto yy114;
		if (yych == '[') goto yy116;
yy111:
		YYDEBUG(111, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1677 "Zend/zend_language_scanner.l"
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
#line 2028 "Zend/zend_language_scanner.c"
yy112:
		YYDEBUG(112, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(113, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1300 "Zend/zend_language_scanner.l"
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME TSRMLS_CC);
	return T_DOLLAR_OPEN_CURLY_BRACES;
}
#line 2039 "Zend/zend_language_scanner.c"
yy114:
		YYDEBUG(114, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy118;
yy115:
		YYDEBUG(115, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy111;
yy116:
		YYDEBUG(116, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(117, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1669 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
#line 2061 "Zend/zend_language_scanner.c"
yy118:
		YYDEBUG(118, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy115;
			if (yych <= 'Z') goto yy119;
			if (yych <= '^') goto yy115;
		} else {
			if (yych <= '`') goto yy115;
			if (yych <= 'z') goto yy119;
			if (yych <= '~') goto yy115;
		}
yy119:
		YYDEBUG(119, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(120, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1659 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
#line 2087 "Zend/zend_language_scanner.c"
	}
/* *********************************** */
yyc_ST_IN_SCRIPTING:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0, 192,  64,   0,   0,  64,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			192,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 56,  56,  56,  56,  56,  56,  56,  56, 
			 56,  56,   0,   0,   0,   0,   0,   0, 
			  0,  40,  40,  40,  40,  40,  40,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   0,   0,   0,   0,   8, 
			  0,  40,  40,  40,  40,  40,  40,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   0,   0,   0,   0,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
			  8,   8,   8,   8,   8,   8,   8,   8, 
		};
		YYDEBUG(121, *YYCURSOR);
		YYFILL(16);
		yych = *YYCURSOR;
		YYDEBUG(-1, yych);
		switch (yych) {
		case 0x00:
		case 0x01:
		case 0x02:
		case 0x03:
		case 0x04:
		case 0x05:
		case 0x06:
		case 0x07:
		case 0x08:
		case '\v':
		case '\f':
		case 0x0E:
		case 0x0F:
		case 0x10:
		case 0x11:
		case 0x12:
		case 0x13:
		case 0x14:
		case 0x15:
		case 0x16:
		case 0x17:
		case 0x18:
		case 0x19:
		case 0x1A:
		case 0x1B:
		case 0x1C:
		case 0x1D:
		case 0x1E:
		case 0x1F:	goto yy183;
		case '\t':
		case '\n':
		case '\r':
		case ' ':	goto yy139;
		case '!':	goto yy152;
		case '"':	goto yy179;
		case '#':	goto yy175;
		case '$':	goto yy164;
		case '%':	goto yy158;
		case '&':	goto yy159;
		case '\'':	goto yy177;
		case '(':	goto yy146;
		case ')':
		case ',':
		case ';':
		case '@':
		case '[':
		case ']':
		case '~':	goto yy165;
		case '*':	goto yy155;
		case '+':	goto yy151;
		case '-':	goto yy137;
		case '.':	goto yy157;
		case '/':	goto yy156;
		case '0':	goto yy171;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':	goto yy173;
		case ':':	goto yy141;
		case '<':	goto yy153;
		case '=':	goto yy149;
		case '>':	goto yy154;
		case '?':	goto yy166;
		case 'A':
		case 'a':	goto yy132;
		case 'B':
		case 'b':	goto yy134;
		case 'C':
		case 'c':	goto yy127;
		case 'D':
		case 'd':	goto yy125;
		case 'E':
		case 'e':	goto yy123;
		case 'F':
		case 'f':	goto yy126;
		case 'G':
		case 'g':	goto yy135;
		case 'I':
		case 'i':	goto yy130;
		case 'L':
		case 'l':	goto yy150;
		case 'N':
		case 'n':	goto yy144;
		case 'O':
		case 'o':	goto yy162;
		case 'P':
		case 'p':	goto yy136;
		case 'R':
		case 'r':	goto yy128;
		case 'S':
		case 's':	goto yy133;
		case 'T':
		case 't':	goto yy129;
		case 'U':
		case 'u':	goto yy147;
		case 'V':
		case 'v':	goto yy145;
		case 'W':
		case 'w':	goto yy131;
		case 'X':
		case 'x':	goto yy163;
		case '\\':	goto yy142;
		case '^':	goto yy161;
		case '_':	goto yy148;
		case '`':	goto yy181;
		case '{':	goto yy167;
		case '|':	goto yy160;
		case '}':	goto yy169;
		default:	goto yy174;
		}
yy123:
		YYDEBUG(123, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(-1, yych);
		switch ((yych = *YYCURSOR)) {
		case 'C':
		case 'c':	goto yy701;
		case 'L':
		case 'l':	goto yy702;
		case 'M':
		case 'm':	goto yy703;
		case 'N':
		case 'n':	goto yy704;
		case 'V':
		case 'v':	goto yy705;
		case 'X':
		case 'x':	goto yy706;
		default:	goto yy186;
		}
yy124:
		YYDEBUG(124, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1700 "Zend/zend_language_scanner.l"
		{
	zend_copy_value(zendlval, yytext, yyleng);
	zendlval->type = IS_STRING;
	return T_STRING;
}
#line 2274 "Zend/zend_language_scanner.c"
yy125:
		YYDEBUG(125, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych <= 'H') {
				if (yych == 'E') goto yy683;
				goto yy186;
			} else {
				if (yych <= 'I') goto yy684;
				if (yych <= 'N') goto yy186;
				goto yy685;
			}
		} else {
			if (yych <= 'h') {
				if (yych == 'e') goto yy683;
				goto yy186;
			} else {
				if (yych <= 'i') goto yy684;
				if (yych == 'o') goto yy685;
				goto yy186;
			}
		}
yy126:
		YYDEBUG(126, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'U') {
			if (yych <= 'N') {
				if (yych == 'I') goto yy662;
				goto yy186;
			} else {
				if (yych <= 'O') goto yy663;
				if (yych <= 'T') goto yy186;
				goto yy664;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'i') goto yy662;
				goto yy186;
			} else {
				if (yych <= 'o') goto yy663;
				if (yych == 'u') goto yy664;
				goto yy186;
			}
		}
yy127:
		YYDEBUG(127, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych <= 'K') {
				if (yych == 'A') goto yy634;
				goto yy186;
			} else {
				if (yych <= 'L') goto yy635;
				if (yych <= 'N') goto yy186;
				goto yy636;
			}
		} else {
			if (yych <= 'k') {
				if (yych == 'a') goto yy634;
				goto yy186;
			} else {
				if (yych <= 'l') goto yy635;
				if (yych == 'o') goto yy636;
				goto yy186;
			}
		}
yy128:
		YYDEBUG(128, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy616;
		if (yych == 'e') goto yy616;
		goto yy186;
yy129:
		YYDEBUG(129, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'R') {
			if (yych == 'H') goto yy608;
			if (yych <= 'Q') goto yy186;
			goto yy609;
		} else {
			if (yych <= 'h') {
				if (yych <= 'g') goto yy186;
				goto yy608;
			} else {
				if (yych == 'r') goto yy609;
				goto yy186;
			}
		}
yy130:
		YYDEBUG(130, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'S') {
			if (yych <= 'L') {
				if (yych == 'F') goto yy561;
				goto yy186;
			} else {
				if (yych <= 'M') goto yy563;
				if (yych <= 'N') goto yy564;
				if (yych <= 'R') goto yy186;
				goto yy565;
			}
		} else {
			if (yych <= 'm') {
				if (yych == 'f') goto yy561;
				if (yych <= 'l') goto yy186;
				goto yy563;
			} else {
				if (yych <= 'n') goto yy564;
				if (yych == 's') goto yy565;
				goto yy186;
			}
		}
yy131:
		YYDEBUG(131, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy556;
		if (yych == 'h') goto yy556;
		goto yy186;
yy132:
		YYDEBUG(132, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'S') {
			if (yych <= 'M') {
				if (yych == 'B') goto yy538;
				goto yy186;
			} else {
				if (yych <= 'N') goto yy539;
				if (yych <= 'Q') goto yy186;
				if (yych <= 'R') goto yy540;
				goto yy541;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'b') goto yy538;
				if (yych <= 'm') goto yy186;
				goto yy539;
			} else {
				if (yych <= 'q') goto yy186;
				if (yych <= 'r') goto yy540;
				if (yych <= 's') goto yy541;
				goto yy186;
			}
		}
yy133:
		YYDEBUG(133, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'W') {
			if (yych == 'T') goto yy526;
			if (yych <= 'V') goto yy186;
			goto yy527;
		} else {
			if (yych <= 't') {
				if (yych <= 's') goto yy186;
				goto yy526;
			} else {
				if (yych == 'w') goto yy527;
				goto yy186;
			}
		}
yy134:
		YYDEBUG(134, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') {
			if (yych <= '"') {
				if (yych <= '!') goto yy186;
				goto yy518;
			} else {
				if (yych == '\'') goto yy519;
				goto yy186;
			}
		} else {
			if (yych <= 'R') {
				if (yych <= '<') goto yy517;
				if (yych <= 'Q') goto yy186;
				goto yy520;
			} else {
				if (yych == 'r') goto yy520;
				goto yy186;
			}
		}
yy135:
		YYDEBUG(135, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'L') goto yy507;
			if (yych <= 'N') goto yy186;
			goto yy508;
		} else {
			if (yych <= 'l') {
				if (yych <= 'k') goto yy186;
				goto yy507;
			} else {
				if (yych == 'o') goto yy508;
				goto yy186;
			}
		}
yy136:
		YYDEBUG(136, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'U') {
			if (yych == 'R') goto yy483;
			if (yych <= 'T') goto yy186;
			goto yy484;
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy186;
				goto yy483;
			} else {
				if (yych == 'u') goto yy484;
				goto yy186;
			}
		}
yy137:
		YYDEBUG(137, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '<') {
			if (yych == '-') goto yy479;
		} else {
			if (yych <= '=') goto yy477;
			if (yych <= '>') goto yy481;
		}
yy138:
		YYDEBUG(138, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1289 "Zend/zend_language_scanner.l"
		{
	return yytext[0];
}
#line 2504 "Zend/zend_language_scanner.c"
yy139:
		YYDEBUG(139, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy476;
yy140:
		YYDEBUG(140, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1024 "Zend/zend_language_scanner.l"
		{
	zendlval->value.str.val = yytext; /* no copying - intentional */
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	HANDLE_NEWLINES(yytext, yyleng);
	return T_WHITESPACE;
}
#line 2521 "Zend/zend_language_scanner.c"
yy141:
		YYDEBUG(141, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == ':') goto yy473;
		goto yy138;
yy142:
		YYDEBUG(142, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(143, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1053 "Zend/zend_language_scanner.l"
		{
	return T_NS_SEPARATOR;
}
#line 2536 "Zend/zend_language_scanner.c"
yy144:
		YYDEBUG(144, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'E') {
			if (yych == 'A') goto yy461;
			if (yych <= 'D') goto yy186;
			goto yy462;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy186;
				goto yy461;
			} else {
				if (yych == 'e') goto yy462;
				goto yy186;
			}
		}
yy145:
		YYDEBUG(145, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy458;
		if (yych == 'a') goto yy458;
		goto yy186;
yy146:
		YYDEBUG(146, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'S') {
			if (yych <= 'D') {
				if (yych <= ' ') {
					if (yych == '\t') goto yy379;
					if (yych <= 0x1F) goto yy138;
					goto yy379;
				} else {
					if (yych <= '@') goto yy138;
					if (yych == 'C') goto yy138;
					goto yy379;
				}
			} else {
				if (yych <= 'I') {
					if (yych == 'F') goto yy379;
					if (yych <= 'H') goto yy138;
					goto yy379;
				} else {
					if (yych == 'O') goto yy379;
					if (yych <= 'Q') goto yy138;
					goto yy379;
				}
			}
		} else {
			if (yych <= 'f') {
				if (yych <= 'b') {
					if (yych == 'U') goto yy379;
					if (yych <= '`') goto yy138;
					goto yy379;
				} else {
					if (yych == 'd') goto yy379;
					if (yych <= 'e') goto yy138;
					goto yy379;
				}
			} else {
				if (yych <= 'o') {
					if (yych == 'i') goto yy379;
					if (yych <= 'n') goto yy138;
					goto yy379;
				} else {
					if (yych <= 's') {
						if (yych <= 'q') goto yy138;
						goto yy379;
					} else {
						if (yych == 'u') goto yy379;
						goto yy138;
					}
				}
			}
		}
yy147:
		YYDEBUG(147, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'S') {
			if (yych == 'N') goto yy370;
			if (yych <= 'R') goto yy186;
			goto yy371;
		} else {
			if (yych <= 'n') {
				if (yych <= 'm') goto yy186;
				goto yy370;
			} else {
				if (yych == 's') goto yy371;
				goto yy186;
			}
		}
yy148:
		YYDEBUG(148, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy296;
		goto yy186;
yy149:
		YYDEBUG(149, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy138;
		if (yych <= '=') goto yy290;
		if (yych <= '>') goto yy292;
		goto yy138;
yy150:
		YYDEBUG(150, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy286;
		if (yych == 'i') goto yy286;
		goto yy186;
yy151:
		YYDEBUG(151, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '+') goto yy284;
		if (yych == '=') goto yy282;
		goto yy138;
yy152:
		YYDEBUG(152, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy279;
		goto yy138;
yy153:
		YYDEBUG(153, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') {
			if (yych == '/') goto yy251;
			goto yy138;
		} else {
			if (yych <= '<') goto yy249;
			if (yych <= '=') goto yy252;
			if (yych <= '>') goto yy254;
			goto yy138;
		}
yy154:
		YYDEBUG(154, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy138;
		if (yych <= '=') goto yy245;
		if (yych <= '>') goto yy243;
		goto yy138;
yy155:
		YYDEBUG(155, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy241;
		goto yy138;
yy156:
		YYDEBUG(156, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '.') {
			if (yych == '*') goto yy233;
			goto yy138;
		} else {
			if (yych <= '/') goto yy235;
			if (yych == '=') goto yy236;
			goto yy138;
		}
yy157:
		YYDEBUG(157, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '/') goto yy138;
		if (yych <= '9') goto yy229;
		if (yych == '=') goto yy231;
		goto yy138;
yy158:
		YYDEBUG(158, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy138;
		if (yych <= '=') goto yy225;
		if (yych <= '>') goto yy223;
		goto yy138;
yy159:
		YYDEBUG(159, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '&') goto yy219;
		if (yych == '=') goto yy221;
		goto yy138;
yy160:
		YYDEBUG(160, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy217;
		if (yych == '|') goto yy215;
		goto yy138;
yy161:
		YYDEBUG(161, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy213;
		goto yy138;
yy162:
		YYDEBUG(162, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy211;
		if (yych == 'r') goto yy211;
		goto yy186;
yy163:
		YYDEBUG(163, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy208;
		if (yych == 'o') goto yy208;
		goto yy186;
yy164:
		YYDEBUG(164, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy138;
			if (yych <= 'Z') goto yy205;
			if (yych <= '^') goto yy138;
			goto yy205;
		} else {
			if (yych <= '`') goto yy138;
			if (yych <= 'z') goto yy205;
			if (yych <= '~') goto yy138;
			goto yy205;
		}
yy165:
		YYDEBUG(165, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy138;
yy166:
		YYDEBUG(166, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy201;
		goto yy138;
yy167:
		YYDEBUG(167, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(168, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1294 "Zend/zend_language_scanner.l"
		{
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	return '{';
}
#line 2769 "Zend/zend_language_scanner.c"
yy169:
		YYDEBUG(169, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(170, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1306 "Zend/zend_language_scanner.l"
		{
	RESET_DOC_COMMENT();
	if (!zend_stack_is_empty(&SCNG(state_stack))) {
		yy_pop_state(TSRMLS_C);
	}
	return '}';
}
#line 2783 "Zend/zend_language_scanner.c"
yy171:
		YYDEBUG(171, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'E') {
			if (yych <= '/') {
				if (yych == '.') goto yy187;
			} else {
				if (yych <= '9') goto yy190;
				if (yych >= 'E') goto yy192;
			}
		} else {
			if (yych <= 'd') {
				if (yych == 'X') goto yy197;
			} else {
				if (yych <= 'e') goto yy192;
				if (yych == 'x') goto yy197;
			}
		}
yy172:
		YYDEBUG(172, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1332 "Zend/zend_language_scanner.l"
		{
	if (yyleng < MAX_LENGTH_OF_LONG - 1) { /* Won't overflow */
		zendlval->value.lval = strtol(yytext, NULL, 0);
	} else {
		errno = 0;
		zendlval->value.lval = strtol(yytext, NULL, 0);
		if (errno == ERANGE) { /* Overflow */
			if (yytext[0] == '0') { /* octal overflow */
				zendlval->value.dval = zend_oct_strtod(yytext, NULL);
			} else {
				zendlval->value.dval = zend_strtod(yytext, NULL);
			}
			zendlval->type = IS_DOUBLE;
			return T_DNUMBER;
		}
	}

	zendlval->type = IS_LONG;
	return T_LNUMBER;
}
#line 2827 "Zend/zend_language_scanner.c"
yy173:
		YYDEBUG(173, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '9') {
			if (yych == '.') goto yy187;
			if (yych <= '/') goto yy172;
			goto yy190;
		} else {
			if (yych <= 'E') {
				if (yych <= 'D') goto yy172;
				goto yy192;
			} else {
				if (yych == 'e') goto yy192;
				goto yy172;
			}
		}
yy174:
		YYDEBUG(174, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy186;
yy175:
		YYDEBUG(175, *YYCURSOR);
		++YYCURSOR;
yy176:
		YYDEBUG(176, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1707 "Zend/zend_language_scanner.l"
		{
	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				CG(zend_lineno)++;
				break;
			case '%':
				if (!CG(asp_tags)) {
					continue;
				}
				/* fall through */
			case '?':
				if (*YYCURSOR == '>') {
					YYCURSOR--;
					break;
				}
				/* fall through */
			default:
				continue;
		}

		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	return T_COMMENT;
}
#line 2889 "Zend/zend_language_scanner.c"
yy177:
		YYDEBUG(177, *YYCURSOR);
		++YYCURSOR;
yy178:
		YYDEBUG(178, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1798 "Zend/zend_language_scanner.l"
		{
	register char *s, *t;
	char *end;
	int bprefix = (yytext[0] != '\'') ? 1 : 0;

	while (1) {
		if (YYCURSOR < YYLIMIT) {
			if (*YYCURSOR == '\'') {
				YYCURSOR++;
				yyleng = YYCURSOR - SCNG(yy_text);

				break;
			} else if (*YYCURSOR++ == '\\' && YYCURSOR < YYLIMIT) {
				YYCURSOR++;
			}
		} else {
			yyleng = YYLIMIT - SCNG(yy_text);

			/* Unclosed single quotes; treat similar to double quotes, but without a separate token
			 * for ' (unrecognized by parser), instead of old flex fallback to "Unexpected character..."
			 * rule, which continued in ST_IN_SCRIPTING state after the quote */
			return T_ENCAPSED_AND_WHITESPACE;
		}
	}

	zendlval->value.str.val = estrndup(yytext+bprefix+1, yyleng-bprefix-2);
	zendlval->value.str.len = yyleng-bprefix-2;
	zendlval->type = IS_STRING;

	/* convert escape sequences */
	s = t = zendlval->value.str.val;
	end = s+zendlval->value.str.len;
	while (s<end) {
		if (*s=='\\') {
			s++;

			switch(*s) {
				case '\\':
				case '\'':
					*t++ = *s;
					zendlval->value.str.len--;
					break;
				default:
					*t++ = '\\';
					*t++ = *s;
					break;
			}
		} else {
			*t++ = *s;
		}

		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;

#ifdef ZEND_MULTIBYTE
	if (SCNG(output_filter)) {
		size_t sz = 0;
		s = zendlval->value.str.val;
		SCNG(output_filter)((unsigned char **)&(zendlval->value.str.val), &sz, (unsigned char *)s, (size_t)zendlval->value.str.len TSRMLS_CC);
		zendlval->value.str.len = sz;
		efree(s);
	}
#endif /* ZEND_MULTIBYTE */
	return T_CONSTANT_ENCAPSED_STRING;
}
#line 2966 "Zend/zend_language_scanner.c"
yy179:
		YYDEBUG(179, *YYCURSOR);
		++YYCURSOR;
yy180:
		YYDEBUG(180, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1869 "Zend/zend_language_scanner.l"
		{
	int bprefix = (yytext[0] != '"') ? 1 : 0;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				yyleng = YYCURSOR - SCNG(yy_text);
				zend_scan_escape_string(zendlval, yytext+bprefix+1, yyleng-bprefix-2, '"' TSRMLS_CC);
				return T_CONSTANT_ENCAPSED_STRING;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	/* Remember how much was scanned to save rescanning */
	SET_DOUBLE_QUOTES_SCANNED_LENGTH(YYCURSOR - SCNG(yy_text) - yyleng);

	YYCURSOR = SCNG(yy_text) + yyleng;

	BEGIN(ST_DOUBLE_QUOTES);
	return '"';
}
#line 3014 "Zend/zend_language_scanner.c"
yy181:
		YYDEBUG(181, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(182, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1960 "Zend/zend_language_scanner.l"
		{
	BEGIN(ST_BACKQUOTE);
	return '`';
}
#line 3025 "Zend/zend_language_scanner.c"
yy183:
		YYDEBUG(183, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(184, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2218 "Zend/zend_language_scanner.l"
		{
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	zend_error(E_COMPILE_WARNING,"Unexpected character in input:  '%c' (ASCII=%d) state=%d", yytext[0], yytext[0], YYSTATE);
	goto restart;
}
#line 3040 "Zend/zend_language_scanner.c"
yy185:
		YYDEBUG(185, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy186:
		YYDEBUG(186, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy185;
		}
		goto yy124;
yy187:
		YYDEBUG(187, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(188, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy187;
		}
		if (yych == 'E') goto yy192;
		if (yych == 'e') goto yy192;
yy189:
		YYDEBUG(189, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1397 "Zend/zend_language_scanner.l"
		{
	zendlval->value.dval = zend_strtod(yytext, NULL);
	zendlval->type = IS_DOUBLE;
	return T_DNUMBER;
}
#line 3073 "Zend/zend_language_scanner.c"
yy190:
		YYDEBUG(190, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(191, *YYCURSOR);
		if (yych <= '9') {
			if (yych == '.') goto yy187;
			if (yych <= '/') goto yy172;
			goto yy190;
		} else {
			if (yych <= 'E') {
				if (yych <= 'D') goto yy172;
			} else {
				if (yych != 'e') goto yy172;
			}
		}
yy192:
		YYDEBUG(192, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= ',') {
			if (yych == '+') goto yy194;
		} else {
			if (yych <= '-') goto yy194;
			if (yych <= '/') goto yy193;
			if (yych <= '9') goto yy195;
		}
yy193:
		YYDEBUG(193, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 2) {
			if (yyaccept <= 1) {
				if (yyaccept <= 0) {
					goto yy124;
				} else {
					goto yy138;
				}
			} else {
				goto yy172;
			}
		} else {
			if (yyaccept <= 4) {
				if (yyaccept <= 3) {
					goto yy189;
				} else {
					goto yy234;
				}
			} else {
				goto yy250;
			}
		}
yy194:
		YYDEBUG(194, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '/') goto yy193;
		if (yych >= ':') goto yy193;
yy195:
		YYDEBUG(195, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(196, *YYCURSOR);
		if (yych <= '/') goto yy189;
		if (yych <= '9') goto yy195;
		goto yy189;
yy197:
		YYDEBUG(197, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 32) {
			goto yy198;
		}
		goto yy193;
yy198:
		YYDEBUG(198, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(199, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy198;
		}
		YYDEBUG(200, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1353 "Zend/zend_language_scanner.l"
		{
	char *hex = yytext + 2; /* Skip "0x" */
	int len = yyleng - 2;

	/* Skip any leading 0s */
	while (*hex == '0') {
		hex++;
		len--;
	}

	if (len < SIZEOF_LONG * 2 || (len == SIZEOF_LONG * 2 && *hex <= '7')) {
		if (len == 0) {
			zendlval->value.lval = 0;
		} else {
			zendlval->value.lval = strtol(hex, NULL, 16);
		}
		zendlval->type = IS_LONG;
		return T_LNUMBER;
	} else {
		zendlval->value.dval = zend_hex_strtod(hex, NULL);
		zendlval->type = IS_DOUBLE;
		return T_DNUMBER;
	}
}
#line 3183 "Zend/zend_language_scanner.c"
yy201:
		YYDEBUG(201, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '\n') goto yy203;
		if (yych == '\r') goto yy204;
yy202:
		YYDEBUG(202, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1775 "Zend/zend_language_scanner.l"
		{
	zendlval->value.str.val = yytext; /* no copying - intentional */
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	BEGIN(INITIAL);
	return T_CLOSE_TAG;  /* implicit ';' at php-end tag */
}
#line 3200 "Zend/zend_language_scanner.c"
yy203:
		YYDEBUG(203, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy202;
yy204:
		YYDEBUG(204, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy203;
		goto yy202;
yy205:
		YYDEBUG(205, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(206, *YYCURSOR);
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy205;
			} else {
				if (yych <= '@') goto yy207;
				if (yych <= 'Z') goto yy205;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy205;
			} else {
				if (yych <= 'z') goto yy205;
				if (yych >= 0x7F) goto yy205;
			}
		}
yy207:
		YYDEBUG(207, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1677 "Zend/zend_language_scanner.l"
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
#line 3240 "Zend/zend_language_scanner.c"
yy208:
		YYDEBUG(208, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy209;
		if (yych != 'r') goto yy186;
yy209:
		YYDEBUG(209, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(210, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1277 "Zend/zend_language_scanner.l"
		{
	return T_LOGICAL_XOR;
}
#line 3258 "Zend/zend_language_scanner.c"
yy211:
		YYDEBUG(211, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(212, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1269 "Zend/zend_language_scanner.l"
		{
	return T_LOGICAL_OR;
}
#line 3271 "Zend/zend_language_scanner.c"
yy213:
		YYDEBUG(213, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(214, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1257 "Zend/zend_language_scanner.l"
		{
	return T_XOR_EQUAL;
}
#line 3281 "Zend/zend_language_scanner.c"
yy215:
		YYDEBUG(215, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(216, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1261 "Zend/zend_language_scanner.l"
		{
	return T_BOOLEAN_OR;
}
#line 3291 "Zend/zend_language_scanner.c"
yy217:
		YYDEBUG(217, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(218, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1253 "Zend/zend_language_scanner.l"
		{
	return T_OR_EQUAL;
}
#line 3301 "Zend/zend_language_scanner.c"
yy219:
		YYDEBUG(219, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(220, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1265 "Zend/zend_language_scanner.l"
		{
	return T_BOOLEAN_AND;
}
#line 3311 "Zend/zend_language_scanner.c"
yy221:
		YYDEBUG(221, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(222, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1249 "Zend/zend_language_scanner.l"
		{
	return T_AND_EQUAL;
}
#line 3321 "Zend/zend_language_scanner.c"
yy223:
		YYDEBUG(223, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '\n') goto yy227;
		if (yych == '\r') goto yy228;
yy224:
		YYDEBUG(224, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1784 "Zend/zend_language_scanner.l"
		{
	if (CG(asp_tags)) {
		BEGIN(INITIAL);
		zendlval->value.str.len = yyleng;
		zendlval->type = IS_STRING;
		zendlval->value.str.val = yytext; /* no copying - intentional */
		return T_CLOSE_TAG;  /* implicit ';' at php-end tag */
	} else {
		yyless(1);
		return yytext[0];
	}
}
#line 3343 "Zend/zend_language_scanner.c"
yy225:
		YYDEBUG(225, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(226, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1237 "Zend/zend_language_scanner.l"
		{
	return T_MOD_EQUAL;
}
#line 3353 "Zend/zend_language_scanner.c"
yy227:
		YYDEBUG(227, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy224;
yy228:
		YYDEBUG(228, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy227;
		goto yy224;
yy229:
		YYDEBUG(229, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(230, *YYCURSOR);
		if (yych <= 'D') {
			if (yych <= '/') goto yy189;
			if (yych <= '9') goto yy229;
			goto yy189;
		} else {
			if (yych <= 'E') goto yy192;
			if (yych == 'e') goto yy192;
			goto yy189;
		}
yy231:
		YYDEBUG(231, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(232, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1233 "Zend/zend_language_scanner.l"
		{
	return T_CONCAT_EQUAL;
}
#line 3388 "Zend/zend_language_scanner.c"
yy233:
		YYDEBUG(233, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '*') goto yy238;
yy234:
		YYDEBUG(234, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1741 "Zend/zend_language_scanner.l"
		{
	int doc_com;

	if (yyleng > 2) {
		doc_com = 1;
		RESET_DOC_COMMENT();
	} else {
		doc_com = 0;
	}

	while (YYCURSOR < YYLIMIT) {
		if (*YYCURSOR++ == '*' && *YYCURSOR == '/') {
			break;
		}
	}

	if (YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	} else {
		zend_error(E_COMPILE_WARNING, "Unterminated comment starting line %d", CG(zend_lineno));
	}

	yyleng = YYCURSOR - SCNG(yy_text);
	HANDLE_NEWLINES(yytext, yyleng);

	if (doc_com) {
		CG(doc_comment) = estrndup(yytext, yyleng);
		CG(doc_comment_len) = yyleng;
		return T_DOC_COMMENT;
	}

	return T_COMMENT;
}
#line 3431 "Zend/zend_language_scanner.c"
yy235:
		YYDEBUG(235, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy176;
yy236:
		YYDEBUG(236, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(237, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1229 "Zend/zend_language_scanner.l"
		{
	return T_DIV_EQUAL;
}
#line 3445 "Zend/zend_language_scanner.c"
yy238:
		YYDEBUG(238, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy239;
		}
		goto yy193;
yy239:
		YYDEBUG(239, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(240, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy239;
		}
		goto yy234;
yy241:
		YYDEBUG(241, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(242, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1225 "Zend/zend_language_scanner.l"
		{
	return T_MUL_EQUAL;
}
#line 3472 "Zend/zend_language_scanner.c"
yy243:
		YYDEBUG(243, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '=') goto yy247;
		YYDEBUG(244, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1285 "Zend/zend_language_scanner.l"
		{
	return T_SR;
}
#line 3483 "Zend/zend_language_scanner.c"
yy245:
		YYDEBUG(245, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(246, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1213 "Zend/zend_language_scanner.l"
		{
	return T_IS_GREATER_OR_EQUAL;
}
#line 3493 "Zend/zend_language_scanner.c"
yy247:
		YYDEBUG(247, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(248, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1245 "Zend/zend_language_scanner.l"
		{
	return T_SR_EQUAL;
}
#line 3503 "Zend/zend_language_scanner.c"
yy249:
		YYDEBUG(249, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') goto yy250;
		if (yych <= '<') goto yy265;
		if (yych <= '=') goto yy263;
yy250:
		YYDEBUG(250, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1281 "Zend/zend_language_scanner.l"
		{
	return T_SL;
}
#line 3518 "Zend/zend_language_scanner.c"
yy251:
		YYDEBUG(251, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy256;
		if (yych == 's') goto yy256;
		goto yy193;
yy252:
		YYDEBUG(252, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(253, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1209 "Zend/zend_language_scanner.l"
		{
	return T_IS_SMALLER_OR_EQUAL;
}
#line 3534 "Zend/zend_language_scanner.c"
yy254:
		YYDEBUG(254, *YYCURSOR);
		++YYCURSOR;
yy255:
		YYDEBUG(255, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1205 "Zend/zend_language_scanner.l"
		{
	return T_IS_NOT_EQUAL;
}
#line 3545 "Zend/zend_language_scanner.c"
yy256:
		YYDEBUG(256, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy257;
		if (yych != 'c') goto yy193;
yy257:
		YYDEBUG(257, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy258;
		if (yych != 'r') goto yy193;
yy258:
		YYDEBUG(258, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy259;
		if (yych != 'i') goto yy193;
yy259:
		YYDEBUG(259, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy260;
		if (yych != 'p') goto yy193;
yy260:
		YYDEBUG(260, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy261;
		if (yych != 't') goto yy193;
yy261:
		YYDEBUG(261, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(262, *YYCURSOR);
		if (yych <= '\r') {
			if (yych <= 0x08) goto yy193;
			if (yych <= '\n') goto yy261;
			if (yych <= '\f') goto yy193;
			goto yy261;
		} else {
			if (yych <= ' ') {
				if (yych <= 0x1F) goto yy193;
				goto yy261;
			} else {
				if (yych == '>') goto yy201;
				goto yy193;
			}
		}
yy263:
		YYDEBUG(263, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(264, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1241 "Zend/zend_language_scanner.l"
		{
	return T_SL_EQUAL;
}
#line 3600 "Zend/zend_language_scanner.c"
yy265:
		YYDEBUG(265, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(266, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy265;
		}
		if (yych <= 'Z') {
			if (yych <= '&') {
				if (yych == '"') goto yy270;
				goto yy193;
			} else {
				if (yych <= '\'') goto yy269;
				if (yych <= '@') goto yy193;
			}
		} else {
			if (yych <= '`') {
				if (yych != '_') goto yy193;
			} else {
				if (yych <= 'z') goto yy267;
				if (yych <= '~') goto yy193;
			}
		}
yy267:
		YYDEBUG(267, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(268, *YYCURSOR);
		if (yych <= '@') {
			if (yych <= '\f') {
				if (yych == '\n') goto yy274;
				goto yy193;
			} else {
				if (yych <= '\r') goto yy276;
				if (yych <= '/') goto yy193;
				if (yych <= '9') goto yy267;
				goto yy193;
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'Z') goto yy267;
				if (yych <= '^') goto yy193;
				goto yy267;
			} else {
				if (yych <= '`') goto yy193;
				if (yych <= 'z') goto yy267;
				if (yych <= '~') goto yy193;
				goto yy267;
			}
		}
yy269:
		YYDEBUG(269, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\'') goto yy193;
		if (yych <= '/') goto yy278;
		if (yych <= '9') goto yy193;
		goto yy278;
yy270:
		YYDEBUG(270, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '"') goto yy193;
		if (yych <= '/') goto yy272;
		if (yych <= '9') goto yy193;
		goto yy272;
yy271:
		YYDEBUG(271, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy272:
		YYDEBUG(272, *YYCURSOR);
		if (yych <= 'Z') {
			if (yych <= '/') {
				if (yych != '"') goto yy193;
			} else {
				if (yych <= '9') goto yy271;
				if (yych <= '@') goto yy193;
				goto yy271;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy271;
				goto yy193;
			} else {
				if (yych <= 'z') goto yy271;
				if (yych <= '~') goto yy193;
				goto yy271;
			}
		}
yy273:
		YYDEBUG(273, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy274;
		if (yych == '\r') goto yy276;
		goto yy193;
yy274:
		YYDEBUG(274, *YYCURSOR);
		++YYCURSOR;
yy275:
		YYDEBUG(275, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1911 "Zend/zend_language_scanner.l"
		{
	char *s;
	int bprefix = (yytext[0] != '<') ? 1 : 0;

	/* save old heredoc label */
	Z_STRVAL_P(zendlval) = CG(heredoc);
	Z_STRLEN_P(zendlval) = CG(heredoc_len);

	CG(zend_lineno)++;
	CG(heredoc_len) = yyleng-bprefix-3-1-(yytext[yyleng-2]=='\r'?1:0);
	s = yytext+bprefix+3;
	while ((*s == ' ') || (*s == '\t')) {
		s++;
		CG(heredoc_len)--;
	}

	if (*s == '\'') {
		s++;
		CG(heredoc_len) -= 2;

		BEGIN(ST_NOWDOC);
	} else {
		if (*s == '"') {
			s++;
			CG(heredoc_len) -= 2;
		}

		BEGIN(ST_HEREDOC);
	}

	CG(heredoc) = estrndup(s, CG(heredoc_len));

	/* Check for ending label on the next line */
	if (CG(heredoc_len) < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, s, CG(heredoc_len))) {
		YYCTYPE *end = YYCURSOR + CG(heredoc_len);

		if (*end == ';') {
			end++;
		}

		if (*end == '\n' || *end == '\r') {
			BEGIN(ST_END_HEREDOC);
		}
	}

	return T_START_HEREDOC;
}
#line 3753 "Zend/zend_language_scanner.c"
yy276:
		YYDEBUG(276, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy274;
		goto yy275;
yy277:
		YYDEBUG(277, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy278:
		YYDEBUG(278, *YYCURSOR);
		if (yych <= 'Z') {
			if (yych <= '/') {
				if (yych == '\'') goto yy273;
				goto yy193;
			} else {
				if (yych <= '9') goto yy277;
				if (yych <= '@') goto yy193;
				goto yy277;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy277;
				goto yy193;
			} else {
				if (yych <= 'z') goto yy277;
				if (yych <= '~') goto yy193;
				goto yy277;
			}
		}
yy279:
		YYDEBUG(279, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '=') goto yy255;
		YYDEBUG(280, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(281, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1197 "Zend/zend_language_scanner.l"
		{
	return T_IS_NOT_IDENTICAL;
}
#line 3797 "Zend/zend_language_scanner.c"
yy282:
		YYDEBUG(282, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(283, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1217 "Zend/zend_language_scanner.l"
		{
	return T_PLUS_EQUAL;
}
#line 3807 "Zend/zend_language_scanner.c"
yy284:
		YYDEBUG(284, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(285, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1185 "Zend/zend_language_scanner.l"
		{
	return T_INC;
}
#line 3817 "Zend/zend_language_scanner.c"
yy286:
		YYDEBUG(286, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy287;
		if (yych != 's') goto yy186;
yy287:
		YYDEBUG(287, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy288;
		if (yych != 't') goto yy186;
yy288:
		YYDEBUG(288, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(289, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1177 "Zend/zend_language_scanner.l"
		{
	return T_LIST;
}
#line 3840 "Zend/zend_language_scanner.c"
yy290:
		YYDEBUG(290, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '=') goto yy294;
		YYDEBUG(291, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1201 "Zend/zend_language_scanner.l"
		{
	return T_IS_EQUAL;
}
#line 3851 "Zend/zend_language_scanner.c"
yy292:
		YYDEBUG(292, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(293, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1173 "Zend/zend_language_scanner.l"
		{
	return T_DOUBLE_ARROW;
}
#line 3861 "Zend/zend_language_scanner.c"
yy294:
		YYDEBUG(294, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(295, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1193 "Zend/zend_language_scanner.l"
		{
	return T_IS_IDENTICAL;
}
#line 3871 "Zend/zend_language_scanner.c"
yy296:
		YYDEBUG(296, *YYCURSOR);
		yych = *++YYCURSOR;
		YYDEBUG(-1, yych);
		switch (yych) {
		case 'C':
		case 'c':	goto yy298;
		case 'D':
		case 'd':	goto yy302;
		case 'F':
		case 'f':	goto yy299;
		case 'H':
		case 'h':	goto yy297;
		case 'L':
		case 'l':	goto yy301;
		case 'M':
		case 'm':	goto yy300;
		case 'N':
		case 'n':	goto yy303;
		default:	goto yy186;
		}
yy297:
		YYDEBUG(297, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy357;
		if (yych == 'a') goto yy357;
		goto yy186;
yy298:
		YYDEBUG(298, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy350;
		if (yych == 'l') goto yy350;
		goto yy186;
yy299:
		YYDEBUG(299, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'U') {
			if (yych == 'I') goto yy334;
			if (yych <= 'T') goto yy186;
			goto yy335;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy186;
				goto yy334;
			} else {
				if (yych == 'u') goto yy335;
				goto yy186;
			}
		}
yy300:
		YYDEBUG(300, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy326;
		if (yych == 'e') goto yy326;
		goto yy186;
yy301:
		YYDEBUG(301, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy320;
		if (yych == 'i') goto yy320;
		goto yy186;
yy302:
		YYDEBUG(302, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy315;
		if (yych == 'i') goto yy315;
		goto yy186;
yy303:
		YYDEBUG(303, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy304;
		if (yych != 'a') goto yy186;
yy304:
		YYDEBUG(304, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy305;
		if (yych != 'm') goto yy186;
yy305:
		YYDEBUG(305, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy306;
		if (yych != 'e') goto yy186;
yy306:
		YYDEBUG(306, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy307;
		if (yych != 's') goto yy186;
yy307:
		YYDEBUG(307, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy308;
		if (yych != 'p') goto yy186;
yy308:
		YYDEBUG(308, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy309;
		if (yych != 'a') goto yy186;
yy309:
		YYDEBUG(309, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy310;
		if (yych != 'c') goto yy186;
yy310:
		YYDEBUG(310, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy311;
		if (yych != 'e') goto yy186;
yy311:
		YYDEBUG(311, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(312, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(313, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(314, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1501 "Zend/zend_language_scanner.l"
		{
	if (CG(current_namespace)) {
		*zendlval = *CG(current_namespace);
		zval_copy_ctor(zendlval);
	} else {
		ZVAL_EMPTY_STRING(zendlval);
	}
	return T_NS_C;
}
#line 4003 "Zend/zend_language_scanner.c"
yy315:
		YYDEBUG(315, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy316;
		if (yych != 'r') goto yy186;
yy316:
		YYDEBUG(316, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(317, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(318, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(319, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1474 "Zend/zend_language_scanner.l"
		{
	char *filename = zend_get_compiled_filename(TSRMLS_C);
	const size_t filename_len = strlen(filename);
	char *dirname;

	if (!filename) {
		filename = "";
	}

	dirname = estrndup(filename, filename_len);
	zend_dirname(dirname, filename_len);

	if (strcmp(dirname, ".") == 0) {
		dirname = erealloc(dirname, MAXPATHLEN);
#if HAVE_GETCWD
		VCWD_GETCWD(dirname, MAXPATHLEN);
#elif HAVE_GETWD
		VCWD_GETWD(dirname);
#endif
	}

	zendlval->value.str.len = strlen(dirname);
	zendlval->value.str.val = dirname;
	zendlval->type = IS_STRING;
	return T_DIR;
}
#line 4050 "Zend/zend_language_scanner.c"
yy320:
		YYDEBUG(320, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy321;
		if (yych != 'n') goto yy186;
yy321:
		YYDEBUG(321, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy322;
		if (yych != 'e') goto yy186;
yy322:
		YYDEBUG(322, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(323, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(324, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(325, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1456 "Zend/zend_language_scanner.l"
		{
	zendlval->value.lval = CG(zend_lineno);
	zendlval->type = IS_LONG;
	return T_LINE;
}
#line 4081 "Zend/zend_language_scanner.c"
yy326:
		YYDEBUG(326, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy327;
		if (yych != 't') goto yy186;
yy327:
		YYDEBUG(327, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy328;
		if (yych != 'h') goto yy186;
yy328:
		YYDEBUG(328, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy329;
		if (yych != 'o') goto yy186;
yy329:
		YYDEBUG(329, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy330;
		if (yych != 'd') goto yy186;
yy330:
		YYDEBUG(330, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(331, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(332, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(333, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1435 "Zend/zend_language_scanner.l"
		{
	char *class_name = CG(active_class_entry) ? CG(active_class_entry)->name : NULL;
	char *func_name = CG(active_op_array)? CG(active_op_array)->function_name : NULL;
	size_t len = 0;

	if (class_name) {
		len += strlen(class_name) + 2;
	}
	if (func_name) {
		len += strlen(func_name);
	}

	zendlval->value.str.len = zend_spprintf(&zendlval->value.str.val, 0, "%s%s%s", 
		class_name ? class_name : "",
		class_name && func_name ? "::" : "",
		func_name ? func_name : ""
		);
	zendlval->type = IS_STRING;
	return T_METHOD_C;
}
#line 4137 "Zend/zend_language_scanner.c"
yy334:
		YYDEBUG(334, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy345;
		if (yych == 'l') goto yy345;
		goto yy186;
yy335:
		YYDEBUG(335, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy336;
		if (yych != 'n') goto yy186;
yy336:
		YYDEBUG(336, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy337;
		if (yych != 'c') goto yy186;
yy337:
		YYDEBUG(337, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy338;
		if (yych != 't') goto yy186;
yy338:
		YYDEBUG(338, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy339;
		if (yych != 'i') goto yy186;
yy339:
		YYDEBUG(339, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy340;
		if (yych != 'o') goto yy186;
yy340:
		YYDEBUG(340, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy341;
		if (yych != 'n') goto yy186;
yy341:
		YYDEBUG(341, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(342, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(343, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(344, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1419 "Zend/zend_language_scanner.l"
		{
	char *func_name = NULL;

	if (CG(active_op_array)) {
		func_name = CG(active_op_array)->function_name;
	}

	if (!func_name) {
		func_name = "";
	}
	zendlval->value.str.len = strlen(func_name);
	zendlval->value.str.val = estrndup(func_name, zendlval->value.str.len);
	zendlval->type = IS_STRING;
	return T_FUNC_C;
}
#line 4204 "Zend/zend_language_scanner.c"
yy345:
		YYDEBUG(345, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy346;
		if (yych != 'e') goto yy186;
yy346:
		YYDEBUG(346, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(347, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(348, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(349, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1462 "Zend/zend_language_scanner.l"
		{
	char *filename = zend_get_compiled_filename(TSRMLS_C);

	if (!filename) {
		filename = "";
	}
	zendlval->value.str.len = strlen(filename);
	zendlval->value.str.val = estrndup(filename, zendlval->value.str.len);
	zendlval->type = IS_STRING;
	return T_FILE;
}
#line 4236 "Zend/zend_language_scanner.c"
yy350:
		YYDEBUG(350, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy351;
		if (yych != 'a') goto yy186;
yy351:
		YYDEBUG(351, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy352;
		if (yych != 's') goto yy186;
yy352:
		YYDEBUG(352, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy353;
		if (yych != 's') goto yy186;
yy353:
		YYDEBUG(353, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(354, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(355, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(356, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1403 "Zend/zend_language_scanner.l"
		{
	char *class_name = NULL;

	if (CG(active_class_entry)) {
		class_name = CG(active_class_entry)->name;
	}

	if (!class_name) {
		class_name = "";
	}
	zendlval->value.str.len = strlen(class_name);
	zendlval->value.str.val = estrndup(class_name, zendlval->value.str.len);
	zendlval->type = IS_STRING;
	return T_CLASS_C;
}
#line 4282 "Zend/zend_language_scanner.c"
yy357:
		YYDEBUG(357, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy358;
		if (yych != 'l') goto yy186;
yy358:
		YYDEBUG(358, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy359;
		if (yych != 't') goto yy186;
yy359:
		YYDEBUG(359, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(360, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy361;
		if (yych != 'c') goto yy186;
yy361:
		YYDEBUG(361, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy362;
		if (yych != 'o') goto yy186;
yy362:
		YYDEBUG(362, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy363;
		if (yych != 'm') goto yy186;
yy363:
		YYDEBUG(363, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy364;
		if (yych != 'p') goto yy186;
yy364:
		YYDEBUG(364, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy365;
		if (yych != 'i') goto yy186;
yy365:
		YYDEBUG(365, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy366;
		if (yych != 'l') goto yy186;
yy366:
		YYDEBUG(366, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy367;
		if (yych != 'e') goto yy186;
yy367:
		YYDEBUG(367, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy368;
		if (yych != 'r') goto yy186;
yy368:
		YYDEBUG(368, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(369, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1141 "Zend/zend_language_scanner.l"
		{
	return T_HALT_COMPILER;
}
#line 4348 "Zend/zend_language_scanner.c"
yy370:
		YYDEBUG(370, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy374;
		if (yych == 's') goto yy374;
		goto yy186;
yy371:
		YYDEBUG(371, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy372;
		if (yych != 'e') goto yy186;
yy372:
		YYDEBUG(372, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(373, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1125 "Zend/zend_language_scanner.l"
		{
	return T_USE;
}
#line 4372 "Zend/zend_language_scanner.c"
yy374:
		YYDEBUG(374, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy375;
		if (yych != 'e') goto yy186;
yy375:
		YYDEBUG(375, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy376;
		if (yych != 't') goto yy186;
yy376:
		YYDEBUG(376, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(377, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1169 "Zend/zend_language_scanner.l"
		{
	return T_UNSET;
}
#line 4395 "Zend/zend_language_scanner.c"
yy378:
		YYDEBUG(378, *YYCURSOR);
		++YYCURSOR;
		YYFILL(7);
		yych = *YYCURSOR;
yy379:
		YYDEBUG(379, *YYCURSOR);
		if (yych <= 'S') {
			if (yych <= 'D') {
				if (yych <= ' ') {
					if (yych == '\t') goto yy378;
					if (yych <= 0x1F) goto yy193;
					goto yy378;
				} else {
					if (yych <= 'A') {
						if (yych <= '@') goto yy193;
						goto yy383;
					} else {
						if (yych <= 'B') goto yy381;
						if (yych <= 'C') goto yy193;
						goto yy386;
					}
				}
			} else {
				if (yych <= 'I') {
					if (yych == 'F') goto yy387;
					if (yych <= 'H') goto yy193;
					goto yy388;
				} else {
					if (yych <= 'O') {
						if (yych <= 'N') goto yy193;
						goto yy382;
					} else {
						if (yych <= 'Q') goto yy193;
						if (yych <= 'R') goto yy385;
						goto yy384;
					}
				}
			}
		} else {
			if (yych <= 'f') {
				if (yych <= 'a') {
					if (yych == 'U') goto yy380;
					if (yych <= '`') goto yy193;
					goto yy383;
				} else {
					if (yych <= 'c') {
						if (yych <= 'b') goto yy381;
						goto yy193;
					} else {
						if (yych <= 'd') goto yy386;
						if (yych <= 'e') goto yy193;
						goto yy387;
					}
				}
			} else {
				if (yych <= 'q') {
					if (yych <= 'i') {
						if (yych <= 'h') goto yy193;
						goto yy388;
					} else {
						if (yych == 'o') goto yy382;
						goto yy193;
					}
				} else {
					if (yych <= 's') {
						if (yych <= 'r') goto yy385;
						goto yy384;
					} else {
						if (yych != 'u') goto yy193;
					}
				}
			}
		}
yy380:
		YYDEBUG(380, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy451;
		if (yych == 'n') goto yy451;
		goto yy193;
yy381:
		YYDEBUG(381, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'I') goto yy434;
			if (yych <= 'N') goto yy193;
			goto yy435;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy193;
				goto yy434;
			} else {
				if (yych == 'o') goto yy435;
				goto yy193;
			}
		}
yy382:
		YYDEBUG(382, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy426;
		if (yych == 'b') goto yy426;
		goto yy193;
yy383:
		YYDEBUG(383, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy419;
		if (yych == 'r') goto yy419;
		goto yy193;
yy384:
		YYDEBUG(384, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy411;
		if (yych == 't') goto yy411;
		goto yy193;
yy385:
		YYDEBUG(385, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy409;
		if (yych == 'e') goto yy409;
		goto yy193;
yy386:
		YYDEBUG(386, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy405;
		if (yych == 'o') goto yy405;
		goto yy193;
yy387:
		YYDEBUG(387, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy398;
		if (yych == 'l') goto yy398;
		goto yy193;
yy388:
		YYDEBUG(388, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy389;
		if (yych != 'n') goto yy193;
yy389:
		YYDEBUG(389, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy390;
		if (yych != 't') goto yy193;
yy390:
		YYDEBUG(390, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy391;
		if (yych != 'e') goto yy393;
yy391:
		YYDEBUG(391, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy396;
		if (yych == 'g') goto yy396;
		goto yy193;
yy392:
		YYDEBUG(392, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy393:
		YYDEBUG(393, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy392;
			goto yy193;
		} else {
			if (yych <= ' ') goto yy392;
			if (yych != ')') goto yy193;
		}
		YYDEBUG(394, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(395, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1069 "Zend/zend_language_scanner.l"
		{
	return T_INT_CAST;
}
#line 4571 "Zend/zend_language_scanner.c"
yy396:
		YYDEBUG(396, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy397;
		if (yych != 'e') goto yy193;
yy397:
		YYDEBUG(397, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy392;
		if (yych == 'r') goto yy392;
		goto yy193;
yy398:
		YYDEBUG(398, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy399;
		if (yych != 'o') goto yy193;
yy399:
		YYDEBUG(399, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy400;
		if (yych != 'a') goto yy193;
yy400:
		YYDEBUG(400, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy401;
		if (yych != 't') goto yy193;
yy401:
		YYDEBUG(401, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(402, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy401;
			goto yy193;
		} else {
			if (yych <= ' ') goto yy401;
			if (yych != ')') goto yy193;
		}
		YYDEBUG(403, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(404, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1073 "Zend/zend_language_scanner.l"
		{
	return T_DOUBLE_CAST;
}
#line 4619 "Zend/zend_language_scanner.c"
yy405:
		YYDEBUG(405, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy406;
		if (yych != 'u') goto yy193;
yy406:
		YYDEBUG(406, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy407;
		if (yych != 'b') goto yy193;
yy407:
		YYDEBUG(407, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy408;
		if (yych != 'l') goto yy193;
yy408:
		YYDEBUG(408, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy401;
		if (yych == 'e') goto yy401;
		goto yy193;
yy409:
		YYDEBUG(409, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy410;
		if (yych != 'a') goto yy193;
yy410:
		YYDEBUG(410, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy401;
		if (yych == 'l') goto yy401;
		goto yy193;
yy411:
		YYDEBUG(411, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy412;
		if (yych != 'r') goto yy193;
yy412:
		YYDEBUG(412, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy413;
		if (yych != 'i') goto yy193;
yy413:
		YYDEBUG(413, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy414;
		if (yych != 'n') goto yy193;
yy414:
		YYDEBUG(414, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy415;
		if (yych != 'g') goto yy193;
yy415:
		YYDEBUG(415, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(416, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy415;
			goto yy193;
		} else {
			if (yych <= ' ') goto yy415;
			if (yych != ')') goto yy193;
		}
		YYDEBUG(417, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(418, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1077 "Zend/zend_language_scanner.l"
		{
	return T_STRING_CAST;
}
#line 4693 "Zend/zend_language_scanner.c"
yy419:
		YYDEBUG(419, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy420;
		if (yych != 'r') goto yy193;
yy420:
		YYDEBUG(420, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy421;
		if (yych != 'a') goto yy193;
yy421:
		YYDEBUG(421, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy422;
		if (yych != 'y') goto yy193;
yy422:
		YYDEBUG(422, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(423, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy422;
			goto yy193;
		} else {
			if (yych <= ' ') goto yy422;
			if (yych != ')') goto yy193;
		}
		YYDEBUG(424, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(425, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1085 "Zend/zend_language_scanner.l"
		{
	return T_ARRAY_CAST;
}
#line 4730 "Zend/zend_language_scanner.c"
yy426:
		YYDEBUG(426, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'J') goto yy427;
		if (yych != 'j') goto yy193;
yy427:
		YYDEBUG(427, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy428;
		if (yych != 'e') goto yy193;
yy428:
		YYDEBUG(428, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy429;
		if (yych != 'c') goto yy193;
yy429:
		YYDEBUG(429, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy430;
		if (yych != 't') goto yy193;
yy430:
		YYDEBUG(430, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(431, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy430;
			goto yy193;
		} else {
			if (yych <= ' ') goto yy430;
			if (yych != ')') goto yy193;
		}
		YYDEBUG(432, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(433, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1089 "Zend/zend_language_scanner.l"
		{
	return T_OBJECT_CAST;
}
#line 4772 "Zend/zend_language_scanner.c"
yy434:
		YYDEBUG(434, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy444;
		if (yych == 'n') goto yy444;
		goto yy193;
yy435:
		YYDEBUG(435, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy436;
		if (yych != 'o') goto yy193;
yy436:
		YYDEBUG(436, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy437;
		if (yych != 'l') goto yy193;
yy437:
		YYDEBUG(437, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy442;
		if (yych == 'e') goto yy442;
		goto yy439;
yy438:
		YYDEBUG(438, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy439:
		YYDEBUG(439, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy438;
			goto yy193;
		} else {
			if (yych <= ' ') goto yy438;
			if (yych != ')') goto yy193;
		}
		YYDEBUG(440, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(441, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1093 "Zend/zend_language_scanner.l"
		{
	return T_BOOL_CAST;
}
#line 4817 "Zend/zend_language_scanner.c"
yy442:
		YYDEBUG(442, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy443;
		if (yych != 'a') goto yy193;
yy443:
		YYDEBUG(443, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy438;
		if (yych == 'n') goto yy438;
		goto yy193;
yy444:
		YYDEBUG(444, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy445;
		if (yych != 'a') goto yy193;
yy445:
		YYDEBUG(445, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy446;
		if (yych != 'r') goto yy193;
yy446:
		YYDEBUG(446, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy447;
		if (yych != 'y') goto yy193;
yy447:
		YYDEBUG(447, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(448, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy447;
			goto yy193;
		} else {
			if (yych <= ' ') goto yy447;
			if (yych != ')') goto yy193;
		}
		YYDEBUG(449, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(450, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1081 "Zend/zend_language_scanner.l"
		{
	return T_STRING_CAST;
}
#line 4865 "Zend/zend_language_scanner.c"
yy451:
		YYDEBUG(451, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy452;
		if (yych != 's') goto yy193;
yy452:
		YYDEBUG(452, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy453;
		if (yych != 'e') goto yy193;
yy453:
		YYDEBUG(453, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy454;
		if (yych != 't') goto yy193;
yy454:
		YYDEBUG(454, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(455, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy454;
			goto yy193;
		} else {
			if (yych <= ' ') goto yy454;
			if (yych != ')') goto yy193;
		}
		YYDEBUG(456, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(457, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1097 "Zend/zend_language_scanner.l"
		{
	return T_UNSET_CAST;
}
#line 4902 "Zend/zend_language_scanner.c"
yy458:
		YYDEBUG(458, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy459;
		if (yych != 'r') goto yy186;
yy459:
		YYDEBUG(459, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(460, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1065 "Zend/zend_language_scanner.l"
		{
	return T_VAR;
}
#line 4920 "Zend/zend_language_scanner.c"
yy461:
		YYDEBUG(461, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy465;
		if (yych == 'm') goto yy465;
		goto yy186;
yy462:
		YYDEBUG(462, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'W') goto yy463;
		if (yych != 'w') goto yy186;
yy463:
		YYDEBUG(463, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(464, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1057 "Zend/zend_language_scanner.l"
		{
	return T_NEW;
}
#line 4944 "Zend/zend_language_scanner.c"
yy465:
		YYDEBUG(465, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy466;
		if (yych != 'e') goto yy186;
yy466:
		YYDEBUG(466, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy467;
		if (yych != 's') goto yy186;
yy467:
		YYDEBUG(467, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy468;
		if (yych != 'p') goto yy186;
yy468:
		YYDEBUG(468, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy469;
		if (yych != 'a') goto yy186;
yy469:
		YYDEBUG(469, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy470;
		if (yych != 'c') goto yy186;
yy470:
		YYDEBUG(470, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy471;
		if (yych != 'e') goto yy186;
yy471:
		YYDEBUG(471, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(472, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1121 "Zend/zend_language_scanner.l"
		{
	return T_NAMESPACE;
}
#line 4987 "Zend/zend_language_scanner.c"
yy473:
		YYDEBUG(473, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(474, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1049 "Zend/zend_language_scanner.l"
		{
	return T_PAAMAYIM_NEKUDOTAYIM;
}
#line 4997 "Zend/zend_language_scanner.c"
yy475:
		YYDEBUG(475, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy476:
		YYDEBUG(476, *YYCURSOR);
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy140;
			if (yych <= '\n') goto yy475;
			goto yy140;
		} else {
			if (yych <= '\r') goto yy475;
			if (yych == ' ') goto yy475;
			goto yy140;
		}
yy477:
		YYDEBUG(477, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(478, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1221 "Zend/zend_language_scanner.l"
		{
	return T_MINUS_EQUAL;
}
#line 5023 "Zend/zend_language_scanner.c"
yy479:
		YYDEBUG(479, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(480, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1189 "Zend/zend_language_scanner.l"
		{
	return T_DEC;
}
#line 5033 "Zend/zend_language_scanner.c"
yy481:
		YYDEBUG(481, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(482, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1019 "Zend/zend_language_scanner.l"
		{
	yy_push_state(ST_LOOKING_FOR_PROPERTY TSRMLS_CC);
	return T_OBJECT_OPERATOR;
}
#line 5044 "Zend/zend_language_scanner.c"
yy483:
		YYDEBUG(483, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'I') goto yy490;
			if (yych <= 'N') goto yy186;
			goto yy491;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy186;
				goto yy490;
			} else {
				if (yych == 'o') goto yy491;
				goto yy186;
			}
		}
yy484:
		YYDEBUG(484, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy485;
		if (yych != 'b') goto yy186;
yy485:
		YYDEBUG(485, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy486;
		if (yych != 'l') goto yy186;
yy486:
		YYDEBUG(486, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy487;
		if (yych != 'i') goto yy186;
yy487:
		YYDEBUG(487, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy488;
		if (yych != 'c') goto yy186;
yy488:
		YYDEBUG(488, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(489, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1165 "Zend/zend_language_scanner.l"
		{
	return T_PUBLIC;
}
#line 5093 "Zend/zend_language_scanner.c"
yy490:
		YYDEBUG(490, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'V') {
			if (yych == 'N') goto yy499;
			if (yych <= 'U') goto yy186;
			goto yy500;
		} else {
			if (yych <= 'n') {
				if (yych <= 'm') goto yy186;
				goto yy499;
			} else {
				if (yych == 'v') goto yy500;
				goto yy186;
			}
		}
yy491:
		YYDEBUG(491, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy492;
		if (yych != 't') goto yy186;
yy492:
		YYDEBUG(492, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy493;
		if (yych != 'e') goto yy186;
yy493:
		YYDEBUG(493, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy494;
		if (yych != 'c') goto yy186;
yy494:
		YYDEBUG(494, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy495;
		if (yych != 't') goto yy186;
yy495:
		YYDEBUG(495, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy496;
		if (yych != 'e') goto yy186;
yy496:
		YYDEBUG(496, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy497;
		if (yych != 'd') goto yy186;
yy497:
		YYDEBUG(497, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(498, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1161 "Zend/zend_language_scanner.l"
		{
	return T_PROTECTED;
}
#line 5152 "Zend/zend_language_scanner.c"
yy499:
		YYDEBUG(499, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy505;
		if (yych == 't') goto yy505;
		goto yy186;
yy500:
		YYDEBUG(500, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy501;
		if (yych != 'a') goto yy186;
yy501:
		YYDEBUG(501, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy502;
		if (yych != 't') goto yy186;
yy502:
		YYDEBUG(502, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy503;
		if (yych != 'e') goto yy186;
yy503:
		YYDEBUG(503, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(504, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1157 "Zend/zend_language_scanner.l"
		{
	return T_PRIVATE;
}
#line 5186 "Zend/zend_language_scanner.c"
yy505:
		YYDEBUG(505, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(506, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 999 "Zend/zend_language_scanner.l"
		{
	return T_PRINT;
}
#line 5199 "Zend/zend_language_scanner.c"
yy507:
		YYDEBUG(507, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy512;
		if (yych == 'o') goto yy512;
		goto yy186;
yy508:
		YYDEBUG(508, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy509;
		if (yych != 't') goto yy186;
yy509:
		YYDEBUG(509, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy510;
		if (yych != 'o') goto yy186;
yy510:
		YYDEBUG(510, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(511, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 991 "Zend/zend_language_scanner.l"
		{
	return T_GOTO;
}
#line 5228 "Zend/zend_language_scanner.c"
yy512:
		YYDEBUG(512, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy513;
		if (yych != 'b') goto yy186;
yy513:
		YYDEBUG(513, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy514;
		if (yych != 'a') goto yy186;
yy514:
		YYDEBUG(514, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy515;
		if (yych != 'l') goto yy186;
yy515:
		YYDEBUG(515, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(516, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1129 "Zend/zend_language_scanner.l"
		{
	return T_GLOBAL;
}
#line 5256 "Zend/zend_language_scanner.c"
yy517:
		YYDEBUG(517, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy525;
		goto yy193;
yy518:
		YYDEBUG(518, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy180;
yy519:
		YYDEBUG(519, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy178;
yy520:
		YYDEBUG(520, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy521;
		if (yych != 'e') goto yy186;
yy521:
		YYDEBUG(521, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy522;
		if (yych != 'a') goto yy186;
yy522:
		YYDEBUG(522, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'K') goto yy523;
		if (yych != 'k') goto yy186;
yy523:
		YYDEBUG(523, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(524, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 983 "Zend/zend_language_scanner.l"
		{
	return T_BREAK;
}
#line 5297 "Zend/zend_language_scanner.c"
yy525:
		YYDEBUG(525, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy265;
		goto yy193;
yy526:
		YYDEBUG(526, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy533;
		if (yych == 'a') goto yy533;
		goto yy186;
yy527:
		YYDEBUG(527, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy528;
		if (yych != 'i') goto yy186;
yy528:
		YYDEBUG(528, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy529;
		if (yych != 't') goto yy186;
yy529:
		YYDEBUG(529, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy530;
		if (yych != 'c') goto yy186;
yy530:
		YYDEBUG(530, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy531;
		if (yych != 'h') goto yy186;
yy531:
		YYDEBUG(531, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(532, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 967 "Zend/zend_language_scanner.l"
		{
	return T_SWITCH;
}
#line 5341 "Zend/zend_language_scanner.c"
yy533:
		YYDEBUG(533, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy534;
		if (yych != 't') goto yy186;
yy534:
		YYDEBUG(534, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy535;
		if (yych != 'i') goto yy186;
yy535:
		YYDEBUG(535, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy536;
		if (yych != 'c') goto yy186;
yy536:
		YYDEBUG(536, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(537, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1145 "Zend/zend_language_scanner.l"
		{
	return T_STATIC;
}
#line 5369 "Zend/zend_language_scanner.c"
yy538:
		YYDEBUG(538, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy549;
		if (yych == 's') goto yy549;
		goto yy186;
yy539:
		YYDEBUG(539, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy547;
		if (yych == 'd') goto yy547;
		goto yy186;
yy540:
		YYDEBUG(540, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy543;
		if (yych == 'r') goto yy543;
		goto yy186;
yy541:
		YYDEBUG(541, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(542, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 963 "Zend/zend_language_scanner.l"
		{
	return T_AS;
}
#line 5400 "Zend/zend_language_scanner.c"
yy543:
		YYDEBUG(543, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy544;
		if (yych != 'a') goto yy186;
yy544:
		YYDEBUG(544, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy545;
		if (yych != 'y') goto yy186;
yy545:
		YYDEBUG(545, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(546, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1181 "Zend/zend_language_scanner.l"
		{
	return T_ARRAY;
}
#line 5423 "Zend/zend_language_scanner.c"
yy547:
		YYDEBUG(547, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(548, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1273 "Zend/zend_language_scanner.l"
		{
	return T_LOGICAL_AND;
}
#line 5436 "Zend/zend_language_scanner.c"
yy549:
		YYDEBUG(549, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy550;
		if (yych != 't') goto yy186;
yy550:
		YYDEBUG(550, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy551;
		if (yych != 'r') goto yy186;
yy551:
		YYDEBUG(551, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy552;
		if (yych != 'a') goto yy186;
yy552:
		YYDEBUG(552, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy553;
		if (yych != 'c') goto yy186;
yy553:
		YYDEBUG(553, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy554;
		if (yych != 't') goto yy186;
yy554:
		YYDEBUG(554, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(555, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1149 "Zend/zend_language_scanner.l"
		{
	return T_ABSTRACT;
}
#line 5474 "Zend/zend_language_scanner.c"
yy556:
		YYDEBUG(556, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy557;
		if (yych != 'i') goto yy186;
yy557:
		YYDEBUG(557, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy558;
		if (yych != 'l') goto yy186;
yy558:
		YYDEBUG(558, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy559;
		if (yych != 'e') goto yy186;
yy559:
		YYDEBUG(559, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(560, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 923 "Zend/zend_language_scanner.l"
		{
	return T_WHILE;
}
#line 5502 "Zend/zend_language_scanner.c"
yy561:
		YYDEBUG(561, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(562, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 907 "Zend/zend_language_scanner.l"
		{
	return T_IF;
}
#line 5515 "Zend/zend_language_scanner.c"
yy563:
		YYDEBUG(563, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy599;
		if (yych == 'p') goto yy599;
		goto yy186;
yy564:
		YYDEBUG(564, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych <= 'C') {
				if (yych <= 'B') goto yy186;
				goto yy572;
			} else {
				if (yych <= 'R') goto yy186;
				if (yych <= 'S') goto yy570;
				goto yy571;
			}
		} else {
			if (yych <= 'r') {
				if (yych == 'c') goto yy572;
				goto yy186;
			} else {
				if (yych <= 's') goto yy570;
				if (yych <= 't') goto yy571;
				goto yy186;
			}
		}
yy565:
		YYDEBUG(565, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy566;
		if (yych != 's') goto yy186;
yy566:
		YYDEBUG(566, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy567;
		if (yych != 'e') goto yy186;
yy567:
		YYDEBUG(567, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy568;
		if (yych != 't') goto yy186;
yy568:
		YYDEBUG(568, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(569, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1133 "Zend/zend_language_scanner.l"
		{
	return T_ISSET;
}
#line 5571 "Zend/zend_language_scanner.c"
yy570:
		YYDEBUG(570, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy591;
		if (yych == 't') goto yy591;
		goto yy186;
yy571:
		YYDEBUG(571, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy584;
		if (yych == 'e') goto yy584;
		goto yy186;
yy572:
		YYDEBUG(572, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy573;
		if (yych != 'l') goto yy186;
yy573:
		YYDEBUG(573, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy574;
		if (yych != 'u') goto yy186;
yy574:
		YYDEBUG(574, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy575;
		if (yych != 'd') goto yy186;
yy575:
		YYDEBUG(575, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy576;
		if (yych != 'e') goto yy186;
yy576:
		YYDEBUG(576, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy185;
			} else {
				if (yych <= '@') goto yy577;
				if (yych <= 'Z') goto yy185;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy578;
			} else {
				if (yych <= 'z') goto yy185;
				if (yych >= 0x7F) goto yy185;
			}
		}
yy577:
		YYDEBUG(577, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1105 "Zend/zend_language_scanner.l"
		{
	return T_INCLUDE;
}
#line 5629 "Zend/zend_language_scanner.c"
yy578:
		YYDEBUG(578, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy579;
		if (yych != 'o') goto yy186;
yy579:
		YYDEBUG(579, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy580;
		if (yych != 'n') goto yy186;
yy580:
		YYDEBUG(580, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy581;
		if (yych != 'c') goto yy186;
yy581:
		YYDEBUG(581, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy582;
		if (yych != 'e') goto yy186;
yy582:
		YYDEBUG(582, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(583, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1109 "Zend/zend_language_scanner.l"
		{
	return T_INCLUDE_ONCE;
}
#line 5662 "Zend/zend_language_scanner.c"
yy584:
		YYDEBUG(584, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy585;
		if (yych != 'r') goto yy186;
yy585:
		YYDEBUG(585, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy586;
		if (yych != 'f') goto yy186;
yy586:
		YYDEBUG(586, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy587;
		if (yych != 'a') goto yy186;
yy587:
		YYDEBUG(587, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy588;
		if (yych != 'c') goto yy186;
yy588:
		YYDEBUG(588, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy589;
		if (yych != 'e') goto yy186;
yy589:
		YYDEBUG(589, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(590, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1007 "Zend/zend_language_scanner.l"
		{
	return T_INTERFACE;
}
#line 5700 "Zend/zend_language_scanner.c"
yy591:
		YYDEBUG(591, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy592;
		if (yych != 'a') goto yy186;
yy592:
		YYDEBUG(592, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy593;
		if (yych != 'n') goto yy186;
yy593:
		YYDEBUG(593, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy594;
		if (yych != 'c') goto yy186;
yy594:
		YYDEBUG(594, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy595;
		if (yych != 'e') goto yy186;
yy595:
		YYDEBUG(595, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy596;
		if (yych != 'o') goto yy186;
yy596:
		YYDEBUG(596, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy597;
		if (yych != 'f') goto yy186;
yy597:
		YYDEBUG(597, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(598, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 959 "Zend/zend_language_scanner.l"
		{
	return T_INSTANCEOF;
}
#line 5743 "Zend/zend_language_scanner.c"
yy599:
		YYDEBUG(599, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy600;
		if (yych != 'l') goto yy186;
yy600:
		YYDEBUG(600, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy601;
		if (yych != 'e') goto yy186;
yy601:
		YYDEBUG(601, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy602;
		if (yych != 'm') goto yy186;
yy602:
		YYDEBUG(602, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy603;
		if (yych != 'e') goto yy186;
yy603:
		YYDEBUG(603, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy604;
		if (yych != 'n') goto yy186;
yy604:
		YYDEBUG(604, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy605;
		if (yych != 't') goto yy186;
yy605:
		YYDEBUG(605, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy606;
		if (yych != 's') goto yy186;
yy606:
		YYDEBUG(606, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(607, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1015 "Zend/zend_language_scanner.l"
		{
	return T_IMPLEMENTS;
}
#line 5791 "Zend/zend_language_scanner.c"
yy608:
		YYDEBUG(608, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy612;
		if (yych == 'r') goto yy612;
		goto yy186;
yy609:
		YYDEBUG(609, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy610;
		if (yych != 'y') goto yy186;
yy610:
		YYDEBUG(610, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(611, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 895 "Zend/zend_language_scanner.l"
		{
	return T_TRY;
}
#line 5815 "Zend/zend_language_scanner.c"
yy612:
		YYDEBUG(612, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy613;
		if (yych != 'o') goto yy186;
yy613:
		YYDEBUG(613, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'W') goto yy614;
		if (yych != 'w') goto yy186;
yy614:
		YYDEBUG(614, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(615, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 903 "Zend/zend_language_scanner.l"
		{
	return T_THROW;
}
#line 5838 "Zend/zend_language_scanner.c"
yy616:
		YYDEBUG(616, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych == 'Q') goto yy618;
			if (yych <= 'S') goto yy186;
		} else {
			if (yych <= 'q') {
				if (yych <= 'p') goto yy186;
				goto yy618;
			} else {
				if (yych != 't') goto yy186;
			}
		}
		YYDEBUG(617, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy630;
		if (yych == 'u') goto yy630;
		goto yy186;
yy618:
		YYDEBUG(618, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy619;
		if (yych != 'u') goto yy186;
yy619:
		YYDEBUG(619, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy620;
		if (yych != 'i') goto yy186;
yy620:
		YYDEBUG(620, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy621;
		if (yych != 'r') goto yy186;
yy621:
		YYDEBUG(621, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy622;
		if (yych != 'e') goto yy186;
yy622:
		YYDEBUG(622, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy185;
			} else {
				if (yych <= '@') goto yy623;
				if (yych <= 'Z') goto yy185;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy624;
			} else {
				if (yych <= 'z') goto yy185;
				if (yych >= 0x7F) goto yy185;
			}
		}
yy623:
		YYDEBUG(623, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1113 "Zend/zend_language_scanner.l"
		{
	return T_REQUIRE;
}
#line 5903 "Zend/zend_language_scanner.c"
yy624:
		YYDEBUG(624, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy625;
		if (yych != 'o') goto yy186;
yy625:
		YYDEBUG(625, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy626;
		if (yych != 'n') goto yy186;
yy626:
		YYDEBUG(626, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy627;
		if (yych != 'c') goto yy186;
yy627:
		YYDEBUG(627, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy628;
		if (yych != 'e') goto yy186;
yy628:
		YYDEBUG(628, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(629, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1117 "Zend/zend_language_scanner.l"
		{
	return T_REQUIRE_ONCE;
}
#line 5936 "Zend/zend_language_scanner.c"
yy630:
		YYDEBUG(630, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy631;
		if (yych != 'r') goto yy186;
yy631:
		YYDEBUG(631, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy632;
		if (yych != 'n') goto yy186;
yy632:
		YYDEBUG(632, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(633, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 891 "Zend/zend_language_scanner.l"
		{
	return T_RETURN;
}
#line 5959 "Zend/zend_language_scanner.c"
yy634:
		YYDEBUG(634, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych <= 'R') goto yy186;
			if (yych <= 'S') goto yy656;
			goto yy655;
		} else {
			if (yych <= 'r') goto yy186;
			if (yych <= 's') goto yy656;
			if (yych <= 't') goto yy655;
			goto yy186;
		}
yy635:
		YYDEBUG(635, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'A') goto yy647;
			if (yych <= 'N') goto yy186;
			goto yy648;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy186;
				goto yy647;
			} else {
				if (yych == 'o') goto yy648;
				goto yy186;
			}
		}
yy636:
		YYDEBUG(636, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy637;
		if (yych != 'n') goto yy186;
yy637:
		YYDEBUG(637, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych <= 'R') goto yy186;
			if (yych >= 'T') goto yy639;
		} else {
			if (yych <= 'r') goto yy186;
			if (yych <= 's') goto yy638;
			if (yych <= 't') goto yy639;
			goto yy186;
		}
yy638:
		YYDEBUG(638, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy645;
		if (yych == 't') goto yy645;
		goto yy186;
yy639:
		YYDEBUG(639, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy640;
		if (yych != 'i') goto yy186;
yy640:
		YYDEBUG(640, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy641;
		if (yych != 'n') goto yy186;
yy641:
		YYDEBUG(641, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy642;
		if (yych != 'u') goto yy186;
yy642:
		YYDEBUG(642, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy643;
		if (yych != 'e') goto yy186;
yy643:
		YYDEBUG(643, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(644, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 987 "Zend/zend_language_scanner.l"
		{
	return T_CONTINUE;
}
#line 6044 "Zend/zend_language_scanner.c"
yy645:
		YYDEBUG(645, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(646, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 887 "Zend/zend_language_scanner.l"
		{
	return T_CONST;
}
#line 6057 "Zend/zend_language_scanner.c"
yy647:
		YYDEBUG(647, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy652;
		if (yych == 's') goto yy652;
		goto yy186;
yy648:
		YYDEBUG(648, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy649;
		if (yych != 'n') goto yy186;
yy649:
		YYDEBUG(649, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy650;
		if (yych != 'e') goto yy186;
yy650:
		YYDEBUG(650, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(651, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1061 "Zend/zend_language_scanner.l"
		{
	return T_CLONE;
}
#line 6086 "Zend/zend_language_scanner.c"
yy652:
		YYDEBUG(652, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy653;
		if (yych != 's') goto yy186;
yy653:
		YYDEBUG(653, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(654, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1003 "Zend/zend_language_scanner.l"
		{
	return T_CLASS;
}
#line 6104 "Zend/zend_language_scanner.c"
yy655:
		YYDEBUG(655, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy659;
		if (yych == 'c') goto yy659;
		goto yy186;
yy656:
		YYDEBUG(656, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy657;
		if (yych != 'e') goto yy186;
yy657:
		YYDEBUG(657, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(658, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 975 "Zend/zend_language_scanner.l"
		{
	return T_CASE;
}
#line 6128 "Zend/zend_language_scanner.c"
yy659:
		YYDEBUG(659, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy660;
		if (yych != 'h') goto yy186;
yy660:
		YYDEBUG(660, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(661, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 899 "Zend/zend_language_scanner.l"
		{
	return T_CATCH;
}
#line 6146 "Zend/zend_language_scanner.c"
yy662:
		YYDEBUG(662, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy679;
		if (yych == 'n') goto yy679;
		goto yy186;
yy663:
		YYDEBUG(663, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy672;
		if (yych == 'r') goto yy672;
		goto yy186;
yy664:
		YYDEBUG(664, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy665;
		if (yych != 'n') goto yy186;
yy665:
		YYDEBUG(665, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy666;
		if (yych != 'c') goto yy186;
yy666:
		YYDEBUG(666, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy667;
		if (yych != 't') goto yy186;
yy667:
		YYDEBUG(667, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy668;
		if (yych != 'i') goto yy186;
yy668:
		YYDEBUG(668, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy669;
		if (yych != 'o') goto yy186;
yy669:
		YYDEBUG(669, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy670;
		if (yych != 'n') goto yy186;
yy670:
		YYDEBUG(670, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(671, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 883 "Zend/zend_language_scanner.l"
		{
	return T_FUNCTION;
}
#line 6201 "Zend/zend_language_scanner.c"
yy672:
		YYDEBUG(672, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '@') {
				if (yych <= '/') goto yy673;
				if (yych <= '9') goto yy185;
			} else {
				if (yych == 'E') goto yy674;
				if (yych <= 'Z') goto yy185;
			}
		} else {
			if (yych <= 'd') {
				if (yych != '`') goto yy185;
			} else {
				if (yych <= 'e') goto yy674;
				if (yych <= 'z') goto yy185;
				if (yych >= 0x7F) goto yy185;
			}
		}
yy673:
		YYDEBUG(673, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 935 "Zend/zend_language_scanner.l"
		{
	return T_FOR;
}
#line 6229 "Zend/zend_language_scanner.c"
yy674:
		YYDEBUG(674, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy675;
		if (yych != 'a') goto yy186;
yy675:
		YYDEBUG(675, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy676;
		if (yych != 'c') goto yy186;
yy676:
		YYDEBUG(676, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy677;
		if (yych != 'h') goto yy186;
yy677:
		YYDEBUG(677, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(678, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 943 "Zend/zend_language_scanner.l"
		{
	return T_FOREACH;
}
#line 6257 "Zend/zend_language_scanner.c"
yy679:
		YYDEBUG(679, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy680;
		if (yych != 'a') goto yy186;
yy680:
		YYDEBUG(680, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy681;
		if (yych != 'l') goto yy186;
yy681:
		YYDEBUG(681, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(682, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1153 "Zend/zend_language_scanner.l"
		{
	return T_FINAL;
}
#line 6280 "Zend/zend_language_scanner.c"
yy683:
		YYDEBUG(683, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'F') {
			if (yych == 'C') goto yy689;
			if (yych <= 'E') goto yy186;
			goto yy690;
		} else {
			if (yych <= 'c') {
				if (yych <= 'b') goto yy186;
				goto yy689;
			} else {
				if (yych == 'f') goto yy690;
				goto yy186;
			}
		}
yy684:
		YYDEBUG(684, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy687;
		if (yych == 'e') goto yy687;
		goto yy186;
yy685:
		YYDEBUG(685, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(686, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 931 "Zend/zend_language_scanner.l"
		{
	return T_DO;
}
#line 6315 "Zend/zend_language_scanner.c"
yy687:
		YYDEBUG(687, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(688, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 879 "Zend/zend_language_scanner.l"
		{
	return T_EXIT;
}
#line 6328 "Zend/zend_language_scanner.c"
yy689:
		YYDEBUG(689, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy696;
		if (yych == 'l') goto yy696;
		goto yy186;
yy690:
		YYDEBUG(690, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy691;
		if (yych != 'a') goto yy186;
yy691:
		YYDEBUG(691, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy692;
		if (yych != 'u') goto yy186;
yy692:
		YYDEBUG(692, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy693;
		if (yych != 'l') goto yy186;
yy693:
		YYDEBUG(693, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy694;
		if (yych != 't') goto yy186;
yy694:
		YYDEBUG(694, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(695, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 979 "Zend/zend_language_scanner.l"
		{
	return T_DEFAULT;
}
#line 6367 "Zend/zend_language_scanner.c"
yy696:
		YYDEBUG(696, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy697;
		if (yych != 'a') goto yy186;
yy697:
		YYDEBUG(697, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy698;
		if (yych != 'r') goto yy186;
yy698:
		YYDEBUG(698, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy699;
		if (yych != 'e') goto yy186;
yy699:
		YYDEBUG(699, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(700, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 951 "Zend/zend_language_scanner.l"
		{
	return T_DECLARE;
}
#line 6395 "Zend/zend_language_scanner.c"
yy701:
		YYDEBUG(701, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy763;
		if (yych == 'h') goto yy763;
		goto yy186;
yy702:
		YYDEBUG(702, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy757;
		if (yych == 's') goto yy757;
		goto yy186;
yy703:
		YYDEBUG(703, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy753;
		if (yych == 'p') goto yy753;
		goto yy186;
yy704:
		YYDEBUG(704, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy719;
		if (yych == 'd') goto yy719;
		goto yy186;
yy705:
		YYDEBUG(705, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy716;
		if (yych == 'a') goto yy716;
		goto yy186;
yy706:
		YYDEBUG(706, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych == 'I') goto yy707;
			if (yych <= 'S') goto yy186;
			goto yy708;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy186;
			} else {
				if (yych == 't') goto yy708;
				goto yy186;
			}
		}
yy707:
		YYDEBUG(707, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy714;
		if (yych == 't') goto yy714;
		goto yy186;
yy708:
		YYDEBUG(708, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy709;
		if (yych != 'e') goto yy186;
yy709:
		YYDEBUG(709, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy710;
		if (yych != 'n') goto yy186;
yy710:
		YYDEBUG(710, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy711;
		if (yych != 'd') goto yy186;
yy711:
		YYDEBUG(711, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy712;
		if (yych != 's') goto yy186;
yy712:
		YYDEBUG(712, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(713, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1011 "Zend/zend_language_scanner.l"
		{
	return T_EXTENDS;
}
#line 6479 "Zend/zend_language_scanner.c"
yy714:
		YYDEBUG(714, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(715, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 875 "Zend/zend_language_scanner.l"
		{
	return T_EXIT;
}
#line 6492 "Zend/zend_language_scanner.c"
yy716:
		YYDEBUG(716, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy717;
		if (yych != 'l') goto yy186;
yy717:
		YYDEBUG(717, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(718, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1101 "Zend/zend_language_scanner.l"
		{
	return T_EVAL;
}
#line 6510 "Zend/zend_language_scanner.c"
yy719:
		YYDEBUG(719, *YYCURSOR);
		yych = *++YYCURSOR;
		YYDEBUG(-1, yych);
		switch (yych) {
		case 'D':
		case 'd':	goto yy720;
		case 'F':
		case 'f':	goto yy721;
		case 'I':
		case 'i':	goto yy722;
		case 'S':
		case 's':	goto yy723;
		case 'W':
		case 'w':	goto yy724;
		default:	goto yy186;
		}
yy720:
		YYDEBUG(720, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy746;
		if (yych == 'e') goto yy746;
		goto yy186;
yy721:
		YYDEBUG(721, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy738;
		if (yych == 'o') goto yy738;
		goto yy186;
yy722:
		YYDEBUG(722, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy736;
		if (yych == 'f') goto yy736;
		goto yy186;
yy723:
		YYDEBUG(723, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'W') goto yy730;
		if (yych == 'w') goto yy730;
		goto yy186;
yy724:
		YYDEBUG(724, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy725;
		if (yych != 'h') goto yy186;
yy725:
		YYDEBUG(725, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy726;
		if (yych != 'i') goto yy186;
yy726:
		YYDEBUG(726, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy727;
		if (yych != 'l') goto yy186;
yy727:
		YYDEBUG(727, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy728;
		if (yych != 'e') goto yy186;
yy728:
		YYDEBUG(728, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(729, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 927 "Zend/zend_language_scanner.l"
		{
	return T_ENDWHILE;
}
#line 6584 "Zend/zend_language_scanner.c"
yy730:
		YYDEBUG(730, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy731;
		if (yych != 'i') goto yy186;
yy731:
		YYDEBUG(731, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy732;
		if (yych != 't') goto yy186;
yy732:
		YYDEBUG(732, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy733;
		if (yych != 'c') goto yy186;
yy733:
		YYDEBUG(733, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy734;
		if (yych != 'h') goto yy186;
yy734:
		YYDEBUG(734, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(735, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 971 "Zend/zend_language_scanner.l"
		{
	return T_ENDSWITCH;
}
#line 6617 "Zend/zend_language_scanner.c"
yy736:
		YYDEBUG(736, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(737, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 915 "Zend/zend_language_scanner.l"
		{
	return T_ENDIF;
}
#line 6630 "Zend/zend_language_scanner.c"
yy738:
		YYDEBUG(738, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy739;
		if (yych != 'r') goto yy186;
yy739:
		YYDEBUG(739, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '@') {
				if (yych <= '/') goto yy740;
				if (yych <= '9') goto yy185;
			} else {
				if (yych == 'E') goto yy741;
				if (yych <= 'Z') goto yy185;
			}
		} else {
			if (yych <= 'd') {
				if (yych != '`') goto yy185;
			} else {
				if (yych <= 'e') goto yy741;
				if (yych <= 'z') goto yy185;
				if (yych >= 0x7F) goto yy185;
			}
		}
yy740:
		YYDEBUG(740, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 939 "Zend/zend_language_scanner.l"
		{
	return T_ENDFOR;
}
#line 6663 "Zend/zend_language_scanner.c"
yy741:
		YYDEBUG(741, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy742;
		if (yych != 'a') goto yy186;
yy742:
		YYDEBUG(742, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy743;
		if (yych != 'c') goto yy186;
yy743:
		YYDEBUG(743, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy744;
		if (yych != 'h') goto yy186;
yy744:
		YYDEBUG(744, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(745, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 947 "Zend/zend_language_scanner.l"
		{
	return T_ENDFOREACH;
}
#line 6691 "Zend/zend_language_scanner.c"
yy746:
		YYDEBUG(746, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy747;
		if (yych != 'c') goto yy186;
yy747:
		YYDEBUG(747, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy748;
		if (yych != 'l') goto yy186;
yy748:
		YYDEBUG(748, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy749;
		if (yych != 'a') goto yy186;
yy749:
		YYDEBUG(749, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy750;
		if (yych != 'r') goto yy186;
yy750:
		YYDEBUG(750, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy751;
		if (yych != 'e') goto yy186;
yy751:
		YYDEBUG(751, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(752, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 955 "Zend/zend_language_scanner.l"
		{
	return T_ENDDECLARE;
}
#line 6729 "Zend/zend_language_scanner.c"
yy753:
		YYDEBUG(753, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy754;
		if (yych != 't') goto yy186;
yy754:
		YYDEBUG(754, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy755;
		if (yych != 'y') goto yy186;
yy755:
		YYDEBUG(755, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(756, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1137 "Zend/zend_language_scanner.l"
		{
	return T_EMPTY;
}
#line 6752 "Zend/zend_language_scanner.c"
yy757:
		YYDEBUG(757, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy758;
		if (yych != 'e') goto yy186;
yy758:
		YYDEBUG(758, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '@') {
				if (yych <= '/') goto yy759;
				if (yych <= '9') goto yy185;
			} else {
				if (yych == 'I') goto yy760;
				if (yych <= 'Z') goto yy185;
			}
		} else {
			if (yych <= 'h') {
				if (yych != '`') goto yy185;
			} else {
				if (yych <= 'i') goto yy760;
				if (yych <= 'z') goto yy185;
				if (yych >= 0x7F) goto yy185;
			}
		}
yy759:
		YYDEBUG(759, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 919 "Zend/zend_language_scanner.l"
		{
	return T_ELSE;
}
#line 6785 "Zend/zend_language_scanner.c"
yy760:
		YYDEBUG(760, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy761;
		if (yych != 'f') goto yy186;
yy761:
		YYDEBUG(761, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(762, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 911 "Zend/zend_language_scanner.l"
		{
	return T_ELSEIF;
}
#line 6803 "Zend/zend_language_scanner.c"
yy763:
		YYDEBUG(763, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy764;
		if (yych != 'o') goto yy186;
yy764:
		YYDEBUG(764, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 8) {
			goto yy185;
		}
		YYDEBUG(765, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 995 "Zend/zend_language_scanner.l"
		{
	return T_ECHO;
}
#line 6821 "Zend/zend_language_scanner.c"
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_PROPERTY:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128,   0,   0, 128,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,   0,   0,   0,   0,   0,   0, 
			  0,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,   0,   0,   0,   0,  64, 
			  0,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,   0,   0,   0,   0,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
		};
		YYDEBUG(766, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '-') {
			if (yych <= '\r') {
				if (yych <= 0x08) goto yy774;
				if (yych <= '\n') goto yy768;
				if (yych <= '\f') goto yy774;
			} else {
				if (yych == ' ') goto yy768;
				if (yych <= ',') goto yy774;
				goto yy770;
			}
		} else {
			if (yych <= '_') {
				if (yych <= '@') goto yy774;
				if (yych <= 'Z') goto yy772;
				if (yych <= '^') goto yy774;
				goto yy772;
			} else {
				if (yych <= '`') goto yy774;
				if (yych <= 'z') goto yy772;
				if (yych <= '~') goto yy774;
				goto yy772;
			}
		}
yy768:
		YYDEBUG(768, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy780;
yy769:
		YYDEBUG(769, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1024 "Zend/zend_language_scanner.l"
		{
	zendlval->value.str.val = yytext; /* no copying - intentional */
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	HANDLE_NEWLINES(yytext, yyleng);
	return T_WHITESPACE;
}
#line 6902 "Zend/zend_language_scanner.c"
yy770:
		YYDEBUG(770, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '>') goto yy777;
yy771:
		YYDEBUG(771, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1043 "Zend/zend_language_scanner.l"
		{
	yyless(0);
	yy_pop_state(TSRMLS_C);
	goto restart;
}
#line 6916 "Zend/zend_language_scanner.c"
yy772:
		YYDEBUG(772, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy776;
yy773:
		YYDEBUG(773, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1036 "Zend/zend_language_scanner.l"
		{
	yy_pop_state(TSRMLS_C);
	zend_copy_value(zendlval, yytext, yyleng);
	zendlval->type = IS_STRING;
	return T_STRING;
}
#line 6932 "Zend/zend_language_scanner.c"
yy774:
		YYDEBUG(774, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy771;
yy775:
		YYDEBUG(775, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy776:
		YYDEBUG(776, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy775;
		}
		goto yy773;
yy777:
		YYDEBUG(777, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(778, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1032 "Zend/zend_language_scanner.l"
		{
	return T_OBJECT_OPERATOR;
}
#line 6957 "Zend/zend_language_scanner.c"
yy779:
		YYDEBUG(779, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy780:
		YYDEBUG(780, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy779;
		}
		goto yy769;
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_VARNAME:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(781, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy785;
			if (yych <= 'Z') goto yy783;
			if (yych <= '^') goto yy785;
		} else {
			if (yych <= '`') goto yy785;
			if (yych <= 'z') goto yy783;
			if (yych <= '~') goto yy785;
		}
yy783:
		YYDEBUG(783, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy788;
yy784:
		YYDEBUG(784, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1315 "Zend/zend_language_scanner.l"
		{
	zend_copy_value(zendlval, yytext, yyleng);
	zendlval->type = IS_STRING;
	yy_pop_state(TSRMLS_C);
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	return T_STRING_VARNAME;
}
#line 7035 "Zend/zend_language_scanner.c"
yy785:
		YYDEBUG(785, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(786, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1324 "Zend/zend_language_scanner.l"
		{
	yyless(0);
	yy_pop_state(TSRMLS_C);
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	goto restart;
}
#line 7048 "Zend/zend_language_scanner.c"
yy787:
		YYDEBUG(787, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy788:
		YYDEBUG(788, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy787;
		}
		goto yy784;
	}
/* *********************************** */
yyc_ST_NOWDOC:
	YYDEBUG(789, *YYCURSOR);
	YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(791, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(792, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
#line 2162 "Zend/zend_language_scanner.l"
	{
	int newline = 0;

	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && CG(heredoc_len) < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, CG(heredoc), CG(heredoc_len))) {
					YYCTYPE *end = YYCURSOR + CG(heredoc_len);

					if (*end == ';') {
						end++;
					}

					if (*end == '\n' || *end == '\r') {
						/* newline before label will be subtracted from returned text, but
						 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
						if (YYCURSOR[-2] == '\r' && YYCURSOR[-1] == '\n') {
							newline = 2; /* Windows newline */
						} else {
							newline = 1;
						}

						CG(increment_lineno) = 1; /* For newline before label */
						BEGIN(ST_END_HEREDOC);

						goto nowdoc_scan_done;
					}
				}
				/* fall through */
			default:
				continue;
		}
	}

nowdoc_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	zend_copy_value(zendlval, yytext, yyleng - newline);
	zendlval->type = IS_STRING;
	HANDLE_NEWLINES(yytext, yyleng - newline);
	return T_ENCAPSED_AND_WHITESPACE;
}
#line 7125 "Zend/zend_language_scanner.c"
/* *********************************** */
yyc_ST_VAR_OFFSET:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			224, 224, 224, 224, 224, 224, 224, 224, 
			224, 224,   0,   0,   0,   0,   0,   0, 
			  0, 160, 160, 160, 160, 160, 160,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,   0,   0,   0,   0,  32, 
			  0, 160, 160, 160, 160, 160, 160,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,   0,   0,   0,   0,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
		};
		YYDEBUG(793, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		if (yych <= '/') {
			if (yych <= ' ') {
				if (yych <= '\f') {
					if (yych <= 0x08) goto yy807;
					if (yych <= '\n') goto yy803;
					goto yy807;
				} else {
					if (yych <= '\r') goto yy803;
					if (yych <= 0x1F) goto yy807;
					goto yy803;
				}
			} else {
				if (yych <= '$') {
					if (yych <= '"') goto yy802;
					if (yych <= '#') goto yy803;
					goto yy798;
				} else {
					if (yych == '\'') goto yy803;
					goto yy802;
				}
			}
		} else {
			if (yych <= '\\') {
				if (yych <= '@') {
					if (yych <= '0') goto yy795;
					if (yych <= '9') goto yy797;
					goto yy802;
				} else {
					if (yych <= 'Z') goto yy805;
					if (yych <= '[') goto yy802;
					goto yy803;
				}
			} else {
				if (yych <= '_') {
					if (yych <= ']') goto yy800;
					if (yych <= '^') goto yy802;
					goto yy805;
				} else {
					if (yych <= '`') goto yy802;
					if (yych <= 'z') goto yy805;
					if (yych <= '~') goto yy802;
					goto yy805;
				}
			}
		}
yy795:
		YYDEBUG(795, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'W') {
			if (yych <= '/') goto yy796;
			if (yych <= '9') goto yy818;
		} else {
			if (yych <= 'X') goto yy816;
			if (yych == 'x') goto yy816;
		}
yy796:
		YYDEBUG(796, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1378 "Zend/zend_language_scanner.l"
		{ /* Offset could be treated as a long */
	if (yyleng < MAX_LENGTH_OF_LONG - 1 || (yyleng == MAX_LENGTH_OF_LONG - 1 && strcmp(yytext, long_min_digits) < 0)) {
		zendlval->value.lval = strtol(yytext, NULL, 10);
		zendlval->type = IS_LONG;
	} else {
		zendlval->value.str.val = (char *)estrndup(yytext, yyleng);
		zendlval->value.str.len = yyleng;
		zendlval->type = IS_STRING;
	}
	return T_NUM_STRING;
}
#line 7237 "Zend/zend_language_scanner.c"
yy797:
		YYDEBUG(797, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy815;
yy798:
		YYDEBUG(798, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '_') {
			if (yych <= '@') goto yy799;
			if (yych <= 'Z') goto yy811;
			if (yych >= '_') goto yy811;
		} else {
			if (yych <= '`') goto yy799;
			if (yych <= 'z') goto yy811;
			if (yych >= 0x7F) goto yy811;
		}
yy799:
		YYDEBUG(799, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1688 "Zend/zend_language_scanner.l"
		{
	/* Only '[' can be valid, but returning other tokens will allow a more explicit parse error */
	return yytext[0];
}
#line 7262 "Zend/zend_language_scanner.c"
yy800:
		YYDEBUG(800, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(801, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1683 "Zend/zend_language_scanner.l"
		{
	yy_pop_state(TSRMLS_C);
	return ']';
}
#line 7273 "Zend/zend_language_scanner.c"
yy802:
		YYDEBUG(802, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy799;
yy803:
		YYDEBUG(803, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(804, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1693 "Zend/zend_language_scanner.l"
		{
	/* Invalid rule to return a more explicit parse error with proper line number */
	yyless(0);
	yy_pop_state(TSRMLS_C);
	return T_ENCAPSED_AND_WHITESPACE;
}
#line 7290 "Zend/zend_language_scanner.c"
yy805:
		YYDEBUG(805, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy810;
yy806:
		YYDEBUG(806, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1700 "Zend/zend_language_scanner.l"
		{
	zend_copy_value(zendlval, yytext, yyleng);
	zendlval->type = IS_STRING;
	return T_STRING;
}
#line 7305 "Zend/zend_language_scanner.c"
yy807:
		YYDEBUG(807, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(808, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2218 "Zend/zend_language_scanner.l"
		{
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	zend_error(E_COMPILE_WARNING,"Unexpected character in input:  '%c' (ASCII=%d) state=%d", yytext[0], yytext[0], YYSTATE);
	goto restart;
}
#line 7320 "Zend/zend_language_scanner.c"
yy809:
		YYDEBUG(809, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy810:
		YYDEBUG(810, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy809;
		}
		goto yy806;
yy811:
		YYDEBUG(811, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(812, *YYCURSOR);
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy811;
			} else {
				if (yych <= '@') goto yy813;
				if (yych <= 'Z') goto yy811;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy811;
			} else {
				if (yych <= 'z') goto yy811;
				if (yych >= 0x7F) goto yy811;
			}
		}
yy813:
		YYDEBUG(813, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1677 "Zend/zend_language_scanner.l"
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
#line 7362 "Zend/zend_language_scanner.c"
yy814:
		YYDEBUG(814, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy815:
		YYDEBUG(815, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy814;
		}
		goto yy796;
yy816:
		YYDEBUG(816, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy821;
		}
		YYDEBUG(817, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy796;
yy818:
		YYDEBUG(818, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(819, *YYCURSOR);
		if (yych <= '/') goto yy820;
		if (yych <= '9') goto yy818;
yy820:
		YYDEBUG(820, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1390 "Zend/zend_language_scanner.l"
		{ /* Offset must be treated as a string */
	zendlval->value.str.val = (char *)estrndup(yytext, yyleng);
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	return T_NUM_STRING;
}
#line 7401 "Zend/zend_language_scanner.c"
yy821:
		YYDEBUG(821, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(822, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy821;
		}
		goto yy820;
	}
}
#line 2227 "Zend/zend_language_scanner.l"

}
