/* A Bison parser, made by GNU Bison 2.0.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Using locations.  */
#define YYLSP_NEEDED 0

/* Substitute the variable and function names.  */
#define yyparse MYSQLparse
#define yylex   MYSQLlex
#define yyerror MYSQLerror
#define yylval  MYSQLlval
#define yychar  MYSQLchar
#define yydebug MYSQLdebug
#define yynerrs MYSQLnerrs


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     END_OF_INPUT = 258,
     ABORT_SYM = 259,
     ACTION = 260,
     ADD = 261,
     ADDDATE_SYM = 262,
     AFTER_SYM = 263,
     AGAINST = 264,
     AGGREGATE_SYM = 265,
     ALGORITHM_SYM = 266,
     ALL = 267,
     ALTER = 268,
     ANALYZE_SYM = 269,
     AND_AND_SYM = 270,
     AND_SYM = 271,
     ANY_SYM = 272,
     AS = 273,
     ASC = 274,
     ASCII_SYM = 275,
     ASENSITIVE_SYM = 276,
     ATAN = 277,
     AUTO_INC = 278,
     AVG_ROW_LENGTH = 279,
     AVG_SYM = 280,
     BACKUP_SYM = 281,
     BEFORE_SYM = 282,
     BEGIN_SYM = 283,
     BENCHMARK_SYM = 284,
     BERKELEY_DB_SYM = 285,
     BIGINT = 286,
     BINARY = 287,
     BINLOG_SYM = 288,
     BIN_NUM = 289,
     BIT_AND = 290,
     BIT_OR = 291,
     BIT_SYM = 292,
     BIT_XOR = 293,
     BLOB_SYM = 294,
     BLOCK_SYM = 295,
     BOOLEAN_SYM = 296,
     BOOL_SYM = 297,
     BOTH = 298,
     BTREE_SYM = 299,
     BY = 300,
     BYTE_SYM = 301,
     CACHE_SYM = 302,
     CALL_SYM = 303,
     CASCADE = 304,
     CASCADED = 305,
     CAST_SYM = 306,
     CHAIN_SYM = 307,
     CHANGE = 308,
     CHANGED = 309,
     CHARSET = 310,
     CHAR_SYM = 311,
     CHECKSUM_SYM = 312,
     CHECK_SYM = 313,
     CIPHER_SYM = 314,
     CLIENT_SYM = 315,
     CLOSE_SYM = 316,
     COALESCE = 317,
     CODE_SYM = 318,
     COLLATE_SYM = 319,
     COLLATION_SYM = 320,
     COLUMNS = 321,
     COLUMN_SYM = 322,
     COMMENT_SYM = 323,
     COMMITTED_SYM = 324,
     COMMIT_SYM = 325,
     COMPACT_SYM = 326,
     COMPRESSED_SYM = 327,
     CONCAT = 328,
     CONCAT_WS = 329,
     CONCURRENT = 330,
     CONDITION_SYM = 331,
     CONNECTION_SYM = 332,
     CONSISTENT_SYM = 333,
     CONSTRAINT = 334,
     CONTAINS_SYM = 335,
     CONTEXT_SYM = 336,
     CONTINUE_SYM = 337,
     CONVERT_SYM = 338,
     CONVERT_TZ_SYM = 339,
     COUNT_SYM = 340,
     CPU_SYM = 341,
     CREATE = 342,
     CROSS = 343,
     CUBE_SYM = 344,
     CURDATE = 345,
     CURRENT_USER = 346,
     CURSOR_SYM = 347,
     CURTIME = 348,
     DATABASE = 349,
     DATABASES = 350,
     DATA_SYM = 351,
     DATETIME = 352,
     DATE_ADD_INTERVAL = 353,
     DATE_SUB_INTERVAL = 354,
     DATE_SYM = 355,
     DAY_HOUR_SYM = 356,
     DAY_MICROSECOND_SYM = 357,
     DAY_MINUTE_SYM = 358,
     DAY_SECOND_SYM = 359,
     DAY_SYM = 360,
     DEALLOCATE_SYM = 361,
     DECIMAL_NUM = 362,
     DECIMAL_SYM = 363,
     DECLARE_SYM = 364,
     DECODE_SYM = 365,
     DEFAULT = 366,
     DEFINER_SYM = 367,
     DELAYED_SYM = 368,
     DELAY_KEY_WRITE_SYM = 369,
     DELETE_SYM = 370,
     DESC = 371,
     DESCRIBE = 372,
     DES_DECRYPT_SYM = 373,
     DES_ENCRYPT_SYM = 374,
     DES_KEY_FILE = 375,
     DETERMINISTIC_SYM = 376,
     DIRECTORY_SYM = 377,
     DISABLE_SYM = 378,
     DISCARD = 379,
     DISTINCT = 380,
     DIV_SYM = 381,
     DOUBLE_SYM = 382,
     DO_SYM = 383,
     DROP = 384,
     DUAL_SYM = 385,
     DUMPFILE = 386,
     DUPLICATE_SYM = 387,
     DYNAMIC_SYM = 388,
     EACH_SYM = 389,
     ELSEIF_SYM = 390,
     ELT_FUNC = 391,
     ENABLE_SYM = 392,
     ENCLOSED = 393,
     ENCODE_SYM = 394,
     ENCRYPT = 395,
     END = 396,
     ENGINES_SYM = 397,
     ENGINE_SYM = 398,
     ENUM = 399,
     EQ = 400,
     EQUAL_SYM = 401,
     ERRORS = 402,
     ESCAPED = 403,
     ESCAPE_SYM = 404,
     EVENTS_SYM = 405,
     EXECUTE_SYM = 406,
     EXISTS = 407,
     EXIT_SYM = 408,
     EXPANSION_SYM = 409,
     EXPORT_SET = 410,
     EXTENDED_SYM = 411,
     EXTRACT_SYM = 412,
     FALSE_SYM = 413,
     FAST_SYM = 414,
     FAULTS_SYM = 415,
     FETCH_SYM = 416,
     FIELD_FUNC = 417,
     FILE_SYM = 418,
     FIRST_SYM = 419,
     FIXED_SYM = 420,
     FLOAT_NUM = 421,
     FLOAT_SYM = 422,
     FLUSH_SYM = 423,
     FORCE_SYM = 424,
     FOREIGN = 425,
     FORMAT_SYM = 426,
     FOR_SYM = 427,
     FOUND_SYM = 428,
     FRAC_SECOND_SYM = 429,
     FROM = 430,
     FROM_UNIXTIME = 431,
     FULL = 432,
     FULLTEXT_SYM = 433,
     FUNCTION_SYM = 434,
     FUNC_ARG0 = 435,
     FUNC_ARG1 = 436,
     FUNC_ARG2 = 437,
     FUNC_ARG3 = 438,
     GE = 439,
     GEOMCOLLFROMTEXT = 440,
     GEOMETRYCOLLECTION = 441,
     GEOMETRY_SYM = 442,
     GEOMFROMTEXT = 443,
     GEOMFROMWKB = 444,
     GET_FORMAT = 445,
     GLOBAL_SYM = 446,
     GRANT = 447,
     GRANTS = 448,
     GREATEST_SYM = 449,
     GROUP = 450,
     GROUP_CONCAT_SYM = 451,
     GROUP_UNIQUE_USERS = 452,
     GT_SYM = 453,
     HANDLER_SYM = 454,
     HASH_SYM = 455,
     HAVING = 456,
     HELP_SYM = 457,
     HEX_NUM = 458,
     HIGH_PRIORITY = 459,
     HOSTS_SYM = 460,
     HOUR_MICROSECOND_SYM = 461,
     HOUR_MINUTE_SYM = 462,
     HOUR_SECOND_SYM = 463,
     HOUR_SYM = 464,
     IDENT = 465,
     IDENTIFIED_SYM = 466,
     IDENT_QUOTED = 467,
     IF = 468,
     IGNORE_SYM = 469,
     IMPORT = 470,
     INDEXES = 471,
     INDEX_SYM = 472,
     INFILE = 473,
     INNER_SYM = 474,
     INNOBASE_SYM = 475,
     INOUT_SYM = 476,
     INSENSITIVE_SYM = 477,
     INSERT = 478,
     INSERT_METHOD = 479,
     INTERVAL_SYM = 480,
     INTO = 481,
     INT_SYM = 482,
     INVOKER_SYM = 483,
     IN_SYM = 484,
     IO_SYM = 485,
     IPC_SYM = 486,
     IS = 487,
     ISOLATION = 488,
     ISSUER_SYM = 489,
     ITERATE_SYM = 490,
     JOIN_SYM = 491,
     KEYS = 492,
     KEY_SYM = 493,
     KILL_SYM = 494,
     LABEL_SYM = 495,
     LANGUAGE_SYM = 496,
     LAST_INSERT_ID = 497,
     LAST_SYM = 498,
     LE = 499,
     LEADING = 500,
     LEAST_SYM = 501,
     LEAVES = 502,
     LEAVE_SYM = 503,
     LEFT = 504,
     LEVEL_SYM = 505,
     LEX_HOSTNAME = 506,
     LIKE = 507,
     LIMIT = 508,
     LINEFROMTEXT = 509,
     LINES = 510,
     LINESTRING = 511,
     LOAD = 512,
     LOCAL_SYM = 513,
     LOCATE = 514,
     LOCATOR_SYM = 515,
     LOCKS_SYM = 516,
     LOCK_SYM = 517,
     LOGS_SYM = 518,
     LOG_SYM = 519,
     LONGBLOB = 520,
     LONGTEXT = 521,
     LONG_NUM = 522,
     LONG_SYM = 523,
     LOOP_SYM = 524,
     LOW_PRIORITY = 525,
     LT = 526,
     MAKE_SET_SYM = 527,
     MASTER_CONNECT_RETRY_SYM = 528,
     MASTER_HOST_SYM = 529,
     MASTER_LOG_FILE_SYM = 530,
     MASTER_LOG_POS_SYM = 531,
     MASTER_PASSWORD_SYM = 532,
     MASTER_PORT_SYM = 533,
     MASTER_POS_WAIT = 534,
     MASTER_SERVER_ID_SYM = 535,
     MASTER_SSL_CAPATH_SYM = 536,
     MASTER_SSL_CA_SYM = 537,
     MASTER_SSL_CERT_SYM = 538,
     MASTER_SSL_CIPHER_SYM = 539,
     MASTER_SSL_KEY_SYM = 540,
     MASTER_SSL_SYM = 541,
     MASTER_SYM = 542,
     MASTER_USER_SYM = 543,
     MATCH = 544,
     MAX_CONNECTIONS_PER_HOUR = 545,
     MAX_QUERIES_PER_HOUR = 546,
     MAX_ROWS = 547,
     MAX_SYM = 548,
     MAX_UPDATES_PER_HOUR = 549,
     MAX_USER_CONNECTIONS_SYM = 550,
     MEDIUMBLOB = 551,
     MEDIUMINT = 552,
     MEDIUMTEXT = 553,
     MEDIUM_SYM = 554,
     MEMORY_SYM = 555,
     MERGE_SYM = 556,
     MICROSECOND_SYM = 557,
     MIGRATE_SYM = 558,
     MINUTE_MICROSECOND_SYM = 559,
     MINUTE_SECOND_SYM = 560,
     MINUTE_SYM = 561,
     MIN_ROWS = 562,
     MIN_SYM = 563,
     MLINEFROMTEXT = 564,
     MODE_SYM = 565,
     MODIFIES_SYM = 566,
     MODIFY_SYM = 567,
     MOD_SYM = 568,
     MONTH_SYM = 569,
     MPOINTFROMTEXT = 570,
     MPOLYFROMTEXT = 571,
     MULTILINESTRING = 572,
     MULTIPOINT = 573,
     MULTIPOLYGON = 574,
     MUTEX_SYM = 575,
     NAMES_SYM = 576,
     NAME_SYM = 577,
     NATIONAL_SYM = 578,
     NATURAL = 579,
     NCHAR_STRING = 580,
     NCHAR_SYM = 581,
     NDBCLUSTER_SYM = 582,
     NE = 583,
     NEW_SYM = 584,
     NEXT_SYM = 585,
     NONE_SYM = 586,
     NOT2_SYM = 587,
     NOT_SYM = 588,
     NOW_SYM = 589,
     NO_SYM = 590,
     NO_WRITE_TO_BINLOG = 591,
     NULL_SYM = 592,
     NUM = 593,
     NUMERIC_SYM = 594,
     NVARCHAR_SYM = 595,
     OFFSET_SYM = 596,
     OJ_SYM = 597,
     OLD_PASSWORD = 598,
     ON = 599,
     ONE_SHOT_SYM = 600,
     ONE_SYM = 601,
     OPEN_SYM = 602,
     OPTIMIZE = 603,
     OPTION = 604,
     OPTIONALLY = 605,
     OR2_SYM = 606,
     ORDER_SYM = 607,
     OR_OR_SYM = 608,
     OR_SYM = 609,
     OUTER = 610,
     OUTFILE = 611,
     OUT_SYM = 612,
     PACK_KEYS_SYM = 613,
     PAGE_SYM = 614,
     PARTIAL = 615,
     PASSWORD = 616,
     PARAM_MARKER = 617,
     PHASE_SYM = 618,
     POINTFROMTEXT = 619,
     POINT_SYM = 620,
     POLYFROMTEXT = 621,
     POLYGON = 622,
     POSITION_SYM = 623,
     PRECISION = 624,
     PREPARE_SYM = 625,
     PREV_SYM = 626,
     PRIMARY_SYM = 627,
     PRIVILEGES = 628,
     PROCEDURE = 629,
     PROCESS = 630,
     PROCESSLIST_SYM = 631,
     PROFILE_SYM = 632,
     PROFILES_SYM = 633,
     PURGE = 634,
     QUARTER_SYM = 635,
     QUERY_SYM = 636,
     QUICK = 637,
     RAID_0_SYM = 638,
     RAID_CHUNKS = 639,
     RAID_CHUNKSIZE = 640,
     RAID_STRIPED_SYM = 641,
     RAID_TYPE = 642,
     RAND = 643,
     READS_SYM = 644,
     READ_SYM = 645,
     REAL = 646,
     RECOVER_SYM = 647,
     REDUNDANT_SYM = 648,
     REFERENCES = 649,
     REGEXP = 650,
     RELAY_LOG_FILE_SYM = 651,
     RELAY_LOG_POS_SYM = 652,
     RELAY_THREAD = 653,
     RELEASE_SYM = 654,
     RELOAD = 655,
     RENAME = 656,
     REPAIR = 657,
     REPEATABLE_SYM = 658,
     REPEAT_SYM = 659,
     REPLACE = 660,
     REPLICATION = 661,
     REQUIRE_SYM = 662,
     RESET_SYM = 663,
     RESOURCES = 664,
     RESTORE_SYM = 665,
     RESTRICT = 666,
     RESUME_SYM = 667,
     RETURNS_SYM = 668,
     RETURN_SYM = 669,
     REVOKE = 670,
     RIGHT = 671,
     ROLLBACK_SYM = 672,
     ROLLUP_SYM = 673,
     ROUND = 674,
     ROUTINE_SYM = 675,
     ROWS_SYM = 676,
     ROW_COUNT_SYM = 677,
     ROW_FORMAT_SYM = 678,
     ROW_SYM = 679,
     RTREE_SYM = 680,
     SAVEPOINT_SYM = 681,
     SECOND_MICROSECOND_SYM = 682,
     SECOND_SYM = 683,
     SECURITY_SYM = 684,
     SELECT_SYM = 685,
     SENSITIVE_SYM = 686,
     SEPARATOR_SYM = 687,
     SERIALIZABLE_SYM = 688,
     SERIAL_SYM = 689,
     SESSION_SYM = 690,
     SET = 691,
     SET_VAR = 692,
     SHARE_SYM = 693,
     SHIFT_LEFT = 694,
     SHIFT_RIGHT = 695,
     SHOW = 696,
     SHUTDOWN = 697,
     SIGNED_SYM = 698,
     SIMPLE_SYM = 699,
     SLAVE = 700,
     SMALLINT = 701,
     SNAPSHOT_SYM = 702,
     SOUNDS_SYM = 703,
     SOURCE_SYM = 704,
     SPATIAL_SYM = 705,
     SPECIFIC_SYM = 706,
     SQLEXCEPTION_SYM = 707,
     SQLSTATE_SYM = 708,
     SQLWARNING_SYM = 709,
     SQL_BIG_RESULT = 710,
     SQL_BUFFER_RESULT = 711,
     SQL_CACHE_SYM = 712,
     SQL_CALC_FOUND_ROWS = 713,
     SQL_NO_CACHE_SYM = 714,
     SQL_SMALL_RESULT = 715,
     SQL_SYM = 716,
     SQL_THREAD = 717,
     SSL_SYM = 718,
     STARTING = 719,
     START_SYM = 720,
     STATUS_SYM = 721,
     STD_SYM = 722,
     STDDEV_SAMP_SYM = 723,
     STOP_SYM = 724,
     STORAGE_SYM = 725,
     STRAIGHT_JOIN = 726,
     STRING_SYM = 727,
     SUBDATE_SYM = 728,
     SUBJECT_SYM = 729,
     SUBSTRING = 730,
     SUBSTRING_INDEX = 731,
     SUM_SYM = 732,
     SUPER_SYM = 733,
     SUSPEND_SYM = 734,
     SWAPS_SYM = 735,
     SWITCHES_SYM = 736,
     SYSDATE = 737,
     TABLES = 738,
     TABLESPACE = 739,
     TABLE_SYM = 740,
     TEMPORARY = 741,
     TEMPTABLE_SYM = 742,
     TERMINATED = 743,
     TEXT_STRING = 744,
     TEXT_SYM = 745,
     TIMESTAMP = 746,
     TIMESTAMP_ADD = 747,
     TIMESTAMP_DIFF = 748,
     TIME_SYM = 749,
     TINYBLOB = 750,
     TINYINT = 751,
     TINYTEXT = 752,
     TO_SYM = 753,
     TRAILING = 754,
     TRANSACTION_SYM = 755,
     TRIGGER_SYM = 756,
     TRIGGERS_SYM = 757,
     TRIM = 758,
     TRUE_SYM = 759,
     TRUNCATE_SYM = 760,
     TYPES_SYM = 761,
     TYPE_SYM = 762,
     UDF_RETURNS_SYM = 763,
     UDF_SONAME_SYM = 764,
     ULONGLONG_NUM = 765,
     UNCOMMITTED_SYM = 766,
     UNDEFINED_SYM = 767,
     UNDERSCORE_CHARSET = 768,
     UNDO_SYM = 769,
     UNICODE_SYM = 770,
     UNION_SYM = 771,
     UNIQUE_SYM = 772,
     UNIQUE_USERS = 773,
     UNIX_TIMESTAMP = 774,
     UNKNOWN_SYM = 775,
     UNLOCK_SYM = 776,
     UNSIGNED = 777,
     UNTIL_SYM = 778,
     UPDATE_SYM = 779,
     UPGRADE_SYM = 780,
     USAGE = 781,
     USER = 782,
     USE_FRM = 783,
     USE_SYM = 784,
     USING = 785,
     UTC_DATE_SYM = 786,
     UTC_TIMESTAMP_SYM = 787,
     UTC_TIME_SYM = 788,
     VAR_SAMP_SYM = 789,
     VALUES = 790,
     VALUE_SYM = 791,
     VARBINARY = 792,
     VARCHAR = 793,
     VARIABLES = 794,
     VARIANCE_SYM = 795,
     VARYING = 796,
     VIEW_SYM = 797,
     WARNINGS = 798,
     WEEK_SYM = 799,
     WHEN_SYM = 800,
     WHERE = 801,
     WHILE_SYM = 802,
     WITH = 803,
     WORK_SYM = 804,
     WRITE_SYM = 805,
     X509_SYM = 806,
     XA_SYM = 807,
     XOR = 808,
     YEARWEEK = 809,
     YEAR_MONTH_SYM = 810,
     YEAR_SYM = 811,
     ZEROFILL = 812,
     TABLE_REF_PRIORITY = 813,
     ELSE = 814,
     THEN_SYM = 815,
     CASE_SYM = 816,
     BETWEEN_SYM = 817,
     NEG = 818
   };
#endif
#define END_OF_INPUT 258
#define ABORT_SYM 259
#define ACTION 260
#define ADD 261
#define ADDDATE_SYM 262
#define AFTER_SYM 263
#define AGAINST 264
#define AGGREGATE_SYM 265
#define ALGORITHM_SYM 266
#define ALL 267
#define ALTER 268
#define ANALYZE_SYM 269
#define AND_AND_SYM 270
#define AND_SYM 271
#define ANY_SYM 272
#define AS 273
#define ASC 274
#define ASCII_SYM 275
#define ASENSITIVE_SYM 276
#define ATAN 277
#define AUTO_INC 278
#define AVG_ROW_LENGTH 279
#define AVG_SYM 280
#define BACKUP_SYM 281
#define BEFORE_SYM 282
#define BEGIN_SYM 283
#define BENCHMARK_SYM 284
#define BERKELEY_DB_SYM 285
#define BIGINT 286
#define BINARY 287
#define BINLOG_SYM 288
#define BIN_NUM 289
#define BIT_AND 290
#define BIT_OR 291
#define BIT_SYM 292
#define BIT_XOR 293
#define BLOB_SYM 294
#define BLOCK_SYM 295
#define BOOLEAN_SYM 296
#define BOOL_SYM 297
#define BOTH 298
#define BTREE_SYM 299
#define BY 300
#define BYTE_SYM 301
#define CACHE_SYM 302
#define CALL_SYM 303
#define CASCADE 304
#define CASCADED 305
#define CAST_SYM 306
#define CHAIN_SYM 307
#define CHANGE 308
#define CHANGED 309
#define CHARSET 310
#define CHAR_SYM 311
#define CHECKSUM_SYM 312
#define CHECK_SYM 313
#define CIPHER_SYM 314
#define CLIENT_SYM 315
#define CLOSE_SYM 316
#define COALESCE 317
#define CODE_SYM 318
#define COLLATE_SYM 319
#define COLLATION_SYM 320
#define COLUMNS 321
#define COLUMN_SYM 322
#define COMMENT_SYM 323
#define COMMITTED_SYM 324
#define COMMIT_SYM 325
#define COMPACT_SYM 326
#define COMPRESSED_SYM 327
#define CONCAT 328
#define CONCAT_WS 329
#define CONCURRENT 330
#define CONDITION_SYM 331
#define CONNECTION_SYM 332
#define CONSISTENT_SYM 333
#define CONSTRAINT 334
#define CONTAINS_SYM 335
#define CONTEXT_SYM 336
#define CONTINUE_SYM 337
#define CONVERT_SYM 338
#define CONVERT_TZ_SYM 339
#define COUNT_SYM 340
#define CPU_SYM 341
#define CREATE 342
#define CROSS 343
#define CUBE_SYM 344
#define CURDATE 345
#define CURRENT_USER 346
#define CURSOR_SYM 347
#define CURTIME 348
#define DATABASE 349
#define DATABASES 350
#define DATA_SYM 351
#define DATETIME 352
#define DATE_ADD_INTERVAL 353
#define DATE_SUB_INTERVAL 354
#define DATE_SYM 355
#define DAY_HOUR_SYM 356
#define DAY_MICROSECOND_SYM 357
#define DAY_MINUTE_SYM 358
#define DAY_SECOND_SYM 359
#define DAY_SYM 360
#define DEALLOCATE_SYM 361
#define DECIMAL_NUM 362
#define DECIMAL_SYM 363
#define DECLARE_SYM 364
#define DECODE_SYM 365
#define DEFAULT 366
#define DEFINER_SYM 367
#define DELAYED_SYM 368
#define DELAY_KEY_WRITE_SYM 369
#define DELETE_SYM 370
#define DESC 371
#define DESCRIBE 372
#define DES_DECRYPT_SYM 373
#define DES_ENCRYPT_SYM 374
#define DES_KEY_FILE 375
#define DETERMINISTIC_SYM 376
#define DIRECTORY_SYM 377
#define DISABLE_SYM 378
#define DISCARD 379
#define DISTINCT 380
#define DIV_SYM 381
#define DOUBLE_SYM 382
#define DO_SYM 383
#define DROP 384
#define DUAL_SYM 385
#define DUMPFILE 386
#define DUPLICATE_SYM 387
#define DYNAMIC_SYM 388
#define EACH_SYM 389
#define ELSEIF_SYM 390
#define ELT_FUNC 391
#define ENABLE_SYM 392
#define ENCLOSED 393
#define ENCODE_SYM 394
#define ENCRYPT 395
#define END 396
#define ENGINES_SYM 397
#define ENGINE_SYM 398
#define ENUM 399
#define EQ 400
#define EQUAL_SYM 401
#define ERRORS 402
#define ESCAPED 403
#define ESCAPE_SYM 404
#define EVENTS_SYM 405
#define EXECUTE_SYM 406
#define EXISTS 407
#define EXIT_SYM 408
#define EXPANSION_SYM 409
#define EXPORT_SET 410
#define EXTENDED_SYM 411
#define EXTRACT_SYM 412
#define FALSE_SYM 413
#define FAST_SYM 414
#define FAULTS_SYM 415
#define FETCH_SYM 416
#define FIELD_FUNC 417
#define FILE_SYM 418
#define FIRST_SYM 419
#define FIXED_SYM 420
#define FLOAT_NUM 421
#define FLOAT_SYM 422
#define FLUSH_SYM 423
#define FORCE_SYM 424
#define FOREIGN 425
#define FORMAT_SYM 426
#define FOR_SYM 427
#define FOUND_SYM 428
#define FRAC_SECOND_SYM 429
#define FROM 430
#define FROM_UNIXTIME 431
#define FULL 432
#define FULLTEXT_SYM 433
#define FUNCTION_SYM 434
#define FUNC_ARG0 435
#define FUNC_ARG1 436
#define FUNC_ARG2 437
#define FUNC_ARG3 438
#define GE 439
#define GEOMCOLLFROMTEXT 440
#define GEOMETRYCOLLECTION 441
#define GEOMETRY_SYM 442
#define GEOMFROMTEXT 443
#define GEOMFROMWKB 444
#define GET_FORMAT 445
#define GLOBAL_SYM 446
#define GRANT 447
#define GRANTS 448
#define GREATEST_SYM 449
#define GROUP 450
#define GROUP_CONCAT_SYM 451
#define GROUP_UNIQUE_USERS 452
#define GT_SYM 453
#define HANDLER_SYM 454
#define HASH_SYM 455
#define HAVING 456
#define HELP_SYM 457
#define HEX_NUM 458
#define HIGH_PRIORITY 459
#define HOSTS_SYM 460
#define HOUR_MICROSECOND_SYM 461
#define HOUR_MINUTE_SYM 462
#define HOUR_SECOND_SYM 463
#define HOUR_SYM 464
#define IDENT 465
#define IDENTIFIED_SYM 466
#define IDENT_QUOTED 467
#define IF 468
#define IGNORE_SYM 469
#define IMPORT 470
#define INDEXES 471
#define INDEX_SYM 472
#define INFILE 473
#define INNER_SYM 474
#define INNOBASE_SYM 475
#define INOUT_SYM 476
#define INSENSITIVE_SYM 477
#define INSERT 478
#define INSERT_METHOD 479
#define INTERVAL_SYM 480
#define INTO 481
#define INT_SYM 482
#define INVOKER_SYM 483
#define IN_SYM 484
#define IO_SYM 485
#define IPC_SYM 486
#define IS 487
#define ISOLATION 488
#define ISSUER_SYM 489
#define ITERATE_SYM 490
#define JOIN_SYM 491
#define KEYS 492
#define KEY_SYM 493
#define KILL_SYM 494
#define LABEL_SYM 495
#define LANGUAGE_SYM 496
#define LAST_INSERT_ID 497
#define LAST_SYM 498
#define LE 499
#define LEADING 500
#define LEAST_SYM 501
#define LEAVES 502
#define LEAVE_SYM 503
#define LEFT 504
#define LEVEL_SYM 505
#define LEX_HOSTNAME 506
#define LIKE 507
#define LIMIT 508
#define LINEFROMTEXT 509
#define LINES 510
#define LINESTRING 511
#define LOAD 512
#define LOCAL_SYM 513
#define LOCATE 514
#define LOCATOR_SYM 515
#define LOCKS_SYM 516
#define LOCK_SYM 517
#define LOGS_SYM 518
#define LOG_SYM 519
#define LONGBLOB 520
#define LONGTEXT 521
#define LONG_NUM 522
#define LONG_SYM 523
#define LOOP_SYM 524
#define LOW_PRIORITY 525
#define LT 526
#define MAKE_SET_SYM 527
#define MASTER_CONNECT_RETRY_SYM 528
#define MASTER_HOST_SYM 529
#define MASTER_LOG_FILE_SYM 530
#define MASTER_LOG_POS_SYM 531
#define MASTER_PASSWORD_SYM 532
#define MASTER_PORT_SYM 533
#define MASTER_POS_WAIT 534
#define MASTER_SERVER_ID_SYM 535
#define MASTER_SSL_CAPATH_SYM 536
#define MASTER_SSL_CA_SYM 537
#define MASTER_SSL_CERT_SYM 538
#define MASTER_SSL_CIPHER_SYM 539
#define MASTER_SSL_KEY_SYM 540
#define MASTER_SSL_SYM 541
#define MASTER_SYM 542
#define MASTER_USER_SYM 543
#define MATCH 544
#define MAX_CONNECTIONS_PER_HOUR 545
#define MAX_QUERIES_PER_HOUR 546
#define MAX_ROWS 547
#define MAX_SYM 548
#define MAX_UPDATES_PER_HOUR 549
#define MAX_USER_CONNECTIONS_SYM 550
#define MEDIUMBLOB 551
#define MEDIUMINT 552
#define MEDIUMTEXT 553
#define MEDIUM_SYM 554
#define MEMORY_SYM 555
#define MERGE_SYM 556
#define MICROSECOND_SYM 557
#define MIGRATE_SYM 558
#define MINUTE_MICROSECOND_SYM 559
#define MINUTE_SECOND_SYM 560
#define MINUTE_SYM 561
#define MIN_ROWS 562
#define MIN_SYM 563
#define MLINEFROMTEXT 564
#define MODE_SYM 565
#define MODIFIES_SYM 566
#define MODIFY_SYM 567
#define MOD_SYM 568
#define MONTH_SYM 569
#define MPOINTFROMTEXT 570
#define MPOLYFROMTEXT 571
#define MULTILINESTRING 572
#define MULTIPOINT 573
#define MULTIPOLYGON 574
#define MUTEX_SYM 575
#define NAMES_SYM 576
#define NAME_SYM 577
#define NATIONAL_SYM 578
#define NATURAL 579
#define NCHAR_STRING 580
#define NCHAR_SYM 581
#define NDBCLUSTER_SYM 582
#define NE 583
#define NEW_SYM 584
#define NEXT_SYM 585
#define NONE_SYM 586
#define NOT2_SYM 587
#define NOT_SYM 588
#define NOW_SYM 589
#define NO_SYM 590
#define NO_WRITE_TO_BINLOG 591
#define NULL_SYM 592
#define NUM 593
#define NUMERIC_SYM 594
#define NVARCHAR_SYM 595
#define OFFSET_SYM 596
#define OJ_SYM 597
#define OLD_PASSWORD 598
#define ON 599
#define ONE_SHOT_SYM 600
#define ONE_SYM 601
#define OPEN_SYM 602
#define OPTIMIZE 603
#define OPTION 604
#define OPTIONALLY 605
#define OR2_SYM 606
#define ORDER_SYM 607
#define OR_OR_SYM 608
#define OR_SYM 609
#define OUTER 610
#define OUTFILE 611
#define OUT_SYM 612
#define PACK_KEYS_SYM 613
#define PAGE_SYM 614
#define PARTIAL 615
#define PASSWORD 616
#define PARAM_MARKER 617
#define PHASE_SYM 618
#define POINTFROMTEXT 619
#define POINT_SYM 620
#define POLYFROMTEXT 621
#define POLYGON 622
#define POSITION_SYM 623
#define PRECISION 624
#define PREPARE_SYM 625
#define PREV_SYM 626
#define PRIMARY_SYM 627
#define PRIVILEGES 628
#define PROCEDURE 629
#define PROCESS 630
#define PROCESSLIST_SYM 631
#define PROFILE_SYM 632
#define PROFILES_SYM 633
#define PURGE 634
#define QUARTER_SYM 635
#define QUERY_SYM 636
#define QUICK 637
#define RAID_0_SYM 638
#define RAID_CHUNKS 639
#define RAID_CHUNKSIZE 640
#define RAID_STRIPED_SYM 641
#define RAID_TYPE 642
#define RAND 643
#define READS_SYM 644
#define READ_SYM 645
#define REAL 646
#define RECOVER_SYM 647
#define REDUNDANT_SYM 648
#define REFERENCES 649
#define REGEXP 650
#define RELAY_LOG_FILE_SYM 651
#define RELAY_LOG_POS_SYM 652
#define RELAY_THREAD 653
#define RELEASE_SYM 654
#define RELOAD 655
#define RENAME 656
#define REPAIR 657
#define REPEATABLE_SYM 658
#define REPEAT_SYM 659
#define REPLACE 660
#define REPLICATION 661
#define REQUIRE_SYM 662
#define RESET_SYM 663
#define RESOURCES 664
#define RESTORE_SYM 665
#define RESTRICT 666
#define RESUME_SYM 667
#define RETURNS_SYM 668
#define RETURN_SYM 669
#define REVOKE 670
#define RIGHT 671
#define ROLLBACK_SYM 672
#define ROLLUP_SYM 673
#define ROUND 674
#define ROUTINE_SYM 675
#define ROWS_SYM 676
#define ROW_COUNT_SYM 677
#define ROW_FORMAT_SYM 678
#define ROW_SYM 679
#define RTREE_SYM 680
#define SAVEPOINT_SYM 681
#define SECOND_MICROSECOND_SYM 682
#define SECOND_SYM 683
#define SECURITY_SYM 684
#define SELECT_SYM 685
#define SENSITIVE_SYM 686
#define SEPARATOR_SYM 687
#define SERIALIZABLE_SYM 688
#define SERIAL_SYM 689
#define SESSION_SYM 690
#define SET 691
#define SET_VAR 692
#define SHARE_SYM 693
#define SHIFT_LEFT 694
#define SHIFT_RIGHT 695
#define SHOW 696
#define SHUTDOWN 697
#define SIGNED_SYM 698
#define SIMPLE_SYM 699
#define SLAVE 700
#define SMALLINT 701
#define SNAPSHOT_SYM 702
#define SOUNDS_SYM 703
#define SOURCE_SYM 704
#define SPATIAL_SYM 705
#define SPECIFIC_SYM 706
#define SQLEXCEPTION_SYM 707
#define SQLSTATE_SYM 708
#define SQLWARNING_SYM 709
#define SQL_BIG_RESULT 710
#define SQL_BUFFER_RESULT 711
#define SQL_CACHE_SYM 712
#define SQL_CALC_FOUND_ROWS 713
#define SQL_NO_CACHE_SYM 714
#define SQL_SMALL_RESULT 715
#define SQL_SYM 716
#define SQL_THREAD 717
#define SSL_SYM 718
#define STARTING 719
#define START_SYM 720
#define STATUS_SYM 721
#define STD_SYM 722
#define STDDEV_SAMP_SYM 723
#define STOP_SYM 724
#define STORAGE_SYM 725
#define STRAIGHT_JOIN 726
#define STRING_SYM 727
#define SUBDATE_SYM 728
#define SUBJECT_SYM 729
#define SUBSTRING 730
#define SUBSTRING_INDEX 731
#define SUM_SYM 732
#define SUPER_SYM 733
#define SUSPEND_SYM 734
#define SWAPS_SYM 735
#define SWITCHES_SYM 736
#define SYSDATE 737
#define TABLES 738
#define TABLESPACE 739
#define TABLE_SYM 740
#define TEMPORARY 741
#define TEMPTABLE_SYM 742
#define TERMINATED 743
#define TEXT_STRING 744
#define TEXT_SYM 745
#define TIMESTAMP 746
#define TIMESTAMP_ADD 747
#define TIMESTAMP_DIFF 748
#define TIME_SYM 749
#define TINYBLOB 750
#define TINYINT 751
#define TINYTEXT 752
#define TO_SYM 753
#define TRAILING 754
#define TRANSACTION_SYM 755
#define TRIGGER_SYM 756
#define TRIGGERS_SYM 757
#define TRIM 758
#define TRUE_SYM 759
#define TRUNCATE_SYM 760
#define TYPES_SYM 761
#define TYPE_SYM 762
#define UDF_RETURNS_SYM 763
#define UDF_SONAME_SYM 764
#define ULONGLONG_NUM 765
#define UNCOMMITTED_SYM 766
#define UNDEFINED_SYM 767
#define UNDERSCORE_CHARSET 768
#define UNDO_SYM 769
#define UNICODE_SYM 770
#define UNION_SYM 771
#define UNIQUE_SYM 772
#define UNIQUE_USERS 773
#define UNIX_TIMESTAMP 774
#define UNKNOWN_SYM 775
#define UNLOCK_SYM 776
#define UNSIGNED 777
#define UNTIL_SYM 778
#define UPDATE_SYM 779
#define UPGRADE_SYM 780
#define USAGE 781
#define USER 782
#define USE_FRM 783
#define USE_SYM 784
#define USING 785
#define UTC_DATE_SYM 786
#define UTC_TIMESTAMP_SYM 787
#define UTC_TIME_SYM 788
#define VAR_SAMP_SYM 789
#define VALUES 790
#define VALUE_SYM 791
#define VARBINARY 792
#define VARCHAR 793
#define VARIABLES 794
#define VARIANCE_SYM 795
#define VARYING 796
#define VIEW_SYM 797
#define WARNINGS 798
#define WEEK_SYM 799
#define WHEN_SYM 800
#define WHERE 801
#define WHILE_SYM 802
#define WITH 803
#define WORK_SYM 804
#define WRITE_SYM 805
#define X509_SYM 806
#define XA_SYM 807
#define XOR 808
#define YEARWEEK 809
#define YEAR_MONTH_SYM 810
#define YEAR_SYM 811
#define ZEROFILL 812
#define TABLE_REF_PRIORITY 813
#define ELSE 814
#define THEN_SYM 815
#define CASE_SYM 816
#define BETWEEN_SYM 817
#define NEG 818




/* Copy the first part of user declarations.  */
#line 18 "sql_yacc.yy"

/* thd is passed as an arg to yyparse(), and subsequently to yylex().
** The type will be void*, so it must be  cast to (THD*) when used.
** Use the YYTHD macro for this.
*/
#define YYPARSE_PARAM yythd
#define YYLEX_PARAM yythd
#define YYTHD ((THD *)yythd)

#define MYSQL_YACC
#define YYINITDEPTH 100
#define YYMAXDEPTH 3200				/* Because of 64K stack */
#define Lex (YYTHD->lex)
#define Select Lex->current_select
#include "mysql_priv.h"
#include "slave.h"
#include "lex_symbol.h"
#include "item_create.h"
#include "sp_head.h"
#include "sp_pcontext.h"
#include "sp_rcontext.h"
#include "sp.h"
#include <myisam.h>
#include <myisammrg.h>

int yylex(void *yylval, void *yythd);

const LEX_STRING null_lex_str={0,0};

#define yyoverflow(A,B,C,D,E,F) {ulong val= *(F); if (my_yyoverflow((B), (D), &val)) { yyerror((char*) (A)); return 2; } else { *(F)= (YYSIZE_T)val; }}

#undef 	WARN_DEPRECATED			/* this macro is also defined in mysql_priv.h */
#define WARN_DEPRECATED(A,B)                                        \
  push_warning_printf(((THD *)yythd), MYSQL_ERROR::WARN_LEVEL_WARN, \
		      ER_WARN_DEPRECATED_SYNTAX,                    \
		      ER(ER_WARN_DEPRECATED_SYNTAX), (A), (B));

#define MYSQL_YYABORT                         \
  do                                          \
  {                                           \
    LEX::cleanup_lex_after_parse_error(YYTHD);\
    YYABORT;                                  \
  } while (0)

#define MYSQL_YYABORT_UNLESS(A)         \
  if (!(A))                             \
  {                                     \
    my_parse_error(ER(ER_SYNTAX_ERROR));\
    MYSQL_YYABORT;                      \
  }

#ifndef DBUG_OFF
#define YYDEBUG 1
#else
#define YYDEBUG 0
#endif

/**
  @brief Push an error message into MySQL error stack with line
  and position information.

  This function provides semantic action implementers with a way
  to push the famous "You have a syntax error near..." error
  message into the error stack, which is normally produced only if
  a parse error is discovered internally by the Bison generated
  parser.
*/

void my_parse_error(const char *s)
{
  THD *thd= current_thd;
  Lex_input_stream *lip= thd->m_lip;

  const char *yytext= lip->tok_start;
  /* Push an error into the error stack */
  my_printf_error(ER_PARSE_ERROR,  ER(ER_PARSE_ERROR), MYF(0), s,
                  (yytext ? yytext : ""),
                  lip->yylineno);
}

/**
  @brief Bison callback to report a syntax/OOM error

  This function is invoked by the bison-generated parser
  when a syntax error, a parse error or an out-of-memory
  condition occurs. This function is not invoked when the
  parser is requested to abort by semantic action code
  by means of YYABORT or YYACCEPT macros. This is why these
  macros should not be used (use MYSQL_YYABORT/MYSQL_YYACCEPT
  instead).

  The parser will abort immediately after invoking this callback.

  This function is not for use in semantic actions and is internal to
  the parser, as it performs some pre-return cleanup. 
  In semantic actions, please use my_parse_error or my_error to
  push an error into the error stack and MYSQL_YYABORT
  to abort from the parser.
*/

void MYSQLerror(const char *s)
{
  THD *thd= current_thd;

  /*
    Restore the original LEX if it was replaced when parsing
    a stored procedure. We must ensure that a parsing error
    does not leave any side effects in the THD.
  */
  LEX::cleanup_lex_after_parse_error(thd);

  /* "parse error" changed into "syntax error" between bison 1.75 and 1.875 */
  if (strcmp(s,"parse error") == 0 || strcmp(s,"syntax error") == 0)
    s= ER(ER_SYNTAX_ERROR);
  my_parse_error(s);
}


#ifndef DBUG_OFF
void turn_parser_debug_on()
{
  /*
     MYSQLdebug is in sql/sql_yacc.cc, in bison generated code.
     Turning this option on is **VERY** verbose, and should be
     used when investigating a syntax error problem only.

     The syntax to run with bison traces is as follows :
     - Starting a server manually :
       mysqld --debug="d,parser_debug" ...
     - Running a test :
       mysql-test-run.pl --mysqld="--debug=d,parser_debug" ...

     The result will be in the process stderr (var/log/master.err)
   */

  extern int yydebug;
  yydebug= 1;
}
#endif


/**
  Helper action for a case statement (entering the CASE).
  This helper is used for both 'simple' and 'searched' cases.
  This helper, with the other case_stmt_action_..., is executed when
  the following SQL code is parsed:
<pre>
CREATE PROCEDURE proc_19194_simple(i int)
BEGIN
  DECLARE str CHAR(10);

  CASE i
    WHEN 1 THEN SET str="1";
    WHEN 2 THEN SET str="2";
    WHEN 3 THEN SET str="3";
    ELSE SET str="unknown";
  END CASE;

  SELECT str;
END
</pre>
  The actions are used to generate the following code:
<pre>
SHOW PROCEDURE CODE proc_19194_simple;
Pos     Instruction
0       set str@1 NULL
1       set_case_expr (12) 0 i@0
2       jump_if_not 5(12) (case_expr@0 = 1)
3       set str@1 _latin1'1'
4       jump 12
5       jump_if_not 8(12) (case_expr@0 = 2)
6       set str@1 _latin1'2'
7       jump 12
8       jump_if_not 11(12) (case_expr@0 = 3)
9       set str@1 _latin1'3'
10      jump 12
11      set str@1 _latin1'unknown'
12      stmt 0 "SELECT str"
</pre>

  @param lex the parser lex context
*/

void case_stmt_action_case(LEX *lex)
{
  lex->sphead->new_cont_backpatch(NULL);

  /*
    BACKPATCH: Creating target label for the jump to
    "case_stmt_action_end_case"
    (Instruction 12 in the example)
  */

  lex->spcont->push_label((char *)"", lex->sphead->instructions());
}

/**
  Helper action for a case expression statement (the expr in 'CASE expr').
  This helper is used for 'searched' cases only.
  @param lex the parser lex context
  @param expr the parsed expression
  @return 0 on success
*/

int case_stmt_action_expr(LEX *lex, Item* expr)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *parsing_ctx= lex->spcont;
  int case_expr_id= parsing_ctx->register_case_expr();
  sp_instr_set_case_expr *i;

  if (parsing_ctx->push_case_expr_id(case_expr_id))
    return 1;

  i= new sp_instr_set_case_expr(sp->instructions(),
                                parsing_ctx, case_expr_id, expr, lex);

  sp->add_cont_backpatch(i);
  sp->add_instr(i);

  return 0;
}

/**
  Helper action for a case when condition.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param when the parsed expression for the WHEN clause
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_when(LEX *lex, Item *when, bool simple)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump_if_not *i;
  Item_case_expr *var;
  Item *expr;

  if (simple)
  {
    var= new Item_case_expr(ctx->get_current_case_expr_id());

#ifndef DBUG_OFF
    if (var)
    {
      var->m_sp= sp;
    }
#endif

    expr= new Item_func_eq(var, when);
    i= new sp_instr_jump_if_not(ip, ctx, expr, lex);
  }
  else
    i= new sp_instr_jump_if_not(ip, ctx, when, lex);

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->push_backpatch(i, ctx->push_label((char *)"", 0));
  sp->add_cont_backpatch(i);
  sp->add_instr(i);
}

/**
  Helper action for a case then statements.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
*/

void case_stmt_action_then(LEX *lex)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump *i = new sp_instr_jump(ip, ctx);
  sp->add_instr(i);

  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->backpatch(ctx->pop_label());

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */

  sp->push_backpatch(i, ctx->last_label());
}

/**
  Helper action for an end case.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_end_case(LEX *lex, bool simple)
{
  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */
  lex->sphead->backpatch(lex->spcont->pop_label());

  if (simple)
    lex->spcont->pop_case_expr_id();

  lex->sphead->do_cont_backpatch();
}

/**
  Helper to resolve the SQL:2003 Syntax exception 1) in <in predicate>.
  See SQL:2003, Part 2, section 8.4 <in predicate>, Note 184, page 383.
  This function returns the proper item for the SQL expression
  <code>left [NOT] IN ( expr )</code>
  @param thd the current thread
  @param left the in predicand
  @param equal true for IN predicates, false for NOT IN predicates
  @param expr first and only expression of the in value list
  @return an expression representing the IN predicate.
*/
Item* handle_sql2003_note184_exception(THD *thd, Item* left, bool equal,
                                       Item *expr)
{
  /*
    Relevant references for this issue:
    - SQL:2003, Part 2, section 8.4 <in predicate>, page 383,
    - SQL:2003, Part 2, section 7.2 <row value expression>, page 296,
    - SQL:2003, Part 2, section 6.3 <value expression primary>, page 174,
    - SQL:2003, Part 2, section 7.15 <subquery>, page 370,
    - SQL:2003 Feature F561, "Full value expressions".

    The exception in SQL:2003 Note 184 means:
    Item_singlerow_subselect, which corresponds to a <scalar subquery>,
    should be re-interpreted as an Item_in_subselect, which corresponds
    to a <table subquery> when used inside an <in predicate>.

    Our reading of Note 184 is reccursive, so that all:
    - IN (( <subquery> ))
    - IN ((( <subquery> )))
    - IN '('^N <subquery> ')'^N
    - etc
    should be interpreted as a <table subquery>, no matter how deep in the
    expression the <subquery> is.
  */

  Item *result;

  DBUG_ENTER("handle_sql2003_note184_exception");

  if (expr->type() == Item::SUBSELECT_ITEM)
  {
    Item_subselect *expr2 = (Item_subselect*) expr;

    if (expr2->substype() == Item_subselect::SINGLEROW_SUBS)
    {
      Item_singlerow_subselect *expr3 = (Item_singlerow_subselect*) expr2;
      st_select_lex *subselect;

      /*
        Implement the mandated change, by altering the semantic tree:
          left IN Item_singlerow_subselect(subselect)
        is modified to
          left IN (subselect)
        which is represented as
          Item_in_subselect(left, subselect)
      */
      subselect= expr3->invalidate_and_restore_select_lex();
      result= new (thd->mem_root) Item_in_subselect(left, subselect);

      if (! equal)
        result = negate_expression(thd, result);

      DBUG_RETURN(result);
    }
  }

  if (equal)
    result= new (thd->mem_root) Item_func_eq(left, expr);
  else
    result= new (thd->mem_root) Item_func_ne(left, expr);

  DBUG_RETURN(result);
}



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 415 "sql_yacc.yy"
typedef union YYSTYPE {
  int  num;
  ulong ulong_num;
  ulonglong ulonglong_number;
  LEX_STRING lex_str;
  LEX_STRING *lex_str_ptr;
  LEX_SYMBOL symbol;
  Table_ident *table;
  char *simple_string;
  Item *item;
  Item_num *item_num;
  List<Item> *item_list;
  List<String> *string_list;
  String *string;
  key_part_spec *key_part;
  TABLE_LIST *table_list;
  udf_func *udf;
  LEX_USER *lex_user;
  struct sys_var_with_base variable;
  enum enum_var_type var_type;
  Key::Keytype key_type;
  enum ha_key_alg key_alg;
  enum db_type db_type;
  enum row_type row_type;
  enum ha_rkey_function ha_rkey_mode;
  enum enum_tx_isolation tx_isolation;
  enum Cast_target cast_type;
  enum Item_udftype udf_type;
  CHARSET_INFO *charset;
  thr_lock_type lock_type;
  interval_type interval, interval_time_st;
  timestamp_type date_time_type;
  st_select_lex *select_lex;
  chooser_compare_func_creator boolfunc2creator;
  struct sp_cond_type *spcondtype;
  struct { int vars, conds, hndlrs, curs; } spblock;
  sp_name *spname;
  struct st_lex *lex;
} YYSTYPE;
/* Line 190 of yacc.c.  */
#line 1648 "sql_yacc.cc"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */
#line 455 "sql_yacc.yy"

bool my_yyoverflow(short **a, YYSTYPE **b, ulong *yystacksize);


/* Line 213 of yacc.c.  */
#line 1663 "sql_yacc.cc"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

# ifndef YYFREE
#  define YYFREE free
# endif
# ifndef YYMALLOC
#  define YYMALLOC malloc
# endif

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   else
#    define YYSTACK_ALLOC alloca
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (defined (YYSTYPE_IS_TRIVIAL) && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short int yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short int) + sizeof (YYSTYPE))			\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined (__GNUC__) && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short int yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  472
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   43820

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  583
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  668
/* YYNRULES -- Number of rules. */
#define YYNRULES  2047
/* YYNRULES -- Number of states. */
#define YYNSTATES  3698

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   818

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short int yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   576,     2,     2,     2,   569,   564,     2,
     573,   574,   567,   566,   575,   565,   580,   568,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   582,   581,
       2,     2,     2,     2,   579,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,   570,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   577,   563,   578,   571,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   572
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short int yyprhs[] =
{
       0,     0,     3,     5,     8,    10,    12,    14,    16,    18,
      20,    22,    24,    26,    28,    30,    32,    34,    36,    38,
      40,    42,    44,    46,    48,    50,    52,    54,    56,    58,
      60,    62,    64,    66,    68,    70,    72,    74,    76,    78,
      80,    82,    84,    86,    88,    90,    92,    94,    96,    98,
     100,   102,   104,   106,   110,   112,   114,   119,   121,   124,
     125,   130,   131,   134,   138,   140,   143,   144,   148,   149,
     155,   157,   161,   165,   169,   173,   177,   181,   185,   189,
     193,   197,   201,   205,   207,   211,   215,   219,   223,   224,
     232,   233,   245,   246,   253,   254,   258,   263,   264,   268,
     270,   275,   276,   277,   278,   279,   280,   293,   294,   297,
     298,   301,   304,   307,   310,   313,   317,   321,   323,   325,
     327,   330,   334,   338,   339,   344,   345,   349,   350,   352,
     356,   358,   359,   361,   365,   367,   368,   372,   373,   375,
     379,   381,   386,   387,   389,   391,   393,   394,   398,   401,
     405,   406,   410,   411,   417,   423,   424,   432,   438,   439,
     442,   444,   446,   448,   452,   454,   456,   460,   461,   463,
     465,   467,   469,   472,   474,   476,   480,   481,   484,   485,
     488,   489,   493,   494,   500,   502,   504,   505,   508,   511,
     514,   517,   518,   525,   528,   529,   532,   534,   536,   540,
     541,   542,   543,   551,   552,   555,   558,   560,   562,   563,
     564,   573,   574,   581,   583,   586,   588,   591,   592,   593,
     600,   601,   602,   609,   610,   613,   614,   620,   621,   623,
     624,   630,   635,   636,   637,   646,   647,   655,   657,   659,
     661,   663,   665,   668,   671,   674,   679,   684,   685,   690,
     691,   692,   698,   699,   707,   708,   709,   716,   717,   719,
     720,   722,   724,   727,   729,   731,   732,   734,   736,   739,
     741,   742,   746,   747,   749,   751,   754,   756,   759,   763,
     767,   771,   775,   779,   783,   787,   791,   795,   799,   803,
     807,   811,   815,   819,   823,   827,   833,   835,   837,   841,
     846,   851,   855,   860,   865,   867,   869,   871,   873,   875,
     877,   879,   881,   883,   885,   887,   889,   891,   893,   896,
     897,   899,   901,   903,   905,   907,   909,   913,   915,   917,
     920,   923,   930,   938,   947,   950,   953,   954,   956,   959,
     960,   962,   965,   966,   971,   975,   979,   983,   985,   990,
     992,   994,  1000,  1003,  1009,  1012,  1017,  1019,  1025,  1031,
    1036,  1040,  1042,  1044,  1047,  1049,  1051,  1054,  1056,  1058,
    1060,  1063,  1067,  1070,  1074,  1077,  1080,  1084,  1088,  1092,
    1093,  1100,  1101,  1108,  1111,  1113,  1115,  1117,  1119,  1121,
    1123,  1125,  1127,  1129,  1131,  1133,  1136,  1139,  1141,  1144,
    1146,  1149,  1153,  1156,  1158,  1160,  1162,  1164,  1166,  1168,
    1170,  1173,  1174,  1178,  1180,  1186,  1187,  1189,  1192,  1194,
    1196,  1198,  1200,  1201,  1205,  1206,  1208,  1209,  1211,  1214,
    1216,  1218,  1221,  1224,  1229,  1231,  1235,  1238,  1240,  1243,
    1246,  1249,  1252,  1254,  1257,  1259,  1261,  1263,  1265,  1267,
    1268,  1271,  1273,  1275,  1277,  1279,  1281,  1282,  1285,  1287,
    1289,  1290,  1292,  1293,  1296,  1298,  1301,  1305,  1308,  1309,
    1311,  1312,  1314,  1316,  1319,  1320,  1322,  1323,  1328,  1330,
    1335,  1339,  1341,  1342,  1344,  1347,  1349,  1353,  1357,  1360,
    1363,  1366,  1368,  1370,  1373,  1376,  1379,  1381,  1384,  1387,
    1390,  1393,  1395,  1397,  1398,  1400,  1402,  1404,  1406,  1407,
    1409,  1411,  1413,  1414,  1417,  1420,  1422,  1424,  1426,  1431,
    1434,  1436,  1441,  1442,  1444,  1445,  1448,  1450,  1454,  1455,
    1462,  1463,  1469,  1470,  1476,  1477,  1483,  1484,  1496,  1497,
    1499,  1500,  1503,  1506,  1508,  1512,  1515,  1519,  1522,  1527,
    1528,  1535,  1536,  1537,  1546,  1551,  1556,  1560,  1564,  1567,
    1570,  1577,  1583,  1587,  1593,  1595,  1597,  1599,  1600,  1602,
    1603,  1605,  1606,  1608,  1610,  1611,  1614,  1616,  1617,  1619,
    1621,  1623,  1624,  1630,  1634,  1635,  1641,  1645,  1649,  1650,
    1654,  1655,  1658,  1660,  1664,  1665,  1667,  1669,  1670,  1673,
    1675,  1679,  1680,  1687,  1688,  1695,  1696,  1702,  1703,  1705,
    1707,  1708,  1715,  1716,  1718,  1720,  1723,  1725,  1727,  1729,
    1730,  1737,  1738,  1744,  1745,  1747,  1749,  1752,  1754,  1756,
    1758,  1760,  1762,  1765,  1766,  1773,  1774,  1776,  1778,  1779,
    1784,  1789,  1793,  1799,  1801,  1805,  1809,  1815,  1817,  1821,
    1824,  1826,  1828,  1829,  1836,  1838,  1842,  1846,  1847,  1850,
    1851,  1856,  1857,  1860,  1862,  1865,  1870,  1873,  1877,  1878,
    1882,  1883,  1884,  1891,  1894,  1896,  1898,  1901,  1904,  1913,
    1918,  1919,  1921,  1924,  1926,  1928,  1930,  1932,  1934,  1936,
    1938,  1940,  1942,  1944,  1946,  1947,  1950,  1955,  1959,  1961,
    1963,  1968,  1969,  1970,  1972,  1974,  1975,  1978,  1981,  1983,
    1985,  1986,  1989,  1993,  1997,  2001,  2004,  2008,  2013,  2017,
    2022,  2026,  2031,  2033,  2037,  2042,  2046,  2050,  2057,  2059,
    2065,  2072,  2078,  2086,  2093,  2102,  2108,  2115,  2120,  2125,
    2131,  2135,  2140,  2142,  2146,  2150,  2154,  2158,  2162,  2166,
    2171,  2176,  2180,  2184,  2188,  2192,  2196,  2200,  2202,  2204,
    2206,  2208,  2210,  2212,  2214,  2216,  2218,  2220,  2222,  2224,
    2226,  2228,  2230,  2232,  2234,  2237,  2239,  2243,  2245,  2247,
    2249,  2251,  2255,  2258,  2261,  2264,  2267,  2271,  2275,  2281,
    2288,  2293,  2298,  2306,  2311,  2314,  2321,  2327,  2334,  2341,
    2346,  2351,  2355,  2360,  2367,  2376,  2383,  2392,  2399,  2404,
    2411,  2416,  2423,  2428,  2433,  2438,  2443,  2450,  2459,  2462,
    2465,  2470,  2473,  2481,  2489,  2493,  2498,  2503,  2510,  2517,
    2522,  2529,  2536,  2543,  2548,  2555,  2560,  2567,  2576,  2587,
    2600,  2607,  2612,  2619,  2626,  2628,  2635,  2640,  2649,  2660,
    2665,  2667,  2671,  2676,  2683,  2690,  2699,  2706,  2713,  2718,
    2725,  2732,  2741,  2746,  2751,  2758,  2763,  2766,  2771,  2776,
    2781,  2788,  2793,  2798,  2802,  2811,  2818,  2823,  2830,  2834,
    2841,  2850,  2855,  2864,  2871,  2880,  2887,  2896,  2899,  2904,
    2909,  2914,  2921,  2930,  2939,  2944,  2952,  2960,  2968,  2975,
    2982,  2989,  2996,  3003,  3010,  3011,  3017,  3028,  3032,  3037,
    3041,  3044,  3047,  3050,  3055,  3062,  3067,  3072,  3079,  3086,
    3093,  3100,  3105,  3112,  3117,  3124,  3129,  3134,  3139,  3144,
    3151,  3156,  3163,  3168,  3175,  3180,  3185,  3192,  3197,  3204,
    3209,  3216,  3221,  3226,  3233,  3238,  3245,  3246,  3250,  3254,
    3255,  3257,  3258,  3261,  3263,  3267,  3272,  3277,  3283,  3288,
    3293,  3298,  3304,  3309,  3310,  3311,  3319,  3330,  3335,  3341,
    3346,  3352,  3357,  3362,  3367,  3372,  3377,  3383,  3384,  3393,
    3394,  3398,  3402,  3404,  3409,  3410,  3412,  3413,  3416,  3417,
    3419,  3420,  3424,  3427,  3431,  3434,  3436,  3439,  3441,  3444,
    3446,  3448,  3450,  3453,  3454,  3456,  3457,  3460,  3462,  3466,
    3468,  3472,  3473,  3476,  3478,  3482,  3483,  3485,  3486,  3489,
    3494,  3500,  3502,  3504,  3506,  3508,  3512,  3516,  3520,  3521,
    3528,  3529,  3536,  3537,  3546,  3551,  3552,  3561,  3562,  3573,
    3580,  3581,  3590,  3591,  3602,  3609,  3611,  3614,  3617,  3618,
    3623,  3624,  3636,  3640,  3647,  3648,  3652,  3653,  3654,  3660,
    3661,  3663,  3664,  3666,  3667,  3670,  3671,  3674,  3677,  3680,
    3681,  3688,  3689,  3691,  3695,  3697,  3699,  3701,  3705,  3707,
    3709,  3711,  3713,  3715,  3717,  3719,  3721,  3723,  3725,  3727,
    3729,  3731,  3733,  3735,  3737,  3739,  3741,  3743,  3745,  3747,
    3749,  3751,  3753,  3755,  3757,  3758,  3760,  3762,  3763,  3766,
    3767,  3769,  3770,  3771,  3775,  3776,  3777,  3781,  3784,  3785,
    3786,  3791,  3796,  3799,  3800,  3803,  3806,  3810,  3814,  3816,
    3819,  3820,  3822,  3823,  3828,  3833,  3836,  3837,  3839,  3841,
    3842,  3844,  3845,  3847,  3850,  3852,  3856,  3860,  3862,  3864,
    3866,  3868,  3869,  3872,  3874,  3876,  3878,  3880,  3882,  3884,
    3886,  3888,  3890,  3892,  3894,  3895,  3896,  3903,  3904,  3906,
    3910,  3912,  3915,  3916,  3919,  3923,  3925,  3928,  3930,  3931,
    3935,  3936,  3942,  3945,  3947,  3948,  3952,  3959,  3960,  3967,
    3972,  3977,  3982,  3987,  3993,  3998,  4000,  4004,  4006,  4008,
    4012,  4014,  4015,  4018,  4019,  4021,  4022,  4023,  4032,  4033,
    4034,  4041,  4042,  4044,  4046,  4048,  4050,  4052,  4055,  4057,
    4059,  4061,  4065,  4070,  4071,  4075,  4079,  4081,  4084,  4087,
    4088,  4092,  4093,  4099,  4103,  4105,  4109,  4111,  4115,  4117,
    4119,  4120,  4122,  4123,  4128,  4129,  4131,  4135,  4137,  4139,
    4141,  4142,  4143,  4150,  4151,  4152,  4164,  4168,  4170,  4174,
    4178,  4180,  4184,  4185,  4187,  4188,  4193,  4194,  4201,  4202,
    4208,  4209,  4216,  4218,  4222,  4226,  4232,  4233,  4236,  4237,
    4240,  4242,  4244,  4246,  4250,  4251,  4253,  4254,  4256,  4258,
    4262,  4264,  4266,  4269,  4272,  4275,  4277,  4279,  4281,  4283,
    4284,  4288,  4289,  4293,  4296,  4301,  4306,  4311,  4316,  4317,
    4322,  4329,  4346,  4349,  4352,  4353,  4360,  4366,  4369,  4372,
    4375,  4377,  4383,  4389,  4392,  4395,  4397,  4402,  4406,  4409,
    4412,  4415,  4419,  4422,  4425,  4428,  4430,  4432,  4436,  4441,
    4445,  4449,  4452,  4455,  4459,  4463,  4467,  4471,  4475,  4479,
    4481,  4483,  4485,  4487,  4488,  4490,  4491,  4494,  4495,  4497,
    4499,  4501,  4502,  4505,  4506,  4509,  4510,  4513,  4516,  4517,
    4522,  4523,  4528,  4530,  4532,  4533,  4535,  4536,  4538,  4540,
    4541,  4546,  4550,  4552,  4553,  4557,  4562,  4565,  4567,  4569,
    4571,  4573,  4575,  4577,  4579,  4581,  4582,  4584,  4585,  4589,
    4593,  4595,  4597,  4599,  4602,  4603,  4607,  4611,  4614,  4617,
    4618,  4623,  4624,  4626,  4628,  4631,  4632,  4637,  4643,  4644,
    4645,  4646,  4647,  4666,  4669,  4670,  4672,  4673,  4675,  4677,
    4678,  4680,  4682,  4683,  4686,  4689,  4691,  4695,  4700,  4704,
    4708,  4709,  4712,  4715,  4717,  4721,  4725,  4726,  4730,  4731,
    4735,  4738,  4742,  4744,  4746,  4749,  4750,  4753,  4755,  4757,
    4760,  4763,  4765,  4767,  4769,  4771,  4773,  4776,  4779,  4781,
    4783,  4785,  4787,  4789,  4791,  4793,  4796,  4799,  4802,  4805,
    4808,  4810,  4812,  4814,  4816,  4818,  4820,  4822,  4826,  4832,
    4834,  4836,  4838,  4840,  4842,  4846,  4851,  4857,  4859,  4865,
    4869,  4872,  4874,  4878,  4881,  4883,  4885,  4887,  4889,  4891,
    4893,  4895,  4897,  4899,  4901,  4903,  4905,  4907,  4909,  4913,
    4916,  4918,  4920,  4922,  4924,  4926,  4928,  4930,  4932,  4934,
    4936,  4938,  4940,  4942,  4944,  4946,  4948,  4950,  4952,  4954,
    4956,  4958,  4960,  4962,  4964,  4966,  4968,  4970,  4972,  4974,
    4976,  4978,  4980,  4982,  4984,  4986,  4988,  4990,  4992,  4994,
    4996,  4998,  5000,  5002,  5004,  5006,  5008,  5010,  5012,  5014,
    5016,  5018,  5020,  5022,  5024,  5026,  5028,  5030,  5032,  5034,
    5036,  5038,  5040,  5042,  5044,  5046,  5048,  5050,  5052,  5054,
    5056,  5058,  5060,  5062,  5064,  5066,  5068,  5070,  5072,  5074,
    5076,  5078,  5080,  5082,  5084,  5086,  5088,  5090,  5092,  5094,
    5096,  5098,  5100,  5102,  5104,  5106,  5108,  5110,  5112,  5114,
    5116,  5118,  5120,  5122,  5124,  5126,  5128,  5130,  5132,  5134,
    5136,  5138,  5140,  5142,  5144,  5146,  5148,  5150,  5152,  5154,
    5156,  5158,  5160,  5162,  5164,  5166,  5168,  5170,  5172,  5174,
    5176,  5178,  5180,  5182,  5184,  5186,  5188,  5190,  5192,  5194,
    5196,  5198,  5200,  5202,  5204,  5206,  5208,  5210,  5212,  5214,
    5216,  5218,  5220,  5222,  5224,  5226,  5228,  5230,  5232,  5234,
    5236,  5238,  5240,  5242,  5244,  5246,  5248,  5250,  5252,  5254,
    5256,  5258,  5260,  5262,  5264,  5266,  5268,  5270,  5272,  5274,
    5276,  5278,  5280,  5282,  5284,  5286,  5288,  5290,  5292,  5294,
    5296,  5298,  5300,  5302,  5304,  5306,  5308,  5310,  5312,  5314,
    5316,  5318,  5320,  5322,  5324,  5326,  5328,  5330,  5332,  5334,
    5336,  5338,  5340,  5342,  5344,  5346,  5348,  5350,  5352,  5354,
    5356,  5358,  5360,  5362,  5364,  5366,  5368,  5370,  5372,  5374,
    5376,  5378,  5380,  5382,  5384,  5386,  5388,  5390,  5392,  5394,
    5396,  5398,  5400,  5402,  5404,  5406,  5408,  5410,  5412,  5414,
    5416,  5418,  5420,  5422,  5424,  5426,  5428,  5430,  5432,  5434,
    5436,  5438,  5440,  5442,  5443,  5448,  5449,  5451,  5453,  5457,
    5458,  5461,  5463,  5465,  5467,  5469,  5470,  5472,  5473,  5475,
    5477,  5479,  5480,  5483,  5486,  5489,  5491,  5494,  5499,  5505,
    5510,  5517,  5520,  5524,  5528,  5532,  5538,  5540,  5544,  5548,
    5551,  5554,  5557,  5559,  5561,  5566,  5571,  5573,  5575,  5577,
    5579,  5581,  5582,  5587,  5589,  5591,  5593,  5597,  5601,  5603,
    5605,  5608,  5611,  5612,  5616,  5621,  5625,  5626,  5634,  5636,
    5639,  5641,  5643,  5645,  5647,  5649,  5651,  5652,  5658,  5660,
    5662,  5664,  5666,  5668,  5672,  5679,  5686,  5693,  5701,  5705,
    5714,  5723,  5732,  5733,  5735,  5737,  5740,  5741,  5743,  5745,
    5749,  5750,  5754,  5755,  5759,  5760,  5764,  5765,  5769,  5771,
    5773,  5775,  5777,  5779,  5781,  5783,  5785,  5787,  5789,  5791,
    5794,  5797,  5799,  5803,  5806,  5809,  5812,  5815,  5818,  5821,
    5824,  5827,  5828,  5830,  5834,  5836,  5839,  5842,  5845,  5847,
    5851,  5855,  5857,  5859,  5863,  5865,  5869,  5874,  5880,  5882,
    5883,  5887,  5891,  5893,  5895,  5896,  5899,  5902,  5905,  5908,
    5909,  5912,  5915,  5917,  5920,  5923,  5926,  5929,  5932,  5933,
    5937,  5938,  5940,  5941,  5945,  5948,  5949,  5951,  5954,  5955,
    5957,  5962,  5967,  5973,  5976,  5980,  5981,  5983,  5984,  5989,
    5990,  5992,  5994,  5995,  5998,  6001,  6003,  6004,  6006,  6008,
    6013,  6014,  6022,  6024,  6025,  6026,  6029,  6033,  6035,  6037,
    6039,  6040,  6044,  6046,  6049,  6051,  6054,  6058,  6062,  6066,
    6067,  6069,  6070,  6074,  6078,  6079,  6088,  6089,  6093,  6095,
    6099,  6100,  6103,  6107,  6113,  6114,  6118,  6123,  6128,  6129,
    6144,  6145,  6152,  6153,  6154,  6155,  6156,  6169,  6174,  6179,
    6183,  6188,  6192,  6195,  6197,  6201,  6207,  6209,  6211,  6212,
    6214,  6216,  6217,  6220,  6221,  6222,  6226,  6227
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short int yyrhs[] =
{
     584,     0,    -1,     3,    -1,   585,     3,    -1,   586,    -1,
    1196,    -1,   784,    -1,   825,    -1,   815,    -1,   621,    -1,
     598,    -1,   827,    -1,   817,    -1,  1202,    -1,   603,    -1,
     587,    -1,  1036,    -1,  1067,    -1,   990,    -1,   992,    -1,
     591,    -1,  1073,    -1,  1171,    -1,  1162,    -1,   596,    -1,
    1000,    -1,  1087,    -1,  1091,    -1,  1154,    -1,   832,    -1,
     840,    -1,   844,    -1,   589,    -1,  1083,    -1,  1205,    -1,
     835,    -1,   820,    -1,  1003,    -1,  1079,    -1,   813,    -1,
    1169,    -1,  1203,    -1,  1204,    -1,   852,    -1,  1137,    -1,
    1053,    -1,   802,    -1,   805,    -1,  1047,    -1,  1160,    -1,
    1028,    -1,  1090,    -1,  1243,    -1,   588,   370,  1131,    -1,
     106,    -1,   129,    -1,   370,  1131,   175,   590,    -1,  1128,
      -1,   579,  1133,    -1,    -1,   151,  1131,   592,   593,    -1,
      -1,   530,   594,    -1,   594,   575,   595,    -1,   595,    -1,
     579,  1133,    -1,    -1,   202,   597,  1133,    -1,    -1,    53,
     287,   498,   599,   600,    -1,   601,    -1,   600,   575,   601,
      -1,   274,   145,  1128,    -1,   288,   145,  1128,    -1,   277,
     145,  1128,    -1,   278,   145,   975,    -1,   273,   145,   975,
      -1,   286,   145,   975,    -1,   282,   145,  1128,    -1,   281,
     145,  1128,    -1,   283,   145,  1128,    -1,   284,   145,  1128,
      -1,   285,   145,  1128,    -1,   602,    -1,   275,   145,  1128,
      -1,   276,   145,   976,    -1,   396,   145,  1128,    -1,   397,
     145,   975,    -1,    -1,    87,   701,   485,   704,  1125,   604,
     688,    -1,    -1,    87,   776,   217,  1131,   777,   344,  1125,
     605,   573,   779,   574,    -1,    -1,    87,    94,   704,  1131,
     606,   698,    -1,    -1,    87,   607,  1219,    -1,    87,   527,
     608,  1187,    -1,    -1,  1131,   580,  1131,    -1,  1131,    -1,
     413,   717,   509,  1128,    -1,    -1,    -1,    -1,    -1,    -1,
     573,   611,   626,   574,   612,   413,   613,   728,   614,   617,
     615,   650,    -1,    -1,   616,   618,    -1,    -1,   617,   619,
      -1,    68,  1128,    -1,   241,   461,    -1,   335,   461,    -1,
      80,   461,    -1,   389,   461,    96,    -1,   311,   461,    96,
      -1,   620,    -1,   618,    -1,   121,    -1,   879,   121,    -1,
     461,   429,   112,    -1,   461,   429,   228,    -1,    -1,    48,
     609,   622,   623,    -1,    -1,   573,   624,   574,    -1,    -1,
     625,    -1,   625,   575,   873,    -1,   873,    -1,    -1,   627,
      -1,   627,   575,   629,    -1,   629,    -1,    -1,  1131,   628,
     728,    -1,    -1,   631,    -1,   631,   575,   632,    -1,   632,
      -1,   633,   628,  1131,   728,    -1,    -1,   229,    -1,   357,
      -1,   221,    -1,    -1,   634,   650,   581,    -1,   650,   581,
      -1,   635,   650,   581,    -1,    -1,   636,   637,   581,    -1,
      -1,   109,   648,   638,   728,   649,    -1,   109,  1131,    76,
     172,   645,    -1,    -1,   109,   642,   199,   172,   639,   643,
     650,    -1,   109,  1131,    92,   172,   640,    -1,    -1,   641,
     586,    -1,   153,    -1,    82,    -1,   644,    -1,   643,   575,
     644,    -1,   647,    -1,   975,    -1,   453,   646,  1129,    -1,
      -1,   536,    -1,   645,    -1,  1131,    -1,   454,    -1,   879,
     173,    -1,   452,    -1,  1131,    -1,   648,   575,  1131,    -1,
      -1,   111,   873,    -1,    -1,   651,   586,    -1,    -1,   414,
     652,   873,    -1,    -1,   213,   653,   658,   141,   213,    -1,
     663,    -1,   678,    -1,    -1,   654,   681,    -1,   248,  1132,
      -1,   235,  1132,    -1,   347,  1131,    -1,    -1,   161,   656,
    1131,   226,   655,   657,    -1,    61,  1131,    -1,    -1,   330,
     175,    -1,   175,    -1,  1131,    -1,   657,   575,  1131,    -1,
      -1,    -1,    -1,   659,   873,   560,   660,   635,   661,   662,
      -1,    -1,   135,   658,    -1,   559,   635,    -1,   664,    -1,
     667,    -1,    -1,    -1,   561,   665,   873,   666,   669,   677,
     141,   561,    -1,    -1,   561,   668,   670,   677,   141,   561,
      -1,   671,    -1,   669,   671,    -1,   674,    -1,   670,   674,
      -1,    -1,    -1,   545,   672,   873,   673,   560,   635,    -1,
      -1,    -1,   545,   675,   873,   676,   560,   635,    -1,    -1,
     559,   635,    -1,    -1,  1132,   582,   679,   681,   680,    -1,
      -1,  1132,    -1,    -1,    28,   682,   636,   634,   141,    -1,
     269,   635,   141,   269,    -1,    -1,    -1,   547,   683,   873,
     128,   684,   635,   141,   547,    -1,    -1,   404,   635,   523,
     685,   873,   141,   404,    -1,    27,    -1,     8,    -1,   223,
      -1,   524,    -1,   115,    -1,   573,   689,    -1,   705,   691,
      -1,   252,  1125,    -1,   573,   252,  1125,   574,    -1,   718,
     574,   705,   691,    -1,    -1,   694,   574,   690,  1209,    -1,
      -1,    -1,  1100,   697,   694,   692,  1206,    -1,    -1,  1100,
     697,   573,   694,   574,   693,  1209,    -1,    -1,    -1,   430,
     695,   862,   866,   696,   715,    -1,    -1,    18,    -1,    -1,
     699,    -1,   700,    -1,   699,   700,    -1,   710,    -1,   709,
      -1,    -1,   702,    -1,   703,    -1,   703,   702,    -1,   486,
      -1,    -1,   213,   879,   152,    -1,    -1,   707,    -1,   708,
      -1,   708,   706,    -1,   708,    -1,   708,   707,    -1,   708,
     575,   707,    -1,   143,  1020,   711,    -1,   507,  1020,   711,
      -1,   292,  1020,   976,    -1,   307,  1020,   976,    -1,    24,
    1020,   975,    -1,   361,  1020,  1128,    -1,    68,  1020,  1128,
      -1,    23,  1020,   976,    -1,   358,  1020,   975,    -1,   358,
    1020,   111,    -1,    57,  1020,   975,    -1,   114,  1020,   975,
      -1,   423,  1020,   712,    -1,   387,  1020,   713,    -1,   384,
    1020,   975,    -1,   385,  1020,   975,    -1,   516,  1020,   573,
     994,   574,    -1,   709,    -1,   710,    -1,   224,  1020,   714,
      -1,    96,   122,  1020,  1128,    -1,   217,   122,  1020,  1128,
      -1,    77,  1020,  1128,    -1,   758,   749,  1020,   751,    -1,
     758,    64,  1020,   757,    -1,  1133,    -1,   111,    -1,   165,
      -1,   133,    -1,    72,    -1,   393,    -1,    71,    -1,   386,
      -1,   383,    -1,   975,    -1,   335,    -1,   164,    -1,   243,
      -1,   970,    -1,   861,   865,    -1,    -1,    10,    -1,   472,
      -1,   391,    -1,   108,    -1,   227,    -1,   719,    -1,   718,
     575,   719,    -1,   720,    -1,   721,    -1,   726,   722,    -1,
     726,   763,    -1,   771,   781,   777,   573,   779,   574,    -1,
     724,   772,   781,   777,   573,   779,   574,    -1,   724,   170,
     238,   781,   573,   779,   574,   763,    -1,   725,   722,    -1,
     724,   723,    -1,    -1,   723,    -1,    58,   873,    -1,    -1,
     725,    -1,    79,   781,    -1,    -1,  1124,   727,   728,   745,
      -1,   736,   743,   740,    -1,   737,   744,   740,    -1,   167,
     738,   740,    -1,    37,    -1,    37,   573,   338,   574,    -1,
      42,    -1,    41,    -1,   732,   573,   338,   574,   759,    -1,
     732,   759,    -1,   733,   573,   338,   574,   760,    -1,   733,
     760,    -1,    32,   573,   338,   574,    -1,    32,    -1,   734,
     573,   338,   574,   759,    -1,   735,   573,   338,   574,   760,
      -1,   537,   573,   338,   574,    -1,   556,   743,   740,    -1,
     100,    -1,   494,    -1,   491,   743,    -1,    97,    -1,   495,
      -1,    39,   743,    -1,   731,    -1,   296,    -1,   265,    -1,
     268,   537,    -1,   268,   734,   759,    -1,   497,   759,    -1,
     490,   743,   759,    -1,   298,   759,    -1,   266,   759,    -1,
     108,   738,   740,    -1,   339,   738,   740,    -1,   165,   738,
     740,    -1,    -1,   144,   729,   573,   783,   574,   759,    -1,
      -1,   436,   730,   573,   783,   574,   759,    -1,   268,   759,
      -1,   434,    -1,   187,    -1,   186,    -1,   365,    -1,   318,
      -1,   256,    -1,   317,    -1,   367,    -1,   319,    -1,    56,
      -1,   326,    -1,   323,    56,    -1,   732,   541,    -1,   538,
      -1,   323,   538,    -1,   340,    -1,   326,   538,    -1,   323,
      56,   541,    -1,   326,   541,    -1,   227,    -1,   496,    -1,
     446,    -1,   297,    -1,    31,    -1,   391,    -1,   127,    -1,
     127,   369,    -1,    -1,   573,   338,   574,    -1,   739,    -1,
     573,   338,   575,   338,   574,    -1,    -1,   741,    -1,   741,
     742,    -1,   742,    -1,   443,    -1,   522,    -1,   557,    -1,
      -1,   573,   338,   574,    -1,    -1,   739,    -1,    -1,   746,
      -1,   746,   747,    -1,   747,    -1,   337,    -1,   879,   337,
      -1,   111,   748,    -1,   344,   524,   334,   872,    -1,    23,
      -1,   434,   111,   536,    -1,   762,   238,    -1,   517,    -1,
     517,   238,    -1,    68,  1128,    -1,    64,   755,    -1,   334,
     872,    -1,  1115,    -1,    56,   436,    -1,    55,    -1,  1133,
      -1,    32,    -1,   750,    -1,   111,    -1,    -1,   749,   751,
      -1,  1133,    -1,    32,    -1,   753,    -1,   111,    -1,  1133,
      -1,    -1,    64,   757,    -1,   755,    -1,   111,    -1,    -1,
     111,    -1,    -1,    20,   760,    -1,    46,    -1,   515,   760,
      -1,   749,   750,   760,    -1,    32,   761,    -1,    -1,    32,
      -1,    -1,    20,    -1,   515,    -1,   749,   750,    -1,    -1,
     372,    -1,    -1,   394,  1125,   764,   765,    -1,   767,    -1,
     573,   766,   574,   767,    -1,   766,   575,  1131,    -1,  1131,
      -1,    -1,   768,    -1,   768,   769,    -1,   769,    -1,   344,
     115,   770,    -1,   344,   524,   770,    -1,   289,   177,    -1,
     289,   360,    -1,   289,   444,    -1,   411,    -1,    49,    -1,
     436,   337,    -1,   335,     5,    -1,   436,   111,    -1,   773,
      -1,   178,   774,    -1,   450,   774,    -1,   372,   238,    -1,
     517,   774,    -1,   238,    -1,   217,    -1,    -1,   773,    -1,
     237,    -1,   217,    -1,   216,    -1,    -1,   517,    -1,   178,
      -1,   450,    -1,    -1,   530,   778,    -1,   507,   778,    -1,
      44,    -1,   425,    -1,   200,    -1,   779,   575,   780,   968,
      -1,   780,   968,    -1,  1131,    -1,  1131,   573,   338,   574,
      -1,    -1,  1124,    -1,    -1,   580,  1131,    -1,  1113,    -1,
     783,   575,  1113,    -1,    -1,    13,   798,   485,  1125,   785,
     791,    -1,    -1,    13,    94,   790,   786,   699,    -1,    -1,
      13,   374,   609,   787,   616,    -1,    -1,    13,   179,   609,
     788,   616,    -1,    -1,    13,  1225,  1221,  1226,   542,  1125,
     789,  1229,    18,  1231,  1234,    -1,    -1,  1131,    -1,    -1,
     124,   484,    -1,   215,   484,    -1,   793,    -1,   791,   575,
     793,    -1,     6,   797,    -1,   792,   720,   800,    -1,     6,
     721,    -1,   792,   573,   718,   574,    -1,    -1,    53,   797,
    1124,   794,   726,   800,    -1,    -1,    -1,   312,   797,  1124,
     795,   728,   745,   796,   800,    -1,   129,   797,  1124,   799,
      -1,   129,   170,   238,   781,    -1,   129,   372,   238,    -1,
     129,   773,  1124,    -1,   123,   237,    -1,   137,   237,    -1,
      13,   797,  1124,   436,   111,  1115,    -1,    13,   797,  1124,
     129,   111,    -1,   401,   801,  1125,    -1,    83,   498,   749,
     751,   756,    -1,   706,    -1,   169,    -1,   961,    -1,    -1,
      67,    -1,    -1,   214,    -1,    -1,   411,    -1,    49,    -1,
      -1,     8,  1131,    -1,   164,    -1,    -1,   498,    -1,   145,
      -1,    18,    -1,    -1,   465,   445,   807,   803,   811,    -1,
     469,   445,   807,    -1,    -1,   445,   465,   807,   804,   811,
      -1,   445,   469,   807,    -1,   465,   500,   806,    -1,    -1,
     548,    78,   447,    -1,    -1,   808,   809,    -1,   810,    -1,
     809,   575,   810,    -1,    -1,   462,    -1,   398,    -1,    -1,
     523,   812,    -1,   602,    -1,   812,   575,   602,    -1,    -1,
     410,  1156,   814,   994,   175,  1128,    -1,    -1,    26,  1156,
     816,   994,   498,  1128,    -1,    -1,    57,  1156,   818,   994,
     819,    -1,    -1,   382,    -1,   156,    -1,    -1,   402,   834,
    1156,   821,   994,   822,    -1,    -1,   823,    -1,   824,    -1,
     824,   823,    -1,   382,    -1,   156,    -1,   528,    -1,    -1,
      14,   834,  1156,   826,   994,   829,    -1,    -1,    58,  1156,
     828,   994,   829,    -1,    -1,   830,    -1,   831,    -1,   831,
     830,    -1,   382,    -1,   159,    -1,   299,    -1,   156,    -1,
      54,    -1,   172,   525,    -1,    -1,   348,   834,  1156,   833,
     994,   829,    -1,    -1,   336,    -1,   258,    -1,    -1,   401,
    1156,   836,   838,    -1,   401,   527,   608,   837,    -1,  1134,
     498,  1134,    -1,   837,   575,  1134,   498,  1134,    -1,   839,
      -1,   838,   575,   839,    -1,  1125,   498,  1125,    -1,    47,
     217,   841,   229,   843,    -1,   842,    -1,   841,   575,   842,
      -1,  1125,   848,    -1,  1131,    -1,   111,    -1,    -1,   257,
     217,   226,    47,   845,   846,    -1,   847,    -1,   846,   575,
     847,    -1,  1125,   848,   851,    -1,    -1,   849,   850,    -1,
      -1,   774,   573,   945,   574,    -1,    -1,   214,   247,    -1,
     853,    -1,   430,   855,    -1,   573,   854,   574,  1209,    -1,
     430,   857,    -1,   573,   854,   574,    -1,    -1,   857,   856,
    1206,    -1,    -1,    -1,   858,   862,   866,   859,   860,   865,
      -1,   964,   970,    -1,   986,    -1,   861,    -1,   986,   861,
      -1,   861,   986,    -1,   175,   918,   953,   958,   955,   964,
     970,   977,    -1,   175,   130,   953,   970,    -1,    -1,   863,
      -1,   863,   864,    -1,   864,    -1,   471,    -1,   204,    -1,
     125,    -1,   460,    -1,   455,    -1,   456,    -1,   458,    -1,
     459,    -1,   457,    -1,    12,    -1,    -1,   172,   524,    -1,
     262,   229,   438,   310,    -1,   866,   575,   867,    -1,   867,
      -1,   567,    -1,   868,   870,   869,   871,    -1,    -1,    -1,
    1119,    -1,   873,    -1,    -1,    18,  1131,    -1,    18,  1128,
      -1,  1131,    -1,  1128,    -1,    -1,   573,   574,    -1,   873,
     877,   873,    -1,   873,   553,   873,    -1,   873,   878,   873,
      -1,   333,   873,    -1,   874,   232,   504,    -1,   874,   232,
     879,   504,    -1,   874,   232,   158,    -1,   874,   232,   879,
     158,    -1,   874,   232,   520,    -1,   874,   232,   879,   520,
      -1,   874,    -1,   874,   232,   337,    -1,   874,   232,   879,
     337,    -1,   874,   146,   875,    -1,   874,   881,   875,    -1,
     874,   881,   882,   573,  1214,   574,    -1,   875,    -1,   876,
     229,   573,  1214,   574,    -1,   876,   879,   229,   573,  1214,
     574,    -1,   876,   229,   573,   873,   574,    -1,   876,   229,
     573,   873,   575,   907,   574,    -1,   876,   879,   229,   573,
     873,   574,    -1,   876,   879,   229,   573,   873,   575,   907,
     574,    -1,   876,   562,   876,    16,   875,    -1,   876,   879,
     562,   876,    16,   875,    -1,   876,   448,   252,   876,    -1,
     876,   252,   884,   957,    -1,   876,   879,   252,   884,   957,
      -1,   876,   395,   876,    -1,   876,   879,   395,   876,    -1,
     876,    -1,   876,   563,   876,    -1,   876,   564,   876,    -1,
     876,   439,   876,    -1,   876,   440,   876,    -1,   876,   566,
     876,    -1,   876,   565,   876,    -1,   876,   566,   883,   947,
      -1,   876,   565,   883,   947,    -1,   876,   567,   876,    -1,
     876,   568,   876,    -1,   876,   569,   876,    -1,   876,   126,
     876,    -1,   876,   313,   876,    -1,   876,   570,   876,    -1,
     884,    -1,   354,    -1,   351,    -1,    16,    -1,    15,    -1,
     333,    -1,   332,    -1,   576,    -1,   332,    -1,   145,    -1,
     184,    -1,   198,    -1,   244,    -1,   271,    -1,   328,    -1,
      12,    -1,    17,    -1,   225,   873,    -1,  1121,    -1,   884,
      64,  1133,    -1,  1116,    -1,  1114,    -1,   897,    -1,   893,
      -1,   884,   353,   884,    -1,   566,   884,    -1,   565,   884,
      -1,   571,   884,    -1,   880,   884,    -1,   573,  1214,   574,
      -1,   573,   873,   574,    -1,   573,   873,   575,   907,   574,
      -1,   424,   573,   873,   575,   907,   574,    -1,   152,   573,
    1214,   574,    -1,   577,  1131,   873,   578,    -1,   289,   910,
       9,   573,   876,   887,   574,    -1,    20,   573,   873,   574,
      -1,    32,   884,    -1,    51,   573,   873,    18,   905,   574,
      -1,   561,   914,   916,   915,   141,    -1,    83,   573,   873,
     575,   905,   574,    -1,    83,   573,   873,   530,   750,   574,
      -1,   111,   573,  1121,   574,    -1,   535,   573,  1122,   574,
      -1,   180,   573,   574,    -1,   181,   573,   873,   574,    -1,
     182,   573,   873,   575,   873,   574,    -1,   183,   573,   873,
     575,   873,   575,   873,   574,    -1,     7,   573,   873,   575,
     873,   574,    -1,     7,   573,   873,   575,   225,   873,   947,
     574,    -1,   404,   573,   873,   575,   873,   574,    -1,    22,
     573,   873,   574,    -1,    22,   573,   873,   575,   873,   574,
      -1,    56,   573,   907,   574,    -1,    56,   573,   907,   530,
     750,   574,    -1,    55,   573,   873,   574,    -1,    62,   573,
     907,   574,    -1,    65,   573,   873,   574,    -1,    73,   573,
     907,   574,    -1,    74,   573,   873,   575,   907,   574,    -1,
      84,   573,   873,   575,   873,   575,   873,   574,    -1,    90,
     872,    -1,    93,   872,    -1,    93,   573,   873,   574,    -1,
      91,   872,    -1,    98,   573,   873,   575,   883,   947,   574,
      -1,    99,   573,   873,   575,   883,   947,   574,    -1,    94,
     573,   574,    -1,   100,   573,   873,   574,    -1,   105,   573,
     873,   574,    -1,   136,   573,   873,   575,   907,   574,    -1,
     272,   573,   873,   575,   907,   574,    -1,   140,   573,   873,
     574,    -1,   140,   573,   873,   575,   873,   574,    -1,   110,
     573,   873,   575,  1129,   574,    -1,   139,   573,   873,   575,
    1129,   574,    -1,   118,   573,   873,   574,    -1,   118,   573,
     873,   575,   873,   574,    -1,   119,   573,   873,   574,    -1,
     119,   573,   873,   575,   873,   574,    -1,   155,   573,   873,
     575,   873,   575,   873,   574,    -1,   155,   573,   873,   575,
     873,   575,   873,   575,   873,   574,    -1,   155,   573,   873,
     575,   873,   575,   873,   575,   873,   575,   873,   574,    -1,
     171,   573,   873,   575,   338,   574,    -1,   176,   573,   873,
     574,    -1,   176,   573,   873,   575,   873,   574,    -1,   162,
     573,   873,   575,   907,   574,    -1,   886,    -1,   190,   573,
     949,   575,   873,   574,    -1,   209,   573,   873,   574,    -1,
     213,   573,   873,   575,   873,   575,   873,   574,    -1,   223,
     573,   873,   575,   873,   575,   873,   575,   873,   574,    -1,
     883,   947,   566,   873,    -1,   883,    -1,   242,   573,   574,
      -1,   242,   573,   873,   574,    -1,   249,   573,   873,   575,
     873,   574,    -1,   259,   573,   873,   575,   873,   574,    -1,
     259,   573,   873,   575,   873,   575,   873,   574,    -1,   194,
     573,   873,   575,   907,   574,    -1,   246,   573,   873,   575,
     907,   574,    -1,   264,   573,   873,   574,    -1,   264,   573,
     873,   575,   873,   574,    -1,   279,   573,   873,   575,   873,
     574,    -1,   279,   573,   873,   575,   873,   575,   873,   574,
      -1,   302,   573,   873,   574,    -1,   306,   573,   873,   574,
      -1,   313,   573,   873,   575,   873,   574,    -1,   314,   573,
     873,   574,    -1,   334,   872,    -1,   334,   573,   873,   574,
      -1,   361,   573,   873,   574,    -1,   343,   573,   873,   574,
      -1,   368,   573,   876,   229,   873,   574,    -1,   380,   573,
     873,   574,    -1,   388,   573,   873,   574,    -1,   388,   573,
     574,    -1,   405,   573,   873,   575,   873,   575,   873,   574,
      -1,   416,   573,   873,   575,   873,   574,    -1,   419,   573,
     873,   574,    -1,   419,   573,   873,   575,   873,   574,    -1,
     422,   573,   574,    -1,   473,   573,   873,   575,   873,   574,
      -1,   473,   573,   873,   575,   225,   873,   947,   574,    -1,
     428,   573,   873,   574,    -1,   475,   573,   873,   575,   873,
     575,   873,   574,    -1,   475,   573,   873,   575,   873,   574,
      -1,   475,   573,   873,   175,   873,   172,   873,   574,    -1,
     475,   573,   873,   175,   873,   574,    -1,   476,   573,   873,
     575,   873,   575,   873,   574,    -1,   482,   872,    -1,   482,
     573,   873,   574,    -1,   494,   573,   873,   574,    -1,   491,
     573,   873,   574,    -1,   491,   573,   873,   575,   873,   574,
      -1,   492,   573,   948,   575,   873,   575,   873,   574,    -1,
     493,   573,   948,   575,   873,   575,   873,   574,    -1,   503,
     573,   873,   574,    -1,   503,   573,   245,   873,   175,   873,
     574,    -1,   503,   573,   499,   873,   175,   873,   574,    -1,
     503,   573,    43,   873,   175,   873,   574,    -1,   503,   573,
     245,   175,   873,   574,    -1,   503,   573,   499,   175,   873,
     574,    -1,   503,   573,    43,   175,   873,   574,    -1,   503,
     573,   873,   175,   873,   574,    -1,   505,   573,   873,   575,
     873,   574,    -1,  1131,   580,  1131,   573,   906,   574,    -1,
      -1,  1127,   573,   885,   888,   574,    -1,   518,   573,  1112,
     575,   338,   575,   338,   575,   907,   574,    -1,   519,   573,
     574,    -1,   519,   573,   873,   574,    -1,   527,   573,   574,
      -1,   531,   872,    -1,   533,   872,    -1,   532,   872,    -1,
     544,   573,   873,   574,    -1,   544,   573,   873,   575,   873,
     574,    -1,   556,   573,   873,   574,    -1,   554,   573,   873,
     574,    -1,   554,   573,   873,   575,   873,   574,    -1,    29,
     573,   975,   575,   873,   574,    -1,   157,   573,   947,   175,
     873,   574,    -1,    80,   573,   873,   575,   873,   574,    -1,
     188,   573,   873,   574,    -1,   188,   573,   873,   575,   873,
     574,    -1,   189,   573,   873,   574,    -1,   189,   573,   873,
     575,   873,   574,    -1,   186,   573,   907,   574,    -1,   256,
     573,   907,   574,    -1,   317,   573,   907,   574,    -1,   309,
     573,   873,   574,    -1,   309,   573,   873,   575,   873,   574,
      -1,   315,   573,   873,   574,    -1,   315,   573,   873,   575,
     873,   574,    -1,   316,   573,   873,   574,    -1,   316,   573,
     873,   575,   873,   574,    -1,   318,   573,   907,   574,    -1,
     319,   573,   907,   574,    -1,   365,   573,   873,   575,   873,
     574,    -1,   364,   573,   873,   574,    -1,   364,   573,   873,
     575,   873,   574,    -1,   366,   573,   873,   574,    -1,   366,
     573,   873,   575,   873,   574,    -1,   367,   573,   907,   574,
      -1,   185,   573,   873,   574,    -1,   185,   573,   873,   575,
     873,   574,    -1,   254,   573,   873,   574,    -1,   254,   573,
     873,   575,   873,   574,    -1,    -1,   548,   381,   154,    -1,
     229,    41,   310,    -1,    -1,   889,    -1,    -1,   890,   891,
      -1,   892,    -1,   891,   575,   892,    -1,   868,   873,   869,
     871,    -1,    25,   573,   903,   574,    -1,    25,   573,   125,
     903,   574,    -1,    35,   573,   903,   574,    -1,    36,   573,
     903,   574,    -1,    38,   573,   903,   574,    -1,    85,   573,
     952,   567,   574,    -1,    85,   573,   903,   574,    -1,    -1,
      -1,    85,   573,   125,   894,   907,   895,   574,    -1,   197,
     573,  1112,   575,   338,   575,   338,   575,   903,   574,    -1,
     308,   573,   903,   574,    -1,   308,   573,   125,   903,   574,
      -1,   293,   573,   903,   574,    -1,   293,   573,   125,   903,
     574,    -1,   467,   573,   903,   574,    -1,   540,   573,   903,
     574,    -1,   468,   573,   903,   574,    -1,   534,   573,   903,
     574,    -1,   477,   573,   903,   574,    -1,   477,   573,   125,
     903,   574,    -1,    -1,   196,   573,   900,   896,   907,   902,
     901,   574,    -1,    -1,   579,   898,   899,    -1,  1133,   437,
     873,    -1,  1133,    -1,   579,  1146,  1133,   782,    -1,    -1,
     125,    -1,    -1,   432,  1113,    -1,    -1,   965,    -1,    -1,
     952,   904,   873,    -1,    32,   743,    -1,    56,   743,   759,
      -1,   326,   743,    -1,   443,    -1,   443,   227,    -1,   522,
      -1,   522,   227,    -1,   100,    -1,   494,    -1,    97,    -1,
     108,   738,    -1,    -1,   907,    -1,    -1,   908,   909,    -1,
     873,    -1,   909,   575,   873,    -1,   911,    -1,   573,   911,
     574,    -1,    -1,   912,   913,    -1,  1121,    -1,   913,   575,
    1121,    -1,    -1,   873,    -1,    -1,   559,   873,    -1,   545,
     873,   560,   873,    -1,   916,   545,   873,   560,   873,    -1,
     929,    -1,   920,    -1,   919,    -1,   917,    -1,   919,   575,
     917,    -1,   917,   928,   917,    -1,   917,   471,   929,    -1,
      -1,   917,   928,   917,   344,   921,   873,    -1,    -1,   917,
     471,   929,   344,   922,   873,    -1,    -1,   917,   928,   917,
     530,   923,   573,   946,   574,    -1,   917,   324,   236,   929,
      -1,    -1,   917,   249,   939,   236,   917,   344,   924,   873,
      -1,    -1,   917,   249,   939,   236,   929,   925,   530,   573,
     946,   574,    -1,   917,   324,   249,   939,   236,   929,    -1,
      -1,   917,   416,   939,   236,   917,   344,   926,   873,    -1,
      -1,   917,   416,   939,   236,   929,   927,   530,   573,   946,
     574,    -1,   917,   324,   416,   939,   236,   929,    -1,   236,
      -1,   219,   236,    -1,    88,   236,    -1,    -1,   930,  1125,
     951,   941,    -1,    -1,   577,  1131,   917,   249,   355,   236,
     917,   344,   931,   873,   578,    -1,   938,   937,   934,    -1,
     573,   937,   932,  1209,   574,   951,    -1,    -1,   937,   933,
     919,    -1,    -1,    -1,   935,   862,   866,   936,   715,    -1,
      -1,   430,    -1,    -1,   355,    -1,    -1,   172,   236,    -1,
      -1,   529,   942,    -1,   169,   942,    -1,   214,   942,    -1,
      -1,   773,   940,   943,   573,   944,   574,    -1,    -1,   945,
      -1,   945,   575,  1131,    -1,  1131,    -1,   372,    -1,  1131,
      -1,   946,   575,  1131,    -1,   948,    -1,   101,    -1,   102,
      -1,   103,    -1,   104,    -1,   206,    -1,   207,    -1,   208,
      -1,   302,    -1,   304,    -1,   305,    -1,   427,    -1,   555,
      -1,   105,    -1,   544,    -1,   209,    -1,   174,    -1,   306,
      -1,   314,    -1,   380,    -1,   428,    -1,   556,    -1,   100,
      -1,   494,    -1,    97,    -1,   491,    -1,    -1,    18,    -1,
     145,    -1,    -1,   950,  1131,    -1,    -1,    12,    -1,    -1,
      -1,   546,   954,   873,    -1,    -1,    -1,   201,   956,   873,
      -1,   149,   884,    -1,    -1,    -1,   195,    45,   959,   960,
      -1,   959,   575,  1120,   968,    -1,  1120,   968,    -1,    -1,
     548,    89,    -1,   548,   418,    -1,   352,    45,   962,    -1,
     962,   575,   963,    -1,   963,    -1,  1122,   968,    -1,    -1,
     965,    -1,    -1,   352,    45,   966,   967,    -1,   967,   575,
    1120,   968,    -1,  1120,   968,    -1,    -1,    19,    -1,   116,
      -1,    -1,   971,    -1,    -1,   971,    -1,   253,   972,    -1,
     973,    -1,   973,   575,   973,    -1,   973,   341,   973,    -1,
    1114,    -1,   510,    -1,   267,    -1,   338,    -1,    -1,   253,
     973,    -1,   338,    -1,   203,    -1,   267,    -1,   510,    -1,
     107,    -1,   166,    -1,   338,    -1,   510,    -1,   267,    -1,
     107,    -1,   166,    -1,    -1,    -1,   374,  1131,   978,   573,
     979,   574,    -1,    -1,   980,    -1,   980,   575,   981,    -1,
     981,    -1,   868,   873,    -1,    -1,   983,   984,    -1,   984,
     575,   985,    -1,   985,    -1,   579,  1133,    -1,  1133,    -1,
      -1,   226,   987,   988,    -1,    -1,   356,  1130,   989,  1101,
    1104,    -1,   131,  1130,    -1,   982,    -1,    -1,   128,   991,
     907,    -1,   129,   999,  1156,   998,   994,   799,    -1,    -1,
     129,   217,  1131,   344,  1125,   993,    -1,   129,    94,   998,
    1131,    -1,   129,   179,   998,   609,    -1,   129,   374,   998,
     609,    -1,   129,   527,   608,  1186,    -1,   129,   542,   998,
     994,   799,    -1,   129,   501,   998,   609,    -1,   995,    -1,
     994,   575,   995,    -1,  1125,    -1,   997,    -1,   996,   575,
     997,    -1,  1125,    -1,    -1,   213,   152,    -1,    -1,   486,
      -1,    -1,    -1,   223,  1001,  1006,   798,  1008,  1002,  1010,
    1026,    -1,    -1,    -1,   405,  1004,  1007,  1008,  1005,  1010,
      -1,    -1,   270,    -1,   113,    -1,   204,    -1,  1035,    -1,
     113,    -1,   226,  1009,    -1,  1009,    -1,   995,    -1,  1013,
      -1,   573,   574,  1013,    -1,   573,  1012,   574,  1013,    -1,
      -1,   436,  1011,  1017,    -1,  1012,   575,  1118,    -1,  1118,
      -1,   535,  1016,    -1,   536,  1016,    -1,    -1,   694,  1014,
    1206,    -1,    -1,   573,   694,   574,  1015,  1209,    -1,  1016,
     575,  1021,    -1,  1021,    -1,  1017,   575,  1018,    -1,  1018,
      -1,  1122,  1019,  1025,    -1,   145,    -1,   437,    -1,    -1,
    1019,    -1,    -1,   573,  1022,  1023,   574,    -1,    -1,  1024,
      -1,  1024,   575,  1025,    -1,  1025,    -1,   873,    -1,   111,
      -1,    -1,    -1,   344,   132,  1027,   238,   524,  1033,    -1,
      -1,    -1,   524,  1029,  1035,   798,   918,   436,  1031,  1030,
     953,   964,   974,    -1,  1031,   575,  1032,    -1,  1032,    -1,
    1122,  1019,  1025,    -1,  1033,   575,  1034,    -1,  1034,    -1,
    1122,  1019,  1025,    -1,    -1,   270,    -1,    -1,   115,  1037,
    1045,  1038,    -1,    -1,   175,  1125,  1039,   953,   964,   974,
      -1,    -1,  1042,  1040,   175,   918,   953,    -1,    -1,   175,
     996,  1041,   530,   918,   953,    -1,  1043,    -1,  1042,   575,
    1043,    -1,  1131,  1044,   951,    -1,  1131,   580,  1131,  1044,
     951,    -1,    -1,   580,   567,    -1,    -1,  1046,  1045,    -1,
     382,    -1,   270,    -1,   214,    -1,   505,  1048,   995,    -1,
      -1,   485,    -1,    -1,  1050,    -1,  1051,    -1,  1050,   575,
    1051,    -1,    86,    -1,   300,    -1,    40,   230,    -1,    81,
     481,    -1,   359,   160,    -1,   231,    -1,   480,    -1,   449,
      -1,    12,    -1,    -1,   172,   381,   338,    -1,    -1,   441,
    1054,  1055,    -1,    95,  1066,    -1,  1062,   483,  1061,  1066,
      -1,  1062,   502,  1061,  1066,    -1,   485,   466,  1061,  1066,
      -1,   347,   483,  1061,  1066,    -1,    -1,   143,   711,  1056,
    1058,    -1,  1062,    66,  1063,  1125,  1061,  1066,    -1,   329,
     287,   172,   445,   548,   275,   145,  1128,    16,   276,   145,
     976,    16,   280,   145,   975,    -1,  1059,   263,    -1,   445,
     205,    -1,    -1,    33,   150,  1064,  1065,  1057,   969,    -1,
     775,  1063,  1125,  1061,   953,    -1,    67,   506,    -1,   485,
     506,    -1,  1060,   142,    -1,   373,    -1,    85,   573,   567,
     574,   543,    -1,    85,   573,   567,   574,   147,    -1,   543,
     969,    -1,   147,   969,    -1,   378,    -1,   377,  1049,  1052,
     969,    -1,  1145,   466,  1066,    -1,   220,   466,    -1,   320,
     466,    -1,  1062,   376,    -1,  1145,   539,  1066,    -1,   749,
    1066,    -1,    65,  1066,    -1,    30,   263,    -1,   263,    -1,
     193,    -1,   193,   172,  1134,    -1,    87,    94,   704,  1131,
      -1,    87,   485,  1125,    -1,    87,   542,  1125,    -1,   287,
     466,    -1,   445,   466,    -1,    87,   374,   609,    -1,    87,
     179,   609,    -1,   374,   466,  1066,    -1,   179,   466,  1066,
      -1,   374,    63,   609,    -1,   179,    63,   609,    -1,   466,
      -1,   263,    -1,   287,    -1,    32,    -1,    -1,   470,    -1,
      -1,  1063,  1131,    -1,    -1,   177,    -1,   175,    -1,   229,
      -1,    -1,   229,  1128,    -1,    -1,   175,   976,    -1,    -1,
     252,  1128,    -1,   546,   873,    -1,    -1,  1070,  1125,  1068,
    1072,    -1,    -1,  1070,  1071,  1069,   852,    -1,   116,    -1,
     117,    -1,    -1,   156,    -1,    -1,  1113,    -1,  1131,    -1,
      -1,   168,   834,  1074,  1075,    -1,  1075,   575,  1076,    -1,
    1076,    -1,    -1,  1156,  1077,  1078,    -1,   483,   548,   390,
     262,    -1,   381,    47,    -1,   205,    -1,   373,    -1,   263,
      -1,   466,    -1,   445,    -1,   287,    -1,   120,    -1,   409,
      -1,    -1,   994,    -1,    -1,   408,  1080,  1081,    -1,  1081,
     575,  1082,    -1,  1082,    -1,   445,    -1,   287,    -1,   381,
      47,    -1,    -1,   379,  1084,  1085,    -1,  1059,   263,  1086,
      -1,   498,  1128,    -1,    27,   873,    -1,    -1,   239,  1088,
    1089,   873,    -1,    -1,    77,    -1,   381,    -1,   529,  1131,
      -1,    -1,   257,    96,  1092,  1093,    -1,   257,   485,  1125,
     175,   287,    -1,    -1,    -1,    -1,    -1,  1099,  1098,   218,
    1130,  1094,  1100,   226,  1095,   485,  1125,  1096,   752,  1097,
    1101,  1104,  1107,  1108,  1111,    -1,   175,   287,    -1,    -1,
     258,    -1,    -1,    75,    -1,   270,    -1,    -1,   405,    -1,
     214,    -1,    -1,    66,  1102,    -1,  1102,  1103,    -1,  1103,
      -1,   488,    45,  1113,    -1,   350,   138,    45,  1113,    -1,
     138,    45,  1113,    -1,   148,    45,  1113,    -1,    -1,   255,
    1105,    -1,  1105,  1106,    -1,  1106,    -1,   488,    45,  1113,
      -1,   464,    45,  1113,    -1,    -1,   214,   338,   255,    -1,
      -1,   573,  1109,   574,    -1,   573,   574,    -1,  1109,   575,
    1110,    -1,  1110,    -1,  1122,    -1,   579,  1133,    -1,    -1,
     436,  1033,    -1,   489,    -1,   325,    -1,   513,   489,    -1,
    1112,  1129,    -1,  1129,    -1,   203,    -1,    34,    -1,   362,
      -1,  1116,    -1,   566,  1117,    -1,   565,  1117,    -1,  1112,
      -1,  1117,    -1,   337,    -1,   158,    -1,   504,    -1,   203,
      -1,    34,    -1,   513,   203,    -1,   513,    34,    -1,   100,
    1112,    -1,   494,  1112,    -1,   491,  1112,    -1,   338,    -1,
     267,    -1,   510,    -1,   107,    -1,   166,    -1,  1122,    -1,
    1119,    -1,  1131,   580,   567,    -1,  1131,   580,  1131,   580,
     567,    -1,   873,    -1,  1131,    -1,  1123,    -1,  1131,    -1,
    1123,    -1,  1131,   580,  1131,    -1,   580,  1131,   580,  1131,
      -1,  1131,   580,  1131,   580,  1131,    -1,  1131,    -1,  1131,
     580,  1131,   580,  1131,    -1,  1131,   580,  1131,    -1,   580,
    1131,    -1,  1131,    -1,  1131,   580,  1131,    -1,   580,  1131,
      -1,  1131,    -1,   210,    -1,   212,    -1,   489,    -1,   489,
      -1,   489,    -1,  1127,    -1,  1135,    -1,  1127,    -1,  1136,
      -1,  1131,    -1,  1128,    -1,   251,    -1,  1133,    -1,  1133,
     579,  1133,    -1,    91,   872,    -1,  1136,    -1,    20,    -1,
      26,    -1,    28,    -1,    46,    -1,    47,    -1,    55,    -1,
      57,    -1,    61,    -1,    68,    -1,    70,    -1,    80,    -1,
     106,    -1,   128,    -1,   141,    -1,   151,    -1,   168,    -1,
     199,    -1,   202,    -1,   241,    -1,   335,    -1,   347,    -1,
     370,    -1,   402,    -1,   408,    -1,   410,    -1,   417,    -1,
     426,    -1,   429,    -1,   443,    -1,   445,    -1,   465,    -1,
     469,    -1,   505,    -1,   515,    -1,   552,    -1,   525,    -1,
       5,    -1,     7,    -1,     8,    -1,     9,    -1,    10,    -1,
      11,    -1,    17,    -1,    23,    -1,    24,    -1,    25,    -1,
      30,    -1,    33,    -1,    37,    -1,    40,    -1,    42,    -1,
      41,    -1,    44,    -1,    50,    -1,    52,    -1,    54,    -1,
      59,    -1,    60,    -1,    63,    -1,    65,    -1,    66,    -1,
      69,    -1,    71,    -1,    72,    -1,    75,    -1,    77,    -1,
      78,    -1,    81,    -1,    86,    -1,    89,    -1,    96,    -1,
      97,    -1,   100,    -1,   105,    -1,   112,    -1,   114,    -1,
     120,    -1,   122,    -1,   124,    -1,   131,    -1,   132,    -1,
     133,    -1,   144,    -1,   143,    -1,   142,    -1,   147,    -1,
     149,    -1,   150,    -1,   154,    -1,   156,    -1,   159,    -1,
     160,    -1,   173,    -1,   123,    -1,   137,    -1,   177,    -1,
     163,    -1,   164,    -1,   165,    -1,   174,    -1,   187,    -1,
     186,    -1,   190,    -1,   193,    -1,   191,    -1,   200,    -1,
     205,    -1,   209,    -1,   211,    -1,   228,    -1,   215,    -1,
     216,    -1,   233,    -1,   234,    -1,   220,    -1,   224,    -1,
     230,    -1,   231,    -1,   398,    -1,   243,    -1,   247,    -1,
     250,    -1,   256,    -1,   258,    -1,   261,    -1,   263,    -1,
     292,    -1,   287,    -1,   274,    -1,   278,    -1,   275,    -1,
     276,    -1,   288,    -1,   277,    -1,   280,    -1,   273,    -1,
     286,    -1,   282,    -1,   281,    -1,   283,    -1,   284,    -1,
     285,    -1,   290,    -1,   291,    -1,   294,    -1,   295,    -1,
     299,    -1,   300,    -1,   301,    -1,   302,    -1,   303,    -1,
     306,    -1,   307,    -1,   312,    -1,   310,    -1,   314,    -1,
     317,    -1,   318,    -1,   319,    -1,   320,    -1,   322,    -1,
     321,    -1,   323,    -1,   326,    -1,   327,    -1,   330,    -1,
     329,    -1,   331,    -1,   340,    -1,   341,    -1,   343,    -1,
     345,    -1,   346,    -1,   358,    -1,   359,    -1,   360,    -1,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,   371,    -1,
     373,    -1,   375,    -1,   376,    -1,   377,    -1,   378,    -1,
     380,    -1,   381,    -1,   382,    -1,   383,    -1,   384,    -1,
     385,    -1,   386,    -1,   387,    -1,   392,    -1,   393,    -1,
     396,    -1,   397,    -1,   400,    -1,   403,    -1,   406,    -1,
     409,    -1,   412,    -1,   413,    -1,   418,    -1,   420,    -1,
     421,    -1,   423,    -1,   424,    -1,   425,    -1,   428,    -1,
     434,    -1,   433,    -1,   435,    -1,   444,    -1,   438,    -1,
     442,    -1,   447,    -1,   448,    -1,   449,    -1,   457,    -1,
     456,    -1,   459,    -1,   462,    -1,   466,    -1,   470,    -1,
     472,    -1,   473,    -1,   474,    -1,   478,    -1,   479,    -1,
     480,    -1,   481,    -1,   483,    -1,   484,    -1,   486,    -1,
     487,    -1,   490,    -1,   500,    -1,   502,    -1,   491,    -1,
     492,    -1,   493,    -1,   494,    -1,   506,    -1,   507,    -1,
     508,    -1,   179,    -1,   511,    -1,   512,    -1,   520,    -1,
     523,    -1,   527,    -1,   528,    -1,   539,    -1,   542,    -1,
     536,    -1,   543,    -1,   544,    -1,   549,    -1,   551,    -1,
     556,    -1,    -1,   436,  1139,  1138,  1140,    -1,    -1,   349,
      -1,  1141,    -1,  1140,   575,  1141,    -1,    -1,  1142,  1147,
      -1,  1144,    -1,   191,    -1,   258,    -1,   435,    -1,    -1,
     345,    -1,    -1,   191,    -1,   258,    -1,   435,    -1,    -1,
     191,   580,    -1,   258,   580,    -1,   435,   580,    -1,  1148,
      -1,  1144,  1149,    -1,  1143,  1150,  1019,  1153,    -1,  1143,
     500,   233,   250,  1151,    -1,   579,  1133,  1019,   873,    -1,
     579,   579,  1146,  1150,  1019,  1153,    -1,   749,   754,    -1,
     321,  1019,   873,    -1,   321,   751,   756,    -1,   361,  1019,
    1152,    -1,   361,   172,  1134,  1019,  1152,    -1,  1131,    -1,
    1131,   580,  1131,    -1,   111,   580,  1131,    -1,   390,   511,
      -1,   390,    69,    -1,   403,   390,    -1,   433,    -1,   489,
      -1,   361,   573,   489,   574,    -1,   343,   573,   489,   574,
      -1,   873,    -1,   111,    -1,   344,    -1,    12,    -1,    32,
      -1,    -1,   262,  1156,  1155,  1157,    -1,   485,    -1,   483,
      -1,  1158,    -1,  1157,   575,  1158,    -1,  1125,   951,  1159,
      -1,   390,    -1,   550,    -1,   270,   550,    -1,   390,   258,
      -1,    -1,   521,  1161,  1156,    -1,   199,  1125,   347,   951,
      -1,   199,  1126,    61,    -1,    -1,   199,  1126,   390,  1163,
    1164,   953,   970,    -1,  1165,    -1,  1131,  1166,    -1,   164,
      -1,   330,    -1,   164,    -1,   330,    -1,   371,    -1,   243,
      -1,    -1,  1168,  1167,   573,  1024,   574,    -1,   145,    -1,
     184,    -1,   244,    -1,   198,    -1,   271,    -1,   415,   608,
    1170,    -1,  1174,   344,  1173,  1185,   175,  1187,    -1,  1174,
     344,   179,  1185,   175,  1187,    -1,  1174,   344,   374,  1185,
     175,  1187,    -1,    12,  1175,   575,   192,   349,   175,  1187,
      -1,   192,   608,  1172,    -1,  1174,   344,  1173,  1185,   498,
    1187,  1192,  1193,    -1,  1174,   344,   179,  1185,   498,  1187,
    1192,  1193,    -1,  1174,   344,   374,  1185,   498,  1187,  1192,
    1193,    -1,    -1,   485,    -1,  1176,    -1,    12,  1175,    -1,
      -1,   373,    -1,  1177,    -1,  1176,   575,  1177,    -1,    -1,
     430,  1178,  1189,    -1,    -1,   223,  1179,  1189,    -1,    -1,
     524,  1180,  1189,    -1,    -1,   394,  1181,  1189,    -1,   115,
      -1,   526,    -1,   217,    -1,    13,    -1,    87,    -1,   129,
      -1,   151,    -1,   400,    -1,   442,    -1,   375,    -1,   163,
      -1,   192,   349,    -1,   441,    95,    -1,   478,    -1,    87,
     486,   483,    -1,   262,   483,    -1,   406,   445,    -1,   406,
      60,    -1,    87,   542,    -1,   441,   542,    -1,    87,   420,
      -1,    13,   420,    -1,    87,   527,    -1,    -1,    16,    -1,
    1184,  1182,  1183,    -1,  1184,    -1,   474,   489,    -1,   234,
     489,    -1,    59,   489,    -1,   567,    -1,  1131,   580,   567,
      -1,   567,   580,   567,    -1,  1125,    -1,  1134,    -1,  1186,
     575,  1134,    -1,  1188,    -1,  1187,   575,  1188,    -1,  1134,
     211,    45,   489,    -1,  1134,   211,    45,   361,   489,    -1,
    1134,    -1,    -1,   573,  1190,   574,    -1,  1190,   575,  1191,
      -1,  1191,    -1,  1131,    -1,    -1,   407,  1183,    -1,   407,
     463,    -1,   407,   551,    -1,   407,   331,    -1,    -1,   548,
    1194,    -1,  1194,  1195,    -1,  1195,    -1,   192,   349,    -1,
     291,   975,    -1,   294,   975,    -1,   290,   975,    -1,   295,
     975,    -1,    -1,    28,  1197,  1198,    -1,    -1,   549,    -1,
      -1,    16,   335,    52,    -1,    16,    52,    -1,    -1,   399,
      -1,   335,   399,    -1,    -1,   426,    -1,    70,  1198,  1199,
    1200,    -1,   417,  1198,  1199,  1200,    -1,   417,  1198,   498,
    1201,  1131,    -1,   426,  1131,    -1,   399,   426,  1131,    -1,
      -1,  1207,    -1,    -1,   516,  1213,  1208,   853,    -1,    -1,
    1207,    -1,  1210,    -1,    -1,  1211,  1212,    -1,   965,   969,
      -1,   971,    -1,    -1,   125,    -1,    12,    -1,   430,  1217,
    1216,  1218,    -1,    -1,   573,  1217,  1214,   574,  1215,  1206,
    1218,    -1,   855,    -1,    -1,    -1,  1221,  1220,    -1,  1222,
    1221,  1227,    -1,  1227,    -1,  1235,    -1,  1237,    -1,    -1,
     112,   145,  1134,    -1,  1223,    -1,  1223,  1224,    -1,  1224,
      -1,   354,   405,    -1,    11,   145,   512,    -1,    11,   145,
     301,    -1,    11,   145,   487,    -1,    -1,  1224,    -1,    -1,
     461,   429,   112,    -1,   461,   429,   228,    -1,    -1,  1226,
     542,  1125,  1228,  1229,    18,  1231,  1234,    -1,    -1,   573,
    1230,   574,    -1,  1131,    -1,  1230,   575,  1131,    -1,    -1,
    1232,  1233,    -1,   430,   868,   855,    -1,   573,   868,   854,
     574,  1209,    -1,    -1,   548,    58,   349,    -1,   548,    50,
      58,   349,    -1,   548,   258,    58,   349,    -1,    -1,   501,
     868,   609,   686,   687,   344,   868,  1125,   172,   868,   134,
     424,  1236,   650,    -1,    -1,   716,   868,   179,   609,  1238,
     610,    -1,    -1,    -1,    -1,    -1,   374,   868,   609,  1239,
     573,  1240,   630,   574,  1241,   617,  1242,   650,    -1,   552,
    1245,  1244,  1246,    -1,   552,   141,  1244,  1248,    -1,   552,
     370,  1244,    -1,   552,    70,  1244,  1247,    -1,   552,   417,
    1244,    -1,   552,   392,    -1,  1113,    -1,  1113,   575,  1113,
      -1,  1113,   575,  1113,   575,   975,    -1,    28,    -1,   465,
      -1,    -1,   236,    -1,   412,    -1,    -1,   346,   363,    -1,
      -1,    -1,   479,  1249,  1250,    -1,    -1,   172,   303,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short int yyrline[] =
{
       0,  1219,  1219,  1233,  1236,  1237,  1242,  1243,  1244,  1245,
    1246,  1247,  1248,  1249,  1250,  1251,  1252,  1253,  1254,  1255,
    1256,  1257,  1258,  1259,  1260,  1261,  1262,  1263,  1264,  1265,
    1266,  1267,  1268,  1269,  1270,  1271,  1272,  1273,  1274,  1275,
    1276,  1277,  1278,  1279,  1280,  1281,  1282,  1283,  1284,  1285,
    1286,  1287,  1288,  1292,  1301,  1302,  1307,  1316,  1323,  1333,
    1332,  1343,  1345,  1349,  1350,  1353,  1366,  1365,  1384,  1383,
    1394,  1395,  1398,  1403,  1408,  1413,  1418,  1422,  1427,  1431,
    1435,  1439,  1443,  1448,  1452,  1456,  1472,  1476,  1488,  1487,
    1507,  1506,  1527,  1526,  1539,  1538,  1546,  1554,  1568,  1583,
    1601,  1621,  1660,  1668,  1676,  1688,  1620,  1719,  1720,  1724,
    1725,  1730,  1732,  1734,  1736,  1738,  1740,  1742,  1748,  1749,
    1750,  1754,  1758,  1766,  1765,  1778,  1780,  1783,  1785,  1789,
    1793,  1800,  1802,  1806,  1807,  1812,  1831,  1857,  1859,  1863,
    1864,  1868,  1894,  1895,  1896,  1897,  1901,  1902,  1906,  1907,
    1912,  1915,  1942,  1941,  1997,  2012,  2011,  2055,  2079,  2079,
    2110,  2111,  2116,  2118,  2123,  2146,  2152,  2167,  2168,  2172,
    2176,  2185,  2190,  2195,  2203,  2218,  2236,  2237,  2241,  2241,
    2291,  2290,  2314,  2313,  2317,  2318,  2320,  2320,  2331,  2360,
    2388,  2404,  2403,  2420,  2437,  2439,  2440,  2444,  2465,  2488,
    2490,  2504,  2488,  2522,  2524,  2525,  2529,  2530,  2535,  2541,
    2534,  2560,  2559,  2575,  2576,  2580,  2581,  2586,  2590,  2585,
    2607,  2611,  2606,  2626,  2634,  2639,  2638,  2676,  2677,  2682,
    2681,  2708,  2719,  2721,  2718,  2745,  2744,  2762,  2764,  2769,
    2771,  2773,  2778,  2779,  2780,  2786,  2795,  2796,  2796,  2800,
    2802,  2801,  2804,  2803,  2809,  2825,  2808,  2839,  2840,  2843,
    2844,  2847,  2848,  2851,  2852,  2855,  2856,  2859,  2860,  2863,
    2866,  2867,  2869,  2871,  2874,  2875,  2878,  2879,  2880,  2883,
    2884,  2885,  2886,  2887,  2888,  2889,  2890,  2891,  2906,  2912,
    2913,  2914,  2915,  2920,  2925,  2930,  2945,  2946,  2947,  2948,
    2949,  2950,  2954,  2971,  2987,  2997,  2998,  2999,  3000,  3001,
    3002,  3005,  3006,  3007,  3010,  3011,  3012,  3015,  3016,  3019,
    3020,  3023,  3024,  3025,  3026,  3029,  3030,  3034,  3035,  3039,
    3040,  3047,  3055,  3063,  3080,  3084,  3090,  3092,  3096,  3100,
    3101,  3105,  3110,  3109,  3131,  3132,  3133,  3134,  3136,  3138,
    3140,  3142,  3144,  3146,  3149,  3152,  3155,  3158,  3160,  3163,
    3166,  3167,  3168,  3169,  3182,  3183,  3185,  3187,  3199,  3201,
    3203,  3205,  3206,  3207,  3208,  3209,  3210,  3212,  3214,  3216,
    3216,  3218,  3218,  3220,  3221,  3230,  3231,  3232,  3235,  3236,
    3237,  3238,  3239,  3243,  3247,  3248,  3252,  3253,  3257,  3258,
    3259,  3260,  3261,  3265,  3266,  3267,  3268,  3269,  3272,  3274,
    3275,  3279,  3280,  3281,  3284,  3291,  3292,  3295,  3296,  3299,
    3300,  3301,  3304,  3305,  3308,  3309,  3312,  3313,  3316,  3317,
    3320,  3321,  3322,  3323,  3325,  3326,  3332,  3338,  3344,  3350,
    3351,  3367,  3368,  3372,  3373,  3377,  3385,  3389,  3390,  3393,
    3394,  3398,  3407,  3411,  3412,  3415,  3425,  3426,  3430,  3431,
    3434,  3435,  3438,  3439,  3440,  3441,  3450,  3451,  3454,  3455,
    3458,  3459,  3460,  3469,  3471,  3473,  3478,  3477,  3489,  3490,
    3493,  3494,  3498,  3499,  3502,  3503,  3506,  3507,  3508,  3509,
    3510,  3513,  3514,  3515,  3516,  3517,  3520,  3521,  3522,  3534,
    3535,  3538,  3539,  3542,  3543,  3547,  3548,  3549,  3552,  3553,
    3554,  3555,  3568,  3569,  3570,  3573,  3574,  3578,  3581,  3582,
    3585,  3586,  3597,  3598,  3601,  3602,  3605,  3606,  3614,  3613,
    3637,  3636,  3650,  3649,  3668,  3667,  3687,  3685,  3705,  3706,
    3708,  3709,  3710,  3711,  3712,  3715,  3723,  3724,  3728,  3733,
    3732,  3740,  3749,  3739,  3761,  3768,  3772,  3779,  3786,  3792,
    3798,  3804,  3811,  3829,  3850,  3855,  3859,  3866,  3867,  3870,
    3871,  3875,  3876,  3877,  3881,  3882,  3883,  3886,  3887,  3888,
    3889,  3897,  3896,  3907,  3915,  3914,  3924,  3934,  3943,  3944,
    3951,  3951,  3957,  3958,  3962,  3963,  3964,  3968,  3969,  3986,
    3987,  3992,  3991,  4002,  4001,  4012,  4011,  4021,  4022,  4023,
    4028,  4027,  4039,  4040,  4043,  4044,  4047,  4048,  4049,  4053,
    4052,  4065,  4064,  4081,  4082,  4085,  4086,  4089,  4090,  4091,
    4092,  4093,  4094,  4098,  4097,  4109,  4110,  4111,  4116,  4115,
    4121,  4128,  4133,  4141,  4142,  4145,  4157,  4166,  4167,  4170,
    4183,  4184,  4189,  4188,  4198,  4199,  4202,  4215,  4215,  4225,
    4226,  4235,  4236,  4245,  4254,  4256,  4259,  4281,  4285,  4284,
    4304,  4312,  4304,  4318,  4319,  4320,  4321,  4322,  4325,  4332,
    4339,  4341,  4352,  4353,  4356,  4357,  4363,  4364,  4365,  4366,
    4372,  4378,  4384,  4398,  4401,  4403,  4409,  4419,  4420,  4421,
    4434,  4454,  4461,  4468,  4469,  4472,  4473,  4474,  4475,  4476,
    4480,  4481,  4485,  4534,  4539,  4580,  4582,  4584,  4586,  4588,
    4590,  4592,  4594,  4598,  4600,  4602,  4604,  4606,  4608,  4611,
    4615,  4621,  4625,  4631,  4635,  4643,  4645,  4651,  4654,  4656,
    4658,  4659,  4661,  4664,  4666,  4668,  4670,  4672,  4674,  4676,
    4678,  4680,  4682,  4684,  4686,  4688,  4690,  4692,  4695,  4695,
    4696,  4696,  4697,  4697,  4698,  4698,  4700,  4701,  4702,  4703,
    4704,  4705,  4708,  4709,  4713,  4718,  4719,  4726,  4727,  4728,
    4729,  4730,  4732,  4733,  4734,  4735,  4736,  4740,  4741,  4746,
    4751,  4755,  4756,  4760,  4761,  4765,  4772,  4774,  4780,  4782,
    4793,  4795,  4806,  4817,  4828,  4839,  4841,  4843,  4845,  4847,
    4849,  4851,  4853,  4855,  4857,  4859,  4861,  4863,  4869,  4871,
    4873,  4878,  4883,  4885,  4887,  4892,  4894,  4896,  4898,  4900,
    4905,  4906,  4908,  4910,  4912,  4914,  4916,  4918,  4920,  4922,
    4924,  4926,  4928,  4932,  4934,  4944,  4946,  4948,  4950,  4952,
    4955,  4964,  4969,  4974,  4976,  4978,  4980,  4982,  4984,  4986,
    4988,  4993,  4998,  5000,  5002,  5004,  5006,  5008,  5010,  5016,
    5018,  5020,  5022,  5024,  5026,  5028,  5030,  5032,  5033,  5038,
    5040,  5042,  5044,  5046,  5048,  5050,  5052,  5054,  5061,  5068,
    5070,  5072,  5074,  5076,  5078,  5080,  5082,  5084,  5086,  5088,
    5090,  5092,  5094,  5096,  5110,  5109,  5226,  5230,  5235,  5237,
    5239,  5241,  5243,  5245,  5250,  5252,  5254,  5256,  5258,  5263,
    5267,  5269,  5271,  5273,  5275,  5277,  5281,  5284,  5287,  5289,
    5291,  5293,  5295,  5297,  5299,  5302,  5305,  5307,  5309,  5311,
    5313,  5315,  5318,  5320,  5322,  5324,  5329,  5330,  5331,  5335,
    5336,  5340,  5340,  5346,  5350,  5357,  5388,  5390,  5392,  5394,
    5396,  5398,  5400,  5403,  5405,  5402,  5408,  5410,  5417,  5419,
    5421,  5423,  5425,  5427,  5429,  5431,  5433,  5436,  5435,  5450,
    5449,  5464,  5470,  5476,  5489,  5490,  5494,  5497,  5502,  5505,
    5517,  5516,  5532,  5533,  5534,  5535,  5536,  5537,  5538,  5539,
    5540,  5541,  5542,  5546,  5547,  5551,  5551,  5556,  5557,  5560,
    5561,  5564,  5564,  5569,  5570,  5573,  5574,  5577,  5578,  5581,
    5587,  5597,  5598,  5607,  5612,  5613,  5633,  5635,  5639,  5637,
    5654,  5652,  5670,  5668,  5675,  5684,  5682,  5700,  5699,  5709,
    5720,  5718,  5737,  5736,  5747,  5757,  5758,  5759,  5764,  5764,
    5783,  5781,  5800,  5822,  5870,  5869,  5892,  5910,  5892,  5917,
    5921,  5947,  5948,  5950,  5952,  5955,  5956,  5962,  5969,  5978,
    5977,  5984,  5985,  5989,  5993,  5997,  6003,  6011,  6020,  6021,
    6022,  6023,  6024,  6025,  6026,  6027,  6028,  6029,  6030,  6031,
    6032,  6035,  6036,  6037,  6038,  6039,  6040,  6041,  6042,  6043,
    6047,  6048,  6049,  6050,  6053,  6055,  6056,  6059,  6060,  6063,
    6065,  6069,  6071,  6070,  6084,  6087,  6086,  6101,  6107,  6120,
    6122,  6125,  6127,  6131,  6132,  6145,  6163,  6167,  6168,  6172,
    6185,  6187,  6191,  6190,  6222,  6224,  6228,  6229,  6230,  6235,
    6241,  6245,  6246,  6250,  6254,  6261,  6268,  6277,  6281,  6282,
    6283,  6288,  6292,  6300,  6301,  6302,  6303,  6304,  6305,  6309,
    6310,  6311,  6312,  6313,  6316,  6319,  6318,  6347,  6348,  6351,
    6352,  6355,  6370,  6370,  6380,  6381,  6385,  6397,  6430,  6429,
    6442,  6441,  6450,  6462,  6473,  6472,  6489,  6496,  6496,  6508,
    6515,  6527,  6539,  6543,  6549,  6559,  6560,  6563,  6571,  6572,
    6575,  6585,  6586,  6590,  6591,  6599,  6608,  6598,  6618,  6625,
    6617,  6635,  6647,  6648,  6649,  6653,  6654,  6657,  6658,  6661,
    6670,  6671,  6672,  6674,  6673,  6683,  6684,  6687,  6688,  6689,
    6689,  6690,  6690,  6694,  6695,  6698,  6700,  6703,  6711,  6712,
    6716,  6717,  6722,  6721,  6734,  6735,  6738,  6743,  6751,  6752,
    6755,  6757,  6757,  6765,  6774,  6764,  6796,  6797,  6800,  6807,
    6808,  6811,  6820,  6821,  6827,  6826,  6840,  6839,  6848,  6847,
    6855,  6854,  6864,  6865,  6868,  6875,  6888,  6889,  6893,  6894,
    6897,  6898,  6899,  6902,  6912,  6914,  6916,  6918,  6921,  6922,
    6925,  6929,  6933,  6937,  6941,  6945,  6949,  6953,  6957,  6965,
    6968,  6977,  6976,  6990,  6998,  7007,  7016,  7025,  7035,  7034,
    7037,  7047,  7057,  7061,  7066,  7065,  7070,  7080,  7085,  7091,
    7096,  7101,  7103,  7105,  7107,  7109,  7111,  7119,  7128,  7130,
    7132,  7134,  7143,  7151,  7159,  7161,  7163,  7173,  7180,  7186,
    7194,  7202,  7206,  7210,  7217,  7224,  7234,  7244,  7254,  7267,
    7281,  7294,  7295,  7297,  7299,  7302,  7303,  7306,  7307,  7310,
    7311,  7314,  7315,  7318,  7319,  7321,  7323,  7326,  7338,  7337,
    7352,  7351,  7361,  7362,  7365,  7366,  7370,  7371,  7372,  7380,
    7379,  7391,  7392,  7395,  7395,  7396,  7397,  7398,  7399,  7400,
    7401,  7402,  7403,  7404,  7405,  7408,  7409,  7413,  7412,  7421,
    7422,  7425,  7426,  7427,  7431,  7430,  7440,  7444,  7448,  7460,
    7460,  7468,  7469,  7470,  7475,  7485,  7484,  7500,  7518,  7529,
    7536,  7546,  7517,  7551,  7560,  7561,  7564,  7565,  7577,  7581,
    7582,  7583,  7585,  7587,  7590,  7591,  7594,  7599,  7606,  7611,
    7617,  7619,  7622,  7623,  7626,  7631,  7637,  7639,  7646,  7647,
    7648,  7651,  7653,  7658,  7659,  7664,  7665,  7671,  7689,  7697,
    7702,  7721,  7723,  7734,  7747,  7768,  7769,  7770,  7779,  7780,
    7781,  7786,  7787,  7788,  7789,  7790,  7806,  7820,  7821,  7822,
    7825,  7826,  7827,  7828,  7836,  7851,  7852,  7855,  7861,  7872,
    7875,  7912,  7916,  7924,  7928,  7996,  8011,  8035,  8036,  8052,
    8062,  8065,  8066,  8067,  8071,  8075,  8076,  8101,  8113,  8126,
    8138,  8139,  8148,  8149,  8158,  8159,  8160,  8163,  8176,  8189,
    8203,  8204,  8205,  8206,  8207,  8208,  8209,  8210,  8211,  8212,
    8213,  8214,  8215,  8216,  8217,  8218,  8219,  8220,  8221,  8222,
    8223,  8224,  8225,  8226,  8227,  8228,  8229,  8230,  8231,  8232,
    8233,  8234,  8235,  8236,  8237,  8238,  8239,  8249,  8250,  8251,
    8252,  8253,  8254,  8255,  8256,  8257,  8258,  8259,  8260,  8261,
    8262,  8263,  8264,  8265,  8266,  8267,  8268,  8269,  8270,  8271,
    8272,  8273,  8274,  8275,  8276,  8277,  8278,  8279,  8280,  8281,
    8282,  8283,  8284,  8285,  8286,  8287,  8288,  8289,  8290,  8291,
    8292,  8293,  8294,  8295,  8296,  8297,  8298,  8299,  8300,  8301,
    8302,  8303,  8304,  8305,  8306,  8307,  8308,  8309,  8310,  8311,
    8312,  8313,  8314,  8315,  8316,  8317,  8318,  8319,  8320,  8321,
    8322,  8323,  8324,  8325,  8326,  8327,  8328,  8329,  8330,  8331,
    8332,  8333,  8334,  8335,  8336,  8337,  8338,  8339,  8340,  8341,
    8342,  8343,  8344,  8345,  8346,  8347,  8348,  8349,  8350,  8351,
    8352,  8353,  8354,  8355,  8356,  8357,  8358,  8359,  8360,  8361,
    8362,  8363,  8364,  8365,  8366,  8367,  8368,  8369,  8370,  8371,
    8372,  8373,  8374,  8375,  8376,  8377,  8378,  8379,  8380,  8381,
    8382,  8383,  8384,  8385,  8386,  8387,  8388,  8389,  8390,  8391,
    8392,  8393,  8394,  8395,  8396,  8397,  8398,  8399,  8400,  8401,
    8402,  8403,  8404,  8405,  8406,  8407,  8408,  8409,  8410,  8411,
    8412,  8413,  8414,  8415,  8416,  8417,  8418,  8419,  8420,  8421,
    8422,  8423,  8424,  8425,  8426,  8427,  8428,  8429,  8430,  8431,
    8432,  8433,  8434,  8435,  8436,  8437,  8438,  8439,  8440,  8441,
    8442,  8443,  8444,  8445,  8446,  8447,  8448,  8449,  8450,  8451,
    8452,  8453,  8454,  8455,  8456,  8457,  8458,  8459,  8460,  8461,
    8462,  8463,  8464,  8465,  8466,  8467,  8468,  8469,  8470,  8471,
    8472,  8473,  8474,  8481,  8480,  8494,  8495,  8498,  8499,  8502,
    8502,  8579,  8580,  8581,  8582,  8586,  8587,  8591,  8592,  8593,
    8594,  8598,  8599,  8600,  8601,  8605,  8606,  8609,  8689,  8702,
    8706,  8711,  8718,  8733,  8746,  8767,  8774,  8812,  8855,  8869,
    8870,  8871,  8872,  8876,  8877,  8884,  8893,  8894,  8895,  8896,
    8897,  8905,  8904,  8920,  8921,  8924,  8925,  8928,  8936,  8937,
    8938,  8939,  8944,  8943,  8964,  8976,  8989,  8988,  9007,  9008,
    9012,  9013,  9017,  9018,  9019,  9020,  9022,  9021,  9032,  9033,
    9034,  9035,  9036,  9042,  9047,  9054,  9067,  9079,  9086,  9091,
    9099,  9112,  9126,  9128,  9131,  9132,  9139,  9141,  9145,  9146,
    9149,  9149,  9150,  9150,  9151,  9151,  9152,  9152,  9153,  9154,
    9155,  9156,  9157,  9158,  9159,  9160,  9161,  9162,  9163,  9164,
    9165,  9166,  9167,  9168,  9169,  9170,  9171,  9172,  9173,  9174,
    9175,  9180,  9181,  9185,  9186,  9190,  9200,  9210,  9223,  9237,
    9250,  9263,  9276,  9277,  9286,  9287,  9296,  9321,  9323,  9330,
    9334,  9337,  9338,  9341,  9362,  9363,  9367,  9371,  9375,  9382,
    9383,  9386,  9387,  9391,  9392,  9398,  9404,  9410,  9420,  9419,
    9429,  9430,  9434,  9435,  9436,  9440,  9441,  9442,  9446,  9447,
    9451,  9461,  9468,  9478,  9487,  9501,  9502,  9507,  9506,  9541,
    9542,  9543,  9547,  9547,  9571,  9572,  9576,  9577,  9578,  9582,
    9587,  9586,  9606,  9612,  9633,  9655,  9657,  9662,  9664,  9666,
    9678,  9688,  9701,  9703,  9705,  9710,  9715,  9717,  9719,  9725,
    9726,  9732,  9733,  9735,  9741,  9740,  9755,  9756,  9760,  9765,
    9773,  9773,  9791,  9800,  9813,  9814,  9816,  9818,  9831,  9829,
    9906,  9905,  9915,  9944,  9953,  9962,  9914,  9986,  9990,  9994,
    9998, 10002, 10006, 10012, 10019, 10026, 10035, 10036, 10040, 10041,
   10042, 10046, 10047, 10051, 10052, 10052, 10057, 10058
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "END_OF_INPUT", "ABORT_SYM", "ACTION",
  "ADD", "ADDDATE_SYM", "AFTER_SYM", "AGAINST", "AGGREGATE_SYM",
  "ALGORITHM_SYM", "ALL", "ALTER", "ANALYZE_SYM", "AND_AND_SYM", "AND_SYM",
  "ANY_SYM", "AS", "ASC", "ASCII_SYM", "ASENSITIVE_SYM", "ATAN",
  "AUTO_INC", "AVG_ROW_LENGTH", "AVG_SYM", "BACKUP_SYM", "BEFORE_SYM",
  "BEGIN_SYM", "BENCHMARK_SYM", "BERKELEY_DB_SYM", "BIGINT", "BINARY",
  "BINLOG_SYM", "BIN_NUM", "BIT_AND", "BIT_OR", "BIT_SYM", "BIT_XOR",
  "BLOB_SYM", "BLOCK_SYM", "BOOLEAN_SYM", "BOOL_SYM", "BOTH", "BTREE_SYM",
  "BY", "BYTE_SYM", "CACHE_SYM", "CALL_SYM", "CASCADE", "CASCADED",
  "CAST_SYM", "CHAIN_SYM", "CHANGE", "CHANGED", "CHARSET", "CHAR_SYM",
  "CHECKSUM_SYM", "CHECK_SYM", "CIPHER_SYM", "CLIENT_SYM", "CLOSE_SYM",
  "COALESCE", "CODE_SYM", "COLLATE_SYM", "COLLATION_SYM", "COLUMNS",
  "COLUMN_SYM", "COMMENT_SYM", "COMMITTED_SYM", "COMMIT_SYM",
  "COMPACT_SYM", "COMPRESSED_SYM", "CONCAT", "CONCAT_WS", "CONCURRENT",
  "CONDITION_SYM", "CONNECTION_SYM", "CONSISTENT_SYM", "CONSTRAINT",
  "CONTAINS_SYM", "CONTEXT_SYM", "CONTINUE_SYM", "CONVERT_SYM",
  "CONVERT_TZ_SYM", "COUNT_SYM", "CPU_SYM", "CREATE", "CROSS", "CUBE_SYM",
  "CURDATE", "CURRENT_USER", "CURSOR_SYM", "CURTIME", "DATABASE",
  "DATABASES", "DATA_SYM", "DATETIME", "DATE_ADD_INTERVAL",
  "DATE_SUB_INTERVAL", "DATE_SYM", "DAY_HOUR_SYM", "DAY_MICROSECOND_SYM",
  "DAY_MINUTE_SYM", "DAY_SECOND_SYM", "DAY_SYM", "DEALLOCATE_SYM",
  "DECIMAL_NUM", "DECIMAL_SYM", "DECLARE_SYM", "DECODE_SYM", "DEFAULT",
  "DEFINER_SYM", "DELAYED_SYM", "DELAY_KEY_WRITE_SYM", "DELETE_SYM",
  "DESC", "DESCRIBE", "DES_DECRYPT_SYM", "DES_ENCRYPT_SYM", "DES_KEY_FILE",
  "DETERMINISTIC_SYM", "DIRECTORY_SYM", "DISABLE_SYM", "DISCARD",
  "DISTINCT", "DIV_SYM", "DOUBLE_SYM", "DO_SYM", "DROP", "DUAL_SYM",
  "DUMPFILE", "DUPLICATE_SYM", "DYNAMIC_SYM", "EACH_SYM", "ELSEIF_SYM",
  "ELT_FUNC", "ENABLE_SYM", "ENCLOSED", "ENCODE_SYM", "ENCRYPT", "END",
  "ENGINES_SYM", "ENGINE_SYM", "ENUM", "EQ", "EQUAL_SYM", "ERRORS",
  "ESCAPED", "ESCAPE_SYM", "EVENTS_SYM", "EXECUTE_SYM", "EXISTS",
  "EXIT_SYM", "EXPANSION_SYM", "EXPORT_SET", "EXTENDED_SYM", "EXTRACT_SYM",
  "FALSE_SYM", "FAST_SYM", "FAULTS_SYM", "FETCH_SYM", "FIELD_FUNC",
  "FILE_SYM", "FIRST_SYM", "FIXED_SYM", "FLOAT_NUM", "FLOAT_SYM",
  "FLUSH_SYM", "FORCE_SYM", "FOREIGN", "FORMAT_SYM", "FOR_SYM",
  "FOUND_SYM", "FRAC_SECOND_SYM", "FROM", "FROM_UNIXTIME", "FULL",
  "FULLTEXT_SYM", "FUNCTION_SYM", "FUNC_ARG0", "FUNC_ARG1", "FUNC_ARG2",
  "FUNC_ARG3", "GE", "GEOMCOLLFROMTEXT", "GEOMETRYCOLLECTION",
  "GEOMETRY_SYM", "GEOMFROMTEXT", "GEOMFROMWKB", "GET_FORMAT",
  "GLOBAL_SYM", "GRANT", "GRANTS", "GREATEST_SYM", "GROUP",
  "GROUP_CONCAT_SYM", "GROUP_UNIQUE_USERS", "GT_SYM", "HANDLER_SYM",
  "HASH_SYM", "HAVING", "HELP_SYM", "HEX_NUM", "HIGH_PRIORITY",
  "HOSTS_SYM", "HOUR_MICROSECOND_SYM", "HOUR_MINUTE_SYM",
  "HOUR_SECOND_SYM", "HOUR_SYM", "IDENT", "IDENTIFIED_SYM", "IDENT_QUOTED",
  "IF", "IGNORE_SYM", "IMPORT", "INDEXES", "INDEX_SYM", "INFILE",
  "INNER_SYM", "INNOBASE_SYM", "INOUT_SYM", "INSENSITIVE_SYM", "INSERT",
  "INSERT_METHOD", "INTERVAL_SYM", "INTO", "INT_SYM", "INVOKER_SYM",
  "IN_SYM", "IO_SYM", "IPC_SYM", "IS", "ISOLATION", "ISSUER_SYM",
  "ITERATE_SYM", "JOIN_SYM", "KEYS", "KEY_SYM", "KILL_SYM", "LABEL_SYM",
  "LANGUAGE_SYM", "LAST_INSERT_ID", "LAST_SYM", "LE", "LEADING",
  "LEAST_SYM", "LEAVES", "LEAVE_SYM", "LEFT", "LEVEL_SYM", "LEX_HOSTNAME",
  "LIKE", "LIMIT", "LINEFROMTEXT", "LINES", "LINESTRING", "LOAD",
  "LOCAL_SYM", "LOCATE", "LOCATOR_SYM", "LOCKS_SYM", "LOCK_SYM",
  "LOGS_SYM", "LOG_SYM", "LONGBLOB", "LONGTEXT", "LONG_NUM", "LONG_SYM",
  "LOOP_SYM", "LOW_PRIORITY", "LT", "MAKE_SET_SYM",
  "MASTER_CONNECT_RETRY_SYM", "MASTER_HOST_SYM", "MASTER_LOG_FILE_SYM",
  "MASTER_LOG_POS_SYM", "MASTER_PASSWORD_SYM", "MASTER_PORT_SYM",
  "MASTER_POS_WAIT", "MASTER_SERVER_ID_SYM", "MASTER_SSL_CAPATH_SYM",
  "MASTER_SSL_CA_SYM", "MASTER_SSL_CERT_SYM", "MASTER_SSL_CIPHER_SYM",
  "MASTER_SSL_KEY_SYM", "MASTER_SSL_SYM", "MASTER_SYM", "MASTER_USER_SYM",
  "MATCH", "MAX_CONNECTIONS_PER_HOUR", "MAX_QUERIES_PER_HOUR", "MAX_ROWS",
  "MAX_SYM", "MAX_UPDATES_PER_HOUR", "MAX_USER_CONNECTIONS_SYM",
  "MEDIUMBLOB", "MEDIUMINT", "MEDIUMTEXT", "MEDIUM_SYM", "MEMORY_SYM",
  "MERGE_SYM", "MICROSECOND_SYM", "MIGRATE_SYM", "MINUTE_MICROSECOND_SYM",
  "MINUTE_SECOND_SYM", "MINUTE_SYM", "MIN_ROWS", "MIN_SYM",
  "MLINEFROMTEXT", "MODE_SYM", "MODIFIES_SYM", "MODIFY_SYM", "MOD_SYM",
  "MONTH_SYM", "MPOINTFROMTEXT", "MPOLYFROMTEXT", "MULTILINESTRING",
  "MULTIPOINT", "MULTIPOLYGON", "MUTEX_SYM", "NAMES_SYM", "NAME_SYM",
  "NATIONAL_SYM", "NATURAL", "NCHAR_STRING", "NCHAR_SYM", "NDBCLUSTER_SYM",
  "NE", "NEW_SYM", "NEXT_SYM", "NONE_SYM", "NOT2_SYM", "NOT_SYM",
  "NOW_SYM", "NO_SYM", "NO_WRITE_TO_BINLOG", "NULL_SYM", "NUM",
  "NUMERIC_SYM", "NVARCHAR_SYM", "OFFSET_SYM", "OJ_SYM", "OLD_PASSWORD",
  "ON", "ONE_SHOT_SYM", "ONE_SYM", "OPEN_SYM", "OPTIMIZE", "OPTION",
  "OPTIONALLY", "OR2_SYM", "ORDER_SYM", "OR_OR_SYM", "OR_SYM", "OUTER",
  "OUTFILE", "OUT_SYM", "PACK_KEYS_SYM", "PAGE_SYM", "PARTIAL", "PASSWORD",
  "PARAM_MARKER", "PHASE_SYM", "POINTFROMTEXT", "POINT_SYM",
  "POLYFROMTEXT", "POLYGON", "POSITION_SYM", "PRECISION", "PREPARE_SYM",
  "PREV_SYM", "PRIMARY_SYM", "PRIVILEGES", "PROCEDURE", "PROCESS",
  "PROCESSLIST_SYM", "PROFILE_SYM", "PROFILES_SYM", "PURGE", "QUARTER_SYM",
  "QUERY_SYM", "QUICK", "RAID_0_SYM", "RAID_CHUNKS", "RAID_CHUNKSIZE",
  "RAID_STRIPED_SYM", "RAID_TYPE", "RAND", "READS_SYM", "READ_SYM", "REAL",
  "RECOVER_SYM", "REDUNDANT_SYM", "REFERENCES", "REGEXP",
  "RELAY_LOG_FILE_SYM", "RELAY_LOG_POS_SYM", "RELAY_THREAD", "RELEASE_SYM",
  "RELOAD", "RENAME", "REPAIR", "REPEATABLE_SYM", "REPEAT_SYM", "REPLACE",
  "REPLICATION", "REQUIRE_SYM", "RESET_SYM", "RESOURCES", "RESTORE_SYM",
  "RESTRICT", "RESUME_SYM", "RETURNS_SYM", "RETURN_SYM", "REVOKE", "RIGHT",
  "ROLLBACK_SYM", "ROLLUP_SYM", "ROUND", "ROUTINE_SYM", "ROWS_SYM",
  "ROW_COUNT_SYM", "ROW_FORMAT_SYM", "ROW_SYM", "RTREE_SYM",
  "SAVEPOINT_SYM", "SECOND_MICROSECOND_SYM", "SECOND_SYM", "SECURITY_SYM",
  "SELECT_SYM", "SENSITIVE_SYM", "SEPARATOR_SYM", "SERIALIZABLE_SYM",
  "SERIAL_SYM", "SESSION_SYM", "SET", "SET_VAR", "SHARE_SYM", "SHIFT_LEFT",
  "SHIFT_RIGHT", "SHOW", "SHUTDOWN", "SIGNED_SYM", "SIMPLE_SYM", "SLAVE",
  "SMALLINT", "SNAPSHOT_SYM", "SOUNDS_SYM", "SOURCE_SYM", "SPATIAL_SYM",
  "SPECIFIC_SYM", "SQLEXCEPTION_SYM", "SQLSTATE_SYM", "SQLWARNING_SYM",
  "SQL_BIG_RESULT", "SQL_BUFFER_RESULT", "SQL_CACHE_SYM",
  "SQL_CALC_FOUND_ROWS", "SQL_NO_CACHE_SYM", "SQL_SMALL_RESULT", "SQL_SYM",
  "SQL_THREAD", "SSL_SYM", "STARTING", "START_SYM", "STATUS_SYM",
  "STD_SYM", "STDDEV_SAMP_SYM", "STOP_SYM", "STORAGE_SYM", "STRAIGHT_JOIN",
  "STRING_SYM", "SUBDATE_SYM", "SUBJECT_SYM", "SUBSTRING",
  "SUBSTRING_INDEX", "SUM_SYM", "SUPER_SYM", "SUSPEND_SYM", "SWAPS_SYM",
  "SWITCHES_SYM", "SYSDATE", "TABLES", "TABLESPACE", "TABLE_SYM",
  "TEMPORARY", "TEMPTABLE_SYM", "TERMINATED", "TEXT_STRING", "TEXT_SYM",
  "TIMESTAMP", "TIMESTAMP_ADD", "TIMESTAMP_DIFF", "TIME_SYM", "TINYBLOB",
  "TINYINT", "TINYTEXT", "TO_SYM", "TRAILING", "TRANSACTION_SYM",
  "TRIGGER_SYM", "TRIGGERS_SYM", "TRIM", "TRUE_SYM", "TRUNCATE_SYM",
  "TYPES_SYM", "TYPE_SYM", "UDF_RETURNS_SYM", "UDF_SONAME_SYM",
  "ULONGLONG_NUM", "UNCOMMITTED_SYM", "UNDEFINED_SYM",
  "UNDERSCORE_CHARSET", "UNDO_SYM", "UNICODE_SYM", "UNION_SYM",
  "UNIQUE_SYM", "UNIQUE_USERS", "UNIX_TIMESTAMP", "UNKNOWN_SYM",
  "UNLOCK_SYM", "UNSIGNED", "UNTIL_SYM", "UPDATE_SYM", "UPGRADE_SYM",
  "USAGE", "USER", "USE_FRM", "USE_SYM", "USING", "UTC_DATE_SYM",
  "UTC_TIMESTAMP_SYM", "UTC_TIME_SYM", "VAR_SAMP_SYM", "VALUES",
  "VALUE_SYM", "VARBINARY", "VARCHAR", "VARIABLES", "VARIANCE_SYM",
  "VARYING", "VIEW_SYM", "WARNINGS", "WEEK_SYM", "WHEN_SYM", "WHERE",
  "WHILE_SYM", "WITH", "WORK_SYM", "WRITE_SYM", "X509_SYM", "XA_SYM",
  "XOR", "YEARWEEK", "YEAR_MONTH_SYM", "YEAR_SYM", "ZEROFILL",
  "TABLE_REF_PRIORITY", "ELSE", "THEN_SYM", "CASE_SYM", "BETWEEN_SYM",
  "'|'", "'&'", "'-'", "'+'", "'*'", "'/'", "'%'", "'^'", "'~'", "NEG",
  "'('", "')'", "','", "'!'", "'{'", "'}'", "'@'", "'.'", "';'", "':'",
  "$accept", "query", "verb_clause", "statement", "deallocate",
  "deallocate_or_drop", "prepare", "prepare_src", "execute", "@1",
  "execute_using", "execute_var_list", "execute_var_ident", "help", "@2",
  "change", "@3", "master_defs", "master_def", "master_file_def", "create",
  "@4", "@5", "@6", "@7", "clear_privileges", "sp_name",
  "create_function_tail", "@8", "@9", "@10", "@11", "@12", "sp_a_chistics",
  "sp_c_chistics", "sp_chistic", "sp_c_chistic", "sp_suid", "call", "@13",
  "opt_sp_cparam_list", "opt_sp_cparams", "sp_cparams", "sp_fdparam_list",
  "sp_fdparams", "sp_init_param", "sp_fdparam", "sp_pdparam_list",
  "sp_pdparams", "sp_pdparam", "sp_opt_inout", "sp_proc_stmts",
  "sp_proc_stmts1", "sp_decls", "sp_decl", "@14", "@15", "sp_cursor_stmt",
  "@16", "sp_handler_type", "sp_hcond_list", "sp_hcond_element", "sp_cond",
  "opt_value", "sp_hcond", "sp_decl_idents", "sp_opt_default",
  "sp_proc_stmt", "@17", "@18", "@19", "@20", "@21", "sp_opt_fetch_noise",
  "sp_fetch_list", "sp_if", "@22", "@23", "@24", "sp_elseifs",
  "case_stmt_specification", "simple_case_stmt", "@25", "@26",
  "searched_case_stmt", "@27", "simple_when_clause_list",
  "searched_when_clause_list", "simple_when_clause", "@28", "@29",
  "searched_when_clause", "@30", "@31", "else_clause_opt",
  "sp_labeled_control", "@32", "sp_opt_label", "sp_unlabeled_control",
  "@33", "@34", "@35", "@36", "trg_action_time", "trg_event", "create2",
  "create2a", "@37", "create3", "@38", "@39", "create_select", "@40",
  "@41", "opt_as", "opt_create_database_options",
  "create_database_options", "create_database_option", "opt_table_options",
  "table_options", "table_option", "opt_if_not_exists",
  "opt_create_table_options", "create_table_options_space_separated",
  "create_table_options", "create_table_option", "default_charset",
  "default_collation", "storage_engines", "row_types", "raid_types",
  "merge_insert_types", "opt_select_from", "udf_func_type", "udf_type",
  "field_list", "field_list_item", "column_def", "key_def",
  "opt_check_constraint", "check_constraint", "opt_constraint",
  "constraint", "field_spec", "@42", "type", "@43", "@44", "spatial_type",
  "char", "nchar", "varchar", "nvarchar", "int_type", "real_type",
  "float_options", "precision", "field_options", "field_opt_list",
  "field_option", "opt_len", "opt_precision", "opt_attribute",
  "opt_attribute_list", "attribute", "now_or_signed_literal", "charset",
  "charset_name", "charset_name_or_default", "opt_load_data_charset",
  "old_or_new_charset_name", "old_or_new_charset_name_or_default",
  "collation_name", "opt_collate", "collation_name_or_default",
  "opt_default", "opt_binary", "opt_bin_mod", "opt_bin_charset",
  "opt_primary", "references", "@45", "opt_ref_list", "ref_list",
  "opt_on_delete", "opt_on_delete_list", "opt_on_delete_item",
  "delete_option", "key_type", "constraint_key_type", "key_or_index",
  "opt_key_or_index", "keys_or_index", "opt_unique_or_fulltext", "key_alg",
  "opt_btree_or_rtree", "key_list", "key_part", "opt_ident",
  "opt_component", "string_list", "alter", "@46", "@47", "@48", "@49",
  "@50", "ident_or_empty", "alter_list", "add_column", "alter_list_item",
  "@51", "@52", "@53", "opt_column", "opt_ignore", "opt_restrict",
  "opt_place", "opt_to", "slave", "@54", "@55", "start",
  "start_transaction_opts", "slave_thread_opts", "@56",
  "slave_thread_opt_list", "slave_thread_opt", "slave_until",
  "slave_until_opts", "restore", "@57", "backup", "@58", "checksum", "@59",
  "opt_checksum_type", "repair", "@60", "opt_mi_repair_type",
  "mi_repair_types", "mi_repair_type", "analyze", "@61", "check", "@62",
  "opt_mi_check_type", "mi_check_types", "mi_check_type", "optimize",
  "@63", "opt_no_write_to_binlog", "rename", "@64", "rename_list",
  "table_to_table_list", "table_to_table", "keycache", "keycache_list",
  "assign_to_keycache", "key_cache_name", "preload", "@65", "preload_list",
  "preload_keys", "cache_keys_spec", "@66", "cache_key_list_or_empty",
  "opt_ignore_leaves", "select", "select_init", "select_paren",
  "select_init2", "@67", "select_part2", "@68", "@69", "select_into",
  "select_from", "select_options", "select_option_list", "select_option",
  "select_lock_type", "select_item_list", "select_item", "remember_name",
  "remember_end", "select_item2", "select_alias", "optional_braces",
  "expr", "bool_pri", "predicate", "bit_expr", "or", "and", "not", "not2",
  "comp_op", "all_or_any", "interval_expr", "simple_expr", "@70",
  "geometry_function", "fulltext_options", "udf_expr_list",
  "udf_expr_list2", "@71", "udf_expr_list3", "udf_expr", "sum_expr", "@72",
  "@73", "@74", "variable", "@75", "variable_aux", "opt_distinct",
  "opt_gconcat_separator", "opt_gorder_clause", "in_sum_expr", "@76",
  "cast_type", "opt_expr_list", "expr_list", "@77", "expr_list2",
  "ident_list_arg", "ident_list", "@78", "ident_list2", "opt_expr",
  "opt_else", "when_list", "table_ref", "join_table_list",
  "derived_table_list", "join_table", "@79", "@80", "@81", "@82", "@83",
  "@84", "@85", "normal_join", "table_factor", "@86", "@87",
  "select_derived", "@88", "select_derived2", "@89", "@90",
  "get_select_lex", "select_derived_init", "opt_outer", "opt_for_join",
  "opt_key_definition", "key_usage_list", "@91", "key_list_or_empty",
  "key_usage_list2", "using_list", "interval", "interval_time_st",
  "date_time_type", "table_alias", "opt_table_alias", "opt_all",
  "where_clause", "@92", "having_clause", "@93", "opt_escape",
  "group_clause", "group_list", "olap_opt", "alter_order_clause",
  "alter_order_list", "alter_order_item", "opt_order_clause",
  "order_clause", "@94", "order_list", "order_dir",
  "opt_limit_clause_init", "opt_limit_clause", "limit_clause",
  "limit_options", "limit_option", "delete_limit_clause", "ulong_num",
  "ulonglong_num", "procedure_clause", "@95", "procedure_list",
  "procedure_list2", "procedure_item", "select_var_list_init", "@96",
  "select_var_list", "select_var_ident", "into", "@97", "into_destination",
  "@98", "do", "@99", "drop", "@100", "table_list", "table_name",
  "table_alias_ref_list", "table_alias_ref", "if_exists", "opt_temporary",
  "insert", "@101", "@102", "replace", "@103", "@104",
  "insert_lock_option", "replace_lock_option", "insert2", "insert_table",
  "insert_field_spec", "@105", "fields", "insert_values", "@106", "@107",
  "values_list", "ident_eq_list", "ident_eq_value", "equal", "opt_equal",
  "no_braces", "@108", "opt_values", "values", "expr_or_default",
  "opt_insert_update", "@109", "update", "@110", "@111", "update_list",
  "update_elem", "insert_update_list", "insert_update_elem",
  "opt_low_priority", "delete", "@112", "single_multi", "@113", "@114",
  "@115", "table_wild_list", "table_wild_one", "opt_wild",
  "opt_delete_options", "opt_delete_option", "truncate", "opt_table_sym",
  "opt_profile_defs", "profile_defs", "profile_def", "opt_profile_args",
  "show", "@116", "show_param", "@117", "@118", "show_engine_param",
  "master_or_binary", "opt_storage", "opt_db", "opt_full", "from_or_in",
  "binlog_in", "binlog_from", "wild_and_where", "describe", "@119", "@120",
  "describe_command", "opt_extended_describe", "opt_describe_column",
  "flush", "@121", "flush_options", "flush_option", "@122",
  "opt_table_list", "reset", "@123", "reset_options", "reset_option",
  "purge", "@124", "purge_options", "purge_option", "kill", "@125",
  "kill_option", "use", "load", "@126", "load_data", "@127", "@128",
  "@129", "@130", "opt_local", "load_data_lock", "opt_duplicate",
  "opt_field_term", "field_term_list", "field_term", "opt_line_term",
  "line_term_list", "line_term", "opt_ignore_lines",
  "opt_field_or_var_spec", "fields_or_vars", "field_or_var",
  "opt_load_data_set_spec", "text_literal", "text_string", "param_marker",
  "signed_literal", "literal", "NUM_literal", "insert_ident", "table_wild",
  "order_ident", "simple_ident", "simple_ident_nospvar", "simple_ident_q",
  "field_ident", "table_ident", "table_ident_nodb", "IDENT_sys",
  "TEXT_STRING_sys", "TEXT_STRING_literal", "TEXT_STRING_filesystem",
  "ident", "label_ident", "ident_or_text", "user", "keyword", "keyword_sp",
  "set", "@131", "opt_option", "option_value_list", "option_type_value",
  "@132", "option_type", "option_type2", "opt_var_type",
  "opt_var_ident_type", "ext_option_value", "sys_option_value",
  "option_value", "internal_variable_name", "isolation_types",
  "text_or_password", "set_expr_or_default", "lock", "@133",
  "table_or_tables", "table_lock_list", "table_lock", "lock_option",
  "unlock", "@134", "handler", "@135", "handler_read_or_scan",
  "handler_scan_function", "handler_rkey_function", "@136",
  "handler_rkey_mode", "revoke", "revoke_command", "grant",
  "grant_command", "opt_table", "grant_privileges", "opt_privileges",
  "object_privilege_list", "object_privilege", "@137", "@138", "@139",
  "@140", "opt_and", "require_list", "require_list_element", "grant_ident",
  "user_list", "grant_list", "grant_user", "opt_column_list",
  "column_list", "column_list_id", "require_clause", "grant_options",
  "grant_option_list", "grant_option", "begin", "@141", "opt_work",
  "opt_chain", "opt_release", "opt_savepoint", "commit", "rollback",
  "savepoint", "release", "union_clause", "union_list", "@142",
  "union_opt", "union_order_or_limit", "@143", "order_or_limit",
  "union_option", "subselect", "@144", "subselect_init", "subselect_start",
  "subselect_end", "view_or_trigger_or_sp", "view_or_trigger_or_sp_tail",
  "definer", "view_replace_or_algorithm", "view_replace", "view_algorithm",
  "view_algorithm_opt", "view_suid", "view_tail", "@145", "view_list_opt",
  "view_list", "view_select", "@146", "view_select_aux",
  "view_check_option", "trigger_tail", "@147", "sp_tail", "@148", "@149",
  "@150", "@151", "@152", "xa", "xid", "begin_or_start",
  "opt_join_or_resume", "opt_one_phase", "opt_suspend", "@153",
  "opt_migrate", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short int yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     805,   806,   807,   808,   809,   810,   811,   812,   813,   814,
     815,   816,   817,   124,    38,    45,    43,    42,    47,    37,
      94,   126,   818,    40,    41,    44,    33,   123,   125,    64,
      46,    59,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short int yyr1[] =
{
       0,   583,   584,   584,   585,   585,   586,   586,   586,   586,
     586,   586,   586,   586,   586,   586,   586,   586,   586,   586,
     586,   586,   586,   586,   586,   586,   586,   586,   586,   586,
     586,   586,   586,   586,   586,   586,   586,   586,   586,   586,
     586,   586,   586,   586,   586,   586,   586,   586,   586,   586,
     586,   586,   586,   587,   588,   588,   589,   590,   590,   592,
     591,   593,   593,   594,   594,   595,   597,   596,   599,   598,
     600,   600,   601,   601,   601,   601,   601,   601,   601,   601,
     601,   601,   601,   601,   602,   602,   602,   602,   604,   603,
     605,   603,   606,   603,   607,   603,   603,   608,   609,   609,
     610,   611,   612,   613,   614,   615,   610,   616,   616,   617,
     617,   618,   618,   618,   618,   618,   618,   618,   619,   619,
     619,   620,   620,   622,   621,   623,   623,   624,   624,   625,
     625,   626,   626,   627,   627,   628,   629,   630,   630,   631,
     631,   632,   633,   633,   633,   633,   634,   634,   635,   635,
     636,   636,   638,   637,   637,   639,   637,   637,   641,   640,
     642,   642,   643,   643,   644,   645,   645,   646,   646,   647,
     647,   647,   647,   647,   648,   648,   649,   649,   651,   650,
     652,   650,   653,   650,   650,   650,   654,   650,   650,   650,
     650,   655,   650,   650,   656,   656,   656,   657,   657,   659,
     660,   661,   658,   662,   662,   662,   663,   663,   665,   666,
     664,   668,   667,   669,   669,   670,   670,   672,   673,   671,
     675,   676,   674,   677,   677,   679,   678,   680,   680,   682,
     681,   681,   683,   684,   681,   685,   681,   686,   686,   687,
     687,   687,   688,   688,   688,   688,   689,   690,   689,   691,
     692,   691,   693,   691,   695,   696,   694,   697,   697,   698,
     698,   699,   699,   700,   700,   701,   701,   702,   702,   703,
     704,   704,   705,   705,   706,   706,   707,   707,   707,   708,
     708,   708,   708,   708,   708,   708,   708,   708,   708,   708,
     708,   708,   708,   708,   708,   708,   708,   708,   708,   708,
     708,   708,   709,   710,   711,   712,   712,   712,   712,   712,
     712,   713,   713,   713,   714,   714,   714,   715,   715,   716,
     716,   717,   717,   717,   717,   718,   718,   719,   719,   720,
     720,   721,   721,   721,   721,   721,   722,   722,   723,   724,
     724,   725,   727,   726,   728,   728,   728,   728,   728,   728,
     728,   728,   728,   728,   728,   728,   728,   728,   728,   728,
     728,   728,   728,   728,   728,   728,   728,   728,   728,   728,
     728,   728,   728,   728,   728,   728,   728,   728,   728,   729,
     728,   730,   728,   728,   728,   731,   731,   731,   731,   731,
     731,   731,   731,   732,   733,   733,   734,   734,   735,   735,
     735,   735,   735,   736,   736,   736,   736,   736,   737,   737,
     737,   738,   738,   738,   739,   740,   740,   741,   741,   742,
     742,   742,   743,   743,   744,   744,   745,   745,   746,   746,
     747,   747,   747,   747,   747,   747,   747,   747,   747,   747,
     747,   748,   748,   749,   749,   750,   750,   751,   751,   752,
     752,   753,   753,   754,   754,   755,   756,   756,   757,   757,
     758,   758,   759,   759,   759,   759,   759,   759,   760,   760,
     761,   761,   761,   761,   762,   762,   764,   763,   765,   765,
     766,   766,   767,   767,   768,   768,   769,   769,   769,   769,
     769,   770,   770,   770,   770,   770,   771,   771,   771,   772,
     772,   773,   773,   774,   774,   775,   775,   775,   776,   776,
     776,   776,   777,   777,   777,   778,   778,   778,   779,   779,
     780,   780,   781,   781,   782,   782,   783,   783,   785,   784,
     786,   784,   787,   784,   788,   784,   789,   784,   790,   790,
     791,   791,   791,   791,   791,   792,   793,   793,   793,   794,
     793,   795,   796,   793,   793,   793,   793,   793,   793,   793,
     793,   793,   793,   793,   793,   793,   793,   797,   797,   798,
     798,   799,   799,   799,   800,   800,   800,   801,   801,   801,
     801,   803,   802,   802,   804,   802,   802,   805,   806,   806,
     808,   807,   809,   809,   810,   810,   810,   811,   811,   812,
     812,   814,   813,   816,   815,   818,   817,   819,   819,   819,
     821,   820,   822,   822,   823,   823,   824,   824,   824,   826,
     825,   828,   827,   829,   829,   830,   830,   831,   831,   831,
     831,   831,   831,   833,   832,   834,   834,   834,   836,   835,
     835,   837,   837,   838,   838,   839,   840,   841,   841,   842,
     843,   843,   845,   844,   846,   846,   847,   849,   848,   850,
     850,   851,   851,   852,   853,   853,   854,   854,   856,   855,
     858,   859,   857,   860,   860,   860,   860,   860,   861,   861,
     862,   862,   863,   863,   864,   864,   864,   864,   864,   864,
     864,   864,   864,   864,   865,   865,   865,   866,   866,   866,
     867,   868,   869,   870,   870,   871,   871,   871,   871,   871,
     872,   872,   873,   873,   873,   873,   873,   873,   873,   873,
     873,   873,   873,   874,   874,   874,   874,   874,   874,   875,
     875,   875,   875,   875,   875,   875,   875,   875,   875,   875,
     875,   875,   875,   876,   876,   876,   876,   876,   876,   876,
     876,   876,   876,   876,   876,   876,   876,   876,   877,   877,
     878,   878,   879,   879,   880,   880,   881,   881,   881,   881,
     881,   881,   882,   882,   883,   884,   884,   884,   884,   884,
     884,   884,   884,   884,   884,   884,   884,   884,   884,   884,
     884,   884,   884,   884,   884,   884,   884,   884,   884,   884,
     884,   884,   884,   884,   884,   884,   884,   884,   884,   884,
     884,   884,   884,   884,   884,   884,   884,   884,   884,   884,
     884,   884,   884,   884,   884,   884,   884,   884,   884,   884,
     884,   884,   884,   884,   884,   884,   884,   884,   884,   884,
     884,   884,   884,   884,   884,   884,   884,   884,   884,   884,
     884,   884,   884,   884,   884,   884,   884,   884,   884,   884,
     884,   884,   884,   884,   884,   884,   884,   884,   884,   884,
     884,   884,   884,   884,   884,   884,   884,   884,   884,   884,
     884,   884,   884,   884,   884,   884,   884,   884,   884,   884,
     884,   884,   884,   884,   884,   884,   884,   884,   884,   884,
     884,   884,   884,   884,   885,   884,   884,   884,   884,   884,
     884,   884,   884,   884,   884,   884,   884,   884,   884,   884,
     886,   886,   886,   886,   886,   886,   886,   886,   886,   886,
     886,   886,   886,   886,   886,   886,   886,   886,   886,   886,
     886,   886,   886,   886,   886,   886,   887,   887,   887,   888,
     888,   890,   889,   891,   891,   892,   893,   893,   893,   893,
     893,   893,   893,   894,   895,   893,   893,   893,   893,   893,
     893,   893,   893,   893,   893,   893,   893,   896,   893,   898,
     897,   899,   899,   899,   900,   900,   901,   901,   902,   902,
     904,   903,   905,   905,   905,   905,   905,   905,   905,   905,
     905,   905,   905,   906,   906,   908,   907,   909,   909,   910,
     910,   912,   911,   913,   913,   914,   914,   915,   915,   916,
     916,   917,   917,   918,   919,   919,   920,   920,   921,   920,
     922,   920,   923,   920,   920,   924,   920,   925,   920,   920,
     926,   920,   927,   920,   920,   928,   928,   928,   930,   929,
     931,   929,   929,   929,   933,   932,   935,   936,   934,   937,
     938,   939,   939,   940,   940,   941,   941,   941,   941,   943,
     942,   944,   944,   945,   945,   945,   946,   946,   947,   947,
     947,   947,   947,   947,   947,   947,   947,   947,   947,   947,
     947,   948,   948,   948,   948,   948,   948,   948,   948,   948,
     949,   949,   949,   949,   950,   950,   950,   951,   951,   952,
     952,   953,   954,   953,   955,   956,   955,   957,   957,   958,
     958,   959,   959,   960,   960,   960,   961,   962,   962,   963,
     964,   964,   966,   965,   967,   967,   968,   968,   968,   969,
     969,   970,   970,   971,   972,   972,   972,   973,   973,   973,
     973,   974,   974,   975,   975,   975,   975,   975,   975,   976,
     976,   976,   976,   976,   977,   978,   977,   979,   979,   980,
     980,   981,   983,   982,   984,   984,   985,   985,   987,   986,
     989,   988,   988,   988,   991,   990,   992,   993,   992,   992,
     992,   992,   992,   992,   992,   994,   994,   995,   996,   996,
     997,   998,   998,   999,   999,  1001,  1002,  1000,  1004,  1005,
    1003,  1006,  1006,  1006,  1006,  1007,  1007,  1008,  1008,  1009,
    1010,  1010,  1010,  1011,  1010,  1012,  1012,  1013,  1013,  1014,
    1013,  1015,  1013,  1016,  1016,  1017,  1017,  1018,  1019,  1019,
    1020,  1020,  1022,  1021,  1023,  1023,  1024,  1024,  1025,  1025,
    1026,  1027,  1026,  1029,  1030,  1028,  1031,  1031,  1032,  1033,
    1033,  1034,  1035,  1035,  1037,  1036,  1039,  1038,  1040,  1038,
    1041,  1038,  1042,  1042,  1043,  1043,  1044,  1044,  1045,  1045,
    1046,  1046,  1046,  1047,  1048,  1048,  1049,  1049,  1050,  1050,
    1051,  1051,  1051,  1051,  1051,  1051,  1051,  1051,  1051,  1052,
    1052,  1054,  1053,  1055,  1055,  1055,  1055,  1055,  1056,  1055,
    1055,  1055,  1055,  1055,  1057,  1055,  1055,  1055,  1055,  1055,
    1055,  1055,  1055,  1055,  1055,  1055,  1055,  1055,  1055,  1055,
    1055,  1055,  1055,  1055,  1055,  1055,  1055,  1055,  1055,  1055,
    1055,  1055,  1055,  1055,  1055,  1055,  1055,  1055,  1055,  1058,
    1058,  1059,  1059,  1060,  1060,  1061,  1061,  1062,  1062,  1063,
    1063,  1064,  1064,  1065,  1065,  1066,  1066,  1066,  1068,  1067,
    1069,  1067,  1070,  1070,  1071,  1071,  1072,  1072,  1072,  1074,
    1073,  1075,  1075,  1077,  1076,  1076,  1076,  1076,  1076,  1076,
    1076,  1076,  1076,  1076,  1076,  1078,  1078,  1080,  1079,  1081,
    1081,  1082,  1082,  1082,  1084,  1083,  1085,  1086,  1086,  1088,
    1087,  1089,  1089,  1089,  1090,  1092,  1091,  1091,  1094,  1095,
    1096,  1097,  1093,  1093,  1098,  1098,  1099,  1099,  1099,  1100,
    1100,  1100,  1101,  1101,  1102,  1102,  1103,  1103,  1103,  1103,
    1104,  1104,  1105,  1105,  1106,  1106,  1107,  1107,  1108,  1108,
    1108,  1109,  1109,  1110,  1110,  1111,  1111,  1112,  1112,  1112,
    1112,  1113,  1113,  1113,  1114,  1115,  1115,  1115,  1116,  1116,
    1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,  1116,
    1117,  1117,  1117,  1117,  1117,  1118,  1118,  1119,  1119,  1120,
    1121,  1121,  1122,  1122,  1123,  1123,  1123,  1124,  1124,  1124,
    1124,  1125,  1125,  1125,  1126,  1127,  1127,  1128,  1129,  1130,
    1131,  1131,  1132,  1132,  1133,  1133,  1133,  1134,  1134,  1134,
    1135,  1135,  1135,  1135,  1135,  1135,  1135,  1135,  1135,  1135,
    1135,  1135,  1135,  1135,  1135,  1135,  1135,  1135,  1135,  1135,
    1135,  1135,  1135,  1135,  1135,  1135,  1135,  1135,  1135,  1135,
    1135,  1135,  1135,  1135,  1135,  1135,  1135,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1136,  1136,  1138,  1137,  1139,  1139,  1140,  1140,  1142,
    1141,  1143,  1143,  1143,  1143,  1144,  1144,  1145,  1145,  1145,
    1145,  1146,  1146,  1146,  1146,  1147,  1147,  1148,  1148,  1149,
    1149,  1149,  1149,  1149,  1149,  1149,  1150,  1150,  1150,  1151,
    1151,  1151,  1151,  1152,  1152,  1152,  1153,  1153,  1153,  1153,
    1153,  1155,  1154,  1156,  1156,  1157,  1157,  1158,  1159,  1159,
    1159,  1159,  1161,  1160,  1162,  1162,  1163,  1162,  1164,  1164,
    1165,  1165,  1166,  1166,  1166,  1166,  1167,  1166,  1168,  1168,
    1168,  1168,  1168,  1169,  1170,  1170,  1170,  1170,  1171,  1172,
    1172,  1172,  1173,  1173,  1174,  1174,  1175,  1175,  1176,  1176,
    1178,  1177,  1179,  1177,  1180,  1177,  1181,  1177,  1177,  1177,
    1177,  1177,  1177,  1177,  1177,  1177,  1177,  1177,  1177,  1177,
    1177,  1177,  1177,  1177,  1177,  1177,  1177,  1177,  1177,  1177,
    1177,  1182,  1182,  1183,  1183,  1184,  1184,  1184,  1185,  1185,
    1185,  1185,  1186,  1186,  1187,  1187,  1188,  1188,  1188,  1189,
    1189,  1190,  1190,  1191,  1192,  1192,  1192,  1192,  1192,  1193,
    1193,  1194,  1194,  1195,  1195,  1195,  1195,  1195,  1197,  1196,
    1198,  1198,  1199,  1199,  1199,  1200,  1200,  1200,  1201,  1201,
    1202,  1203,  1203,  1204,  1205,  1206,  1206,  1208,  1207,  1209,
    1209,  1209,  1211,  1210,  1212,  1212,  1213,  1213,  1213,  1214,
    1215,  1214,  1216,  1217,  1218,  1219,  1219,  1220,  1220,  1220,
    1221,  1221,  1222,  1222,  1222,  1223,  1224,  1224,  1224,  1225,
    1225,  1226,  1226,  1226,  1228,  1227,  1229,  1229,  1230,  1230,
    1232,  1231,  1233,  1233,  1234,  1234,  1234,  1234,  1236,  1235,
    1238,  1237,  1239,  1240,  1241,  1242,  1237,  1243,  1243,  1243,
    1243,  1243,  1243,  1244,  1244,  1244,  1245,  1245,  1246,  1246,
    1246,  1247,  1247,  1248,  1249,  1248,  1250,  1250
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     3,     1,     1,     4,     1,     2,     0,
       4,     0,     2,     3,     1,     2,     0,     3,     0,     5,
       1,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     1,     3,     3,     3,     3,     0,     7,
       0,    11,     0,     6,     0,     3,     4,     0,     3,     1,
       4,     0,     0,     0,     0,     0,    12,     0,     2,     0,
       2,     2,     2,     2,     2,     3,     3,     1,     1,     1,
       2,     3,     3,     0,     4,     0,     3,     0,     1,     3,
       1,     0,     1,     3,     1,     0,     3,     0,     1,     3,
       1,     4,     0,     1,     1,     1,     0,     3,     2,     3,
       0,     3,     0,     5,     5,     0,     7,     5,     0,     2,
       1,     1,     1,     3,     1,     1,     3,     0,     1,     1,
       1,     1,     2,     1,     1,     3,     0,     2,     0,     2,
       0,     3,     0,     5,     1,     1,     0,     2,     2,     2,
       2,     0,     6,     2,     0,     2,     1,     1,     3,     0,
       0,     0,     7,     0,     2,     2,     1,     1,     0,     0,
       8,     0,     6,     1,     2,     1,     2,     0,     0,     6,
       0,     0,     6,     0,     2,     0,     5,     0,     1,     0,
       5,     4,     0,     0,     8,     0,     7,     1,     1,     1,
       1,     1,     2,     2,     2,     4,     4,     0,     4,     0,
       0,     5,     0,     7,     0,     0,     6,     0,     1,     0,
       1,     1,     2,     1,     1,     0,     1,     1,     2,     1,
       0,     3,     0,     1,     1,     2,     1,     2,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     5,     1,     1,     3,     4,
       4,     3,     4,     4,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     0,
       1,     1,     1,     1,     1,     1,     3,     1,     1,     2,
       2,     6,     7,     8,     2,     2,     0,     1,     2,     0,
       1,     2,     0,     4,     3,     3,     3,     1,     4,     1,
       1,     5,     2,     5,     2,     4,     1,     5,     5,     4,
       3,     1,     1,     2,     1,     1,     2,     1,     1,     1,
       2,     3,     2,     3,     2,     2,     3,     3,     3,     0,
       6,     0,     6,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     2,     1,     2,     1,
       2,     3,     2,     1,     1,     1,     1,     1,     1,     1,
       2,     0,     3,     1,     5,     0,     1,     2,     1,     1,
       1,     1,     0,     3,     0,     1,     0,     1,     2,     1,
       1,     2,     2,     4,     1,     3,     2,     1,     2,     2,
       2,     2,     1,     2,     1,     1,     1,     1,     1,     0,
       2,     1,     1,     1,     1,     1,     0,     2,     1,     1,
       0,     1,     0,     2,     1,     2,     3,     2,     0,     1,
       0,     1,     1,     2,     0,     1,     0,     4,     1,     4,
       3,     1,     0,     1,     2,     1,     3,     3,     2,     2,
       2,     1,     1,     2,     2,     2,     1,     2,     2,     2,
       2,     1,     1,     0,     1,     1,     1,     1,     0,     1,
       1,     1,     0,     2,     2,     1,     1,     1,     4,     2,
       1,     4,     0,     1,     0,     2,     1,     3,     0,     6,
       0,     5,     0,     5,     0,     5,     0,    11,     0,     1,
       0,     2,     2,     1,     3,     2,     3,     2,     4,     0,
       6,     0,     0,     8,     4,     4,     3,     3,     2,     2,
       6,     5,     3,     5,     1,     1,     1,     0,     1,     0,
       1,     0,     1,     1,     0,     2,     1,     0,     1,     1,
       1,     0,     5,     3,     0,     5,     3,     3,     0,     3,
       0,     2,     1,     3,     0,     1,     1,     0,     2,     1,
       3,     0,     6,     0,     6,     0,     5,     0,     1,     1,
       0,     6,     0,     1,     1,     2,     1,     1,     1,     0,
       6,     0,     5,     0,     1,     1,     2,     1,     1,     1,
       1,     1,     2,     0,     6,     0,     1,     1,     0,     4,
       4,     3,     5,     1,     3,     3,     5,     1,     3,     2,
       1,     1,     0,     6,     1,     3,     3,     0,     2,     0,
       4,     0,     2,     1,     2,     4,     2,     3,     0,     3,
       0,     0,     6,     2,     1,     1,     2,     2,     8,     4,
       0,     1,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     2,     4,     3,     1,     1,
       4,     0,     0,     1,     1,     0,     2,     2,     1,     1,
       0,     2,     3,     3,     3,     2,     3,     4,     3,     4,
       3,     4,     1,     3,     4,     3,     3,     6,     1,     5,
       6,     5,     7,     6,     8,     5,     6,     4,     4,     5,
       3,     4,     1,     3,     3,     3,     3,     3,     3,     4,
       4,     3,     3,     3,     3,     3,     3,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     1,     3,     1,     1,     1,
       1,     3,     2,     2,     2,     2,     3,     3,     5,     6,
       4,     4,     7,     4,     2,     6,     5,     6,     6,     4,
       4,     3,     4,     6,     8,     6,     8,     6,     4,     6,
       4,     6,     4,     4,     4,     4,     6,     8,     2,     2,
       4,     2,     7,     7,     3,     4,     4,     6,     6,     4,
       6,     6,     6,     4,     6,     4,     6,     8,    10,    12,
       6,     4,     6,     6,     1,     6,     4,     8,    10,     4,
       1,     3,     4,     6,     6,     8,     6,     6,     4,     6,
       6,     8,     4,     4,     6,     4,     2,     4,     4,     4,
       6,     4,     4,     3,     8,     6,     4,     6,     3,     6,
       8,     4,     8,     6,     8,     6,     8,     2,     4,     4,
       4,     6,     8,     8,     4,     7,     7,     7,     6,     6,
       6,     6,     6,     6,     0,     5,    10,     3,     4,     3,
       2,     2,     2,     4,     6,     4,     4,     6,     6,     6,
       6,     4,     6,     4,     6,     4,     4,     4,     4,     6,
       4,     6,     4,     6,     4,     4,     6,     4,     6,     4,
       6,     4,     4,     6,     4,     6,     0,     3,     3,     0,
       1,     0,     2,     1,     3,     4,     4,     5,     4,     4,
       4,     5,     4,     0,     0,     7,    10,     4,     5,     4,
       5,     4,     4,     4,     4,     4,     5,     0,     8,     0,
       3,     3,     1,     4,     0,     1,     0,     2,     0,     1,
       0,     3,     2,     3,     2,     1,     2,     1,     2,     1,
       1,     1,     2,     0,     1,     0,     2,     1,     3,     1,
       3,     0,     2,     1,     3,     0,     1,     0,     2,     4,
       5,     1,     1,     1,     1,     3,     3,     3,     0,     6,
       0,     6,     0,     8,     4,     0,     8,     0,    10,     6,
       0,     8,     0,    10,     6,     1,     2,     2,     0,     4,
       0,    11,     3,     6,     0,     3,     0,     0,     5,     0,
       1,     0,     1,     0,     2,     0,     2,     2,     2,     0,
       6,     0,     1,     3,     1,     1,     1,     3,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     1,     1,     0,     2,     0,
       1,     0,     0,     3,     0,     0,     3,     2,     0,     0,
       4,     4,     2,     0,     2,     2,     3,     3,     1,     2,
       0,     1,     0,     4,     4,     2,     0,     1,     1,     0,
       1,     0,     1,     2,     1,     3,     3,     1,     1,     1,
       1,     0,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     0,     6,     0,     1,     3,
       1,     2,     0,     2,     3,     1,     2,     1,     0,     3,
       0,     5,     2,     1,     0,     3,     6,     0,     6,     4,
       4,     4,     4,     5,     4,     1,     3,     1,     1,     3,
       1,     0,     2,     0,     1,     0,     0,     8,     0,     0,
       6,     0,     1,     1,     1,     1,     1,     2,     1,     1,
       1,     3,     4,     0,     3,     3,     1,     2,     2,     0,
       3,     0,     5,     3,     1,     3,     1,     3,     1,     1,
       0,     1,     0,     4,     0,     1,     3,     1,     1,     1,
       0,     0,     6,     0,     0,    11,     3,     1,     3,     3,
       1,     3,     0,     1,     0,     4,     0,     6,     0,     5,
       0,     6,     1,     3,     3,     5,     0,     2,     0,     2,
       1,     1,     1,     3,     0,     1,     0,     1,     1,     3,
       1,     1,     2,     2,     2,     1,     1,     1,     1,     0,
       3,     0,     3,     2,     4,     4,     4,     4,     0,     4,
       6,    16,     2,     2,     0,     6,     5,     2,     2,     2,
       1,     5,     5,     2,     2,     1,     4,     3,     2,     2,
       2,     3,     2,     2,     2,     1,     1,     3,     4,     3,
       3,     2,     2,     3,     3,     3,     3,     3,     3,     1,
       1,     1,     1,     0,     1,     0,     2,     0,     1,     1,
       1,     0,     2,     0,     2,     0,     2,     2,     0,     4,
       0,     4,     1,     1,     0,     1,     0,     1,     1,     0,
       4,     3,     1,     0,     3,     4,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     0,     1,     0,     3,     3,
       1,     1,     1,     2,     0,     3,     3,     2,     2,     0,
       4,     0,     1,     1,     2,     0,     4,     5,     0,     0,
       0,     0,    18,     2,     0,     1,     0,     1,     1,     0,
       1,     1,     0,     2,     2,     1,     3,     4,     3,     3,
       0,     2,     2,     1,     3,     3,     0,     3,     0,     3,
       2,     3,     1,     1,     2,     0,     2,     1,     1,     2,
       2,     1,     1,     1,     1,     1,     2,     2,     1,     1,
       1,     1,     1,     1,     1,     2,     2,     2,     2,     2,
       1,     1,     1,     1,     1,     1,     1,     3,     5,     1,
       1,     1,     1,     1,     3,     4,     5,     1,     5,     3,
       2,     1,     3,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     3,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     0,     4,     0,     1,     1,     3,     0,
       2,     1,     1,     1,     1,     0,     1,     0,     1,     1,
       1,     0,     2,     2,     2,     1,     2,     4,     5,     4,
       6,     2,     3,     3,     3,     5,     1,     3,     3,     2,
       2,     2,     1,     1,     4,     4,     1,     1,     1,     1,
       1,     0,     4,     1,     1,     1,     3,     3,     1,     1,
       2,     2,     0,     3,     4,     3,     0,     7,     1,     2,
       1,     1,     1,     1,     1,     1,     0,     5,     1,     1,
       1,     1,     1,     3,     6,     6,     6,     7,     3,     8,
       8,     8,     0,     1,     1,     2,     0,     1,     1,     3,
       0,     3,     0,     3,     0,     3,     0,     3,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       2,     1,     3,     2,     2,     2,     2,     2,     2,     2,
       2,     0,     1,     3,     1,     2,     2,     2,     1,     3,
       3,     1,     1,     3,     1,     3,     4,     5,     1,     0,
       3,     3,     1,     1,     0,     2,     2,     2,     2,     0,
       2,     2,     1,     2,     2,     2,     2,     2,     0,     3,
       0,     1,     0,     3,     2,     0,     1,     2,     0,     1,
       4,     4,     5,     2,     3,     0,     1,     0,     4,     0,
       1,     1,     0,     2,     2,     1,     0,     1,     1,     4,
       0,     7,     1,     0,     0,     2,     3,     1,     1,     1,
       0,     3,     1,     2,     1,     2,     3,     3,     3,     0,
       1,     0,     3,     3,     0,     8,     0,     3,     1,     3,
       0,     2,     3,     5,     0,     3,     4,     4,     0,    14,
       0,     6,     0,     0,     0,     0,    12,     4,     4,     3,
       4,     3,     2,     1,     3,     5,     1,     1,     0,     1,
       1,     0,     2,     0,     0,     3,     0,     2
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short int yydefact[] =
{
       0,     2,  1999,   635,     0,  1948,     0,     0,     0,     0,
       0,  1950,    94,    54,  1264,  1372,  1373,  1184,  1203,     0,
     635,    97,     0,    66,  1205,  1409,     0,     0,   635,     0,
    1404,     0,     0,   635,  1208,  1397,     0,    97,  1950,     0,
     670,  1785,  1301,     0,     0,     0,  1284,  1842,  1253,     0,
       0,     0,     0,     0,     4,    15,     0,    32,    20,    24,
      10,    14,     9,     6,    46,    47,    39,     8,    12,    36,
       7,    11,    29,    35,    30,    31,    43,   663,    18,    19,
      25,    37,    50,    16,    48,    45,    17,  1374,    21,    38,
      33,    26,    51,    27,    44,    28,    49,    23,    40,    22,
       5,    13,    41,    42,    34,    52,     0,   538,     0,   570,
       0,     0,  2000,  1990,   637,   636,     0,  1834,  1833,   603,
    1950,     0,  1557,  1558,  1559,  1560,  1561,  1562,  1563,  1521,
    1564,  1565,  1566,  1522,  1523,  1567,  1568,  1569,  1570,  1572,
    1571,  1573,  1524,  1525,  1574,  1575,  1576,  1526,  1527,  1577,
    1578,  1528,  1579,  1580,  1581,  1529,  1582,  1530,  1583,  1584,
    1585,  1586,  1587,  1531,  1588,  1589,  1590,  1591,  1592,  1593,
    1594,  1532,  1595,  1596,  1597,  1598,  1614,  1599,  1533,  1600,
    1601,  1602,  1615,  1534,  1605,  1604,  1603,  1606,  1607,  1608,
    1535,  1609,  1610,  1611,  1612,  1617,  1618,  1619,  1536,  1613,
    1620,  1616,  1768,  1622,  1621,  1623,  1625,  1624,  1537,  1626,
    1538,  1627,  1628,  1505,  1629,  1506,  1631,  1632,  1635,  1636,
    1630,  1637,  1638,  1633,  1634,  1539,  1640,  1641,  1642,  1643,
    1644,  1645,  1646,  1656,  1649,  1651,  1652,  1654,  1650,  1655,
    1659,  1658,  1660,  1661,  1662,  1657,  1648,  1653,  1663,  1664,
    1647,  1665,  1666,  1667,  1668,  1669,  1670,  1671,  1672,  1673,
    1675,  1674,  1676,  1677,  1678,  1679,  1680,  1682,  1681,  1683,
    1684,  1685,  1687,  1686,  1688,  1540,  1689,  1690,  1691,  1692,
    1693,  1541,  1694,  1695,  1696,  1697,  1698,  1699,  1700,  1542,
    1701,  1702,  1703,  1704,  1705,  1706,  1707,  1708,  1709,  1710,
    1711,  1712,  1713,  1714,  1715,  1716,  1717,  1718,  1639,  1719,
    1543,  1720,  1721,  1544,  1722,  1545,  1723,  1724,  1546,  1725,
    1726,  1727,  1728,  1729,  1730,  1547,  1731,  1548,  1733,  1732,
    1734,  1736,  1737,  1549,  1735,  1550,  1738,  1739,  1740,  1742,
    1741,  1743,  1744,  1551,  1745,  1552,  1746,  1747,  1748,  1749,
    1750,  1751,  1752,  1753,  1754,  1755,  1756,  1757,  1758,  1761,
    1762,  1763,  1764,  1759,  1760,  1553,  1765,  1766,  1767,  1769,
    1770,  1554,  1771,  1772,  1556,  1773,  1774,  1777,  1775,  1776,
    1778,  1779,  1780,  1781,  1555,  1782,   123,  1510,    99,  1511,
    1520,     0,   605,   621,  1951,  1952,   270,   510,   511,   269,
     509,    97,  1990,     0,   266,   267,     0,  1278,  1005,  1201,
    1201,     0,  1201,  1204,  1201,    97,  1201,     0,    59,  1379,
       0,     0,     0,     0,  1504,     0,  1211,  1411,  1415,     0,
       0,  1831,     0,     0,     0,     0,    97,   638,     0,  1262,
       0,   601,     0,  1952,  1963,   664,   668,   680,  1786,  1783,
    1357,   590,   590,   590,   588,   590,  1285,     0,     0,  1262,
    1414,  2036,     0,     0,     0,  2032,     0,  2037,     0,   670,
       0,     0,     1,     3,     0,  1610,  1370,  1368,  1501,     0,
     530,   539,   534,   532,     0,     0,  2001,   619,     0,  1949,
       0,   647,   657,   125,     0,    68,     0,     0,     0,  1955,
       0,     0,     0,     0,    95,   319,  1990,  1992,  1994,   270,
     268,     0,  1282,  1281,  1280,     0,  1278,  1185,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1201,    61,     0,
    1876,  1891,  1892,  1888,  1893,  1894,  1898,     0,  1890,  1882,
       0,  1897,  1886,  1895,     0,  1880,     0,  1896,  1901,  1884,
    1889,  1868,     0,  1874,  1878,  1503,  1104,  1845,  1846,     0,
    1516,  1507,  1515,  1514,    67,  1213,  1214,  1212,   569,  1412,
    1413,     0,  1426,     0,     0,     0,   633,     0,  1352,  1351,
       0,  1405,  1964,     0,     0,   610,  1216,  1263,     0,  1215,
    1402,     0,  1401,  1398,  1400,     0,  1876,  1863,     0,  1958,
    1955,  1965,   693,   686,   685,   688,   689,   692,   690,   691,
     687,   684,   701,   681,   683,  1789,     0,     0,   444,     0,
    1365,     0,     0,     0,  1365,     0,  1139,  1358,     0,  1798,
    1336,   507,   506,     0,   505,  1799,  1335,  1351,     0,     0,
       0,  1320,     0,  1286,  1325,  1800,     0,  1354,     0,  1139,
    1365,     0,  1302,     0,     0,     0,     0,   584,   594,   586,
     581,     0,   587,   583,  1283,  1197,  1843,   569,  1463,  1462,
    1508,  2033,  1461,  2041,  2043,  2029,  2031,  2038,   666,     0,
    1969,    53,     0,  1376,  1997,  1998,  1996,   460,   107,   107,
     528,     0,     0,     0,     0,     0,  1195,     0,     0,   649,
     659,   127,   124,    98,     0,   607,   623,  1954,     0,     0,
    1956,  1960,   763,   762,     0,    92,   710,  1517,  1928,    96,
    1924,  1995,   320,   701,   701,   701,  1985,     0,  1987,  1988,
    1989,  2001,  1993,     0,   512,     0,  1265,  1268,  1272,  1276,
    1279,  1558,  1521,     0,  1566,     0,     0,  1474,     0,     0,
       0,     0,  1526,     0,     0,  1580,     0,     0,  1531,     0,
       0,     0,   710,   710,   710,     0,     0,     0,  1593,  1594,
    1483,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1471,     0,  1484,     0,     0,     0,     0,     0,     0,
       0,  1622,     0,     0,  1623,     0,     0,     0,  1473,  1628,
       0,     0,     0,     0,     0,     0,     0,  1643,     0,     0,
    1481,     0,     0,  1011,     0,  1670,  1672,     0,     0,     0,
    1676,     0,     0,  1677,  1678,  1679,  1458,   765,     0,   710,
    1470,  1480,  1691,  1697,  1464,     0,  1699,     0,  1700,     0,
    1707,     0,     0,     0,     0,     0,     0,  1729,  1731,     0,
       0,  1748,     0,     0,     0,   710,  1457,  1761,  1762,  1763,
    1764,     0,  1472,  1553,  1482,     0,     0,     0,  1773,   710,
     710,   710,     0,     0,     0,  1779,     0,  1782,  1015,     0,
       0,     0,     0,   764,     0,   979,     0,  1007,   722,   728,
     742,     0,   850,   757,   844,   780,   779,  1006,  1468,   778,
     777,  1469,   775,  1491,  1510,  1490,  1202,  1189,  1190,     0,
    1191,  1194,  1922,  1192,   571,     0,     0,    60,  1393,  1387,
    1389,  1392,  1388,     0,  1394,  1391,  1390,  1834,  1380,  1382,
    1383,  1877,  1875,  1909,  1908,     0,  1910,  1906,  1899,  1929,
    1903,  1929,  1905,  1904,  1929,  1900,  1907,  1929,  1872,     0,
    1105,  1106,     0,  1844,     0,  1502,     0,  1410,  1427,     0,
    1428,  1416,  1424,   652,     0,  1104,  1832,  1835,     0,     0,
      56,    57,     0,   640,     0,   639,   643,     0,     0,     0,
    1219,  1209,  1218,  1403,     0,     0,  1875,  1872,  1959,     0,
    1961,  1976,   669,  1966,   699,   671,   698,     0,   682,  1784,
    1787,  1795,  1334,  1361,   443,     0,     0,  1333,  1317,     0,
     270,     0,     0,     0,     0,  1303,  1308,   304,     0,  1324,
    1140,     0,  1365,     0,  1328,  1341,  1329,     0,  1355,     0,
    1365,  1298,     0,     0,  1290,  1295,  1291,     0,  1297,  1296,
    1299,  1287,  1288,  1313,  1342,  1355,  1318,  1323,  1332,  1359,
    1360,     0,  1312,  1319,     0,  1330,  1355,  1355,  1365,  1365,
     597,   596,   595,   591,   592,   597,     0,  1048,     0,     0,
    2030,  2044,  2028,  2039,  2040,  2027,   667,  1970,   665,  1971,
       0,  1371,  1369,  1377,  1378,   461,   460,   261,   264,   263,
       0,   535,   533,   460,  1991,     0,     0,   623,     0,     0,
     651,   646,   650,   648,   502,   501,   504,     0,   658,     0,
     128,   130,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    69,    70,    83,
     609,   608,   606,   631,   630,   628,     0,   629,   627,   622,
     624,   625,  1953,  1957,   271,   460,     0,  1519,     0,     0,
       0,     0,     0,     0,     0,  1986,    88,     0,     0,     0,
    1270,  1198,  1266,     0,     0,     0,  1104,     0,     0,     0,
    1109,     0,   794,  1109,  1109,  1109,     0,     0,  1005,  1005,
       0,  1005,     0,     0,     0,     0,  1109,   818,   821,     0,
     819,     0,     0,     0,     0,     0,  1477,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1005,     0,     0,     0,
       0,   984,     0,     0,     0,     0,   774,     0,     0,     0,
       0,  1005,     0,     0,     0,     0,  1011,     0,  1009,     0,
    1109,     0,     0,  1109,     0,     0,     0,     0,     0,  1005,
    1005,  1005,   715,     0,   866,     0,     0,     0,     0,     0,
    1005,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1109,  1109,     0,     0,     0,  1109,     0,   887,     0,
    1479,     0,     0,     0,  1478,     0,     0,  1476,  1475,  1459,
       0,     0,     0,   910,   912,   911,  1109,     0,  1109,     0,
       0,     0,  1016,     0,   783,   782,   784,  1983,     0,     0,
       0,     0,     0,     0,   761,   760,   759,   758,     0,     0,
       0,   766,     0,   767,   768,     0,   769,   770,   771,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   785,  1079,
    1080,  1081,  1082,  1091,  1094,  1083,  1084,  1085,  1093,  1086,
    1087,  1088,  1095,  1096,  1097,  1089,  1098,  1092,  1090,  1099,
       0,  1078,     0,     0,     0,  1460,   904,     0,  1187,     0,
     573,   572,  1193,   571,     0,    62,    64,  1386,     0,     0,
    1395,  1902,     0,  1883,  1887,  1881,  1885,     0,     0,  1873,
       0,  1879,  1108,  1618,  1686,     0,  1111,  1848,  1206,  1423,
    1425,     0,     0,  1417,     0,     0,   623,    58,     0,     0,
    1406,     0,     0,     0,     0,   612,  1217,     0,  1399,     0,
       0,     0,     0,     0,  1962,  1978,  1977,  1967,   701,  1130,
     702,   704,   703,  1490,  1789,  1792,  1793,  1796,  1794,     0,
    1791,  1790,  1805,     0,  1363,  1366,  1367,     0,     0,  1344,
    1343,  1339,  1340,     0,  1149,  1150,  1148,  1143,  1144,  1147,
    1348,  1346,  1337,     0,  1365,     0,  1347,  1345,  1292,  1293,
    1294,     0,  1139,     0,  1365,  1355,     0,  1365,  1365,  1327,
    1331,     0,   585,   594,   582,   589,  1060,  1059,     0,  1024,
       0,  1023,  1022,  1021,     0,  1059,  2034,  2042,  2046,     0,
    1139,  1975,  1973,   262,  1240,  1240,     0,     0,     0,     0,
       0,     0,     0,   108,   117,   567,   567,  1240,  1240,   567,
    1240,  1240,  1240,     0,     0,  1240,     0,     0,   567,     0,
    1240,   565,     0,     0,  1240,  1240,  1240,   567,     0,  1240,
    1240,  1240,  1240,  1240,   577,  1240,  1240,  1240,   564,   274,
     296,   297,   529,     0,   543,   566,  2002,  2003,   536,   620,
     604,  1196,     0,   126,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   632,   626,    93,   460,   711,  1518,     0,  1925,  2022,
       0,     0,  2004,   272,   515,   517,   516,   514,   513,     0,
       0,     0,  1111,  1273,  1048,  1277,  1276,  1274,     0,     0,
       0,  1110,  1109,     0,   990,  1157,  1158,  1154,  1155,  1153,
    1156,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   963,     0,   990,     0,   824,
       0,     0,     0,     0,     0,     0,  1490,     0,     0,     0,
       0,     0,  1983,     0,     0,     0,     0,     0,     0,   801,
       0,     0,     0,     0,     0,     0,     0,  1102,  1100,  1103,
    1101,     0,     0,   985,   977,     0,     0,     0,     0,   851,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1012,  1013,  1109,     0,     0,     0,  1109,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   873,     0,     0,     0,
       0,     0,   878,     0,     0,     0,     0,     0,     0,     0,
    1109,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   907,     0,   909,     0,     0,  1493,  1492,
       0,     0,     0,     0,     0,  1017,   670,     0,   787,  1005,
     786,     0,  1801,   980,   982,     0,   713,   712,   714,   725,
     718,   723,   716,   720,     0,   772,  1563,   726,     0,   754,
       0,  1118,   755,   740,   745,   746,     0,     0,   743,   744,
     748,   850,   747,   850,   751,   752,   753,   756,     0,     0,
       0,     0,     0,   776,   781,  1008,   951,  1494,  1188,  1923,
    1186,    65,     0,     0,  1381,  1396,  1384,  1933,     0,  1932,
    1918,  1921,  1501,     0,     0,     0,  1858,  1852,  1859,  1861,
    1855,  1860,  1862,  1853,  1854,  1849,  1856,  1112,  1141,     0,
       0,   653,   654,   657,     0,  1838,  1839,  1837,  1836,   634,
    1408,  1407,     0,   641,   644,   645,   617,   616,   618,   611,
     613,   614,   254,  1223,     0,     0,     0,  1229,  1210,  1220,
     602,     0,     0,     0,     0,     0,   697,  1048,  1178,   694,
     675,  1141,  1131,   674,   705,     0,  1788,     0,  1759,  1816,
       0,     0,     0,     0,     0,  1806,  1362,     0,  1314,     0,
    1338,  1350,  1349,  1309,     0,     0,     0,  1307,  1356,     0,
    1326,  1289,  1306,  1111,  1355,  1304,  1305,   599,   598,   593,
    1059,  1048,     0,     0,  1045,  1061,     0,  1061,  1048,  1048,
       0,  1048,  1104,  1056,     0,     0,  2045,  1132,  1974,  1238,
    1239,  1241,     0,     0,   111,   114,   112,     0,   113,     0,
       0,   568,   522,   503,   503,   547,     0,   336,   522,   496,
     545,     0,     0,     0,     0,     0,     0,     0,     0,  1240,
       0,   558,   541,     0,     0,     0,     0,   559,     0,   542,
    1240,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   580,   579,   578,     0,     0,     0,     0,   275,   460,
     339,     0,   574,   336,   342,  1497,  2006,  1075,     0,  1074,
     129,    76,    72,    84,  1162,  1163,  1161,  1159,  1160,    85,
      74,    75,    79,    78,    80,    81,    82,    77,    73,    86,
      87,    71,     0,  1926,     0,   238,   237,     0,  2020,  2006,
       0,   339,    89,  1429,   273,   276,    90,  1199,  1200,  1048,
    1130,  1111,     0,  1104,     0,   793,   808,     0,     0,   956,
       0,     0,   958,   959,   960,     0,   812,     0,   810,   813,
     814,   815,  1005,     0,     0,     0,     0,  1005,   962,     0,
     820,     0,     0,   825,   826,     0,   799,     0,   833,     0,
     835,     0,  1005,     0,   829,     0,   790,     0,     0,  1005,
       0,   841,     0,   802,     0,     0,   942,     0,   925,   921,
       0,   923,     0,     0,  1005,  1005,     0,   846,     0,     0,
     852,  1005,     0,   944,     0,   926,     0,   858,     0,  1005,
       0,  1010,     0,     0,     0,   969,   862,   863,     0,   967,
     928,     0,     0,   865,   930,     0,   932,     0,   927,   934,
     935,   867,   869,   868,   937,     0,     0,   939,     0,   941,
       0,   871,   872,     0,     0,     0,   876,     0,  1005,   881,
     971,   973,     0,     0,     0,     0,     0,   975,   888,   890,
       0,     0,     0,   889,     0,     0,     0,     0,     0,     0,
       0,   894,     0,     0,   908,   974,   800,   972,   913,     0,
     916,     0,   915,     0,     0,     0,     0,  1982,  1984,     0,
       0,   791,     0,     0,     0,     0,     0,  1495,   719,   724,
     717,   721,     0,     0,     0,     0,   738,   737,     0,   750,
     749,     0,  1118,   741,     0,   849,     0,   950,   701,  1005,
       0,    63,  1385,  1930,     0,     0,     0,     0,     0,     0,
       0,     0,  1847,  1142,  1250,  1509,  1418,     0,   661,  1840,
    1841,     0,   615,   680,     0,  1242,  1227,  1234,  1228,     0,
       0,     0,  1226,  1486,  1485,  1492,  1965,     0,     0,     0,
       0,  1968,  1111,  1111,  1172,     0,     0,   672,   677,   673,
     676,     0,   700,   709,   708,  1487,  1494,     0,     0,     0,
       0,   446,   448,   447,   456,     0,   445,     0,     0,  1801,
       0,   452,   454,   453,  1811,   451,  1364,  1139,  1322,  1321,
    1146,  1145,     0,  1300,  1316,  1365,     0,  1972,  1054,     0,
    1047,  1046,  1062,     0,  1048,  1061,  1061,     0,  1027,  1026,
    1254,  1257,     0,  1025,  1065,  1052,   680,  2035,  2047,     0,
     459,   458,   303,   455,   302,   116,   115,   121,   122,   341,
     523,   497,   498,     0,     0,     0,   503,   335,   522,   334,
     337,   512,     0,   286,   283,   549,   289,   285,   301,     0,
       0,   290,   522,   556,   557,   571,   279,     0,   315,   316,
     314,   298,   281,   282,   551,  1126,  1128,  1136,   288,   287,
     284,   293,   294,   312,   311,   292,   313,   562,   310,   308,
     305,   307,   306,   309,   291,   280,     0,   544,     0,   325,
     327,   328,  1500,     0,   576,   546,     0,   329,   330,     0,
       0,     0,     0,   660,     0,  1927,  2023,   241,   239,   240,
       0,     0,     0,   244,     0,   242,     0,     0,  1431,  1430,
     243,   257,   460,   277,     0,  1111,  1151,  1269,  1275,     0,
       0,     0,   957,   991,     0,   422,   422,  1001,   999,   411,
     422,   995,  1000,   997,     0,     0,     0,     0,     0,     0,
       0,   964,   961,     0,     0,     0,  1494,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   988,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   946,  1014,   970,   968,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   976,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1018,   796,  1979,  1980,   788,  1802,
    1803,  1804,   524,   981,     0,   731,  1005,   729,  1117,   735,
       0,     0,   739,     0,   905,     0,   952,   953,     0,  1004,
    1496,  1931,  1920,  1919,  1934,  1934,  1934,     0,  1113,     0,
    1207,  1429,   655,     0,   656,   642,   701,  1224,  1236,     0,
    1244,     0,     0,  1221,  1231,     0,     0,     0,  1230,     0,
    1865,  1866,  1864,  1141,  1119,     0,     0,  1183,     0,  1179,
     695,     0,   707,   706,     0,  1818,     0,  1817,  1829,  1830,
    1827,  1828,  1826,  1807,     0,  1813,  1812,     0,     0,     0,
    1823,  1814,     0,     0,  1315,     0,  1310,   600,     0,  1048,
    1061,  1048,  1034,     0,     0,  1048,  1030,  1028,  1032,     0,
    1111,     0,     0,     0,     0,  1049,   701,  1489,  1133,  1136,
     338,   522,   499,   500,   512,     0,     0,     0,     0,   456,
     299,   555,   554,   300,     0,     0,  1137,  1138,  1129,     0,
     548,   339,   575,   476,   407,   356,   347,   422,   350,   349,
     393,   364,   361,   411,   409,   379,   411,   411,   386,   385,
     403,   389,   369,   462,   462,   368,   406,   462,   390,   388,
     392,     0,   394,   411,   399,   387,   391,   408,   384,   381,
     405,   422,   422,   362,   365,   404,   462,     0,   397,   422,
     426,   367,   462,   468,     0,     0,   422,   424,  1499,  2008,
       0,  2010,  1073,   142,   701,     0,   101,  2021,  2010,     0,
     247,   272,   258,     0,   278,     0,  1271,     0,  1267,   774,
     805,   809,   918,     0,   992,   462,     0,  1002,   413,   994,
     996,   998,   795,   811,   816,   920,   798,   797,     0,     0,
       0,     0,   831,   834,   836,   827,   832,   830,     0,   919,
     843,   840,   842,   803,     0,   943,   922,   924,   845,   856,
     986,   989,     0,     0,     0,   857,   853,   945,   854,     0,
     859,   828,   860,     0,     0,     0,     0,   929,   864,   931,
     933,   938,   936,   940,   870,   807,     0,   875,   877,   789,
     774,   879,     0,   885,   883,     0,     0,   891,     0,     0,
     900,     0,   898,     0,   899,     0,   901,   902,     0,   914,
     917,  1019,     0,  1965,     0,   983,   727,     0,   733,  1005,
     730,   736,   702,   701,   903,     0,  1939,  1939,  1939,  1249,
    1248,     0,  1247,  1251,     0,   662,   255,     0,     0,     0,
    1245,  1233,  1969,  1222,  1225,  1494,  1867,   679,     0,  1114,
    1182,  1180,     0,  1173,  1175,  1177,     0,  1488,     0,     0,
    1822,  1808,   457,     0,     0,     0,     0,  1809,     0,  1104,
    1055,     0,     0,  1021,  1048,  1048,     0,  1021,     0,     0,
       0,  1256,  1130,  1258,  1063,  1067,  1068,  1066,  1057,     0,
    1135,     0,     0,     0,   561,     0,   574,   563,   426,  1127,
     295,   326,   482,     0,     0,   366,   415,   410,     0,   415,
     415,   468,   470,   464,   468,     0,   375,   393,   370,     0,
     462,   383,   374,   395,   398,   400,   402,   415,     0,   462,
     363,   372,     0,   415,   434,     0,     0,     0,   430,     0,
     475,     0,   437,   343,   427,   429,     0,     0,   396,     0,
     352,   469,     0,   354,     0,     0,   415,     0,   425,   415,
       0,  2007,     0,  2014,     0,   145,   143,   144,     0,   138,
     140,   135,     0,   323,   324,   322,   321,     0,   131,  2014,
     245,  1969,  1429,     0,   250,     0,  1136,   520,  1152,     0,
       0,   993,     0,     0,   965,   822,   823,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   792,     0,
       0,     0,     0,     0,     0,     0,   897,   895,   896,     0,
    1020,  1984,   525,   732,     0,   705,   954,     0,     0,  1938,
    1936,     0,  1937,  1935,  1911,     0,  1870,  1871,  1869,  1857,
       0,     0,  1419,  1141,  1235,  1237,  1243,  1232,     0,  1115,
    1130,  1432,  1176,     0,   696,  1820,  1819,  1821,  1815,     0,
       0,     0,     0,  1053,  1048,  1035,     0,  1039,  1044,  1040,
       0,  1031,  1029,     0,  1151,     0,  1069,  1141,  1136,     0,
       0,     0,     0,     0,     0,     0,     0,   560,  1465,   550,
     552,     0,     0,     0,   477,   478,   483,   485,     0,     0,
     419,   420,   421,   376,   416,   418,     0,   378,   346,   463,
     471,   472,     0,   467,   465,   468,   371,   401,   377,     0,
     373,     0,   360,   440,   439,   710,   432,   442,     0,     0,
     438,   428,   436,   431,     0,     0,     0,     0,   344,     0,
     345,  1498,  2009,     0,   537,   701,   701,  2011,  2024,   142,
       0,     0,     0,     0,   132,   134,   135,  2005,   248,   246,
       0,  1965,    91,     0,   519,     0,   806,   423,   412,     0,
     817,   837,     0,   804,   987,   978,  1109,   847,     0,   855,
     861,   948,   947,   874,   880,   884,   882,   886,   892,   893,
    1005,  1981,   734,   955,  1917,  1916,  1915,  1912,     0,     0,
       0,     0,     0,     0,  1940,  1942,  1246,     0,     0,   256,
     694,   317,  1123,  1136,     0,  1141,     0,  1440,  1174,  1825,
    1824,  1810,     0,     0,     0,     0,     0,     0,     0,  1076,
    1255,  1064,     0,  1058,  1134,     0,     0,   331,  1467,  1466,
     574,   488,   489,   490,     0,     0,     0,   481,   484,   355,
     348,   417,     0,   526,   473,   466,     0,   359,   441,   710,
     435,   462,   468,   462,   468,     0,     0,     0,   670,     0,
     109,   139,     0,   701,   100,   102,     0,     0,   252,   251,
    1136,     0,     0,     0,     0,     0,     0,  1913,  1943,  1946,
    1944,  1945,  1947,  1941,     0,     0,   318,     0,     0,  1120,
    1122,  1116,  1164,     0,     0,     0,     0,  1433,  1435,     0,
    1181,     0,  1050,  1036,     0,  1041,     0,  1033,     0,  1071,
       0,   332,   553,   492,     0,   491,     0,   486,   487,   482,
       0,   462,     0,   462,   433,   351,   353,   357,   358,     0,
    2015,     0,  2012,     0,  2025,   141,     0,     0,   133,   136,
    1969,   518,   521,   414,   838,     0,   966,   848,   906,  1252,
    1260,     0,  1420,  1124,  1125,  1136,     0,   678,     0,     0,
       0,     0,  1434,     0,     0,  1441,  1443,     0,     0,     0,
       0,  1077,     0,  1072,   333,   494,   495,   493,   479,   480,
     380,   527,   382,  2016,  2017,  1969,   119,   118,   110,     0,
     178,     0,   103,   253,     0,     0,     0,   449,  1121,  1165,
    1438,  1439,     0,  1436,     0,     0,  1442,     0,     0,  1038,
    1043,  1070,  2013,   120,     0,   194,   182,     0,     0,     0,
     180,   208,  2026,     0,     0,   184,   206,   207,   185,  1512,
       0,  1513,  2018,     0,   839,  1259,  1261,     0,  1421,     0,
    1437,  1445,  1444,     0,  1051,   193,   196,     0,     0,   199,
     189,   188,   190,     0,     0,     0,   179,   229,   178,   178,
     232,   187,   225,   178,   104,   450,  1432,   701,     0,   195,
       0,     0,     0,   181,   209,   220,   223,   215,   150,   178,
       0,   178,     0,     0,  2019,   109,  1440,     0,     0,  1168,
    1170,     0,   191,     0,     0,     0,     0,   178,   216,     0,
     146,     0,     0,   148,   235,     0,   227,   105,  1446,  1171,
    1166,   701,  1311,     0,   183,   200,   217,   223,   213,   221,
     178,     0,     0,   178,     0,   231,   149,     0,   233,   226,
     228,   178,     0,  1448,  1169,   192,   197,   178,     0,   214,
       0,     0,   212,   161,   160,     0,   152,   174,   230,     0,
     151,     0,   178,   106,     0,     0,  1455,     0,   178,   218,
       0,   178,     0,     0,     0,     0,     0,   147,     0,   178,
    1447,  1450,     0,     0,  1452,  1453,     0,  1422,   198,   203,
       0,   210,   178,   155,   175,   176,     0,   158,   236,     0,
    1454,  1449,     0,  1456,   199,   178,   202,   178,     0,     0,
     153,   167,   154,   165,   157,     0,   234,  1451,   204,   178,
     178,   173,   171,   178,   162,   169,   164,     0,   170,   177,
     168,     0,   159,     0,   156,   172,   166,   163
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short int yydefgoto[] =
{
      -1,    52,    53,    54,    55,    56,    57,   970,    58,   528,
     917,  1385,  1386,    59,   425,    60,   704,  1127,  1128,  1129,
      61,  1603,  2464,  1145,   402,   420,   386,  2767,  3038,  3407,
    3503,  3555,  3601,  1091,  3404,  1523,  3458,  1524,    62,   493,
     702,  1109,  1110,  3213,  3214,  3210,  3215,  3028,  3029,  3030,
    3031,  3593,  3549,  3570,  3594,  3634,  3668,  3674,  3675,  3615,
    3683,  3684,  3685,  3691,  3686,  3616,  3670,  3550,  3493,  3523,
    3519,  3494,  3583,  3518,  3605,  3541,  3542,  3607,  3649,  3666,
    3495,  3496,  3524,  3565,  3497,  3525,  3587,  3546,  3588,  3608,
    3650,  3547,  3566,  3611,  3569,  3498,  3553,  3599,  3531,  3548,
    3552,  3622,  3597,  2047,  2450,  2052,  2455,  3041,  2460,  3221,
    3410,  1877,  2273,  3103,  2773,  1593,  1086,  1087,   403,   404,
     405,   501,  2053,  1558,  2054,  2055,  1560,  1561,  1016,  2424,
    2415,  2401,  3269,   725,  3037,  2428,  2429,  2430,  2431,  2379,
    2380,  1966,  1967,  2013,  2439,  2750,  2968,  2988,  2751,  2752,
    2753,  2754,  2755,  2756,  2757,  2787,  2788,  3163,  3164,  3165,
    2784,  3019,  3003,  3004,  3005,  3186,  2975,  2313,  2314,  3508,
    2323,  2324,  2361,  2645,  2362,  1090,  2976,  3013,  3173,  3006,
    2438,  2962,  3154,  3306,  3155,  3156,  3157,  3387,  1968,  2378,
    1106,  1107,   651,   406,  1159,  1607,  3045,  3046,  2369,  2875,
    3312,    63,  1093,   687,   689,   688,  2016,   480,  1562,  1563,
    1564,  2688,  2694,  3300,  1970,   111,  1382,  2435,  2004,    64,
    1065,  1060,    65,   662,   657,   658,  1063,  1064,  1492,  1928,
      66,   595,    67,   488,    68,   496,  1132,    69,   978,  1869,
    1870,  1871,    70,   694,    71,   497,  1139,  1140,  1141,    72,
     968,   116,    73,   584,   973,   975,   976,    74,   490,   491,
    1101,    75,  1412,  1851,  1852,   699,   700,  1108,  2604,    76,
      77,   471,   445,   601,   446,   447,  1439,  1889,  3270,   612,
     613,   614,  2297,   995,   996,   997,  1894,  1440,  2302,  1147,
    2890,   888,   889,   890,  1319,  1320,  3007,   891,  1329,  1788,
     892,   893,  1816,   894,  2836,  2246,  2247,  2248,  2586,  2587,
     895,  2087,  2799,  2125,   896,  1312,  1773,  1684,  3060,  2820,
    1623,  2070,  2484,  2588,   517,   518,   897,  1237,  1238,  1239,
    1701,  1303,  2216,  1765,  1499,  1500,  1501,  1502,  2939,  2938,
    2940,  3284,  3126,  3286,  3130,  1939,  1503,  1504,  3438,  2337,
    2659,  2355,  2356,  3137,  1930,  1505,  2343,  3136,  2675,  2945,
    3292,  3442,  2018,  3288,  1370,  1371,  1681,   952,   953,  1624,
    1848,  2261,  3110,  3274,  2236,  2909,  3272,  3359,  1565,  2405,
    2406,  1891,  1892,  2359,  2678,  2698,  1019,  3271,  2263,  1467,
    1468,  2778,  3673,  2029,  3427,  3509,  3558,  3559,  3560,  2627,
    2628,  2913,  2914,  1893,  2294,  2629,  3111,    78,   408,    79,
    1818,   695,   696,  1160,  1161,   520,   417,    80,   426,  1849,
      81,   439,  1427,   568,   588,   981,   982,  1878,  2274,  2281,
    1879,  2286,  2902,  2276,  2607,  2608,  1951,  1952,  2277,  2610,
    2899,  2891,  2892,  2600,  3101,    82,   459,  2670,  2350,  2351,
    3419,  3420,   589,    83,   407,   736,  1612,  1164,  1611,   737,
     738,  1166,   515,   516,    84,   457,  1040,  1041,  1042,  1482,
      85,   450,   652,  1463,  2327,  1913,   580,   654,  1474,   655,
    1475,  1454,  1908,  1007,    86,   683,   682,    87,   476,  1082,
      88,   529,   928,   929,  1390,  1826,    89,   440,   593,   594,
      90,   434,   581,  1420,    91,   427,   571,    92,    93,   572,
     961,  2601,  3268,  3467,  3536,  1411,   962,  2461,  3277,  3367,
    3368,  3370,  3435,  3436,  3603,  3626,  3643,  3644,  3647,   898,
     671,   899,  3147,   900,   901,  2282,  2283,  2679,   902,  3421,
     903,  2014,   665,   423,   904,   562,   672,  2266,   905,  3500,
     717,   718,   389,   390,    94,   615,   449,   999,  1000,  1001,
    1449,  1450,   656,  2225,  1451,  1452,  1905,  1900,  2921,  2651,
    2643,    95,   575,   930,   966,   967,  1857,    96,   458,    97,
     954,  1406,  1407,  1845,  2260,  1846,    98,   597,    99,   551,
    1400,   552,   932,   553,   554,   944,   939,   947,   941,  3258,
    3093,  3094,  1833,   913,   719,   720,  1393,  1828,  1829,  2886,
    3096,  3264,  3265,   100,   120,   395,   499,   711,   989,   101,
     102,   103,   104,   992,  1077,  1885,  1078,  1079,  1080,  1512,
    1437,  1310,  2873,  2218,  1767,  2566,   504,   726,   486,   506,
     507,   112,   113,   727,   728,  2049,  2442,  2760,  3023,  3024,
    3207,  3204,   729,  3533,   730,  2451,  2044,  2763,  3330,  3460,
     105,   673,   468,  1075,  1070,  1072,  1508,  1946
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -3238
static const int yypact[] =
{
    3736, -3238,  1159,    55,  1035, -3238,   373, 42164,   514,  1035,
    1035,   282,  1179, -3238, -3238, -3238, -3238, -3238,  2944, 42164,
      55, -3238, 20637, -3238, -3238, -3238,   274,  1035,    55, 42164,
   -3238,   416,   914,    55, -3238, -3238,  1035, -3238,   282, 42164,
   -3238,   577, -3238,   879,  -107,   565,   545, -3238, -3238, 42164,
    1545,   410,  1051,  1053, -3238, -3238,   767, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, 21190, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238,   981, 42164, 42164, -3238,
   42164,   663, -3238,  1077, -3238, -3238,  1035, -3238, -3238, -3238,
     282, 20637, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,   638, -3238,
   -3238,   750, -3238, -3238, -3238,  1247,  1076, -3238, -3238, -3238,
   -3238, -3238,   409,   809, -3238,   827,  1090,    93, -3238,  1108,
    1108, 42164,  1108, -3238,  1108, -3238,  1108,  1035, -3238, -3238,
    3862, 42164,   987,   107,  -101, 37214,   707,   258, -3238,  1116,
   20637, -3238,  1035,  1174,   312, 42164, -3238, -3238,  1035,   586,
     752, -3238,  4016,   113, -3238, -3238, -3238,  2733, -3238, -3238,
    5591, -3238, -3238, -3238,   812, -3238, -3238, 20637,  1035,  1096,
   -3238, -3238,   148,   148,   148, -3238,   148, -3238,   148, -3238,
     410,   806, -3238, -3238, 42164,   563, -3238, -3238,   849,   -43,
   -3238, -3238, -3238, -3238, 20637,  1305,  1002, -3238, 20637, -3238,
     -50, -3238, -3238,   901, 42164, -3238, 20637, 20637,   112,   762,
      14, 42164, 35014,  1079, -3238,   679,  1077,  1478, -3238,  1076,
   -3238, 42164, -3238, -3238, -3238, 38864,    93, -3238, 12742,  1344,
   42164, 42164,  1161, 42164, 42164, 35014, 20637,  1108,  1034,  3326,
    1167,  1146,   948, -3238, -3238, -3238, -3238,  1227, -3238, -3238,
    1100, -3238, -3238, -3238,   117, -3238,    27, -3238, -3238, -3238,
   -3238, -3238,  1256,  1016, -3238, -3238,    78, -3238, -3238, 42164,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,  1391, -3238,
   -3238, 12742,   991,  1560,  1437, 20637, -3238,  -191, -3238, -3238,
    1356, -3238, -3238, 35014, 20637, -3238, -3238, -3238, 18415, -3238,
   -3238,  1569, -3238,  1050, -3238, 20637,  1167, -3238,  1299,  1211,
     762,  1129, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238, -3238,  1081,  2733, -3238, -3238,  1390,  1510, -3238,  1233,
       0,  1156,  1109,   136,     0, 37214,  1432, -3238,   125, -3238,
    1515, -3238, -3238,  1223, -3238, -3238, -3238,  1242,  1257,  1439,
    1248, -3238,   251,   243, -3238, -3238,    73, -3238,   729,  1432,
       0,  1001, -3238,  1465,  1592,   292,  -145, -3238,   724, -3238,
   -3238,  1674, -3238, -3238, -3238, -3238, -3238,  1391, -3238, -3238,
   -3238,  1181, -3238,  1408,  1280, -3238, -3238,    30, -3238,  1208,
     -83, -3238,   591, 35564, -3238, -3238, -3238,  1663, -3238, -3238,
   -3238, 35014,  1351,  1244, 20637,  -192, -3238, 39414, 20637, -3238,
      -3, 12742, -3238, -3238,  4068,    70,   167, -3238,  1736,  1398,
   -3238, -3238, -3238, -3238,  1650, -3238,  1234,  1238,  1618,  1259,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238,  1294, -3238, -3238,
   -3238,  1002, -3238, 20637,  -182, 20637, -3238,  1268, -3238,  1274,
   -3238,  1283,  1285,  1290,  1295,  1303, 15622, -3238,  1311,  1325,
    1327,  1335,  1338,  1343,  1348,  1369,  1371,  1376,  1392,  1413,
    1418,  1420,  1234,  1234,  1425,  1428,  1457,  1468,   573,  1474,
   -3238,  1479,  1481,  1484,  1488,  1490,  1492,  1499,  1501,  1511,
    1514, -3238,  1516, -3238,  1519,  1521,  1532,  1533,  1534,  1536,
    1537,  1542,  1543,  1548,  1551,  1558,  1566,  1567, -3238,  1577,
    1578,  1579, 12742,  1580,  1581,  1582,  1588,  1589,  1593,  1594,
   -3238,  1599,  1600,  1601,  1602,  1608,  1615,  1619,  1620,  1621,
    1623,  1630,  1632,  1635,  1636,  1637, -3238, -3238, 12742,  1638,
   -3238, -3238,  1642,  1644, -3238,  1649,  1654,  1657,  1659,  1660,
    1664,  1667,  1669,  1675,  1689,  1692,  1697,  1703,  1707,  1712,
    1719,  1720,  1722,  1725,  1726,  1728, -3238,   582,  1731,  1732,
     915,  1733, -3238,  1738, -3238,   178,  1742,  1743,  1745,  1234,
    1234,  1234,  1746,  1747,  1752,  1753,  1755,  1758, 12742, 15622,
   15622, 15622,  8134, -3238, 42164, -3238, 42164,  1784,  3253, -3238,
    3815, 15622,  4637,   135, -3238, -3238, -3238,  1354,  1358, -3238,
   -3238, -3238, -3238, -3238,  1763,  1372, -3238, -3238, -3238, 20637,
   -3238, -3238, -3238,  1383,   118, 20637,  1426, -3238, -3238, -3238,
   -3238, -3238, -3238,  1924, -3238, -3238, -3238,  1470,  1518, -3238,
   -3238, -3238, -3238, -3238, -3238,  1603, -3238, -3238, -3238,  1765,
   -3238,  1765, -3238, -3238,  1765, -3238, -3238,  1765,    43,  4113,
   -3238, -3238, 42164, -3238, 42714, -3238, 18415,  1784, -3238,  1845,
   -3238, -3238,  1875, -3238,  1855,   189,  1610, -3238, 20637, 37214,
   -3238, -3238,   110,  1629,  1761,  1700, -3238,  1825, 20637, 20637,
   -3238, -3238, -3238, -3238,   752,   -28,  1766,   211, -3238, 42164,
   -3238,   285, -3238, -3238, -3238,  1771, -3238, 12742, -3238,  1772,
   -3238,  1185, -3238,  2120, -3238,  1861, 12742, -3238, -3238,  1785,
    1076, 42164, 42164, 20637, 20637, -3238, -3238, -3238,   526, -3238,
   -3238, 42164,     0, 35014, -3238, -3238, -3238,  2179,  1001, 42164,
       0, -3238,  2125,  1879, -3238, -3238, -3238,  2201, -3238, -3238,
    2193,  1791, -3238, -3238, -3238,  1001, -3238, -3238, -3238, -3238,
   -3238, 20637, -3238, -3238,  1001, -3238,  1001,  1001,     0,     0,
    1844, -3238, -3238,  1798, -3238,  1844,  1931,   252,   148,  2017,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
     759, -3238, -3238, -3238, -3238, -3238,    82, -3238, -3238, -3238,
    1489,  2568,  2568,  1154, -3238,   173, 20637,   167,  1861, 20637,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238,  1808, -3238,  1810,
    1812,  1784,  2248,  2249,  2253,  2256,  2261,  2262,  2265,  2267,
    2268,  2270,  2275,  2277,  2279,  2280,  2282,  1860, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238,  1911, -3238, -3238, -3238,
   -3238,  1445, -3238, -3238, -3238,    90,  1874, -3238, 37214,  2405,
   35014, 42164, 42164,  2287, 20637, -3238, -3238,   130,   130,  2110,
    1894, -3238,  -188, 42164,  2295, 25056,    74, 12742, 12742, 12742,
     802,  1189,  2407,  2460,  2460,  2460, 12742, 12742, -3238, -3238,
   12742, -3238, 12742, 12742, 12742, 12742,   816, -3238, -3238,  8710,
   -3238,  1900, 12742, 12742,  1988, 12742,  1358, 12742, 12742, 21743,
   12742, 12742, 12742, 12742, 12742,   620, 12742,  4637, 12742, 12742,
   12742,  1907, 12742, 12742, 12742, 12742, -3238, 12742, 12742,   267,
   12742,  2361,   924, 12742, 12742, 12742, -3238,  9286, 12742, 12742,
   12742, -3238, 12742, 12742, 12742, 12742, -3238,  2483, -3238, 21743,
     936, 12742, 12742,   956, 12742, 12742, 12742, 12742, 12742, -3238,
   -3238, -3238, -3238,  8710, -3238, 12742, 12742, 12742, 12742, 12742,
   -3238, 15622, 12742,  9862, 12742, 12742, 12742, 12742,  1932, 12742,
   12742,  2460,  2460, 12742, 12742, 12742,   996,  8710, -3238, 12742,
    1358,  2871,  2871, 12742,  1358,  6982, 12742, -3238, -3238, -3238,
     924, 10438,  1933, -3238, -3238, -3238,  2460, 21743,  2460, 12742,
   12742, 12742,  1784,  1960,  2407,  2407,  2407, -3238,  8134,    83,
    1934, 12742, 22849,  1937, -3238, -3238, -3238, -3238, 12742, 12742,
   12742, -3238, 15622, -3238, -3238,   927, -3238, -3238, -3238, 13318,
   15622,  1939, 15622, 15622, 15622, 15622, 15622,  2273, 15622, 15622,
   15622, 15622, 15622, 15622, 15622, 15622, 15622,   898,  2407, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
    1954, -3238, 37214, 15622, 12742, -3238, -3238, 42164, -3238, 35014,
   -3238, -3238, -3238,   118, 37214,  1944, -3238, -3238,  2132,  3326,
   20637, -3238, 42164, -3238, -3238, -3238, -3238, 18968, 18968, -3238,
   18968, -3238, -3238,    79,    80,  3408,  1982, -3238, -3238, -3238,
   -3238,  2316, 20637, -3238,   538, 20637,   167, -3238, 12742,  1861,
   -3238, 35014, 35014, 20637, 20637,   175, -3238,  1222, -3238,  1861,
    2345, 18968, 18968, 18968, -3238, -3238, -3238, -3238, -3238,   705,
   -3238,  1784, -3238,  1961, -3238, -3238, -3238, -3238, -3238, 39964,
     313, -3238, -3238,  1861,  2367, -3238,  1784,  1969, 42164, -3238,
   -3238, -3238, -3238,    19, -3238, -3238, -3238, -3238,   -91, -3238,
   -3238, -3238, -3238,  2100,     0, 42164, -3238, -3238, -3238, -3238,
   -3238,  2169,  1432,   243,     0,  1001, 20637,     0,     0, -3238,
   -3238,   683, -3238,   724, -3238, -3238, -3238, -3238, 42164,  1298,
    2116,  1978, -3238, -3238, 20637, -3238,  1980, -3238,  2388,  2517,
    1432, -3238, -3238, -3238,    61,    61,  1861,  2106,  2108,  2114,
    2124,  2126,  2134, -3238, -3238,  2961,  2505,    61,    61,  2505,
      61,    61,    61,  2079,  2469,    61,  2356,  2112,   826,  2357,
      61, -3238,  2115,  2476,    61,    61,    61,  2505,  2558,    61,
      61,    61,    61,    61,   134,    61,    61,    61, -3238,  3393,
   -3238, -3238,  2043, 19521, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238, -3238, 40514, -3238, 12742,  1189,  1861,  1861,   693,  1861,
    1189,  1861,  1861,  1861,  1861,  1861,  1189,  1861,  1861,  1189,
    4068, -3238, -3238, -3238,    92, -3238, -3238,   -87, -3238, -3238,
    1193, 42164, -3238,  3822, -3238, -3238, -3238, -3238, -3238, 20637,
   20637,  2089,  1982, -3238,   252, -3238,  2040, -3238,   380,   244,
     169, -3238,  2460,  2055, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238,  2056,  2059,  2067,  2068,   334,   963,  -190,  2069,  1379,
    2070,   709,   845,   176,   971, -3238,  2072,  2063,  1734, -3238,
     975,  1033,  1750,  1769,  1104,  2073,  2074,   202,   209,  1113,
    1119,   238, -3238,  2084,  1147,  2478,  1168,  1172,   249, -3238,
    1817,  1198,  1200,   273,  2085,   277,   293, -3238, -3238, -3238,
   -3238,  2088,  1228, -3238, -3238,   278,  1826,  1230,  1236, -3238,
    1835,  1241,  1255,   321,  2086,  1260,   344,  1270,  1284,  2091,
    2094,  2104, -3238,  2460,  2099,  1865,  1870,  2460,  2103,   346,
    1300,  1877,   350,   364,  2109,  2117,  2119,  1887,  1902,  1915,
     382,  1320,   414,  2122,  3417,  1920, -3238,  1935,  1324,  1330,
    1359,   445, -3238,  1373,  1958,  2130,  2136,  1385,   182,  1461,
    2460,  2141,  1991,   550,  2105,  2123,  2018, 11014, 11590, 12166,
     301,  1471,   427, -3238,  2023, -3238,  2153,  2156, -3238,  2074,
    2158,   578,   649,  2060, 12742,   742, -3238,   620, -3238, -3238,
   -3238,   103,   832, -3238,  2263, 42164,  1226,   133, -3238, -3238,
   -3238, -3238, -3238, -3238,   449, -3238,  2160, -3238,  2163,  2168,
    8134,   916,  2168,  3442,  1513,  1513, 15622,  2673,  2774,  3746,
    1297,  4637,  1297,  4637,  2168,  2168,  2168, -3238,  2166, 15622,
   15622, 15622, 12742, -3238,  2407,  1784,  2170,   342, -3238, -3238,
   -3238, -3238,  1426,  2428, -3238,  2165, -3238, -3238,   835, -3238,
    2174, -3238,  2177,  2208,  2245,  2276, -3238, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,  1432,  1222,
    2266,  2186, -3238, -3238,  2227,  2521, -3238, -3238, -3238, -3238,
    1784, -3238,  2284, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238,    44, -3238, -3238,  2207,  2207, 17304, -3238, -3238, -3238,
   -3238,  2437,  2613,  2615,  2616,   591, -3238,     9, -3238,  1018,
    2566,  1432, -3238,  2619, 37764, 25608, -3238,  2228,  2580,  2235,
      61, 33364,   327, 23399, 33914, -3238, -3238,   693, -3238,   100,
   -3238, -3238, -3238, -3238,   526,   526,  2252, -3238, -3238,  2480,
   -3238, -3238, -3238,  1982,  1001, -3238, -3238, -3238,  2232, -3238,
   -3238,   252,  2583,  2584, -3238,  2461,    54,  2461,   252,   252,
   21743,   252,  1454, -3238,  1189,  2518, -3238, -3238, -3238, -3238,
   -3238, -3238, 36114, 34464, -3238, -3238, -3238,  2727, -3238,  2728,
     179, -3238, 22296,   807,   807, -3238,   203,   270, 22296, -3238,
   -3238, 22296,   693,  1189, 22296,  1189,  1861,  1861,  1384,    61,
    1189, -3238, -3238,  2587,  2588, 22296, 22296, -3238, 37214, -3238,
      61,   657,   693,   693, 22296, 21743,  1953,  1861,  1189,  1189,
    2383, -3238, -3238, -3238, 20637,  1155, 37214,  2254, -3238,  4908,
   16751, 42164,   268,   150, -3238,  2255,  2260, -3238,   934, -3238,
    1784, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238, -3238,  2339, -3238,  2264, -3238, -3238,    50, -3238,  2260,
   20637, 16198, -3238,    88, -3238,  3333, -3238, -3238, -3238,   252,
    2477,  1982,  2285,    74, 13894, -3238, -3238, 12742,  2269, -3238,
   12742, 12742, -3238, -3238, -3238,  2741, -3238, 36664, -3238, -3238,
   -3238, -3238, -3238, 12742, 36664,  2741, 12742, -3238, -3238,  2274,
   -3238,  2632,  2632, -3238, -3238,  1358, -3238, 42164, -3238, 12742,
   -3238, 12742, -3238,  1358, -3238, 12742, -3238, 12742, 12742, -3238,
    2502, -3238, 12742, -3238, 12742, 12742, -3238, 12742, -3238, -3238,
   12742, -3238, 12742, 12742, -3238, -3238,  2522, -3238, 12742, 12742,
   -3238, -3238, 12742, -3238, 12742, -3238, 12742, -3238, 12742, -3238,
   12742, -3238, 15622, 21743,  2289, -3238, -3238, -3238,  2291, -3238,
   -3238, 12742, 12742, -3238, -3238, 12742, -3238, 12742, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238, 12742, 12742, -3238, 12742, -3238,
   12742, -3238, -3238, 12742, 12742, 12742, -3238, 12742, -3238, -3238,
   -3238, -3238, 14470, 12742, 12742, 12742,  2292, -3238, -3238, -3238,
   12742, 12742, 12742, -3238, 12742,    95, 12742,  1010, 12742,  2749,
   12742, -3238, 12742,  2523, -3238, -3238, -3238, -3238, -3238, 12742,
   -3238, 12742, -3238,  2035, 12742, 12742,  2718, -3238, -3238,  2294,
    2299, -3238,  2300,  2301,  2303, 37214, 12742, -3238, -3238, -3238,
   -3238, -3238,   620,   664,  2312, 15622, -3238,  3442, 15622, -3238,
   -3238,  8134,   916,  3442,  2710, -3238,  2313, -3238, -3238,  2315,
   42164, -3238, -3238, -3238, 42164,  2302, 26160, 35014, 35014, 35014,
    2323, 12742, -3238, -3238,  2530, -3238, -3238, 20637,  2685, -3238,
   -3238, 35014, -3238,  2733, 21743, -3238,  2327, -3238,  2327,  1206,
    2330,   985, -3238, -3238, -3238,  2328,  1129,  2732, 35014, 35014,
   35014, -3238,  1982,  1982,   581,  2386,  2682, -3238, -3238, -3238,
   -3238, 41064, -3238, -3238, -3238, -3238,   601, 42164,  2662, 42164,
    7558, -3238, -3238, -3238,  2851, 12742, -3238, 35014,   830,   832,
      61, -3238, -3238, -3238, -3238, -3238, -3238,  1432, -3238, -3238,
   -3238, -3238,  2644, -3238, -3238,     0,   683,   597, -3238,  1813,
   -3238, -3238, -3238,  2680,   252,  2461,  2461,  2684,  2579,   525,
    2351, -3238,    61,  1298,   266, -3238,  2733, -3238, -3238, 12742,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238, -3238, -3238, 12742,  2689,  2692,   807, -3238, 22296, -3238,
   -3238,  -182,    42, -3238, -3238, -3238, -3238, -3238, -3238, 34464,
    1861, -3238, 22296, -3238, -3238,   153, -3238,  1861, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238,  2363, -3238,   957, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, 20637, -3238,   994, -3238,
   -3238, -3238, -3238, 42164, -3238, -3238, 20637, -3238, -3238,  4750,
   42164, 42164,  2913, -3238, 42164, -3238, -3238, -3238, -3238, -3238,
    2597,  -142,  2917, -3238, 20637, -3238,  2370,  1022, -3238, -3238,
   -3238,  2929,  5256, -3238,  2375,  1982,  2698, -3238, -3238, 12742,
    2087,  2098, -3238,  1784,  2102,  2389,  2389, -3238, -3238,  2392,
    2389,  2729, -3238,  2739,  2385,  2393,  2396,  2111,  2397,  2398,
    1520, -3238, -3238,  4637,  4637,  2401,  2399,  2113,  2129,  2404,
    2408,  2131,  1555,  2133,  2415,  2417,  2142,  2144,  1559,  2148,
    2167,  2175,  2182,  2419,  2477,  2424,  1612,  1626,  2420,  2184,
    2197,   756,  2210,  2426,   758,  3101, -3238, -3238, -3238,  2219,
    2230,  2257,  2281,  2298,  2317,  2324,  2348,  2360,  1631,  2380,
    2416,  2429, 12742,  2427,  1495,   788,  1661, -3238,  2463,  1686,
    1702,  2488, 12742,  2499, 12742,  2524, 12742,  2531,  2541,  2431,
    2543,  2563, 12742,  2444,  1784, -3238, -3238, -3238, -3238, -3238,
   -3238, -3238,  2422,  1784,  2436, -3238, -3238, -3238,   135, -3238,
     828,  2438, -3238, 15622, -3238, 12742,  2442, -3238,  2446, -3238,
   -3238, -3238, -3238, -3238,   400,   400,   400, 15046,  1784,  2879,
   -3238,    48, -3238,  2775, -3238, -3238,  1081,  2449, -3238,    61,
   15046,  2207,  2596, -3238, -3238,  1206, 21743, 25608, -3238, 35014,
    1259,  1259,  1259,  1432,  2826,  2266,  2266, -3238, 23949, -3238,
   -3238,  2592, -3238, -3238, 26712, -3238,   -47, -3238, -3238, 15622,
    1481, -3238,  1784, -3238, 36114, -3238,  1784,    61,  2454,  2462,
   -3238, -3238, 41614, 12742, -3238,  2888, -3238, -3238,  2465,   252,
    2679,   252, -3238,  2800,  2806,   252, -3238, -3238, -3238, 21743,
    1982, 15046,   807,   807,   807, -3238,  1081,  1784,  2468,   957,
    1784, 22296, -3238, -3238,  -182,  2473,  2938,  2939, 22296,  2851,
   -3238, -3238, -3238, -3238,  4750, 21743, -3238, -3238, -3238,  1058,
   -3238, 16751, -3238, -3238, -3238,  2481,  2484,  2389, -3238, -3238,
   -3238, -3238, -3238,  2392,  2687, -3238,  2392,  2392, -3238, -3238,
   -3238, -3238, -3238,   231,  1272, -3238, -3238,   231, -3238, -3238,
   -3238,    85,   841,  2392, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238,  2389,  2389, -3238, -3238, -3238,   231,  2485, -3238,  2389,
    2991, -3238,   264,    77,  2491,  2492,  2389,  2493,  2489, -3238,
    1118, -3238, -3238,    46, -3238,   747, -3238, -3238, -3238,  2487,
   -3238,  3393, -3238,   637, -3238, 42164, -3238,   526, -3238,  4637,
   -3238, -3238, -3238,  2730, -3238,   231,  2736, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, 12742,  2496,
    2497,  2501, -3238, -3238, -3238, -3238, -3238, -3238, 12742, -3238,
   -3238, -3238, -3238, -3238, 12742, -3238, -3238, -3238, -3238, -3238,
    2649, -3238,  2738, 12742, 12742, -3238, -3238, -3238, -3238, 12742,
   -3238, -3238, -3238, 12742,  3042,  2708,  2516, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, 12742, -3238, -3238, -3238,
    4637, -3238, 12742, -3238, -3238, 12742, 12742, -3238, 12742, 12742,
   -3238,  2567, -3238,  2574, -3238,  2585, -3238, -3238,  2754, -3238,
   -3238,  1784, 12742,  1129, 42164, -3238, -3238,  2519, -3238, -3238,
   -3238, -3238,  1784, -3238, -3238,   399,  2547,  2547,  2547,  1481,
    1784,  1123, -3238, -3238,  2873, -3238,  1771, 21743, 15046,  2527,
    2529, -3238,   -83, -3238, -3238,  2528,  1259, -3238,  3052,  2906,
   -3238, -3238, 37214,  2534, -3238, -3238,  2808, -3238,    69,  2720,
   -3238, -3238, -3238,   830,  2630,  2633,    61,  1784,  1861,  1595,
    1978,  2885,  3068,  2594,   252,   252,  3076,  2595, 12742, 12742,
    2555, -3238,  2477, -3238,  2957, -3238, -3238, -3238,  1771, 12742,
   -3238,  2561,  2562, 42164, -3238,  3530,   268, -3238,  2991, -3238,
   -3238, -3238,   708,  2798,  2802, -3238,  -144, -3238,  2570,  -144,
    -144,  3115,   131, -3238,  3115, 36664, -3238,  1233, -3238,  2612,
     231, -3238, -3238,  2614, -3238, -3238, -3238,  -144,  2593,   231,
   -3238, -3238,  2819,  -144, -3238, 37214,  1861,  3438, -3238,  2634,
   -3238,  3056,  2930, -3238,  2991, -3238,  2931,  2834, -3238,  2836,
   -3238, -3238,  2841, -3238,  2842,  2844,  -144,  2848, -3238,  -144,
   42164, -3238, 42164,  2624,   685, -3238, -3238, -3238,  2622,  2625,
   -3238, -3238, 20637, -3238, -3238, -3238, -3238,  2678, 42164,  2624,
   -3238,   -83,    88,  2596, -3238,  1130,   957,  2628, -3238,  2635,
    2637, -3238,  1163,  2589, -3238, -3238, -3238,   874,  2599,   148,
    2645,  2627,  2601,  1704,  2607,  2609,  2896,  3044, -3238,  2623,
    2646,  2641,  2654,  2693,  2697,  2709, -3238, -3238, -3238,  2647,
    1784, -3238, -3238, -3238,  2650, 37764, -3238,  2719,  2743, -3238,
   -3238,  2745, -3238, -3238,    81,  1267, -3238, -3238, -3238, -3238,
   15046,  2988, -3238,   789, -3238, -3238, -3238, -3238, 12742, -3238,
    2477,  3178, -3238, 23949, -3238, -3238, -3238, -3238, -3238,  2675,
    2686,  7558,  3231, -3238,   252, -3238,  2722, -3238, -3238, -3238,
    2723,  1784,  1784, 42164,  2698,  3022, -3238,   789,   957, 42164,
   42164,  1196,   924,   924,   924,   699,   699, -3238, -3238, -3238,
   -3238,    52,   142, 42164, -3238, -3238,    65, -3238,  2694,  2695,
   -3238, -3238, -3238, -3238,  -144, -3238,   148, -3238, -3238, -3238,
   -3238, -3238, 36664, -3238, -3238,  3115, -3238, -3238, -3238,   148,
   -3238,  2696, -3238, -3238, -3238,  1234, -3238, -3238,  2925,  2725,
   -3238, -3238, -3238, -3238,  2707,  2711,  2712,  2714, -3238,  2717,
   -3238, -3238, -3238,   783, -3238, -3238, -3238, -3238, -3238,    51,
   42164,  3100,  1861,  2715,  2721, -3238, -3238, -3238, -3238, -3238,
    2724,  1129, -3238, 42164, -3238,  2955, -3238, -3238, -3238,  2956,
   -3238, -3238, 12742, -3238, -3238, -3238,  2460, -3238, 12742, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,    84,  2951,
    1189,  1189,  1189,  1189,  1267, -3238, -3238,  2779,  2821, -3238,
    1018, -3238,  -193,   957, 12742,  1432,   644,  3054, -3238, -3238,
   -3238, -3238,  3031,  3130, 12742,  2747, 12742,  2748,  1202, -3238,
   -3238, -3238,  2753, -3238, -3238,  1245,  1264, -3238, -3238, -3238,
     268, -3238, -3238, -3238,   434,   434,  1286, -3238, -3238, -3238,
   -3238, -3238,  1304, -3238, -3238, -3238,  1353, -3238, -3238,  1234,
   -3238,   231,  3115,   231,  3115,  3252,  2967,  3264, -3238,   410,
   -3238, -3238,  4750, -3238, -3238, -3238, 42164,  4750, -3238, -3238,
     957,  2758,  2762,   928,  2771,  2731,  2772, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, 21743, 20637, -3238,   287, 12742, -3238,
   -3238,  1784,  2960,  3305,  3306,  3214,  3308,   644, -3238,  -111,
   -3238,  3210, -3238,  1784, 42164,  1784, 42164, -3238, 42164, 40514,
    2964, -3238, -3238, -3238,  3356, -3238,   194, -3238, -3238,    65,
   42164,   231,   148,   231, -3238, -3238, -3238, -3238, -3238,  3013,
   -3238,  3015, -3238,  2791,  3247, -3238,  3236,  2962, -3238, -3238,
     -83, -3238, -3238, -3238, -3238, 12742, -3238, -3238, -3238,  2799,
   -3238,    61, -3238, -3238, -3238,   957, 42164, -3238,   148,   148,
    3328,   148, -3238,  3335,  3336,  -111, -3238,   693, 12742,  1382,
    1401, -3238,  2804,  2809, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238,   -83, -3238, -3238, -3238,  3266,
   31704,  2969, -3238, -3238,  2737, 21743, 15046,  1384, -3238, -3238,
   -3238, -3238,   148, -3238,   148,   148, -3238,  3369,   200, -3238,
   -3238, -3238, -3238, -3238, 42164,   106, -3238, 43264, 43264, 42164,
   -3238,  2846, -3238,  4701,   155, -3238, -3238, -3238, -3238, -3238,
    2812, -3238, -3238,  4750, -3238, -3238, -3238, 34464, -3238,  2822,
   -3238, -3238, -3238,  3122, -3238, -3238, -3238,  3228, 42164, -3238,
   -3238, -3238, -3238, 12742, 12742,  2859, -3238, -3238, 31704, 31704,
   -3238, -3238, -3238, 31704, -3238, -3238,  3178,  2832,  3262, -3238,
    3182,  3268, 12742,  1784,  1784, -3238,   753, -3238, -3238, 28929,
    2837, 32259, 12742,   155, -3238, -3238,  3054, 12742,  2839,  2847,
   -3238,  1189, -3238,  3208,  2591,  2878, 12742, 31704, -3238,  3283,
    3317,  3159,  2850, -3238,  2853,  2760, 43264,  3247,  3218,  1784,
   -3238, -3238, -3238, 42164, -3238, -3238, -3238,   926, -3238,  1784,
   29484,  2872, 38314, 30039,  2855, -3238, -3238, 12742, -3238, -3238,
   -3238, 31704,  3102,  2865, -3238,  2864, -3238, 31704, 12742, -3238,
    3300,  2892, -3238, -3238, -3238,  3256,  2881,  1232, -3238,  2882,
   -3238,   359, 31704, -3238,  3204, 17857,  3024, 42164, 27264,  1784,
    2901, 31704,  3292, 42164,  4750,  3293,  3295, -3238,  3064, 30594,
   -3238, -3238, 37214,  1434, -3238, -3238, 21743, -3238, -3238,   -14,
    2909, -3238, 27819, -3238, -3238,  3362,  1140, -3238, -3238,  2928,
   -3238, -3238, 20079,  2799, -3238, 31704, -3238, 31704, 32814, 12742,
   -3238,  2943, -3238, -3238, -3238,  4701, -3238, -3238, -3238, 31149,
   28374, -3238, -3238, 24499, -3238, -3238, -3238,  3310, -3238,  1784,
   -3238,  1358, -3238, 32814, -3238, -3238, -3238, -3238
};

/* YYPGOTO[NTERM-NUM].  */
static const short int yypgoto[] =
{
   -3238, -3238, -3238, -3237, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238, -3238,  1665, -3238, -3238, -3238, -3238, -3238,  1901, -1422,
   -3238, -3238, -3238, -3238, -3238,   715,    17, -3238, -3238, -3238,
   -3238, -3238, -3238,  2801,   -62, -3136, -3238, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238,   279,   158, -3238, -3238,   289,
   -3238, -3238,  -658, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238,  -197,  -157, -3238, -3238, -3238, -3238,   362, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238,  -163, -3238, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,   -85, -3238,
   -3238,   -41, -3238, -3238,   -84, -3238, -3238, -3238,   -44, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,   464, -3238,
   -3238, -1831, -3238, -3238, -3238, -3238,  2365,  -980, -3238,  3107,
   -3238,  -394,   743,  1956, -1901, -1025,  -621,  -613,  -834, -3238,
   -3238, -3238,   376, -3238, -3238,  1466,   815,  1955,  1994,  1507,
    1557, -3238, -3238,   837, -3238, -2621, -3238, -3238, -3238,   803,
   -3238,   805, -3238, -3238, -3238, -1366,   773,  -974, -3238,   368,
     821, -3238,   575, -3238,   530, -3238,  -449, -2023, -1927, -3238,
   -3238, -3238,   540,   848,   904, -3238, -2574, -2088, -3238, -3238,
     171, -3238, -3238, -3238,   160, -3238,   396,   250, -3238, -3238,
   -1468, -1669, -3238, -3238, -2054,  2403, -1885,   331, -1866, -3238,
     377, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
    1550, -3238, -3238, -3238,   -34,  -246, -1320, -2798, -3238, -3238,
   -3238, -3238, -3238, -3238,  1293, -3238, -3238,  2078,  2500, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
    1695, -3238, -3238, -3238, -3238, -3238,  -924,  2432, -3238, -3238,
   -3238,  1402, -3238, -3238, -3238, -3238,  2151, -3238, -3238,  2869,
   -3238, -3238, -3238, -3238,  1308,  1735, -3238, -3238, -3238,  2902,
    1693,  -465, -1739, -3238,  3118, -3238, -3238, -3238, -1284, -1278,
   -3238,  2977,   323, -1818,  2157,  -705,   716, -3238,   506,  -739,
    3401, -3238, -1273, -1102, -3238, -3238,  -498, -3238, -3238, -3238,
   -1253,  -735, -3238, -3238, -3238, -3238, -3238, -3238, -3238,   714,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
   -1136, -3238,  1517, -3238, -1055, -3238, -3238, -3238,  2369, -3238,
   -3238, -3238, -3238, -3238, -1895, -1424,   940, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, -1876, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, -1393, -3238, -1692, -3238, -3238,  -910,
   -3238, -3238,   224, -2102, -1191,   735, -3238, -3238,  -957,  2421,
   -1552, -3238, -3238, -3238,  1367, -3238, -3238, -3238, -3238, -3238,
     917, -2002, -1049, -3238, -3238, -2603,  -632, -1813,  -616, -3238,
   -1843,   477, -1164, -1859, -3238, -3238, -3238, -3238,    33, -3238,
   -3238, -3238,   503,  1729, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238,  -467,  -378, -3238,  2012,   942, -3238, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238,  2667,  2648,  1779, -3238, -3238,
   -2031, -3238, -3238,  1754, -3238,   734, -1849,  2520,  1023, -3238,
   -3238,  1028, -2594, -3238, -3238, -3238, -3238, -3238, -3238,   964,
      -4,   183,  3184, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
    2490,  2028,  3131, -3238, -3238, -3238, -3238, -3238,  2171, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238,  3200, -3238,  -970, -3238,
    -306, -3238, -3238,  -603, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238, -3238, -3238,  2286, -3238, -3238, -3238, -3238, -3238,  2672,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238,  1056,   123, -3238,
     295,   121, -3238,   228, -3238, -3238, -3238,    12, -3238,  -740,
    -669, -1005,   681, -1660, -1125,  1064,  2690, -2736, -1134, -1257,
   -1263, -1805,    21, -3238,    -7,  -483,  -895,  -599,  1833, -3176,
    -421,  -516, -3238,  2220, -3238, -3238, -3238, -3238,  2237, -3238,
   -3238, -3238, -3238,  1363, -3238, -3238, -3238,  1031, -3238,   761,
     568, -3238, -3238,  3350, -3238,  2278, -3238, -3238, -3238, -3238,
   -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
    2703,  3250,  3099, -3238,  2752, -3238, -3238, -3238, -3238, -3238,
     439, -3238,   491, -3238,  -497,  2548,   768, -3238,  1448,  -573,
    -820, -3238,   440, -3238, -3238,  1045,  3260,  3106, -3238, -3238,
   -3238, -3238, -3238, -2222,  -595, -3238, -2296, -3238, -3238, -3238,
   -3238, -1150, -3238, -3238,  2406,   629, -3238, -3238,   -61, -3238,
   -3238,  -102, -3238,  3225,  2981, -3238,  1666, -3238,   946, -3238,
   -3238,   677, -3238, -3238, -3238, -3238, -3238, -3238, -3238, -3238,
   -3238,  1526, -3238, -3238, -3238, -3238, -3238, -3238
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -2002
static const short int yytable[] =
{
     387,   650,   714,  1375,   564,   679,   993,  1631,  1414,   912,
    1020,  1172,   387,  1469,  1083,   387,  1665,  1047,  1151,  1152,
    1153,  1015,   387,  1187,  1188,  1190,  2364,  2217,  1196,   705,
     706,  1510,   387,  1020,  1758,  2262,  2339,  1632,  1633,  1634,
    1757,  2658,   387,   422,  2349,  2280,  2353,  1048,  2326,  1779,
    1646,  2310,  2315,  2318,  2485,  1663,  1787,  1969,  2466,   914,
    2060,  2488,  2348,  1820,  2618,  1655,  1088,   974,  1559,  1927,
    1985,  2330,  2331,  2958,  1089,  1484,  2950,  2943,  2299,   664,
     387, -1107, -1850, -1851, -1914,  -531,  1487,  1488,  1801,  1803,
    1254,  -249,   950,  -259,   971,  -260,   950,  3257,  1314,  1315,
     387,   387,  2381,   387,  1704,  1702,  1513,  1708,   477,  3011,
    1314,  1315,  1943,  2383,   387,   733,  1278,  1280,  1314,  1315,
    1284,  3664,   945,  1637,  1638,   482,  1640,   483,   985,   498,
    1293,  1294,  1295,  2402,  2403,  1735,  1736,  1418,  3115,  2292,
    1741,  2983,   492,  3087,  1304,  1305,  1306,  1429,  1314,  1315,
    2981,  3170,  2001,  2982,  2463,  1890,  1348,  2370,  3149,  1724,
    1756,  1674,  1760,  2370,   707,  2447,  2382,  1380,   557,  2385,
   -1972,  2686,  2991,  1569,  1604,  1094,  1694,   942,  3010,   697,
    2394,  2395,   668,  3527,  1314,  1315,   618,   619,  1021,  2404,
    2061,  1314,  1315,  1085,  1714,  1715,  1716,  1314,  1315,  1372,
    1866,  1085,  1380,  1085,  1017,  1723,  1949,   950,  2373,  1617,
     980,  3051,  1287,  3138,  1104,  1314,  1315,  1314,  1315,   951,
    2456,  1133,  1397,   951,  1314,  1315,  1130,  1097,  1789,  3301,
    1010,  1792,  1793,  1794,  1795,  1105,  1797,  1798,  1799,  1800,
    1802,  1804,  1805,  1806,  1807,  2347, -1501,  2328,  2613, -1107,
    1914,  2971,  1005,  1314,  1315,  1031,  3526,  3304,   684,  1314,
    1315,  2373,  2458,  2972,  1314,  1315,  1073,  3025,  3457, -1972,
    2552,  2765,  3025,  2448,  2042,  3026,  2433,  2973,  1043,  2002,
    3026,  3516,  1911,  1032,  2971,  1566,   618,   619,  1314,  1315,
    2344,  2367,  1314,  1315,  2371,  2372,  2972,  1435,   561,  3160,
     508,  1375,  2458,  2345,  3105,  3446,  1098,   512,  1314,  1315,
    2973,  3520,  3521,   114,  1029,  1011,  1314,  1315,  3088,   618,
     619,  1058,   956,  1134,  1033,  1157,  1135,  2685,  2373,  1034,
    1605,  1866, -1850, -1851,   951,   569,  1314,  1315,   453,  1136,
    2077,   505, -1200,  2918,   578,  1051,   712,   713,  1158,  1314,
    1315,   669,  2075,  3433,  3151,  3357,  2919,  2183,  1054,  1314,
    1315,  1314,  1315,   513,  1677,  1314,  1315,  1678,   618,   619,
     428,  2334,  3273,  2374,  1314,  1315,  3423,  3434,  3161,  1314,
    1315,  1288,  3358,  1099,  2078,  1375,  2920, -1200,   969,  1375,
    1431,   115,  1347,   454,  1059,  1314,  1315,  1314,  1315,  1506,
    3600,  1567,  2043,  3027,   387,   732,  3176,  2368,  3027,  3152,
    1436,  2021,  3302,  3162,   387,  3180,  2031,  1398,   387,  1471,
     106,  1067,  2037,   387,  3528,  2040,  1867,  1477,   387,  1314,
    1315,  2766,  2434,   991,  1316,  2672,  3517,  1317,  3692,  1496,
    -340,  3457,  1074,  3224,   685,   731,  1316,   708,  1383,  1317,
     387,   574,  1131,  2459,  1316,  1489,  1490,  1317,  3087, -1107,
    1314,  1315,  2689,  2293,  1511,  1088,  1137,   387,  2662,   686,
    2346,  2653,  1949,  1089,  1035,   514,  2200,   387,  2687,   559,
    2673,   387,  1685,  3383,  1915,  1912,  2068,   387,  1373,   387,
     387,   429,  1859,  2459,   387,   387,  3303,   558,  1950,  2317,
    3638,  1416,  3382,  2671,   387,   690,  3266,  1472,   387,  2467,
    1012,  1425,  2684,   387,   387,  1923,   387,   387,   387,   387,
    1316,   485,  1455,  1317,  1088,   698,  2691,  1316,  1399,  1381,
    1317,  3447,  1089,  1316,  1559,  3294,  1317,  2338,   908,  1044,
     910,   911,  1969,  1036,  2436,  3665,  1006,  1099,  1417,  1138,
    1752,  1316,   387,  1316,  1317,  1606,  1317,  1867,  3091,  3529,
    1316,  2774,   943,  1317,  1381,  1314,  1315,  2144,   387,   946,
    -503,  2148,  1868,  2370,  2449,  2375,   387,   387,   980, -1107,
    3116,   387,  1497,  1969,  2903,  1432,  1498,  2370,   387,  1316,
     121,  1022,  1317,  1314,  1315,  1316,   965,  1791,  1317,   579,
    1316,   980,  1037,  1317,  2186,   977,  3107,  2228,  1419,  2300,
    2239,   599,  2240,  1758,  1513,  1570,  1458,  2219,   387,  2284,
    -137,  1013,  3425,  2984,  1316, -1850, -1851,  1317,  1316, -1914,
    2952,  1317,  2003,  3088,  1901,  2465,  1318,   670,  1814,   570,
    2234,  1515,  -340,  2329,  1316,  1099,  3171,  1317,  1318, -1107,
    3012,  3081,  1316,  2663,  2664,  1317,  1318,  1768,  1769, -1107,
   -1850, -1851, -1914,  -531,  1314,  1315,  3305,  1289,  1055,  -249,
    3360,  -259,  1316,  -260,  1902,  1317,   387,  1758,  1014,  1314,
    1315,  2221,  1496,  2352,   387,  1316,  1318,   387,  1317,   722,
     387,   387,  1038,  1099,  2237,  1316,  1399,  1316,  1317,   586,
    1317,  1316,  3530,  1868,  1317,  3424,  2084,  2683,  2243,  2244,
    1316,  3405,  2625,  1317,  2220,  1316,  3409,  1030,  1317,   492,
    2376,  1571,  1318,  1039,  1314,  1315,   387,  1596,   387,  1318,
    3089,  1316,  1758,  1316,  1317,  1318,  1317,  3411,  2407, -1107,
    2623,  2624,  1099,  2066,  2067,  3218,  2974,  3395,  1486,  3397,
    1099,  2085,   442,  1318,  1156,  1318,  1162,  2184,  1679,   430,
    2898,  1680,  1318,   503,  1950,  1316,  2932,   670,  1317,  3384,
    2936,  1314,  1315,  1314,  1315,  1056,  2098,  2099,  3514,  2974,
    2357,  2280,  3363,  2100,  2101,  2933,  2229,  -340,  2896,  2937,
    1375,  1318,  3364,  1464,  1057,  2674,  1316,  1318,  2923,  1317,
    2024,   391,  1318,  1314,  1315,  3008,   770,  2885,  1854,  2384,
    2907,  2386,  2104,  2105,  1621,  2951,  2391,  3450,  2065,  3452,
     565,  2398,  3468,  2111,  2112,  1497,  1318,  1784,  1621,  1498,
    1318,   394,  2409,  3325,  2411,  2412,  2416,  3009,  2493,  2494,
     469,  3326,   435,  1314,  1315,  3385,  1318,  2116,  2117,  1936,
    1920,  2119,  2120,  2126,  1318,  3033,   587,  1375,  2948,  2025,
    1314,  1315,  3090,  1819,  1465,   783,  1020,  2121,  2122,  2667,
    3386,  1917,  3506,  3091,  1318,  2201,  2370,   387,  1948,   387,
    1887,  1922,  3534,  3169,  1925,  1926,  3174,  1318,   834,  1314,
    1315,  1774,  1903,  1961,  1020,  2133,  2134,  1318,   826,  1318,
    2399,  1316,   387,  1318,  1317,  1862,  1863,   826,   387,  1469,
    1469,   566,  1318,  2776,  2657,  2249,   670,  1318,  2137,  2138,
    2150,  2151,  2250,  1825,  2154,  2155,   448,  1622,  1855,  1316,
    1378,  1888,  1317,  1318,  3048,  1318,  1861,  2626,  2156,  2157,
    3134,  1645,  3044,  1314,  1315,   387,  1880,   387,  1621,   387,
    3092,  1813,  3175,  2230,  2335,  2064,  2164,  2165,  1114,  1115,
    2026,   387,   387,  1821,  1887,  2579,   810,  1318,  1621,  2231,
    1906,   387,   387,  1088,  3034,  1150,  2696,   567,  1314,  1315,
    1372,  1089,   387,   470,  1559,  2354,  1314,  1315,  2167,  2168,
    1314,  1315,  2400, -1375,  3365,  2606,  1983,  3151,  1318,  3339,
    1316,  1904,  2203,  1317,   387,   387,   387,   387,  1621,  2526,
     455,  1758,  1018,  3655,   387,  1316,   387,  2609,  1317,  2176,
    2177,    40,   387,  2222,  1104,  1314,  1315,  2486,  1459,  1460,
     456,  2027,  2491,  1954,  1461,  1462,  1466,   831,  1470,   590,
    2525,  3327,  1018,  1104,   387,  1105,  1476,  2499,  1314,  1315,
    1307,   472,  3152,   723,  2504,  2668,   473,  1509,  3127,  3128,
    1316,  1703,   856,  1317,  1105,  2235,   958,  1872,  3141,  2513,
    2514,   856,  1485,  2697,  2242,  2692,  2518,  3121,  2676,  1125,
    1126,  1707,  2574,   443,  2523,  1780,  1194,  3315,  1856,   387,
    2223,  2581,   387,  2022,  2023,  1194,  2030,   709,  2032,  2033,
    2034,  2035,  2036,  1318,  2038,  2039,  2468,  1316,  3275,  1316,
    1317,  1509,  1317,   991,  3463,  3205,   502,  1568,  2942,  1314,
    1315,  1740,  1061,  2541,  2189,  2190,   479,  1808,  1314,  1315,
     525,  1318,  3366,   591,  1314,  1315, -1375,   474,  3035,  1316,
     692,   387,  1317,   387,   387,   387,  1195,   387,   484,  3314,
    1809,   583,  2208,  2209,  2396,  1279,   387,  -540,   387,  3482,
    1525,   710,  1314,  1315,    51,   489,   959,  1526,  1599,  1600,
     106, -1969,  2425,  2648,  2249,  1602,  1049,  1527,  1528,  1316,
     724,  2634,  1317,  1314,  1315,  2554,  1062,  1314,  1315,   485,
    2295,  2649,   387,  1662,  2589,  1045,  1316,   592,  1984,  1317,
    2495,  2045,  1318,  2028,  2944,  2944,  2944,  1529,  2500,   864,
    3043,  1530,  3220,  1314,  1315,  1314,  1315,  1318,   494,  3036,
    2046, -2001,  1531,  2210,  2211,  1316,  2418,  2419,  1317,  3283,
    1050,  1532,   387,  1969,  3396,  1046,  3398,  1533,  2575,  2576,
     826,  1314,  1315,  1314,  1315,  1314,  1315,  1625,   495,   826,
    1534,  1314,  1315,   107,  3295,  3296,  1314,  1315,  3206,   712,
     713,   960,  1318,   498,  1781,  1085,  2420,  2224,  1535,  1373,
    1314,  1315,  3439,   396,  3440,  1314,  1315,  1536,  1537,  1316,
    2296,  3153,  1317,  1538,  2082,  1314,  1315,  2214,  2421,   500,
     387,  1539,  2971,  1810,   509,  3148,  1625,  1540,  3545,  1314,
    1315,  2215,  2800,  2801,  2972,   387,  1626,   511,  3635,  1318,
    2881,  1318,  3567,   399,  1316,  1314,  1315,  1317,  2973,  2650,
    2422,   519,  1316,  1541,  3636,  1317,  1316,   618,  2977,  1317,
    2828,  2829,  2832,  2833,   556,  1314,  1315,  3148,   108,  1314,
    1315,  1318,   573,  1627,   451,  1314,  1315,  2966,   452,   577,
    2969,  2970,   521,  1758,   523,  1626,   524,   397,   526,  2284,
     661,  1316,  2854,  2855,  1317,   387,   587,  2987,   934,  1542,
     387,  1543,   387,   109,  1314,  1315,  1445,   387,  1544,  2985,
     680,  1318,  2986,   387,  1316,   387,  1932,  1317,  1314,  1315,
     387,   387,  1627,   387,  1314,  1315,  -508,   117,  1318,   118,
    1314,  1315,  2878,  2879,   856,   387,  1758,  1628,   387,  2253,
    2254,  2303,  2352,   856,   387,   387,   387,   387,  1831,  1831,
    2083,  1831,   419,  1330,   387,   387,   387,  1318,  1194,   559,
     432,  1782,  1758,  1853,   935,   438,   965,  1194,  2407,   618,
     619,   436,   387,  1446,   977,  1865,  1545,  1783,  3231,  3232,
     691,   387,  1831,  1831,  1831,  1316,  1628, -1107,  1317,  3259,
    1811,  1546,  3362,   692,  1316,  2821,  1547,  1317,   387,   915,
    1316,  3586,   950,  1317,   701,   936,  1314,  1315,  1629,   387,
    2316,  1318,  2320,  2325,   721,  3567,  1314,  1315,  1283,   106,
     937,   387,  1971,  2387,  2388,  1974,   906,   387,  1316,  1133,
    2578,  1317,  3414,  3415,  1986,   909,  1548,  1924,  2443,  2444,
    1314,  1315,  1549,  1994,  2410,  1550,  1318,  1933,   117,  1316,
     118,  2877,  1317,  1316,  1318,  1942,  1317,  1629,  1318,  2389,
    1447,  2363,  2316,   110,  1934,  1314,  1315,  2076,  1551,  1552,
     931,  1553, -1107,  2585,   618,   619,  2086,  1935,  2423,  1316,
    2091,  1316,  1317,  1514,  1317,  1554,   387,  3260,  3261,  2615,
    2616,  3262,  3263,  1318,   916,   387,   933,  1017,  2700,  2701,
    1314,  1315,  3466,   461,  1314,  1315,   938,  1555,  3477,  1316,
    3535,  1316,  1317,   940,  1317,  1017,  1318,  1316,  3049,  3402,
    1317,   949,  1316,  3671,   387,  1317,  2771,  2701, -1107,   951,
     948,  1134,   387,   387,  1135,   109,  1316,   963,  2092,  1317,
    1333,  1316,   964,   950,  1317,   462,   983,  1136,  2048,   972,
    1448,  1316,  1936, -1107,  1317,   984, -1107,  1314,  1315,   398,
    2056,  2058,  2960,  1099,  1758,  1316,  1872,   988,  1317,  1330,
    2609,  1314,  1315,   987,  -569,   991,  1314,  1315,   994, -1107,
    1630,  1316,  1872,  1002,  1317, -1107,  2316,  1318,  1873,  3070,
    1003,  1556,  1008,  2316,  -265,   399,  1318,  2852, -1107,  1004,
    1557,  1316,  1318, -1107,  1317,  1316,  1314,  1315,  1317,  2095,
   -1107,  1316,  1009, -1107,  1317,  1018,   463,  1023,  2102,  1024,
   -1107,   993,  3021,  3022,  2103,  2654,   400,  3099,  3100,  1630,
    1318,  1314,  1315, -1107,  3222,  3223,   401, -1107,  1025,  1394,
    1316,  1020,  1395,  1317,  1937,  1396, -1107,  1314,  1315,  1314,
    1315,  1318,  2107,  1026,  1316,  1318,  1027,  1317,  1052,  -540,
    1316,  1028,  2656,  1317,  1053,  -540,  1316,  3228,  3229,  1317,
     951,  1874,  1875,  2109,  1137,   659,   660,  2110,   663,  1314,
    1315,  1318,  1066,  1318,  1069,  2605,  1068,  1874,  1875,  1071,
    2594,  2595,  2596,  2946,  2947,  1314,  1315, -1107,   387,  1938,
    3297,  3223,  1469,  2114,  1085,  2115,  3377,  3378, -1107,  2612,
    1095,  1318,  1076,  1318,  1314,  1315,  1096,  2974,  1142,  1318,
   -1107,  2620,  2621,  2622,  1318,  1876, -1107,  1143, -1107,  1314,
    1315,  2647,  1144,  2124,  2572,  2128, -1107,  1146,  1318,  2978,
    2748,  2129,  1316,  1318, -1107,  1317,  2131,  1148,  2632,  3380,
    3223, -1107,  1316,  1318,  3084,  1317,  1333,  1138, -1107,  1149,
    2132, -1107,  1314,  1315,  1150,  2136,  1154,  1318,  3381,  3223,
     388,  1314,  1315,  1163, -1107,  2139,  1316,   670, -1107,  1317,
    1314,  1315,   418,  1318,  1165,   424,  1167, -1107,  1168,  2140,
    3389,  3390,   433,  1169,  1343,  1344,  1345,  1346,  1170,   387,
   -1107,  1316,   444,  1318,  1317,  2152,  1171,  1318,  3391,  3392,
    1314,  1315,   460,  1318,  1173,  1314,  1315,   387,   387,  1834,
   -1107,  1835,  1314,  1315,   387,  2166,   387,   387,  1174,  2173,
    1175,  1932,  1314,  1315,  1172,  2174,  1316,  2690,  1176,  1317,
    1316,  1177,  1318,  1317,  2693,   464,  1178,  1314,  1315, -1107,
     478,  1179,  1882,  1883,  1884, -1107,  1318,  3393,  3392,  1374,
    1314,  1315,  1318,   387,  2175,  1314,  1315,   465,  1318, -1107,
     481,   388,  1180,   388,  1181,   387,   387, -1107,  2178,  1182,
    1314,  1315,  1377,  2080,   478,   387,  3479,  3378,  1379,  2699,
    2182,   387,   466,  1316,   387,  1183,  1317,   387,  2316, -1107,
   -1107,  1387,  3123,  1314,  1315,  3480,  3378,  1316,   387,   387,
    1317,   387,  1316, -1107, -1107,  1317,  1184,   387,   387,   674,
     675,  1185,   676,  1186,   677,  3167,  3168,   387,  1189,   387,
   -1107,  1191, -1107,   387,   387,  1384,  1314,  1315,  3661,  3662,
     467, -1107,  1316,  3178,  1318,  1317,  1744,  1745,  1388,  3182,
    3298,  3299,  2887,  2888,  1318,  2417,  2910,  2911, -1107, -1107,
    1192, -1107,  1933,  1314,  1315, -1107,  2185,  1316,  1314,  1315,
    1317,  1193,  3198,   387,   387,  3200,  2202,  1197,  1318,  1934,
    1314,  1315,  1198,  1316,  1199,  1316,  1317,  1200,  1317,  3032,
    1625,  1201,  2660,  1202,  2408,  1203, -1107,  3097,  3098,  2853,
     387,  2453,  1204,  1318,  1205,  1314,  1315,   387,  1341,  1342,
    1343,  1344,  1345,  1346,  1206,  1316,  1391,  1207,  1317,  1208,
     387,  1758,  1209,  1389,  1210,  2798,  3349,  3350,  3351,  3352,
    3344,  1316,  1314,  1315,  1317,  1211,  1212,  1213,  1318,  1214,
    1215, -1107,  1318,  1314,  1315,  1216,  1217,  1314,  1315,  1626,
    1316,  1218,  2906,  1317,  1219, -1107,  1314,  1315,  1314,  1315,
    2808,  1220,  1409,  1410,  2814,  1316,   387,  1936,  1317,  1221,
    1222, -1107,  1413, -1107,  1314,  1315,  1314,  1315,  1314,  1315,
    1223,  1224,  1225,  1227,  1228,  1229,  1627,  1314,  1315,  1314,
    1315,  1230,  1231,  1314,  1315,  1318,  1232,  1233,  1316, -1107,
   -1107,  1317,  1234,  1235,  1236,  1240, -1107,  1316,  2585,  1318,
    1317,  1241,  1314,  1315,  1318,  1415,  1316,  2823,  1242,  1317,
    1314,  1315,  1243,  1244,  1245,  3346,  1246,  1314,  1315,  1314,
    1315,  2824,  1758,  1247,  1421,  1248,  2846,  2915,  1249,  1250,
    1251,  1253,  1314,  1315,  1318,  1255,  1316,  1256,   387,  1317,
    1628,  1316,  1257,  2363,  1317,  1314,  1315,  1258,  1316,  1937,
    1259,  1317,  1260,  1261,  1314,  1315,  2856,  1262,  1316,  1318,
    1263,  1317,  1264,   387,   522,  1314,  1315,   387,  1265,   387,
     387,   387,   387,  1316,   555,  1318,  1317,  1318,   563,  1422,
     387,  2858,  1266,   478,   387,  1267,  1316,   387,   582,  1317,
    1268,  1316,  1314,  1315,  1317,  1423,  1269,  2859,   993,  3238,
    1270,   387,   387,   387,  1938,  1271,  1316,  1318,  1853,  1317,
     478,  1629,  1272,  1273,   387,  1274,  1314,  1315,  1275,  1276,
     387,  1277,   387,  1318,  1281,  1282,  1285,   681,  2090,  1316,
     387,  1286,  1317,  1314,  1315,  1290,  1291,   478,  1292,  1296,
    1297,   478,  1318,  1424,  2093,  1298,  1299,   703,  1300,   478,
     478,  1301,  1314,  1315,   715,   563,  1376,  1318,  1392,  1314,
    1315,  1430,  1316,  2094,   734,  1317,  1438,  1444,   739,  1453,
     561,  1473,  1457,   907,   388,  1478,   388,   388,   563,   478,
    1479,  1480,  1758,  1314,  1315,  1481,  1483,  1491,  3645,  1316,
    1318,   387,  1317,  1493,  1316,  1314,  1315,  1317,  1495,  1318,
    1507,  1572,   387,  1758,  1573,   387,  1316,  1574,  1318,  1317,
    3234,  2113,   955,  1575,  1576,  1314,  1315,  3582,  1577,  1758,
    2127,  1578,  1196,  1280,  1284,  3645,  1579,  1580,   478,  2130,
    1581,  1316,  1582,  1583,  1317,  1584,   563,   478,  1318,   387,
    1585,   478,  1586,  1318,  1587,  1588,   387,  1589,   478,   387,
    1318,  1314,  1315,   387,   387,  1590,  1591,   387,  1316,  2146,
    1318,  1317,  1314,  1315,  2147,  3122,  3318,   387,  1595,  1316,
    1597,  2153,  1317,  1316,  1609,  1318,  1317,  2703,   563,  1314,
    1315,  2161,  1316,  1630,  1316,  1317,  1601,  1317,  1318,  1610,
    1614,  1372,  1621,  1318,  1649,  2769,  2162,  1289,  1314,  1315,
    1316,  1669,  1316,  1317,  1316,  1317,  1683,  1317,  1318,  2163,
    1625,  3112,  1700,  1316,  2171,  1316,  1317,  3313,  1317,  1316,
    3328,  3329,  1317,  1314,  1315,  1764,  1732,  1755,  1770,  2172,
    3313,  1318,  1790,  3184,  1314,  1315,  1084,  1775,  1316,  1822,
    1812,  1317,  1823,  3172,   563,  1796,  1316,   478,  1847,  1317,
    1102,   478,  2179,  1316,  1850,  1316,  1317,  1881,  1317,  1314,
    1315,  1895,  1907,  1909,  1318,  1916,  1314,  1315,  1316,  1626,
    1919,  1317,  1940,  1941,  2316,  1944,  1314,  1315,  1314,  1315,
    1945,  1316,  1947,  1960,  1317,  2188,   478,  1955,   478,  1956,
    1316,  1318,  1961,  1317,  2363,  1957,  1318,  1978,  1314,  1315,
    3394,  1316,  1314,  1315,  1317,  1958,  1627,  1959,  1318,  1314,
    1315,  1979,  2193,  1981,  1987,  2562,  1982,  2204,  1990,  1989,
    1314,  1315,  2303,  1995,  1314,  1315,  1314,  1315,  1316,   387,
     387,  1317,   387,  1318,  1314,  1315,  1314,  1315,  2009,  2059,
    2062,   387,  1314,  1315,  1314,  1315,   993,   387,  3406,  2069,
    2089,  2071,  1316,  2072,  2212,  1317,  1516,   387,  1314,  1315,
    1318,  2073,  2074,  2079,  2081,   387,  2088,  2096,  1517,  1316,
    1628,  1318,  1317,  2108,  2097,  1318,  1314,  1315,  2106,  2118,
    2135,  2780,   387,  2123,  1318,  2141,  1318,  2142,  1316,  1314,
    1315,  1317,  2781,  2145,   387,  1316,  2782,  2149,  1317,  2143,
    2191,   387,  1318,  2158,  1318,  2795,  1318,  2803,   387,  2238,
    2252,  2159,  2915,  2160,   387,  1318,  2169,  1318,  2192,  1316,
    2226,  1318,  1317,  2804,  2180,  2807,  2257,  2809,  1314,  1315,
    2181,  1316,  1314,  1315,  1317,  2187,  2812,  1311,  2813,  1313,
    1318,  1629,  2815,  3451,  1314,  1315,  2583,  2205,  1318,  3334,
    2206,  1316,  2207,  -773,  1317,  1318,  2232,  1318,  1346,  2241,
    1099,  2816,   478,  2258,  -949,   602,  1314,  1315,   478,  2817,
    1318,  2316,  1314,  1315,  2255,  2265,  2818,  2256,  2826,  3470,
    3471,  2267,  3473,  1318,  1314,  1315,  2413,  1316,   387,  2414,
    1317,  2827,  1318,  2475,  2259,  1314,  1315,  2269,  1316,  2270,
    2275,  1317,  2271,  1318,  2830,  1402,  2287,  1405,  2288,   478,
    2289,  2290,  1888,  2837,  1887,  1316,  3696,  2476,  1317,  1330,
    2332,   478,   563,  3510,  2838,  3511,  3512,  2336,  2307,  1518,
    1318,   478,   478,  2308,  1316,  2309,  2342,  1317,  2333,  2340,
    2341,  2358,  1434,  2365,  2366,  2392,  2393,  2426,  2445,  1509,
    1443,  2839,  3557,  2441,  1318,  2440,  1330,  2446,  2477,  1316,
    2505,  2478,  1317,  2472,   388,   388,   478,   478,  2492,  2479,
    1316,  1318,  1615,  1317,   388,  2840,   563,   802,   603,  2565,
    2515,  2559,   388,  2527,  3403,  2528,  2547,   387,  2567,  2592,
    1318,  3551,  2841,  2568,  2599,  1316,  3557,  1318,  1317,  1519,
    2569,  2570,  1316,  2571,   478,  1317,  2577,  2584,  3598, -1003,
     387,  2842,  1316,  1630,  1316,  1317,  2597,  1317,  2843,  2603,
    1330,  1318,  2611,  1520,  2614,   387,  3459,  2619,  2617,  3590,
    2630,  2631,  2636,  1318,  1316,  2644,  2661,  1317,  1316,  2655,
    2665,  1317,  2844,  2666,  2556,  1316,  2669,  2681,  1317,   478,
    2682,  2761,   478,  1318,  2845,  2768,  1316,   604,  2695,  1317,
    1316,  2764,  1316,  1317,  2770,  1317,   387,  2772,  2775,  3628,
    1316,  2777,  1316,  1317,  2847,  1317,  2790,  1521,  1316,  2792,
    1316,  1317,  2783,  1317,  3639,  2786,  2791,  2793,   387,  1318,
    2794,  2796,  2797,  3652,  1316,  2802,  1353,  1317,  2805,  2250,
    1318,   563,  2806,   563,   388,   388,  1333,   478,   387,  2810,
    2848,  2811,  1316,  2819,  2825,  1317,   739,  1318,  1616,  2822,
    2831,  2851,  2874,  2849,  2872,  1316,  2868,  3679,  1317,  3680,
    2876,  2893,  2880,   387,  2994,   387,  1318,  2883,  3507,  -339,
    2884,  2908,  2895,  1333,  2897,   387,  1872,  2924,  1961,  1522,
    2916,   387,  1656,  2928,  2931,  2925,  2934,  2857,   409,  2929,
    1962,  1318,  2935,  2949,  1316,  1354,  2953,  1317,  1316,  2954,
    2955,  1317,  1318,  3211,  2963,  2995,  2967,  2964,  2992,  2996,
    1316,  3040,  2860,  1317,  3014,  3015,  3017,  2480,  3050,  3020,
    3054,  3055,  1656,  2862,  3052,  3056,  3061,  1318,   387,  3459,
    1358,  3059,  1316,  3066,  1318,  1317,  2316,  1333,  1316,  3067,
    3068,  1317,  3079,  3083,  1318,  3095,  1318,  3108,  2864,  3102,
    1316,  3106,  2997,  1317,  3100,  2866,   387,  3109,  2634,  3113,
    3117,  1316,  1335,  1336,  1317,  2867,  1318,  2869,  3114,  3119,
    1318,  3124,  3120,   410, -1037, -1042,   387,  1318,  3133,  3135,
    1759,  -339,   387,   387,  3139,  3140,  3158,  2870,  1318,  1963,
    3159,  3076,  1318,  3166,  1318,   563,   387,  3011,  3077,  1335,
    1336,  3585,  1318,  3008,  1318,  3177,  1932,  3181,  3188,  3078,
    1318,   411,  1318,  3230,  1932,   387,  3179,  3189,  3190,  3192,
    3687,  3193,  3203,  3233,  3194,  3237,  1318,  1362,  1104,  3195,
    3196,  3239,  3197,  3240,  2481,  1363,  3199,  3212,   605,   606,
     607,   608,   609,   610,  1318,  3687,  3208,  3243,  3242,  1105,
    3209,  3225,  3236,   387,   611,   563,  3241,  1318,  3254,  3226,
    1817,  3227,   563,  1335,  1336,  3245,   387,   563,  1932,  3235,
    3244,  3660,  3250,   478,  3252,  1827,  3267,  1330,  3246,  -474,
    1832,  1832,  3255,  1832,  3256,  2482,  1339,  1340,  1341,  1342,
    1343,  1344,  1345,  1346,  3276,   478,  1318,  3282,   478,  3279,
    1318,  1364,  3285,  3287,   563,   563,   478,   478,  3291,  3319,
    3280,  3320,  1318,  2483,  1832,  1832,  1832,  3247,  3309,  3310,
    3317,  3248,  3333,  1339,  1340,  1341,  1342,  1343,  1344,  1345,
    1346,  3321,  1899,  3249,  1318,  3322,  3323,  1933,  3324,  3335,
    1318,  1910,  3229,  3341,  3342,  1933,  3336,  2785,  3338,  1366,
    3348,  2789,  1318,  3354,  1934,  3417,  3355,  3371,  1918,  3369,
    3399,  3504,  1934,  1318,   -55,  1516,  3400,  1935,   412,   478,
    3374,  3376,  3401,   712,   713,  1935,  3379,  1517,  2998,   387,
    2834,  1931,  3412,  -339,  3426,  2999,  3413,   478,  1340,  1341,
    1342,  1343,  1344,  1345,  1346,  3416,  3418,   387,   387,  1933,
    3428,  3429,  3430,  3431,   119,  3437,  1527,  1528,  2436,   392,
     393,  3445,  3453,  3000,  3454,  3455,  1934,   387,  3456,   387,
    3461,   387,   387,  3472,  3465,  3462,  3422,   431,  3481,  1935,
    3474,  3475,   437,   387,  2444,  3513,   441,  3483,  -460,  -460,
    1530,  -211,  1936,  3502,  3532,  3537,  2015,  -460,  1321,  1322,
    1936,  1531,  3538,  3539,  3545,  2019, -1167,  3561,  3562,  3563,
    1532,  1964,  3125,  3580,  1333,  1367,  1527,  1528,  3573,   387,
    3129,  3584,  3581,  3586,  3591,  3001,  3592,  1369,  3595,  1534,
     413,  3596,  3602,  3612,   388, -1772,  3620,  1323,  3625,  3627,
    3624,  3630,   478,   478,  1085,   414,   918,  1535,  -460,  -460,
    1530,  1324,  3631,  3499,  1936,  3632,  3633,  -460,   387,  3640,
    3646,  1531,  3651,  3637,  3653,  3656,   487,  3657,  3658,  3667,
    1532,   415,   747,  3669,  3372,  3676,  1540,   387,  -339,  3690,
    3499,  3499,   387,  3695,  1937,  1325,   416,  2251,  1518,  1534,
    1092,  2041,  1937,  3577,  3408,  3337,  3697,  1326,  3331,  3672,
     387,  3678,  3609,  3610,  1085,  3568,  3219,  1535,  3002,  3576,
    1594,   387,   510,  3293,  3042,  2008,  2961,  2457,  2012,  1965,
    2437,  3499,  3499,  2377,  1327,  2956,  3499,  2979,  2965,  2980,
    3018,   919,  3311,  3150,  3191,  3183,  1540,  2957,  3142,  1938,
    1335,  1336,  3499,  1330,  3499,   770,  1937,  1938,  2922,  3448,
    1543,  3444,  3308,  1836,  3340,  3388,  3316,  1544,  1519,  2427,
    3499,  1608,  2989,  2990,   747,  1494,  2272,  1103,  1330,  3499,
    2993,  1929,  1837,  1592,  1864,  2602,   387,  3016,  2291,   712,
     713,  1328,  1520,  3499,  1081,   387,  3499,   678,  2268,   920,
     998,  3253,  1838,  3356,  3499,  1886,   781,  3086,  3085,  2930,
    3499,  1938,  2489,  3443,   783,  1699,  1839,  1647,  2227,  2582,
    1543,  3290,  2959,   921,  3604,  3499,  3278,  1544,   387,  2298,
     387,  3499,  2057,  1408,  3499,  1545,   387,  1426,  2264,  2278,
    3142,  3104,  3499,  2941,  2901,   387,  1521,   770,  2900,   387,
    1546,   798,  3663,   667,  2063,  3499,  2170,   740,  3505,  2835,
     653,  1840,  1841,  1613,  1921,   387,  1428,  2894,  3499,  3556,
    3499,   387,  3432,  3476,  1339,  1340,  1341,  1342,  1343,  1344,
    1345,  1346,  3499,  3499,  3677,  1824,  3499,  3578,  3187,  1842,
    2904,  1896,  2652,  2926,  3118,  1545,   387,  1442,   781,  3281,
    1433,  1549,   598,  1858,  1550,   986,   783,  3347,  1598,   922,
    1546,  1401,  2591,   600,  3353,   810,   990,   923,  1522,  2285,
    3251,   693,  1155,  1766,  3039,  2452,  3217,  1551,  1552,     0,
    1553,     0,     0,     0,     0,     0,     0,  2304,  2306,     0,
    1333,     0,     0,   798,   563,   924,   563,   563,  1843,     1,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     2,
       3,  1549,     0,     0,  1550,  1333,  1555,     0,     0,     0,
       0,     0,     4,   826,     5,     0,     0,   527,     0,     0,
       0,   925,  3185,  1759,     0,   830,   831,  1551,  1552,  1844,
    1553,     0,   576,     6,     7,   563,   563,     0,   585,     8,
       0,     0,   926,     9,    10,  2015,     0,   810,     0,     0,
       0,  2015,     0,     0,  2015,     0,    11,  2015,   666,   927,
       0,   118,     0,     0,     0,     0,  1555,     0,  2015,  2015,
       0,   563,  3492,    12,     0,     0,     0,  2015,  1759,     0,
       0,     0,     0,     0,     0,     0,     0,   478,     0,   563,
    1556,     0,    13,  2015,  2432,  1527,  1528,     0,     0,  1557,
       0,    14,    15,    16,     0,   826,  1335,  1336,     0,     0,
       0,     0,     0,     0,    17,    18,     0,   830,   831,     0,
       0,     0,  1330,     0,   530,   531,     0,  -460,  -460,  1530,
       0,  1335,  1336,   478,  2015,     0,  -460,    19,     0,     0,
    1531,     0,     0,     0,     0,  3554,     0,     0,     0,  1532,
    1556,     0,     0,     0,    20,     0,     0,     0,  2462,  1557,
     563,  3572,     0,  3572,     0,     0,     0,   563,  1534,   887,
       0,     0,     0,     0,     0,     0,     0,   856,    21,  3143,
    2496,     0,  3144,  1085,     0,    22,  1535,     0,    23,     0,
       0,  1330,   862,     0,     0,     0,     0,     0,   864,   532,
       0,   865,  3572,     0,     0,  3619,     0,     0,     0,    24,
       0,     0,     0,  3623,     0,  1540,     0,     0,     0,     0,
       0,     0,   957,     0,     0,    25,  1656,   533,     0,     0,
    1339,  1340,  1341,  1342,  1343,  1344,  1345,  1346,     0,     0,
    3572,   534,     0,    26,     0,     0,     0,     0,    27,     0,
       0,  3572,     0,  3145,  3146,  1339,  1340,  1341,  1342,  1343,
    1344,  1345,  1346,   535,  3572,     0,     0,     0,     0,   856,
       0,  3143,     0,     0,  3144,   536,     0,     0,   596,   531,
       0,     0,     0,     0,   862,  1953,     0,     0,     0,  1543,
     864,  3572,  3572,   865,  1331,  3694,  1544,  1972,  1973,     0,
    1975,  1976,  1977,     0,   537,  1980,     0,     0,   563,  1333,
    1988,     0,     0,     0,  1991,  1992,  1993,  1332,     0,  1996,
    1997,  1998,  1999,  2000,  2050,  2005,  2006,  2007,     0,   538,
       0,     0,     0,  2590,    28,   539,     0,  1827,     0,   955,
     563,   563,   563,     0,     0,  3145,  3146,     0,     0,     0,
     478,     0,  1111,   532,   563,     0,    29,  1759,     0,     0,
       0,     0,     0,     0,  1545,    30,     0,     0,     0,     0,
       0,   563,   563,   563,   540,     0,   531,     0,  1333,  1546,
       0,   533,     0,     0,  2633,    31,     0,    32,    33,     0,
    2635,    34,  2637,     0,    35,   534,    36,   712,   713,     0,
     563,    37,     0,    38,     0,     0,     0,     0,     0,     0,
       0,     0,    39,     0,     0,     0,    40,   535,     0,     0,
       0,     0,    41,     0,     0,     0,     0,    42,     0,   536,
    1549,    43,     0,  1550,     0,  1335,  1336,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     532,    44,     0,  1226,     0,    45,  1551,  1552,   537,  1553,
    1334,  2015,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   563,     0,     0,  2015,     0,     0,   533,  1252,
       0,     0,     0,   538,     0,     0,     0,   541,     0,   539,
       0,    46,   534,     0,     0,  1555,     0,     0,     0,     0,
       0,     0,     0,     0,  1335,  1336,   542,    47,     0,   478,
      48,     0,   543,  1337,   535,    49,  2702,     0,   544,   478,
       0,     0,     0,  2758,  2759,     0,   536,  2762,   540,  1302,
       0,     0,     0,  1309,     0,     0,     0,   478,    50,     0,
       0,     0,   545,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   546,   547,   537,     0,     0,     0,    51,
       0,  1341,  1342,  1343,  1344,  1345,  1346,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1556,
     538,     0,     0,     0,     0,     0,   539,     0,  1557,     0,
     548,  1112,  1113,  1114,  1115,  1116,  1117,     0,     0,  1118,
    1119,  1120,  1121,  1122,  1123,     0,  1124,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   540,     0,  1338,  1339,  1340,
    1341,  1342,  1343,  1344,  1345,  1346,   549,     0,   550,     0,
       0,   541,     0,     0,     0,  2051,     0,     0,  1441,     0,
       0,     0,     0,     0,     0,     0,     0,  1456,     0,     0,
     542,     0,     0,     0,     0,     0,   543,     0,     0,     0,
       0,     0,   544,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   545,     0,     0,  2285,
    2905,     0,   563,     0,     0,     0,     0,   546,   547,     0,
       0,   563,     0,     0,  1125,  1126,     0,  2590,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   563,     0,     0,
       0,     0,     0,     0,     0,  1899,     0,     0,   541,     0,
       0,     0,     0,     0,   548,     0,     0,     0,     0,  2390,
       0,     0,  1759,     0,     0,     0,     0,   542,     0,     0,
    2397,     0,     0,   543,  2015,     0,     0,     0,     0,   544,
       0,  2015,     0,     0,     0,     0,     0,     0,  1759,     0,
       0,     0,     0,     0,  2015,     0,     0,     0,     0,     0,
     549,     0,   550,   545,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   546,   547,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1618,  1619,
    1620,     0,     0,     0,     0,     0,     0,  1635,  1636,     0,
       0,  1639,     0,  1641,  1642,  1643,  1644,     0,     0,     0,
    1648,   548,     0,  1650,  1651,     0,  1652,     0,  1653,  1654,
       0,  1657,  1658,  1659,  1660,  1661,     0,  1664,  3047,  1666,
    1667,  1668,     0,  1670,  1671,  1672,  1673,     0,  1675,  1676,
       0,  1682,     0,     0,  1686,  1687,  1688,     0,  1690,  1691,
    1692,  1693,     0,  1695,  1696,  1697,  1698,   549,     0,   550,
       0,     0,  1705,  1706,     0,  1709,  1710,  1711,  1712,  1713,
       0,     0,     0,     0,  1717,     0,  1718,  1719,  1720,  1721,
    1722,     0,     0,  1725,  1727,  1728,  1729,  1730,  1731,     0,
    1733,  1734,     0,     0,  1737,  1738,  1739,     0,  1742,     0,
    1743,     0,     0,     0,  1746,     0,  1750,  1751,     0,     0,
       0,     0,  1754,     0,     0,     0,     0,     0,     0,     0,
    1761,  1762,  1763,     0,     0,     0,     0,  3082,     0,  1309,
       0,     0,  1771,     0,     2,     3,     0,     0,     0,  1776,
    1777,  1778,     0,     0,     0,     0,     0,     4,     0,     0,
    1759,     0,     0,     0,     0,     0,     0,     0,  1349,  1350,
    1351,  1352,  1353,     0,     0,   563,     0,     0,     6,     7,
       0,     0,     0,     0,     8,     0,     0,     0,     9,    10,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    11,     0,     0,     0,  1815,     0,     0,     0,     0,
       0,  2704,  2705,     0,     0,     0,  3047,  2706,    12,  2707,
       0,  2708,  2709,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2710,    13,   563,     0,
       0,  1354,     0,     0,     0,     0,    14,    15,    16,  1860,
       0,     0,     0,     0,     0,     0,     0,     0,   563,    17,
      18,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1355,  1356,  1357,  1358,  2711,     0,     0,
    2712,     0,    19,  3201,     0,  3202,     0,     0,  2713,     0,
       0,     0,     0,     0,     0,   478,     0,     0,     0,    20,
       0,  3216,     0,     0,     0,     0,     0,  2714,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    21,  2715,     0,     0,     0,     0,     0,
      22,     0,     0,    23,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1525,  2716,     0,  2717,  2304,     0,
       0,  1526,     0,     0,    24,     0,     0,     0,     0,     0,
       0,  1527,  1528,     0,     0,     0,  2718,  2719,     0,  1359,
      25,  1360,  1361,  1362,     0,     0,   563,     0,     0,     0,
       0,  1363,     0,     0,     0,     0,     0,     0,    26,     0,
       0,  1529,     0,    27,     0,  1530,  3289,     0,     0,     0,
       0,     0,  3047,  3047,     0,  2020,  1531,  2720,     0,     0,
       0,     0,     0,     0,     0,  1532,  3307,     0,     0,     0,
       0,  1533,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1534,   563,  2721,     0,     0,     0,
       0,     0,     0,     0,     0,  2722,  2723,  1364,  2724,  1085,
       0,     0,  1535,     0,     0,     0,     0,     0,     0,     0,
       0,  1536,     0,     0,     0,     0,     0,  1538,     0,     0,
       0,     0,     0,  3332,     0,  1539,  2725,  2726,  2727,    28,
       0,  1540,     0,     0,     0,     0,  3047,     0,     0,     0,
       0,     0,     0,     0,  1365,  1366,     0,  2728,  2729,  2730,
       0,    29,     0,  2731,     0,     0,  2732,  1541,     0,     0,
      30,     0,     0,     0,     0,     0,     0,     0,     0,  2733,
    2734,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      31,     0,    32,    33,     0,     0,    34,     0,     0,    35,
       0,    36,     0,     0,     0,  2735,    37,  2736,    38,     0,
       0,     0,     0,     0,     0,  1543,     0,    39,     0,     0,
       0,    40,  1544,     0,     0,     0,     0,    41,     0,     0,
       0,  2737,    42,     0,     0,     0,    43,     0,  2195,  2197,
    2199,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2213,    44,     0,     0,  3216,
      45,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1367,     0,     0,  2738,     0,  2739,  1759,   478,     0,
       0,  2233,  1368,  1369,     0,     0,  2740,     0,     0,     0,
    1545,     0,     0,     0,     0,     0,    46,  3289,     0,  3289,
       0,  3441,  2019,  2245,     0,  1546,     0,     0,     0,     0,
    1547,     0,    47,  3449,     0,    48,     0,     0,     0,     0,
      49,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2741,  2742,     0,     0,  2743,  2744,  2745,  2746,     0,     0,
       0,     0,     0,    50,     0,     0,     0,     0,     0,  3469,
    1548,     0,     0,     0,     0,     0,  1549,     0,     0,  1550,
       0,     0,     0,     0,    51,     0,     0,     0,     0,  1527,
    1528,     0,     0,     0,     0,     0,     0,  2747,  2748,     0,
       0,     0,  1551,  1552,     0,  1553,     0,     0,  1759,     0,
       0,     0,     0,     0,     0,     0,  2749,     0,     0,  1554,
       0,     0,     0,  1530,     0,     0,     0,  3515,     0,     0,
       0,     0,  3522,     0,  1531,     0,     0,     0,     0,     0,
       0,  1555,     0,  1532,     0,     0,     0,     0,     0,     0,
     563,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3540,  1534,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1085,     0,     0,
    1535,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1540,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1556,  3606,     0,     0,     0,
       0,     0,     0,     0,  1557,  3617,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1759,     0,
    3648,     0,     0,     0,     0,  2470,  3654,     0,  2471,     0,
       0,  2473,  2474,  1543,     0,   563,     0,     0,     0,  1759,
    1544,     0,     0,     0,  2487,     0,     0,  2490,     0,     0,
       0,     0,     0,     0,     0,  1759,     0,     0,     0,     0,
    2497,  3688,  2498,     0,     0,     0,  2501,     0,  2502,  2503,
       0,     0,     0,  2506,     0,  2507,  2508,     0,  2509,     0,
       0,  2510,     0,  2511,  2512,     0,  3688,     0,     0,  2516,
    2517,     0,     0,  2519,     0,  2520,     0,  2521,     0,  2522,
       0,  2524,     0,     0,     0,     0,     0,     0,  1545,     0,
       0,     0,  2529,  2530,     0,     0,  2531,     0,  2532,     0,
       0,     0,     0,  1546,     0,     0,  2533,  2534,     0,  2535,
       0,  2536,     0,     0,  2537,  2538,  2539,     0,  2540,     0,
       0,     0,     0,  2543,  2544,  2545,  2546,     0,     0,     0,
       0,  2548,  2549,  2550,     0,  2551,     0,  2553,     0,  2555,
       0,  2557,     0,  2558,     0,     0,     0,     0,     0,     0,
    2560,     0,  2561,     0,  1549,  2563,  2564,  1550,     0,     0,
       0,   616,     0,   578,   617,     0,     0,  2573,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1551,  1552,  2580,  1553,     0,     0,   618,   619,     0,     0,
       0,     0,     0,     0,     0,     0,   620,     0,   621,     0,
       0,     0,  2598,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   622,     0,   623,  1555,
    3501,     0,     0,     0,     0,     0,   624,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3501,  3501,     0,
       0,  2642,     0,     0,     0,     0,  2646,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -1353,   625,     0,     0,     0,   626,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3501,  3501,
       0,     0,     0,  3501,     0,     0,     0,     0,     0,     0,
    2677,     0,     0,  1556,     0,     0,     0,     0,   627,  3501,
     628,  3501,  1557,     0,  2680,     0,     0,     0,     0,     0,
       0,     0,   629,     0,   630,     0,     0,  3501,     0,     0,
       0,     0,     0,     0,     0,     0,  3501,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   631,   632,     0,
    3501,   633,     0,  3501,     0,     0,     0,     0,     0,     0,
       0,  3501,     0,     0,     0,     0,     0,  3501,   634,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3501,     0,     0,     0,     0,     0,  3501,   635,
       0,  3501,     0,     0,   636,     0,     0,     0,     0,  3501,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2779,     0,  3501,     0,     0,     0,     0,     0,   637,     0,
       0,     0,     0,     0,     0,  3501,     0,  3501,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3501,
    3501,     0,     0,  3501,     0,     0,     0,     0,     0,     0,
       0,   638,     0,     0,     0,     0,     0,     0,     0,     0,
     639,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   640,     0,
       0,     0,     0,  2850,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2861,     0,  2863,     0,  2865,     0,     0,
       0,     0,     0,  2871,   641,   642,     0,     0,   643,   644,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2882,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   645,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   646,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2927,     0,     0, -1797,     0,     0,
       0,   647,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   648,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -1797,     0,     0,     0,   649,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3053,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3057,
       0,     0,     0,     0,     0,  3058,     0,     0,     0,     0,
       0,     0,     0,     0,  3062,  3063,     0,     0,     0,     0,
    3064,     0,     0,     0,  3065,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3069,     0,     0,
       0,     0,     0,  3071,     0,     0,  3072,  3073,     0,  3074,
    3075,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3080,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3131,
    3132,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2677,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2677,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2642,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3343,     0,     0,     0,     0,     0,  3345,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3361,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3373,     0,  3375,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2677,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3464,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3478,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3543,  3544,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3564,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3575,     0,     0,     0,     0,  3579,     0,
       0,     0,     0,     0,     0,     0,     0,  3589,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   122,     0,   741,
     124,   125,   126,   127,     0,     0,     0,     0,  3621,   128,
       0,     0,   742,     0,   743,   130,   131,   744,   133,  3629,
     134,   745,   135,     0,   746,   136,   747,   748,   749,   137,
     750,     0,   138,   139,   140,  1747,   141,     0,   142,   143,
       0,     0,   144,   751,   145,     0,   146,   752,   753,   148,
       0,   149,   150,   151,   754,   152,     0,   755,   154,     0,
     155,   156,   157,   158,   159,   756,   757,   160,     0,   161,
     162,     0,   758,   164,     0,   759,   760,   761,   165,     0,
    3689,   166,   762,   763,     0,   764,   765,     0,   167,   168,
     766,   767,   768,     0,     0,     0,     0,   769,   171,   770,
       0,     0,   771,   772,   172,     0,   173,     0,     0,     0,
     773,   774,   174,     0,   175,   176,   177,     0,     0,     0,
     178,     0,     0,   179,   180,   181,     0,     0,   775,   182,
       0,   776,   777,   183,   184,   185,   186,     0,     0,   187,
       0,   188,   189,   190,   778,     0,   191,   779,   192,   780,
     781,   193,   194,     0,   782,   195,   196,   197,   783,     0,
     198,     0,     0,   784,     0,   199,   200,     0,   785,   201,
       0,   202,   786,   787,   788,   789,     0,   790,   791,   204,
     792,   793,   794,   206,     0,   207,   795,     0,   796,   797,
       0,   208,   209,     0,   210,   798,     0,   211,     0,     0,
       0,   799,   213,   214,   215,   800,     0,   216,   217,     0,
       0,     0,   218,     0,     0,   801,   219,   802,     0,     0,
     220,     0,   221,   222,     0,   223,   224,     0,     0,     0,
       0,     0,     0,   225,   803,   226,     0,  1748,   804,   227,
       0,   805,   228,     0,     0,     0,   806,     0,   807,     0,
     230,   808,     0,   231,     0,   232,   809,     0,     0,   810,
       0,     0,     0,     0,   811,   233,   234,   235,   236,   237,
     238,   812,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   813,   248,   249,   250,   814,   251,   252,     0,     0,
       0,   253,   254,   255,   815,   257,     0,     0,   816,   259,
     817,   818,   260,     0,   261,   819,   820,   821,   822,   823,
     824,   825,   266,   267,   268,   269,     0,   826,   270,   271,
       0,   272,   273,   274,   827,   828,   829,   275,     0,   830,
     831,     0,   276,   277,     0,   832,     0,   279,   280,   281,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     282,   283,   284,   833,   834,   286,   835,   836,   837,   838,
     839,     0,   289,   290,     0,   291,     0,   292,   293,   294,
     295,     0,   840,   297,   298,   299,   300,   301,   302,   303,
     841,     0,     0,     0,   304,   305,     0,     0,   306,   307,
     308,     0,   309,     0,   310,   311,   842,   843,   312,     0,
     313,   314,   315,     0,   316,   317,     0,     0,   844,   318,
     319,   845,   320,   321,   846,   322,   847,   324,   325,     0,
     848,   327,     0,     0,     0,   328,   329,   330,     0,     0,
     331,     0,     0,     0,   332,   333,   334,   335,     0,   336,
     337,   338,     0,     0,     0,     0,     0,     0,   339,   340,
       0,   341,     0,     0,   342,     0,     0,   343,   344,   849,
     850,   345,   346,     0,   347,   851,   349,   852,   853,   854,
     350,   351,   352,   353,   855,   354,   355,     0,   356,   357,
       0,   856,   358,   857,   858,   859,   860,     0,     0,     0,
       0,  1749,   363,     0,   364,   861,   862,   863,   366,   367,
     368,     0,   864,   369,   370,   865,     0,   371,     0,     0,
     866,   867,   372,     0,     0,   373,     0,   374,     0,   868,
     376,     0,     0,   869,   870,   871,   872,   873,   377,     0,
       0,   378,   874,     0,   379,   380,   875,     0,     0,     0,
       0,   382,     0,   383,   384,     0,   876,     0,   877,     0,
       0,     0,     0,   878,     0,     0,     0,   879,   880,     0,
       0,     0,     0,   881,     0,   882,     0,     0,   883,   884,
       0,   885,   886,   122,     0,   741,   124,   125,   126,   127,
    2638,     0,     0,     0,     0,   128,     0,     0,   742,     0,
     743,   130,   131,   744,   133,     0,   134,   745,   135,     0,
    2639,   136,   747,   748,   749,   137,   750,     0,   138,   139,
     140,     0,   141,     0,   142,   143,     0,     0,   144,   751,
     145,     0,   146,   752,   753,   148,     0,   149,   150,   151,
     754,   152,     0,   755,   154,     0,   155,   156,   157,   158,
     159,   756,   757,   160,     0,   161,   162,     0,   758,   164,
       0,   759,   760,   761,   165,     0,     0,   166,   762,   763,
       0,   764,   765,     0,   167,   168,   766,   767,   768,     0,
       0,     0,     0,   769,   171,   770,     0,     0,   771,  2640,
     172,     0,   173,     0,     0,     0,   773,   774,   174,     0,
     175,   176,   177,     0,     0,     0,   178,     0,     0,   179,
     180,   181,     0,     0,   775,   182,     0,   776,   777,   183,
     184,   185,   186,     0,     0,   187,     0,   188,   189,   190,
     778,     0,   191,   779,   192,   780,   781,   193,   194,     0,
     782,   195,   196,   197,   783,     0,   198,     0,     0,   784,
       0,   199,   200,     0,   785,   201,     0,   202,   786,   787,
     788,   789,     0,   790,   791,   204,   792,   793,   794,   206,
       0,   207,   795,     0,   796,   797,     0,   208,   209,     0,
     210,   798,     0,   211,     0,     0,     0,   799,   213,   214,
     215,   800,     0,   216,   217,     0,     0,     0,   218,     0,
       0,   801,   219,   802,     0,     0,   220,     0,   221,   222,
       0,   223,   224,     0,     0,     0,     0,     0,     0,   225,
     803,   226,     0,     0,   804,   227,     0,   805,   228,     0,
       0,     0,   806,     0,   807,     0,   230,   808,     0,   231,
       0,   232,   809,     0,     0,   810,     0,     0,     0,     0,
     811,   233,   234,   235,   236,   237,   238,   812,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   813,   248,   249,
     250,   814,   251,   252,     0,     0,     0,   253,   254,   255,
     815,   257,     0,     0,   816,   259,   817,   818,   260,     0,
     261,   819,   820,   821,   822,   823,   824,   825,   266,   267,
     268,   269,     0,   826,   270,   271,     0,   272,   273,   274,
     827,   828,   829,   275,     0,   830,   831,     0,   276,   277,
       0,   832,  2641,   279,   280,   281,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   282,   283,   284,   833,
     834,   286,   835,   836,   837,   838,   839,     0,   289,   290,
       0,   291,     0,   292,   293,   294,   295,     0,   840,   297,
     298,   299,   300,   301,   302,   303,   841,     0,     0,     0,
     304,   305,     0,     0,   306,   307,   308,     0,   309,     0,
     310,   311,   842,   843,   312,     0,   313,   314,   315,     0,
     316,   317,     0,     0,   844,   318,   319,   845,   320,   321,
     846,   322,   847,   324,   325,     0,   848,   327,     0,     0,
       0,   328,   329,   330,     0,     0,   331,     0,     0,     0,
     332,   333,   334,   335,     0,   336,   337,   338,     0,     0,
       0,     0,     0,     0,   339,   340,     0,   341,     0,     0,
     342,     0,     0,   343,   344,   849,   850,   345,   346,     0,
     347,   851,   349,   852,   853,   854,   350,   351,   352,   353,
     855,   354,   355,     0,   356,   357,     0,   856,   358,   857,
     858,   859,   860,     0,     0,     0,     0,     0,   363,     0,
     364,   861,   862,   863,   366,   367,   368,     0,   864,   369,
     370,   865,     0,   371,     0,     0,   866,   867,   372,     0,
       0,   373,     0,   374,     0,   868,   376,     0,     0,   869,
     870,   871,   872,   873,   377,     0,     0,   378,   874,     0,
     379,   380,   875,     0,     0,     0,     0,   382,     0,   383,
     384,     0,   876,     0,   877,     0,     0,     0,     0,   878,
       0,     0,     0,   879,   880,     0,     0,     0,     0,   881,
       0,   882,     0,     0,   883,   884,     0,   885,   886,   122,
       0,   741,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   742,     0,   743,   130,   131,   744,
     133,     0,   134,   745,   135,     0,   746,   136,   747,   748,
     749,   137,   750,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,   751,   145,     0,   146,   752,
     753,   148,     0,   149,   150,   151,   754,   152,     0,   755,
     154,     0,   155,   156,   157,   158,   159,   756,   757,   160,
       0,   161,   162,     0,   758,   164,     0,   759,   760,   761,
     165,     0,     0,   166,   762,   763,     0,   764,   765,     0,
     167,   168,   766,   767,   768,     0,     0,     0,     0,   769,
     171,   770,     0,     0,   771,   772,   172,     0,   173,     0,
       0,     0,   773,   774,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
     775,   182,     0,   776,   777,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,   778,     0,   191,   779,
     192,   780,   781,   193,   194,     0,   782,   195,   196,   197,
     783,     0,   198,     0,     0,   784,     0,   199,   200,     0,
     785,   201,     0,   202,   786,   787,   788,   789,     0,   790,
     791,   204,   792,   793,   794,   206,     0,   207,   795,     0,
     796,   797,     0,   208,   209,     0,   210,   798,     0,   211,
       0,     0,     0,   799,   213,   214,   215,   800,     0,   216,
     217,     0,     0,     0,   218,     0,     0,   801,   219,   802,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,   803,   226,     0,     0,
     804,   227,     0,   805,   228,     0,     0,     0,   806,     0,
     807,     0,   230,   808,     0,   231,     0,   232,   809,     0,
       0,   810,     0,     0,     0,     0,   811,   233,   234,   235,
     236,   237,   238,   812,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   813,   248,   249,   250,   814,   251,   252,
       0,     0,     0,   253,   254,   255,   815,   257,     0,     0,
     816,   259,   817,   818,   260,     0,   261,   819,   820,   821,
     822,   823,   824,   825,   266,   267,   268,   269,     0,   826,
     270,   271,     0,   272,   273,   274,   827,   828,   829,   275,
       0,   830,   831,     0,   276,   277,     0,   832,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   833,   834,   286,   835,   836,
     837,   838,   839,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   840,   297,   298,   299,   300,   301,
     302,   303,   841,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,   842,   843,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
     844,   318,   319,   845,   320,   321,   846,   322,   847,   324,
     325,     0,   848,   327,  1307,     0,     0,   328,   329,   330,
       0,     0,   331,     0,     0,     0,   332,   333,   334,   335,
       0,   336,   337,   338,     0,     0,     0,     0,     0,     0,
     339,   340,     0,   341,     0,     0,   342,     0,     0,   343,
     344,   849,   850,   345,   346,     0,   347,   851,   349,   852,
     853,   854,   350,   351,   352,   353,   855,   354,   355,     0,
     356,   357,     0,   856,   358,   857,   858,   859,   860,     0,
       0,     0,     0,     0,   363,     0,   364,   861,   862,   863,
     366,   367,   368,     0,   864,   369,   370,   865,     0,   371,
       0,     0,   866,   867,   372,     0,     0,   373,     0,   374,
       0,   868,   376,     0,     0,   869,   870,   871,   872,   873,
     377,     0,     0,   378,   874,     0,   379,   380,   875,     0,
       0,     0,     0,   382,     0,   383,   384,     0,   876,     0,
     877,     0,     0,     0,     0,   878,     0,     0,     0,   879,
     880,     0,     0,     0,     0,   881,     0,  1308,     0,     0,
     883,   884,     0,   885,   886,   122,     0,   741,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     742,     0,   743,   130,   131,   744,   133,     0,   134,   745,
     135,     0,   746,   136,   747,   748,   749,   137,   750,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,   751,   145,     0,   146,   752,   753,   148,     0,   149,
     150,   151,   754,   152,     0,   755,   154,     0,   155,   156,
     157,   158,   159,   756,   757,   160,     0,   161,   162,     0,
     758,   164,     0,   759,   760,   761,   165,     0,     0,   166,
     762,   763,     0,   764,   765,     0,   167,   168,   766,   767,
     768,     0,     0,     0,     0,   769,   171,   770,     0,     0,
     771,   772,   172,     0,   173,     0,     0,     0,   773,   774,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,   775,   182,     0,   776,
     777,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,   778,     0,   191,   779,   192,   780,   781,   193,
     194,     0,   782,   195,   196,   197,   783,     0,   198,     0,
       0,   784,     0,   199,   200,     0,   785,   201,     0,   202,
     786,   787,   788,   789,     0,   790,   791,   204,   792,   793,
     794,   206,     0,   207,   795,     0,   796,   797,     0,   208,
     209,     0,   210,   798,     0,   211,     0,     0,     0,   799,
     213,   214,   215,   800,     0,   216,   217,     0,     0,     0,
     218,     0,     0,   801,   219,   802,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,   803,   226,     0,     0,   804,   227,     0,   805,
     228,     0,     0,     0,   806,     0,   807,     0,   230,   808,
       0,   231,     0,   232,   809,     0,     0,   810,     0,     0,
       0,     0,   811,   233,   234,   235,   236,   237,   238,   812,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   813,
     248,   249,   250,   814,   251,   252,     0,     0,     0,   253,
     254,   255,   815,   257,     0,     0,   816,   259,   817,   818,
     260,     0,   261,   819,   820,   821,   822,   823,   824,   825,
     266,   267,   268,   269,     0,   826,   270,   271,     0,   272,
     273,   274,   827,   828,   829,   275,     0,   830,   831,     0,
     276,   277,     0,   832,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   833,   834,   286,   835,   836,   837,   838,   839,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     840,   297,   298,   299,   300,   301,   302,   303,   841,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,   842,   843,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,   844,   318,   319,   845,
     320,   321,   846,   322,   847,   324,   325,     0,   848,   327,
       0,     0,     0,   328,   329,   330,     0,     0,   331,     0,
       0,     0,   332,   333,   334,   335,     0,   336,   337,   338,
       0,     0,     0,     0,     0,     0,   339,   340,     0,   341,
       0,     0,   342,     0,     0,   343,   344,   849,   850,   345,
     346,     0,   347,   851,   349,   852,   853,   854,   350,   351,
     352,   353,   855,   354,   355,     0,   356,   357,     0,   856,
     358,   857,   858,   859,   860,     0,     0,     0,     0,     0,
     363,     0,   364,   861,   862,   863,   366,   367,   368,     0,
     864,   369,   370,   865,     0,   371,     0,     0,   866,   867,
     372,     0,     0,   373,     0,   374,     0,   868,   376,     0,
       0,   869,   870,   871,   872,   873,   377,     0,     0,   378,
     874,     0,   379,   380,   875,     0,     0,     0,     0,   382,
       0,   383,   384,     0,   876,     0,   877,     0,     0,     0,
       0,   878,     0,     0,     0,   879,   880,     0,     0,     0,
       0,   881,     0,   882,  1595,     0,   883,   884,     0,   885,
     886,   122,     0,   741,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   742,     0,   743,   130,
     131,   744,   133,     0,   134,   745,   135,     0,   746,   136,
     747,   748,   749,   137,   750,     0,   138,   139,   140,     0,
     141,     0,   142,   143,     0,     0,   144,   751,   145,     0,
     146,   752,   753,   148,     0,   149,   150,   151,   754,   152,
       0,   755,   154,     0,   155,   156,   157,   158,   159,   756,
     757,   160,     0,   161,   162,     0,   758,   164,     0,   759,
     760,   761,   165,     0,     0,   166,   762,   763,     0,   764,
     765,     0,   167,   168,   766,   767,   768,     0,     0,     0,
       0,   769,   171,   770,     0,     0,   771,   772,   172,     0,
     173,     0,     0,     0,   773,   774,   174,     0,   175,   176,
     177,     0,     0,     0,   178,     0,     0,   179,   180,   181,
       0,     0,   775,   182,     0,   776,   777,   183,   184,   185,
     186,     0,     0,   187,     0,   188,   189,   190,   778,     0,
     191,   779,   192,   780,   781,   193,   194,     0,   782,   195,
     196,   197,   783,     0,   198,     0,     0,   784,     0,   199,
     200,     0,   785,   201,     0,   202,   786,   787,   788,   789,
       0,   790,   791,   204,   792,   793,   794,   206,     0,   207,
     795,     0,   796,   797,     0,   208,   209,     0,   210,   798,
       0,   211,     0,     0,     0,   799,   213,   214,   215,   800,
       0,   216,   217,     0,     0,     0,   218,     0,     0,   801,
     219,   802,     0,     0,   220,     0,   221,   222,     0,   223,
     224,     0,     0,     0,     0,     0,     0,   225,   803,   226,
       0,     0,   804,   227,     0,   805,   228,     0,     0,     0,
     806,     0,   807,     0,   230,   808,     0,   231,     0,   232,
     809,     0,     0,   810,     0,     0,     0,     0,   811,   233,
     234,   235,   236,   237,   238,   812,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   813,   248,   249,   250,   814,
     251,   252,     0,     0,     0,   253,   254,   255,   815,   257,
       0,     0,   816,   259,   817,   818,   260,     0,   261,   819,
     820,   821,   822,   823,   824,   825,   266,   267,   268,   269,
       0,   826,   270,   271,     0,   272,   273,   274,   827,   828,
     829,   275,     0,   830,   831,     0,   276,   277,     0,   832,
       0,   279,   280,   281,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   833,   834,   286,
     835,   836,   837,   838,   839,     0,   289,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   840,   297,   298,   299,
     300,   301,   302,   303,   841,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,   310,   311,
     842,   843,   312,     0,   313,   314,   315,     0,   316,   317,
       0,     0,   844,   318,   319,   845,   320,   321,   846,   322,
     847,   324,   325,     0,   848,   327,     0,     0,     0,   328,
     329,   330,     0,     0,   331,     0,     0,     0,   332,   333,
     334,   335,     0,   336,   337,   338,     0,     0,     0,     0,
       0,     0,   339,   340,     0,   341,     0,     0,   342,     0,
       0,   343,   344,   849,   850,   345,   346,     0,   347,   851,
     349,   852,   853,   854,   350,   351,   352,   353,   855,   354,
     355,     0,   356,   357,     0,   856,   358,   857,   858,   859,
     860,     0,     0,     0,     0,     0,   363,     0,   364,   861,
     862,   863,   366,   367,   368,     0,   864,   369,   370,   865,
       0,   371,     0,     0,   866,   867,   372,     0,     0,   373,
       0,   374,     0,   868,   376,     0,     0,   869,   870,   871,
     872,   873,   377,     0,     0,   378,   874,     0,   379,   380,
     875,     0,     0,     0,     0,   382,     0,   383,   384,     0,
     876,     0,   877,     0,     0,     0,     0,   878,     0,     0,
       0,   879,   880,     0,     0,     0,     0,   881,     0,   882,
    1689,     0,   883,   884,     0,   885,   886,   122,     0,   741,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   742,     0,   743,   130,   131,   744,   133,     0,
     134,   745,   135,     0,   746,   136,   747,   748,   749,   137,
     750,     0,   138,   139,   140,     0,   141,     0,   142,   143,
       0,     0,   144,   751,   145,     0,   146,   752,   753,   148,
       0,   149,   150,   151,   754,   152,     0,   755,   154,     0,
     155,   156,   157,   158,   159,   756,   757,   160,     0,   161,
     162,     0,   758,   164,     0,   759,   760,   761,   165,     0,
       0,   166,   762,   763,     0,   764,   765,     0,   167,   168,
     766,   767,   768,     0,     0,     0,     0,   769,   171,   770,
       0,     0,   771,   772,   172,     0,   173,     0,     0,     0,
     773,   774,   174,     0,   175,   176,   177,     0,     0,     0,
     178,     0,     0,   179,   180,   181,     0,     0,   775,   182,
       0,   776,   777,   183,   184,   185,   186,     0,     0,   187,
       0,   188,   189,   190,   778,     0,   191,   779,   192,   780,
     781,   193,   194,     0,   782,   195,   196,   197,   783,     0,
     198,     0,     0,   784,     0,   199,   200,     0,   785,   201,
       0,   202,   786,   787,   788,   789,     0,   790,   791,   204,
     792,   793,   794,   206,     0,   207,   795,     0,   796,   797,
       0,   208,   209,     0,   210,   798,     0,   211,     0,     0,
       0,   799,   213,   214,   215,   800,     0,   216,   217,     0,
       0,     0,   218,     0,     0,   801,   219,   802,     0,     0,
     220,     0,   221,   222,     0,   223,   224,     0,     0,     0,
       0,     0,     0,   225,   803,   226,     0,     0,   804,   227,
       0,   805,   228,     0,     0,     0,   806,     0,   807,     0,
     230,   808,     0,   231,     0,   232,   809,     0,     0,   810,
       0,     0,     0,     0,   811,   233,   234,   235,   236,   237,
     238,   812,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   813,   248,   249,   250,   814,   251,   252,     0,     0,
       0,   253,   254,   255,   815,   257,     0,     0,   816,   259,
     817,   818,   260,     0,   261,   819,   820,   821,   822,   823,
     824,   825,   266,   267,   268,   269,     0,   826,   270,   271,
       0,   272,   273,   274,   827,   828,   829,   275,     0,   830,
     831,     0,   276,   277,     0,   832,     0,   279,   280,   281,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     282,   283,   284,   833,   834,   286,   835,   836,   837,   838,
     839,     0,   289,   290,     0,   291,     0,   292,   293,   294,
     295,     0,   840,   297,   298,   299,   300,   301,   302,   303,
     841,     0,     0,     0,   304,   305,     0,     0,   306,   307,
     308,     0,   309,     0,   310,   311,   842,   843,   312,     0,
     313,   314,   315,     0,   316,   317,     0,     0,   844,   318,
     319,   845,   320,   321,   846,   322,   847,   324,   325,     0,
     848,   327,     0,     0,     0,   328,   329,   330,     0,     0,
     331,     0,     0,     0,   332,   333,   334,   335,     0,   336,
     337,   338,     0,     0,     0,     0,     0,     0,   339,   340,
       0,   341,     0,     0,   342,     0,     0,   343,   344,   849,
     850,   345,   346,     0,   347,   851,   349,   852,   853,   854,
     350,   351,   352,   353,   855,   354,   355,     0,   356,   357,
       0,   856,   358,   857,   858,   859,   860,     0,     0,     0,
       0,     0,   363,     0,   364,   861,   862,   863,   366,   367,
     368,     0,   864,   369,   370,   865,     0,   371,     0,     0,
     866,   867,   372,     0,     0,   373,     0,   374,     0,   868,
     376,     0,     0,   869,   870,   871,   872,   873,   377,     0,
       0,   378,   874,     0,   379,   380,   875,     0,     0,     0,
       0,   382,     0,   383,   384,     0,   876,     0,   877,     0,
       0,     0,     0,   878,     0,     0,     0,   879,   880,     0,
       0,     0,     0,   881,     0,   882,  1726,     0,   883,   884,
       0,   885,   886,   122,     0,   741,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   742,     0,
     743,   130,   131,   744,   133,     0,   134,   745,   135,     0,
     746,   136,   747,   748,   749,   137,   750,     0,   138,   139,
     140,     0,   141,     0,   142,   143,     0,     0,   144,   751,
     145,     0,   146,   752,   753,   148,     0,   149,   150,   151,
     754,   152,     0,   755,   154,     0,   155,   156,   157,   158,
     159,   756,   757,   160,     0,   161,   162,     0,   758,   164,
       0,   759,   760,   761,   165,     0,     0,   166,   762,   763,
       0,   764,   765,     0,   167,   168,   766,   767,   768,     0,
       0,     0,     0,   769,   171,   770,     0,     0,   771,   772,
     172,     0,   173,     0,     0,     0,   773,   774,   174,     0,
     175,   176,   177,     0,     0,     0,   178,     0,     0,   179,
     180,   181,     0,     0,   775,   182,     0,   776,   777,   183,
     184,   185,   186,     0,     0,   187,     0,   188,   189,   190,
     778,     0,   191,   779,   192,   780,   781,   193,   194,     0,
     782,   195,   196,   197,   783,     0,   198,     0,     0,   784,
       0,   199,   200,     0,   785,   201,     0,   202,   786,   787,
     788,   789,     0,   790,   791,   204,   792,   793,   794,   206,
       0,   207,   795,     0,   796,   797,     0,   208,   209,     0,
     210,   798,     0,   211,     0,     0,     0,   799,   213,   214,
     215,   800,     0,   216,   217,     0,     0,     0,   218,     0,
       0,   801,   219,   802,     0,     0,   220,     0,   221,   222,
       0,   223,   224,     0,     0,     0,     0,     0,     0,   225,
     803,   226,     0,     0,   804,   227,     0,   805,   228,     0,
       0,     0,   806,     0,   807,     0,   230,   808,     0,   231,
       0,   232,   809,     0,     0,   810,     0,     0,     0,     0,
     811,   233,   234,   235,   236,   237,   238,   812,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   813,   248,   249,
     250,   814,   251,   252,     0,     0,     0,   253,   254,   255,
     815,   257,     0,     0,   816,   259,   817,   818,   260,     0,
     261,   819,   820,   821,   822,   823,   824,   825,   266,   267,
     268,   269,     0,   826,   270,   271,     0,   272,   273,   274,
     827,   828,   829,   275,     0,   830,   831,     0,   276,   277,
       0,   832,     0,   279,   280,   281,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   282,   283,   284,   833,
     834,   286,   835,   836,   837,   838,   839,     0,   289,   290,
       0,   291,     0,   292,   293,   294,   295,     0,   840,   297,
     298,   299,   300,   301,   302,   303,   841,     0,     0,     0,
     304,   305,     0,     0,   306,   307,   308,     0,   309,     0,
     310,   311,   842,   843,   312,     0,   313,   314,   315,     0,
     316,   317,     0,     0,   844,   318,   319,   845,   320,   321,
     846,   322,   847,   324,   325,     0,   848,   327,     0,     0,
       0,   328,   329,   330,     0,     0,   331,     0,     0,     0,
     332,   333,   334,   335,     0,   336,   337,   338,     0,     0,
       0,     0,     0,     0,   339,   340,     0,   341,     0,     0,
     342,     0,     0,   343,   344,   849,   850,   345,   346,     0,
     347,   851,   349,   852,   853,   854,   350,   351,   352,   353,
     855,   354,   355,     0,   356,   357,     0,   856,   358,   857,
     858,   859,   860,     0,     0,     0,     0,     0,   363,     0,
     364,   861,   862,   863,   366,   367,   368,     0,   864,   369,
     370,   865,     0,   371,     0,     0,   866,   867,   372,     0,
       0,   373,     0,   374,     0,   868,   376,     0,     0,   869,
     870,   871,   872,   873,   377,     0,     0,   378,   874,     0,
     379,   380,   875,     0,     0,     0,     0,   382,     0,   383,
     384,     0,   876,     0,   877,     0,     0,     0,     0,   878,
       0,     0,     0,   879,   880,     0,     0,     0,     0,   881,
       0,   882,  1753,     0,   883,   884,     0,   885,   886,   122,
       0,   741,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   742,     0,   743,   130,   131,   744,
     133,     0,   134,   745,   135,     0,   746,   136,   747,   748,
     749,   137,   750,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,   751,   145,     0,   146,   752,
     753,   148,     0,   149,   150,   151,   754,   152,     0,   755,
     154,     0,   155,   156,   157,   158,   159,   756,   757,   160,
       0,   161,   162,     0,   758,   164,     0,   759,   760,   761,
     165,     0,     0,   166,   762,   763,     0,   764,   765,     0,
     167,   168,   766,   767,   768,     0,     0,     0,     0,   769,
     171,   770,     0,     0,   771,   772,   172,     0,   173,     0,
       0,     0,   773,   774,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
     775,   182,     0,   776,   777,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,   778,     0,   191,   779,
     192,   780,   781,   193,   194,     0,   782,   195,   196,   197,
     783,     0,   198,     0,     0,   784,     0,   199,   200,  2194,
     785,   201,     0,   202,   786,   787,   788,   789,     0,   790,
     791,   204,   792,   793,   794,   206,     0,   207,   795,     0,
     796,   797,     0,   208,   209,     0,   210,   798,     0,   211,
       0,     0,     0,   799,   213,   214,   215,   800,     0,   216,
     217,     0,     0,     0,   218,     0,     0,   801,   219,   802,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,   803,   226,     0,     0,
     804,   227,     0,   805,   228,     0,     0,     0,   806,     0,
     807,     0,   230,   808,     0,   231,     0,   232,   809,     0,
       0,   810,     0,     0,     0,     0,   811,   233,   234,   235,
     236,   237,   238,   812,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   813,   248,   249,   250,   814,   251,   252,
       0,     0,     0,   253,   254,   255,   815,   257,     0,     0,
     816,   259,   817,   818,   260,     0,   261,   819,   820,   821,
     822,   823,   824,   825,   266,   267,   268,   269,     0,   826,
     270,   271,     0,   272,   273,   274,   827,   828,   829,   275,
       0,   830,   831,     0,   276,   277,     0,   832,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   833,   834,   286,   835,   836,
     837,   838,   839,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   840,   297,   298,   299,   300,   301,
     302,   303,   841,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,   842,   843,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
     844,   318,   319,   845,   320,   321,   846,   322,   847,   324,
     325,     0,   848,   327,     0,     0,     0,   328,   329,   330,
       0,     0,   331,     0,     0,     0,   332,   333,   334,   335,
       0,   336,   337,   338,     0,     0,     0,     0,     0,     0,
     339,   340,     0,   341,     0,     0,   342,     0,     0,   343,
     344,   849,   850,   345,   346,     0,   347,   851,   349,   852,
     853,   854,   350,   351,   352,   353,   855,   354,   355,     0,
     356,   357,     0,   856,   358,   857,   858,   859,   860,     0,
       0,     0,     0,     0,   363,     0,   364,   861,   862,   863,
     366,   367,   368,     0,   864,   369,   370,   865,     0,   371,
       0,     0,   866,   867,   372,     0,     0,   373,     0,   374,
       0,   868,   376,     0,     0,   869,   870,   871,   872,   873,
     377,     0,     0,   378,   874,     0,   379,   380,   875,     0,
       0,     0,     0,   382,     0,   383,   384,     0,   876,     0,
     877,     0,     0,     0,     0,   878,     0,     0,     0,   879,
     880,     0,     0,     0,     0,   881,     0,   882,     0,     0,
     883,   884,     0,   885,   886,   122,     0,   741,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     742,     0,   743,   130,   131,   744,   133,     0,   134,   745,
     135,     0,   746,   136,   747,   748,   749,   137,   750,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,   751,   145,     0,   146,   752,   753,   148,     0,   149,
     150,   151,   754,   152,     0,   755,   154,     0,   155,   156,
     157,   158,   159,   756,   757,   160,     0,   161,   162,     0,
     758,   164,     0,   759,   760,   761,   165,     0,     0,   166,
     762,   763,     0,   764,   765,     0,   167,   168,   766,   767,
     768,     0,     0,     0,     0,   769,   171,   770,     0,     0,
     771,   772,   172,     0,   173,     0,     0,     0,   773,   774,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,   775,   182,     0,   776,
     777,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,   778,     0,   191,   779,   192,   780,   781,   193,
     194,     0,   782,   195,   196,   197,   783,     0,   198,     0,
       0,   784,     0,   199,   200,  2196,   785,   201,     0,   202,
     786,   787,   788,   789,     0,   790,   791,   204,   792,   793,
     794,   206,     0,   207,   795,     0,   796,   797,     0,   208,
     209,     0,   210,   798,     0,   211,     0,     0,     0,   799,
     213,   214,   215,   800,     0,   216,   217,     0,     0,     0,
     218,     0,     0,   801,   219,   802,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,   803,   226,     0,     0,   804,   227,     0,   805,
     228,     0,     0,     0,   806,     0,   807,     0,   230,   808,
       0,   231,     0,   232,   809,     0,     0,   810,     0,     0,
       0,     0,   811,   233,   234,   235,   236,   237,   238,   812,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   813,
     248,   249,   250,   814,   251,   252,     0,     0,     0,   253,
     254,   255,   815,   257,     0,     0,   816,   259,   817,   818,
     260,     0,   261,   819,   820,   821,   822,   823,   824,   825,
     266,   267,   268,   269,     0,   826,   270,   271,     0,   272,
     273,   274,   827,   828,   829,   275,     0,   830,   831,     0,
     276,   277,     0,   832,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   833,   834,   286,   835,   836,   837,   838,   839,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     840,   297,   298,   299,   300,   301,   302,   303,   841,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,   842,   843,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,   844,   318,   319,   845,
     320,   321,   846,   322,   847,   324,   325,     0,   848,   327,
       0,     0,     0,   328,   329,   330,     0,     0,   331,     0,
       0,     0,   332,   333,   334,   335,     0,   336,   337,   338,
       0,     0,     0,     0,     0,     0,   339,   340,     0,   341,
       0,     0,   342,     0,     0,   343,   344,   849,   850,   345,
     346,     0,   347,   851,   349,   852,   853,   854,   350,   351,
     352,   353,   855,   354,   355,     0,   356,   357,     0,   856,
     358,   857,   858,   859,   860,     0,     0,     0,     0,     0,
     363,     0,   364,   861,   862,   863,   366,   367,   368,     0,
     864,   369,   370,   865,     0,   371,     0,     0,   866,   867,
     372,     0,     0,   373,     0,   374,     0,   868,   376,     0,
       0,   869,   870,   871,   872,   873,   377,     0,     0,   378,
     874,     0,   379,   380,   875,     0,     0,     0,     0,   382,
       0,   383,   384,     0,   876,     0,   877,     0,     0,     0,
       0,   878,     0,     0,     0,   879,   880,     0,     0,     0,
       0,   881,     0,   882,     0,     0,   883,   884,     0,   885,
     886,   122,     0,   741,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   742,     0,   743,   130,
     131,   744,   133,     0,   134,   745,   135,     0,   746,   136,
     747,   748,   749,   137,   750,     0,   138,   139,   140,     0,
     141,     0,   142,   143,     0,     0,   144,   751,   145,     0,
     146,   752,   753,   148,     0,   149,   150,   151,   754,   152,
       0,   755,   154,     0,   155,   156,   157,   158,   159,   756,
     757,   160,     0,   161,   162,     0,   758,   164,     0,   759,
     760,   761,   165,     0,     0,   166,   762,   763,     0,   764,
     765,     0,   167,   168,   766,   767,   768,     0,     0,     0,
       0,   769,   171,   770,     0,     0,   771,   772,   172,     0,
     173,     0,     0,     0,   773,   774,   174,     0,   175,   176,
     177,     0,     0,     0,   178,     0,     0,   179,   180,   181,
       0,     0,   775,   182,     0,   776,   777,   183,   184,   185,
     186,     0,     0,   187,     0,   188,   189,   190,   778,     0,
     191,   779,   192,   780,   781,   193,   194,     0,   782,   195,
     196,   197,   783,     0,   198,     0,     0,   784,     0,   199,
     200,  2198,   785,   201,     0,   202,   786,   787,   788,   789,
       0,   790,   791,   204,   792,   793,   794,   206,     0,   207,
     795,     0,   796,   797,     0,   208,   209,     0,   210,   798,
       0,   211,     0,     0,     0,   799,   213,   214,   215,   800,
       0,   216,   217,     0,     0,     0,   218,     0,     0,   801,
     219,   802,     0,     0,   220,     0,   221,   222,     0,   223,
     224,     0,     0,     0,     0,     0,     0,   225,   803,   226,
       0,     0,   804,   227,     0,   805,   228,     0,     0,     0,
     806,     0,   807,     0,   230,   808,     0,   231,     0,   232,
     809,     0,     0,   810,     0,     0,     0,     0,   811,   233,
     234,   235,   236,   237,   238,   812,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   813,   248,   249,   250,   814,
     251,   252,     0,     0,     0,   253,   254,   255,   815,   257,
       0,     0,   816,   259,   817,   818,   260,     0,   261,   819,
     820,   821,   822,   823,   824,   825,   266,   267,   268,   269,
       0,   826,   270,   271,     0,   272,   273,   274,   827,   828,
     829,   275,     0,   830,   831,     0,   276,   277,     0,   832,
       0,   279,   280,   281,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   833,   834,   286,
     835,   836,   837,   838,   839,     0,   289,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   840,   297,   298,   299,
     300,   301,   302,   303,   841,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,   310,   311,
     842,   843,   312,     0,   313,   314,   315,     0,   316,   317,
       0,     0,   844,   318,   319,   845,   320,   321,   846,   322,
     847,   324,   325,     0,   848,   327,     0,     0,     0,   328,
     329,   330,     0,     0,   331,     0,     0,     0,   332,   333,
     334,   335,     0,   336,   337,   338,     0,     0,     0,     0,
       0,     0,   339,   340,     0,   341,     0,     0,   342,     0,
       0,   343,   344,   849,   850,   345,   346,     0,   347,   851,
     349,   852,   853,   854,   350,   351,   352,   353,   855,   354,
     355,     0,   356,   357,     0,   856,   358,   857,   858,   859,
     860,     0,     0,     0,     0,     0,   363,     0,   364,   861,
     862,   863,   366,   367,   368,     0,   864,   369,   370,   865,
       0,   371,     0,     0,   866,   867,   372,     0,     0,   373,
       0,   374,     0,   868,   376,     0,     0,   869,   870,   871,
     872,   873,   377,     0,     0,   378,   874,     0,   379,   380,
     875,     0,     0,     0,     0,   382,     0,   383,   384,     0,
     876,     0,   877,     0,     0,     0,     0,   878,     0,     0,
       0,   879,   880,     0,     0,     0,     0,   881,     0,   882,
       0,     0,   883,   884,     0,   885,   886,   122,     0,   741,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   742,     0,   743,   130,   131,   744,   133,     0,
     134,   745,   135,     0,   746,   136,   747,   748,   749,   137,
     750,     0,   138,   139,   140,     0,   141,     0,   142,   143,
       0,     0,   144,   751,   145,     0,   146,   752,   753,   148,
       0,   149,   150,   151,   754,   152,     0,   755,   154,     0,
     155,   156,   157,   158,   159,   756,   757,   160,     0,   161,
     162,     0,   758,   164,     0,   759,   760,   761,   165,     0,
       0,   166,   762,   763,     0,   764,   765,     0,   167,   168,
     766,   767,   768,     0,     0,     0,     0,   769,   171,   770,
       0,     0,   771,   772,   172,     0,   173,     0,     0,     0,
     773,   774,   174,     0,   175,   176,   177,     0,     0,     0,
     178,     0,     0,   179,   180,   181,     0,     0,   775,   182,
       0,   776,   777,   183,   184,   185,   186,     0,     0,   187,
       0,   188,   189,   190,   778,     0,   191,   779,   192,   780,
     781,   193,   194,     0,   782,   195,   196,   197,   783,     0,
     198,     0,     0,   784,     0,   199,   200,     0,   785,   201,
       0,   202,   786,   787,   788,   789,     0,   790,   791,   204,
     792,   793,   794,   206,     0,   207,   795,     0,   796,   797,
       0,   208,   209,     0,   210,   798,     0,   211,     0,     0,
       0,   799,   213,   214,   215,   800,     0,   216,   217,     0,
       0,     0,   218,     0,     0,   801,   219,   802,     0,     0,
     220,     0,   221,   222,     0,   223,   224,     0,     0,     0,
       0,     0,     0,   225,   803,   226,     0,     0,   804,   227,
       0,   805,   228,     0,     0,     0,   806,     0,   807,     0,
     230,   808,     0,   231,     0,   232,   809,     0,     0,   810,
       0,     0,     0,     0,   811,   233,   234,   235,   236,   237,
     238,   812,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   813,   248,   249,   250,   814,   251,   252,     0,     0,
       0,   253,   254,   255,   815,   257,     0,     0,   816,   259,
     817,   818,   260,     0,   261,   819,   820,   821,   822,   823,
     824,   825,   266,   267,   268,   269,     0,   826,   270,   271,
       0,   272,   273,   274,   827,   828,   829,   275,     0,   830,
     831,     0,   276,   277,     0,   832,     0,   279,   280,   281,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     282,   283,   284,   833,   834,   286,   835,   836,   837,   838,
     839,     0,   289,   290,     0,   291,     0,   292,   293,   294,
     295,     0,   840,   297,   298,   299,   300,   301,   302,   303,
     841,     0,     0,     0,   304,   305,     0,     0,   306,   307,
     308,     0,   309,     0,   310,   311,   842,   843,   312,     0,
     313,   314,   315,     0,   316,   317,     0,     0,   844,   318,
     319,   845,   320,   321,   846,   322,   847,   324,   325,     0,
     848,   327,     0,     0,     0,   328,   329,   330,     0,     0,
     331,     0,     0,     0,   332,   333,   334,   335,     0,   336,
     337,   338,     0,     0,     0,     0,     0,     0,   339,   340,
       0,   341,     0,     0,   342,     0,     0,   343,   344,   849,
     850,   345,   346,     0,   347,   851,   349,   852,   853,   854,
     350,   351,   352,   353,   855,   354,   355,     0,   356,   357,
       0,   856,   358,   857,   858,   859,   860,     0,     0,     0,
       0,     0,   363,     0,   364,   861,   862,   863,   366,   367,
     368,     0,   864,   369,   370,   865,     0,   371,     0,     0,
     866,   867,   372,     0,     0,   373,     0,   374,     0,   868,
     376,     0,     0,   869,   870,   871,   872,   873,   377,     0,
       0,   378,   874,     0,   379,   380,   875,     0,     0,     0,
       0,   382,     0,   383,   384,     0,   876,     0,   877,     0,
       0,     0,     0,   878,     0,     0,     0,   879,   880,     0,
       0,     0,     0,   881,     0,   882,     0,     0,   883,   884,
       0,   885,   886,   122,     0,   741,   124,   125,   126,   127,
    1785,     0,     0,     0,     0,  1786,     0,     0,   742,     0,
     743,   130,   131,   744,   133,     0,   134,   745,   135,     0,
     746,   136,   747,   748,   749,   137,   750,     0,   138,   139,
     140,     0,   141,     0,   142,   143,     0,     0,   144,   751,
     145,     0,   146,   752,   753,   148,     0,   149,   150,   151,
     754,   152,     0,   755,   154,     0,   155,   156,   157,   158,
     159,   756,   757,   160,     0,   161,   162,     0,   758,   164,
       0,   759,   760,   761,   165,     0,     0,   166,   762,   763,
       0,   764,   765,     0,   167,   168,   766,   767,   768,     0,
       0,     0,     0,   769,   171,   770,     0,     0,   771,   772,
     172,     0,   173,     0,     0,     0,   773,   774,   174,     0,
     175,   176,   177,     0,     0,     0,   178,     0,     0,   179,
     180,   181,     0,     0,   775,   182,     0,   776,   777,   183,
     184,   185,   186,     0,     0,   187,     0,   188,   189,   190,
     778,     0,   191,   779,   192,   780,   781,   193,   194,     0,
     782,   195,   196,   197,   783,     0,   198,     0,     0,   784,
       0,   199,   200,     0,   785,   201,     0,   202,   786,   787,
     788,   789,     0,   790,   791,   204,   792,   793,   794,   206,
       0,   207,   795,     0,   796,   797,     0,   208,   209,     0,
     210,   798,     0,   211,     0,     0,     0,   799,   213,   214,
     215,   800,     0,   216,   217,     0,     0,     0,   218,     0,
       0,   801,   219,   802,     0,     0,   220,     0,   221,   222,
       0,   223,   224,     0,     0,     0,     0,     0,     0,   225,
     803,   226,     0,     0,   804,   227,     0,   805,   228,     0,
       0,     0,   806,     0,   807,     0,   230,   808,     0,   231,
       0,   232,   809,     0,     0,   810,     0,     0,     0,     0,
     811,   233,   234,   235,   236,   237,   238,   812,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   813,   248,   249,
     250,   814,   251,   252,     0,     0,     0,   253,   254,   255,
     815,   257,     0,     0,   816,   259,   817,   818,   260,     0,
     261,   819,   820,   821,   822,   823,   824,   825,   266,   267,
     268,   269,     0,   826,   270,   271,     0,   272,   273,   274,
     827,     0,   829,   275,     0,   830,   831,     0,   276,   277,
       0,   832,     0,   279,   280,   281,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   282,   283,   284,   833,
     834,   286,   835,   836,   837,   838,   839,     0,   289,   290,
       0,   291,     0,   292,   293,   294,   295,     0,   840,   297,
     298,   299,   300,   301,   302,   303,   841,     0,     0,     0,
     304,   305,     0,     0,   306,   307,   308,     0,   309,     0,
     310,   311,   842,   843,   312,     0,   313,   314,   315,     0,
     316,   317,     0,     0,   844,   318,   319,   845,   320,   321,
     846,   322,   847,   324,   325,     0,   848,   327,     0,     0,
       0,   328,   329,   330,     0,     0,   331,     0,     0,     0,
     332,   333,   334,   335,     0,   336,   337,   338,     0,     0,
       0,     0,     0,     0,   339,   340,     0,   341,     0,     0,
     342,     0,     0,   343,   344,   849,   850,   345,   346,     0,
     347,   851,   349,   852,   853,   854,   350,   351,   352,   353,
     855,   354,   355,     0,   356,   357,     0,   856,   358,   857,
     858,   859,   860,     0,     0,     0,     0,     0,   363,     0,
     364,   861,   862,   863,   366,   367,   368,     0,   864,   369,
     370,   865,     0,   371,     0,     0,   866,   867,   372,     0,
       0,   373,     0,   374,     0,   868,   376,     0,     0,   869,
     870,   871,   872,   873,   377,     0,     0,   378,   874,     0,
     379,   380,   875,     0,     0,     0,     0,   382,     0,   383,
     384,     0,   876,     0,   877,     0,     0,     0,     0,   878,
       0,     0,     0,   879,   880,     0,     0,     0,     0,   881,
       0,   882,     0,     0,   883,   884,     0,   885,   886,   122,
       0,   741,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   742,     0,   743,   130,   131,   744,
     133,     0,   134,   745,   135,     0,   746,   136,   747,   748,
     749,   137,   750,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,   751,   145,     0,   146,   752,
     753,   148,     0,   149,   150,   151,   754,   152,     0,   755,
     154,     0,   155,   156,   157,   158,   159,   756,   757,   160,
       0,   161,   162,     0,   758,   164,     0,   759,   760,   761,
     165,     0,     0,   166,   762,   763,     0,   764,   765,     0,
     167,   168,   766,   767,   768,     0,     0,     0,     0,   769,
     171,   770,     0,     0,   771,   772,   172,     0,   173,     0,
       0,     0,   773,   774,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
     775,   182,     0,   776,   777,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,   778,     0,   191,   779,
     192,   780,   781,   193,   194,     0,   782,   195,   196,   197,
     783,     0,   198,     0,     0,   784,     0,   199,   200,     0,
     785,   201,     0,   202,   786,   787,   788,   789,     0,   790,
     791,   204,   792,   793,   794,   206,     0,   207,   795,     0,
     796,   797,     0,   208,   209,     0,   210,   798,     0,   211,
       0,     0,     0,   799,   213,   214,   215,   800,     0,   216,
     217,     0,     0,     0,   218,     0,     0,   801,   219,  2469,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,   803,   226,     0,     0,
     804,   227,     0,   805,   228,     0,     0,     0,   806,     0,
     807,     0,   230,   808,     0,   231,     0,   232,   809,     0,
       0,   810,     0,     0,     0,     0,   811,   233,   234,   235,
     236,   237,   238,   812,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   813,   248,   249,   250,   814,   251,   252,
       0,     0,     0,   253,   254,   255,   815,   257,     0,     0,
     816,   259,   817,   818,   260,     0,   261,   819,   820,   821,
     822,   823,   824,   825,   266,   267,   268,   269,     0,   826,
     270,   271,     0,   272,   273,   274,   827,   828,   829,   275,
       0,   830,   831,     0,   276,   277,     0,   832,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   833,   834,   286,   835,   836,
     837,   838,   839,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   840,   297,   298,   299,   300,   301,
     302,   303,   841,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,   842,   843,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
     844,   318,   319,   845,   320,   321,   846,   322,   847,   324,
     325,     0,   848,   327,     0,     0,     0,   328,   329,   330,
       0,     0,   331,     0,     0,     0,   332,   333,   334,   335,
       0,   336,   337,   338,     0,     0,     0,     0,     0,     0,
     339,   340,     0,   341,     0,     0,   342,     0,     0,   343,
     344,   849,   850,   345,   346,     0,   347,   851,   349,   852,
     853,   854,   350,   351,   352,   353,   855,   354,   355,     0,
     356,   357,     0,   856,   358,   857,   858,   859,   860,     0,
       0,     0,     0,     0,   363,     0,   364,   861,   862,   863,
     366,   367,   368,     0,   864,   369,   370,   865,     0,   371,
       0,     0,   866,   867,   372,     0,     0,   373,     0,   374,
       0,   868,   376,     0,     0,   869,   870,   871,   872,   873,
     377,     0,     0,   378,   874,     0,   379,   380,   875,     0,
       0,     0,     0,   382,     0,   383,   384,     0,   876,     0,
     877,     0,     0,     0,     0,   878,     0,     0,     0,   879,
     880,     0,     0,     0,     0,   881,     0,   882,     0,     0,
     883,   884,     0,   885,   886,   122,     0,   741,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     742,     0,   743,   130,   131,   744,   133,     0,   134,   745,
     135,     0,   746,   136,   747,   748,   749,   137,   750,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,   751,   145,     0,   146,   752,   753,   148,     0,   149,
     150,   151,   754,   152,     0,   755,   154,     0,   155,   156,
     157,   158,   159,   756,   757,   160,     0,   161,   162,     0,
     758,   164,     0,   759,   760,   761,   165,     0,     0,   166,
     762,   763,     0,   764,   765,     0,   167,   168,   766,   767,
     768,     0,     0,     0,     0,   769,   171,   770,     0,     0,
     771,   772,   172,     0,   173,     0,     0,     0,   773,   774,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,   775,   182,     0,   776,
     777,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,   778,     0,   191,   779,   192,   780,   781,   193,
     194,     0,   782,   195,   196,   197,   783,     0,   198,     0,
       0,   784,     0,   199,   200,     0,   785,   201,     0,   202,
     786,   787,   788,   789,     0,   790,   791,   204,   792,   793,
     794,   206,     0,   207,   795,     0,   796,   797,     0,   208,
     209,     0,   210,   798,     0,   211,     0,     0,     0,   799,
     213,   214,   215,   800,     0,   216,   217,     0,     0,     0,
     218,     0,     0,   801,   219,  2542,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,   803,   226,     0,     0,   804,   227,     0,   805,
     228,     0,     0,     0,   806,     0,   807,     0,   230,   808,
       0,   231,     0,   232,   809,     0,     0,   810,     0,     0,
       0,     0,   811,   233,   234,   235,   236,   237,   238,   812,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   813,
     248,   249,   250,   814,   251,   252,     0,     0,     0,   253,
     254,   255,   815,   257,     0,     0,   816,   259,   817,   818,
     260,     0,   261,   819,   820,   821,   822,   823,   824,   825,
     266,   267,   268,   269,     0,   826,   270,   271,     0,   272,
     273,   274,   827,   828,   829,   275,     0,   830,   831,     0,
     276,   277,     0,   832,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   833,   834,   286,   835,   836,   837,   838,   839,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     840,   297,   298,   299,   300,   301,   302,   303,   841,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,   842,   843,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,   844,   318,   319,   845,
     320,   321,   846,   322,   847,   324,   325,     0,   848,   327,
       0,     0,     0,   328,   329,   330,     0,     0,   331,     0,
       0,     0,   332,   333,   334,   335,     0,   336,   337,   338,
       0,     0,     0,     0,     0,     0,   339,   340,     0,   341,
       0,     0,   342,     0,     0,   343,   344,   849,   850,   345,
     346,     0,   347,   851,   349,   852,   853,   854,   350,   351,
     352,   353,   855,   354,   355,     0,   356,   357,     0,   856,
     358,   857,   858,   859,   860,     0,     0,     0,     0,     0,
     363,     0,   364,   861,   862,   863,   366,   367,   368,     0,
     864,   369,   370,   865,     0,   371,     0,     0,   866,   867,
     372,     0,     0,   373,     0,   374,     0,   868,   376,     0,
       0,   869,   870,   871,   872,   873,   377,     0,     0,   378,
     874,     0,   379,   380,   875,     0,     0,     0,     0,   382,
       0,   383,   384,     0,   876,     0,   877,     0,     0,     0,
       0,   878,     0,     0,     0,   879,   880,     0,     0,     0,
       0,   881,     0,   882,     0,     0,   883,   884,     0,   885,
     886,   122,     0,   741,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   742,     0,   743,   130,
     131,   744,   133,     0,   134,   745,   135,     0,   746,   136,
     747,   748,   749,   137,   750,     0,   138,   139,   140,     0,
     141,     0,   142,   143,     0,     0,   144,   751,   145,     0,
     146,   752,   753,   148,     0,   149,   150,   151,   754,   152,
       0,   755,   154,     0,   155,   156,   157,   158,   159,   756,
     757,   160,     0,   161,   162,     0,   758,   164,     0,   759,
     760,   761,   165,     0,     0,   166,   762,   763,     0,   764,
     765,     0,   167,   168,   766,   767,   768,     0,     0,     0,
       0,   769,   171,   770,     0,     0,   771,  2889,   172,     0,
     173,     0,     0,     0,   773,   774,   174,     0,   175,   176,
     177,     0,     0,     0,   178,     0,     0,   179,   180,   181,
       0,     0,   775,   182,     0,   776,   777,   183,   184,   185,
     186,     0,     0,   187,     0,   188,   189,   190,   778,     0,
     191,   779,   192,   780,   781,   193,   194,     0,   782,   195,
     196,   197,   783,     0,   198,     0,     0,   784,     0,   199,
     200,     0,   785,   201,     0,   202,   786,   787,   788,   789,
       0,   790,   791,   204,   792,   793,   794,   206,     0,   207,
     795,     0,   796,   797,     0,   208,   209,     0,   210,   798,
       0,   211,     0,     0,     0,   799,   213,   214,   215,   800,
       0,   216,   217,     0,     0,     0,   218,     0,     0,   801,
     219,   802,     0,     0,   220,     0,   221,   222,     0,   223,
     224,     0,     0,     0,     0,     0,     0,   225,   803,   226,
       0,     0,   804,   227,     0,   805,   228,     0,     0,     0,
     806,     0,   807,     0,   230,   808,     0,   231,     0,   232,
     809,     0,     0,   810,     0,     0,     0,     0,   811,   233,
     234,   235,   236,   237,   238,   812,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   813,   248,   249,   250,   814,
     251,   252,     0,     0,     0,   253,   254,   255,   815,   257,
       0,     0,   816,   259,   817,   818,   260,     0,   261,   819,
     820,   821,   822,   823,   824,   825,   266,   267,   268,   269,
       0,   826,   270,   271,     0,   272,   273,   274,   827,   828,
     829,   275,     0,   830,   831,     0,   276,   277,     0,   832,
       0,   279,   280,   281,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   833,   834,   286,
     835,   836,   837,   838,   839,     0,   289,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   840,   297,   298,   299,
     300,   301,   302,   303,   841,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,   310,   311,
     842,   843,   312,     0,   313,   314,   315,     0,   316,   317,
       0,     0,   844,   318,   319,   845,   320,   321,   846,   322,
     847,   324,   325,     0,   848,   327,     0,     0,     0,   328,
     329,   330,     0,     0,   331,     0,     0,     0,   332,   333,
     334,   335,     0,   336,   337,   338,     0,     0,     0,     0,
       0,     0,   339,   340,     0,   341,     0,     0,   342,     0,
       0,   343,   344,   849,   850,   345,   346,     0,   347,   851,
     349,   852,   853,   854,   350,   351,   352,   353,   855,   354,
     355,     0,   356,   357,     0,   856,   358,   857,   858,   859,
     860,     0,     0,     0,     0,     0,   363,     0,   364,   861,
     862,   863,   366,   367,   368,     0,   864,   369,   370,   865,
       0,   371,     0,     0,   866,   867,   372,     0,     0,   373,
       0,   374,     0,   868,   376,     0,     0,   869,   870,   871,
     872,   873,   377,     0,     0,   378,   874,     0,   379,   380,
     875,     0,     0,     0,     0,   382,     0,   383,   384,     0,
     876,     0,   877,     0,     0,     0,     0,   878,     0,     0,
       0,   879,   880,     0,     0,     0,     0,   881,     0,   882,
       0,     0,   883,   884,     0,   885,   886,   122,     0,   741,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   742,     0,   743,   130,   131,   744,   133,     0,
     134,   745,   135,     0,   746,   136,   747,   748,   749,   137,
     750,     0,   138,   139,   140,     0,   141,     0,   142,   143,
       0,     0,   144,   751,   145,     0,   146,   752,   753,   148,
       0,   149,   150,   151,   754,   152,     0,   755,   154,     0,
     155,   156,   157,   158,   159,   756,   757,   160,     0,   161,
     162,     0,   758,   164,     0,   759,   760,   761,   165,     0,
       0,   166,   762,   763,     0,   764,   765,     0,   167,   168,
     766,   767,   768,     0,     0,     0,     0,   769,   171,   770,
       0,     0,   771,   772,   172,     0,   173,     0,     0,     0,
     773,   774,   174,     0,   175,   176,   177,     0,     0,     0,
     178,     0,     0,   179,   180,   181,     0,     0,   775,   182,
       0,   776,   777,   183,   184,   185,   186,     0,     0,   187,
       0,   188,   189,   190,   778,     0,   191,   779,   192,   780,
     781,   193,   194,     0,   782,   195,   196,   197,   783,     0,
     198,     0,     0,   784,     0,   199,   200,     0,   785,   201,
       0,   202,   786,   787,   788,   789,     0,   790,   791,   204,
     792,   793,   794,   206,     0,   207,   795,     0,   796,   797,
       0,   208,   209,     0,   210,   798,     0,   211,     0,     0,
       0,   799,   213,   214,   215,   800,     0,   216,   217,     0,
       0,     0,   218,     0,     0,   801,   219,   802,     0,     0,
     220,     0,   221,   222,     0,   223,   224,     0,     0,     0,
       0,     0,     0,   225,   803,   226,     0,     0,   804,   227,
       0,   805,   228,     0,     0,     0,   806,     0,   807,     0,
     230,   808,     0,   231,     0,   232,   809,     0,     0,   810,
       0,     0,     0,     0,   811,   233,   234,   235,   236,   237,
     238,   812,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   813,   248,   249,   250,   814,   251,   252,     0,     0,
       0,   253,   254,   255,   815,   257,     0,     0,   816,   259,
     817,   818,   260,     0,   261,   819,   820,   821,   822,   823,
     824,   825,   266,   267,   268,   269,     0,   826,   270,   271,
       0,   272,   273,   274,   827,     0,   829,   275,     0,   830,
     831,     0,   276,   277,     0,   832,     0,   279,   280,   281,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     282,   283,   284,   833,   834,   286,   835,   836,   837,   838,
     839,     0,   289,   290,     0,   291,     0,   292,   293,   294,
     295,     0,   840,   297,   298,   299,   300,   301,   302,   303,
     841,     0,     0,     0,   304,   305,     0,     0,   306,   307,
     308,     0,   309,     0,   310,   311,   842,   843,   312,     0,
     313,   314,   315,     0,   316,   317,     0,     0,   844,   318,
     319,   845,   320,   321,   846,   322,   847,   324,   325,     0,
     848,   327,     0,     0,     0,   328,   329,   330,     0,     0,
     331,     0,     0,     0,   332,   333,   334,   335,     0,   336,
     337,   338,     0,     0,     0,     0,     0,     0,   339,   340,
       0,   341,     0,     0,   342,     0,     0,   343,   344,   849,
     850,   345,   346,     0,   347,   851,   349,   852,   853,   854,
     350,   351,   352,   353,   855,   354,   355,     0,   356,   357,
       0,   856,   358,   857,   858,   859,   860,     0,     0,     0,
       0,     0,   363,     0,   364,   861,   862,   863,   366,   367,
     368,     0,   864,   369,   370,   865,     0,   371,     0,     0,
     866,   867,   372,     0,     0,   373,     0,   374,     0,   868,
     376,     0,     0,   869,   870,   871,   872,   873,   377,     0,
       0,   378,   874,     0,   379,   380,   875,     0,     0,     0,
       0,   382,     0,   383,   384,     0,   876,     0,   877,     0,
       0,     0,     0,   878,     0,     0,     0,   879,   880,     0,
       0,     0,     0,   881,     0,   882,     0,     0,   883,   884,
       0,   885,   886,   122,     0,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   129,     0,
       0,   130,   131,   132,   133,     0,   134,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
     140,     0,   141,     0,   142,   143,     0,     0,   144,     0,
     145,     0,   146,   147,     0,   148,     0,   149,   150,   151,
       0,   152,     0,   153,   154,     0,   155,   156,   157,   158,
     159,     0,     0,   160,     0,   161,   162,  1962,   163,   164,
       0,     0,     0,     0,   165,     0,     0,   166,     0,     0,
       0,     0,     0,     0,   167,   168,     0,     0,   169,     0,
       0,     0,     0,   170,   171,     0,     0,     0,     0,     0,
     172,     0,   173,     0,     0,     0,     0,     0,   174,     0,
     175,   176,   177,     0,     0,     0,   178,     0,     0,   179,
     180,   181,     0,     0,     0,   182,     0,     0,     0,   183,
     184,   185,   186,     0,     0,   187,     0,   188,   189,   190,
       0,     0,   191,     0,   192,     0,     0,   193,   194,     0,
       0,   195,   196,   197,     0,     0,   198,     0,     0,     0,
       0,   199,   200,     0,     0,   201,  1963,   202,     0,     0,
       0,     0,     0,     0,   203,   204,     0,     0,   205,   206,
       0,   207,     0,     0,     0,     0,     0,   208,   209,     0,
     210,     0,     0,   211,     0,     0,     0,   212,   213,   214,
     215,     0,     0,   216,   217,  1104,     0,     0,   218,     0,
       0,     0,   219,     0,     0,     0,   220,     0,   221,   222,
       0,   223,   224,     0,     0,     0,  1105,     0,     0,   225,
       0,   226,     0,     0,     0,   227,     0,     0,   228,     0,
    2454,     0,     0,     0,   229,     0,   230,     0,     0,   231,
       0,   232,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   233,   234,   235,   236,   237,   238,     0,   239,   240,
     241,   242,   243,   244,   245,   246,   247,     0,   248,   249,
     250,     0,   251,   252,     0,     0,     0,   253,   254,   255,
     256,   257,     0,     0,   258,   259,     0,     0,   260,     0,
     261,     0,   262,     0,     0,   263,   264,   265,   266,   267,
     268,   269,     0,     0,   270,   271,     0,   272,   273,   274,
       0,     0,     0,   275,     0,     0,     0,     0,   276,   277,
       0,   278,     0,   279,   280,   281,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   282,   283,   284,   285,
       0,   286,     0,   287,     0,   288,     0,     0,   289,   290,
       0,   291,     0,   292,   293,   294,   295,     0,   296,   297,
     298,   299,   300,   301,   302,   303,     0,     0,     0,     0,
     304,   305,     0,     0,   306,   307,   308,     0,   309,     0,
     310,   311,     0,     0,   312,     0,   313,   314,   315,     0,
     316,   317,     0,     0,     0,   318,   319,     0,   320,   321,
       0,   322,   323,   324,   325,     0,   326,   327,  1872,     0,
       0,   328,   329,   330,     0,     0,   331,     0,     0,     0,
     332,   333,   334,   335,     0,   336,   337,   338,  1964,     0,
       0,     0,     0,     0,   339,   340,     0,   341,     0,     0,
     342,     0,     0,   343,   344,     0,     0,   345,   346,     0,
     347,   348,   349,     0,     0,     0,   350,   351,   352,   353,
       0,   354,   355,     0,   356,   357,     0,     0,   358,   359,
     360,   361,   362,     0,     0,     0,     0,     0,   363,     0,
     364,     0,     0,   365,   366,   367,   368,     0,     0,   369,
     370,     0,     0,   371,     0,     0,     0,     0,   372,     0,
       0,   373,     0,   374,     0,   375,   376,     0,     0,     0,
       0,     0,     0,     0,   377,     0,     0,   378,     0,     0,
     379,   380,   381,     0,     0,     0,     0,   382,     0,   383,
     384,     0,     0,     0,   385,     0,   122,     0,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,  2011,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,     0,   145,     0,   146,   147,     0,   148,     0,
     149,   150,   151,     0,   152,     0,   153,   154,     0,   155,
     156,   157,   158,   159,     0,     0,   160,     0,   161,   162,
    1962,   163,   164,     0,     0,     0,     0,   165,     0,     0,
     166,     0,     0,     0,     0,     0,     0,   167,   168,     0,
       0,   169,     0,     0,     0,     0,   170,   171,     0,     0,
       0,     0,     0,   172,     0,   173,     0,     0,     0,     0,
       0,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,     0,   182,     0,
       0,     0,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,     0,     0,   191,     0,   192,     0,     0,
     193,   194,     0,     0,   195,   196,   197,     0,     0,   198,
       0,     0,     0,     0,   199,   200,     0,     0,   201,  1963,
     202,     0,     0,     0,     0,     0,     0,   203,   204,     0,
       0,   205,   206,     0,   207,     0,     0,     0,     0,     0,
     208,   209,     0,   210,     0,     0,   211,     0,     0,     0,
     212,   213,   214,   215,     0,     0,   216,   217,  1104,     0,
       0,   218,     0,     0,     0,   219,     0,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,  1105,
       0,     0,   225,     0,   226,     0,     0,     0,   227,     0,
       0,   228,     0,     0,     0,     0,     0,   229,     0,   230,
       0,     0,   231,     0,   232,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   233,   234,   235,   236,   237,   238,
       0,   239,   240,   241,   242,   243,   244,   245,   246,   247,
       0,   248,   249,   250,     0,   251,   252,     0,     0,     0,
     253,   254,   255,   256,   257,     0,     0,   258,   259,     0,
       0,   260,     0,   261,     0,   262,     0,     0,   263,   264,
     265,   266,   267,   268,   269,     0,     0,   270,   271,     0,
     272,   273,   274,     0,     0,     0,   275,     0,     0,     0,
       0,   276,   277,     0,   278,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   285,     0,   286,     0,   287,     0,   288,     0,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   300,   301,   302,   303,     0,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,     0,     0,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
       0,   320,   321,     0,   322,   323,   324,   325,     0,   326,
     327,     0,     0,     0,   328,   329,   330,     0,     0,   331,
       0,     0,     0,   332,   333,   334,   335,     0,   336,   337,
     338,  1964,     0,     0,     0,     0,     0,   339,   340,     0,
     341,     0,     0,   342,     0,     0,   343,   344,     0,     0,
     345,   346,     0,   347,   348,   349,     0,     0,     0,   350,
     351,   352,   353,     0,   354,   355,     0,   356,   357,     0,
       0,   358,   359,   360,   361,   362,     0,     0,     0,     0,
       0,   363,     0,   364,     0,     0,   365,   366,   367,   368,
       0,     0,   369,   370,     0,     0,   371,     0,     0,     0,
       0,   372,     0,     0,   373,     0,   374,     0,   375,   376,
       0,     0,     0,     0,     0,     0,     0,   377,     0,     0,
     378,     0,     0,   379,   380,   381,     0,     0,     0,     0,
     382,     0,   383,   384,     0,     0,     0,   385,     0,   122,
       0,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,  2011,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,     0,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,  1872,     0,     0,   328,   329,   330,
       0,     0,   331,     0,     0,     0,   332,   333,   334,   335,
       0,   336,   337,   338,     0,     0,     0,     0,     0,     0,
     339,   340,     0,   341,     0,     0,   342,     0,     0,   343,
     344,     0,     0,   345,   346,     0,   347,   348,   349,     0,
       0,     0,   350,   351,   352,   353,     0,   354,   355,     0,
     356,   357,     0,     0,   358,   359,   360,   361,   362,     0,
       0,     0,     0,     0,   363,     0,   364,     0,     0,   365,
     366,   367,   368,     0,     0,   369,   370,     0,     0,   371,
       0,     0,     0,     0,   372,     0,     0,   373,     0,   374,
       0,   375,   376,     0,     0,     0,     0,     0,     0,     0,
     377,     0,     0,   378,     0,     0,   379,   380,   381,     0,
       0,     0,     0,   382,     0,   383,   384,     0,     0,     0,
     385,     0,   122,     0,   123,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   129,  2279,     0,
     130,   131,   132,   133,   886,   134,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,   140,
       0,   141,     0,   142,   143,     0,     0,   144,     0,   145,
       0,   146,   147,     0,   148,     0,   149,   150,   151,     0,
     152,     0,   153,   154,     0,   155,   156,   157,   158,   159,
       0,     0,   160,     0,   161,   162,     0,   163,   164,     0,
       0,     0,     0,   165,     0,     0,   166,     0,     0,     0,
       0,     0,     0,   167,   168,     0,     0,   169,     0,     0,
       0,     0,   170,   171,     0,     0,     0,     0,     0,   172,
       0,   173,     0,     0,     0,     0,     0,   174,     0,   175,
     176,   177,     0,     0,     0,   178,     0,     0,   179,   180,
     181,     0,     0,     0,   182,     0,     0,     0,   183,   184,
     185,   186,     0,     0,   187,     0,   188,   189,   190,     0,
       0,   191,     0,   192,     0,     0,   193,   194,     0,     0,
     195,   196,   197,     0,     0,   198,     0,     0,     0,     0,
     199,   200,     0,     0,   201,     0,   202,     0,     0,     0,
       0,     0,     0,   203,   204,     0,     0,   205,   206,     0,
     207,     0,     0,     0,     0,     0,   208,   209,     0,   210,
       0,     0,   211,     0,     0,     0,   212,   213,   214,   215,
       0,     0,   216,   217,     0,     0,     0,   218,     0,     0,
       0,   219,     0,     0,     0,   220,     0,   221,   222,     0,
     223,   224,     0,     0,     0,     0,     0,     0,   225,     0,
     226,     0,     0,     0,   227,     0,     0,   228,     0,     0,
       0,     0,     0,   229,     0,   230,     0,     0,   231,     0,
     232,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     233,   234,   235,   236,   237,   238,     0,   239,   240,   241,
     242,   243,   244,   245,   246,   247,     0,   248,   249,   250,
       0,   251,   252,     0,     0,     0,   253,   254,   255,   256,
     257,     0,     0,   258,   259,     0,     0,   260,     0,   261,
       0,   262,     0,     0,   263,   264,   265,   266,   267,   268,
     269,     0,     0,   270,   271,     0,   272,   273,   274,     0,
       0,     0,   275,     0,     0,     0,     0,   276,   277,     0,
     278,     0,   279,   280,   281,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   282,   283,   284,   285,     0,
     286,     0,   287,     0,   288,     0,     0,   289,   290,     0,
     291,     0,   292,   293,   294,   295,     0,   296,   297,   298,
     299,   300,   301,   302,   303,     0,     0,     0,     0,   304,
     305,     0,     0,   306,   307,   308,     0,   309,     0,   310,
     311,     0,     0,   312,     0,   313,   314,   315,     0,   316,
     317,     0,     0,     0,   318,   319,     0,   320,   321,     0,
     322,   323,   324,   325,     0,   326,   327,     0,     0,     0,
     328,   329,   330,     0,     0,   331,     0,     0,     0,   332,
     333,   334,   335,     0,   336,   337,   338,     0,     0,     0,
       0,     0,     0,   339,   340,     0,   341,     0,     0,   342,
       0,     0,   343,   344,     0,     0,   345,   346,     0,   347,
     348,   349,     0,     0,     0,   350,   351,   352,   353,     0,
     354,   355,     0,   356,   357,     0,     0,   358,   359,   360,
     361,   362,     0,     0,     0,     0,     0,   363,     0,   364,
       0,     0,   365,   366,   367,   368,     0,     0,   369,   370,
       0,     0,   371,     0,     0,     0,     0,   372,     0,     0,
     373,     0,   374,     0,   375,   376,     0,     0,     0,     0,
       0,     0,     0,   377,     0,     0,   378,     0,     0,   379,
     380,   381,     0,     0,     0,     0,   382,     0,   383,   384,
       0,     0,     0,   385,     0,     0,     0,     0,     0,     0,
     122,     0,   123,   124,   125,   126,   127,     0,     0,     0,
       0,  3641,   128,     0,     0,   129,  3642,   886,   130,   131,
     132,   133,     0,   134,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,   140,     0,   141,
       0,   142,   143,     0,     0,   144,     0,   145,     0,   146,
     147,     0,   148,     0,   149,   150,   151,     0,   152,     0,
     153,   154,     0,   155,   156,   157,   158,   159,     0,     0,
     160,     0,   161,   162,     0,   163,   164,     0,     0,     0,
       0,   165,     0,     0,   166,     0,     0,     0,     0,     0,
       0,   167,   168,     0,     0,   169,     0,     0,     0,     0,
     170,   171,     0,     0,     0,     0,     0,   172,     0,   173,
       0,     0,     0,     0,     0,   174,     0,   175,   176,   177,
       0,     0,     0,   178,     0,     0,   179,   180,   181,     0,
       0,     0,   182,     0,     0,     0,   183,   184,   185,   186,
       0,     0,   187,     0,   188,   189,   190,     0,     0,   191,
       0,   192,     0,     0,   193,   194,     0,     0,   195,   196,
     197,     0,     0,   198,     0,     0,     0,     0,   199,   200,
       0,     0,   201,     0,   202,     0,     0,     0,     0,     0,
       0,   203,   204,     0,     0,   205,   206,     0,   207,     0,
       0,     0,     0,     0,   208,   209,     0,   210,     0,     0,
     211,     0,     0,     0,   212,   213,   214,   215,     0,     0,
     216,   217,     0,     0,     0,   218,     0,     0,     0,   219,
       0,   979,     0,   220,     0,   221,   222,     0,   223,   224,
       0,     0,     0,     0,     0,     0,   225,     0,   226,     0,
       0,     0,   227,     0,     0,   228,     0,     0,     0,     0,
       0,   229,     0,   230,     0,     0,   231,     0,   232,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   233,   234,
     235,   236,   237,   238,     0,   239,   240,   241,   242,   243,
     244,   245,   246,   247,     0,   248,   249,   250,     0,   251,
     252,     0,     0,     0,   253,   254,   255,   256,   257,     0,
       0,   258,   259,     0,     0,   260,     0,   261,     0,   262,
       0,     0,   263,   264,   265,   266,   267,   268,   269,     0,
       0,   270,   271,     0,   272,   273,   274,     0,     0,     0,
     275,     0,     0,     0,     0,   276,   277,     0,   278,     0,
     279,   280,   281,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   282,   283,   284,   285,     0,   286,     0,
     287,     0,   288,     0,     0,   289,   290,     0,   291,     0,
     292,   293,   294,   295,     0,   296,   297,   298,   299,   300,
     301,   302,   303,     0,     0,     0,     0,   304,   305,     0,
       0,   306,   307,   308,     0,   309,     0,   310,   311,     0,
       0,   312,     0,   313,   314,   315,     0,   316,   317,     0,
       0,     0,   318,   319,     0,   320,   321,     0,   322,   323,
     324,   325,     0,   326,   327,     0,     0,     0,   328,   329,
     330,     0,     0,   331,     0,     0,     0,   332,   333,   334,
     335,     0,   336,   337,   338,     0,     0,     0,     0,     0,
       0,   339,   340,     0,   341,     0,     0,   342,     0,     0,
     343,   344,     0,     0,   345,   346,     0,   347,   348,   349,
       0,     0,     0,   350,   351,   352,   353,     0,   354,   355,
       0,   356,   357,     0,     0,   358,   359,   360,   361,   362,
       0,     0,     0,     0,     0,   363,     0,   364,     0,     0,
     365,   366,   367,   368,     0,     0,   369,   370,     0,     0,
     371,     0,     0,     0,     0,   372,     0,     0,   373,     0,
     374,     0,   375,   376,     0,     0,     0,     0,     0,     0,
       0,   377,     0,     0,   378,     0,     0,   379,   380,   381,
       0,     0,     0,     0,   382,     0,   383,   384,     0,     0,
       0,   385,     0,   122,     0,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   129,     0,
       0,   130,   131,   132,   133,   421,   134,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
     140,     0,   141,     0,   142,   143,     0,     0,   144,     0,
     145,     0,   146,   147,     0,   148,     0,   149,   150,   151,
       0,   152,     0,   153,   154,     0,   155,   156,   157,   158,
     159,     0,     0,   160,     0,   161,   162,     0,   163,   164,
       0,     0,     0,     0,   165,     0,     0,   166,     0,     0,
       0,     0,     0,     0,   167,   168,     0,     0,   169,     0,
       0,     0,     0,   170,   171,     0,     0,     0,     0,     0,
     172,     0,   173,     0,     0,     0,     0,     0,   174,     0,
     175,   176,   177,     0,     0,     0,   178,     0,     0,   179,
     180,   181,     0,     0,     0,   182,     0,     0,     0,   183,
     184,   185,   186,     0,     0,   187,     0,   188,   189,   190,
       0,     0,   191,     0,   192,     0,     0,   193,   194,     0,
       0,   195,   196,   197,     0,     0,   198,     0,     0,     0,
       0,   199,   200,     0,     0,   201,     0,   202,     0,     0,
       0,     0,     0,     0,   203,   204,     0,     0,   205,   206,
       0,   207,     0,     0,     0,     0,     0,   208,   209,     0,
     210,     0,     0,   211,     0,     0,     0,   212,   213,   214,
     215,     0,     0,   216,   217,     0,     0,     0,   218,     0,
       0,     0,   219,     0,     0,     0,   220,     0,   221,   222,
       0,   223,   224,     0,     0,     0,     0,     0,     0,   225,
       0,   226,     0,     0,     0,   227,     0,     0,   228,     0,
       0,     0,     0,     0,   229,     0,   230,     0,     0,   231,
       0,   232,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   233,   234,   235,   236,   237,   238,     0,   239,   240,
     241,   242,   243,   244,   245,   246,   247,     0,   248,   249,
     250,     0,   251,   252,     0,     0,     0,   253,   254,   255,
     256,   257,     0,     0,   258,   259,     0,     0,   260,     0,
     261,     0,   262,     0,     0,   263,   264,   265,   266,   267,
     268,   269,     0,     0,   270,   271,     0,   272,   273,   274,
       0,     0,     0,   275,     0,     0,     0,     0,   276,   277,
       0,   278,     0,   279,   280,   281,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   282,   283,   284,   285,
       0,   286,     0,   287,     0,   288,     0,     0,   289,   290,
       0,   291,     0,   292,   293,   294,   295,     0,   296,   297,
     298,   299,   300,   301,   302,   303,     0,     0,     0,     0,
     304,   305,     0,     0,   306,   307,   308,     0,   309,     0,
     310,   311,     0,     0,   312,     0,   313,   314,   315,     0,
     316,   317,     0,     0,     0,   318,   319,     0,   320,   321,
       0,   322,   323,   324,   325,     0,   326,   327,     0,     0,
       0,   328,   329,   330,     0,     0,   331,     0,     0,     0,
     332,   333,   334,   335,     0,   336,   337,   338,     0,     0,
       0,     0,     0,     0,   339,   340,     0,   341,     0,     0,
     342,     0,     0,   343,   344,     0,     0,   345,   346,     0,
     347,   348,   349,     0,     0,     0,   350,   351,   352,   353,
       0,   354,   355,     0,   356,   357,     0,     0,   358,   359,
     360,   361,   362,     0,     0,     0,     0,     0,   363,     0,
     364,     0,     0,   365,   366,   367,   368,     0,     0,   369,
     370,     0,     0,   371,     0,     0,     0,     0,   372,     0,
       0,   373,     0,   374,     0,   375,   376,     0,     0,     0,
       0,     0,     0,     0,   377,     0,     0,   378,     0,     0,
     379,   380,   381,     0,     0,     0,     0,   382,     0,   383,
     384,     0,     0,     0,   385,     0,   122,     0,   123,   124,
     125,   126,   127,     0,     0,  1830,     0,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,   421,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,   140,     0,   141,     0,   142,   143,     0,
       0,   144,     0,   145,     0,   146,   147,     0,   148,     0,
     149,   150,   151,     0,   152,     0,   153,   154,     0,   155,
     156,   157,   158,   159,     0,     0,   160,     0,   161,   162,
       0,   163,   164,     0,     0,     0,     0,   165,     0,     0,
     166,     0,     0,     0,     0,     0,     0,   167,   168,     0,
       0,   169,     0,     0,     0,     0,   170,   171,     0,     0,
       0,     0,     0,   172,     0,   173,     0,     0,     0,     0,
       0,   174,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,   179,   180,   181,     0,     0,     0,   182,     0,
       0,     0,   183,   184,   185,   186,     0,     0,   187,     0,
     188,   189,   190,     0,     0,   191,     0,   192,     0,     0,
     193,   194,     0,     0,   195,   196,   197,     0,     0,   198,
       0,     0,     0,     0,   199,   200,     0,     0,   201,     0,
     202,     0,     0,     0,     0,     0,     0,   203,   204,     0,
       0,   205,   206,     0,   207,     0,     0,     0,     0,     0,
     208,   209,     0,   210,     0,     0,   211,     0,     0,     0,
     212,   213,   214,   215,     0,     0,   216,   217,     0,     0,
       0,   218,     0,     0,     0,   219,     0,     0,     0,   220,
       0,   221,   222,     0,   223,   224,     0,     0,     0,     0,
       0,     0,   225,     0,   226,     0,     0,     0,   227,     0,
       0,   228,     0,     0,     0,     0,     0,   229,     0,   230,
       0,     0,   231,     0,   232,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   233,   234,   235,   236,   237,   238,
       0,   239,   240,   241,   242,   243,   244,   245,   246,   247,
       0,   248,   249,   250,     0,   251,   252,     0,     0,     0,
     253,   254,   255,   256,   257,     0,     0,   258,   259,     0,
       0,   260,     0,   261,     0,   262,     0,     0,   263,   264,
     265,   266,   267,   268,   269,     0,     0,   270,   271,     0,
     272,   273,   274,     0,     0,     0,   275,     0,     0,     0,
       0,   276,   277,     0,   278,     0,   279,   280,   281,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   282,
     283,   284,   285,     0,   286,     0,   287,     0,   288,     0,
       0,   289,   290,     0,   291,     0,   292,   293,   294,   295,
       0,   296,   297,   298,   299,   300,   301,   302,   303,     0,
       0,     0,     0,   304,   305,     0,     0,   306,   307,   308,
       0,   309,     0,   310,   311,     0,     0,   312,     0,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
       0,   320,   321,     0,   322,   323,   324,   325,     0,   326,
     327,     0,     0,     0,   328,   329,   330,     0,     0,   331,
       0,     0,     0,   332,   333,   334,   335,     0,   336,   337,
     338,     0,     0,     0,     0,     0,     0,   339,   340,     0,
     341,     0,     0,   342,     0,     0,   343,   344,     0,     0,
     345,   346,     0,   347,   348,   349,     0,     0,     0,   350,
     351,   352,   353,     0,   354,   355,     0,   356,   357,     0,
       0,   358,   359,   360,   361,   362,     0,     0,     0,     0,
       0,   363,     0,   364,     0,     0,   365,   366,   367,   368,
       0,     0,   369,   370,     0,     0,   371,     0,     0,     0,
       0,   372,     0,     0,   373,     0,   374,     0,   375,   376,
       0,     0,     0,     0,     0,     0,     0,   377,     0,     0,
     378,     0,     0,   379,   380,   381,     0,     0,     0,     0,
     382,     0,   383,   384,     0,     0,     0,   385,     0,     0,
       0,     0,     0,     0,   122,     0,   123,   124,   125,   126,
     127,     0,     0,     0,  2010,     0,   128,     0,     0,   129,
       0,  2011,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
       0,     0,   328,   329,   330,     0,     0,   331,     0,     0,
       0,   332,   333,   334,   335,     0,   336,   337,   338,     0,
       0,     0,     0,     0,     0,   339,   340,     0,   341,     0,
       0,   342,     0,     0,   343,   344,     0,     0,   345,   346,
       0,   347,   348,   349,     0,     0,     0,   350,   351,   352,
     353,     0,   354,   355,     0,   356,   357,     0,     0,   358,
     359,   360,   361,   362,     0,     0,     0,     0,     0,   363,
       0,   364,     0,     0,   365,   366,   367,   368,     0,     0,
     369,   370,     0,     0,   371,     0,     0,     0,     0,   372,
       0,     0,   373,     0,   374,     0,   375,   376,     0,     0,
       0,     0,     0,     0,     0,   377,     0,     0,   378,     0,
       0,   379,   380,   381,     0,     0,     0,     0,   382,     0,
     383,   384,     0,     0,     0,   385,     0,     0,     0,     0,
       0,     0,   122,     0,   123,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   129,  3642,   886,
     130,   131,   132,   133,     0,   134,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,   140,
       0,   141,     0,   142,   143,     0,     0,   144,     0,   145,
       0,   146,   147,     0,   148,     0,   149,   150,   151,     0,
     152,     0,   153,   154,     0,   155,   156,   157,   158,   159,
       0,     0,   160,     0,   161,   162,     0,   163,   164,     0,
       0,     0,     0,   165,     0,     0,   166,     0,     0,     0,
       0,     0,     0,   167,   168,     0,     0,   169,     0,     0,
       0,     0,   170,   171,     0,     0,     0,     0,     0,   172,
       0,   173,     0,     0,     0,     0,     0,   174,     0,   175,
     176,   177,     0,     0,     0,   178,     0,     0,   179,   180,
     181,     0,     0,     0,   182,     0,     0,     0,   183,   184,
     185,   186,     0,     0,   187,     0,   188,   189,   190,     0,
       0,   191,     0,   192,     0,     0,   193,   194,     0,     0,
     195,   196,   197,     0,     0,   198,     0,     0,     0,     0,
     199,   200,     0,     0,   201,     0,   202,     0,     0,     0,
       0,     0,     0,   203,   204,     0,     0,   205,   206,     0,
     207,     0,     0,     0,     0,     0,   208,   209,     0,   210,
       0,     0,   211,     0,     0,     0,   212,   213,   214,   215,
       0,     0,   216,   217,     0,     0,     0,   218,     0,     0,
       0,   219,     0,     0,     0,   220,     0,   221,   222,     0,
     223,   224,     0,     0,     0,     0,     0,     0,   225,     0,
     226,     0,     0,     0,   227,     0,     0,   228,     0,     0,
       0,     0,     0,   229,     0,   230,     0,     0,   231,     0,
     232,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     233,   234,   235,   236,   237,   238,     0,   239,   240,   241,
     242,   243,   244,   245,   246,   247,     0,   248,   249,   250,
       0,   251,   252,     0,     0,     0,   253,   254,   255,   256,
     257,     0,     0,   258,   259,     0,     0,   260,     0,   261,
       0,   262,     0,     0,   263,   264,   265,   266,   267,   268,
     269,     0,     0,   270,   271,     0,   272,   273,   274,     0,
       0,     0,   275,     0,     0,     0,     0,   276,   277,     0,
     278,     0,   279,   280,   281,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   282,   283,   284,   285,     0,
     286,     0,   287,     0,   288,     0,     0,   289,   290,     0,
     291,     0,   292,   293,   294,   295,     0,   296,   297,   298,
     299,   300,   301,   302,   303,     0,     0,     0,     0,   304,
     305,     0,     0,   306,   307,   308,     0,   309,     0,   310,
     311,     0,     0,   312,     0,   313,   314,   315,     0,   316,
     317,     0,     0,     0,   318,   319,     0,   320,   321,     0,
     322,   323,   324,   325,     0,   326,   327,     0,     0,     0,
     328,   329,   330,     0,     0,   331,     0,     0,     0,   332,
     333,   334,   335,     0,   336,   337,   338,     0,     0,     0,
       0,     0,     0,   339,   340,     0,   341,     0,     0,   342,
       0,     0,   343,   344,     0,     0,   345,   346,     0,   347,
     348,   349,     0,     0,     0,   350,   351,   352,   353,     0,
     354,   355,     0,   356,   357,     0,     0,   358,   359,   360,
     361,   362,     0,     0,     0,     0,     0,   363,     0,   364,
       0,     0,   365,   366,   367,   368,     0,     0,   369,   370,
       0,     0,   371,     0,     0,     0,     0,   372,     0,     0,
     373,     0,   374,     0,   375,   376,     0,     0,     0,     0,
       0,     0,     0,   377,     0,     0,   378,     0,     0,   379,
     380,   381,     0,     0,     0,     0,   382,     0,   383,   384,
       0,     0,     0,   385,     0,   122,     0,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,   421,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   475,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,   328,   329,   330,     0,     0,   331,     0,
       0,     0,   332,   333,   334,   335,     0,   336,   337,   338,
       0,     0,     0,     0,     0,     0,   339,   340,     0,   341,
       0,     0,   342,     0,     0,   343,   344,     0,     0,   345,
     346,     0,   347,   348,   349,     0,     0,     0,   350,   351,
     352,   353,     0,   354,   355,     0,   356,   357,     0,     0,
     358,   359,   360,   361,   362,     0,     0,     0,     0,     0,
     363,     0,   364,     0,     0,   365,   366,   367,   368,     0,
       0,   369,   370,     0,     0,   371,     0,     0,     0,     0,
     372,     0,     0,   373,     0,   374,     0,   375,   376,     0,
       0,     0,     0,     0,     0,     0,   377,     0,     0,   378,
       0,     0,   379,   380,   381,     0,     0,     0,     0,   382,
       0,   383,   384,     0,     0,     0,   385,     0,   122,     0,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
     421,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,   140,     0,   141,     0,   142,
     143,     0,     0,   144,     0,   145,     0,   146,   147,     0,
     148,     0,   149,   150,   151,     0,   152,     0,   153,   154,
       0,   155,   156,   157,   158,   159,     0,     0,   160,     0,
     161,   162,     0,   163,   164,     0,     0,     0,     0,   165,
       0,     0,   166,     0,     0,     0,     0,     0,     0,   167,
     168,     0,     0,   169,     0,     0,     0,     0,   170,   171,
       0,     0,     0,     0,     0,   172,     0,   173,     0,     0,
       0,     0,     0,   174,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,   179,   180,   181,     0,     0,     0,
     182,     0,     0,     0,   183,   184,   185,   186,     0,     0,
     187,     0,   188,   189,   190,     0,     0,   191,     0,   192,
       0,     0,   193,   194,     0,     0,   195,   196,   197,     0,
       0,   198,     0,     0,     0,     0,   199,   200,     0,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,   205,   206,     0,   207,     0,     0,     0,
       0,     0,   208,   209,     0,   210,     0,     0,   211,     0,
       0,     0,   212,   213,   214,   215,     0,     0,   216,   217,
       0,     0,     0,   218,     0,     0,     0,   219,     0,     0,
       0,   220,     0,   221,   222,     0,   223,   224,     0,     0,
       0,     0,     0,     0,   225,     0,   226,     0,     0,     0,
     227,     0,     0,   228,     0,     0,     0,     0,     0,   229,
       0,   230,     0,     0,   231,     0,   232,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   233,   234,   235,   236,
     237,   238,     0,   239,   240,   241,   242,   243,   244,   245,
     246,   247,     0,   248,   249,   250,     0,   251,   252,     0,
       0,     0,   253,   254,   255,   256,   257,     0,     0,   258,
     259,     0,     0,   260,     0,   261,     0,   262,     0,     0,
     263,   264,   265,   266,   267,   268,   269,     0,     0,   270,
     271,     0,   272,   273,   274,     0,     0,     0,   275,     0,
       0,     0,     0,   276,   277,     0,   278,     0,   279,   280,
     281,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   282,   283,   284,   285,     0,   286,     0,   287,     0,
     288,     0,     0,   289,   290,     0,   291,     0,   292,   293,
     294,   295,     0,   296,   297,   298,   299,   300,   301,   302,
     303,     0,     0,     0,     0,   304,   305,     0,     0,   306,
     307,   308,     0,   309,     0,   310,   311,     0,     0,   312,
       0,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,     0,   320,   321,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,   328,   329,   330,     0,
       0,   331,     0,     0,     0,   332,   333,   334,   335,     0,
     336,   337,   338,     0,     0,     0,     0,     0,     0,   339,
     340,     0,   341,     0,     0,   342,     0,     0,   343,   344,
       0,     0,   345,   346,     0,   347,   348,   349,     0,     0,
       0,   350,   351,   352,   353,     0,   354,   355,     0,   356,
     357,     0,     0,   358,   359,   360,   361,   362,     0,     0,
       0,     0,     0,   363,     0,   364,     0,     0,   365,   366,
     367,   368,     0,     0,   369,   370,     0,     0,   371,     0,
       0,     0,     0,   372,     0,     0,   373,     0,   374,     0,
     375,   376,     0,     0,     0,     0,     0,     0,     0,   377,
       0,     0,   378,     0,     0,   379,   380,   381,     0,     0,
       0,     0,   382,     0,   383,   384,     0,     0,     0,   385,
       0,   122,     0,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   129,     0,     0,   130,
     131,   132,   133,   886,   134,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,   140,     0,
     141,     0,   142,   143,     0,     0,   144,     0,   145,     0,
     146,   147,     0,   148,     0,   149,   150,   151,     0,   152,
       0,   153,   154,     0,   155,   156,   157,   158,   159,     0,
       0,   160,     0,   161,   162,     0,   163,   164,     0,     0,
       0,     0,   165,     0,     0,   166,     0,     0,     0,     0,
       0,     0,   167,   168,     0,     0,   169,     0,     0,     0,
       0,   170,   171,     0,     0,     0,     0,     0,   172,     0,
     173,     0,     0,     0,     0,     0,   174,     0,   175,   176,
     177,     0,     0,     0,   178,     0,     0,   179,   180,   181,
       0,     0,     0,   182,     0,     0,     0,   183,   184,   185,
     186,     0,     0,   187,     0,   188,   189,   190,     0,     0,
     191,     0,   192,     0,     0,   193,   194,     0,     0,   195,
     196,   197,     0,     0,   198,     0,     0,     0,     0,   199,
     200,     0,     0,   201,     0,   202,     0,     0,     0,     0,
       0,     0,   203,   204,     0,     0,   205,   206,     0,   207,
       0,     0,     0,     0,     0,   208,   209,     0,   210,     0,
       0,   211,     0,     0,     0,   212,   213,   214,   215,     0,
       0,   216,   217,     0,     0,     0,   218,     0,     0,     0,
     219,     0,     0,     0,   220,     0,   221,   222,     0,   223,
     224,     0,     0,     0,     0,     0,     0,   225,     0,   226,
       0,     0,     0,   227,     0,     0,   228,     0,     0,     0,
       0,     0,   229,     0,   230,     0,     0,   231,     0,   232,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   233,
     234,   235,   236,   237,   238,     0,   239,   240,   241,   242,
     243,   244,   245,   246,   247,     0,   248,   249,   250,     0,
     251,   252,     0,     0,     0,   253,   254,   255,   256,   257,
       0,     0,   258,   259,     0,     0,   260,     0,   261,     0,
     262,     0,     0,   263,   264,   265,   266,   267,   268,   269,
       0,     0,   270,   271,     0,   272,   273,   274,     0,     0,
       0,   275,     0,     0,     0,     0,   276,   277,     0,   278,
       0,   279,   280,   281,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   285,     0,   286,
       0,   287,     0,   288,     0,     0,   289,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     300,   301,   302,   303,     0,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,   310,   311,
       0,     0,   312,     0,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,     0,   320,   321,     0,   322,
     323,   324,   325,     0,   326,   327,     0,     0,     0,   328,
     329,   330,     0,     0,   331,     0,     0,     0,   332,   333,
     334,   335,     0,   336,   337,   338,     0,     0,     0,     0,
       0,     0,   339,   340,     0,   341,     0,     0,   342,     0,
       0,   343,   344,     0,     0,   345,   346,     0,   347,   348,
     349,     0,     0,     0,   350,   351,   352,   353,     0,   354,
     355,     0,   356,   357,     0,     0,   358,   359,   360,   361,
     362,     0,     0,     0,     0,     0,   363,     0,   364,     0,
       0,   365,   366,   367,   368,     0,     0,   369,   370,     0,
       0,   371,     0,     0,     0,     0,   372,     0,     0,   373,
       0,   374,     0,   375,   376,     0,     0,     0,     0,     0,
       0,     0,   377,     0,     0,   378,     0,     0,   379,   380,
     381,     0,     0,     0,     0,   382,     0,   383,   384,     0,
       0,     0,   385,     0,   122,     0,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,  2011,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
     560,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
       0,     0,   328,   329,   330,     0,     0,   331,     0,     0,
       0,   332,   333,   334,   335,     0,   336,   337,   338,     0,
       0,     0,     0,     0,     0,   339,   340,     0,   341,     0,
       0,   342,     0,     0,   343,   344,     0,     0,   345,   346,
       0,   347,   348,   349,     0,     0,     0,   350,   351,   352,
     353,     0,   354,   355,     0,   356,   357,     0,   561,   358,
     359,   360,   361,   362,     0,     0,     0,     0,     0,   363,
       0,   364,     0,     0,   365,   366,   367,   368,     0,     0,
     369,   370,     0,     0,   371,     0,     0,     0,     0,   372,
       0,     0,   373,     0,   374,     0,   375,   376,     0,     0,
       0,     0,     0,     0,     0,   377,     0,     0,   378,     0,
       0,   379,   380,   381,     0,     0,     0,     0,   382,     0,
     383,   384,     0,     0,   122,   385,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,  1772,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
     560,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
       0,     0,   328,   329,   330,     0,     0,   331,     0,     0,
       0,   332,   333,   334,   335,     0,   336,   337,   338,     0,
       0,     0,     0,     0,     0,   339,   340,     0,   341,     0,
       0,   342,     0,     0,   343,   344,     0,     0,   345,   346,
       0,   347,   348,   349,     0,     0,     0,   350,   351,   352,
     353,     0,   354,   355,     0,   356,   357,     0,   561,   358,
     359,   360,   361,   362,     0,     0,     0,     0,     0,   363,
       0,   364,     0,     0,   365,   366,   367,   368,     0,     0,
     369,   370,     0,     0,   371,     0,     0,     0,     0,   372,
       0,     0,   373,     0,   374,     0,   375,   376,     0,     0,
       0,     0,     0,     0,     0,   377,     0,     0,   378,     0,
       0,   379,   380,   381,     0,     0,     0,     0,   382,     0,
     383,   384,     0,     0,   122,   385,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,  2319,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,   142,   143,     0,     0,   144,
       0,   145,     0,   146,   147,     0,   148,     0,   149,   150,
     151,     0,   152,     0,   153,   154,     0,   155,   156,   157,
     158,   159,     0,     0,   160,     0,   161,   162,     0,   163,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,   171,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
     183,   184,   185,   186,     0,     0,   187,     0,   188,   189,
     190,     0,     0,   191,     0,   192,     0,     0,   193,   194,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,   208,   209,
       0,   210,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,     0,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,     0,     0,     0,     0,     0,     0,
     225,     0,   226,     0,     0,     0,   227,     0,     0,   228,
     560,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,   275,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,   281,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,   289,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,   310,   311,     0,     0,   312,     0,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,     0,   320,
     321,     0,   322,   323,   324,   325,     0,   326,   327,     0,
       0,     0,   328,   329,   330,     0,     0,   331,     0,     0,
       0,   332,   333,   334,   335,     0,   336,   337,   338,     0,
       0,     0,     0,     0,     0,   339,   340,     0,   341,     0,
       0,   342,     0,     0,   343,   344,     0,     0,   345,   346,
       0,   347,   348,   349,     0,     0,     0,   350,   351,   352,
     353,     0,   354,   355,     0,   356,   357,     0,   561,   358,
     359,   360,   361,   362,     0,     0,     0,     0,     0,   363,
       0,   364,     0,     0,   365,   366,   367,   368,     0,     0,
     369,   370,     0,     0,   371,     0,     0,     0,     0,   372,
       0,     0,   373,     0,   374,     0,   375,   376,     0,     0,
       0,     0,     0,     0,     0,   377,     0,     0,   378,     0,
       0,   379,   380,   381,     0,     0,     0,     0,   382,     0,
     383,   384,     0,     0,   122,   385,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,     0,
       0,     0,   130,   131,   132,     0,     0,  -186,  2912,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,     0,     0,     0,     0,   144,
       0,   145,     0,   146,     0,     0,     0,     0,   149,   150,
    3484,     0,   152,     0,   153,   154,     0,     0,   156,     0,
     158,   159,     0,     0,   160,     0,   161,   162,     0,     0,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,     0,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,     0,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
       0,   184,   185,   186,     0,     0,   187,     0,   188,   189,
       0,     0,     0,   191,     0,   192,     0,     0,   193,   194,
    3485,     0,   195,   196,   197,     0,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,     0,   209,
       0,     0,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,  3486,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,  3487,     0,     0,     0,     0,     0,
       0,     0,   226,     0,     0,     0,   227,  3488,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,  -186,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,  3489,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,     0,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,     0,   311,  -186,     0,   312,     0,     0,   314,     0,
       0,   316,   317,  3490,     0,     0,     0,   319,     0,   320,
     321,     0,   322,   323,   324,     0,     0,   326,     0,     0,
       0,     0,   328,   329,   330,     0,     0,   331,     0,     0,
       0,   332,     0,   334,     0,     0,   336,   337,   338,     0,
       0,     0,     0,     0,     0,   339,   340,     0,   341,     0,
       0,   342,     0,     0,     0,   344,     0,     0,     0,   346,
       0,   347,   348,   349,     0,     0,     0,   350,   351,   352,
     353,     0,   354,   355,     0,   356,   357,     0,     0,   358,
     359,   360,   361,   362,     0,     0,     0,     0,     0,   363,
       0,   364,     0,     0,     0,   366,   367,   368,     0,     0,
     369,   370,     0,     0,     0,     0,     0,     0,     0,   372,
       0,     0,   373,     0,     0,     0,   375,   376,     0,     0,
       0,     0,     0,     0,     0,   377,     0,     0,   378,     0,
       0,   379,   380,   381,     0,     0,  -186,     0,   382,     0,
     383,     0,     0,     0,     0,   385,     0,     0,     0,     0,
    3491,   122,     0,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,  3693,     0,   129,     0,     0,   130,
     131,   132,   133,     0,   134,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,   140,     0,
     141,     0,   142,   143,     0,     0,   144,     0,   145,     0,
     146,   147,     0,   148,     0,   149,   150,   151,     0,   152,
       0,   153,   154,     0,   155,   156,   157,   158,   159,     0,
       0,   160,     0,   161,   162,     0,   163,   164,     0,     0,
       0,     0,   165,     0,     0,   166,     0,     0,     0,     0,
       0,     0,   167,   168,     0,     0,   169,     0,     0,     0,
       0,   170,   171,     0,     0,     0,     0,     0,   172,     0,
     173,     0,     0,     0,     0,     0,   174,     0,   175,   176,
     177,     0,     0,     0,   178,     0,     0,   179,   180,   181,
       0,     0,     0,   182,     0,     0,     0,   183,   184,   185,
     186,     0,     0,   187,     0,   188,   189,   190,     0,     0,
     191,     0,   192,     0,     0,   193,   194,     0,     0,   195,
     196,   197,     0,     0,   198,     0,     0,     0,     0,   199,
     200,     0,     0,   201,     0,   202,     0,     0,     0,     0,
       0,     0,   203,   204,     0,     0,   205,   206,     0,   207,
       0,     0,     0,     0,     0,   208,   209,     0,   210,     0,
       0,   211,     0,     0,     0,   212,   213,   214,   215,     0,
       0,   216,   217,     0,     0,     0,   218,     0,     0,     0,
     219,     0,     0,     0,   220,     0,   221,   222,     0,   223,
     224,     0,     0,     0,     0,     0,     0,   225,     0,   226,
       0,     0,     0,   227,     0,     0,   228,     0,     0,     0,
       0,     0,   229,     0,   230,     0,     0,   231,     0,   232,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   233,
     234,   235,   236,   237,   238,     0,   239,   240,   241,   242,
     243,   244,   245,   246,   247,     0,   248,   249,   250,     0,
     251,   252,     0,     0,     0,   253,   254,   255,   256,   257,
       0,     0,   258,   259,     0,     0,   260,     0,   261,     0,
     262,     0,     0,   263,   264,   265,   266,   267,   268,   269,
       0,     0,   270,   271,     0,   272,   273,   274,     0,     0,
       0,   275,     0,     0,     0,     0,   276,   277,     0,   278,
       0,   279,   280,   281,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   282,   283,   284,   285,     0,   286,
       0,   287,     0,   288,     0,     0,   289,   290,     0,   291,
       0,   292,   293,   294,   295,     0,   296,   297,   298,   299,
     300,   301,   302,   303,     0,     0,     0,     0,   304,   305,
       0,     0,   306,   307,   308,     0,   309,     0,   310,   311,
       0,     0,   312,     0,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,     0,   320,   321,     0,   322,
     323,   324,   325,     0,   326,   327,     0,     0,     0,   328,
     329,   330,     0,     0,   331,     0,     0,     0,   332,   333,
     334,   335,     0,   336,   337,   338,     0,     0,     0,     0,
       0,     0,   339,   340,     0,   341,     0,     0,   342,     0,
       0,   343,   344,     0,     0,   345,   346,     0,   347,   348,
     349,     0,     0,     0,   350,   351,   352,   353,     0,   354,
     355,     0,   356,   357,     0,     0,   358,   359,   360,   361,
     362,     0,     0,     0,     0,     0,   363,     0,   364,     0,
       0,   365,   366,   367,   368,     0,     0,   369,   370,     0,
       0,   371,     0,     0,     0,     0,   372,     0,     0,   373,
       0,   374,     0,   375,   376,     0,     0,     0,     0,     0,
       0,     0,   377,     0,     0,   378,     0,     0,   379,   380,
     381,     0,     0,     0,     0,   382,     0,   383,   384,     0,
       0,     0,   385,   122,     0,   123,   124,   125,   126,   127,
       0,     0,     0,  1615,     0,   128,     0,     0,   129,     0,
       0,   130,   131,   132,   133,     0,   134,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
     140,     0,   141,     0,   142,   143,     0,     0,   144,     0,
     145,     0,   146,   147,     0,   148,     0,   149,   150,   151,
       0,   152,     0,   153,   154,     0,   155,   156,   157,   158,
     159,     0,     0,   160,     0,   161,   162,     0,   163,   164,
       0,     0,     0,     0,   165,     0,     0,   166,     0,     0,
       0,     0,     0,     0,   167,   168,     0,     0,   169,     0,
       0,     0,     0,   170,   171,     0,     0,     0,     0,     0,
     172,     0,   173,     0,     0,     0,     0,     0,   174,     0,
     175,   176,   177,     0,     0,     0,   178,     0,     0,   179,
     180,   181,     0,     0,     0,   182,     0,     0,     0,   183,
     184,   185,   186,     0,     0,   187,     0,   188,   189,   190,
       0,     0,   191,     0,   192,     0,     0,   193,   194,     0,
       0,   195,   196,   197,     0,     0,   198,     0,     0,     0,
       0,   199,   200,     0,     0,   201,     0,   202,     0,     0,
       0,     0,     0,     0,   203,   204,     0,     0,   205,   206,
       0,   207,     0,     0,     0,     0,     0,   208,   209,     0,
     210,     0,     0,   211,     0,     0,     0,   212,   213,   214,
     215,     0,     0,   216,   217,     0,     0,     0,   218,     0,
       0,     0,   219,     0,     0,     0,   220,     0,   221,   222,
       0,   223,   224,     0,     0,     0,     0,     0,     0,   225,
       0,   226,     0,     0,     0,   227,     0,     0,   228,     0,
       0,     0,     0,     0,   229,     0,   230,     0,     0,   231,
       0,   232,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   233,   234,   235,   236,   237,   238,     0,   239,   240,
     241,   242,   243,   244,   245,   246,   247,     0,   248,   249,
     250,     0,   251,   252,     0,     0,     0,   253,   254,   255,
     256,   257,     0,     0,   258,   259,     0,     0,   260,     0,
     261,     0,   262,     0,     0,   263,   264,   265,   266,   267,
     268,   269,     0,     0,   270,   271,     0,   272,   273,   274,
       0,     0,     0,   275,     0,     0,     0,     0,   276,   277,
       0,   278,     0,   279,   280,   281,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   282,   283,   284,   285,
       0,   286,     0,   287,     0,   288,     0,     0,   289,   290,
       0,   291,     0,   292,   293,   294,   295,     0,   296,   297,
     298,   299,   300,   301,   302,   303,     0,     0,     0,     0,
     304,   305,     0,     0,   306,   307,   308,     0,   309,     0,
     310,   311,     0,     0,   312,     0,   313,   314,   315,     0,
     316,   317,     0,     0,     0,   318,   319,     0,   320,   321,
       0,   322,   323,   324,   325,     0,   326,   327,     0,     0,
       0,   328,   329,   330,     0,     0,   331,     0,     0,     0,
     332,   333,   334,   335,     0,   336,   337,   338,     0,     0,
       0,     0,     0,     0,   339,   340,     0,   341,     0,     0,
     342,     0,     0,   343,   344,     0,     0,   345,   346,     0,
     347,   348,   349,     0,     0,     0,   350,   351,   352,   353,
       0,   354,   355,     0,   356,   357,     0,     0,   358,   359,
     360,   361,   362,     0,     0,     0,     0,     0,   363,     0,
     364,     0,     0,   365,   366,   367,   368,     0,     0,   369,
     370,     0,     0,   371,     0,     0,     0,     0,   372,     0,
       0,   373,     0,   374,     0,   375,   376,     0,     0,     0,
       0,     0,     0,     0,   377,     0,     0,   378,     0,     0,
     379,   380,   381,     0,     0,     0,     0,   382,     0,   383,
     384,     0,     0,     0,   385,   122,     0,   123,   124,   125,
     126,   127,     0,     0,     0,  2305,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,   140,     0,   141,     0,   142,   143,     0,     0,
     144,     0,   145,     0,   146,   147,     0,   148,     0,   149,
     150,   151,     0,   152,     0,   153,   154,     0,   155,   156,
     157,   158,   159,     0,     0,   160,     0,   161,   162,     0,
     163,   164,     0,     0,     0,     0,   165,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   167,   168,     0,     0,
     169,     0,     0,     0,     0,   170,   171,     0,     0,     0,
       0,     0,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,   179,   180,   181,     0,     0,     0,   182,     0,     0,
       0,   183,   184,   185,   186,     0,     0,   187,     0,   188,
     189,   190,     0,     0,   191,     0,   192,     0,     0,   193,
     194,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,   203,   204,     0,     0,
     205,   206,     0,   207,     0,     0,     0,     0,     0,   208,
     209,     0,   210,     0,     0,   211,     0,     0,     0,   212,
     213,   214,   215,     0,     0,   216,   217,     0,     0,     0,
     218,     0,     0,     0,   219,     0,     0,     0,   220,     0,
     221,   222,     0,   223,   224,     0,     0,     0,     0,     0,
       0,   225,     0,   226,     0,     0,     0,   227,     0,     0,
     228,     0,     0,     0,     0,     0,   229,     0,   230,     0,
       0,   231,     0,   232,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   233,   234,   235,   236,   237,   238,     0,
     239,   240,   241,   242,   243,   244,   245,   246,   247,     0,
     248,   249,   250,     0,   251,   252,     0,     0,     0,   253,
     254,   255,   256,   257,     0,     0,   258,   259,     0,     0,
     260,     0,   261,     0,   262,     0,     0,   263,   264,   265,
     266,   267,   268,   269,     0,     0,   270,   271,     0,   272,
     273,   274,     0,     0,     0,   275,     0,     0,     0,     0,
     276,   277,     0,   278,     0,   279,   280,   281,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   282,   283,
     284,   285,     0,   286,     0,   287,     0,   288,     0,     0,
     289,   290,     0,   291,     0,   292,   293,   294,   295,     0,
     296,   297,   298,   299,   300,   301,   302,   303,     0,     0,
       0,     0,   304,   305,     0,     0,   306,   307,   308,     0,
     309,     0,   310,   311,     0,     0,   312,     0,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,     0,
     320,   321,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,   328,   329,   330,     0,     0,   331,     0,
       0,     0,   332,   333,   334,   335,     0,   336,   337,   338,
       0,     0,     0,     0,     0,     0,   339,   340,     0,   341,
       0,     0,   342,     0,     0,   343,   344,     0,     0,   345,
     346,     0,   347,   348,   349,     0,     0,     0,   350,   351,
     352,   353,     0,   354,   355,     0,   356,   357,     0,     0,
     358,   359,   360,   361,   362,     0,     0,     0,     0,     0,
     363,     0,   364,     0,     0,   365,   366,   367,   368,     0,
       0,   369,   370,     0,     0,   371,     0,     0,     0,     0,
     372,     0,     0,   373,     0,   374,     0,   375,   376,     0,
       0,     0,     0,     0,     0,     0,   377,     0,     0,   378,
       0,     0,   379,   380,   381,     0,     0,     0,     0,   382,
       0,   383,   384,     0,     0,     0,   385,   122,     0,   123,
     124,   125,   126,   127,     0,     0,     0,  2593,     0,   128,
       0,     0,   129,     0,     0,   130,   131,   132,   133,     0,
     134,     0,   135,     0,     0,   136,     0,     0,     0,   137,
       0,     0,   138,   139,   140,     0,   141,     0,   142,   143,
       0,     0,   144,     0,   145,     0,   146,   147,     0,   148,
       0,   149,   150,   151,     0,   152,     0,   153,   154,     0,
     155,   156,   157,   158,   159,     0,     0,   160,     0,   161,
     162,     0,   163,   164,     0,     0,     0,     0,   165,     0,
       0,   166,     0,     0,     0,     0,     0,     0,   167,   168,
       0,     0,   169,     0,     0,     0,     0,   170,   171,     0,
       0,     0,     0,     0,   172,     0,   173,     0,     0,     0,
       0,     0,   174,     0,   175,   176,   177,     0,     0,     0,
     178,     0,     0,   179,   180,   181,     0,     0,     0,   182,
       0,     0,     0,   183,   184,   185,   186,     0,     0,   187,
       0,   188,   189,   190,     0,     0,   191,     0,   192,     0,
       0,   193,   194,     0,     0,   195,   196,   197,     0,     0,
     198,     0,     0,     0,     0,   199,   200,     0,     0,   201,
       0,   202,     0,     0,     0,     0,     0,     0,   203,   204,
       0,     0,   205,   206,     0,   207,     0,     0,     0,     0,
       0,   208,   209,     0,   210,     0,     0,   211,     0,     0,
       0,   212,   213,   214,   215,     0,     0,   216,   217,     0,
       0,     0,   218,     0,     0,     0,   219,     0,     0,     0,
     220,     0,   221,   222,     0,   223,   224,     0,     0,     0,
       0,     0,     0,   225,     0,   226,     0,     0,     0,   227,
       0,     0,   228,     0,     0,     0,     0,     0,   229,     0,
     230,     0,     0,   231,     0,   232,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   233,   234,   235,   236,   237,
     238,     0,   239,   240,   241,   242,   243,   244,   245,   246,
     247,     0,   248,   249,   250,     0,   251,   252,     0,     0,
       0,   253,   254,   255,   256,   257,     0,     0,   258,   259,
       0,     0,   260,     0,   261,     0,   262,     0,     0,   263,
     264,   265,   266,   267,   268,   269,     0,     0,   270,   271,
       0,   272,   273,   274,     0,     0,     0,   275,     0,     0,
       0,     0,   276,   277,     0,   278,     0,   279,   280,   281,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     282,   283,   284,   285,     0,   286,     0,   287,     0,   288,
       0,     0,   289,   290,     0,   291,     0,   292,   293,   294,
     295,     0,   296,   297,   298,   299,   300,   301,   302,   303,
       0,     0,     0,     0,   304,   305,     0,     0,   306,   307,
     308,     0,   309,     0,   310,   311,     0,     0,   312,     0,
     313,   314,   315,     0,   316,   317,     0,     0,     0,   318,
     319,     0,   320,   321,     0,   322,   323,   324,   325,     0,
     326,   327,     0,     0,     0,   328,   329,   330,     0,     0,
     331,     0,     0,     0,   332,   333,   334,   335,     0,   336,
     337,   338,     0,     0,     0,     0,     0,     0,   339,   340,
       0,   341,     0,     0,   342,     0,     0,   343,   344,     0,
       0,   345,   346,     0,   347,   348,   349,     0,     0,     0,
     350,   351,   352,   353,     0,   354,   355,     0,   356,   357,
       0,     0,   358,   359,   360,   361,   362,     0,     0,     0,
       0,     0,   363,     0,   364,     0,     0,   365,   366,   367,
     368,     0,     0,   369,   370,     0,     0,   371,     0,     0,
       0,     0,   372,     0,     0,   373,     0,   374,     0,   375,
     376,     0,     0,     0,     0,     0,     0,     0,   377,     0,
       0,   378,     0,     0,   379,   380,   381,     0,     0,     0,
       0,   382,     0,   383,   384,     0,     0,     0,   385,   122,
       0,   123,   124,   125,   126,   127,     0,     0,     0,  2917,
       0,   128,     0,     0,     0,     0,     0,   130,   131,   132,
       0,     0,  -186,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
       0,     0,     0,     0,   144,     0,   145,     0,   146,     0,
       0,     0,     0,   149,   150,  3484,     0,   152,     0,   153,
     154,     0,     0,   156,     0,   158,   159,     0,     0,   160,
       0,   161,   162,     0,     0,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
       0,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,     0,     0,     0,   179,   180,   181,     0,  -201,
       0,   182,     0,     0,     0,  -201,   184,   185,   186,     0,
       0,   187,     0,   188,   189,     0,     0,     0,   191,     0,
     192,     0,     0,   193,   194,  3485,     0,   195,   196,   197,
       0,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,     0,   209,     0,     0,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,  3486,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,  3487,
       0,     0,     0,     0,     0,     0,     0,   226,     0,     0,
       0,   227,  3488,     0,   228,     0,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,  -186,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,  3489,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,     0,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,     0,   311,  -186,     0,
     312,     0,     0,   314,     0,     0,   316,   317,  3490,     0,
       0,     0,   319,     0,   320,   321,     0,   322,   323,   324,
       0,     0,   326,     0,     0,     0,     0,   328,   329,   330,
       0,     0,   331,     0,     0,     0,   332,     0,   334,     0,
       0,   336,   337,   338,     0,     0,     0,     0,     0,     0,
     339,   340,     0,   341,     0,     0,   342,     0,     0,     0,
     344,     0,     0,     0,   346,     0,   347,   348,   349,     0,
       0,     0,   350,   351,   352,   353,     0,   354,   355,     0,
     356,   357,     0,     0,   358,   359,   360,   361,   362,     0,
       0,     0,     0,     0,   363,     0,   364,     0,     0,     0,
     366,   367,   368,     0,     0,   369,   370,     0,     0,     0,
       0,     0,     0,     0,   372,     0,     0,   373,     0,     0,
       0,   375,   376,     0,     0,     0,     0,     0,     0,     0,
     377,     0,     0,   378,     0,     0,   379,   380,   381,     0,
       0,  -186,     0,   382,     0,   383,     0,     0,     0,     0,
     385,     0,     0,  -201,   122,  3491,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,     0,
       0,     0,   130,   131,   132,     0,     0,  -186,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,     0,     0,     0,     0,   144,
       0,   145,     0,   146,     0,     0,     0,     0,   149,   150,
    3484,     0,   152,     0,   153,   154,     0,     0,   156,     0,
     158,   159,     0,     0,   160,     0,   161,   162,     0,     0,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,     0,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,     0,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
    -222,   184,   185,   186,     0,     0,   187,     0,   188,   189,
       0,     0,     0,   191,     0,   192,     0,     0,   193,   194,
    3485,     0,   195,   196,   197,     0,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,     0,   209,
       0,     0,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,  3486,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,  3487,     0,     0,     0,     0,     0,
       0,     0,   226,     0,     0,     0,   227,  3488,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,  -186,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,  3489,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,     0,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,     0,   311,  -186,     0,   312,     0,     0,   314,     0,
       0,   316,   317,  3490,     0,     0,     0,   319,     0,   320,
     321,     0,   322,   323,   324,     0,     0,   326,     0,     0,
       0,     0,   328,   329,   330,     0,     0,   331,     0,     0,
       0,   332,     0,   334,     0,     0,   336,   337,   338,     0,
       0,     0,     0,     0,     0,   339,   340,     0,   341,     0,
       0,   342,     0,     0,     0,   344,     0,     0,     0,   346,
       0,   347,   348,   349,     0,     0,     0,   350,   351,   352,
     353,     0,   354,   355,     0,   356,   357,     0,     0,   358,
     359,   360,   361,   362,     0,     0,     0,     0,     0,   363,
       0,   364,     0,     0,     0,   366,   367,   368,     0,     0,
     369,   370,     0,     0,     0,     0,     0,     0,     0,   372,
       0,     0,   373,     0,     0,     0,   375,   376,     0,     0,
       0,     0,     0,     0,     0,   377,     0,     0,   378,     0,
       0,   379,   380,   381,  -222,     0,  -186,     0,   382,     0,
     383,     0,     0,     0,     0,   385,     0,     0,  -222,   122,
    3491,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,     0,     0,     0,   130,   131,   132,
       0,     0,  -186,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
       0,     0,     0,     0,   144,     0,   145,     0,   146,     0,
       0,     0,     0,   149,   150,  3484,     0,   152,     0,   153,
     154,     0,     0,   156,     0,   158,   159,     0,     0,   160,
       0,   161,   162,     0,     0,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
       0,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,     0,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,  -219,   184,   185,   186,     0,
       0,   187,     0,   188,   189,     0,     0,     0,   191,     0,
     192,     0,     0,   193,   194,  3485,     0,   195,   196,   197,
       0,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,     0,   209,     0,     0,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,  3486,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,  3487,
       0,     0,     0,     0,     0,     0,     0,   226,     0,     0,
       0,   227,  3488,     0,   228,     0,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,  -186,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,  3489,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,     0,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,     0,   311,  -186,     0,
     312,     0,     0,   314,     0,     0,   316,   317,  3490,     0,
       0,     0,   319,     0,   320,   321,     0,   322,   323,   324,
       0,     0,   326,     0,     0,     0,     0,   328,   329,   330,
       0,     0,   331,     0,     0,     0,   332,     0,   334,     0,
       0,   336,   337,   338,     0,     0,     0,     0,     0,     0,
     339,   340,     0,   341,     0,     0,   342,     0,     0,     0,
     344,     0,     0,     0,   346,     0,   347,   348,   349,     0,
       0,     0,   350,   351,   352,   353,     0,   354,   355,     0,
     356,   357,     0,     0,   358,   359,   360,   361,   362,     0,
       0,     0,     0,     0,   363,     0,   364,     0,     0,     0,
     366,   367,   368,     0,     0,   369,   370,     0,     0,     0,
       0,     0,     0,     0,   372,     0,     0,   373,     0,     0,
       0,   375,   376,     0,     0,     0,     0,     0,     0,     0,
     377,     0,     0,   378,     0,     0,   379,   380,   381,  -219,
       0,  -186,     0,   382,     0,   383,     0,     0,     0,     0,
     385,     0,     0,  -219,   122,  3491,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,     0,
       0,     0,   130,   131,   132,     0,     0,  -186,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,     0,     0,     0,     0,   144,
       0,   145,     0,   146,     0,     0,     0,     0,   149,   150,
    3484,     0,   152,     0,   153,   154,     0,     0,   156,     0,
     158,   159,     0,     0,   160,     0,   161,   162,     0,     0,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,     0,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,     0,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
    3571,   184,   185,   186,     0,     0,   187,     0,   188,   189,
       0,     0,     0,   191,     0,   192,     0,     0,   193,   194,
    3485,     0,   195,   196,   197,     0,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,     0,   209,
       0,     0,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,  3486,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,  3487,     0,     0,     0,     0,     0,
       0,     0,   226,     0,     0,     0,   227,  3488,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,  -186,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,  3489,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,     0,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,     0,   311,  -186,     0,   312,     0,     0,   314,     0,
       0,   316,   317,  3490,     0,     0,     0,   319,     0,   320,
     321,     0,   322,   323,   324,     0,     0,   326,     0,     0,
       0,     0,   328,   329,   330,     0,     0,   331,     0,     0,
       0,   332,     0,   334,     0,     0,   336,   337,   338,     0,
       0,     0,     0,     0,     0,   339,   340,     0,   341,     0,
       0,   342,     0,     0,     0,   344,     0,     0,     0,   346,
       0,   347,   348,   349,     0,     0,     0,   350,   351,   352,
     353,     0,   354,   355,     0,   356,   357,     0,     0,   358,
     359,   360,   361,   362,     0,     0,     0,     0,     0,   363,
       0,   364,     0,     0,     0,   366,   367,   368,     0,     0,
     369,   370,     0,     0,     0,     0,     0,     0,     0,   372,
       0,     0,   373,     0,     0,     0,   375,   376,     0,     0,
       0,     0,     0,     0,     0,   377,     0,     0,   378,     0,
       0,   379,   380,   381,     0,     0,  -186,     0,   382,     0,
     383,     0,     0,     0,     0,   385,     0,     0,     0,   122,
    3491,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,     0,     0,     0,   130,   131,   132,
       0,     0,  -186,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
       0,     0,     0,     0,   144,     0,   145,     0,   146,     0,
       0,     0,     0,   149,   150,  3484,     0,   152,     0,   153,
     154,     0,     0,   156,     0,   158,   159,     0,     0,   160,
       0,   161,   162,     0,     0,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
       0,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,     0,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,  -224,   184,   185,   186,     0,
       0,   187,     0,   188,   189,     0,     0,     0,   191,     0,
     192,     0,     0,   193,   194,  3485,     0,   195,   196,   197,
       0,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,     0,   209,     0,     0,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,  3486,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,  3487,
       0,     0,     0,     0,     0,     0,     0,   226,     0,     0,
       0,   227,  3488,     0,   228,     0,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,  -186,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,  3489,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,     0,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,     0,   311,  -186,     0,
     312,     0,     0,   314,     0,     0,   316,   317,  3490,     0,
       0,     0,   319,     0,   320,   321,     0,   322,   323,   324,
       0,     0,   326,     0,     0,     0,     0,   328,   329,   330,
       0,     0,   331,     0,     0,     0,   332,     0,   334,     0,
       0,   336,   337,   338,     0,     0,     0,     0,     0,     0,
     339,   340,     0,   341,     0,     0,   342,     0,     0,     0,
     344,     0,     0,     0,   346,     0,   347,   348,   349,     0,
       0,     0,   350,   351,   352,   353,     0,   354,   355,     0,
     356,   357,     0,     0,   358,   359,   360,   361,   362,     0,
       0,     0,     0,     0,   363,     0,   364,     0,     0,     0,
     366,   367,   368,     0,     0,   369,   370,     0,     0,     0,
       0,     0,     0,     0,   372,     0,     0,   373,     0,     0,
       0,   375,   376,     0,     0,     0,     0,     0,     0,     0,
     377,     0,     0,   378,     0,     0,   379,   380,   381,     0,
       0,  -186,     0,   382,     0,   383,     0,     0,     0,     0,
     385,     0,     0,     0,   122,  3491,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,     0,
       0,     0,   130,   131,   132,     0,     0,  -186,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,     0,     0,     0,     0,   144,
       0,   145,     0,   146,     0,     0,     0,     0,   149,   150,
    3484,     0,   152,     0,   153,   154,     0,     0,   156,     0,
     158,   159,     0,     0,   160,     0,   161,   162,     0,     0,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,     0,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,     0,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
    3618,   184,   185,   186,     0,     0,   187,     0,   188,   189,
       0,     0,     0,   191,     0,   192,     0,     0,   193,   194,
    3485,     0,   195,   196,   197,     0,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,     0,   209,
       0,     0,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,  3486,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,  3487,     0,     0,     0,     0,     0,
       0,     0,   226,     0,     0,     0,   227,  3488,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,  -186,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,  3489,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,     0,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,     0,   311,  -186,     0,   312,     0,     0,   314,     0,
       0,   316,   317,  3490,     0,     0,     0,   319,     0,   320,
     321,     0,   322,   323,   324,     0,     0,   326,     0,     0,
       0,     0,   328,   329,   330,     0,     0,   331,     0,     0,
       0,   332,     0,   334,     0,     0,   336,   337,   338,     0,
       0,     0,     0,     0,     0,   339,   340,     0,   341,     0,
       0,   342,     0,     0,     0,   344,     0,     0,     0,   346,
       0,   347,   348,   349,     0,     0,     0,   350,   351,   352,
     353,     0,   354,   355,     0,   356,   357,     0,     0,   358,
     359,   360,   361,   362,     0,     0,     0,     0,     0,   363,
       0,   364,     0,     0,     0,   366,   367,   368,     0,     0,
     369,   370,     0,     0,     0,     0,     0,     0,     0,   372,
       0,     0,   373,     0,     0,     0,   375,   376,     0,     0,
       0,     0,     0,     0,     0,   377,     0,     0,   378,     0,
       0,   379,   380,   381,     0,     0,  -186,     0,   382,     0,
     383,     0,     0,     0,     0,   385,     0,     0,     0,   122,
    3491,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,     0,     0,     0,   130,   131,   132,
       0,     0,  -186,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
       0,     0,     0,     0,   144,     0,   145,     0,   146,     0,
       0,     0,     0,   149,   150,  3484,     0,   152,     0,   153,
     154,     0,     0,   156,     0,   158,   159,     0,     0,   160,
       0,   161,   162,     0,     0,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
       0,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,     0,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,  3659,   184,   185,   186,     0,
       0,   187,     0,   188,   189,     0,     0,     0,   191,     0,
     192,     0,     0,   193,   194,  3485,     0,   195,   196,   197,
       0,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,     0,   209,     0,     0,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,  3486,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,  3487,
       0,     0,     0,     0,     0,     0,     0,   226,     0,     0,
       0,   227,  3488,     0,   228,     0,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,  -186,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,  3489,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,     0,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,     0,   311,  -186,     0,
     312,     0,     0,   314,     0,     0,   316,   317,  3490,     0,
       0,     0,   319,     0,   320,   321,     0,   322,   323,   324,
       0,     0,   326,     0,     0,     0,     0,   328,   329,   330,
       0,     0,   331,     0,     0,     0,   332,     0,   334,     0,
       0,   336,   337,   338,     0,     0,     0,     0,     0,     0,
     339,   340,     0,   341,     0,     0,   342,     0,     0,     0,
     344,     0,     0,     0,   346,     0,   347,   348,   349,     0,
       0,     0,   350,   351,   352,   353,     0,   354,   355,     0,
     356,   357,     0,     0,   358,   359,   360,   361,   362,     0,
       0,     0,     0,     0,   363,     0,   364,     0,     0,     0,
     366,   367,   368,     0,     0,   369,   370,     0,     0,     0,
       0,     0,     0,     0,   372,     0,     0,   373,     0,     0,
       0,   375,   376,     0,     0,     0,     0,     0,     0,     0,
     377,     0,     0,   378,     0,     0,   379,   380,   381,     0,
       0,  -186,     0,   382,     0,   383,     0,     0,     0,     0,
     385,     0,     0,     0,   122,  3491,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,     0,
       0,     0,   130,   131,   132,     0,     0,  -186,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,     0,     0,     0,     0,   144,
       0,   145,     0,   146,     0,     0,     0,     0,   149,   150,
    3484,     0,   152,     0,   153,   154,     0,     0,   156,     0,
     158,   159,     0,     0,   160,     0,   161,   162,     0,     0,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,     0,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,     0,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
    -205,   184,   185,   186,     0,     0,   187,     0,   188,   189,
       0,     0,     0,   191,     0,   192,     0,     0,   193,   194,
    3485,     0,   195,   196,   197,     0,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,     0,   209,
       0,     0,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,  3486,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,  3487,     0,     0,     0,     0,     0,
       0,     0,   226,     0,     0,     0,   227,  3488,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,  -186,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,  3489,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,     0,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,     0,   311,  -186,     0,   312,     0,     0,   314,     0,
       0,   316,   317,  3490,     0,     0,     0,   319,     0,   320,
     321,     0,   322,   323,   324,     0,     0,   326,     0,     0,
       0,     0,   328,   329,   330,     0,     0,   331,     0,     0,
       0,   332,     0,   334,     0,     0,   336,   337,   338,     0,
       0,     0,     0,     0,     0,   339,   340,     0,   341,     0,
       0,   342,     0,     0,     0,   344,     0,     0,     0,   346,
       0,   347,   348,   349,     0,     0,     0,   350,   351,   352,
     353,     0,   354,   355,     0,   356,   357,     0,     0,   358,
     359,   360,   361,   362,     0,     0,     0,     0,     0,   363,
       0,   364,     0,     0,     0,   366,   367,   368,     0,     0,
     369,   370,     0,     0,     0,     0,     0,     0,     0,   372,
       0,     0,   373,     0,     0,     0,   375,   376,     0,     0,
       0,     0,     0,     0,     0,   377,     0,     0,   378,     0,
       0,   379,   380,   381,     0,     0,  -186,     0,   382,     0,
     383,     0,     0,     0,     0,   385,     0,     0,     0,   122,
    3491,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,     0,     0,     0,   130,   131,   132,
       0,     0,  -186,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
       0,     0,     0,     0,   144,     0,   145,     0,   146,     0,
       0,     0,     0,   149,   150,  3484,     0,   152,     0,   153,
     154,     0,     0,   156,     0,   158,   159,     0,     0,   160,
       0,   161,   162,     0,     0,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
       0,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,     0,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,     0,   184,   185,   186,     0,
       0,   187,     0,   188,   189,     0,     0,     0,   191,     0,
     192,     0,     0,   193,   194,  3485,     0,   195,   196,   197,
       0,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,     0,   209,     0,     0,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,  3486,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,  3487,
       0,     0,     0,     0,     0,     0,     0,   226,     0,     0,
       0,   227,  3488,     0,   228,     0,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,  -186,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,  3489,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,     0,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,     0,   311,  -186,     0,
     312,     0,     0,   314,     0,     0,   316,   317,  3490,     0,
       0,     0,   319,     0,   320,   321,     0,   322,   323,   324,
       0,     0,   326,     0,     0,     0,     0,   328,   329,   330,
       0,     0,   331,     0,     0,     0,   332,     0,   334,     0,
       0,   336,   337,   338,     0,     0,     0,     0,     0,     0,
     339,   340,     0,   341,     0,     0,   342,     0,     0,     0,
     344,     0,     0,     0,   346,     0,   347,   348,   349,     0,
       0,     0,   350,   351,   352,   353,     0,   354,   355,     0,
     356,   357,     0,     0,   358,   359,   360,   361,   362,     0,
       0,     0,     0,     0,   363,     0,   364,     0,     0,     0,
     366,   367,   368,     0,     0,   369,   370,     0,     0,     0,
       0,     0,     0,     0,   372,     0,     0,   373,     0,     0,
       0,   375,   376,     0,     0,     0,     0,     0,     0,     0,
     377,     0,     0,   378,     0,     0,   379,   380,   381,     0,
       0,  -186,     0,   382,     0,   383,     0,     0,     0,     0,
     385,     0,     0,     0,   122,  3491,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,     0,
       0,     0,   130,   131,   132,     0,     0,  -186,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,   140,     0,   141,     0,     0,     0,     0,     0,   144,
       0,   145,     0,   146,     0,     0,     0,     0,   149,   150,
    3484,     0,   152,     0,   153,   154,     0,     0,   156,     0,
     158,   159,     0,     0,   160,     0,   161,   162,     0,     0,
     164,     0,     0,     0,     0,   165,     0,     0,   166,     0,
       0,     0,     0,     0,     0,   167,   168,     0,     0,   169,
       0,     0,     0,     0,   170,     0,     0,     0,     0,     0,
       0,   172,     0,   173,     0,     0,     0,     0,     0,   174,
       0,   175,   176,   177,     0,     0,     0,     0,     0,     0,
     179,   180,   181,     0,     0,     0,   182,     0,     0,     0,
       0,   184,   185,   186,     0,     0,   187,     0,   188,   189,
       0,     0,     0,   191,     0,   192,     0,     0,   193,   194,
    3485,     0,   195,   196,   197,     0,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,   205,
     206,     0,   207,     0,     0,     0,     0,     0,     0,   209,
       0,     0,     0,     0,   211,     0,     0,     0,   212,   213,
     214,   215,  3486,     0,   216,   217,     0,     0,     0,   218,
       0,     0,     0,   219,     0,     0,     0,   220,     0,   221,
     222,     0,   223,   224,  3487,     0,     0,     0,     0,     0,
       0,     0,   226,     0,     0,     0,   227,  3488,     0,   228,
       0,     0,     0,     0,     0,   229,     0,   230,     0,     0,
     231,     0,   232,     0,     0,     0,     0,     0,  -186,     0,
       0,     0,   233,   234,   235,   236,   237,   238,     0,   239,
     240,   241,   242,   243,   244,   245,   246,   247,     0,   248,
     249,   250,     0,   251,   252,     0,     0,     0,   253,   254,
     255,   256,   257,     0,     0,   258,   259,     0,     0,   260,
       0,   261,     0,   262,     0,     0,   263,   264,   265,   266,
     267,   268,   269,     0,     0,   270,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,   276,
     277,     0,   278,     0,   279,   280,  3489,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   282,   283,   284,
     285,     0,   286,     0,   287,     0,   288,     0,     0,     0,
     290,     0,   291,     0,   292,   293,   294,   295,     0,   296,
     297,   298,   299,   300,   301,   302,   303,     0,     0,     0,
       0,   304,   305,     0,     0,   306,   307,   308,     0,   309,
       0,     0,   311,  -186,     0,   312,     0,     0,   314,     0,
       0,   316,   317,  3490,     0,     0,     0,   319,     0,   320,
     321,     0,   322,   323,   324,     0,     0,   326,     0,     0,
       0,     0,   328,   329,   330,     0,     0,   331,     0,     0,
       0,   332,     0,   334,     0,     0,   336,   337,   338,     0,
       0,     0,     0,     0,     0,   339,   340,     0,   341,     0,
       0,   342,     0,     0,     0,   344,     0,     0,     0,   346,
       0,   347,   348,   349,     0,     0,     0,   350,   351,   352,
     353,     0,   354,   355,     0,   356,   357,     0,     0,   358,
     359,   360,   361,   362,     0,     0,     0,     0,     0,   363,
       0,   364,     0,     0,     0,   366,   367,   368,     0,     0,
     369,   370,     0,     0,     0,     0,     0,     0,     0,   372,
       0,     0,  3574,     0,     0,     0,   375,   376,     0,     0,
       0,     0,     0,     0,     0,   377,     0,     0,   378,     0,
       0,   379,   380,   381,     0,     0,  -186,     0,   382,     0,
     383,     0,     0,     0,     0,   385,     0,     0,     0,   122,
    3491,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,  1625,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
    1626,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,  1627,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,     0,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,  1628,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,   712,   713,     0,   275,
       0,     0,  1629,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,   328,   329,   330,
       0,     0,   331,     0,     0,     0,   332,   333,   334,   335,
       0,   336,   337,   338,     0,     0,  3681,  3671,  3682,     0,
     339,   340,     0,   341,     0,     0,   342,     0,     0,   343,
     344,     0,     0,   345,   346,     0,   347,   348,   349,     0,
       0,     0,   350,   351,   352,   353,     0,   354,   355,     0,
     356,   357,     0,     0,   358,   359,   360,   361,   362,     0,
       0,     0,     0,     0,   363,     0,   364,     0,     0,   365,
     366,   367,   368,     0,  1630,   369,   370,     0,     0,   371,
       0,     0,     0,     0,   372,     0,     0,   373,     0,   374,
       0,   375,   376,     0,     0,     0,     0,     0,     0,     0,
     377,     0,     0,   378,     0,     0,   379,   380,   381,     0,
       0,     0,     0,   382,     0,   383,   384,     0,     0,   122,
     385,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,  2311,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,  2312,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,  1949,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,   560,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,   328,   329,   330,
       0,  1950,   331,     0,     0,     0,   332,   333,   334,   335,
       0,   336,   337,   338,     0,     0,     0,     0,     0,     0,
     339,   340,     0,   341,     0,     0,   342,     0,     0,   343,
     344,     0,     0,   345,   346,     0,   347,   348,   349,     0,
       0,     0,   350,   351,   352,   353,     0,   354,   355,     0,
     356,   357,     0,   561,   358,   359,   360,   361,   362,     0,
       0,     0,     0,     0,   363,     0,   364,     0,     0,   365,
     366,   367,   368,     0,     0,   369,   370,     0,     0,   371,
       0,     0,     0,     0,   372,     0,     0,   373,     0,   374,
       0,   375,   376,     0,     0,     0,     0,     0,     0,     0,
     377,     0,     0,   378,     0,     0,   379,   380,   381,     0,
       0,     0,     0,   382,     0,   383,   384,     0,     0,   122,
     385,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,  2321,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,  2322,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,   560,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,   328,   329,   330,
       0,     0,   331,     0,     0,     0,   332,   333,   334,   335,
       0,   336,   337,   338,     0,     0,     0,     0,     0,     0,
     339,   340,     0,   341,     0,     0,   342,     0,     0,   343,
     344,     0,     0,   345,   346,     0,   347,   348,   349,     0,
       0,     0,   350,   351,   352,   353,     0,   354,   355,     0,
     356,   357,     0,   561,   358,   359,   360,   361,   362,     0,
       0,     0,     0,     0,   363,     0,   364,     0,     0,   365,
     366,   367,   368,     0,     0,   369,   370,     0,     0,   371,
       0,     0,     0,     0,   372,     0,     0,   373,     0,   374,
       0,   375,   376,     0,     0,     0,     0,     0,     0,     0,
     377,     0,     0,   378,     0,     0,   379,   380,   381,     0,
       0,     0,     0,   382,     0,   383,   384,     0,     0,   122,
     385,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,  2311,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,  2312,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,   560,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,   328,   329,   330,
       0,     0,   331,     0,     0,     0,   332,   333,   334,   335,
       0,   336,   337,   338,     0,     0,     0,     0,     0,     0,
     339,   340,     0,   341,     0,     0,   342,     0,     0,   343,
     344,     0,     0,   345,   346,     0,   347,   348,   349,     0,
       0,     0,   350,   351,   352,   353,     0,   354,   355,     0,
     356,   357,     0,   561,   358,   359,   360,   361,   362,     0,
       0,     0,     0,     0,   363,     0,   364,     0,     0,   365,
     366,   367,   368,     0,     0,   369,   370,     0,     0,   371,
       0,     0,     0,     0,   372,     0,     0,   373,     0,   374,
       0,   375,   376,     0,     0,     0,     0,     0,     0,     0,
     377,     0,     0,   378,     0,     0,   379,   380,   381,     0,
       0,     0,     0,   382,     0,   383,   384,     0,     0,   122,
     385,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,   716,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,   560,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,   328,   329,   330,
       0,     0,   331,     0,     0,     0,   332,   333,   334,   335,
       0,   336,   337,   338,     0,     0,     0,     0,     0,     0,
     339,   340,     0,   341,     0,     0,   342,     0,     0,   343,
     344,     0,     0,   345,   346,     0,   347,   348,   349,     0,
       0,     0,   350,   351,   352,   353,     0,   354,   355,     0,
     356,   357,     0,   561,   358,   359,   360,   361,   362,     0,
       0,     0,     0,     0,   363,     0,   364,     0,     0,   365,
     366,   367,   368,     0,     0,   369,   370,     0,     0,   371,
       0,     0,     0,     0,   372,     0,     0,   373,     0,   374,
       0,   375,   376,     0,     0,     0,     0,     0,     0,     0,
     377,     0,     0,   378,     0,     0,   379,   380,   381,     0,
       0,     0,     0,   382,     0,   383,   384,     0,     0,   122,
     385,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,     0,   136,   668,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,   669,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,     0,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,   328,   329,   330,
       0,     0,   331,     0,     0,     0,   332,   333,   334,   335,
       0,   336,   337,   338,     0,     0,     0,     0,     0,     0,
     339,   340,     0,   341,     0,     0,   342,     0,     0,   343,
     344,     0,     0,   345,   346,     0,   347,   348,   349,     0,
       0,     0,   350,   351,   352,   353,     0,   354,   355,     0,
     356,   357,     0,   670,   358,   359,   360,   361,   362,     0,
       0,     0,     0,     0,   363,     0,   364,     0,     0,   365,
     366,   367,   368,     0,     0,   369,   370,     0,     0,   371,
       0,     0,     0,     0,   372,     0,     0,   373,     0,   374,
       0,   375,   376,     0,     0,     0,     0,     0,     0,     0,
     377,     0,     0,   378,     0,     0,   379,   380,   381,     0,
       0,     0,     0,   382,     0,   383,   384,     0,     0,   122,
     385,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,  2360,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,   560,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,   328,   329,   330,
       0,     0,   331,     0,     0,     0,   332,   333,   334,   335,
       0,   336,   337,   338,     0,     0,     0,     0,     0,     0,
     339,   340,     0,   341,     0,     0,   342,     0,     0,   343,
     344,     0,     0,   345,   346,     0,   347,   348,   349,     0,
       0,     0,   350,   351,   352,   353,     0,   354,   355,     0,
     356,   357,     0,   561,   358,   359,   360,   361,   362,     0,
       0,     0,     0,     0,   363,     0,   364,     0,     0,   365,
     366,   367,   368,     0,     0,   369,   370,     0,     0,   371,
       0,     0,     0,     0,   372,     0,     0,   373,     0,   374,
       0,   375,   376,     0,     0,     0,     0,     0,     0,     0,
     377,     0,     0,   378,     0,     0,   379,   380,   381,     0,
       0,     0,     0,   382,     0,   383,   384,     0,     0,   122,
     385,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,  2311,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,   560,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,   328,   329,   330,
       0,     0,   331,     0,     0,     0,   332,   333,   334,   335,
       0,   336,   337,   338,     0,     0,     0,     0,     0,     0,
     339,   340,     0,   341,     0,     0,   342,     0,     0,   343,
     344,     0,     0,   345,   346,     0,   347,   348,   349,     0,
       0,     0,   350,   351,   352,   353,     0,   354,   355,     0,
     356,   357,     0,   561,   358,   359,   360,   361,   362,     0,
       0,     0,     0,     0,   363,     0,   364,     0,     0,   365,
     366,   367,   368,     0,     0,   369,   370,     0,     0,   371,
       0,     0,     0,     0,   372,     0,     0,   373,     0,   374,
       0,   375,   376,     0,     0,     0,     0,     0,     0,     0,
     377,     0,     0,   378,     0,     0,   379,   380,   381,     0,
       0,     0,     0,   382,     0,   383,   384,     0,     0,   122,
     385,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,   560,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,   328,   329,   330,
       0,     0,   331,     0,     0,     0,   332,   333,   334,   335,
       0,   336,   337,   338,     0,     0,     0,     0,     0,     0,
     339,   340,     0,   341,     0,     0,   342,     0,     0,   343,
     344,     0,     0,   345,   346,     0,   347,   348,   349,     0,
       0,     0,   350,   351,   352,   353,     0,   354,   355,     0,
     356,   357,     0,   561,   358,   359,   360,   361,   362,     0,
       0,     0,     0,     0,   363,     0,   364,     0,     0,   365,
     366,   367,   368,     0,     0,   369,   370,     0,     0,   371,
       0,     0,     0,     0,   372,     0,     0,   373,     0,   374,
       0,   375,   376,     0,     0,     0,     0,     0,     0,     0,
     377,     0,     0,   378,     0,     0,   379,   380,   381,     0,
       0,     0,     0,   382,     0,   383,   384,     0,     0,   122,
     385,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,  2301,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,     0,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,   328,   329,   330,
       0,     0,   331,     0,     0,     0,   332,   333,   334,   335,
       0,   336,   337,   338,     0,     0,     0,     0,     0,     0,
     339,   340,     0,   341,     0,     0,   342,     0,     0,   343,
     344,     0,     0,   345,   346,     0,   347,   348,   349,     0,
       0,     0,   350,   351,   352,   353,     0,   354,   355,     0,
     356,   357,     0,   561,   358,   359,   360,   361,   362,     0,
       0,     0,     0,     0,   363,     0,   364,     0,     0,   365,
     366,   367,   368,     0,     0,   369,   370,     0,     0,   371,
       0,     0,     0,     0,   372,     0,     0,   373,     0,   374,
       0,   375,   376,     0,     0,     0,     0,     0,     0,     0,
     377,     0,     0,   378,     0,     0,   379,   380,   381,     0,
       0,     0,     0,   382,     0,   383,   384,     0,     0,   122,
     385,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,  3613,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,     0,  3614,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,     0,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,   328,   329,   330,
       0,     0,   331,     0,     0,     0,   332,   333,   334,   335,
       0,   336,   337,   338,     0,     0,     0,     0,     0,     0,
     339,   340,     0,   341,     0,     0,   342,     0,     0,   343,
     344,     0,     0,   345,   346,     0,   347,   348,   349,     0,
       0,     0,   350,   351,   352,   353,     0,   354,   355,     0,
     356,   357,     0,     0,   358,   359,   360,   361,   362,     0,
       0,     0,     0,     0,   363,     0,   364,     0,     0,   365,
     366,   367,   368,     0,     0,   369,   370,     0,     0,   371,
       0,     0,     0,     0,   372,     0,     0,   373,     0,   374,
       0,   375,   376,     0,     0,     0,     0,     0,     0,     0,
     377,     0,     0,   378,     0,     0,   379,   380,   381,     0,
       0,     0,     0,   382,     0,   383,   384,     0,     0,   122,
     385,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,   735,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,     0,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,   328,   329,   330,
       0,     0,   331,     0,     0,     0,   332,   333,   334,   335,
       0,   336,   337,   338,     0,     0,     0,     0,     0,     0,
     339,   340,     0,   341,     0,     0,   342,     0,     0,   343,
     344,     0,     0,   345,   346,     0,   347,   348,   349,     0,
       0,     0,   350,   351,   352,   353,     0,   354,   355,     0,
     356,   357,     0,     0,   358,   359,   360,   361,   362,     0,
       0,     0,     0,     0,   363,     0,   364,     0,     0,   365,
     366,   367,   368,     0,     0,   369,   370,     0,     0,   371,
       0,     0,     0,     0,   372,     0,     0,   373,     0,   374,
       0,   375,   376,     0,     0,     0,     0,     0,     0,     0,
     377,     0,     0,   378,     0,     0,   379,   380,   381,     0,
       0,     0,     0,   382,     0,   383,   384,     0,     0,   122,
     385,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,  1100,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,     0,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,   328,   329,   330,
       0,     0,   331,     0,     0,     0,   332,   333,   334,   335,
       0,   336,   337,   338,     0,     0,     0,     0,     0,     0,
     339,   340,     0,   341,     0,     0,   342,     0,     0,   343,
     344,     0,     0,   345,   346,     0,   347,   348,   349,     0,
       0,     0,   350,   351,   352,   353,     0,   354,   355,     0,
     356,   357,     0,     0,   358,   359,   360,   361,   362,     0,
       0,     0,     0,     0,   363,     0,   364,     0,     0,   365,
     366,   367,   368,     0,     0,   369,   370,     0,     0,   371,
       0,     0,     0,     0,   372,     0,     0,   373,     0,   374,
       0,   375,   376,     0,     0,     0,     0,     0,     0,     0,
     377,     0,     0,   378,     0,     0,   379,   380,   381,     0,
       0,     0,     0,   382,     0,   383,   384,     0,     0,   122,
     385,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,  1897,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,     0,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,   328,   329,   330,
       0,     0,   331,     0,     0,     0,   332,   333,   334,   335,
       0,   336,   337,   338,     0,     0,     0,     0,     0,     0,
     339,   340,     0,   341,     0,     0,   342,     0,     0,   343,
     344,     0,     0,   345,   346,     0,   347,   348,   349,     0,
       0,     0,   350,   351,   352,   353,     0,   354,   355,     0,
     356,   357,     0,     0,   358,   359,   360,   361,   362,     0,
       0,     0,     0,     0,  1898,     0,   364,     0,     0,   365,
     366,   367,   368,     0,     0,   369,   370,     0,     0,   371,
       0,     0,     0,     0,   372,     0,     0,   373,     0,   374,
       0,   375,   376,     0,     0,     0,     0,     0,     0,     0,
     377,     0,     0,   378,     0,     0,   379,   380,   381,     0,
       0,     0,     0,   382,     0,   383,   384,     0,     0,   122,
     385,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,     0,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,  2017,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,   328,   329,   330,
       0,     0,   331,     0,     0,     0,   332,   333,   334,   335,
       0,   336,   337,   338,     0,     0,     0,     0,     0,     0,
     339,   340,     0,   341,     0,     0,   342,     0,     0,   343,
     344,     0,     0,   345,   346,     0,   347,   348,   349,     0,
       0,     0,   350,   351,   352,   353,     0,   354,   355,     0,
     356,   357,     0,     0,   358,   359,   360,   361,   362,     0,
       0,     0,     0,     0,   363,     0,   364,     0,     0,   365,
     366,   367,   368,     0,     0,   369,   370,     0,     0,   371,
       0,     0,     0,     0,   372,     0,     0,   373,     0,   374,
       0,   375,   376,     0,     0,     0,     0,     0,     0,     0,
     377,     0,     0,   378,     0,     0,   379,   380,   381,     0,
       0,     0,     0,   382,     0,   383,   384,     0,     0,   122,
     385,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,     0,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,   328,   329,   330,
       0,     0,   331,     0,     0,     0,   332,   333,   334,   335,
       0,   336,   337,   338,     0,     0,     0,     0,     0,     0,
     339,   340,     0,   341,     0,     0,   342,     0,     0,   343,
     344,     0,     0,   345,   346,     0,   347,   348,   349,     0,
       0,     0,   350,   351,   352,   353,     0,   354,   355,     0,
     356,   357,     0,   561,   358,   359,   360,   361,   362,     0,
       0,     0,     0,     0,   363,     0,   364,     0,     0,   365,
     366,   367,   368,     0,     0,   369,   370,     0,     0,   371,
       0,     0,     0,     0,   372,     0,     0,   373,     0,   374,
       0,   375,   376,     0,     0,     0,     0,     0,     0,     0,
     377,     0,     0,   378,     0,     0,   379,   380,   381,     0,
       0,     0,     0,   382,     0,   383,   384,     0,     0,   122,
     385,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,  1897,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,     0,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,   328,   329,   330,
       0,     0,   331,     0,     0,     0,   332,   333,   334,   335,
       0,   336,   337,   338,     0,     0,     0,     0,     0,     0,
     339,   340,     0,   341,     0,     0,   342,     0,     0,   343,
     344,     0,     0,   345,   346,     0,   347,   348,   349,     0,
       0,     0,   350,   351,   352,   353,     0,   354,   355,     0,
     356,   357,     0,     0,   358,   359,   360,   361,   362,     0,
       0,     0,     0,     0,   363,     0,   364,     0,     0,   365,
     366,   367,   368,     0,     0,   369,   370,     0,     0,   371,
       0,     0,     0,     0,   372,     0,     0,   373,     0,   374,
       0,   375,   376,     0,     0,     0,     0,     0,     0,     0,
     377,     0,     0,   378,     0,     0,   379,   380,   381,     0,
       0,     0,     0,   382,     0,   383,   384,     0,     0,   122,
     385,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,     0,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,   328,   329,   330,
       0,     0,   331,     0,     0,     0,   332,   333,   334,   335,
       0,   336,   337,   338,     0,     0,     0,     0,     0,     0,
     339,   340,     0,   341,     0,     0,   342,     0,     0,   343,
     344,     0,     0,   345,   346,     0,   347,   348,   349,     0,
       0,     0,   350,   351,   352,   353,     0,   354,   355,     0,
     356,   357,     0,     0,   358,   359,   360,   361,   362,     0,
       0,     0,     0,     0,   363,     0,   364,     0,     0,   365,
     366,   367,   368,     0,     0,   369,   370,     0,     0,   371,
       0,     0,     0,     0,   372,     0,     0,   373,     0,   374,
       0,   375,   376,     0,     0,     0,     0,     0,     0,     0,
     377,     0,     0,   378,     0,     0,   379,   380,   381,     0,
       0,     0,     0,   382,     0,   383,   384,     0,     0,   122,
     385,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
     142,   143,     0,     0,   144,     0,   145,     0,   146,   147,
       0,   148,     0,   149,   150,   151,     0,   152,     0,   153,
     154,     0,   155,   156,   157,   158,   159,     0,     0,   160,
       0,   161,   162,     0,   163,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
     171,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,   183,   184,   185,   186,     0,
       0,   187,     0,   188,   189,   190,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,  1403,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,   208,   209,     0,   210,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,   225,     0,   226,     0,     0,
       0,   227,     0,     0,   228,     0,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,  1404,   274,     0,     0,     0,   275,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,   281,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,   289,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,   310,   311,     0,     0,
     312,     0,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,     0,   320,   321,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,   328,   329,   330,
       0,     0,   331,     0,     0,     0,   332,   333,   334,   335,
       0,   336,   337,   338,     0,     0,     0,     0,     0,     0,
     339,   340,     0,   341,     0,     0,   342,     0,     0,   343,
     344,     0,     0,   345,   346,     0,   347,   348,   349,     0,
       0,     0,   350,   351,   352,   353,     0,   354,   355,     0,
     356,   357,     0,     0,   358,   359,   360,   361,   362,     0,
       0,     0,     0,     0,   363,     0,   364,     0,     0,   365,
     366,   367,   368,     0,     0,   369,   370,     0,     0,   371,
       0,     0,     0,     0,   372,     0,     0,   373,     0,   374,
       0,   375,   376,     0,     0,     0,     0,     0,     0,     0,
     377,     0,     0,   378,     0,     0,   379,   380,   381,     0,
       0,     0,     0,   382,     0,   383,   384,     0,     0,   122,
     385,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,     0,     0,     0,   130,   131,   132,
       0,     0,     0,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,   140,     0,   141,     0,
       0,     0,     0,     0,   144,     0,   145,     0,   146,     0,
       0,     0,     0,   149,   150,     0,     0,   152,     0,   153,
     154,     0,     0,   156,     0,   158,   159,     0,     0,   160,
       0,   161,   162,     0,     0,   164,     0,     0,     0,     0,
     165,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     167,   168,     0,     0,   169,     0,     0,     0,     0,   170,
       0,     0,     0,     0,     0,     0,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,   176,   177,     0,
       0,     0,     0,     0,     0,   179,   180,   181,     0,     0,
       0,   182,     0,     0,     0,     0,   184,   185,   186,     0,
       0,   187,     0,   188,   189,     0,     0,     0,   191,     0,
     192,     0,     0,   193,   194,     0,     0,   195,   196,   197,
       0,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,   201,     0,   202,     0,     0,     0,     0,     0,     0,
     203,   204,     0,     0,   205,   206,     0,   207,     0,     0,
       0,     0,     0,     0,   209,     0,     0,     0,     0,   211,
       0,     0,     0,   212,   213,   214,   215,     0,     0,   216,
     217,     0,     0,     0,   218,     0,     0,     0,   219,     0,
       0,     0,   220,     0,   221,   222,     0,   223,   224,     0,
       0,     0,     0,     0,     0,     0,     0,   226,     0,     0,
       0,   227,     0,     0,   228,     0,     0,     0,     0,     0,
     229,     0,   230,     0,     0,   231,     0,   232,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,   234,   235,
     236,   237,   238,     0,   239,   240,   241,   242,   243,   244,
     245,   246,   247,     0,   248,   249,   250,     0,   251,   252,
       0,     0,     0,   253,   254,   255,   256,   257,     0,     0,
     258,   259,     0,     0,   260,     0,   261,     0,   262,     0,
       0,   263,   264,   265,   266,   267,   268,   269,     0,     0,
     270,   271,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,   276,   277,     0,   278,     0,   279,
     280,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   282,   283,   284,   285,     0,   286,     0,   287,
       0,   288,     0,     0,     0,   290,     0,   291,     0,   292,
     293,   294,   295,     0,   296,   297,   298,   299,   300,   301,
     302,   303,     0,     0,     0,     0,   304,   305,     0,     0,
     306,   307,   308,     0,   309,     0,     0,   311,     0,     0,
     312,     0,     0,   314,     0,     0,   316,   317,     0,     0,
       0,     0,   319,     0,   320,   321,     0,   322,   323,   324,
       0,     0,   326,     0,     0,     0,     0,   328,   329,   330,
       0,     0,   331,     0,     0,     0,   332,     0,   334,     0,
       0,   336,   337,   338,     0,     0,     0,     0,     0,     0,
     339,   340,     0,   341,     0,     0,   342,     0,     0,     0,
     344,     0,     0,     0,   346,     0,   347,   348,   349,     0,
       0,     0,   350,   351,   352,   353,     0,   354,   355,     0,
     356,   357,     0,     0,   358,   359,   360,   361,   362,     0,
       0,     0,     0,     0,   363,     0,   364,     0,     0,     0,
     366,   367,   368,     0,     0,   369,   370,     0,     0,     0,
       0,     0,     0,     0,   372,     0,     0,   373,     0,     0,
       0,   375,   376,     0,     0,     0,     0,     0,     0,     0,
     377,     0,     0,   378,     0,     0,   379,   380,   381,     0,
       0,     0,     0,   382,     0,   383,     0,     0,     0,     0,
     385
};

static const short int yycheck[] =
{
       7,   450,   500,   898,   425,   470,   601,  1171,   965,   525,
     626,   746,    19,  1018,   683,    22,  1207,   649,   723,   724,
     725,   624,    29,   762,   763,   764,  1953,  1766,   768,   496,
     497,  1080,    39,   649,  1297,  1848,  1931,  1173,  1174,  1175,
    1297,  2337,    49,    22,  1939,  1876,  1941,   650,  1907,  1322,
    1186,  1900,  1901,  1902,  2077,  1205,  1329,  1525,  2060,   526,
    1612,  2084,  1938,  1383,  2286,  1199,   687,   583,  1093,  1491,
    1538,  1914,  1915,  2694,   687,  1045,  2679,  2671,  1891,   457,
      87,     3,     3,     3,     3,     3,  1056,  1057,  1341,  1342,
     829,     3,    18,     3,   577,     3,    18,    16,    15,    16,
     107,   108,  1968,   110,  1240,  1239,  1086,  1243,    87,    32,
      15,    16,  1505,  1972,   121,   509,   855,   857,    15,    16,
     860,   135,    95,  1178,  1179,   108,  1181,   110,   595,    16,
     869,   870,   871,  1992,  1993,  1271,  1272,    27,    69,   130,
    1276,    56,   121,    59,   879,   880,   881,   175,    15,    16,
    2724,    20,    18,  2727,  2055,  1439,   891,  1962,  2956,  1261,
    1296,  1216,  1298,  1968,    52,   115,  1971,    49,    61,  1974,
     253,   129,  2746,  1097,    44,   691,  1231,    60,  2752,   229,
    1985,  1986,    34,    28,    15,    16,    55,    56,    63,  1994,
    1614,    15,    16,   111,  1249,  1250,  1251,    15,    16,    64,
     156,   111,    49,   111,   625,  1260,   145,    18,    58,  1166,
     588,  2785,    34,  2949,   217,    15,    16,    15,    16,   145,
    2051,    54,   179,   145,    15,    16,   156,   694,  1330,   177,
      94,  1333,  1334,  1335,  1336,   238,  1338,  1339,  1340,  1341,
    1342,  1343,  1344,  1345,  1346,  1937,   347,   147,  2279,   175,
     341,    20,   252,    15,    16,    12,  3493,   115,   301,    15,
      16,    58,   214,    32,    15,    16,   236,   221,  3404,   352,
     175,   413,   221,   223,   361,   229,     8,    46,   205,   145,
     229,   175,   263,    40,    20,   112,    55,    56,    15,    16,
     236,   112,    15,    16,  1963,  1964,    32,    12,   489,   443,
     402,  1196,   214,   249,  2898,   111,   498,   214,    15,    16,
      46,  3487,  3488,   258,    63,   179,    15,    16,   234,    55,
      56,   466,   568,   156,    81,   507,   159,  2381,    58,    86,
     200,   156,   253,   253,   145,    77,    15,    16,   445,   172,
     530,   402,   530,   390,    32,   651,   332,   333,   530,    15,
      16,   203,    18,   464,   289,   548,   403,   175,    66,    15,
      16,    15,    16,   270,    97,    15,    16,   100,    55,    56,
      96,  1923,  3108,   170,    15,    16,    89,   488,   522,    15,
      16,   203,   575,   575,   574,  1280,   433,   575,   579,  1284,
     179,   336,   890,   500,   539,    15,    16,    15,    16,  1068,
    3576,   228,   489,   357,   411,   507,  2980,   228,   357,   344,
     125,  1575,   360,   557,   421,  2989,  1580,   374,   425,  1022,
      11,   667,  1586,   430,   269,  1589,   382,  1030,   435,    15,
      16,   573,   164,   516,   351,   169,   330,   354,  3675,   430,
     170,  3577,   412,  3046,   487,   506,   351,   335,   915,   354,
     457,   430,   382,   405,   351,  1058,  1059,   354,    59,   270,
      15,    16,  2389,  1887,  1080,  1086,   299,   474,  2344,   512,
     416,  2320,   145,  1086,   231,   382,   175,   484,   436,   580,
     214,   488,  1222,    49,   575,   466,  1622,   494,   353,   496,
     497,   217,  1416,   405,   501,   502,   444,   390,   437,   172,
     141,   968,  3300,  2352,   511,   484,  3100,  1023,   515,  2061,
     374,   978,  2378,   520,   521,  1485,   523,   524,   525,   526,
     351,   112,  1005,   354,  1145,   575,  2392,   351,   485,   411,
     354,   337,  1145,   351,  1559,  3138,   354,  1930,   521,   466,
     523,   524,  2010,   300,   394,   559,   546,   575,   969,   382,
    1290,   351,   559,   351,   354,   425,   354,   382,   474,   404,
     351,  2462,   445,   354,   411,    15,    16,  1703,   575,   542,
     573,  1707,   528,  2378,   524,   372,   583,   584,   956,   390,
     511,   588,   573,  2051,  2615,   374,   577,  2392,   595,   351,
     217,   466,   354,    15,    16,   351,   575,  1332,   354,   287,
     351,   979,   359,   354,  1740,   584,  2902,   158,   498,  1893,
    1801,   498,  1803,  1876,  1594,  1098,  1010,  1767,   625,  1876,
     574,   485,  3358,   538,   351,   546,   546,   354,   351,   548,
    2684,   354,   498,   234,   321,  2059,   553,   489,  1373,   381,
    1790,  1090,   372,   543,   351,   575,   515,   354,   553,   575,
     573,  2873,   351,  2345,  2346,   354,   553,   574,   575,   581,
     581,   581,   581,   581,    15,    16,   524,   489,   376,   581,
    3273,   581,   351,   581,   361,   354,   683,  1940,   542,    15,
      16,   578,   430,  1940,   691,   351,   553,   694,   354,    10,
     697,   698,   449,   575,  1796,   351,   485,   351,   354,   113,
     354,   351,   547,   528,   354,   418,   530,  2376,  1810,  1811,
     351,  3332,   131,   354,  1769,   351,  3337,   466,   354,   698,
     517,  1099,   553,   480,    15,    16,   733,  1148,   735,   553,
     331,   351,  1995,   351,   354,   553,   354,  3340,  1995,   550,
    2292,  2293,   575,   574,   575,  3041,   515,  3321,  1054,  3323,
     575,   575,    37,   553,   733,   553,   735,   575,   491,   485,
    2609,   494,   553,   354,   437,   351,  2661,   489,   354,   335,
    2665,    15,    16,    15,    16,   483,   574,   575,   578,   515,
    1944,  2612,   138,   574,   575,  2661,   337,   517,  2606,  2665,
    1685,   553,   148,   267,   502,   529,   351,   553,  2647,   354,
     107,   287,   553,    15,    16,   541,   107,   407,   270,  1973,
    2623,  1975,   574,   575,    12,  2681,  1980,  3391,   574,  3393,
     113,   164,  3425,   574,   575,   573,   553,  1325,    12,   577,
     553,   549,  1996,    50,  1998,  1999,  2000,   573,  2091,  2092,
     430,    58,   426,    15,    16,   411,   553,   574,   575,   324,
    1482,   574,   575,   575,   553,   108,   270,  1752,  2676,   166,
      15,    16,   463,  1379,   338,   166,  1482,   574,   575,   344,
     436,  1474,  3466,   474,   553,   574,  2681,   884,  1510,   886,
     175,  1484,  3503,  2971,  1487,  1488,  2974,   553,   362,    15,
      16,  1312,   579,    67,  1510,   574,   575,   553,   325,   553,
     243,   351,   909,   553,   354,  1421,  1422,   325,   915,  1914,
    1915,   204,   553,  2465,  2336,   573,   489,   553,   574,   575,
     574,   575,   580,  1390,   574,   575,   349,   125,   390,   351,
     909,   226,   354,   553,  2777,   553,  1419,   356,   574,   575,
    2942,   125,  2773,    15,    16,   952,  1429,   954,    12,   956,
     551,  1372,  2975,   504,  1924,   575,   574,   575,   275,   276,
     267,   968,   969,  1384,   175,  2238,   267,   553,    12,   520,
    1453,   978,   979,  1594,   227,   575,    19,   270,    15,    16,
      64,  1594,   989,   573,  2009,  1942,    15,    16,   574,   575,
      15,    16,   335,   430,   350,  2273,   170,   289,   553,  3221,
     351,  1450,   575,   354,  1011,  1012,  1013,  1014,    12,  2143,
     445,  2274,   253,  3634,  1021,   351,  1023,  2274,   354,   574,
     575,   430,  1029,   191,   217,    15,    16,  2082,  1011,  1012,
     485,   338,  2087,  1516,  1013,  1014,   510,   338,  1021,   287,
    2142,   258,   253,   217,  1051,   238,  1029,  2102,    15,    16,
     430,     0,   344,   374,  2109,   530,     3,   352,  2934,  2935,
     351,   125,   489,   354,   238,   149,    75,   430,  2953,  2124,
    2125,   489,  1051,   116,  1809,  2395,  2131,  2926,  2356,   396,
     397,   125,  2232,    38,  2139,   158,   513,  3175,   550,  1096,
     258,  2241,  1099,  1576,  1577,   513,  1579,   335,  1581,  1582,
    1583,  1584,  1585,   553,  1587,  1588,  2063,   351,  3110,   351,
     354,   352,   354,   516,  3410,   430,   401,  1096,  2670,    15,
      16,   125,   398,  2178,   574,   575,   145,   229,    15,    16,
     415,   553,   488,   381,    15,    16,   573,   370,   391,   351,
     461,  1148,   354,  1150,  1151,  1152,   573,  1154,   485,  3172,
     252,   436,   574,   575,  1988,   573,  1163,     3,  1165,  3455,
       6,   399,    15,    16,   573,   120,   175,    13,  1151,  1152,
      11,   574,  2006,   343,   573,  1154,   175,    23,    24,   351,
     501,   580,   354,    15,    16,   175,   462,    15,    16,   112,
     172,   361,  1199,   573,  2249,   466,   351,   445,   372,   354,
    2095,     8,   553,   510,  2672,  2673,  2674,    53,  2103,   510,
     573,    57,  3043,    15,    16,    15,    16,   553,   580,   472,
      27,   542,    68,   574,   575,   351,    71,    72,   354,  3124,
     229,    77,  1239,  2701,  3322,   506,  3324,    83,   574,   575,
     325,    15,    16,    15,    16,    15,    16,   107,   498,   325,
      96,    15,    16,    94,  3139,  3140,    15,    16,   573,   332,
     333,   270,   553,    16,   337,   111,   111,   435,   114,   353,
      15,    16,  3374,    94,  3376,    15,    16,   123,   124,   351,
     262,   573,   354,   129,   575,    15,    16,   545,   133,   213,
    1297,   137,    20,   395,   485,  2955,   107,   143,   545,    15,
      16,   559,  2493,  2494,    32,  1312,   166,   217,    76,   553,
    2583,   553,   559,   486,   351,    15,    16,   354,    46,   489,
     165,   213,   351,   169,    92,   354,   351,    55,    56,   354,
     574,   575,   574,   575,   347,    15,    16,  2997,   179,    15,
      16,   553,   226,   203,   465,    15,    16,  2713,   469,   175,
    2716,  2717,   410,  2616,   412,   166,   414,   178,   416,  2616,
     548,   351,   574,   575,   354,  1372,   270,  2733,   420,   215,
    1377,   217,  1379,   214,    15,    16,   191,  1384,   224,   538,
     574,   553,   541,  1390,   351,  1392,    88,   354,    15,    16,
    1397,  1398,   203,  1400,    15,    16,   217,   483,   553,   485,
      15,    16,   574,   575,   489,  1412,  2669,   267,  1415,   574,
     575,  1894,  2669,   489,  1421,  1422,  1423,  1424,  1397,  1398,
     575,  1400,    20,   126,  1431,  1432,  1433,   553,   513,   580,
      28,   504,  2695,  1412,   486,    33,  1415,   513,  2695,    55,
      56,   527,  1449,   258,  1423,  1424,   292,   520,   574,   575,
     145,  1458,  1431,  1432,  1433,   351,   267,     3,   354,   192,
     562,   307,  3275,   461,   351,  2514,   312,   354,  1475,   527,
     351,   545,    18,   354,   573,   527,    15,    16,   338,  1486,
    1901,   553,  1903,  1904,   405,   559,    15,    16,   573,    11,
     542,  1498,  1526,  1976,  1977,  1529,   152,  1504,   351,    54,
    2235,   354,   574,   575,  1538,   344,   352,  1486,   574,   575,
      15,    16,   358,  1547,  1997,   361,   553,   219,   483,   351,
     485,  2576,   354,   351,   553,  1504,   354,   338,   553,  1978,
     345,  1952,  1953,   374,   236,    15,    16,   574,   384,   385,
     373,   387,    88,  2248,    55,    56,   575,   249,   393,   351,
     575,   351,   354,    64,   354,   401,  1563,   290,   291,   574,
     575,   294,   295,   553,   530,  1572,   420,  1988,   574,   575,
      15,    16,  3421,    28,    15,    16,   349,   423,  3437,   351,
    3507,   351,   354,   483,   354,  2006,   553,   351,  2779,  3328,
     354,   575,   351,   453,  1601,   354,   574,   575,     3,   145,
     344,   156,  1609,  1610,   159,   214,   351,    47,   575,   354,
     313,   351,   175,    18,   354,    70,    47,   172,  1601,   263,
     435,   351,   324,   169,   354,   575,   172,    15,    16,   450,
    1609,  1610,   574,   575,  2897,   351,   430,   426,   354,   126,
    2897,    15,    16,   344,   485,   516,    15,    16,   567,   195,
     510,   351,   430,   263,   354,   201,  2077,   553,   436,  2850,
     150,   507,   506,  2084,   485,   486,   553,   172,   214,   436,
     516,   351,   553,   219,   354,   351,    15,    16,   354,   575,
     226,   351,   573,    88,   354,   253,   141,   172,   575,   466,
     236,  2286,   574,   575,   575,  2327,   517,   574,   575,   510,
     553,    15,    16,   249,   574,   575,   527,   253,   466,   941,
     351,  2327,   944,   354,   416,   947,   262,    15,    16,    15,
      16,   553,   575,   466,   351,   553,   287,   354,   263,   575,
     351,   483,  2335,   354,   142,   581,   351,   574,   575,   354,
     145,   535,   536,   575,   299,   452,   453,   575,   455,    15,
      16,   553,    78,   553,   346,  2271,   575,   535,   536,   479,
    2257,  2258,  2259,  2673,  2674,    15,    16,   172,  1775,   471,
     574,   575,  2777,   575,   111,   575,   574,   575,   324,   573,
     429,   553,   574,   553,    15,    16,   542,   515,    52,   553,
     195,  2288,  2289,  2290,   553,   573,   201,   399,   344,    15,
      16,  2317,   152,   575,  2225,   575,   352,   573,   553,   537,
     538,   575,   351,   553,   219,   354,   575,   579,  2301,   574,
     575,   226,   351,   553,  2879,   354,   313,   382,   374,   211,
     575,   236,    15,    16,   575,   575,   542,   553,   574,   575,
       7,    15,    16,   575,   249,   575,   351,   489,   253,   354,
      15,    16,    19,   553,   580,    22,   573,   262,   573,   575,
     574,   575,    29,   573,   567,   568,   569,   570,   573,  1876,
     416,   351,    39,   553,   354,   575,   573,   553,   574,   575,
      15,    16,    49,   553,   573,    15,    16,  1894,  1895,  1398,
     436,  1400,    15,    16,  1901,   575,  1903,  1904,   573,   575,
     573,    88,    15,    16,  2639,   575,   351,  2390,   573,   354,
     351,   573,   553,   354,  2397,   370,   573,    15,    16,   324,
      87,   573,  1431,  1432,  1433,   471,   553,   574,   575,   575,
      15,    16,   553,  1940,   575,    15,    16,   392,   553,   344,
     107,   108,   573,   110,   573,  1952,  1953,   352,   575,   573,
      15,    16,   580,   574,   121,  1962,   574,   575,   575,  2426,
     575,  1968,   417,   351,  1971,   573,   354,  1974,  2389,   374,
     516,    47,  2929,    15,    16,   574,   575,   351,  1985,  1986,
     354,  1988,   351,   529,   530,   354,   573,  1994,  1995,   463,
     464,   573,   466,   573,   468,  2969,  2970,  2004,   573,  2006,
     546,   573,   548,  2010,  2011,   579,    15,    16,   574,   575,
     465,   416,   351,  2987,   553,   354,  1281,  1282,   548,  2993,
    3145,  3146,  2595,  2596,   553,  2004,  2625,  2626,   574,   575,
     573,   436,   219,    15,    16,   581,   575,   351,    15,    16,
     354,   573,  3016,  2050,  2051,  3019,   575,   573,   553,   236,
      15,    16,   573,   351,   573,   351,   354,   573,   354,  2764,
     107,   573,   249,   573,   111,   573,   471,  2887,  2888,   574,
    2077,  2050,   573,   553,   573,    15,    16,  2084,   565,   566,
     567,   568,   569,   570,   573,   351,   483,   573,   354,   573,
    2097,  3354,   573,   575,   573,   575,  3260,  3261,  3262,  3263,
    3236,   351,    15,    16,   354,   573,   573,   573,   553,   573,
     573,   516,   553,    15,    16,   573,   573,    15,    16,   166,
     351,   573,  2619,   354,   573,   530,    15,    16,    15,    16,
     575,   573,   287,   258,   575,   351,  2143,   324,   354,   573,
     573,   546,   287,   548,    15,    16,    15,    16,    15,    16,
     573,   573,   573,   573,   573,   573,   203,    15,    16,    15,
      16,   573,   573,    15,    16,   553,   573,   573,   351,   574,
     575,   354,   573,   573,   573,   573,   581,   351,  2883,   553,
     354,   573,    15,    16,   553,   575,   351,   575,   573,   354,
      15,    16,   573,   573,   573,  3250,   573,    15,    16,    15,
      16,   575,  3465,   573,   575,   573,   575,  2628,   573,   573,
     573,   573,    15,    16,   553,   573,   351,   573,  2225,   354,
     267,   351,   573,  2644,   354,    15,    16,   573,   351,   416,
     573,   354,   573,   573,    15,    16,   575,   573,   351,   553,
     573,   354,   573,  2250,   411,    15,    16,  2254,   573,  2256,
    2257,  2258,  2259,   351,   421,   553,   354,   553,   425,   498,
    2267,   575,   573,   430,  2271,   573,   351,  2274,   435,   354,
     573,   351,    15,    16,   354,   575,   573,   575,  2873,   575,
     573,  2288,  2289,  2290,   471,   573,   351,   553,  2267,   354,
     457,   338,   573,   573,  2301,   573,    15,    16,   573,   573,
    2307,   573,  2309,   553,   573,   573,   573,   474,   574,   351,
    2317,   573,   354,    15,    16,   573,   573,   484,   573,   573,
     573,   488,   553,   498,   574,   573,   573,   494,   573,   496,
     497,   573,    15,    16,   501,   502,   573,   553,   573,    15,
      16,   575,   351,   574,   511,   354,   575,   575,   515,   229,
     489,   172,   567,   520,   521,   230,   523,   524,   525,   526,
     481,   160,  3625,    15,    16,   172,   575,   523,  3625,   351,
     553,  2378,   354,   575,   351,    15,    16,   354,   447,   553,
     363,   573,  2389,  3646,   574,  2392,   351,   575,   553,   354,
    3059,   574,   559,   145,   145,    15,    16,  3561,   145,  3662,
     574,   145,  3142,  3143,  3144,  3662,   145,   145,   575,   574,
     145,   351,   145,   145,   354,   145,   583,   584,   553,  2426,
     145,   588,   145,   553,   145,   145,  2433,   145,   595,  2436,
     553,    15,    16,  2440,  2441,   575,   525,  2444,   351,   574,
     553,   354,    15,    16,   574,  2928,  3185,  2454,   574,   351,
      45,   574,   354,   351,   344,   553,   354,  2436,   625,    15,
      16,   574,   351,   510,   351,   354,   179,   354,   553,   575,
     175,    64,    12,   553,   574,  2454,   574,   489,    15,    16,
     351,   574,   351,   354,   351,   354,   125,   354,   553,   574,
     107,  2912,     9,   351,   574,   351,   354,  3166,   354,   351,
    3205,  3206,   354,    15,    16,   545,   574,   574,   574,   574,
    3179,   553,   573,  2996,    15,    16,   683,   580,   351,   575,
     566,   354,   390,  2972,   691,   252,   351,   694,   546,   354,
     697,   698,   574,   351,   218,   351,   354,   192,   354,    15,
      16,   580,   175,   574,   553,   445,    15,    16,   351,   166,
     381,   354,   436,   575,  2975,   575,    15,    16,    15,    16,
     172,   351,    45,   429,   354,   574,   733,   461,   735,   461,
     351,   553,    67,   354,  2995,   461,   553,   498,    15,    16,
    3319,   351,    15,    16,   354,   461,   203,   461,   553,    15,
      16,   122,   574,   237,   237,   560,   484,   574,   122,   484,
      15,    16,  3085,    45,    15,    16,    15,    16,   351,  2616,
    2617,   354,  2619,   553,    15,    16,    15,    16,   575,   530,
     580,  2628,    15,    16,    15,    16,  3221,  2634,  3333,   574,
     567,   575,   351,   574,   574,   354,    68,  2644,    15,    16,
     553,   574,   574,   574,   574,  2652,   574,   574,    80,   351,
     267,   553,   354,   175,   580,   553,    15,    16,   574,   574,
     574,   574,  2669,   575,   553,   574,   553,   573,   351,    15,
      16,   354,   574,   574,  2681,   351,   574,   574,   354,   575,
     575,  2688,   553,   574,   553,   574,   553,   574,  2695,    16,
     262,   574,  3113,   574,  2701,   553,   574,   553,   575,   351,
     437,   553,   354,   574,   574,   574,   498,   574,    15,    16,
     574,   351,    15,    16,   354,   574,   574,   884,   574,   886,
     553,   338,   574,  3392,    15,    16,    16,   574,   553,  3212,
     574,   351,   574,   573,   354,   553,   573,   553,   570,   573,
     575,   574,   909,   498,   574,    12,    15,    16,   915,   574,
     553,  3172,    15,    16,   580,   489,   574,   580,   574,  3428,
    3429,   575,  3431,   553,    15,    16,   383,   351,  2775,   386,
     354,   574,   553,    32,   498,    15,    16,   550,   351,   258,
     573,   354,   498,   553,   574,   952,   349,   954,   175,   956,
     175,   175,   226,   574,   175,   351,  3691,    56,   354,   126,
     548,   968,   969,  3472,   574,  3474,  3475,   575,   580,   241,
     553,   978,   979,   233,   351,   580,   355,   354,   338,   236,
     236,   303,   989,    96,    96,   238,   238,   573,   489,   352,
     997,   574,  3537,   573,   553,   580,   126,   573,    97,   351,
     338,   100,   354,   574,  1011,  1012,  1013,  1014,   574,   108,
     351,   553,   567,   354,  1021,   574,  1023,   225,   125,   141,
     338,   338,  1029,   574,  3329,   574,   574,  2874,   574,   567,
     553,  3529,   574,   574,   344,   351,  3581,   553,   354,   311,
     580,   580,   351,   580,  1051,   354,   574,   574,   128,   574,
    2897,   574,   351,   510,   351,   354,   573,   354,   574,   214,
     126,   553,   575,   335,   574,  2912,  3404,   175,   580,  3567,
     524,   229,   250,   553,   351,    64,   236,   354,   351,   275,
     236,   354,   574,   344,   175,   351,   575,   238,   354,  1096,
     238,    18,  1099,   553,   574,    18,   351,   204,   575,   354,
     351,   344,   351,   354,   574,   354,  2953,    18,   573,  3607,
     351,   253,   351,   354,   574,   354,   227,   389,   351,   574,
     351,   354,   573,   354,  3622,   573,   227,   574,  2975,   553,
     574,   574,   574,  3631,   351,   574,   105,   354,   574,   580,
     553,  1148,   574,  1150,  1151,  1152,   313,  1154,  2995,   574,
     574,   574,   351,   574,   574,   354,  1163,   553,  1165,   575,
     574,   574,   580,   574,   560,   351,   575,  3665,   354,  3667,
     574,   132,   574,  3020,    23,  3022,   553,   575,  3467,    58,
     574,   195,   247,   313,   575,  3032,   430,   573,    67,   461,
     438,  3038,  1199,   145,   355,   573,   236,   574,    94,   574,
      79,   553,   236,   575,   351,   174,   573,   354,   351,   111,
     111,   354,   553,  3032,   573,    64,   369,   573,   573,    68,
     351,   574,   574,   354,   573,   573,   573,   326,   338,   580,
     574,   574,  1239,   574,   338,   574,   338,   553,  3085,  3577,
     209,   432,   351,    41,   553,   354,  3507,   313,   351,   381,
     574,   354,   338,   574,   553,   548,   553,    45,   574,   226,
     351,   574,   111,   354,   575,   574,  3113,   201,   580,   575,
     390,   351,   439,   440,   354,   574,   553,   574,   310,   489,
     553,   236,   489,   179,   530,   530,  3133,   553,   573,   172,
    1297,   170,  3139,  3140,   573,   573,   338,   574,   553,   178,
     338,   574,   553,   573,   553,  1312,  3153,    32,   574,   439,
     440,   560,   553,   541,   553,   541,    88,   338,   524,   574,
     553,   217,   553,   574,    88,  3172,   573,   111,   238,   238,
    3668,   337,   548,   574,   338,   574,   553,   306,   217,   338,
     338,   574,   338,   574,   443,   314,   338,   509,   455,   456,
     457,   458,   459,   460,   553,  3693,   574,   574,   154,   238,
     575,   573,   575,  3210,   471,  1372,   310,   553,   489,   574,
    1377,   574,  1379,   439,   440,   574,  3223,  1384,    88,   574,
     574,  3642,   575,  1390,   574,  1392,   238,   126,   574,   238,
    1397,  1398,   489,  1400,   489,   494,   563,   564,   565,   566,
     567,   568,   569,   570,    66,  1412,   553,    16,  1415,   574,
     553,   380,   530,   530,  1421,  1422,  1423,  1424,   236,   334,
     574,   536,   553,   522,  1431,  1432,  1433,   574,   574,   574,
     574,   574,   172,   563,   564,   565,   566,   567,   568,   569,
     570,   574,  1449,   574,   553,   574,   574,   219,   574,   574,
     553,  1458,   575,   338,   338,   219,   575,  2476,   574,   428,
     349,  2480,   553,   524,   236,   574,   485,   276,  1475,   255,
      58,   574,   236,   553,   370,    68,   349,   249,   374,  1486,
     573,   573,    58,   332,   333,   249,   573,    80,   337,  3336,
     229,  1498,   574,   372,   374,   344,   574,  1504,   564,   565,
     566,   567,   568,   569,   570,   574,   574,  3354,  3355,   219,
      45,    45,   138,    45,     4,   145,    23,    24,   394,     9,
      10,     5,   349,   372,   349,   574,   236,  3374,   121,  3376,
     134,  3378,  3379,    45,   575,   413,  3355,    27,   574,   249,
      45,    45,    32,  3390,   575,    16,    36,   121,    55,    56,
      57,   545,   324,   424,   582,   573,  1563,    64,   145,   146,
     324,    68,   280,   175,   545,  1572,   574,   145,   226,   141,
      77,   450,   344,   574,   313,   544,    23,    24,   581,  3426,
     344,   213,   575,   545,   141,   434,   109,   556,   269,    96,
     486,   581,   214,   561,  1601,   582,   581,   184,   573,   575,
     338,   141,  1609,  1610,   111,   501,   120,   114,    55,    56,
      57,   198,   560,  3460,   324,   199,   575,    64,  3465,   255,
     436,    68,   561,   581,   172,   172,   116,   172,   404,   560,
      77,   527,    34,   111,   344,   547,   143,  3484,   517,   536,
    3487,  3488,  3489,   173,   416,   232,   542,  1822,   241,    96,
     689,  1590,   416,  3555,  3336,  3216,  3693,   244,  3209,  3656,
    3507,  3664,  3587,  3587,   111,  3546,  3042,   114,   517,  3553,
    1145,  3518,   405,  3137,  2771,  1559,  2701,  2051,  1563,  1525,
    2013,  3528,  3529,  1966,   271,  2688,  3533,  2724,  2707,  2724,
    2757,   205,  3164,  2958,  3004,  2995,   143,  2689,   100,   471,
     439,   440,  3549,   126,  3551,   107,   416,   471,  2644,  3389,
     217,  3380,  3156,   145,  3223,  3305,  3179,   224,   311,  2009,
    3567,  1158,  2741,  2742,    34,  1065,  1871,   698,   126,  3576,
    2749,  1493,   164,  1141,  1423,  2267,  3583,  2756,  1885,   332,
     333,   328,   335,  3590,   682,  3592,  3593,   469,  1853,   263,
     613,  3085,   184,  3270,  3601,  1438,   158,  2883,  2882,  2659,
    3607,   471,  2085,  3379,   166,  1236,   198,  1186,  1775,  2242,
     217,  3134,  2695,   287,  3581,  3622,  3113,   224,  3625,  1890,
    3627,  3628,  1610,   956,  3631,   292,  3633,   979,  1849,  1875,
     100,  2897,  3639,  2669,  2611,  3642,   389,   107,  2610,  3646,
     307,   203,  3646,   459,  1616,  3652,   229,   516,  3465,   548,
     450,   243,   244,  1163,  1483,  3662,   984,  2601,  3665,  3536,
    3667,  3668,  3367,  3435,   563,   564,   565,   566,   567,   568,
     569,   570,  3679,  3680,  3662,  1389,  3683,  3556,  2997,   271,
    2616,  1444,  2319,  2652,  2923,   292,  3693,   997,   158,  3121,
     987,   358,   442,  1415,   361,   596,   166,  3258,  1150,   373,
     307,   949,  2254,   443,  3264,   267,   600,   381,   461,  1876,
    3081,   486,   731,  1307,  2768,  2049,  3039,   384,   385,    -1,
     387,    -1,    -1,    -1,    -1,    -1,    -1,  1894,  1895,    -1,
     313,    -1,    -1,   203,  1901,   409,  1903,  1904,   330,     3,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    13,
      14,   358,    -1,    -1,   361,   313,   423,    -1,    -1,    -1,
      -1,    -1,    26,   325,    28,    -1,    -1,   417,    -1,    -1,
      -1,   445,   334,  1940,    -1,   337,   338,   384,   385,   371,
     387,    -1,   432,    47,    48,  1952,  1953,    -1,   438,    53,
      -1,    -1,   466,    57,    58,  1962,    -1,   267,    -1,    -1,
      -1,  1968,    -1,    -1,  1971,    -1,    70,  1974,   458,   483,
      -1,   485,    -1,    -1,    -1,    -1,   423,    -1,  1985,  1986,
      -1,  1988,  3460,    87,    -1,    -1,    -1,  1994,  1995,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2004,    -1,  2006,
     507,    -1,   106,  2010,  2011,    23,    24,    -1,    -1,   516,
      -1,   115,   116,   117,    -1,   325,   439,   440,    -1,    -1,
      -1,    -1,    -1,    -1,   128,   129,    -1,   337,   338,    -1,
      -1,    -1,   126,    -1,    12,    13,    -1,    55,    56,    57,
      -1,   439,   440,  2050,  2051,    -1,    64,   151,    -1,    -1,
      68,    -1,    -1,    -1,    -1,  3533,    -1,    -1,    -1,    77,
     507,    -1,    -1,    -1,   168,    -1,    -1,    -1,   575,   516,
    2077,  3549,    -1,  3551,    -1,    -1,    -1,  2084,    96,   518,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   489,   192,   491,
    2097,    -1,   494,   111,    -1,   199,   114,    -1,   202,    -1,
      -1,   126,   504,    -1,    -1,    -1,    -1,    -1,   510,    87,
      -1,   513,  3590,    -1,    -1,  3593,    -1,    -1,    -1,   223,
      -1,    -1,    -1,  3601,    -1,   143,    -1,    -1,    -1,    -1,
      -1,    -1,   571,    -1,    -1,   239,  2143,   115,    -1,    -1,
     563,   564,   565,   566,   567,   568,   569,   570,    -1,    -1,
    3628,   129,    -1,   257,    -1,    -1,    -1,    -1,   262,    -1,
      -1,  3639,    -1,   565,   566,   563,   564,   565,   566,   567,
     568,   569,   570,   151,  3652,    -1,    -1,    -1,    -1,   489,
      -1,   491,    -1,    -1,   494,   163,    -1,    -1,    12,    13,
      -1,    -1,    -1,    -1,   504,  1515,    -1,    -1,    -1,   217,
     510,  3679,  3680,   513,   229,  3683,   224,  1527,  1528,    -1,
    1530,  1531,  1532,    -1,   192,  1535,    -1,    -1,  2225,   313,
    1540,    -1,    -1,    -1,  1544,  1545,  1546,   252,    -1,  1549,
    1550,  1551,  1552,  1553,   252,  1555,  1556,  1557,    -1,   217,
      -1,    -1,    -1,  2250,   348,   223,    -1,  2254,    -1,  2256,
    2257,  2258,  2259,    -1,    -1,   565,   566,    -1,    -1,    -1,
    2267,    -1,   701,    87,  2271,    -1,   370,  2274,    -1,    -1,
      -1,    -1,    -1,    -1,   292,   379,    -1,    -1,    -1,    -1,
      -1,  2288,  2289,  2290,   262,    -1,    13,    -1,   313,   307,
      -1,   115,    -1,    -1,  2301,   399,    -1,   401,   402,    -1,
    2307,   405,  2309,    -1,   408,   129,   410,   332,   333,    -1,
    2317,   415,    -1,   417,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   426,    -1,    -1,    -1,   430,   151,    -1,    -1,
      -1,    -1,   436,    -1,    -1,    -1,    -1,   441,    -1,   163,
     358,   445,    -1,   361,    -1,   439,   440,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      87,   465,    -1,   802,    -1,   469,   384,   385,   192,   387,
     395,  2378,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2389,    -1,    -1,  2392,    -1,    -1,   115,   828,
      -1,    -1,    -1,   217,    -1,    -1,    -1,   375,    -1,   223,
      -1,   505,   129,    -1,    -1,   423,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   439,   440,   394,   521,    -1,  2426,
     524,    -1,   400,   448,   151,   529,  2433,    -1,   406,  2436,
      -1,    -1,    -1,  2440,  2441,    -1,   163,  2444,   262,   878,
      -1,    -1,    -1,   882,    -1,    -1,    -1,  2454,   552,    -1,
      -1,    -1,   430,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   441,   442,   192,    -1,    -1,    -1,   573,
      -1,   565,   566,   567,   568,   569,   570,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   507,
     217,    -1,    -1,    -1,    -1,    -1,   223,    -1,   516,    -1,
     478,   273,   274,   275,   276,   277,   278,    -1,    -1,   281,
     282,   283,   284,   285,   286,    -1,   288,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   262,    -1,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   524,    -1,   526,    -1,
      -1,   375,    -1,    -1,    -1,   573,    -1,    -1,   997,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1006,    -1,    -1,
     394,    -1,    -1,    -1,    -1,    -1,   400,    -1,    -1,    -1,
      -1,    -1,   406,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   430,    -1,    -1,  2616,
    2617,    -1,  2619,    -1,    -1,    -1,    -1,   441,   442,    -1,
      -1,  2628,    -1,    -1,   396,   397,    -1,  2634,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2644,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2652,    -1,    -1,   375,    -1,
      -1,    -1,    -1,    -1,   478,    -1,    -1,    -1,    -1,  1979,
      -1,    -1,  2669,    -1,    -1,    -1,    -1,   394,    -1,    -1,
    1990,    -1,    -1,   400,  2681,    -1,    -1,    -1,    -1,   406,
      -1,  2688,    -1,    -1,    -1,    -1,    -1,    -1,  2695,    -1,
      -1,    -1,    -1,    -1,  2701,    -1,    -1,    -1,    -1,    -1,
     524,    -1,   526,   430,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   441,   442,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1167,  1168,
    1169,    -1,    -1,    -1,    -1,    -1,    -1,  1176,  1177,    -1,
      -1,  1180,    -1,  1182,  1183,  1184,  1185,    -1,    -1,    -1,
    1189,   478,    -1,  1192,  1193,    -1,  1195,    -1,  1197,  1198,
      -1,  1200,  1201,  1202,  1203,  1204,    -1,  1206,  2775,  1208,
    1209,  1210,    -1,  1212,  1213,  1214,  1215,    -1,  1217,  1218,
      -1,  1220,    -1,    -1,  1223,  1224,  1225,    -1,  1227,  1228,
    1229,  1230,    -1,  1232,  1233,  1234,  1235,   524,    -1,   526,
      -1,    -1,  1241,  1242,    -1,  1244,  1245,  1246,  1247,  1248,
      -1,    -1,    -1,    -1,  1253,    -1,  1255,  1256,  1257,  1258,
    1259,    -1,    -1,  1262,  1263,  1264,  1265,  1266,  1267,    -1,
    1269,  1270,    -1,    -1,  1273,  1274,  1275,    -1,  1277,    -1,
    1279,    -1,    -1,    -1,  1283,    -1,  1285,  1286,    -1,    -1,
      -1,    -1,  1291,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1299,  1300,  1301,    -1,    -1,    -1,    -1,  2874,    -1,  1308,
      -1,    -1,  1311,    -1,    13,    14,    -1,    -1,    -1,  1318,
    1319,  1320,    -1,    -1,    -1,    -1,    -1,    26,    -1,    -1,
    2897,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   101,   102,
     103,   104,   105,    -1,    -1,  2912,    -1,    -1,    47,    48,
      -1,    -1,    -1,    -1,    53,    -1,    -1,    -1,    57,    58,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    -1,    -1,  1374,    -1,    -1,    -1,    -1,
      -1,    31,    32,    -1,    -1,    -1,  2953,    37,    87,    39,
      -1,    41,    42,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    56,   106,  2975,    -1,
      -1,   174,    -1,    -1,    -1,    -1,   115,   116,   117,  1418,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2995,   128,
     129,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   206,   207,   208,   209,    97,    -1,    -1,
     100,    -1,   151,  3020,    -1,  3022,    -1,    -1,   108,    -1,
      -1,    -1,    -1,    -1,    -1,  3032,    -1,    -1,    -1,   168,
      -1,  3038,    -1,    -1,    -1,    -1,    -1,   127,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   192,   144,    -1,    -1,    -1,    -1,    -1,
     199,    -1,    -1,   202,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,     6,   165,    -1,   167,  3085,    -1,
      -1,    13,    -1,    -1,   223,    -1,    -1,    -1,    -1,    -1,
      -1,    23,    24,    -1,    -1,    -1,   186,   187,    -1,   302,
     239,   304,   305,   306,    -1,    -1,  3113,    -1,    -1,    -1,
      -1,   314,    -1,    -1,    -1,    -1,    -1,    -1,   257,    -1,
      -1,    53,    -1,   262,    -1,    57,  3133,    -1,    -1,    -1,
      -1,    -1,  3139,  3140,    -1,  1574,    68,   227,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    77,  3153,    -1,    -1,    -1,
      -1,    83,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    96,  3172,   256,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   265,   266,   380,   268,   111,
      -1,    -1,   114,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   123,    -1,    -1,    -1,    -1,    -1,   129,    -1,    -1,
      -1,    -1,    -1,  3210,    -1,   137,   296,   297,   298,   348,
      -1,   143,    -1,    -1,    -1,    -1,  3223,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   427,   428,    -1,   317,   318,   319,
      -1,   370,    -1,   323,    -1,    -1,   326,   169,    -1,    -1,
     379,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   339,
     340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     399,    -1,   401,   402,    -1,    -1,   405,    -1,    -1,   408,
      -1,   410,    -1,    -1,    -1,   365,   415,   367,   417,    -1,
      -1,    -1,    -1,    -1,    -1,   217,    -1,   426,    -1,    -1,
      -1,   430,   224,    -1,    -1,    -1,    -1,   436,    -1,    -1,
      -1,   391,   441,    -1,    -1,    -1,   445,    -1,  1747,  1748,
    1749,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1764,   465,    -1,    -1,  3336,
     469,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   544,    -1,    -1,   434,    -1,   436,  3354,  3355,    -1,
      -1,  1790,   555,   556,    -1,    -1,   446,    -1,    -1,    -1,
     292,    -1,    -1,    -1,    -1,    -1,   505,  3374,    -1,  3376,
      -1,  3378,  3379,  1812,    -1,   307,    -1,    -1,    -1,    -1,
     312,    -1,   521,  3390,    -1,   524,    -1,    -1,    -1,    -1,
     529,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     490,   491,    -1,    -1,   494,   495,   496,   497,    -1,    -1,
      -1,    -1,    -1,   552,    -1,    -1,    -1,    -1,    -1,  3426,
     352,    -1,    -1,    -1,    -1,    -1,   358,    -1,    -1,   361,
      -1,    -1,    -1,    -1,   573,    -1,    -1,    -1,    -1,    23,
      24,    -1,    -1,    -1,    -1,    -1,    -1,   537,   538,    -1,
      -1,    -1,   384,   385,    -1,   387,    -1,    -1,  3465,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   556,    -1,    -1,   401,
      -1,    -1,    -1,    57,    -1,    -1,    -1,  3484,    -1,    -1,
      -1,    -1,  3489,    -1,    68,    -1,    -1,    -1,    -1,    -1,
      -1,   423,    -1,    77,    -1,    -1,    -1,    -1,    -1,    -1,
    3507,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3518,    96,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   111,    -1,    -1,
     114,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   143,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   507,  3583,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   516,  3592,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3625,    -1,
    3627,    -1,    -1,    -1,    -1,  2064,  3633,    -1,  2067,    -1,
      -1,  2070,  2071,   217,    -1,  3642,    -1,    -1,    -1,  3646,
     224,    -1,    -1,    -1,  2083,    -1,    -1,  2086,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3662,    -1,    -1,    -1,    -1,
    2099,  3668,  2101,    -1,    -1,    -1,  2105,    -1,  2107,  2108,
      -1,    -1,    -1,  2112,    -1,  2114,  2115,    -1,  2117,    -1,
      -1,  2120,    -1,  2122,  2123,    -1,  3693,    -1,    -1,  2128,
    2129,    -1,    -1,  2132,    -1,  2134,    -1,  2136,    -1,  2138,
      -1,  2140,    -1,    -1,    -1,    -1,    -1,    -1,   292,    -1,
      -1,    -1,  2151,  2152,    -1,    -1,  2155,    -1,  2157,    -1,
      -1,    -1,    -1,   307,    -1,    -1,  2165,  2166,    -1,  2168,
      -1,  2170,    -1,    -1,  2173,  2174,  2175,    -1,  2177,    -1,
      -1,    -1,    -1,  2182,  2183,  2184,  2185,    -1,    -1,    -1,
      -1,  2190,  2191,  2192,    -1,  2194,    -1,  2196,    -1,  2198,
      -1,  2200,    -1,  2202,    -1,    -1,    -1,    -1,    -1,    -1,
    2209,    -1,  2211,    -1,   358,  2214,  2215,   361,    -1,    -1,
      -1,    30,    -1,    32,    33,    -1,    -1,  2226,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     384,   385,  2241,   387,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    65,    -1,    67,    -1,
      -1,    -1,  2261,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    85,    -1,    87,   423,
    3460,    -1,    -1,    -1,    -1,    -1,    95,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3487,  3488,    -1,
      -1,  2310,    -1,    -1,    -1,    -1,  2315,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   142,   143,    -1,    -1,    -1,   147,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3528,  3529,
      -1,    -1,    -1,  3533,    -1,    -1,    -1,    -1,    -1,    -1,
    2359,    -1,    -1,   507,    -1,    -1,    -1,    -1,   177,  3549,
     179,  3551,   516,    -1,  2373,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   191,    -1,   193,    -1,    -1,  3567,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3576,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   216,   217,    -1,
    3590,   220,    -1,  3593,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3601,    -1,    -1,    -1,    -1,    -1,  3607,   237,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3622,    -1,    -1,    -1,    -1,    -1,  3628,   258,
      -1,  3631,    -1,    -1,   263,    -1,    -1,    -1,    -1,  3639,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2469,    -1,  3652,    -1,    -1,    -1,    -1,    -1,   287,    -1,
      -1,    -1,    -1,    -1,    -1,  3665,    -1,  3667,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3679,
    3680,    -1,    -1,  3683,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   320,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     329,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   347,    -1,
      -1,    -1,    -1,  2542,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2552,    -1,  2554,    -1,  2556,    -1,    -1,
      -1,    -1,    -1,  2562,   373,   374,    -1,    -1,   377,   378,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2585,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   435,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   445,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2653,    -1,    -1,   466,    -1,    -1,
      -1,   470,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   485,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     539,    -1,    -1,    -1,   543,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2798,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2808,
      -1,    -1,    -1,    -1,    -1,  2814,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2823,  2824,    -1,    -1,    -1,    -1,
    2829,    -1,    -1,    -1,  2833,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2846,    -1,    -1,
      -1,    -1,    -1,  2852,    -1,    -1,  2855,  2856,    -1,  2858,
    2859,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2872,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2938,
    2939,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2949,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3108,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3121,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3232,    -1,    -1,    -1,    -1,    -1,  3238,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3274,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3284,    -1,  3286,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3358,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3415,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3438,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3523,  3524,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3542,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3552,    -1,    -1,    -1,    -1,  3557,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3566,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,  3597,    17,
      -1,    -1,    20,    -1,    22,    23,    24,    25,    26,  3608,
      28,    29,    30,    -1,    32,    33,    34,    35,    36,    37,
      38,    -1,    40,    41,    42,    43,    44,    -1,    46,    47,
      -1,    -1,    50,    51,    52,    -1,    54,    55,    56,    57,
      -1,    59,    60,    61,    62,    63,    -1,    65,    66,    -1,
      68,    69,    70,    71,    72,    73,    74,    75,    -1,    77,
      78,    -1,    80,    81,    -1,    83,    84,    85,    86,    -1,
    3669,    89,    90,    91,    -1,    93,    94,    -1,    96,    97,
      98,    99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,
      -1,    -1,   110,   111,   112,    -1,   114,    -1,    -1,    -1,
     118,   119,   120,    -1,   122,   123,   124,    -1,    -1,    -1,
     128,    -1,    -1,   131,   132,   133,    -1,    -1,   136,   137,
      -1,   139,   140,   141,   142,   143,   144,    -1,    -1,   147,
      -1,   149,   150,   151,   152,    -1,   154,   155,   156,   157,
     158,   159,   160,    -1,   162,   163,   164,   165,   166,    -1,
     168,    -1,    -1,   171,    -1,   173,   174,    -1,   176,   177,
      -1,   179,   180,   181,   182,   183,    -1,   185,   186,   187,
     188,   189,   190,   191,    -1,   193,   194,    -1,   196,   197,
      -1,   199,   200,    -1,   202,   203,    -1,   205,    -1,    -1,
      -1,   209,   210,   211,   212,   213,    -1,   215,   216,    -1,
      -1,    -1,   220,    -1,    -1,   223,   224,   225,    -1,    -1,
     228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,
      -1,    -1,    -1,   241,   242,   243,    -1,   245,   246,   247,
      -1,   249,   250,    -1,    -1,    -1,   254,    -1,   256,    -1,
     258,   259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,
      -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,    -1,    -1,
      -1,   299,   300,   301,   302,   303,    -1,    -1,   306,   307,
     308,   309,   310,    -1,   312,   313,   314,   315,   316,   317,
     318,   319,   320,   321,   322,   323,    -1,   325,   326,   327,
      -1,   329,   330,   331,   332,   333,   334,   335,    -1,   337,
     338,    -1,   340,   341,    -1,   343,    -1,   345,   346,   347,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     358,   359,   360,   361,   362,   363,   364,   365,   366,   367,
     368,    -1,   370,   371,    -1,   373,    -1,   375,   376,   377,
     378,    -1,   380,   381,   382,   383,   384,   385,   386,   387,
     388,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,
     398,    -1,   400,    -1,   402,   403,   404,   405,   406,    -1,
     408,   409,   410,    -1,   412,   413,    -1,    -1,   416,   417,
     418,   419,   420,   421,   422,   423,   424,   425,   426,    -1,
     428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,    -1,
     438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,   447,
     448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,   457,
      -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,   467,
     468,   469,   470,    -1,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,   482,   483,   484,    -1,   486,   487,
      -1,   489,   490,   491,   492,   493,   494,    -1,    -1,    -1,
      -1,   499,   500,    -1,   502,   503,   504,   505,   506,   507,
     508,    -1,   510,   511,   512,   513,    -1,   515,    -1,    -1,
     518,   519,   520,    -1,    -1,   523,    -1,   525,    -1,   527,
     528,    -1,    -1,   531,   532,   533,   534,   535,   536,    -1,
      -1,   539,   540,    -1,   542,   543,   544,    -1,    -1,    -1,
      -1,   549,    -1,   551,   552,    -1,   554,    -1,   556,    -1,
      -1,    -1,    -1,   561,    -1,    -1,    -1,   565,   566,    -1,
      -1,    -1,    -1,   571,    -1,   573,    -1,    -1,   576,   577,
      -1,   579,   580,     5,    -1,     7,     8,     9,    10,    11,
      12,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    -1,    28,    29,    30,    -1,
      32,    33,    34,    35,    36,    37,    38,    -1,    40,    41,
      42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,    51,
      52,    -1,    54,    55,    56,    57,    -1,    59,    60,    61,
      62,    63,    -1,    65,    66,    -1,    68,    69,    70,    71,
      72,    73,    74,    75,    -1,    77,    78,    -1,    80,    81,
      -1,    83,    84,    85,    86,    -1,    -1,    89,    90,    91,
      -1,    93,    94,    -1,    96,    97,    98,    99,   100,    -1,
      -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,   111,
     112,    -1,   114,    -1,    -1,    -1,   118,   119,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,   136,   137,    -1,   139,   140,   141,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
     152,    -1,   154,   155,   156,   157,   158,   159,   160,    -1,
     162,   163,   164,   165,   166,    -1,   168,    -1,    -1,   171,
      -1,   173,   174,    -1,   176,   177,    -1,   179,   180,   181,
     182,   183,    -1,   185,   186,   187,   188,   189,   190,   191,
      -1,   193,   194,    -1,   196,   197,    -1,   199,   200,    -1,
     202,   203,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,
      -1,   223,   224,   225,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,
     242,   243,    -1,    -1,   246,   247,    -1,   249,   250,    -1,
      -1,    -1,   254,    -1,   256,    -1,   258,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,   267,    -1,    -1,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,   308,   309,   310,    -1,
     312,   313,   314,   315,   316,   317,   318,   319,   320,   321,
     322,   323,    -1,   325,   326,   327,    -1,   329,   330,   331,
     332,   333,   334,   335,    -1,   337,   338,    -1,   340,   341,
      -1,   343,   344,   345,   346,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
     362,   363,   364,   365,   366,   367,   368,    -1,   370,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,   388,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
     402,   403,   404,   405,   406,    -1,   408,   409,   410,    -1,
     412,   413,    -1,    -1,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,    -1,   428,   429,    -1,    -1,
      -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,    -1,
     442,   443,   444,   445,    -1,   447,   448,   449,    -1,    -1,
      -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,    -1,
     462,    -1,    -1,   465,   466,   467,   468,   469,   470,    -1,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
     482,   483,   484,    -1,   486,   487,    -1,   489,   490,   491,
     492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,    -1,
     502,   503,   504,   505,   506,   507,   508,    -1,   510,   511,
     512,   513,    -1,   515,    -1,    -1,   518,   519,   520,    -1,
      -1,   523,    -1,   525,    -1,   527,   528,    -1,    -1,   531,
     532,   533,   534,   535,   536,    -1,    -1,   539,   540,    -1,
     542,   543,   544,    -1,    -1,    -1,    -1,   549,    -1,   551,
     552,    -1,   554,    -1,   556,    -1,    -1,    -1,    -1,   561,
      -1,    -1,    -1,   565,   566,    -1,    -1,    -1,    -1,   571,
      -1,   573,    -1,    -1,   576,   577,    -1,   579,   580,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,    25,
      26,    -1,    28,    29,    30,    -1,    32,    33,    34,    35,
      36,    37,    38,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    51,    52,    -1,    54,    55,
      56,    57,    -1,    59,    60,    61,    62,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    73,    74,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    83,    84,    85,
      86,    -1,    -1,    89,    90,    91,    -1,    93,    94,    -1,
      96,    97,    98,    99,   100,    -1,    -1,    -1,    -1,   105,
     106,   107,    -1,    -1,   110,   111,   112,    -1,   114,    -1,
      -1,    -1,   118,   119,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
     136,   137,    -1,   139,   140,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,   152,    -1,   154,   155,
     156,   157,   158,   159,   160,    -1,   162,   163,   164,   165,
     166,    -1,   168,    -1,    -1,   171,    -1,   173,   174,    -1,
     176,   177,    -1,   179,   180,   181,   182,   183,    -1,   185,
     186,   187,   188,   189,   190,   191,    -1,   193,   194,    -1,
     196,   197,    -1,   199,   200,    -1,   202,   203,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,   223,   224,   225,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,   242,   243,    -1,    -1,
     246,   247,    -1,   249,   250,    -1,    -1,    -1,   254,    -1,
     256,    -1,   258,   259,    -1,   261,    -1,   263,   264,    -1,
      -1,   267,    -1,    -1,    -1,    -1,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,   308,   309,   310,    -1,   312,   313,   314,   315,
     316,   317,   318,   319,   320,   321,   322,   323,    -1,   325,
     326,   327,    -1,   329,   330,   331,   332,   333,   334,   335,
      -1,   337,   338,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,   362,   363,   364,   365,
     366,   367,   368,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,   388,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,   404,   405,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,    -1,   428,   429,   430,    -1,    -1,   433,   434,   435,
      -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,
      -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,
     456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,
     466,   467,   468,   469,   470,    -1,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,   482,   483,   484,    -1,
     486,   487,    -1,   489,   490,   491,   492,   493,   494,    -1,
      -1,    -1,    -1,    -1,   500,    -1,   502,   503,   504,   505,
     506,   507,   508,    -1,   510,   511,   512,   513,    -1,   515,
      -1,    -1,   518,   519,   520,    -1,    -1,   523,    -1,   525,
      -1,   527,   528,    -1,    -1,   531,   532,   533,   534,   535,
     536,    -1,    -1,   539,   540,    -1,   542,   543,   544,    -1,
      -1,    -1,    -1,   549,    -1,   551,   552,    -1,   554,    -1,
     556,    -1,    -1,    -1,    -1,   561,    -1,    -1,    -1,   565,
     566,    -1,    -1,    -1,    -1,   571,    -1,   573,    -1,    -1,
     576,   577,    -1,   579,   580,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,    -1,    28,    29,
      30,    -1,    32,    33,    34,    35,    36,    37,    38,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    51,    52,    -1,    54,    55,    56,    57,    -1,    59,
      60,    61,    62,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    73,    74,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    83,    84,    85,    86,    -1,    -1,    89,
      90,    91,    -1,    93,    94,    -1,    96,    97,    98,    99,
     100,    -1,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,
     110,   111,   112,    -1,   114,    -1,    -1,    -1,   118,   119,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,   136,   137,    -1,   139,
     140,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,   152,    -1,   154,   155,   156,   157,   158,   159,
     160,    -1,   162,   163,   164,   165,   166,    -1,   168,    -1,
      -1,   171,    -1,   173,   174,    -1,   176,   177,    -1,   179,
     180,   181,   182,   183,    -1,   185,   186,   187,   188,   189,
     190,   191,    -1,   193,   194,    -1,   196,   197,    -1,   199,
     200,    -1,   202,   203,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,   223,   224,   225,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,   242,   243,    -1,    -1,   246,   247,    -1,   249,
     250,    -1,    -1,    -1,   254,    -1,   256,    -1,   258,   259,
      -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,    -1,
      -1,    -1,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,   308,   309,
     310,    -1,   312,   313,   314,   315,   316,   317,   318,   319,
     320,   321,   322,   323,    -1,   325,   326,   327,    -1,   329,
     330,   331,   332,   333,   334,   335,    -1,   337,   338,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,   362,   363,   364,   365,   366,   367,   368,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,   388,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,   404,   405,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,    -1,   428,   429,
      -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,
      -1,    -1,   442,   443,   444,   445,    -1,   447,   448,   449,
      -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,
      -1,    -1,   462,    -1,    -1,   465,   466,   467,   468,   469,
     470,    -1,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,   482,   483,   484,    -1,   486,   487,    -1,   489,
     490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,
     500,    -1,   502,   503,   504,   505,   506,   507,   508,    -1,
     510,   511,   512,   513,    -1,   515,    -1,    -1,   518,   519,
     520,    -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,
      -1,   531,   532,   533,   534,   535,   536,    -1,    -1,   539,
     540,    -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,
      -1,   551,   552,    -1,   554,    -1,   556,    -1,    -1,    -1,
      -1,   561,    -1,    -1,    -1,   565,   566,    -1,    -1,    -1,
      -1,   571,    -1,   573,   574,    -1,   576,   577,    -1,   579,
     580,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    -1,    28,    29,    30,    -1,    32,    33,
      34,    35,    36,    37,    38,    -1,    40,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    51,    52,    -1,
      54,    55,    56,    57,    -1,    59,    60,    61,    62,    63,
      -1,    65,    66,    -1,    68,    69,    70,    71,    72,    73,
      74,    75,    -1,    77,    78,    -1,    80,    81,    -1,    83,
      84,    85,    86,    -1,    -1,    89,    90,    91,    -1,    93,
      94,    -1,    96,    97,    98,    99,   100,    -1,    -1,    -1,
      -1,   105,   106,   107,    -1,    -1,   110,   111,   112,    -1,
     114,    -1,    -1,    -1,   118,   119,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,   136,   137,    -1,   139,   140,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,   152,    -1,
     154,   155,   156,   157,   158,   159,   160,    -1,   162,   163,
     164,   165,   166,    -1,   168,    -1,    -1,   171,    -1,   173,
     174,    -1,   176,   177,    -1,   179,   180,   181,   182,   183,
      -1,   185,   186,   187,   188,   189,   190,   191,    -1,   193,
     194,    -1,   196,   197,    -1,   199,   200,    -1,   202,   203,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,   213,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,   223,
     224,   225,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,   243,
      -1,    -1,   246,   247,    -1,   249,   250,    -1,    -1,    -1,
     254,    -1,   256,    -1,   258,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,   267,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,   308,   309,   310,    -1,   312,   313,
     314,   315,   316,   317,   318,   319,   320,   321,   322,   323,
      -1,   325,   326,   327,    -1,   329,   330,   331,   332,   333,
     334,   335,    -1,   337,   338,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,   368,    -1,   370,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,   388,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,   403,
     404,   405,   406,    -1,   408,   409,   410,    -1,   412,   413,
      -1,    -1,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,    -1,   428,   429,    -1,    -1,    -1,   433,
     434,   435,    -1,    -1,   438,    -1,    -1,    -1,   442,   443,
     444,   445,    -1,   447,   448,   449,    -1,    -1,    -1,    -1,
      -1,    -1,   456,   457,    -1,   459,    -1,    -1,   462,    -1,
      -1,   465,   466,   467,   468,   469,   470,    -1,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,   482,   483,
     484,    -1,   486,   487,    -1,   489,   490,   491,   492,   493,
     494,    -1,    -1,    -1,    -1,    -1,   500,    -1,   502,   503,
     504,   505,   506,   507,   508,    -1,   510,   511,   512,   513,
      -1,   515,    -1,    -1,   518,   519,   520,    -1,    -1,   523,
      -1,   525,    -1,   527,   528,    -1,    -1,   531,   532,   533,
     534,   535,   536,    -1,    -1,   539,   540,    -1,   542,   543,
     544,    -1,    -1,    -1,    -1,   549,    -1,   551,   552,    -1,
     554,    -1,   556,    -1,    -1,    -1,    -1,   561,    -1,    -1,
      -1,   565,   566,    -1,    -1,    -1,    -1,   571,    -1,   573,
     574,    -1,   576,   577,    -1,   579,   580,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    22,    23,    24,    25,    26,    -1,
      28,    29,    30,    -1,    32,    33,    34,    35,    36,    37,
      38,    -1,    40,    41,    42,    -1,    44,    -1,    46,    47,
      -1,    -1,    50,    51,    52,    -1,    54,    55,    56,    57,
      -1,    59,    60,    61,    62,    63,    -1,    65,    66,    -1,
      68,    69,    70,    71,    72,    73,    74,    75,    -1,    77,
      78,    -1,    80,    81,    -1,    83,    84,    85,    86,    -1,
      -1,    89,    90,    91,    -1,    93,    94,    -1,    96,    97,
      98,    99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,
      -1,    -1,   110,   111,   112,    -1,   114,    -1,    -1,    -1,
     118,   119,   120,    -1,   122,   123,   124,    -1,    -1,    -1,
     128,    -1,    -1,   131,   132,   133,    -1,    -1,   136,   137,
      -1,   139,   140,   141,   142,   143,   144,    -1,    -1,   147,
      -1,   149,   150,   151,   152,    -1,   154,   155,   156,   157,
     158,   159,   160,    -1,   162,   163,   164,   165,   166,    -1,
     168,    -1,    -1,   171,    -1,   173,   174,    -1,   176,   177,
      -1,   179,   180,   181,   182,   183,    -1,   185,   186,   187,
     188,   189,   190,   191,    -1,   193,   194,    -1,   196,   197,
      -1,   199,   200,    -1,   202,   203,    -1,   205,    -1,    -1,
      -1,   209,   210,   211,   212,   213,    -1,   215,   216,    -1,
      -1,    -1,   220,    -1,    -1,   223,   224,   225,    -1,    -1,
     228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,
      -1,    -1,    -1,   241,   242,   243,    -1,    -1,   246,   247,
      -1,   249,   250,    -1,    -1,    -1,   254,    -1,   256,    -1,
     258,   259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,
      -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,    -1,    -1,
      -1,   299,   300,   301,   302,   303,    -1,    -1,   306,   307,
     308,   309,   310,    -1,   312,   313,   314,   315,   316,   317,
     318,   319,   320,   321,   322,   323,    -1,   325,   326,   327,
      -1,   329,   330,   331,   332,   333,   334,   335,    -1,   337,
     338,    -1,   340,   341,    -1,   343,    -1,   345,   346,   347,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     358,   359,   360,   361,   362,   363,   364,   365,   366,   367,
     368,    -1,   370,   371,    -1,   373,    -1,   375,   376,   377,
     378,    -1,   380,   381,   382,   383,   384,   385,   386,   387,
     388,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,
     398,    -1,   400,    -1,   402,   403,   404,   405,   406,    -1,
     408,   409,   410,    -1,   412,   413,    -1,    -1,   416,   417,
     418,   419,   420,   421,   422,   423,   424,   425,   426,    -1,
     428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,    -1,
     438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,   447,
     448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,   457,
      -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,   467,
     468,   469,   470,    -1,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,   482,   483,   484,    -1,   486,   487,
      -1,   489,   490,   491,   492,   493,   494,    -1,    -1,    -1,
      -1,    -1,   500,    -1,   502,   503,   504,   505,   506,   507,
     508,    -1,   510,   511,   512,   513,    -1,   515,    -1,    -1,
     518,   519,   520,    -1,    -1,   523,    -1,   525,    -1,   527,
     528,    -1,    -1,   531,   532,   533,   534,   535,   536,    -1,
      -1,   539,   540,    -1,   542,   543,   544,    -1,    -1,    -1,
      -1,   549,    -1,   551,   552,    -1,   554,    -1,   556,    -1,
      -1,    -1,    -1,   561,    -1,    -1,    -1,   565,   566,    -1,
      -1,    -1,    -1,   571,    -1,   573,   574,    -1,   576,   577,
      -1,   579,   580,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    -1,    28,    29,    30,    -1,
      32,    33,    34,    35,    36,    37,    38,    -1,    40,    41,
      42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,    51,
      52,    -1,    54,    55,    56,    57,    -1,    59,    60,    61,
      62,    63,    -1,    65,    66,    -1,    68,    69,    70,    71,
      72,    73,    74,    75,    -1,    77,    78,    -1,    80,    81,
      -1,    83,    84,    85,    86,    -1,    -1,    89,    90,    91,
      -1,    93,    94,    -1,    96,    97,    98,    99,   100,    -1,
      -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,   111,
     112,    -1,   114,    -1,    -1,    -1,   118,   119,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,   136,   137,    -1,   139,   140,   141,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
     152,    -1,   154,   155,   156,   157,   158,   159,   160,    -1,
     162,   163,   164,   165,   166,    -1,   168,    -1,    -1,   171,
      -1,   173,   174,    -1,   176,   177,    -1,   179,   180,   181,
     182,   183,    -1,   185,   186,   187,   188,   189,   190,   191,
      -1,   193,   194,    -1,   196,   197,    -1,   199,   200,    -1,
     202,   203,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,
      -1,   223,   224,   225,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,
     242,   243,    -1,    -1,   246,   247,    -1,   249,   250,    -1,
      -1,    -1,   254,    -1,   256,    -1,   258,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,   267,    -1,    -1,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,   308,   309,   310,    -1,
     312,   313,   314,   315,   316,   317,   318,   319,   320,   321,
     322,   323,    -1,   325,   326,   327,    -1,   329,   330,   331,
     332,   333,   334,   335,    -1,   337,   338,    -1,   340,   341,
      -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
     362,   363,   364,   365,   366,   367,   368,    -1,   370,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,   388,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
     402,   403,   404,   405,   406,    -1,   408,   409,   410,    -1,
     412,   413,    -1,    -1,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,    -1,   428,   429,    -1,    -1,
      -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,    -1,
     442,   443,   444,   445,    -1,   447,   448,   449,    -1,    -1,
      -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,    -1,
     462,    -1,    -1,   465,   466,   467,   468,   469,   470,    -1,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
     482,   483,   484,    -1,   486,   487,    -1,   489,   490,   491,
     492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,    -1,
     502,   503,   504,   505,   506,   507,   508,    -1,   510,   511,
     512,   513,    -1,   515,    -1,    -1,   518,   519,   520,    -1,
      -1,   523,    -1,   525,    -1,   527,   528,    -1,    -1,   531,
     532,   533,   534,   535,   536,    -1,    -1,   539,   540,    -1,
     542,   543,   544,    -1,    -1,    -1,    -1,   549,    -1,   551,
     552,    -1,   554,    -1,   556,    -1,    -1,    -1,    -1,   561,
      -1,    -1,    -1,   565,   566,    -1,    -1,    -1,    -1,   571,
      -1,   573,   574,    -1,   576,   577,    -1,   579,   580,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,    25,
      26,    -1,    28,    29,    30,    -1,    32,    33,    34,    35,
      36,    37,    38,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    51,    52,    -1,    54,    55,
      56,    57,    -1,    59,    60,    61,    62,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    73,    74,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    83,    84,    85,
      86,    -1,    -1,    89,    90,    91,    -1,    93,    94,    -1,
      96,    97,    98,    99,   100,    -1,    -1,    -1,    -1,   105,
     106,   107,    -1,    -1,   110,   111,   112,    -1,   114,    -1,
      -1,    -1,   118,   119,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
     136,   137,    -1,   139,   140,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,   152,    -1,   154,   155,
     156,   157,   158,   159,   160,    -1,   162,   163,   164,   165,
     166,    -1,   168,    -1,    -1,   171,    -1,   173,   174,   175,
     176,   177,    -1,   179,   180,   181,   182,   183,    -1,   185,
     186,   187,   188,   189,   190,   191,    -1,   193,   194,    -1,
     196,   197,    -1,   199,   200,    -1,   202,   203,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,   223,   224,   225,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,   242,   243,    -1,    -1,
     246,   247,    -1,   249,   250,    -1,    -1,    -1,   254,    -1,
     256,    -1,   258,   259,    -1,   261,    -1,   263,   264,    -1,
      -1,   267,    -1,    -1,    -1,    -1,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,   308,   309,   310,    -1,   312,   313,   314,   315,
     316,   317,   318,   319,   320,   321,   322,   323,    -1,   325,
     326,   327,    -1,   329,   330,   331,   332,   333,   334,   335,
      -1,   337,   338,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,   362,   363,   364,   365,
     366,   367,   368,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,   388,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,   404,   405,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,    -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,
      -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,
      -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,
     456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,
     466,   467,   468,   469,   470,    -1,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,   482,   483,   484,    -1,
     486,   487,    -1,   489,   490,   491,   492,   493,   494,    -1,
      -1,    -1,    -1,    -1,   500,    -1,   502,   503,   504,   505,
     506,   507,   508,    -1,   510,   511,   512,   513,    -1,   515,
      -1,    -1,   518,   519,   520,    -1,    -1,   523,    -1,   525,
      -1,   527,   528,    -1,    -1,   531,   532,   533,   534,   535,
     536,    -1,    -1,   539,   540,    -1,   542,   543,   544,    -1,
      -1,    -1,    -1,   549,    -1,   551,   552,    -1,   554,    -1,
     556,    -1,    -1,    -1,    -1,   561,    -1,    -1,    -1,   565,
     566,    -1,    -1,    -1,    -1,   571,    -1,   573,    -1,    -1,
     576,   577,    -1,   579,   580,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,    -1,    28,    29,
      30,    -1,    32,    33,    34,    35,    36,    37,    38,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    51,    52,    -1,    54,    55,    56,    57,    -1,    59,
      60,    61,    62,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    73,    74,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    83,    84,    85,    86,    -1,    -1,    89,
      90,    91,    -1,    93,    94,    -1,    96,    97,    98,    99,
     100,    -1,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,
     110,   111,   112,    -1,   114,    -1,    -1,    -1,   118,   119,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,   136,   137,    -1,   139,
     140,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,   152,    -1,   154,   155,   156,   157,   158,   159,
     160,    -1,   162,   163,   164,   165,   166,    -1,   168,    -1,
      -1,   171,    -1,   173,   174,   175,   176,   177,    -1,   179,
     180,   181,   182,   183,    -1,   185,   186,   187,   188,   189,
     190,   191,    -1,   193,   194,    -1,   196,   197,    -1,   199,
     200,    -1,   202,   203,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,   223,   224,   225,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,   242,   243,    -1,    -1,   246,   247,    -1,   249,
     250,    -1,    -1,    -1,   254,    -1,   256,    -1,   258,   259,
      -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,    -1,
      -1,    -1,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,   308,   309,
     310,    -1,   312,   313,   314,   315,   316,   317,   318,   319,
     320,   321,   322,   323,    -1,   325,   326,   327,    -1,   329,
     330,   331,   332,   333,   334,   335,    -1,   337,   338,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,   362,   363,   364,   365,   366,   367,   368,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,   388,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,   404,   405,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,    -1,   428,   429,
      -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,
      -1,    -1,   442,   443,   444,   445,    -1,   447,   448,   449,
      -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,
      -1,    -1,   462,    -1,    -1,   465,   466,   467,   468,   469,
     470,    -1,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,   482,   483,   484,    -1,   486,   487,    -1,   489,
     490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,
     500,    -1,   502,   503,   504,   505,   506,   507,   508,    -1,
     510,   511,   512,   513,    -1,   515,    -1,    -1,   518,   519,
     520,    -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,
      -1,   531,   532,   533,   534,   535,   536,    -1,    -1,   539,
     540,    -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,
      -1,   551,   552,    -1,   554,    -1,   556,    -1,    -1,    -1,
      -1,   561,    -1,    -1,    -1,   565,   566,    -1,    -1,    -1,
      -1,   571,    -1,   573,    -1,    -1,   576,   577,    -1,   579,
     580,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    -1,    28,    29,    30,    -1,    32,    33,
      34,    35,    36,    37,    38,    -1,    40,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    51,    52,    -1,
      54,    55,    56,    57,    -1,    59,    60,    61,    62,    63,
      -1,    65,    66,    -1,    68,    69,    70,    71,    72,    73,
      74,    75,    -1,    77,    78,    -1,    80,    81,    -1,    83,
      84,    85,    86,    -1,    -1,    89,    90,    91,    -1,    93,
      94,    -1,    96,    97,    98,    99,   100,    -1,    -1,    -1,
      -1,   105,   106,   107,    -1,    -1,   110,   111,   112,    -1,
     114,    -1,    -1,    -1,   118,   119,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,   136,   137,    -1,   139,   140,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,   152,    -1,
     154,   155,   156,   157,   158,   159,   160,    -1,   162,   163,
     164,   165,   166,    -1,   168,    -1,    -1,   171,    -1,   173,
     174,   175,   176,   177,    -1,   179,   180,   181,   182,   183,
      -1,   185,   186,   187,   188,   189,   190,   191,    -1,   193,
     194,    -1,   196,   197,    -1,   199,   200,    -1,   202,   203,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,   213,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,   223,
     224,   225,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,   243,
      -1,    -1,   246,   247,    -1,   249,   250,    -1,    -1,    -1,
     254,    -1,   256,    -1,   258,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,   267,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,   308,   309,   310,    -1,   312,   313,
     314,   315,   316,   317,   318,   319,   320,   321,   322,   323,
      -1,   325,   326,   327,    -1,   329,   330,   331,   332,   333,
     334,   335,    -1,   337,   338,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,   368,    -1,   370,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,   388,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,   403,
     404,   405,   406,    -1,   408,   409,   410,    -1,   412,   413,
      -1,    -1,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,    -1,   428,   429,    -1,    -1,    -1,   433,
     434,   435,    -1,    -1,   438,    -1,    -1,    -1,   442,   443,
     444,   445,    -1,   447,   448,   449,    -1,    -1,    -1,    -1,
      -1,    -1,   456,   457,    -1,   459,    -1,    -1,   462,    -1,
      -1,   465,   466,   467,   468,   469,   470,    -1,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,   482,   483,
     484,    -1,   486,   487,    -1,   489,   490,   491,   492,   493,
     494,    -1,    -1,    -1,    -1,    -1,   500,    -1,   502,   503,
     504,   505,   506,   507,   508,    -1,   510,   511,   512,   513,
      -1,   515,    -1,    -1,   518,   519,   520,    -1,    -1,   523,
      -1,   525,    -1,   527,   528,    -1,    -1,   531,   532,   533,
     534,   535,   536,    -1,    -1,   539,   540,    -1,   542,   543,
     544,    -1,    -1,    -1,    -1,   549,    -1,   551,   552,    -1,
     554,    -1,   556,    -1,    -1,    -1,    -1,   561,    -1,    -1,
      -1,   565,   566,    -1,    -1,    -1,    -1,   571,    -1,   573,
      -1,    -1,   576,   577,    -1,   579,   580,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    22,    23,    24,    25,    26,    -1,
      28,    29,    30,    -1,    32,    33,    34,    35,    36,    37,
      38,    -1,    40,    41,    42,    -1,    44,    -1,    46,    47,
      -1,    -1,    50,    51,    52,    -1,    54,    55,    56,    57,
      -1,    59,    60,    61,    62,    63,    -1,    65,    66,    -1,
      68,    69,    70,    71,    72,    73,    74,    75,    -1,    77,
      78,    -1,    80,    81,    -1,    83,    84,    85,    86,    -1,
      -1,    89,    90,    91,    -1,    93,    94,    -1,    96,    97,
      98,    99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,
      -1,    -1,   110,   111,   112,    -1,   114,    -1,    -1,    -1,
     118,   119,   120,    -1,   122,   123,   124,    -1,    -1,    -1,
     128,    -1,    -1,   131,   132,   133,    -1,    -1,   136,   137,
      -1,   139,   140,   141,   142,   143,   144,    -1,    -1,   147,
      -1,   149,   150,   151,   152,    -1,   154,   155,   156,   157,
     158,   159,   160,    -1,   162,   163,   164,   165,   166,    -1,
     168,    -1,    -1,   171,    -1,   173,   174,    -1,   176,   177,
      -1,   179,   180,   181,   182,   183,    -1,   185,   186,   187,
     188,   189,   190,   191,    -1,   193,   194,    -1,   196,   197,
      -1,   199,   200,    -1,   202,   203,    -1,   205,    -1,    -1,
      -1,   209,   210,   211,   212,   213,    -1,   215,   216,    -1,
      -1,    -1,   220,    -1,    -1,   223,   224,   225,    -1,    -1,
     228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,
      -1,    -1,    -1,   241,   242,   243,    -1,    -1,   246,   247,
      -1,   249,   250,    -1,    -1,    -1,   254,    -1,   256,    -1,
     258,   259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,
      -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,    -1,    -1,
      -1,   299,   300,   301,   302,   303,    -1,    -1,   306,   307,
     308,   309,   310,    -1,   312,   313,   314,   315,   316,   317,
     318,   319,   320,   321,   322,   323,    -1,   325,   326,   327,
      -1,   329,   330,   331,   332,   333,   334,   335,    -1,   337,
     338,    -1,   340,   341,    -1,   343,    -1,   345,   346,   347,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     358,   359,   360,   361,   362,   363,   364,   365,   366,   367,
     368,    -1,   370,   371,    -1,   373,    -1,   375,   376,   377,
     378,    -1,   380,   381,   382,   383,   384,   385,   386,   387,
     388,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,
     398,    -1,   400,    -1,   402,   403,   404,   405,   406,    -1,
     408,   409,   410,    -1,   412,   413,    -1,    -1,   416,   417,
     418,   419,   420,   421,   422,   423,   424,   425,   426,    -1,
     428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,    -1,
     438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,   447,
     448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,   457,
      -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,   467,
     468,   469,   470,    -1,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,   482,   483,   484,    -1,   486,   487,
      -1,   489,   490,   491,   492,   493,   494,    -1,    -1,    -1,
      -1,    -1,   500,    -1,   502,   503,   504,   505,   506,   507,
     508,    -1,   510,   511,   512,   513,    -1,   515,    -1,    -1,
     518,   519,   520,    -1,    -1,   523,    -1,   525,    -1,   527,
     528,    -1,    -1,   531,   532,   533,   534,   535,   536,    -1,
      -1,   539,   540,    -1,   542,   543,   544,    -1,    -1,    -1,
      -1,   549,    -1,   551,   552,    -1,   554,    -1,   556,    -1,
      -1,    -1,    -1,   561,    -1,    -1,    -1,   565,   566,    -1,
      -1,    -1,    -1,   571,    -1,   573,    -1,    -1,   576,   577,
      -1,   579,   580,     5,    -1,     7,     8,     9,    10,    11,
      12,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    -1,    28,    29,    30,    -1,
      32,    33,    34,    35,    36,    37,    38,    -1,    40,    41,
      42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,    51,
      52,    -1,    54,    55,    56,    57,    -1,    59,    60,    61,
      62,    63,    -1,    65,    66,    -1,    68,    69,    70,    71,
      72,    73,    74,    75,    -1,    77,    78,    -1,    80,    81,
      -1,    83,    84,    85,    86,    -1,    -1,    89,    90,    91,
      -1,    93,    94,    -1,    96,    97,    98,    99,   100,    -1,
      -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,   111,
     112,    -1,   114,    -1,    -1,    -1,   118,   119,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,   136,   137,    -1,   139,   140,   141,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
     152,    -1,   154,   155,   156,   157,   158,   159,   160,    -1,
     162,   163,   164,   165,   166,    -1,   168,    -1,    -1,   171,
      -1,   173,   174,    -1,   176,   177,    -1,   179,   180,   181,
     182,   183,    -1,   185,   186,   187,   188,   189,   190,   191,
      -1,   193,   194,    -1,   196,   197,    -1,   199,   200,    -1,
     202,   203,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,
      -1,   223,   224,   225,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,
     242,   243,    -1,    -1,   246,   247,    -1,   249,   250,    -1,
      -1,    -1,   254,    -1,   256,    -1,   258,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,   267,    -1,    -1,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,   308,   309,   310,    -1,
     312,   313,   314,   315,   316,   317,   318,   319,   320,   321,
     322,   323,    -1,   325,   326,   327,    -1,   329,   330,   331,
     332,    -1,   334,   335,    -1,   337,   338,    -1,   340,   341,
      -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
     362,   363,   364,   365,   366,   367,   368,    -1,   370,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,   388,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
     402,   403,   404,   405,   406,    -1,   408,   409,   410,    -1,
     412,   413,    -1,    -1,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,    -1,   428,   429,    -1,    -1,
      -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,    -1,
     442,   443,   444,   445,    -1,   447,   448,   449,    -1,    -1,
      -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,    -1,
     462,    -1,    -1,   465,   466,   467,   468,   469,   470,    -1,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
     482,   483,   484,    -1,   486,   487,    -1,   489,   490,   491,
     492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,    -1,
     502,   503,   504,   505,   506,   507,   508,    -1,   510,   511,
     512,   513,    -1,   515,    -1,    -1,   518,   519,   520,    -1,
      -1,   523,    -1,   525,    -1,   527,   528,    -1,    -1,   531,
     532,   533,   534,   535,   536,    -1,    -1,   539,   540,    -1,
     542,   543,   544,    -1,    -1,    -1,    -1,   549,    -1,   551,
     552,    -1,   554,    -1,   556,    -1,    -1,    -1,    -1,   561,
      -1,    -1,    -1,   565,   566,    -1,    -1,    -1,    -1,   571,
      -1,   573,    -1,    -1,   576,   577,    -1,   579,   580,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,    25,
      26,    -1,    28,    29,    30,    -1,    32,    33,    34,    35,
      36,    37,    38,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    51,    52,    -1,    54,    55,
      56,    57,    -1,    59,    60,    61,    62,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    73,    74,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    83,    84,    85,
      86,    -1,    -1,    89,    90,    91,    -1,    93,    94,    -1,
      96,    97,    98,    99,   100,    -1,    -1,    -1,    -1,   105,
     106,   107,    -1,    -1,   110,   111,   112,    -1,   114,    -1,
      -1,    -1,   118,   119,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
     136,   137,    -1,   139,   140,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,   152,    -1,   154,   155,
     156,   157,   158,   159,   160,    -1,   162,   163,   164,   165,
     166,    -1,   168,    -1,    -1,   171,    -1,   173,   174,    -1,
     176,   177,    -1,   179,   180,   181,   182,   183,    -1,   185,
     186,   187,   188,   189,   190,   191,    -1,   193,   194,    -1,
     196,   197,    -1,   199,   200,    -1,   202,   203,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,   223,   224,   225,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,   242,   243,    -1,    -1,
     246,   247,    -1,   249,   250,    -1,    -1,    -1,   254,    -1,
     256,    -1,   258,   259,    -1,   261,    -1,   263,   264,    -1,
      -1,   267,    -1,    -1,    -1,    -1,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,   308,   309,   310,    -1,   312,   313,   314,   315,
     316,   317,   318,   319,   320,   321,   322,   323,    -1,   325,
     326,   327,    -1,   329,   330,   331,   332,   333,   334,   335,
      -1,   337,   338,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,   362,   363,   364,   365,
     366,   367,   368,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,   388,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,   404,   405,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,    -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,
      -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,
      -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,
     456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,
     466,   467,   468,   469,   470,    -1,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,   482,   483,   484,    -1,
     486,   487,    -1,   489,   490,   491,   492,   493,   494,    -1,
      -1,    -1,    -1,    -1,   500,    -1,   502,   503,   504,   505,
     506,   507,   508,    -1,   510,   511,   512,   513,    -1,   515,
      -1,    -1,   518,   519,   520,    -1,    -1,   523,    -1,   525,
      -1,   527,   528,    -1,    -1,   531,   532,   533,   534,   535,
     536,    -1,    -1,   539,   540,    -1,   542,   543,   544,    -1,
      -1,    -1,    -1,   549,    -1,   551,   552,    -1,   554,    -1,
     556,    -1,    -1,    -1,    -1,   561,    -1,    -1,    -1,   565,
     566,    -1,    -1,    -1,    -1,   571,    -1,   573,    -1,    -1,
     576,   577,    -1,   579,   580,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,    -1,    28,    29,
      30,    -1,    32,    33,    34,    35,    36,    37,    38,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    51,    52,    -1,    54,    55,    56,    57,    -1,    59,
      60,    61,    62,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    73,    74,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    83,    84,    85,    86,    -1,    -1,    89,
      90,    91,    -1,    93,    94,    -1,    96,    97,    98,    99,
     100,    -1,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,
     110,   111,   112,    -1,   114,    -1,    -1,    -1,   118,   119,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,   136,   137,    -1,   139,
     140,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,   152,    -1,   154,   155,   156,   157,   158,   159,
     160,    -1,   162,   163,   164,   165,   166,    -1,   168,    -1,
      -1,   171,    -1,   173,   174,    -1,   176,   177,    -1,   179,
     180,   181,   182,   183,    -1,   185,   186,   187,   188,   189,
     190,   191,    -1,   193,   194,    -1,   196,   197,    -1,   199,
     200,    -1,   202,   203,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,   223,   224,   225,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,   242,   243,    -1,    -1,   246,   247,    -1,   249,
     250,    -1,    -1,    -1,   254,    -1,   256,    -1,   258,   259,
      -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,    -1,
      -1,    -1,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,   308,   309,
     310,    -1,   312,   313,   314,   315,   316,   317,   318,   319,
     320,   321,   322,   323,    -1,   325,   326,   327,    -1,   329,
     330,   331,   332,   333,   334,   335,    -1,   337,   338,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,   362,   363,   364,   365,   366,   367,   368,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,   388,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,   404,   405,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,    -1,   428,   429,
      -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,
      -1,    -1,   442,   443,   444,   445,    -1,   447,   448,   449,
      -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,
      -1,    -1,   462,    -1,    -1,   465,   466,   467,   468,   469,
     470,    -1,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,   482,   483,   484,    -1,   486,   487,    -1,   489,
     490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,
     500,    -1,   502,   503,   504,   505,   506,   507,   508,    -1,
     510,   511,   512,   513,    -1,   515,    -1,    -1,   518,   519,
     520,    -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,
      -1,   531,   532,   533,   534,   535,   536,    -1,    -1,   539,
     540,    -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,
      -1,   551,   552,    -1,   554,    -1,   556,    -1,    -1,    -1,
      -1,   561,    -1,    -1,    -1,   565,   566,    -1,    -1,    -1,
      -1,   571,    -1,   573,    -1,    -1,   576,   577,    -1,   579,
     580,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    -1,    28,    29,    30,    -1,    32,    33,
      34,    35,    36,    37,    38,    -1,    40,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    51,    52,    -1,
      54,    55,    56,    57,    -1,    59,    60,    61,    62,    63,
      -1,    65,    66,    -1,    68,    69,    70,    71,    72,    73,
      74,    75,    -1,    77,    78,    -1,    80,    81,    -1,    83,
      84,    85,    86,    -1,    -1,    89,    90,    91,    -1,    93,
      94,    -1,    96,    97,    98,    99,   100,    -1,    -1,    -1,
      -1,   105,   106,   107,    -1,    -1,   110,   111,   112,    -1,
     114,    -1,    -1,    -1,   118,   119,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,   136,   137,    -1,   139,   140,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,   152,    -1,
     154,   155,   156,   157,   158,   159,   160,    -1,   162,   163,
     164,   165,   166,    -1,   168,    -1,    -1,   171,    -1,   173,
     174,    -1,   176,   177,    -1,   179,   180,   181,   182,   183,
      -1,   185,   186,   187,   188,   189,   190,   191,    -1,   193,
     194,    -1,   196,   197,    -1,   199,   200,    -1,   202,   203,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,   213,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,   223,
     224,   225,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,   243,
      -1,    -1,   246,   247,    -1,   249,   250,    -1,    -1,    -1,
     254,    -1,   256,    -1,   258,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,   267,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,   308,   309,   310,    -1,   312,   313,
     314,   315,   316,   317,   318,   319,   320,   321,   322,   323,
      -1,   325,   326,   327,    -1,   329,   330,   331,   332,   333,
     334,   335,    -1,   337,   338,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,   368,    -1,   370,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,   388,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,   403,
     404,   405,   406,    -1,   408,   409,   410,    -1,   412,   413,
      -1,    -1,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,    -1,   428,   429,    -1,    -1,    -1,   433,
     434,   435,    -1,    -1,   438,    -1,    -1,    -1,   442,   443,
     444,   445,    -1,   447,   448,   449,    -1,    -1,    -1,    -1,
      -1,    -1,   456,   457,    -1,   459,    -1,    -1,   462,    -1,
      -1,   465,   466,   467,   468,   469,   470,    -1,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,   482,   483,
     484,    -1,   486,   487,    -1,   489,   490,   491,   492,   493,
     494,    -1,    -1,    -1,    -1,    -1,   500,    -1,   502,   503,
     504,   505,   506,   507,   508,    -1,   510,   511,   512,   513,
      -1,   515,    -1,    -1,   518,   519,   520,    -1,    -1,   523,
      -1,   525,    -1,   527,   528,    -1,    -1,   531,   532,   533,
     534,   535,   536,    -1,    -1,   539,   540,    -1,   542,   543,
     544,    -1,    -1,    -1,    -1,   549,    -1,   551,   552,    -1,
     554,    -1,   556,    -1,    -1,    -1,    -1,   561,    -1,    -1,
      -1,   565,   566,    -1,    -1,    -1,    -1,   571,    -1,   573,
      -1,    -1,   576,   577,    -1,   579,   580,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    22,    23,    24,    25,    26,    -1,
      28,    29,    30,    -1,    32,    33,    34,    35,    36,    37,
      38,    -1,    40,    41,    42,    -1,    44,    -1,    46,    47,
      -1,    -1,    50,    51,    52,    -1,    54,    55,    56,    57,
      -1,    59,    60,    61,    62,    63,    -1,    65,    66,    -1,
      68,    69,    70,    71,    72,    73,    74,    75,    -1,    77,
      78,    -1,    80,    81,    -1,    83,    84,    85,    86,    -1,
      -1,    89,    90,    91,    -1,    93,    94,    -1,    96,    97,
      98,    99,   100,    -1,    -1,    -1,    -1,   105,   106,   107,
      -1,    -1,   110,   111,   112,    -1,   114,    -1,    -1,    -1,
     118,   119,   120,    -1,   122,   123,   124,    -1,    -1,    -1,
     128,    -1,    -1,   131,   132,   133,    -1,    -1,   136,   137,
      -1,   139,   140,   141,   142,   143,   144,    -1,    -1,   147,
      -1,   149,   150,   151,   152,    -1,   154,   155,   156,   157,
     158,   159,   160,    -1,   162,   163,   164,   165,   166,    -1,
     168,    -1,    -1,   171,    -1,   173,   174,    -1,   176,   177,
      -1,   179,   180,   181,   182,   183,    -1,   185,   186,   187,
     188,   189,   190,   191,    -1,   193,   194,    -1,   196,   197,
      -1,   199,   200,    -1,   202,   203,    -1,   205,    -1,    -1,
      -1,   209,   210,   211,   212,   213,    -1,   215,   216,    -1,
      -1,    -1,   220,    -1,    -1,   223,   224,   225,    -1,    -1,
     228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,
      -1,    -1,    -1,   241,   242,   243,    -1,    -1,   246,   247,
      -1,   249,   250,    -1,    -1,    -1,   254,    -1,   256,    -1,
     258,   259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,
      -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,    -1,    -1,
      -1,   299,   300,   301,   302,   303,    -1,    -1,   306,   307,
     308,   309,   310,    -1,   312,   313,   314,   315,   316,   317,
     318,   319,   320,   321,   322,   323,    -1,   325,   326,   327,
      -1,   329,   330,   331,   332,    -1,   334,   335,    -1,   337,
     338,    -1,   340,   341,    -1,   343,    -1,   345,   346,   347,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     358,   359,   360,   361,   362,   363,   364,   365,   366,   367,
     368,    -1,   370,   371,    -1,   373,    -1,   375,   376,   377,
     378,    -1,   380,   381,   382,   383,   384,   385,   386,   387,
     388,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,
     398,    -1,   400,    -1,   402,   403,   404,   405,   406,    -1,
     408,   409,   410,    -1,   412,   413,    -1,    -1,   416,   417,
     418,   419,   420,   421,   422,   423,   424,   425,   426,    -1,
     428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,    -1,
     438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,   447,
     448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,   457,
      -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,   467,
     468,   469,   470,    -1,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,   482,   483,   484,    -1,   486,   487,
      -1,   489,   490,   491,   492,   493,   494,    -1,    -1,    -1,
      -1,    -1,   500,    -1,   502,   503,   504,   505,   506,   507,
     508,    -1,   510,   511,   512,   513,    -1,   515,    -1,    -1,
     518,   519,   520,    -1,    -1,   523,    -1,   525,    -1,   527,
     528,    -1,    -1,   531,   532,   533,   534,   535,   536,    -1,
      -1,   539,   540,    -1,   542,   543,   544,    -1,    -1,    -1,
      -1,   549,    -1,   551,   552,    -1,   554,    -1,   556,    -1,
      -1,    -1,    -1,   561,    -1,    -1,    -1,   565,   566,    -1,
      -1,    -1,    -1,   571,    -1,   573,    -1,    -1,   576,   577,
      -1,   579,   580,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      -1,    23,    24,    25,    26,    -1,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,
      52,    -1,    54,    55,    -1,    57,    -1,    59,    60,    61,
      -1,    63,    -1,    65,    66,    -1,    68,    69,    70,    71,
      72,    -1,    -1,    75,    -1,    77,    78,    79,    80,    81,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,
      -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,    -1,
     112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
      -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,    -1,
      -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,    -1,
      -1,   173,   174,    -1,    -1,   177,   178,   179,    -1,    -1,
      -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,
      -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,    -1,
     202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,    -1,    -1,   215,   216,   217,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,    -1,    -1,    -1,   238,    -1,    -1,   241,
      -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,    -1,
     252,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,
      -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
     282,   283,   284,   285,   286,   287,   288,    -1,   290,   291,
     292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,
     312,    -1,   314,    -1,    -1,   317,   318,   319,   320,   321,
     322,   323,    -1,    -1,   326,   327,    -1,   329,   330,   331,
      -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,   341,
      -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
      -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
     402,   403,    -1,    -1,   406,    -1,   408,   409,   410,    -1,
     412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,   421,
      -1,   423,   424,   425,   426,    -1,   428,   429,   430,    -1,
      -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,    -1,
     442,   443,   444,   445,    -1,   447,   448,   449,   450,    -1,
      -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,    -1,
     462,    -1,    -1,   465,   466,    -1,    -1,   469,   470,    -1,
     472,   473,   474,    -1,    -1,    -1,   478,   479,   480,   481,
      -1,   483,   484,    -1,   486,   487,    -1,    -1,   490,   491,
     492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,    -1,
     502,    -1,    -1,   505,   506,   507,   508,    -1,    -1,   511,
     512,    -1,    -1,   515,    -1,    -1,    -1,    -1,   520,    -1,
      -1,   523,    -1,   525,    -1,   527,   528,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   536,    -1,    -1,   539,    -1,    -1,
     542,   543,   544,    -1,    -1,    -1,    -1,   549,    -1,   551,
     552,    -1,    -1,    -1,   556,    -1,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,   580,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,
      59,    60,    61,    -1,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    -1,    -1,    75,    -1,    77,    78,
      79,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,
      -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,
      -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,
      -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
      -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,
     159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,
      -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,   178,
     179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,
      -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,
     199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,    -1,    -1,   215,   216,   217,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,   238,
      -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,
      -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,
      -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,   282,   283,   284,   285,   286,   287,   288,
      -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,    -1,
      -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,
     319,   320,   321,   322,   323,    -1,    -1,   326,   327,    -1,
     329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,    -1,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,
      -1,   420,   421,    -1,   423,   424,   425,   426,    -1,   428,
     429,    -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,
      -1,    -1,    -1,   442,   443,   444,   445,    -1,   447,   448,
     449,   450,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,
     459,    -1,    -1,   462,    -1,    -1,   465,   466,    -1,    -1,
     469,   470,    -1,   472,   473,   474,    -1,    -1,    -1,   478,
     479,   480,   481,    -1,   483,   484,    -1,   486,   487,    -1,
      -1,   490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,
      -1,   500,    -1,   502,    -1,    -1,   505,   506,   507,   508,
      -1,    -1,   511,   512,    -1,    -1,   515,    -1,    -1,    -1,
      -1,   520,    -1,    -1,   523,    -1,   525,    -1,   527,   528,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,
     539,    -1,    -1,   542,   543,   544,    -1,    -1,    -1,    -1,
     549,    -1,   551,   552,    -1,    -1,    -1,   556,    -1,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,   580,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,   430,    -1,    -1,   433,   434,   435,
      -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,
      -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,
     456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,
     466,    -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,
      -1,    -1,   478,   479,   480,   481,    -1,   483,   484,    -1,
     486,   487,    -1,    -1,   490,   491,   492,   493,   494,    -1,
      -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,
     506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,
      -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,
      -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,
      -1,    -1,    -1,   549,    -1,   551,   552,    -1,    -1,    -1,
     556,    -1,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,   574,    -1,
      23,    24,    25,    26,   580,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,
      -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,    52,
      -1,    54,    55,    -1,    57,    -1,    59,    60,    61,    -1,
      63,    -1,    65,    66,    -1,    68,    69,    70,    71,    72,
      -1,    -1,    75,    -1,    77,    78,    -1,    80,    81,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,
      -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,
      -1,    -1,   105,   106,    -1,    -1,    -1,    -1,    -1,   112,
      -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,
     123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,
     133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,
     143,   144,    -1,    -1,   147,    -1,   149,   150,   151,    -1,
      -1,   154,    -1,   156,    -1,    -1,   159,   160,    -1,    -1,
     163,   164,   165,    -1,    -1,   168,    -1,    -1,    -1,    -1,
     173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,
      -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,
     193,    -1,    -1,    -1,    -1,    -1,   199,   200,    -1,   202,
      -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,
      -1,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,
     233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,
     243,    -1,    -1,    -1,   247,    -1,    -1,   250,    -1,    -1,
      -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,
     263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     273,   274,   275,   276,   277,   278,    -1,   280,   281,   282,
     283,   284,   285,   286,   287,   288,    -1,   290,   291,   292,
      -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,   302,
     303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,
      -1,   314,    -1,    -1,   317,   318,   319,   320,   321,   322,
     323,    -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,
      -1,    -1,   335,    -1,    -1,    -1,    -1,   340,   341,    -1,
     343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,
     363,    -1,   365,    -1,   367,    -1,    -1,   370,   371,    -1,
     373,    -1,   375,   376,   377,   378,    -1,   380,   381,   382,
     383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,
     393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,
     403,    -1,    -1,   406,    -1,   408,   409,   410,    -1,   412,
     413,    -1,    -1,    -1,   417,   418,    -1,   420,   421,    -1,
     423,   424,   425,   426,    -1,   428,   429,    -1,    -1,    -1,
     433,   434,   435,    -1,    -1,   438,    -1,    -1,    -1,   442,
     443,   444,   445,    -1,   447,   448,   449,    -1,    -1,    -1,
      -1,    -1,    -1,   456,   457,    -1,   459,    -1,    -1,   462,
      -1,    -1,   465,   466,    -1,    -1,   469,   470,    -1,   472,
     473,   474,    -1,    -1,    -1,   478,   479,   480,   481,    -1,
     483,   484,    -1,   486,   487,    -1,    -1,   490,   491,   492,
     493,   494,    -1,    -1,    -1,    -1,    -1,   500,    -1,   502,
      -1,    -1,   505,   506,   507,   508,    -1,    -1,   511,   512,
      -1,    -1,   515,    -1,    -1,    -1,    -1,   520,    -1,    -1,
     523,    -1,   525,    -1,   527,   528,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   536,    -1,    -1,   539,    -1,    -1,   542,
     543,   544,    -1,    -1,    -1,    -1,   549,    -1,   551,   552,
      -1,    -1,    -1,   556,    -1,    -1,    -1,    -1,    -1,    -1,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,   574,    17,    -1,    -1,    20,   579,   580,    23,    24,
      25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,
      -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,
      55,    -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,
      65,    66,    -1,    68,    69,    70,    71,    72,    -1,    -1,
      75,    -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,
      -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,
     105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,
      -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,
      -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,
      -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,
      -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,
      -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,
     165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,
      -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,
      -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,
      -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,
     205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,
     215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,   226,    -1,   228,    -1,   230,   231,    -1,   233,   234,
      -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,
      -1,    -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,
      -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,   282,   283,   284,
     285,   286,   287,   288,    -1,   290,   291,   292,    -1,   294,
     295,    -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,
      -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,
      -1,    -1,   317,   318,   319,   320,   321,   322,   323,    -1,
      -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,
     335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,
     345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,
     365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,
     375,   376,   377,   378,    -1,   380,   381,   382,   383,   384,
     385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,
      -1,   396,   397,   398,    -1,   400,    -1,   402,   403,    -1,
      -1,   406,    -1,   408,   409,   410,    -1,   412,   413,    -1,
      -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,   424,
     425,   426,    -1,   428,   429,    -1,    -1,    -1,   433,   434,
     435,    -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,
     445,    -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,
      -1,   456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,
     465,   466,    -1,    -1,   469,   470,    -1,   472,   473,   474,
      -1,    -1,    -1,   478,   479,   480,   481,    -1,   483,   484,
      -1,   486,   487,    -1,    -1,   490,   491,   492,   493,   494,
      -1,    -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,
     505,   506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,
     515,    -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,
     525,    -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,
      -1,    -1,    -1,    -1,   549,    -1,   551,   552,    -1,    -1,
      -1,   556,    -1,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      -1,    23,    24,    25,    26,   580,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,
      52,    -1,    54,    55,    -1,    57,    -1,    59,    60,    61,
      -1,    63,    -1,    65,    66,    -1,    68,    69,    70,    71,
      72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,    81,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,
      -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,    -1,
     112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
      -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,    -1,
      -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,    -1,
      -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,
      -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,
      -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,    -1,
     202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,
      -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,    -1,
      -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,
      -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
     282,   283,   284,   285,   286,   287,   288,    -1,   290,   291,
     292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,
     312,    -1,   314,    -1,    -1,   317,   318,   319,   320,   321,
     322,   323,    -1,    -1,   326,   327,    -1,   329,   330,   331,
      -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,   341,
      -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
      -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
     402,   403,    -1,    -1,   406,    -1,   408,   409,   410,    -1,
     412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,   421,
      -1,   423,   424,   425,   426,    -1,   428,   429,    -1,    -1,
      -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,    -1,
     442,   443,   444,   445,    -1,   447,   448,   449,    -1,    -1,
      -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,    -1,
     462,    -1,    -1,   465,   466,    -1,    -1,   469,   470,    -1,
     472,   473,   474,    -1,    -1,    -1,   478,   479,   480,   481,
      -1,   483,   484,    -1,   486,   487,    -1,    -1,   490,   491,
     492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,    -1,
     502,    -1,    -1,   505,   506,   507,   508,    -1,    -1,   511,
     512,    -1,    -1,   515,    -1,    -1,    -1,    -1,   520,    -1,
      -1,   523,    -1,   525,    -1,   527,   528,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   536,    -1,    -1,   539,    -1,    -1,
     542,   543,   544,    -1,    -1,    -1,    -1,   549,    -1,   551,
     552,    -1,    -1,    -1,   556,    -1,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,   567,    -1,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,   580,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    -1,
      -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,
      59,    60,    61,    -1,    63,    -1,    65,    66,    -1,    68,
      69,    70,    71,    72,    -1,    -1,    75,    -1,    77,    78,
      -1,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,
      -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,
      -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,
      -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,
      -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,
      -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,
     149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,
     159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,
      -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,
     179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,
      -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,
     199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,
     209,   210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,
      -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,
      -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,
      -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,
      -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,   282,   283,   284,   285,   286,   287,   288,
      -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,
     299,   300,   301,   302,   303,    -1,    -1,   306,   307,    -1,
      -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,
     319,   320,   321,   322,   323,    -1,    -1,   326,   327,    -1,
     329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,
      -1,   340,   341,    -1,   343,    -1,   345,   346,   347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,
     359,   360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,
      -1,   370,   371,    -1,   373,    -1,   375,   376,   377,   378,
      -1,   380,   381,   382,   383,   384,   385,   386,   387,    -1,
      -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,
      -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,
     409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,
      -1,   420,   421,    -1,   423,   424,   425,   426,    -1,   428,
     429,    -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,
      -1,    -1,    -1,   442,   443,   444,   445,    -1,   447,   448,
     449,    -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,
     459,    -1,    -1,   462,    -1,    -1,   465,   466,    -1,    -1,
     469,   470,    -1,   472,   473,   474,    -1,    -1,    -1,   478,
     479,   480,   481,    -1,   483,   484,    -1,   486,   487,    -1,
      -1,   490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,
      -1,   500,    -1,   502,    -1,    -1,   505,   506,   507,   508,
      -1,    -1,   511,   512,    -1,    -1,   515,    -1,    -1,    -1,
      -1,   520,    -1,    -1,   523,    -1,   525,    -1,   527,   528,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,
     539,    -1,    -1,   542,   543,   544,    -1,    -1,    -1,    -1,
     549,    -1,   551,   552,    -1,    -1,    -1,   556,    -1,    -1,
      -1,    -1,    -1,    -1,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,   573,    -1,    17,    -1,    -1,    20,
      -1,   580,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
      -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,
      -1,   442,   443,   444,   445,    -1,   447,   448,   449,    -1,
      -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,
      -1,   462,    -1,    -1,   465,   466,    -1,    -1,   469,   470,
      -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,   480,
     481,    -1,   483,   484,    -1,   486,   487,    -1,    -1,   490,
     491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,
      -1,   502,    -1,    -1,   505,   506,   507,   508,    -1,    -1,
     511,   512,    -1,    -1,   515,    -1,    -1,    -1,    -1,   520,
      -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,    -1,
      -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,    -1,
     551,   552,    -1,    -1,    -1,   556,    -1,    -1,    -1,    -1,
      -1,    -1,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,   579,   580,
      23,    24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,
      -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,    52,
      -1,    54,    55,    -1,    57,    -1,    59,    60,    61,    -1,
      63,    -1,    65,    66,    -1,    68,    69,    70,    71,    72,
      -1,    -1,    75,    -1,    77,    78,    -1,    80,    81,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,
      -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,
      -1,    -1,   105,   106,    -1,    -1,    -1,    -1,    -1,   112,
      -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,
     123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,
     133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,
     143,   144,    -1,    -1,   147,    -1,   149,   150,   151,    -1,
      -1,   154,    -1,   156,    -1,    -1,   159,   160,    -1,    -1,
     163,   164,   165,    -1,    -1,   168,    -1,    -1,    -1,    -1,
     173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,
      -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,
     193,    -1,    -1,    -1,    -1,    -1,   199,   200,    -1,   202,
      -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,
      -1,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,
     233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,
     243,    -1,    -1,    -1,   247,    -1,    -1,   250,    -1,    -1,
      -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,
     263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     273,   274,   275,   276,   277,   278,    -1,   280,   281,   282,
     283,   284,   285,   286,   287,   288,    -1,   290,   291,   292,
      -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,   302,
     303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,
      -1,   314,    -1,    -1,   317,   318,   319,   320,   321,   322,
     323,    -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,
      -1,    -1,   335,    -1,    -1,    -1,    -1,   340,   341,    -1,
     343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,
     363,    -1,   365,    -1,   367,    -1,    -1,   370,   371,    -1,
     373,    -1,   375,   376,   377,   378,    -1,   380,   381,   382,
     383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,
     393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,
     403,    -1,    -1,   406,    -1,   408,   409,   410,    -1,   412,
     413,    -1,    -1,    -1,   417,   418,    -1,   420,   421,    -1,
     423,   424,   425,   426,    -1,   428,   429,    -1,    -1,    -1,
     433,   434,   435,    -1,    -1,   438,    -1,    -1,    -1,   442,
     443,   444,   445,    -1,   447,   448,   449,    -1,    -1,    -1,
      -1,    -1,    -1,   456,   457,    -1,   459,    -1,    -1,   462,
      -1,    -1,   465,   466,    -1,    -1,   469,   470,    -1,   472,
     473,   474,    -1,    -1,    -1,   478,   479,   480,   481,    -1,
     483,   484,    -1,   486,   487,    -1,    -1,   490,   491,   492,
     493,   494,    -1,    -1,    -1,    -1,    -1,   500,    -1,   502,
      -1,    -1,   505,   506,   507,   508,    -1,    -1,   511,   512,
      -1,    -1,   515,    -1,    -1,    -1,    -1,   520,    -1,    -1,
     523,    -1,   525,    -1,   527,   528,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   536,    -1,    -1,   539,    -1,    -1,   542,
     543,   544,    -1,    -1,    -1,    -1,   549,    -1,   551,   552,
      -1,    -1,    -1,   556,    -1,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,   580,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,
      -1,    -1,   442,   443,   444,   445,    -1,   447,   448,   449,
      -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,
      -1,    -1,   462,    -1,    -1,   465,   466,    -1,    -1,   469,
     470,    -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,
     480,   481,    -1,   483,   484,    -1,   486,   487,    -1,    -1,
     490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,
     500,    -1,   502,    -1,    -1,   505,   506,   507,   508,    -1,
      -1,   511,   512,    -1,    -1,   515,    -1,    -1,    -1,    -1,
     520,    -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,
      -1,    -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,
      -1,   551,   552,    -1,    -1,    -1,   556,    -1,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
     580,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,
      57,    -1,    59,    60,    61,    -1,    63,    -1,    65,    66,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    75,    -1,
      77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,
      97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,
      -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,
      -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,
     137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,
     147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,
      -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,
      -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,
     177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,
     187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,
      -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
      -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,
     247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,
      -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,   284,   285,   286,
     287,   288,    -1,   290,   291,   292,    -1,   294,   295,    -1,
      -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,   306,
     307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,   326,
     327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,
      -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,
     347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   358,   359,   360,   361,    -1,   363,    -1,   365,    -1,
     367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,
     377,   378,    -1,   380,   381,   382,   383,   384,   385,   386,
     387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,
     397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,
      -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,
     417,   418,    -1,   420,   421,    -1,   423,   424,   425,   426,
      -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,
      -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,
     447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,
     457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,
      -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,
      -1,   478,   479,   480,   481,    -1,   483,   484,    -1,   486,
     487,    -1,    -1,   490,   491,   492,   493,   494,    -1,    -1,
      -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,
     507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,    -1,
      -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,
     527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,
      -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,
      -1,    -1,   549,    -1,   551,   552,    -1,    -1,    -1,   556,
      -1,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,
      24,    25,    26,   580,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,
      54,    55,    -1,    57,    -1,    59,    60,    61,    -1,    63,
      -1,    65,    66,    -1,    68,    69,    70,    71,    72,    -1,
      -1,    75,    -1,    77,    78,    -1,    80,    81,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,
      -1,   105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,
     114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,
     154,    -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,
     164,   165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,
     174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,
      -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,
      -1,    -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,
      -1,    -1,    -1,   247,    -1,    -1,   250,    -1,    -1,    -1,
      -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,
     274,   275,   276,   277,   278,    -1,   280,   281,   282,   283,
     284,   285,   286,   287,   288,    -1,   290,   291,   292,    -1,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,
     314,    -1,    -1,   317,   318,   319,   320,   321,   322,   323,
      -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,
      -1,   335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,
      -1,   365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,   403,
      -1,    -1,   406,    -1,   408,   409,   410,    -1,   412,   413,
      -1,    -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,
     424,   425,   426,    -1,   428,   429,    -1,    -1,    -1,   433,
     434,   435,    -1,    -1,   438,    -1,    -1,    -1,   442,   443,
     444,   445,    -1,   447,   448,   449,    -1,    -1,    -1,    -1,
      -1,    -1,   456,   457,    -1,   459,    -1,    -1,   462,    -1,
      -1,   465,   466,    -1,    -1,   469,   470,    -1,   472,   473,
     474,    -1,    -1,    -1,   478,   479,   480,   481,    -1,   483,
     484,    -1,   486,   487,    -1,    -1,   490,   491,   492,   493,
     494,    -1,    -1,    -1,    -1,    -1,   500,    -1,   502,    -1,
      -1,   505,   506,   507,   508,    -1,    -1,   511,   512,    -1,
      -1,   515,    -1,    -1,    -1,    -1,   520,    -1,    -1,   523,
      -1,   525,    -1,   527,   528,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   536,    -1,    -1,   539,    -1,    -1,   542,   543,
     544,    -1,    -1,    -1,    -1,   549,    -1,   551,   552,    -1,
      -1,    -1,   556,    -1,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,   580,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
     251,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
      -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,
      -1,   442,   443,   444,   445,    -1,   447,   448,   449,    -1,
      -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,
      -1,   462,    -1,    -1,   465,   466,    -1,    -1,   469,   470,
      -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,   480,
     481,    -1,   483,   484,    -1,   486,   487,    -1,   489,   490,
     491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,
      -1,   502,    -1,    -1,   505,   506,   507,   508,    -1,    -1,
     511,   512,    -1,    -1,   515,    -1,    -1,    -1,    -1,   520,
      -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,    -1,
      -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,    -1,
     551,   552,    -1,    -1,     5,   556,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,   579,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
     251,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
      -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,
      -1,   442,   443,   444,   445,    -1,   447,   448,   449,    -1,
      -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,
      -1,   462,    -1,    -1,   465,   466,    -1,    -1,   469,   470,
      -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,   480,
     481,    -1,   483,   484,    -1,   486,   487,    -1,   489,   490,
     491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,
      -1,   502,    -1,    -1,   505,   506,   507,   508,    -1,    -1,
     511,   512,    -1,    -1,   515,    -1,    -1,    -1,    -1,   520,
      -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,    -1,
      -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,    -1,
     551,   552,    -1,    -1,     5,   556,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,   579,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,
      -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
     151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
      -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,
      -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,
     251,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,   410,
      -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,
     421,    -1,   423,   424,   425,   426,    -1,   428,   429,    -1,
      -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,
      -1,   442,   443,   444,   445,    -1,   447,   448,   449,    -1,
      -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,
      -1,   462,    -1,    -1,   465,   466,    -1,    -1,   469,   470,
      -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,   480,
     481,    -1,   483,   484,    -1,   486,   487,    -1,   489,   490,
     491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,
      -1,   502,    -1,    -1,   505,   506,   507,   508,    -1,    -1,
     511,   512,    -1,    -1,   515,    -1,    -1,    -1,    -1,   520,
      -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,    -1,
      -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,    -1,
     551,   552,    -1,    -1,     5,   556,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,
      -1,    -1,    23,    24,    25,    -1,    -1,    28,   579,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    -1,    -1,    -1,    -1,    50,
      -1,    52,    -1,    54,    -1,    -1,    -1,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    -1,    69,    -1,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    -1,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
      -1,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
      -1,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,   163,   164,   165,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,   200,
      -1,    -1,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,   235,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   243,    -1,    -1,    -1,   247,   248,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,   269,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,    -1,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,    -1,   403,   404,    -1,   406,    -1,    -1,   409,    -1,
      -1,   412,   413,   414,    -1,    -1,    -1,   418,    -1,   420,
     421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,
      -1,   442,    -1,   444,    -1,    -1,   447,   448,   449,    -1,
      -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,
      -1,   462,    -1,    -1,    -1,   466,    -1,    -1,    -1,   470,
      -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,   480,
     481,    -1,   483,   484,    -1,   486,   487,    -1,    -1,   490,
     491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,
      -1,   502,    -1,    -1,    -1,   506,   507,   508,    -1,    -1,
     511,   512,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   520,
      -1,    -1,   523,    -1,    -1,    -1,   527,   528,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,    -1,
      -1,   542,   543,   544,    -1,    -1,   547,    -1,   549,    -1,
     551,    -1,    -1,    -1,    -1,   556,    -1,    -1,    -1,    -1,
     561,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,   575,    -1,    20,    -1,    -1,    23,
      24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,
      44,    -1,    46,    47,    -1,    -1,    50,    -1,    52,    -1,
      54,    55,    -1,    57,    -1,    59,    60,    61,    -1,    63,
      -1,    65,    66,    -1,    68,    69,    70,    71,    72,    -1,
      -1,    75,    -1,    77,    78,    -1,    80,    81,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    89,    -1,    -1,    -1,    -1,
      -1,    -1,    96,    97,    -1,    -1,   100,    -1,    -1,    -1,
      -1,   105,   106,    -1,    -1,    -1,    -1,    -1,   112,    -1,
     114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,
     124,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
      -1,    -1,    -1,   137,    -1,    -1,    -1,   141,   142,   143,
     144,    -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,
     154,    -1,   156,    -1,    -1,   159,   160,    -1,    -1,   163,
     164,   165,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,
     174,    -1,    -1,   177,    -1,   179,    -1,    -1,    -1,    -1,
      -1,    -1,   186,   187,    -1,    -1,   190,   191,    -1,   193,
      -1,    -1,    -1,    -1,    -1,   199,   200,    -1,   202,    -1,
      -1,   205,    -1,    -1,    -1,   209,   210,   211,   212,    -1,
      -1,   215,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,    -1,   228,    -1,   230,   231,    -1,   233,
     234,    -1,    -1,    -1,    -1,    -1,    -1,   241,    -1,   243,
      -1,    -1,    -1,   247,    -1,    -1,   250,    -1,    -1,    -1,
      -1,    -1,   256,    -1,   258,    -1,    -1,   261,    -1,   263,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,
     274,   275,   276,   277,   278,    -1,   280,   281,   282,   283,
     284,   285,   286,   287,   288,    -1,   290,   291,   292,    -1,
     294,   295,    -1,    -1,    -1,   299,   300,   301,   302,   303,
      -1,    -1,   306,   307,    -1,    -1,   310,    -1,   312,    -1,
     314,    -1,    -1,   317,   318,   319,   320,   321,   322,   323,
      -1,    -1,   326,   327,    -1,   329,   330,   331,    -1,    -1,
      -1,   335,    -1,    -1,    -1,    -1,   340,   341,    -1,   343,
      -1,   345,   346,   347,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   358,   359,   360,   361,    -1,   363,
      -1,   365,    -1,   367,    -1,    -1,   370,   371,    -1,   373,
      -1,   375,   376,   377,   378,    -1,   380,   381,   382,   383,
     384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,   393,
      -1,    -1,   396,   397,   398,    -1,   400,    -1,   402,   403,
      -1,    -1,   406,    -1,   408,   409,   410,    -1,   412,   413,
      -1,    -1,    -1,   417,   418,    -1,   420,   421,    -1,   423,
     424,   425,   426,    -1,   428,   429,    -1,    -1,    -1,   433,
     434,   435,    -1,    -1,   438,    -1,    -1,    -1,   442,   443,
     444,   445,    -1,   447,   448,   449,    -1,    -1,    -1,    -1,
      -1,    -1,   456,   457,    -1,   459,    -1,    -1,   462,    -1,
      -1,   465,   466,    -1,    -1,   469,   470,    -1,   472,   473,
     474,    -1,    -1,    -1,   478,   479,   480,   481,    -1,   483,
     484,    -1,   486,   487,    -1,    -1,   490,   491,   492,   493,
     494,    -1,    -1,    -1,    -1,    -1,   500,    -1,   502,    -1,
      -1,   505,   506,   507,   508,    -1,    -1,   511,   512,    -1,
      -1,   515,    -1,    -1,    -1,    -1,   520,    -1,    -1,   523,
      -1,   525,    -1,   527,   528,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   536,    -1,    -1,   539,    -1,    -1,   542,   543,
     544,    -1,    -1,    -1,    -1,   549,    -1,   551,   552,    -1,
      -1,    -1,   556,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,   567,    -1,    17,    -1,    -1,    20,    -1,
      -1,    23,    24,    25,    26,    -1,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      42,    -1,    44,    -1,    46,    47,    -1,    -1,    50,    -1,
      52,    -1,    54,    55,    -1,    57,    -1,    59,    60,    61,
      -1,    63,    -1,    65,    66,    -1,    68,    69,    70,    71,
      72,    -1,    -1,    75,    -1,    77,    78,    -1,    80,    81,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,    -1,
      -1,    -1,    -1,   105,   106,    -1,    -1,    -1,    -1,    -1,
     112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,
     122,   123,   124,    -1,    -1,    -1,   128,    -1,    -1,   131,
     132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,   141,
     142,   143,   144,    -1,    -1,   147,    -1,   149,   150,   151,
      -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,    -1,
      -1,   163,   164,   165,    -1,    -1,   168,    -1,    -1,    -1,
      -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,    -1,
      -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,   191,
      -1,   193,    -1,    -1,    -1,    -1,    -1,   199,   200,    -1,
     202,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,   211,
     212,    -1,    -1,   215,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,   231,
      -1,   233,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,
      -1,   243,    -1,    -1,    -1,   247,    -1,    -1,   250,    -1,
      -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,   261,
      -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
     282,   283,   284,   285,   286,   287,   288,    -1,   290,   291,
     292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,   301,
     302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,    -1,
     312,    -1,   314,    -1,    -1,   317,   318,   319,   320,   321,
     322,   323,    -1,    -1,   326,   327,    -1,   329,   330,   331,
      -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,   340,   341,
      -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,   361,
      -1,   363,    -1,   365,    -1,   367,    -1,    -1,   370,   371,
      -1,   373,    -1,   375,   376,   377,   378,    -1,   380,   381,
     382,   383,   384,   385,   386,   387,    -1,    -1,    -1,    -1,
     392,   393,    -1,    -1,   396,   397,   398,    -1,   400,    -1,
     402,   403,    -1,    -1,   406,    -1,   408,   409,   410,    -1,
     412,   413,    -1,    -1,    -1,   417,   418,    -1,   420,   421,
      -1,   423,   424,   425,   426,    -1,   428,   429,    -1,    -1,
      -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,    -1,
     442,   443,   444,   445,    -1,   447,   448,   449,    -1,    -1,
      -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,    -1,
     462,    -1,    -1,   465,   466,    -1,    -1,   469,   470,    -1,
     472,   473,   474,    -1,    -1,    -1,   478,   479,   480,   481,
      -1,   483,   484,    -1,   486,   487,    -1,    -1,   490,   491,
     492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,    -1,
     502,    -1,    -1,   505,   506,   507,   508,    -1,    -1,   511,
     512,    -1,    -1,   515,    -1,    -1,    -1,    -1,   520,    -1,
      -1,   523,    -1,   525,    -1,   527,   528,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   536,    -1,    -1,   539,    -1,    -1,
     542,   543,   544,    -1,    -1,    -1,    -1,   549,    -1,   551,
     552,    -1,    -1,    -1,   556,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,   567,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    -1,    -1,
      50,    -1,    52,    -1,    54,    55,    -1,    57,    -1,    59,
      60,    61,    -1,    63,    -1,    65,    66,    -1,    68,    69,
      70,    71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,
      80,    81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,
      -1,    -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,
     100,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    -1,
      -1,    -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,
     120,    -1,   122,   123,   124,    -1,    -1,    -1,   128,    -1,
      -1,   131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,
      -1,   141,   142,   143,   144,    -1,    -1,   147,    -1,   149,
     150,   151,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,
     160,    -1,    -1,   163,   164,   165,    -1,    -1,   168,    -1,
      -1,    -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,
     190,   191,    -1,   193,    -1,    -1,    -1,    -1,    -1,   199,
     200,    -1,   202,    -1,    -1,   205,    -1,    -1,    -1,   209,
     210,   211,   212,    -1,    -1,   215,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,
     230,   231,    -1,   233,   234,    -1,    -1,    -1,    -1,    -1,
      -1,   241,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
     250,    -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,
      -1,   261,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
     290,   291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,
     300,   301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,
     310,    -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,
     320,   321,   322,   323,    -1,    -1,   326,   327,    -1,   329,
     330,   331,    -1,    -1,    -1,   335,    -1,    -1,    -1,    -1,
     340,   341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,
     360,   361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,
     370,   371,    -1,   373,    -1,   375,   376,   377,   378,    -1,
     380,   381,   382,   383,   384,   385,   386,   387,    -1,    -1,
      -1,    -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,
     400,    -1,   402,   403,    -1,    -1,   406,    -1,   408,   409,
     410,    -1,   412,   413,    -1,    -1,    -1,   417,   418,    -1,
     420,   421,    -1,   423,   424,   425,   426,    -1,   428,   429,
      -1,    -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,
      -1,    -1,   442,   443,   444,   445,    -1,   447,   448,   449,
      -1,    -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,
      -1,    -1,   462,    -1,    -1,   465,   466,    -1,    -1,   469,
     470,    -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,
     480,   481,    -1,   483,   484,    -1,   486,   487,    -1,    -1,
     490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,
     500,    -1,   502,    -1,    -1,   505,   506,   507,   508,    -1,
      -1,   511,   512,    -1,    -1,   515,    -1,    -1,    -1,    -1,
     520,    -1,    -1,   523,    -1,   525,    -1,   527,   528,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,
      -1,    -1,   542,   543,   544,    -1,    -1,    -1,    -1,   549,
      -1,   551,   552,    -1,    -1,    -1,   556,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,   567,    -1,    17,
      -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,
      28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,    47,
      -1,    -1,    50,    -1,    52,    -1,    54,    55,    -1,    57,
      -1,    59,    60,    61,    -1,    63,    -1,    65,    66,    -1,
      68,    69,    70,    71,    72,    -1,    -1,    75,    -1,    77,
      78,    -1,    80,    81,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,
      -1,    -1,   100,    -1,    -1,    -1,    -1,   105,   106,    -1,
      -1,    -1,    -1,    -1,   112,    -1,   114,    -1,    -1,    -1,
      -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,    -1,
     128,    -1,    -1,   131,   132,   133,    -1,    -1,    -1,   137,
      -1,    -1,    -1,   141,   142,   143,   144,    -1,    -1,   147,
      -1,   149,   150,   151,    -1,    -1,   154,    -1,   156,    -1,
      -1,   159,   160,    -1,    -1,   163,   164,   165,    -1,    -1,
     168,    -1,    -1,    -1,    -1,   173,   174,    -1,    -1,   177,
      -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,   186,   187,
      -1,    -1,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,
      -1,   199,   200,    -1,   202,    -1,    -1,   205,    -1,    -1,
      -1,   209,   210,   211,   212,    -1,    -1,   215,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,    -1,
     228,    -1,   230,   231,    -1,   233,   234,    -1,    -1,    -1,
      -1,    -1,    -1,   241,    -1,   243,    -1,    -1,    -1,   247,
      -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,   256,    -1,
     258,    -1,    -1,   261,    -1,   263,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   273,   274,   275,   276,   277,
     278,    -1,   280,   281,   282,   283,   284,   285,   286,   287,
     288,    -1,   290,   291,   292,    -1,   294,   295,    -1,    -1,
      -1,   299,   300,   301,   302,   303,    -1,    -1,   306,   307,
      -1,    -1,   310,    -1,   312,    -1,   314,    -1,    -1,   317,
     318,   319,   320,   321,   322,   323,    -1,    -1,   326,   327,
      -1,   329,   330,   331,    -1,    -1,    -1,   335,    -1,    -1,
      -1,    -1,   340,   341,    -1,   343,    -1,   345,   346,   347,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     358,   359,   360,   361,    -1,   363,    -1,   365,    -1,   367,
      -1,    -1,   370,   371,    -1,   373,    -1,   375,   376,   377,
     378,    -1,   380,   381,   382,   383,   384,   385,   386,   387,
      -1,    -1,    -1,    -1,   392,   393,    -1,    -1,   396,   397,
     398,    -1,   400,    -1,   402,   403,    -1,    -1,   406,    -1,
     408,   409,   410,    -1,   412,   413,    -1,    -1,    -1,   417,
     418,    -1,   420,   421,    -1,   423,   424,   425,   426,    -1,
     428,   429,    -1,    -1,    -1,   433,   434,   435,    -1,    -1,
     438,    -1,    -1,    -1,   442,   443,   444,   445,    -1,   447,
     448,   449,    -1,    -1,    -1,    -1,    -1,    -1,   456,   457,
      -1,   459,    -1,    -1,   462,    -1,    -1,   465,   466,    -1,
      -1,   469,   470,    -1,   472,   473,   474,    -1,    -1,    -1,
     478,   479,   480,   481,    -1,   483,   484,    -1,   486,   487,
      -1,    -1,   490,   491,   492,   493,   494,    -1,    -1,    -1,
      -1,    -1,   500,    -1,   502,    -1,    -1,   505,   506,   507,
     508,    -1,    -1,   511,   512,    -1,    -1,   515,    -1,    -1,
      -1,    -1,   520,    -1,    -1,   523,    -1,   525,    -1,   527,
     528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   536,    -1,
      -1,   539,    -1,    -1,   542,   543,   544,    -1,    -1,    -1,
      -1,   549,    -1,   551,   552,    -1,    -1,    -1,   556,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,   567,
      -1,    17,    -1,    -1,    -1,    -1,    -1,    23,    24,    25,
      -1,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      -1,    -1,    -1,    -1,    50,    -1,    52,    -1,    54,    -1,
      -1,    -1,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    -1,    69,    -1,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    -1,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
      -1,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,    -1,    -1,    -1,   131,   132,   133,    -1,   135,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,    -1,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,   161,    -1,   163,   164,   165,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,   235,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,    -1,
      -1,   247,   248,    -1,   250,    -1,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,    -1,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,    -1,   403,   404,    -1,
     406,    -1,    -1,   409,    -1,    -1,   412,   413,   414,    -1,
      -1,    -1,   418,    -1,   420,   421,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,    -1,   433,   434,   435,
      -1,    -1,   438,    -1,    -1,    -1,   442,    -1,   444,    -1,
      -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,
     456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,    -1,
     466,    -1,    -1,    -1,   470,    -1,   472,   473,   474,    -1,
      -1,    -1,   478,   479,   480,   481,    -1,   483,   484,    -1,
     486,   487,    -1,    -1,   490,   491,   492,   493,   494,    -1,
      -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,    -1,
     506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,    -1,
      -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,
      -1,   547,    -1,   549,    -1,   551,    -1,    -1,    -1,    -1,
     556,    -1,    -1,   559,     5,   561,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,
      -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    -1,    -1,    -1,    -1,    50,
      -1,    52,    -1,    54,    -1,    -1,    -1,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    -1,    69,    -1,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    -1,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
      -1,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,   163,   164,   165,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,   200,
      -1,    -1,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,   235,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   243,    -1,    -1,    -1,   247,   248,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,   269,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,    -1,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,    -1,   403,   404,    -1,   406,    -1,    -1,   409,    -1,
      -1,   412,   413,   414,    -1,    -1,    -1,   418,    -1,   420,
     421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,
      -1,   442,    -1,   444,    -1,    -1,   447,   448,   449,    -1,
      -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,
      -1,   462,    -1,    -1,    -1,   466,    -1,    -1,    -1,   470,
      -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,   480,
     481,    -1,   483,   484,    -1,   486,   487,    -1,    -1,   490,
     491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,
      -1,   502,    -1,    -1,    -1,   506,   507,   508,    -1,    -1,
     511,   512,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   520,
      -1,    -1,   523,    -1,    -1,    -1,   527,   528,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,    -1,
      -1,   542,   543,   544,   545,    -1,   547,    -1,   549,    -1,
     551,    -1,    -1,    -1,    -1,   556,    -1,    -1,   559,     5,
     561,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    -1,    -1,    -1,    23,    24,    25,
      -1,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      -1,    -1,    -1,    -1,    50,    -1,    52,    -1,    54,    -1,
      -1,    -1,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    -1,    69,    -1,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    -1,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
      -1,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,    -1,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,    -1,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,   161,    -1,   163,   164,   165,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,   235,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,    -1,
      -1,   247,   248,    -1,   250,    -1,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,    -1,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,    -1,   403,   404,    -1,
     406,    -1,    -1,   409,    -1,    -1,   412,   413,   414,    -1,
      -1,    -1,   418,    -1,   420,   421,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,    -1,   433,   434,   435,
      -1,    -1,   438,    -1,    -1,    -1,   442,    -1,   444,    -1,
      -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,
     456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,    -1,
     466,    -1,    -1,    -1,   470,    -1,   472,   473,   474,    -1,
      -1,    -1,   478,   479,   480,   481,    -1,   483,   484,    -1,
     486,   487,    -1,    -1,   490,   491,   492,   493,   494,    -1,
      -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,    -1,
     506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,    -1,
      -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,   545,
      -1,   547,    -1,   549,    -1,   551,    -1,    -1,    -1,    -1,
     556,    -1,    -1,   559,     5,   561,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,
      -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    -1,    -1,    -1,    -1,    50,
      -1,    52,    -1,    54,    -1,    -1,    -1,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    -1,    69,    -1,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    -1,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
      -1,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,   163,   164,   165,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,   200,
      -1,    -1,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,   235,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   243,    -1,    -1,    -1,   247,   248,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,   269,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,    -1,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,    -1,   403,   404,    -1,   406,    -1,    -1,   409,    -1,
      -1,   412,   413,   414,    -1,    -1,    -1,   418,    -1,   420,
     421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,
      -1,   442,    -1,   444,    -1,    -1,   447,   448,   449,    -1,
      -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,
      -1,   462,    -1,    -1,    -1,   466,    -1,    -1,    -1,   470,
      -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,   480,
     481,    -1,   483,   484,    -1,   486,   487,    -1,    -1,   490,
     491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,
      -1,   502,    -1,    -1,    -1,   506,   507,   508,    -1,    -1,
     511,   512,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   520,
      -1,    -1,   523,    -1,    -1,    -1,   527,   528,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,    -1,
      -1,   542,   543,   544,    -1,    -1,   547,    -1,   549,    -1,
     551,    -1,    -1,    -1,    -1,   556,    -1,    -1,    -1,     5,
     561,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    -1,    -1,    -1,    23,    24,    25,
      -1,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      -1,    -1,    -1,    -1,    50,    -1,    52,    -1,    54,    -1,
      -1,    -1,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    -1,    69,    -1,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    -1,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
      -1,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,    -1,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,    -1,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,   161,    -1,   163,   164,   165,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,   235,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,    -1,
      -1,   247,   248,    -1,   250,    -1,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,    -1,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,    -1,   403,   404,    -1,
     406,    -1,    -1,   409,    -1,    -1,   412,   413,   414,    -1,
      -1,    -1,   418,    -1,   420,   421,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,    -1,   433,   434,   435,
      -1,    -1,   438,    -1,    -1,    -1,   442,    -1,   444,    -1,
      -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,
     456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,    -1,
     466,    -1,    -1,    -1,   470,    -1,   472,   473,   474,    -1,
      -1,    -1,   478,   479,   480,   481,    -1,   483,   484,    -1,
     486,   487,    -1,    -1,   490,   491,   492,   493,   494,    -1,
      -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,    -1,
     506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,    -1,
      -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,
      -1,   547,    -1,   549,    -1,   551,    -1,    -1,    -1,    -1,
     556,    -1,    -1,    -1,     5,   561,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,
      -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    -1,    -1,    -1,    -1,    50,
      -1,    52,    -1,    54,    -1,    -1,    -1,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    -1,    69,    -1,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    -1,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
      -1,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,   163,   164,   165,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,   200,
      -1,    -1,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,   235,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   243,    -1,    -1,    -1,   247,   248,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,   269,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,    -1,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,    -1,   403,   404,    -1,   406,    -1,    -1,   409,    -1,
      -1,   412,   413,   414,    -1,    -1,    -1,   418,    -1,   420,
     421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,
      -1,   442,    -1,   444,    -1,    -1,   447,   448,   449,    -1,
      -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,
      -1,   462,    -1,    -1,    -1,   466,    -1,    -1,    -1,   470,
      -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,   480,
     481,    -1,   483,   484,    -1,   486,   487,    -1,    -1,   490,
     491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,
      -1,   502,    -1,    -1,    -1,   506,   507,   508,    -1,    -1,
     511,   512,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   520,
      -1,    -1,   523,    -1,    -1,    -1,   527,   528,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,    -1,
      -1,   542,   543,   544,    -1,    -1,   547,    -1,   549,    -1,
     551,    -1,    -1,    -1,    -1,   556,    -1,    -1,    -1,     5,
     561,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    -1,    -1,    -1,    23,    24,    25,
      -1,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      -1,    -1,    -1,    -1,    50,    -1,    52,    -1,    54,    -1,
      -1,    -1,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    -1,    69,    -1,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    -1,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
      -1,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,    -1,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,    -1,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,   161,    -1,   163,   164,   165,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,   235,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,    -1,
      -1,   247,   248,    -1,   250,    -1,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,    -1,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,    -1,   403,   404,    -1,
     406,    -1,    -1,   409,    -1,    -1,   412,   413,   414,    -1,
      -1,    -1,   418,    -1,   420,   421,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,    -1,   433,   434,   435,
      -1,    -1,   438,    -1,    -1,    -1,   442,    -1,   444,    -1,
      -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,
     456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,    -1,
     466,    -1,    -1,    -1,   470,    -1,   472,   473,   474,    -1,
      -1,    -1,   478,   479,   480,   481,    -1,   483,   484,    -1,
     486,   487,    -1,    -1,   490,   491,   492,   493,   494,    -1,
      -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,    -1,
     506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,    -1,
      -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,
      -1,   547,    -1,   549,    -1,   551,    -1,    -1,    -1,    -1,
     556,    -1,    -1,    -1,     5,   561,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,
      -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    -1,    -1,    -1,    -1,    50,
      -1,    52,    -1,    54,    -1,    -1,    -1,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    -1,    69,    -1,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    -1,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
     141,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
      -1,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,   163,   164,   165,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,   200,
      -1,    -1,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,   235,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   243,    -1,    -1,    -1,   247,   248,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,   269,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,    -1,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,    -1,   403,   404,    -1,   406,    -1,    -1,   409,    -1,
      -1,   412,   413,   414,    -1,    -1,    -1,   418,    -1,   420,
     421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,
      -1,   442,    -1,   444,    -1,    -1,   447,   448,   449,    -1,
      -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,
      -1,   462,    -1,    -1,    -1,   466,    -1,    -1,    -1,   470,
      -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,   480,
     481,    -1,   483,   484,    -1,   486,   487,    -1,    -1,   490,
     491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,
      -1,   502,    -1,    -1,    -1,   506,   507,   508,    -1,    -1,
     511,   512,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   520,
      -1,    -1,   523,    -1,    -1,    -1,   527,   528,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,    -1,
      -1,   542,   543,   544,    -1,    -1,   547,    -1,   549,    -1,
     551,    -1,    -1,    -1,    -1,   556,    -1,    -1,    -1,     5,
     561,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    -1,    -1,    -1,    23,    24,    25,
      -1,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      -1,    -1,    -1,    -1,    50,    -1,    52,    -1,    54,    -1,
      -1,    -1,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    -1,    69,    -1,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    -1,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
      -1,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,    -1,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,    -1,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,    -1,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,   161,    -1,   163,   164,   165,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,   213,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,   235,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,    -1,
      -1,   247,   248,    -1,   250,    -1,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,   269,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,    -1,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,    -1,   403,   404,    -1,
     406,    -1,    -1,   409,    -1,    -1,   412,   413,   414,    -1,
      -1,    -1,   418,    -1,   420,   421,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,    -1,   433,   434,   435,
      -1,    -1,   438,    -1,    -1,    -1,   442,    -1,   444,    -1,
      -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,
     456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,    -1,
     466,    -1,    -1,    -1,   470,    -1,   472,   473,   474,    -1,
      -1,    -1,   478,   479,   480,   481,    -1,   483,   484,    -1,
     486,   487,    -1,    -1,   490,   491,   492,   493,   494,    -1,
      -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,    -1,
     506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,    -1,
      -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,
      -1,   547,    -1,   549,    -1,   551,    -1,    -1,    -1,    -1,
     556,    -1,    -1,    -1,     5,   561,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,
      -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    -1,    -1,    -1,    -1,    50,
      -1,    52,    -1,    54,    -1,    -1,    -1,    -1,    59,    60,
      61,    -1,    63,    -1,    65,    66,    -1,    -1,    69,    -1,
      71,    72,    -1,    -1,    75,    -1,    77,    78,    -1,    -1,
      81,    -1,    -1,    -1,    -1,    86,    -1,    -1,    89,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    97,    -1,    -1,   100,
      -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,    -1,
      -1,   112,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,
      -1,   122,   123,   124,    -1,    -1,    -1,    -1,    -1,    -1,
     131,   132,   133,    -1,    -1,    -1,   137,    -1,    -1,    -1,
      -1,   142,   143,   144,    -1,    -1,   147,    -1,   149,   150,
      -1,    -1,    -1,   154,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,   163,   164,   165,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   173,   174,    -1,    -1,   177,    -1,   179,    -1,
      -1,    -1,    -1,    -1,    -1,   186,   187,    -1,    -1,   190,
     191,    -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,   200,
      -1,    -1,    -1,    -1,   205,    -1,    -1,    -1,   209,   210,
     211,   212,   213,    -1,   215,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,    -1,   228,    -1,   230,
     231,    -1,   233,   234,   235,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   243,    -1,    -1,    -1,   247,   248,    -1,   250,
      -1,    -1,    -1,    -1,    -1,   256,    -1,   258,    -1,    -1,
     261,    -1,   263,    -1,    -1,    -1,    -1,    -1,   269,    -1,
      -1,    -1,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,   290,
     291,   292,    -1,   294,   295,    -1,    -1,    -1,   299,   300,
     301,   302,   303,    -1,    -1,   306,   307,    -1,    -1,   310,
      -1,   312,    -1,   314,    -1,    -1,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,   326,   327,    -1,   329,   330,
     331,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   340,
     341,    -1,   343,    -1,   345,   346,   347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   359,   360,
     361,    -1,   363,    -1,   365,    -1,   367,    -1,    -1,    -1,
     371,    -1,   373,    -1,   375,   376,   377,   378,    -1,   380,
     381,   382,   383,   384,   385,   386,   387,    -1,    -1,    -1,
      -1,   392,   393,    -1,    -1,   396,   397,   398,    -1,   400,
      -1,    -1,   403,   404,    -1,   406,    -1,    -1,   409,    -1,
      -1,   412,   413,   414,    -1,    -1,    -1,   418,    -1,   420,
     421,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,    -1,   433,   434,   435,    -1,    -1,   438,    -1,    -1,
      -1,   442,    -1,   444,    -1,    -1,   447,   448,   449,    -1,
      -1,    -1,    -1,    -1,    -1,   456,   457,    -1,   459,    -1,
      -1,   462,    -1,    -1,    -1,   466,    -1,    -1,    -1,   470,
      -1,   472,   473,   474,    -1,    -1,    -1,   478,   479,   480,
     481,    -1,   483,   484,    -1,   486,   487,    -1,    -1,   490,
     491,   492,   493,   494,    -1,    -1,    -1,    -1,    -1,   500,
      -1,   502,    -1,    -1,    -1,   506,   507,   508,    -1,    -1,
     511,   512,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   520,
      -1,    -1,   523,    -1,    -1,    -1,   527,   528,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   536,    -1,    -1,   539,    -1,
      -1,   542,   543,   544,    -1,    -1,   547,    -1,   549,    -1,
     551,    -1,    -1,    -1,    -1,   556,    -1,    -1,    -1,     5,
     561,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,   107,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
     166,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,   203,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,   267,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,   332,   333,    -1,   335,
      -1,    -1,   338,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,
      -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,
      -1,   447,   448,   449,    -1,    -1,   452,   453,   454,    -1,
     456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,
     466,    -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,
      -1,    -1,   478,   479,   480,   481,    -1,   483,   484,    -1,
     486,   487,    -1,    -1,   490,   491,   492,   493,   494,    -1,
      -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,
     506,   507,   508,    -1,   510,   511,   512,    -1,    -1,   515,
      -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,
      -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,
      -1,    -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,
     556,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    32,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,   111,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,   145,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,   251,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,
      -1,   437,   438,    -1,    -1,    -1,   442,   443,   444,   445,
      -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,
     456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,
     466,    -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,
      -1,    -1,   478,   479,   480,   481,    -1,   483,   484,    -1,
     486,   487,    -1,   489,   490,   491,   492,   493,   494,    -1,
      -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,
     506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,
      -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,
      -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,
      -1,    -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,
     556,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    32,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,   111,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,   251,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,
      -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,
      -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,
     456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,
     466,    -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,
      -1,    -1,   478,   479,   480,   481,    -1,   483,   484,    -1,
     486,   487,    -1,   489,   490,   491,   492,   493,   494,    -1,
      -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,
     506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,
      -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,
      -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,
      -1,    -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,
     556,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    32,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,   111,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,   251,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,
      -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,
      -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,
     456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,
     466,    -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,
      -1,    -1,   478,   479,   480,   481,    -1,   483,   484,    -1,
     486,   487,    -1,   489,   490,   491,   492,   493,   494,    -1,
      -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,
     506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,
      -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,
      -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,
      -1,    -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,
     556,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    91,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,   251,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,
      -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,
      -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,
     456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,
     466,    -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,
      -1,    -1,   478,   479,   480,   481,    -1,   483,   484,    -1,
     486,   487,    -1,   489,   490,   491,   492,   493,   494,    -1,
      -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,
     506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,
      -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,
      -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,
      -1,    -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,
     556,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    -1,    33,    34,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,   203,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,
      -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,
      -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,
     456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,
     466,    -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,
      -1,    -1,   478,   479,   480,   481,    -1,   483,   484,    -1,
     486,   487,    -1,   489,   490,   491,   492,   493,   494,    -1,
      -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,
     506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,
      -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,
      -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,
      -1,    -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,
     556,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,   111,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,   251,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,
      -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,
      -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,
     456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,
     466,    -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,
      -1,    -1,   478,   479,   480,   481,    -1,   483,   484,    -1,
     486,   487,    -1,   489,   490,   491,   492,   493,   494,    -1,
      -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,
     506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,
      -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,
      -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,
      -1,    -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,
     556,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    32,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,   251,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,
      -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,
      -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,
     456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,
     466,    -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,
      -1,    -1,   478,   479,   480,   481,    -1,   483,   484,    -1,
     486,   487,    -1,   489,   490,   491,   492,   493,   494,    -1,
      -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,
     506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,
      -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,
      -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,
      -1,    -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,
     556,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,   251,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,
      -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,
      -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,
     456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,
     466,    -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,
      -1,    -1,   478,   479,   480,   481,    -1,   483,   484,    -1,
     486,   487,    -1,   489,   490,   491,   492,   493,   494,    -1,
      -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,
     506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,
      -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,
      -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,
      -1,    -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,
     556,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    18,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,
      -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,
      -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,
     456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,
     466,    -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,
      -1,    -1,   478,   479,   480,   481,    -1,   483,   484,    -1,
     486,   487,    -1,   489,   490,   491,   492,   493,   494,    -1,
      -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,
     506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,
      -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,
      -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,
      -1,    -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,
     556,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    82,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,   153,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,
      -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,
      -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,
     456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,
     466,    -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,
      -1,    -1,   478,   479,   480,   481,    -1,   483,   484,    -1,
     486,   487,    -1,    -1,   490,   491,   492,   493,   494,    -1,
      -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,
     506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,
      -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,
      -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,
      -1,    -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,
     556,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,   175,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,
      -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,
      -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,
     456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,
     466,    -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,
      -1,    -1,   478,   479,   480,   481,    -1,   483,   484,    -1,
     486,   487,    -1,    -1,   490,   491,   492,   493,   494,    -1,
      -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,
     506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,
      -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,
      -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,
      -1,    -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,
     556,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,   111,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,
      -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,
      -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,
     456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,
     466,    -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,
      -1,    -1,   478,   479,   480,   481,    -1,   483,   484,    -1,
     486,   487,    -1,    -1,   490,   491,   492,   493,   494,    -1,
      -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,
     506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,
      -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,
      -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,
      -1,    -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,
     556,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,   111,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,
      -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,
      -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,
     456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,
     466,    -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,
      -1,    -1,   478,   479,   480,   481,    -1,   483,   484,    -1,
     486,   487,    -1,    -1,   490,   491,   492,   493,   494,    -1,
      -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,
     506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,
      -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,
      -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,
      -1,    -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,
     556,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,   372,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,
      -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,
      -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,
     456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,
     466,    -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,
      -1,    -1,   478,   479,   480,   481,    -1,   483,   484,    -1,
     486,   487,    -1,    -1,   490,   491,   492,   493,   494,    -1,
      -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,
     506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,
      -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,
      -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,
      -1,    -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,
     556,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,
      -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,
      -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,
     456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,
     466,    -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,
      -1,    -1,   478,   479,   480,   481,    -1,   483,   484,    -1,
     486,   487,    -1,   489,   490,   491,   492,   493,   494,    -1,
      -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,
     506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,
      -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,
      -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,
      -1,    -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,
     556,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,   111,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,
      -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,
      -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,
     456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,
     466,    -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,
      -1,    -1,   478,   479,   480,   481,    -1,   483,   484,    -1,
     486,   487,    -1,    -1,   490,   491,   492,   493,   494,    -1,
      -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,
     506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,
      -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,
      -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,
      -1,    -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,
     556,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,
      -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,
      -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,
     456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,
     466,    -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,
      -1,    -1,   478,   479,   480,   481,    -1,   483,   484,    -1,
     486,   487,    -1,    -1,   490,   491,   492,   493,   494,    -1,
      -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,
     506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,
      -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,
      -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,
      -1,    -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,
     556,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    -1,    -1,    50,    -1,    52,    -1,    54,    55,
      -1,    57,    -1,    59,    60,    61,    -1,    63,    -1,    65,
      66,    -1,    68,    69,    70,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    80,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
     106,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,   128,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,   141,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,   151,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,   199,   200,    -1,   202,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,   241,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,   335,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,   347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,   370,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,   402,   403,    -1,    -1,
     406,    -1,   408,   409,   410,    -1,   412,   413,    -1,    -1,
      -1,   417,   418,    -1,   420,   421,    -1,   423,   424,   425,
     426,    -1,   428,   429,    -1,    -1,    -1,   433,   434,   435,
      -1,    -1,   438,    -1,    -1,    -1,   442,   443,   444,   445,
      -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,
     456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,   465,
     466,    -1,    -1,   469,   470,    -1,   472,   473,   474,    -1,
      -1,    -1,   478,   479,   480,   481,    -1,   483,   484,    -1,
     486,   487,    -1,    -1,   490,   491,   492,   493,   494,    -1,
      -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,   505,
     506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,   515,
      -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,   525,
      -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,
      -1,    -1,    -1,   549,    -1,   551,   552,    -1,    -1,     5,
     556,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    -1,    -1,    -1,    23,    24,    25,
      -1,    -1,    -1,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      -1,    -1,    -1,    -1,    50,    -1,    52,    -1,    54,    -1,
      -1,    -1,    -1,    59,    60,    -1,    -1,    63,    -1,    65,
      66,    -1,    -1,    69,    -1,    71,    72,    -1,    -1,    75,
      -1,    77,    78,    -1,    -1,    81,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,   100,    -1,    -1,    -1,    -1,   105,
      -1,    -1,    -1,    -1,    -1,    -1,   112,    -1,   114,    -1,
      -1,    -1,    -1,    -1,   120,    -1,   122,   123,   124,    -1,
      -1,    -1,    -1,    -1,    -1,   131,   132,   133,    -1,    -1,
      -1,   137,    -1,    -1,    -1,    -1,   142,   143,   144,    -1,
      -1,   147,    -1,   149,   150,    -1,    -1,    -1,   154,    -1,
     156,    -1,    -1,   159,   160,    -1,    -1,   163,   164,   165,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   173,   174,    -1,
      -1,   177,    -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,
     186,   187,    -1,    -1,   190,   191,    -1,   193,    -1,    -1,
      -1,    -1,    -1,    -1,   200,    -1,    -1,    -1,    -1,   205,
      -1,    -1,    -1,   209,   210,   211,   212,    -1,    -1,   215,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,    -1,   228,    -1,   230,   231,    -1,   233,   234,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,   250,    -1,    -1,    -1,    -1,    -1,
     256,    -1,   258,    -1,    -1,   261,    -1,   263,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,   290,   291,   292,    -1,   294,   295,
      -1,    -1,    -1,   299,   300,   301,   302,   303,    -1,    -1,
     306,   307,    -1,    -1,   310,    -1,   312,    -1,   314,    -1,
      -1,   317,   318,   319,   320,   321,   322,   323,    -1,    -1,
     326,   327,    -1,   329,   330,   331,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   340,   341,    -1,   343,    -1,   345,
     346,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   358,   359,   360,   361,    -1,   363,    -1,   365,
      -1,   367,    -1,    -1,    -1,   371,    -1,   373,    -1,   375,
     376,   377,   378,    -1,   380,   381,   382,   383,   384,   385,
     386,   387,    -1,    -1,    -1,    -1,   392,   393,    -1,    -1,
     396,   397,   398,    -1,   400,    -1,    -1,   403,    -1,    -1,
     406,    -1,    -1,   409,    -1,    -1,   412,   413,    -1,    -1,
      -1,    -1,   418,    -1,   420,   421,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,    -1,   433,   434,   435,
      -1,    -1,   438,    -1,    -1,    -1,   442,    -1,   444,    -1,
      -1,   447,   448,   449,    -1,    -1,    -1,    -1,    -1,    -1,
     456,   457,    -1,   459,    -1,    -1,   462,    -1,    -1,    -1,
     466,    -1,    -1,    -1,   470,    -1,   472,   473,   474,    -1,
      -1,    -1,   478,   479,   480,   481,    -1,   483,   484,    -1,
     486,   487,    -1,    -1,   490,   491,   492,   493,   494,    -1,
      -1,    -1,    -1,    -1,   500,    -1,   502,    -1,    -1,    -1,
     506,   507,   508,    -1,    -1,   511,   512,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   520,    -1,    -1,   523,    -1,    -1,
      -1,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     536,    -1,    -1,   539,    -1,    -1,   542,   543,   544,    -1,
      -1,    -1,    -1,   549,    -1,   551,    -1,    -1,    -1,    -1,
     556
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned short int yystos[] =
{
       0,     3,    13,    14,    26,    28,    47,    48,    53,    57,
      58,    70,    87,   106,   115,   116,   117,   128,   129,   151,
     168,   192,   199,   202,   223,   239,   257,   262,   348,   370,
     379,   399,   401,   402,   405,   408,   410,   415,   417,   426,
     430,   436,   441,   445,   465,   469,   505,   521,   524,   529,
     552,   573,   584,   585,   586,   587,   588,   589,   591,   596,
     598,   603,   621,   784,   802,   805,   813,   815,   817,   820,
     825,   827,   832,   835,   840,   844,   852,   853,   990,   992,
    1000,  1003,  1028,  1036,  1047,  1053,  1067,  1070,  1073,  1079,
    1083,  1087,  1090,  1091,  1137,  1154,  1160,  1162,  1169,  1171,
    1196,  1202,  1203,  1204,  1205,  1243,    11,    94,   179,   214,
     374,   798,  1224,  1225,   258,   336,   834,   483,   485,  1156,
    1197,   217,     5,     7,     8,     9,    10,    11,    17,    20,
      23,    24,    25,    26,    28,    30,    33,    37,    40,    41,
      42,    44,    46,    47,    50,    52,    54,    55,    57,    59,
      60,    61,    63,    65,    66,    68,    69,    70,    71,    72,
      75,    77,    78,    80,    81,    86,    89,    96,    97,   100,
     105,   106,   112,   114,   120,   122,   123,   124,   128,   131,
     132,   133,   137,   141,   142,   143,   144,   147,   149,   150,
     151,   154,   156,   159,   160,   163,   164,   165,   168,   173,
     174,   177,   179,   186,   187,   190,   191,   193,   199,   200,
     202,   205,   209,   210,   211,   212,   215,   216,   220,   224,
     228,   230,   231,   233,   234,   241,   243,   247,   250,   256,
     258,   261,   263,   273,   274,   275,   276,   277,   278,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   290,   291,
     292,   294,   295,   299,   300,   301,   302,   303,   306,   307,
     310,   312,   314,   317,   318,   319,   320,   321,   322,   323,
     326,   327,   329,   330,   331,   335,   340,   341,   343,   345,
     346,   347,   358,   359,   360,   361,   363,   365,   367,   370,
     371,   373,   375,   376,   377,   378,   380,   381,   382,   383,
     384,   385,   386,   387,   392,   393,   396,   397,   398,   400,
     402,   403,   406,   408,   409,   410,   412,   413,   417,   418,
     420,   421,   423,   424,   425,   426,   428,   429,   433,   434,
     435,   438,   442,   443,   444,   445,   447,   448,   449,   456,
     457,   459,   462,   465,   466,   469,   470,   472,   473,   474,
     478,   479,   480,   481,   483,   484,   486,   487,   490,   491,
     492,   493,   494,   500,   502,   505,   506,   507,   508,   511,
     512,   515,   520,   523,   525,   527,   528,   536,   539,   542,
     543,   544,   549,   551,   552,   556,   609,  1127,  1131,  1135,
    1136,   287,  1156,  1156,   549,  1198,    94,   178,   450,   486,
     517,   527,   607,   701,   702,   703,   776,  1037,   991,    94,
     179,   217,   374,   486,   501,   527,   542,   999,  1131,   834,
     608,   580,  1125,  1126,  1131,   597,  1001,  1088,    96,   217,
     485,  1156,   834,  1131,  1084,   426,   527,  1156,   834,  1004,
    1080,  1156,   608,  1198,  1131,   855,   857,   858,   349,  1139,
    1054,   465,   469,   445,   500,   445,   485,  1048,  1161,  1029,
    1131,    28,    70,   141,   370,   392,   417,   465,  1245,   430,
     573,   854,     0,     3,   370,   156,  1071,  1125,  1131,   145,
     790,  1131,   609,   609,   485,   112,  1221,  1156,   816,  1198,
     841,   842,  1125,   622,   580,   498,   818,   828,    16,  1199,
     213,   704,   608,   354,  1219,  1221,  1222,  1223,  1224,   485,
     702,   217,   214,   270,   382,  1045,  1046,   907,   908,   213,
     998,   998,  1131,   998,   998,   608,   998,  1156,   592,  1074,
      12,    13,    87,   115,   129,   151,   163,   192,   217,   223,
     262,   375,   394,   400,   406,   430,   441,   442,   478,   524,
     526,  1172,  1174,  1176,  1177,  1131,   347,    61,   390,   580,
     251,   489,  1128,  1131,  1133,   113,   204,   270,  1006,    77,
     381,  1089,  1092,   226,  1125,  1155,  1156,   175,    32,   287,
    1059,  1085,  1131,   608,   836,  1156,   113,   270,  1007,  1035,
     287,   381,   445,  1081,  1082,   814,    12,  1170,  1174,   498,
    1199,   856,    12,   125,   204,   455,   456,   457,   458,   459,
     460,   471,   862,   863,   864,  1138,    30,    33,    55,    56,
      65,    67,    85,    87,    95,   143,   147,   177,   179,   191,
     193,   216,   217,   220,   237,   258,   263,   287,   320,   329,
     347,   373,   374,   377,   378,   435,   445,   470,   485,   543,
     749,   775,  1055,  1059,  1060,  1062,  1145,   807,   808,   807,
     807,   548,   806,   807,   995,  1125,  1156,  1035,    34,   203,
     489,  1113,  1129,  1244,  1244,  1244,  1244,  1244,   857,   854,
     574,  1131,  1069,  1068,   301,   487,   512,   786,   788,   787,
    1125,   145,   461,  1226,   826,   994,   995,   229,   575,   848,
     849,   573,   623,  1131,   599,   994,   994,    52,   335,   335,
     399,  1200,   332,   333,   879,  1131,    91,  1133,  1134,  1187,
    1188,   405,    10,   374,   501,   716,  1220,  1226,  1227,  1235,
    1237,  1221,  1224,   704,  1131,   175,  1038,  1042,  1043,  1131,
    1045,     7,    20,    22,    25,    29,    32,    34,    35,    36,
      38,    51,    55,    56,    62,    65,    73,    74,    80,    83,
      84,    85,    90,    91,    93,    94,    98,    99,   100,   105,
     107,   110,   111,   118,   119,   136,   139,   140,   152,   155,
     157,   158,   162,   166,   171,   176,   180,   181,   182,   183,
     185,   186,   188,   189,   190,   194,   196,   197,   203,   209,
     213,   223,   225,   242,   246,   249,   254,   256,   259,   264,
     267,   272,   279,   289,   293,   302,   306,   308,   309,   313,
     314,   315,   316,   317,   318,   319,   325,   332,   333,   334,
     337,   338,   343,   361,   362,   364,   365,   366,   367,   368,
     380,   388,   404,   405,   416,   419,   422,   424,   428,   467,
     468,   473,   475,   476,   477,   482,   489,   491,   492,   493,
     494,   503,   504,   505,   510,   513,   518,   519,   527,   531,
     532,   533,   534,   535,   540,   544,   554,   556,   561,   565,
     566,   571,   573,   576,   577,   579,   580,   873,   874,   875,
     876,   880,   883,   884,   886,   893,   897,   909,  1112,  1114,
    1116,  1117,  1121,  1123,  1127,  1131,   152,  1131,   609,   344,
     609,   609,  1134,  1186,   994,   998,   530,   593,   120,   205,
     263,   287,   373,   381,   409,   445,   466,   483,  1075,  1076,
    1156,   373,  1175,   420,   420,   486,   527,   542,   349,  1179,
     483,  1181,    60,   445,  1178,    95,   542,  1180,   344,   575,
      18,   145,   950,   951,  1163,  1131,   798,   873,    75,   175,
     270,  1093,  1099,    47,   175,  1125,  1157,  1158,   833,   579,
     590,  1128,   263,   837,  1134,   838,   839,  1125,   821,   226,
     995,  1008,  1009,    47,   575,   994,  1175,   344,   426,  1201,
    1200,   516,  1206,  1207,   567,   866,   867,   868,   864,  1140,
    1141,  1142,   263,   150,   436,   252,   546,  1066,   506,   573,
      94,   179,   374,   485,   542,  1066,   711,  1133,   253,   969,
     971,    63,   466,   172,   466,   466,   466,   287,   483,    63,
     466,    12,    40,    81,    86,   231,   300,   359,   449,   480,
    1049,  1050,  1051,   205,   466,   466,   506,   969,  1066,   175,
     229,  1063,   263,   142,    66,   376,   483,   502,   466,   539,
     804,   398,   462,   809,   810,   803,    78,   798,   575,   346,
    1247,   479,  1248,   236,   412,  1246,   574,  1207,  1209,  1210,
    1211,   852,  1072,  1113,  1131,   111,   699,   700,   709,   710,
     758,   616,   616,   785,  1134,   429,   542,   994,   498,   575,
     111,   843,  1131,   842,   217,   238,   773,   774,   850,   624,
     625,   873,   273,   274,   275,   276,   277,   278,   281,   282,
     283,   284,   285,   286,   288,   396,   397,   600,   601,   602,
     156,   382,   819,    54,   156,   159,   172,   299,   382,   829,
     830,   831,    52,   399,   152,   606,   573,   872,   579,   211,
     575,   868,   868,   868,   542,  1227,  1125,   507,   530,   777,
     996,   997,  1125,   575,  1040,   580,  1044,   573,   573,   573,
     573,   573,   884,   573,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   573,   872,   872,   573,
     872,   573,   573,   573,   513,   573,  1112,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   873,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   573,   910,   911,   912,
     573,   573,   573,   573,   573,   573,   573,   573,   573,   573,
     573,   573,   873,   573,   872,   573,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   573,   573,   872,   573,
    1112,   573,   573,   573,  1112,   573,   573,    34,   203,   489,
     573,   573,   573,   872,   872,   872,   573,   573,   573,   573,
     573,   573,   873,   914,   884,   884,   884,   430,   573,   873,
    1214,  1131,   898,  1131,    15,    16,   351,   354,   553,   877,
     878,   145,   146,   184,   198,   232,   244,   271,   328,   881,
     126,   229,   252,   313,   395,   439,   440,   448,   562,   563,
     564,   565,   566,   567,   568,   569,   570,   879,   884,   101,
     102,   103,   104,   105,   174,   206,   207,   208,   209,   302,
     304,   305,   306,   314,   380,   427,   428,   544,   555,   556,
     947,   948,    64,   353,   575,  1129,   573,   580,  1125,   575,
      49,   411,   799,   994,   579,   594,   595,    47,   548,   575,
    1077,   483,   573,  1189,  1189,  1189,  1189,   179,   374,   485,
    1173,  1177,  1131,   164,   330,  1131,  1164,  1165,  1008,   287,
     258,  1098,   845,   287,   951,   575,   994,  1133,    27,   498,
    1086,   575,   498,   575,   498,   994,  1009,  1005,  1082,   175,
     575,   179,   374,  1173,  1131,    12,   125,  1213,   575,   859,
     870,   873,  1119,  1131,   575,   191,   258,   345,   435,  1143,
    1144,  1147,  1148,   229,  1064,  1128,   873,   567,   704,   609,
     609,  1125,  1125,  1056,   267,   338,   510,   972,   973,  1114,
     609,  1066,  1134,   172,  1061,  1063,   609,  1066,   230,   481,
     160,   172,  1052,   575,  1061,  1125,  1063,  1061,  1061,  1066,
    1066,   523,   811,   575,   811,   447,   430,   573,   577,   917,
     918,   919,   920,   929,   930,   938,  1113,   363,  1249,   352,
     965,   971,  1212,   700,    64,   749,    68,    80,   241,   311,
     335,   389,   461,   618,   620,     6,    13,    23,    24,    53,
      57,    68,    77,    83,    96,   114,   123,   124,   129,   137,
     143,   169,   215,   217,   224,   292,   307,   312,   352,   358,
     361,   384,   385,   387,   401,   423,   507,   516,   706,   708,
     709,   710,   791,   792,   793,   961,   112,   228,  1125,   829,
    1128,   995,   573,   574,   575,   145,   145,   145,   145,   145,
     145,   145,   145,   145,   145,   145,   145,   145,   145,   145,
     575,   525,   830,   698,   699,   574,  1133,    45,  1188,   609,
     609,   179,  1125,   604,    44,   200,   425,   778,   778,   344,
     575,  1041,  1039,  1043,   175,   567,  1131,   951,   873,   873,
     873,    12,   125,   903,   952,   107,   166,   203,   267,   338,
     510,   975,   903,   903,   903,   873,   873,   907,   907,   873,
     907,   873,   873,   873,   873,   125,   903,   952,   873,   574,
     873,   873,   873,   873,   873,  1121,  1131,   873,   873,   873,
     873,   873,   573,  1214,   873,   947,   873,   873,   873,   574,
     873,   873,   873,   873,   907,   873,   873,    97,   100,   491,
     494,   949,   873,   125,   900,  1112,   873,   873,   873,   574,
     873,   873,   873,   873,   907,   873,   873,   873,   873,   911,
       9,   913,  1121,   125,   903,   873,   873,   125,   903,   873,
     873,   873,   873,   873,   907,   907,   907,   873,   873,   873,
     873,   873,   873,   907,   876,   873,   574,   873,   873,   873,
     873,   873,   574,   873,   873,   903,   903,   873,   873,   873,
     125,   903,   873,   873,   948,   948,   873,    43,   245,   499,
     873,   873,  1112,   574,   873,   574,   903,  1122,  1123,  1131,
     903,   873,   873,   873,   545,   916,  1217,  1217,   574,   575,
     574,   873,   579,   899,  1133,   580,   873,   873,   873,   875,
     158,   337,   504,   520,   879,    12,    17,   875,   882,   876,
     573,   884,   876,   876,   876,   876,   252,   876,   876,   876,
     876,   883,   876,   883,   876,   876,   876,   876,   229,   252,
     395,   562,   566,  1133,   884,   873,   885,  1131,   993,  1134,
     799,  1133,   575,   390,  1076,   994,  1078,  1131,  1190,  1191,
     567,  1125,  1131,  1185,  1185,  1185,   145,   164,   184,   198,
     243,   244,   271,   330,   371,  1166,  1168,   546,   953,  1002,
     218,   846,   847,  1125,   270,   390,   550,  1159,  1158,   829,
     873,  1128,  1134,  1134,   839,  1125,   156,   382,   528,   822,
     823,   824,   430,   436,   535,   536,   573,   694,  1010,  1013,
    1128,   192,  1185,  1185,  1185,  1208,   867,   175,   226,   860,
     861,   964,   965,   986,   869,   580,  1141,   111,   500,  1131,
    1150,   321,   361,   579,   749,  1149,  1128,   175,  1065,   574,
    1131,   263,   466,  1058,   341,   575,   445,  1066,  1131,   381,
     969,  1051,  1066,  1061,  1125,  1066,  1066,   602,   812,   810,
     937,  1131,    88,   219,   236,   249,   324,   416,   471,   928,
     436,   575,  1125,   937,   575,   172,  1250,    45,   969,   145,
     437,  1019,  1020,  1020,  1128,   461,   461,   461,   461,   461,
     429,    67,    79,   178,   450,   721,   724,   725,   771,   773,
     797,   797,  1020,  1020,   797,  1020,  1020,  1020,   498,   122,
    1020,   237,   484,   170,   372,   773,   797,   237,  1020,   484,
     122,  1020,  1020,  1020,   797,    45,  1020,  1020,  1020,  1020,
    1020,    18,   145,   498,   801,  1020,  1020,  1020,   706,   575,
     573,   580,   720,   726,  1124,  1131,   789,   372,   945,  1131,
     873,   975,  1128,  1128,   107,   166,   267,   338,   510,   976,
    1128,   975,  1128,  1128,  1128,  1128,  1128,   975,  1128,  1128,
     975,   601,   361,   489,  1239,     8,    27,   686,   609,  1228,
     252,   573,   688,   705,   707,   708,  1125,   997,  1125,   530,
     953,   918,   580,  1044,   575,   574,   574,   575,   903,   574,
     904,   575,   574,   574,   574,    18,   574,   530,   574,   574,
     574,   574,   575,   575,   530,   575,   575,   894,   574,   567,
     574,   575,   575,   574,   574,   575,   574,   580,   574,   575,
     574,   575,   575,   575,   574,   575,   574,   575,   175,   575,
     575,   574,   575,   574,   575,   575,   574,   575,   574,   574,
     575,   574,   575,   575,   575,   896,   575,   574,   575,   575,
     574,   575,   575,   574,   575,   574,   575,   574,   575,   575,
     575,   574,   573,   575,   903,   574,   574,   574,   903,   574,
     574,   575,   575,   574,   574,   575,   574,   575,   574,   574,
     574,   574,   574,   574,   574,   575,   575,   574,   575,   574,
     229,   574,   574,   575,   575,   575,   574,   575,   575,   574,
     574,   574,   575,   175,   575,   575,   903,   574,   574,   574,
     575,   575,   575,   574,   175,   873,   175,   873,   175,   873,
     175,   574,   575,   575,   574,   574,   574,   574,   574,   575,
     574,   575,   574,   873,   545,   559,   915,   855,  1216,  1214,
     907,   578,   191,   258,   435,  1146,   437,  1131,   158,   337,
     504,   520,   573,   873,  1214,   149,   957,   876,    16,   947,
     947,   573,   884,   876,   876,   873,   888,   889,   890,   573,
     580,   595,   262,   574,   575,   580,   580,   498,   498,   498,
    1167,   954,   970,   971,  1010,   489,  1130,   575,   848,   550,
     258,   498,   823,   695,  1011,   573,  1016,  1021,  1016,   574,
     694,  1012,  1118,  1119,  1122,  1131,  1014,   349,   175,   175,
     175,   853,   130,   918,   987,   172,   262,   865,   986,   970,
     861,    18,   871,  1128,  1131,   567,  1131,   580,   233,   580,
    1019,    32,   111,   750,   751,  1019,  1133,   172,  1019,   579,
    1133,    32,   111,   753,   754,  1133,   976,  1057,   147,   543,
     973,   973,   548,   338,   953,  1061,   575,   932,   937,   917,
     236,   236,   355,   939,   236,   249,   416,   939,   929,   917,
    1031,  1032,  1122,   917,   951,   934,   935,   975,   303,   966,
     111,   755,   757,  1133,   751,    96,    96,   112,   228,   781,
    1124,   774,   774,    58,   170,   372,   517,   723,   772,   722,
     723,   781,  1124,   976,   975,  1124,   975,  1128,  1128,   749,
    1020,   975,   238,   238,  1124,  1124,   711,  1020,   164,   243,
     335,   714,   976,   976,  1124,   962,   963,  1122,   111,   975,
    1128,   975,   975,   383,   386,   713,   975,  1125,    71,    72,
     111,   133,   165,   393,   712,   711,   573,   793,   718,   719,
     720,   721,  1131,     8,   164,   800,   394,   722,   763,   727,
     580,   573,  1229,   574,   575,   489,   573,   115,   223,   524,
     687,  1238,  1229,  1125,   252,   689,   694,   718,   214,   405,
     691,  1100,   575,   707,   605,   918,   964,   953,   951,   225,
     873,   873,   574,   873,   873,    32,    56,    97,   100,   108,
     326,   443,   494,   522,   905,   750,   907,   873,   750,   905,
     873,   907,   574,   883,   883,  1129,  1131,   873,   873,   907,
    1129,   873,   873,   873,   907,   338,   873,   873,   873,   873,
     873,   873,   873,   907,   907,   338,   873,   873,   907,   873,
     873,   873,   873,   907,   873,   876,  1121,   574,   574,   873,
     873,   873,   873,   873,   873,   873,   873,   873,   873,   873,
     873,   907,   225,   873,   873,   873,   873,   574,   873,   873,
     873,   873,   175,   873,   175,   873,   175,   873,   873,   338,
     873,   873,   560,   873,   873,   141,  1218,   574,   574,   580,
     580,   580,  1133,   873,  1214,   574,   575,   574,   884,   875,
     873,  1214,   957,    16,   574,   868,   891,   892,   906,   907,
    1131,  1191,   567,   567,  1187,  1187,  1187,   573,   873,   344,
    1026,  1094,   847,   214,   851,  1134,   862,  1017,  1018,  1122,
    1022,   575,   573,  1013,   574,   574,   575,   580,  1206,   175,
    1187,  1187,  1187,   953,   953,   131,   356,   982,   983,   988,
     524,   229,  1128,  1131,   580,  1131,   250,  1131,    12,    32,
     111,   344,   873,  1153,    64,   756,   873,  1134,   343,   361,
     489,  1152,  1146,  1019,   969,   275,  1066,   602,  1209,   933,
     249,   236,   929,   939,   939,   236,   344,   344,   530,   575,
    1030,  1019,   169,   214,   529,   941,   862,   873,   967,  1120,
     873,   238,   238,   774,   781,   777,   129,   436,   794,   751,
    1128,   781,   799,  1128,   795,   575,    19,   116,   968,   994,
     574,   575,  1131,  1125,    31,    32,    37,    39,    41,    42,
      56,    97,   100,   108,   127,   144,   165,   167,   186,   187,
     227,   256,   265,   266,   268,   296,   297,   298,   317,   318,
     319,   323,   326,   339,   340,   365,   367,   391,   434,   436,
     446,   490,   491,   494,   495,   496,   497,   537,   538,   556,
     728,   731,   732,   733,   734,   735,   736,   737,  1131,  1131,
    1230,    18,  1131,  1240,   344,   413,   573,   610,    18,  1125,
     574,   574,    18,   697,   707,   573,   953,   253,   974,   873,
     574,   574,   574,   573,   743,   743,   573,   738,   739,   743,
     227,   227,   574,   574,   574,   574,   574,   574,   575,   895,
     947,   947,   574,   574,   574,   574,   574,   574,   575,   574,
     574,   574,   574,   574,   575,   574,   574,   574,   574,   574,
     902,   965,   575,   575,   575,   574,   574,   574,   574,   575,
     574,   574,   574,   575,   229,   548,   887,   574,   574,   574,
     574,   574,   574,   574,   574,   574,   575,   574,   574,   574,
     873,   574,   172,   574,   574,   575,   575,   574,   575,   575,
     574,   873,   574,   873,   574,   873,   574,   574,   575,   574,
     574,   873,   560,  1215,   580,   782,   574,   907,   574,   575,
     574,   875,   873,   575,   574,   407,  1192,  1192,  1192,   111,
     873,  1024,  1025,   132,  1100,   247,   866,   575,  1019,  1023,
    1024,  1021,  1015,  1013,  1118,  1131,  1187,   970,   195,   958,
    1130,  1130,   579,   984,   985,  1133,   438,   567,   390,   403,
     433,  1151,   757,  1019,   573,   573,  1150,   873,   145,   574,
     919,   355,   917,   929,   236,   236,   917,   929,   922,   921,
     923,  1032,   953,  1025,   773,   942,   942,   942,   866,   575,
     968,   781,   777,   573,   111,   111,   726,   756,   728,   963,
     574,   719,   764,   573,   573,   743,   738,   369,   729,   738,
     738,    20,    32,    46,   515,   749,   759,    56,   537,   732,
     734,   759,   759,    56,   538,   538,   541,   738,   730,   743,
     743,   759,   573,   743,    23,    64,    68,   111,   337,   344,
     372,   434,   517,   745,   746,   747,   762,   879,   541,   573,
     759,    32,   573,   760,   573,   573,   743,   573,   739,   744,
     580,   574,   575,  1231,  1232,   221,   229,   357,   630,   631,
     632,   633,   868,   108,   227,   391,   472,   717,   611,  1231,
     574,   690,   705,   573,   694,   779,   780,  1131,   973,   947,
     338,   759,   338,   873,   574,   574,   574,   873,   873,   432,
     901,   338,   873,   873,   873,   873,    41,   381,   574,   873,
     947,   873,   873,   873,   873,   873,   574,   574,   574,   338,
     873,  1206,  1131,   574,   907,   869,   892,    59,   234,   331,
     463,   474,   551,  1183,  1184,   548,  1193,  1193,  1193,   574,
     575,  1027,   226,   696,  1018,  1025,   574,  1209,    45,   201,
     955,   989,  1133,   575,   310,    69,   511,   390,  1152,   489,
     489,  1019,  1128,   951,   236,   344,   925,   929,   929,   344,
     927,   873,   873,   573,   964,   172,   940,   936,  1120,   573,
     573,   779,   100,   491,   494,   565,   566,  1115,  1116,   800,
     745,   289,   344,   573,   765,   767,   768,   769,   338,   338,
     443,   522,   557,   740,   741,   742,   573,   740,   740,   760,
      20,   515,   749,   761,   760,   750,   759,   541,   740,   573,
     759,   338,   740,   755,  1128,   334,   748,  1115,   524,   111,
     238,   747,   238,   337,   338,   338,   338,   338,   740,   338,
     740,  1131,  1131,   548,  1234,   430,   573,  1233,   574,   575,
     628,  1125,   509,   626,   627,   629,  1131,  1234,  1209,   691,
     694,   692,   574,   575,   968,   573,   574,   574,   574,   575,
     574,   574,   575,   574,  1113,   574,   575,   574,   575,   574,
     574,   310,   154,   574,   574,   574,   574,   574,   574,   574,
     575,  1218,   574,   871,   489,   489,   489,    16,  1182,   192,
     290,   291,   294,   295,  1194,  1195,  1025,   238,  1095,   715,
     861,   970,   959,  1120,   956,   964,    66,  1101,   985,   574,
     574,  1153,    16,   917,   924,   530,   926,   530,   946,  1131,
     974,   236,   943,   715,   968,   779,   779,   574,  1117,  1117,
     796,   177,   360,   444,   115,   524,   766,  1131,   769,   574,
     574,   742,   783,  1113,   750,   760,   783,   574,   872,   334,
     536,   574,   574,   574,   574,    50,    58,   258,   868,   868,
    1241,   632,  1131,   172,  1128,   574,   575,   628,   574,  1206,
     780,   338,   338,   873,   903,   873,   907,  1183,   349,   975,
     975,   975,   975,  1195,   524,   485,   865,   548,   575,   960,
     968,   873,   970,   138,   148,   350,   488,  1102,  1103,   255,
    1104,   276,   344,   873,   573,   873,   573,   574,   575,   573,
     574,   574,   800,    49,   335,   411,   436,   770,   770,   574,
     575,   574,   575,   574,   872,   759,   760,   759,   760,    58,
     349,    58,   855,   854,   617,   728,   868,   612,   629,   728,
     693,   968,   574,   574,   574,   575,   574,   574,   574,  1033,
    1034,  1122,  1125,    89,   418,  1120,   374,   977,    45,    45,
     138,    45,  1103,   464,   488,  1105,  1106,   145,   931,   946,
     946,  1131,   944,   945,   763,     5,   111,   337,   767,  1131,
     759,  1113,   759,   349,   349,   574,   121,   618,   619,   879,
    1242,   134,   413,  1209,   873,   575,  1019,  1096,   968,  1131,
    1113,  1113,    45,  1113,    45,    45,  1106,   976,   873,   574,
     574,   574,  1209,   121,    61,   161,   213,   235,   248,   347,
     414,   561,   650,   651,   654,   663,   664,   667,   678,  1127,
    1132,  1136,   424,   613,   574,  1034,  1025,   749,   752,   978,
    1113,  1113,  1113,    16,   578,  1131,   175,   330,   656,   653,
    1132,  1132,  1131,   652,   665,   668,   586,    28,   269,   404,
     547,   681,   582,  1236,   728,   751,  1097,   573,   280,   175,
    1131,   658,   659,   873,   873,   545,   670,   674,   682,   635,
     650,   635,   683,   679,   650,   614,  1101,   868,   979,   980,
     981,   145,   226,   141,   873,   666,   675,   559,   674,   677,
     636,   141,   650,   581,   523,   873,   681,   617,  1104,   873,
     574,   575,   975,   655,   213,   560,   545,   669,   671,   873,
     635,   141,   109,   634,   637,   269,   581,   685,   128,   680,
    1132,   615,   214,  1107,   981,   657,  1131,   660,   672,   671,
     677,   676,   561,    82,   153,   642,   648,  1131,   141,   650,
     581,   873,   684,   650,   338,   573,  1108,   575,   635,   873,
     141,   560,   199,   575,   638,    76,    92,   581,   141,   635,
     255,   574,   579,  1109,  1110,  1122,   436,  1111,  1131,   661,
     673,   561,   635,   172,  1131,   728,   172,   172,   404,   141,
    1133,   574,   575,  1033,   135,   559,   662,   560,   639,   111,
     649,   453,   645,   975,   640,   641,   547,  1110,   658,   635,
     635,   452,   454,   643,   644,   645,   647,   879,  1131,   873,
     536,   646,   586,   575,   650,   173,  1129,   644
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (N)								\
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (0)
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
              (Loc).first_line, (Loc).first_column,	\
              (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (&yylval, YYLEX_PARAM)
#else
# define YYLEX yylex (&yylval)
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Type, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short int *bottom, short int *top)
#else
static void
yy_stack_print (bottom, top)
    short int *bottom;
    short int *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);


# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yymsg, yytype, yyvaluep)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */






/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  /* The look-ahead symbol.  */
int yychar;

/* The semantic value of the look-ahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;

  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Look-ahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short int yyssa[YYINITDEPTH];
  short int *yyss = yyssa;
  register short int *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;


  yyvsp[0] = yylval;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short int *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short int *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a look-ahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to look-ahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a look-ahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid look-ahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the look-ahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 1220 "sql_yacc.yy"
    {
	   THD *thd= YYTHD;
	   if (!thd->bootstrap &&
	      (!(thd->lex->select_lex.options & OPTION_FOUND_COMMENT)))
	   {
	     my_message(ER_EMPTY_QUERY, ER(ER_EMPTY_QUERY), MYF(0));
	     MYSQL_YYABORT;
	   }
	   else
	   {
	     thd->lex->sql_command= SQLCOM_EMPTY_QUERY;
	   }
	}
    break;

  case 3:
#line 1233 "sql_yacc.yy"
    {}
    break;

  case 53:
#line 1293 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->sql_command= SQLCOM_DEALLOCATE_PREPARE;
          lex->prepared_stmt_name= (yyvsp[0].lex_str);
        }
    break;

  case 56:
#line 1308 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->sql_command= SQLCOM_PREPARE;
          lex->prepared_stmt_name= (yyvsp[-2].lex_str);
        }
    break;

  case 57:
#line 1317 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->prepared_stmt_code= (yyvsp[0].lex_str);
          lex->prepared_stmt_code_is_varref= FALSE;
        }
    break;

  case 58:
#line 1324 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->prepared_stmt_code= (yyvsp[0].lex_str);
          lex->prepared_stmt_code_is_varref= TRUE;
        }
    break;

  case 59:
#line 1333 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->sql_command= SQLCOM_EXECUTE;
          lex->prepared_stmt_name= (yyvsp[0].lex_str);
        }
    break;

  case 60:
#line 1340 "sql_yacc.yy"
    {}
    break;

  case 65:
#line 1354 "sql_yacc.yy"
    {
          LEX *lex=Lex;
          LEX_STRING *lexstr= (LEX_STRING*)sql_memdup(&(yyvsp[0].lex_str), sizeof(LEX_STRING));
          if (!lexstr || lex->prepared_stmt_params.push_back(lexstr))
              MYSQL_YYABORT;
        }
    break;

  case 66:
#line 1366 "sql_yacc.yy"
    {
         if (Lex->sphead)
         {
           my_error(ER_SP_BADSTATEMENT, MYF(0), "HELP");
           MYSQL_YYABORT;
         }
       }
    break;

  case 67:
#line 1374 "sql_yacc.yy"
    {
	  LEX *lex= Lex;
	  lex->sql_command= SQLCOM_HELP;
	  lex->help_arg= (yyvsp[0].lex_str).str;
       }
    break;

  case 68:
#line 1384 "sql_yacc.yy"
    {
	  LEX *lex = Lex;
	  lex->sql_command = SQLCOM_CHANGE_MASTER;
	  bzero((char*) &lex->mi, sizeof(lex->mi));
        }
    break;

  case 69:
#line 1390 "sql_yacc.yy"
    {}
    break;

  case 72:
#line 1399 "sql_yacc.yy"
    {
	 Lex->mi.host = (yyvsp[0].lex_str).str;
       }
    break;

  case 73:
#line 1404 "sql_yacc.yy"
    {
	 Lex->mi.user = (yyvsp[0].lex_str).str;
       }
    break;

  case 74:
#line 1409 "sql_yacc.yy"
    {
	 Lex->mi.password = (yyvsp[0].lex_str).str;
       }
    break;

  case 75:
#line 1414 "sql_yacc.yy"
    {
	 Lex->mi.port = (yyvsp[0].ulong_num);
       }
    break;

  case 76:
#line 1419 "sql_yacc.yy"
    {
	 Lex->mi.connect_retry = (yyvsp[0].ulong_num);
       }
    break;

  case 77:
#line 1423 "sql_yacc.yy"
    {
           Lex->mi.ssl= (yyvsp[0].ulong_num) ? 
               LEX_MASTER_INFO::SSL_ENABLE : LEX_MASTER_INFO::SSL_DISABLE;
         }
    break;

  case 78:
#line 1428 "sql_yacc.yy"
    {
           Lex->mi.ssl_ca= (yyvsp[0].lex_str).str;
         }
    break;

  case 79:
#line 1432 "sql_yacc.yy"
    {
           Lex->mi.ssl_capath= (yyvsp[0].lex_str).str;
         }
    break;

  case 80:
#line 1436 "sql_yacc.yy"
    {
           Lex->mi.ssl_cert= (yyvsp[0].lex_str).str;
         }
    break;

  case 81:
#line 1440 "sql_yacc.yy"
    {
           Lex->mi.ssl_cipher= (yyvsp[0].lex_str).str;
         }
    break;

  case 82:
#line 1444 "sql_yacc.yy"
    {
           Lex->mi.ssl_key= (yyvsp[0].lex_str).str;
	 }
    break;

  case 84:
#line 1453 "sql_yacc.yy"
    {
	 Lex->mi.log_file_name = (yyvsp[0].lex_str).str;
       }
    break;

  case 85:
#line 1457 "sql_yacc.yy"
    {
           Lex->mi.pos = (yyvsp[0].ulonglong_number);
           /* 
              If the user specified a value < BIN_LOG_HEADER_SIZE, adjust it
              instead of causing subsequent errors. 
              We need to do it in this file, because only there we know that 
              MASTER_LOG_POS has been explicitely specified. On the contrary
              in change_master() (sql_repl.cc) we cannot distinguish between 0
              (MASTER_LOG_POS explicitely specified as 0) and 0 (unspecified),
              whereas we want to distinguish (specified 0 means "read the binlog
              from 0" (4 in fact), unspecified means "don't change the position
              (keep the preceding value)").
           */
           Lex->mi.pos = max(BIN_LOG_HEADER_SIZE, Lex->mi.pos);
         }
    break;

  case 86:
#line 1473 "sql_yacc.yy"
    {
           Lex->mi.relay_log_name = (yyvsp[0].lex_str).str;
         }
    break;

  case 87:
#line 1477 "sql_yacc.yy"
    {
           Lex->mi.relay_log_pos = (yyvsp[0].ulong_num);
           /* Adjust if < BIN_LOG_HEADER_SIZE (same comment as Lex->mi.pos) */
           Lex->mi.relay_log_pos = max(BIN_LOG_HEADER_SIZE, Lex->mi.relay_log_pos);
         }
    break;

  case 88:
#line 1488 "sql_yacc.yy"
    {
	  THD *thd= YYTHD;
	  LEX *lex=Lex;
	  lex->sql_command= SQLCOM_CREATE_TABLE;
	  if (!lex->select_lex.add_table_to_list(thd, (yyvsp[0].table), NULL,
						 TL_OPTION_UPDATING,
						 TL_WRITE))
	    MYSQL_YYABORT;
          lex->alter_info.reset();
	  lex->col_list.empty();
	  lex->change=NullS;
	  bzero((char*) &lex->create_info,sizeof(lex->create_info));
	  lex->create_info.options=(yyvsp[-3].num) | (yyvsp[-1].num);
	  lex->create_info.db_type= (enum db_type) lex->thd->variables.table_type;
	  lex->create_info.default_table_charset= NULL;
	}
    break;

  case 89:
#line 1505 "sql_yacc.yy"
    { Lex->current_select= &Lex->select_lex; }
    break;

  case 90:
#line 1507 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->sql_command= SQLCOM_CREATE_INDEX;
	    if (!lex->current_select->add_table_to_list(lex->thd, (yyvsp[0].table), NULL,
							TL_OPTION_UPDATING))
	      MYSQL_YYABORT;
            lex->alter_info.reset();
            lex->alter_info.flags= ALTER_ADD_INDEX;
	    lex->col_list.empty();
	    lex->change=NullS;
	  }
    break;

  case 91:
#line 1519 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            Key *key= new Key((yyvsp[-9].key_type), (yyvsp[-7].lex_str).str, (yyvsp[-6].key_alg), 0, lex->col_list);

            lex->alter_info.key_list.push_back(key);
	    lex->col_list.empty();
	  }
    break;

  case 92:
#line 1527 "sql_yacc.yy"
    {
             Lex->create_info.default_table_charset= NULL;
             Lex->create_info.used_fields= 0;
          }
    break;

  case 93:
#line 1532 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->sql_command=SQLCOM_CREATE_DB;
	    lex->name=(yyvsp[-2].lex_str).str;
            lex->create_info.options=(yyvsp[-3].num);
	  }
    break;

  case 94:
#line 1539 "sql_yacc.yy"
    {
            Lex->create_view_mode= VIEW_CREATE_NEW;
            Lex->create_view_algorithm= VIEW_ALGORITHM_UNDEFINED;
            Lex->create_view_suid= TRUE;
	  }
    break;

  case 95:
#line 1545 "sql_yacc.yy"
    {}
    break;

  case 96:
#line 1547 "sql_yacc.yy"
    {
	    Lex->sql_command = SQLCOM_CREATE_USER;
          }
    break;

  case 97:
#line 1554 "sql_yacc.yy"
    {
          LEX *lex=Lex;
          lex->users_list.empty();
          lex->columns.empty();
          lex->grant= lex->grant_tot_col= 0;
	  lex->all_privileges= 0;
          lex->select_lex.db= 0;
          lex->ssl_type= SSL_TYPE_NOT_SPECIFIED;
          lex->ssl_cipher= lex->x509_subject= lex->x509_issuer= 0;
          bzero((char *)&(lex->mqh),sizeof(lex->mqh));
        }
    break;

  case 98:
#line 1569 "sql_yacc.yy"
    {
            if (!(yyvsp[-2].lex_str).str || check_db_name((yyvsp[-2].lex_str).str))
            {
	      my_error(ER_WRONG_DB_NAME, MYF(0), (yyvsp[-2].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    if (check_routine_name((yyvsp[0].lex_str)))
            {
	      my_error(ER_SP_WRONG_NAME, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    (yyval.spname)= new sp_name((yyvsp[-2].lex_str), (yyvsp[0].lex_str), true);
	    (yyval.spname)->init_qname(YYTHD);
	  }
    break;

  case 99:
#line 1584 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            LEX_STRING db;
	    if (check_routine_name((yyvsp[0].lex_str)))
            {
	      my_error(ER_SP_WRONG_NAME, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
            if (lex->copy_db_to(&db.str, &db.length))
              MYSQL_YYABORT;
	    (yyval.spname)= new sp_name(db, (yyvsp[0].lex_str), false);
            if ((yyval.spname))
	      (yyval.spname)->init_qname(YYTHD);
	  }
    break;

  case 100:
#line 1602 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            if (lex->definer != NULL)
            {
              /*
                 DEFINER is a concept meaningful when interpreting SQL code.
                 UDF functions are compiled.
                 Using DEFINER with UDF has therefore no semantic,
                 and is considered a parsing error.
              */
	      my_error(ER_WRONG_USAGE, MYF(0), "SONAME", "DEFINER");
              MYSQL_YYABORT;
            }
	    lex->sql_command = SQLCOM_CREATE_FUNCTION;
	    lex->udf.name = lex->spname->m_name;
	    lex->udf.returns=(Item_result) (yyvsp[-2].num);
	    lex->udf.dl=(yyvsp[0].lex_str).str;
	  }
    break;

  case 101:
#line 1621 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
	    LEX *lex= thd->lex;
            Lex_input_stream *lip= thd->m_lip;
	    sp_head *sp;

            /* 
              First check if AGGREGATE was used, in that case it's a
              syntax error.
            */
            if (lex->udf.type == UDFTYPE_AGGREGATE)
            {
              my_error(ER_SP_NO_AGGREGATE, MYF(0));
              MYSQL_YYABORT;
            }

	    if (lex->sphead)
	    {
	      my_error(ER_SP_NO_RECURSIVE_CREATE, MYF(0), "FUNCTION");
	      MYSQL_YYABORT;
	    }
	    /* Order is important here: new - reset - init */
	    sp= new sp_head();
	    sp->reset_thd_mem_root(thd);
	    sp->init(lex);
            sp->init_sp_name(thd, lex->spname);

	    sp->m_type= TYPE_ENUM_FUNCTION;
	    lex->sphead= sp;
	    /*
	     * We have to turn of CLIENT_MULTI_QUERIES while parsing a
	     * stored procedure, otherwise yylex will chop it into pieces
	     * at each ';'.
	     */
	    sp->m_old_cmq= thd->client_capabilities & CLIENT_MULTI_QUERIES;
	    thd->client_capabilities &= ~CLIENT_MULTI_QUERIES;
	    lex->sphead->m_param_begin= lip->tok_start+1;
	  }
    break;

  case 102:
#line 1660 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
	    LEX *lex= thd->lex;
            Lex_input_stream *lip= thd->m_lip;

	    lex->sphead->m_param_end= lip->tok_start;
	  }
    break;

  case 103:
#line 1668 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    lex->charset= NULL;
	    lex->length= lex->dec= NULL;
	    lex->interval_list.empty();
	    lex->type= 0;
	  }
    break;

  case 104:
#line 1676 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

            if (sp->fill_field_definition(YYTHD, lex,
                                          (enum enum_field_types) (yyvsp[0].num),
                                          &sp->m_return_field_def))
              MYSQL_YYABORT;

	    bzero((char *)&lex->sp_chistics, sizeof(st_sp_chistics));
	  }
    break;

  case 105:
#line 1688 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
	    LEX *lex= thd->lex;
            Lex_input_stream *lip= thd->m_lip;

	    lex->sphead->m_chistics= &lex->sp_chistics;
	    lex->sphead->m_body_begin= lip->tok_start;
	  }
    break;

  case 106:
#line 1697 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

            if (sp->is_not_allowed_in_function("function"))
              MYSQL_YYABORT;

	    lex->sql_command= SQLCOM_CREATE_SPFUNCTION;
	    sp->init_strings(YYTHD, lex);
            if (!(sp->m_flags & sp_head::HAS_RETURN))
            {
              my_error(ER_SP_NORETURN, MYF(0), sp->m_qname.str);
              MYSQL_YYABORT;
            }
	    /* Restore flag if it was cleared above */
	    if (sp->m_old_cmq)
	      YYTHD->client_capabilities |= CLIENT_MULTI_QUERIES;
	    sp->restore_thd_mem_root(YYTHD);
	  }
    break;

  case 107:
#line 1719 "sql_yacc.yy"
    {}
    break;

  case 108:
#line 1720 "sql_yacc.yy"
    {}
    break;

  case 109:
#line 1724 "sql_yacc.yy"
    {}
    break;

  case 110:
#line 1725 "sql_yacc.yy"
    {}
    break;

  case 111:
#line 1731 "sql_yacc.yy"
    { Lex->sp_chistics.comment= (yyvsp[0].lex_str); }
    break;

  case 112:
#line 1733 "sql_yacc.yy"
    { /* Just parse it, we only have one language for now. */ }
    break;

  case 113:
#line 1735 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_NO_SQL; }
    break;

  case 114:
#line 1737 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_CONTAINS_SQL; }
    break;

  case 115:
#line 1739 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_READS_SQL_DATA; }
    break;

  case 116:
#line 1741 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_MODIFIES_SQL_DATA; }
    break;

  case 117:
#line 1743 "sql_yacc.yy"
    { }
    break;

  case 118:
#line 1748 "sql_yacc.yy"
    { }
    break;

  case 119:
#line 1749 "sql_yacc.yy"
    { Lex->sp_chistics.detistic= TRUE; }
    break;

  case 120:
#line 1750 "sql_yacc.yy"
    { Lex->sp_chistics.detistic= FALSE; }
    break;

  case 121:
#line 1755 "sql_yacc.yy"
    {
	    Lex->sp_chistics.suid= SP_IS_SUID;
	  }
    break;

  case 122:
#line 1759 "sql_yacc.yy"
    {
	    Lex->sp_chistics.suid= SP_IS_NOT_SUID;
	  }
    break;

  case 123:
#line 1766 "sql_yacc.yy"
    {
	    LEX *lex = Lex;

	    lex->sql_command= SQLCOM_CALL;
	    lex->spname= (yyvsp[0].spname);
	    lex->value_list.empty();
	    sp_add_used_routine(lex, YYTHD, (yyvsp[0].spname), TYPE_ENUM_PROCEDURE);
	  }
    break;

  case 124:
#line 1774 "sql_yacc.yy"
    {}
    break;

  case 129:
#line 1790 "sql_yacc.yy"
    {
	    Lex->value_list.push_back((yyvsp[0].item));
	  }
    break;

  case 130:
#line 1794 "sql_yacc.yy"
    {
	    Lex->value_list.push_back((yyvsp[0].item));
	  }
    break;

  case 135:
#line 1812 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->length= 0;
	    lex->dec= 0;
	    lex->type= 0;
	  
	    lex->default_value= 0;
	    lex->on_update_value= 0;
	  
	    lex->comment= null_lex_str;
	    lex->charset= NULL;
	  
	    lex->interval_list.empty();
	    lex->uint_geom_type= 0;
	  }
    break;

  case 136:
#line 1832 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[-2].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_PARAM, MYF(0), (yyvsp[-2].lex_str).str);
	      MYSQL_YYABORT;
	    }
            sp_variable_t *spvar= spc->push_variable(&(yyvsp[-2].lex_str),
                                                     (enum enum_field_types)(yyvsp[0].num),
                                                     sp_param_in);

            if (lex->sphead->fill_field_definition(YYTHD, lex,
                                                   (enum enum_field_types) (yyvsp[0].num),
                                                   &spvar->field_def))
            {
              MYSQL_YYABORT;
            }
            spvar->field_def.field_name= spvar->name.str;
            spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
	  }
    break;

  case 141:
#line 1869 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[-1].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_PARAM, MYF(0), (yyvsp[-1].lex_str).str);
	      MYSQL_YYABORT;
	    }
            sp_variable_t *spvar= spc->push_variable(&(yyvsp[-1].lex_str),
                                                     (enum enum_field_types)(yyvsp[0].num),
                                                     (sp_param_mode_t)(yyvsp[-3].num));

            if (lex->sphead->fill_field_definition(YYTHD, lex,
                                                   (enum enum_field_types) (yyvsp[0].num),
                                                   &spvar->field_def))
            {
              MYSQL_YYABORT;
            }
            spvar->field_def.field_name= spvar->name.str;
            spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
	  }
    break;

  case 142:
#line 1894 "sql_yacc.yy"
    { (yyval.num)= sp_param_in; }
    break;

  case 143:
#line 1895 "sql_yacc.yy"
    { (yyval.num)= sp_param_in; }
    break;

  case 144:
#line 1896 "sql_yacc.yy"
    { (yyval.num)= sp_param_out; }
    break;

  case 145:
#line 1897 "sql_yacc.yy"
    { (yyval.num)= sp_param_inout; }
    break;

  case 146:
#line 1901 "sql_yacc.yy"
    {}
    break;

  case 148:
#line 1906 "sql_yacc.yy"
    {}
    break;

  case 150:
#line 1912 "sql_yacc.yy"
    {
	    (yyval.spblock).vars= (yyval.spblock).conds= (yyval.spblock).hndlrs= (yyval.spblock).curs= 0;
	  }
    break;

  case 151:
#line 1916 "sql_yacc.yy"
    {
	    /* We check for declarations out of (standard) order this way
	       because letting the grammar rules reflect it caused tricky
	       shift/reduce conflicts with the wrong result. (And we get
	       better error handling this way.) */
	    if (((yyvsp[-1].spblock).vars || (yyvsp[-1].spblock).conds) && ((yyvsp[-2].spblock).curs || (yyvsp[-2].spblock).hndlrs))
	    { /* Variable or condition following cursor or handler */
	      my_message(ER_SP_VARCOND_AFTER_CURSHNDLR,
                         ER(ER_SP_VARCOND_AFTER_CURSHNDLR), MYF(0));
	      MYSQL_YYABORT;
	    }
	    if ((yyvsp[-1].spblock).curs && (yyvsp[-2].spblock).hndlrs)
	    { /* Cursor following handler */
	      my_message(ER_SP_CURSOR_AFTER_HANDLER,
                         ER(ER_SP_CURSOR_AFTER_HANDLER), MYF(0));
	      MYSQL_YYABORT;
	    }
	    (yyval.spblock).vars= (yyvsp[-2].spblock).vars + (yyvsp[-1].spblock).vars;
	    (yyval.spblock).conds= (yyvsp[-2].spblock).conds + (yyvsp[-1].spblock).conds;
	    (yyval.spblock).hndlrs= (yyvsp[-2].spblock).hndlrs + (yyvsp[-1].spblock).hndlrs;
	    (yyval.spblock).curs= (yyvsp[-2].spblock).curs + (yyvsp[-1].spblock).curs;
	  }
    break;

  case 152:
#line 1942 "sql_yacc.yy"
    {
            LEX *lex= Lex;

            lex->sphead->reset_lex(YYTHD);
            lex->spcont->declare_var_boundary((yyvsp[0].num));
          }
    break;

  case 153:
#line 1950 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            sp_pcontext *pctx= lex->spcont;
            uint num_vars= pctx->context_var_count();
            enum enum_field_types var_type= (enum enum_field_types) (yyvsp[-1].num);
            Item *dflt_value_item= (yyvsp[0].item);
            
            if (!dflt_value_item)
            {
              dflt_value_item= new Item_null();
              /* QQ Set to the var_type with null_value? */
            }
            
            for (uint i = num_vars-(yyvsp[-3].num) ; i < num_vars ; i++)
            {
              uint var_idx= pctx->var_context2runtime(i);
              sp_variable_t *spvar= pctx->find_variable(var_idx);
            
              if (!spvar)
                MYSQL_YYABORT;
            
              spvar->type= var_type;
              spvar->dflt= dflt_value_item;
            
              if (lex->sphead->fill_field_definition(YYTHD, lex, var_type,
                                                     &spvar->field_def))
              {
                MYSQL_YYABORT;
              }
            
              spvar->field_def.field_name= spvar->name.str;
              spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
            
              /* The last instruction is responsible for freeing LEX. */

              lex->sphead->add_instr(
                new sp_instr_set(lex->sphead->instructions(), pctx, var_idx,
                                 dflt_value_item, var_type, lex,
                                 (i == num_vars - 1)));
            }

            pctx->declare_var_boundary(0);
            lex->sphead->restore_lex(YYTHD);

            (yyval.spblock).vars= (yyvsp[-3].num);
            (yyval.spblock).conds= (yyval.spblock).hndlrs= (yyval.spblock).curs= 0;
          }
    break;

  case 154:
#line 1998 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_cond(&(yyvsp[-3].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_COND, MYF(0), (yyvsp[-3].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    YYTHD->lex->spcont->push_cond(&(yyvsp[-3].lex_str), (yyvsp[0].spcondtype));
	    (yyval.spblock).vars= (yyval.spblock).hndlrs= (yyval.spblock).curs= 0;
	    (yyval.spblock).conds= 1;
	  }
    break;

  case 155:
#line 2012 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

            lex->spcont= lex->spcont->push_context(LABEL_HANDLER_SCOPE);

	    sp_pcontext *ctx= lex->spcont;
	    sp_instr_hpush_jump *i=
              new sp_instr_hpush_jump(sp->instructions(), ctx, (yyvsp[-2].num),
	                              ctx->current_var_count());

	    sp->add_instr(i);
	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
	  }
    break;

  case 156:
#line 2027 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *hlab= lex->spcont->pop_label(); /* After this hdlr */
	    sp_instr_hreturn *i;

	    if ((yyvsp[-5].num) == SP_HANDLER_CONTINUE)
	    {
	      i= new sp_instr_hreturn(sp->instructions(), ctx,
	                              ctx->current_var_count());
	      sp->add_instr(i);
	    }
	    else
	    {  /* EXIT or UNDO handler, just jump to the end of the block */
	      i= new sp_instr_hreturn(sp->instructions(), ctx, 0);

	      sp->add_instr(i);
	      sp->push_backpatch(i, lex->spcont->last_label()); /* Block end */
	    }
	    lex->sphead->backpatch(hlab);

            lex->spcont= ctx->pop_context();

	    (yyval.spblock).vars= (yyval.spblock).conds= (yyval.spblock).curs= 0;
	    (yyval.spblock).hndlrs= (yyvsp[-1].num);
	    lex->spcont->add_handlers((yyvsp[-1].num));
	  }
    break;

  case 157:
#line 2056 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    uint offp;
	    sp_instr_cpush *i;

	    if (ctx->find_cursor(&(yyvsp[-3].lex_str), &offp, TRUE))
	    {
	      my_error(ER_SP_DUP_CURS, MYF(0), (yyvsp[-3].lex_str).str);
	      delete (yyvsp[0].lex);
	      MYSQL_YYABORT;
	    }
            i= new sp_instr_cpush(sp->instructions(), ctx, (yyvsp[0].lex),
                                  ctx->current_cursor_count());
	    sp->add_instr(i);
	    ctx->push_cursor(&(yyvsp[-3].lex_str));
	    (yyval.spblock).vars= (yyval.spblock).conds= (yyval.spblock).hndlrs= 0;
	    (yyval.spblock).curs= 1;
	  }
    break;

  case 158:
#line 2079 "sql_yacc.yy"
    {
	    Lex->sphead->reset_lex(YYTHD);

	    /* We use statement here just be able to get a better
	       error message. Using 'select' works too, but will then
	       result in a generic "syntax error" if a non-select
	       statement is given. */
	  }
    break;

  case 159:
#line 2088 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    if (lex->sql_command != SQLCOM_SELECT)
	    {
	      my_message(ER_SP_BAD_CURSOR_QUERY, ER(ER_SP_BAD_CURSOR_QUERY),
                         MYF(0));
	      MYSQL_YYABORT;
	    }
	    if (lex->result)
	    {
	      my_message(ER_SP_BAD_CURSOR_SELECT, ER(ER_SP_BAD_CURSOR_SELECT),
                         MYF(0));
	      MYSQL_YYABORT;
	    }
	    lex->sp_lex_in_use= TRUE;
	    (yyval.lex)= lex;
	    lex->sphead->restore_lex(YYTHD);
	  }
    break;

  case 160:
#line 2110 "sql_yacc.yy"
    { (yyval.num)= SP_HANDLER_EXIT; }
    break;

  case 161:
#line 2111 "sql_yacc.yy"
    { (yyval.num)= SP_HANDLER_CONTINUE; }
    break;

  case 162:
#line 2117 "sql_yacc.yy"
    { (yyval.num)= 1; }
    break;

  case 163:
#line 2119 "sql_yacc.yy"
    { (yyval.num)+= 1; }
    break;

  case 164:
#line 2124 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont->parent_context();

	    if (ctx->find_handler((yyvsp[0].spcondtype)))
	    {
	      my_message(ER_SP_DUP_HANDLER, ER(ER_SP_DUP_HANDLER), MYF(0));
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_hpush_jump *i=
                (sp_instr_hpush_jump *)sp->last_instruction();

	      i->add_condition((yyvsp[0].spcondtype));
	      ctx->push_handler((yyvsp[0].spcondtype));
	    }
	  }
    break;

  case 165:
#line 2147 "sql_yacc.yy"
    {			/* mysql errno */
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::number;
	    (yyval.spcondtype)->mysqlerr= (yyvsp[0].ulong_num);
	  }
    break;

  case 166:
#line 2153 "sql_yacc.yy"
    {		/* SQLSTATE */
	    if (!sp_cond_check(&(yyvsp[0].lex_str)))
	    {
	      my_error(ER_SP_BAD_SQLSTATE, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::state;
	    memcpy((yyval.spcondtype)->sqlstate, (yyvsp[0].lex_str).str, 5);
	    (yyval.spcondtype)->sqlstate[5]= '\0';
	  }
    break;

  case 167:
#line 2167 "sql_yacc.yy"
    {}
    break;

  case 168:
#line 2168 "sql_yacc.yy"
    {}
    break;

  case 169:
#line 2173 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (yyvsp[0].spcondtype);
	  }
    break;

  case 170:
#line 2177 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= Lex->spcont->find_cond(&(yyvsp[0].lex_str));
	    if ((yyval.spcondtype) == NULL)
	    {
	      my_error(ER_SP_COND_MISMATCH, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	  }
    break;

  case 171:
#line 2186 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::warning;
	  }
    break;

  case 172:
#line 2191 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::notfound;
	  }
    break;

  case 173:
#line 2196 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::exception;
	  }
    break;

  case 174:
#line 2204 "sql_yacc.yy"
    {
            /* NOTE: field definition is filled in sp_decl section. */

	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[0].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_VAR, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    spc->push_variable(&(yyvsp[0].lex_str), (enum_field_types)0, sp_param_in);
	    (yyval.num)= 1;
	  }
    break;

  case 175:
#line 2219 "sql_yacc.yy"
    {
            /* NOTE: field definition is filled in sp_decl section. */

	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[0].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_VAR, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    spc->push_variable(&(yyvsp[0].lex_str), (enum_field_types)0, sp_param_in);
	    (yyval.num)= (yyvsp[-2].num) + 1;
	  }
    break;

  case 176:
#line 2236 "sql_yacc.yy"
    { (yyval.item) = NULL; }
    break;

  case 177:
#line 2237 "sql_yacc.yy"
    { (yyval.item) = (yyvsp[0].item); }
    break;

  case 178:
#line 2241 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
	    LEX *lex= thd->lex;
            Lex_input_stream *lip= thd->m_lip;

	    lex->sphead->reset_lex(thd);
	    lex->sphead->m_tmp_query= lip->tok_start;
	  }
    break;

  case 179:
#line 2250 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
	    LEX *lex= thd->lex;
            Lex_input_stream *lip= thd->m_lip;
	    sp_head *sp= lex->sphead;

            sp->m_flags|= sp_get_flags_for_command(lex);
	    if (lex->sql_command == SQLCOM_CHANGE_DB)
	    { /* "USE db" doesn't work in a procedure */
	      my_error(ER_SP_BADSTATEMENT, MYF(0), "USE");
	      MYSQL_YYABORT;
	    }
	    /*
              Don't add an instruction for SET statements, since all
              instructions for them were already added during processing
              of "set" rule.
	    */
            DBUG_ASSERT(lex->sql_command != SQLCOM_SET_OPTION ||
                        lex->var_list.is_empty());
            if (lex->sql_command != SQLCOM_SET_OPTION)
	    {
              sp_instr_stmt *i=new sp_instr_stmt(sp->instructions(),
                                                 lex->spcont, lex);

              /*
                Extract the query statement from the tokenizer.  The
                end is either lex->ptr, if there was no lookahead,
                lex->tok_end otherwise.
              */
              if (yychar == YYEMPTY)
                i->m_query.length= lip->ptr - sp->m_tmp_query;
              else
                i->m_query.length= lip->tok_end - sp->m_tmp_query;
              i->m_query.str= strmake_root(thd->mem_root,
                                           sp->m_tmp_query,
                                           i->m_query.length);
              sp->add_instr(i);
            }
	    sp->restore_lex(thd);
          }
    break;

  case 180:
#line 2291 "sql_yacc.yy"
    { Lex->sphead->reset_lex(YYTHD); }
    break;

  case 181:
#line 2293 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

	    if (sp->m_type != TYPE_ENUM_FUNCTION)
	    {
	      my_message(ER_SP_BADRETURN, ER(ER_SP_BADRETURN), MYF(0));
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_freturn *i;

	      i= new sp_instr_freturn(sp->instructions(), lex->spcont, (yyvsp[0].item),
                                      sp->m_return_field_def.sql_type, lex);
	      sp->add_instr(i);
	      sp->m_flags|= sp_head::HAS_RETURN;
	    }
	    sp->restore_lex(YYTHD);
	  }
    break;

  case 182:
#line 2314 "sql_yacc.yy"
    { Lex->sphead->new_cont_backpatch(NULL); }
    break;

  case 183:
#line 2316 "sql_yacc.yy"
    { Lex->sphead->do_cont_backpatch(); }
    break;

  case 185:
#line 2319 "sql_yacc.yy"
    {}
    break;

  case 186:
#line 2320 "sql_yacc.yy"
    { /* Unlabeled controls get a secret label. */
	    LEX *lex= Lex;

	    lex->spcont->push_label((char *)"", lex->sphead->instructions());
	  }
    break;

  case 187:
#line 2326 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 188:
#line 2332 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp = lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label((yyvsp[0].lex_str).str);

	    if (! lab)
	    {
	      my_error(ER_SP_LILABEL_MISMATCH, MYF(0), "LEAVE", (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_jump *i;
	      uint ip= sp->instructions();
	      uint n;

	      n= ctx->diff_handlers(lab->ctx, TRUE);  /* Exclusive the dest. */
	      if (n)
	        sp->add_instr(new sp_instr_hpop(ip++, ctx, n));
	      n= ctx->diff_cursors(lab->ctx, TRUE);  /* Exclusive the dest. */
	      if (n)
	        sp->add_instr(new sp_instr_cpop(ip++, ctx, n));
	      i= new sp_instr_jump(ip, ctx);
	      sp->push_backpatch(i, lab);  /* Jumping forward */
              sp->add_instr(i);
	    }
	  }
    break;

  case 189:
#line 2361 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label((yyvsp[0].lex_str).str);

	    if (! lab || lab->type != SP_LAB_ITER)
	    {
	      my_error(ER_SP_LILABEL_MISMATCH, MYF(0), "ITERATE", (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_jump *i;
	      uint ip= sp->instructions();
	      uint n;

	      n= ctx->diff_handlers(lab->ctx, FALSE);  /* Inclusive the dest. */
	      if (n)
	        sp->add_instr(new sp_instr_hpop(ip++, ctx, n));
	      n= ctx->diff_cursors(lab->ctx, FALSE);  /* Inclusive the dest. */
	      if (n)
	        sp->add_instr(new sp_instr_cpop(ip++, ctx, n));
	      i= new sp_instr_jump(ip, ctx, lab->ip); /* Jump back */
              sp->add_instr(i);
	    }
	  }
    break;

  case 190:
#line 2389 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_copen *i;

	    if (! lex->spcont->find_cursor(&(yyvsp[0].lex_str), &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    i= new sp_instr_copen(sp->instructions(), lex->spcont, offset);
	    sp->add_instr(i);
	  }
    break;

  case 191:
#line 2404 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_cfetch *i;

	    if (! lex->spcont->find_cursor(&(yyvsp[-1].lex_str), &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), (yyvsp[-1].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    i= new sp_instr_cfetch(sp->instructions(), lex->spcont, offset);
	    sp->add_instr(i);
	  }
    break;

  case 192:
#line 2419 "sql_yacc.yy"
    { }
    break;

  case 193:
#line 2421 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_cclose *i;

	    if (! lex->spcont->find_cursor(&(yyvsp[0].lex_str), &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    i= new sp_instr_cclose(sp->instructions(), lex->spcont,  offset);
	    sp->add_instr(i);
	  }
    break;

  case 197:
#line 2445 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *spc= lex->spcont;
	    sp_variable_t *spv;

	    if (!spc || !(spv = spc->find_variable(&(yyvsp[0].lex_str))))
	    {
	      my_error(ER_SP_UNDECLARED_VAR, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      /* An SP local variable */
	      sp_instr_cfetch *i= (sp_instr_cfetch *)sp->last_instruction();

	      i->add_to_varlist(spv);
	    }
	  }
    break;

  case 198:
#line 2466 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *spc= lex->spcont;
	    sp_variable_t *spv;

	    if (!spc || !(spv = spc->find_variable(&(yyvsp[0].lex_str))))
	    {
	      my_error(ER_SP_UNDECLARED_VAR, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      /* An SP local variable */
	      sp_instr_cfetch *i= (sp_instr_cfetch *)sp->last_instruction();

	      i->add_to_varlist(spv);
	    }
	  }
    break;

  case 199:
#line 2488 "sql_yacc.yy"
    { Lex->sphead->reset_lex(YYTHD); }
    break;

  case 200:
#line 2490 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    uint ip= sp->instructions();
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, ctx,
                                                               (yyvsp[-1].item), lex);

	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
            sp->add_cont_backpatch(i);
            sp->add_instr(i);
            sp->restore_lex(YYTHD);
	  }
    break;

  case 201:
#line 2504 "sql_yacc.yy"
    {
	    sp_head *sp= Lex->sphead;
	    sp_pcontext *ctx= Lex->spcont;
	    uint ip= sp->instructions();
	    sp_instr_jump *i = new sp_instr_jump(ip, ctx);

	    sp->add_instr(i);
	    sp->backpatch(ctx->pop_label());
	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
	  }
    break;

  case 202:
#line 2515 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 208:
#line 2535 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_case(lex);
            lex->sphead->reset_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 209:
#line 2541 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            if (case_stmt_action_expr(lex, (yyvsp[0].item)))
              MYSQL_YYABORT;

            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 210:
#line 2552 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_end_case(lex, true);
          }
    break;

  case 211:
#line 2560 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_case(lex);
          }
    break;

  case 212:
#line 2568 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_end_case(lex, false);
          }
    break;

  case 217:
#line 2586 "sql_yacc.yy"
    {
            Lex->sphead->reset_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 218:
#line 2590 "sql_yacc.yy"
    {
            /* Simple case: <caseval> = <whenval> */

            LEX *lex= Lex;
            case_stmt_action_when(lex, (yyvsp[0].item), true);
            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 219:
#line 2599 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_then(lex);
          }
    break;

  case 220:
#line 2607 "sql_yacc.yy"
    {
            Lex->sphead->reset_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 221:
#line 2611 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_when(lex, (yyvsp[0].item), false);
            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 222:
#line 2618 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_then(lex);
          }
    break;

  case 223:
#line 2626 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            sp_head *sp= lex->sphead;
            uint ip= sp->instructions();
            sp_instr_error *i= new sp_instr_error(ip, lex->spcont,
                                                  ER_SP_CASE_NOT_FOUND);
            sp->add_instr(i);
          }
    break;

  case 225:
#line 2639 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label((yyvsp[-1].lex_str).str);

	    if (lab)
	    {
	      my_error(ER_SP_LABEL_REDEFINE, MYF(0), (yyvsp[-1].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      lab= lex->spcont->push_label((yyvsp[-1].lex_str).str,
	                                   lex->sphead->instructions());
	      lab->type= SP_LAB_ITER;
	    }
	  }
    break;

  case 226:
#line 2657 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    if ((yyvsp[0].lex_str).str)
	    {
	      sp_label_t *lab= lex->spcont->find_label((yyvsp[0].lex_str).str);

	      if (!lab ||
	          my_strcasecmp(system_charset_info, (yyvsp[0].lex_str).str, lab->name) != 0)
	      {
	        my_error(ER_SP_LABEL_MISMATCH, MYF(0), (yyvsp[0].lex_str).str);
	        MYSQL_YYABORT;
	      }
	    }
	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 227:
#line 2676 "sql_yacc.yy"
    { (yyval.lex_str)= null_lex_str; }
    break;

  case 228:
#line 2677 "sql_yacc.yy"
    { (yyval.lex_str)= (yyvsp[0].lex_str); }
    break;

  case 229:
#line 2682 "sql_yacc.yy"
    { /* QQ This is just a dummy for grouping declarations and statements
	       together. No [[NOT] ATOMIC] yet, and we need to figure out how
	       make it coexist with the existing BEGIN COMMIT/ROLLBACK. */
	    LEX *lex= Lex;
	    sp_label_t *lab= lex->spcont->last_label();

	    lab->type= SP_LAB_BEGIN;
	    lex->spcont= lex->spcont->push_context(LABEL_DEFAULT_SCOPE);
	  }
    break;

  case 230:
#line 2694 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;

  	    sp->backpatch(ctx->last_label());	/* We always have a label */
	    if ((yyvsp[-2].spblock).hndlrs)
	      sp->add_instr(new sp_instr_hpop(sp->instructions(), ctx,
					      (yyvsp[-2].spblock).hndlrs));
	    if ((yyvsp[-2].spblock).curs)
	      sp->add_instr(new sp_instr_cpop(sp->instructions(), ctx,
					      (yyvsp[-2].spblock).curs));
	    lex->spcont= ctx->pop_context();
	  }
    break;

  case 231:
#line 2710 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump *i = new sp_instr_jump(ip, lex->spcont, lab->ip);

	    lex->sphead->add_instr(i);
	  }
    break;

  case 232:
#line 2719 "sql_yacc.yy"
    { Lex->sphead->reset_lex(YYTHD); }
    break;

  case 233:
#line 2721 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint ip= sp->instructions();
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, lex->spcont,
							       (yyvsp[-1].item), lex);

	    /* Jumping forward */
	    sp->push_backpatch(i, lex->spcont->last_label());
            sp->new_cont_backpatch(i);
            sp->add_instr(i);
            sp->restore_lex(YYTHD);
	  }
    break;

  case 234:
#line 2735 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump *i = new sp_instr_jump(ip, lex->spcont, lab->ip);

	    lex->sphead->add_instr(i);
            lex->sphead->do_cont_backpatch();
	  }
    break;

  case 235:
#line 2745 "sql_yacc.yy"
    { Lex->sphead->reset_lex(YYTHD); }
    break;

  case 236:
#line 2747 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, lex->spcont,
                                                               (yyvsp[-2].item), lab->ip,
                                                               lex);
            lex->sphead->add_instr(i);
            lex->sphead->restore_lex(YYTHD);
            /* We can shortcut the cont_backpatch here */
            i->m_cont_dest= ip+1;
	  }
    break;

  case 237:
#line 2763 "sql_yacc.yy"
    { Lex->trg_chistics.action_time= TRG_ACTION_BEFORE; }
    break;

  case 238:
#line 2765 "sql_yacc.yy"
    { Lex->trg_chistics.action_time= TRG_ACTION_AFTER; }
    break;

  case 239:
#line 2770 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_INSERT; }
    break;

  case 240:
#line 2772 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_UPDATE; }
    break;

  case 241:
#line 2774 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_DELETE; }
    break;

  case 242:
#line 2778 "sql_yacc.yy"
    {}
    break;

  case 243:
#line 2779 "sql_yacc.yy"
    {}
    break;

  case 244:
#line 2781 "sql_yacc.yy"
    {
            Lex->create_info.options|= HA_LEX_CREATE_TABLE_LIKE;
            if (!Lex->select_lex.add_table_to_list(YYTHD, (yyvsp[0].table), NULL, 0, TL_READ))
              MYSQL_YYABORT;
          }
    break;

  case 245:
#line 2787 "sql_yacc.yy"
    {
            Lex->create_info.options|= HA_LEX_CREATE_TABLE_LIKE;
            if (!Lex->select_lex.add_table_to_list(YYTHD, (yyvsp[-1].table), NULL, 0, TL_READ))
              MYSQL_YYABORT;
          }
    break;

  case 246:
#line 2795 "sql_yacc.yy"
    {}
    break;

  case 247:
#line 2796 "sql_yacc.yy"
    { Select->set_braces(1);}
    break;

  case 248:
#line 2796 "sql_yacc.yy"
    {}
    break;

  case 249:
#line 2800 "sql_yacc.yy"
    {}
    break;

  case 250:
#line 2802 "sql_yacc.yy"
    { Select->set_braces(0);}
    break;

  case 251:
#line 2802 "sql_yacc.yy"
    {}
    break;

  case 252:
#line 2804 "sql_yacc.yy"
    { Select->set_braces(1);}
    break;

  case 253:
#line 2804 "sql_yacc.yy"
    {}
    break;

  case 254:
#line 2809 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->lock_option= using_update_log ? TL_READ_NO_INSERT : TL_READ;
	    if (lex->sql_command == SQLCOM_INSERT)
	      lex->sql_command= SQLCOM_INSERT_SELECT;
	    else if (lex->sql_command == SQLCOM_REPLACE)
	      lex->sql_command= SQLCOM_REPLACE_SELECT;
	    /*
              The following work only with the local list, the global list
              is created correctly in this case
	    */
	    lex->current_select->table_list.save_and_clear(&lex->save_list);
	    mysql_init_select(lex);
	    lex->current_select->parsing_place= SELECT_LIST;
          }
    break;

  case 255:
#line 2825 "sql_yacc.yy"
    {
	    Select->parsing_place= NO_MATTER;
	  }
    break;

  case 256:
#line 2829 "sql_yacc.yy"
    {
	    /*
              The following work only with the local list, the global list
              is created correctly in this case
	    */
	    Lex->current_select->table_list.push_front(&Lex->save_list);
	  }
    break;

  case 257:
#line 2839 "sql_yacc.yy"
    {}
    break;

  case 258:
#line 2840 "sql_yacc.yy"
    {}
    break;

  case 259:
#line 2843 "sql_yacc.yy"
    {}
    break;

  case 260:
#line 2844 "sql_yacc.yy"
    {}
    break;

  case 261:
#line 2847 "sql_yacc.yy"
    {}
    break;

  case 262:
#line 2848 "sql_yacc.yy"
    {}
    break;

  case 263:
#line 2851 "sql_yacc.yy"
    {}
    break;

  case 264:
#line 2852 "sql_yacc.yy"
    {}
    break;

  case 265:
#line 2855 "sql_yacc.yy"
    { (yyval.num)= 0; }
    break;

  case 266:
#line 2856 "sql_yacc.yy"
    { (yyval.num)= (yyvsp[0].num);}
    break;

  case 267:
#line 2859 "sql_yacc.yy"
    { (yyval.num)=(yyvsp[0].num); }
    break;

  case 268:
#line 2860 "sql_yacc.yy"
    { (yyval.num)= (yyvsp[-1].num) | (yyvsp[0].num); }
    break;

  case 269:
#line 2863 "sql_yacc.yy"
    { (yyval.num)=HA_LEX_CREATE_TMP_TABLE; }
    break;

  case 270:
#line 2866 "sql_yacc.yy"
    { (yyval.num)= 0; }
    break;

  case 271:
#line 2867 "sql_yacc.yy"
    { (yyval.num)=HA_LEX_CREATE_IF_NOT_EXISTS; }
    break;

  case 279:
#line 2883 "sql_yacc.yy"
    { Lex->create_info.db_type= (yyvsp[0].db_type); Lex->create_info.used_fields|= HA_CREATE_USED_ENGINE; }
    break;

  case 280:
#line 2884 "sql_yacc.yy"
    { Lex->create_info.db_type= (yyvsp[0].db_type); WARN_DEPRECATED("TYPE=storage_engine","ENGINE=storage_engine");   Lex->create_info.used_fields|= HA_CREATE_USED_ENGINE; }
    break;

  case 281:
#line 2885 "sql_yacc.yy"
    { Lex->create_info.max_rows= (yyvsp[0].ulonglong_number); Lex->create_info.used_fields|= HA_CREATE_USED_MAX_ROWS;}
    break;

  case 282:
#line 2886 "sql_yacc.yy"
    { Lex->create_info.min_rows= (yyvsp[0].ulonglong_number); Lex->create_info.used_fields|= HA_CREATE_USED_MIN_ROWS;}
    break;

  case 283:
#line 2887 "sql_yacc.yy"
    { Lex->create_info.avg_row_length=(yyvsp[0].ulong_num); Lex->create_info.used_fields|= HA_CREATE_USED_AVG_ROW_LENGTH;}
    break;

  case 284:
#line 2888 "sql_yacc.yy"
    { Lex->create_info.password=(yyvsp[0].lex_str).str; Lex->create_info.used_fields|= HA_CREATE_USED_PASSWORD; }
    break;

  case 285:
#line 2889 "sql_yacc.yy"
    { Lex->create_info.comment=(yyvsp[0].lex_str); Lex->create_info.used_fields|= HA_CREATE_USED_COMMENT; }
    break;

  case 286:
#line 2890 "sql_yacc.yy"
    { Lex->create_info.auto_increment_value=(yyvsp[0].ulonglong_number); Lex->create_info.used_fields|= HA_CREATE_USED_AUTO;}
    break;

  case 287:
#line 2892 "sql_yacc.yy"
    {
            switch((yyvsp[0].ulong_num)) {
            case 0:
                Lex->create_info.table_options|= HA_OPTION_NO_PACK_KEYS;
                break;
            case 1:
                Lex->create_info.table_options|= HA_OPTION_PACK_KEYS;
                break;
            default:
                my_parse_error(ER(ER_SYNTAX_ERROR));
                MYSQL_YYABORT;
            }
            Lex->create_info.used_fields|= HA_CREATE_USED_PACK_KEYS;
          }
    break;

  case 288:
#line 2907 "sql_yacc.yy"
    {
            Lex->create_info.table_options&=
              ~(HA_OPTION_PACK_KEYS | HA_OPTION_NO_PACK_KEYS);
            Lex->create_info.used_fields|= HA_CREATE_USED_PACK_KEYS;
          }
    break;

  case 289:
#line 2912 "sql_yacc.yy"
    { Lex->create_info.table_options|= (yyvsp[0].ulong_num) ? HA_OPTION_CHECKSUM : HA_OPTION_NO_CHECKSUM; Lex->create_info.used_fields|= HA_CREATE_USED_CHECKSUM; }
    break;

  case 290:
#line 2913 "sql_yacc.yy"
    { Lex->create_info.table_options|= (yyvsp[0].ulong_num) ? HA_OPTION_DELAY_KEY_WRITE : HA_OPTION_NO_DELAY_KEY_WRITE;  Lex->create_info.used_fields|= HA_CREATE_USED_DELAY_KEY_WRITE; }
    break;

  case 291:
#line 2914 "sql_yacc.yy"
    { Lex->create_info.row_type= (yyvsp[0].row_type);  Lex->create_info.used_fields|= HA_CREATE_USED_ROW_FORMAT; }
    break;

  case 292:
#line 2916 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_TYPE", "PARTITION");
	    MYSQL_YYABORT;
	  }
    break;

  case 293:
#line 2921 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_CHUNKS", "PARTITION");
	    MYSQL_YYABORT;
	  }
    break;

  case 294:
#line 2926 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_CHUNKSIZE", "PARTITION");
	    MYSQL_YYABORT;
	  }
    break;

  case 295:
#line 2931 "sql_yacc.yy"
    {
	    /* Move the union list to the merge_list */
	    LEX *lex=Lex;
	    TABLE_LIST *table_list= lex->select_lex.get_table_list();
	    lex->create_info.merge_list= lex->select_lex.table_list;
	    lex->create_info.merge_list.elements--;
	    lex->create_info.merge_list.first=
	      (byte*) (table_list->next_local);
	    lex->select_lex.table_list.elements=1;
	    lex->select_lex.table_list.next=
	      (byte**) &(table_list->next_local);
	    table_list->next_local= 0;
	    lex->create_info.used_fields|= HA_CREATE_USED_UNION;
	  }
    break;

  case 298:
#line 2947 "sql_yacc.yy"
    { Lex->create_info.merge_insert_method= (yyvsp[0].ulong_num); Lex->create_info.used_fields|= HA_CREATE_USED_INSERT_METHOD;}
    break;

  case 299:
#line 2948 "sql_yacc.yy"
    { Lex->create_info.data_file_name= (yyvsp[0].lex_str).str; Lex->create_info.used_fields|= HA_CREATE_USED_DATADIR; }
    break;

  case 300:
#line 2949 "sql_yacc.yy"
    { Lex->create_info.index_file_name= (yyvsp[0].lex_str).str;  Lex->create_info.used_fields|= HA_CREATE_USED_INDEXDIR; }
    break;

  case 301:
#line 2950 "sql_yacc.yy"
    { Lex->create_info.connect_string.str= (yyvsp[0].lex_str).str; Lex->create_info.connect_string.length= (yyvsp[0].lex_str).length;  Lex->create_info.used_fields|= HA_CREATE_USED_CONNECTION; }
    break;

  case 302:
#line 2955 "sql_yacc.yy"
    {
          HA_CREATE_INFO *cinfo= &Lex->create_info;
          if ((cinfo->used_fields & HA_CREATE_USED_DEFAULT_CHARSET) &&
               cinfo->default_table_charset && (yyvsp[0].charset) &&
               !my_charset_same(cinfo->default_table_charset,(yyvsp[0].charset)))
          {
            my_error(ER_CONFLICTING_DECLARATIONS, MYF(0),
                     "CHARACTER SET ", cinfo->default_table_charset->csname,
                     "CHARACTER SET ", (yyvsp[0].charset)->csname);
            MYSQL_YYABORT;
          }
	  Lex->create_info.default_table_charset= (yyvsp[0].charset);
          Lex->create_info.used_fields|= HA_CREATE_USED_DEFAULT_CHARSET;
        }
    break;

  case 303:
#line 2972 "sql_yacc.yy"
    {
          HA_CREATE_INFO *cinfo= &Lex->create_info;
          if ((cinfo->used_fields & HA_CREATE_USED_DEFAULT_CHARSET) &&
               cinfo->default_table_charset && (yyvsp[0].charset) &&
               !my_charset_same(cinfo->default_table_charset,(yyvsp[0].charset)))
            {
              my_error(ER_COLLATION_CHARSET_MISMATCH, MYF(0),
                       (yyvsp[0].charset)->name, cinfo->default_table_charset->csname);
              MYSQL_YYABORT;
            }
            Lex->create_info.default_table_charset= (yyvsp[0].charset);
            Lex->create_info.used_fields|= HA_CREATE_USED_DEFAULT_CHARSET;
        }
    break;

  case 304:
#line 2988 "sql_yacc.yy"
    {
	  (yyval.db_type) = ha_resolve_by_name((yyvsp[0].lex_str).str,(yyvsp[0].lex_str).length);
	  if ((yyval.db_type) == DB_TYPE_UNKNOWN) {
	    my_error(ER_UNKNOWN_STORAGE_ENGINE, MYF(0), (yyvsp[0].lex_str).str);
	    MYSQL_YYABORT;
	  }
	}
    break;

  case 305:
#line 2997 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_DEFAULT; }
    break;

  case 306:
#line 2998 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_FIXED; }
    break;

  case 307:
#line 2999 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_DYNAMIC; }
    break;

  case 308:
#line 3000 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_COMPRESSED; }
    break;

  case 309:
#line 3001 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_REDUNDANT; }
    break;

  case 310:
#line 3002 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_COMPACT; }
    break;

  case 311:
#line 3005 "sql_yacc.yy"
    { (yyval.ulong_num)= RAID_TYPE_0; }
    break;

  case 312:
#line 3006 "sql_yacc.yy"
    { (yyval.ulong_num)= RAID_TYPE_0; }
    break;

  case 313:
#line 3007 "sql_yacc.yy"
    { (yyval.ulong_num)=(yyvsp[0].ulong_num);}
    break;

  case 314:
#line 3010 "sql_yacc.yy"
    { (yyval.ulong_num)= MERGE_INSERT_DISABLED; }
    break;

  case 315:
#line 3011 "sql_yacc.yy"
    { (yyval.ulong_num)= MERGE_INSERT_TO_FIRST; }
    break;

  case 316:
#line 3012 "sql_yacc.yy"
    { (yyval.ulong_num)= MERGE_INSERT_TO_LAST; }
    break;

  case 317:
#line 3015 "sql_yacc.yy"
    {}
    break;

  case 319:
#line 3019 "sql_yacc.yy"
    { (yyval.udf_type) = UDFTYPE_FUNCTION; }
    break;

  case 320:
#line 3020 "sql_yacc.yy"
    { (yyval.udf_type) = UDFTYPE_AGGREGATE; }
    break;

  case 321:
#line 3023 "sql_yacc.yy"
    {(yyval.num) = (int) STRING_RESULT; }
    break;

  case 322:
#line 3024 "sql_yacc.yy"
    {(yyval.num) = (int) REAL_RESULT; }
    break;

  case 323:
#line 3025 "sql_yacc.yy"
    {(yyval.num) = (int) DECIMAL_RESULT; }
    break;

  case 324:
#line 3026 "sql_yacc.yy"
    {(yyval.num) = (int) INT_RESULT; }
    break;

  case 330:
#line 3041 "sql_yacc.yy"
    {
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 331:
#line 3048 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            Key *key= new Key((yyvsp[-5].key_type), (yyvsp[-4].simple_string), (yyvsp[-3].key_alg), 0, lex->col_list);
            lex->alter_info.key_list.push_back(key);

	    lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 332:
#line 3056 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    const char *key_name= (yyvsp[-4].simple_string) ? (yyvsp[-4].simple_string):(yyvsp[-6].simple_string);
            Key *key= new Key((yyvsp[-5].key_type), key_name, (yyvsp[-3].key_alg), 0, lex->col_list);
            lex->alter_info.key_list.push_back(key);
	    lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 333:
#line 3064 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            const char *key_name= (yyvsp[-4].simple_string) ? (yyvsp[-4].simple_string) : (yyvsp[-7].simple_string);
            Key *key= new foreign_key(key_name, lex->col_list,
                                      (yyvsp[0].table),
                                      lex->ref_list,
                                      lex->fk_delete_opt,
                                      lex->fk_update_opt,
                                      lex->fk_match_option);
            lex->alter_info.key_list.push_back(key);
            key= new Key(Key::MULTIPLE, key_name,
                         HA_KEY_ALG_UNDEF, 1,
                         lex->col_list);
            lex->alter_info.key_list.push_back(key);
	    lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 334:
#line 3081 "sql_yacc.yy"
    {
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 335:
#line 3085 "sql_yacc.yy"
    {
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 339:
#line 3100 "sql_yacc.yy"
    { (yyval.simple_string)=(char*) 0; }
    break;

  case 340:
#line 3101 "sql_yacc.yy"
    { (yyval.simple_string)= (yyvsp[0].simple_string); }
    break;

  case 341:
#line 3105 "sql_yacc.yy"
    { (yyval.simple_string)=(yyvsp[0].simple_string); }
    break;

  case 342:
#line 3110 "sql_yacc.yy"
    {
	   LEX *lex=Lex;
	   lex->length=lex->dec=0; lex->type=0;
	   lex->default_value= lex->on_update_value= 0;
           lex->comment=null_lex_str;
	   lex->charset=NULL;
	 }
    break;

  case 343:
#line 3118 "sql_yacc.yy"
    {
	  LEX *lex=Lex;
	  if (add_field_to_list(lex->thd, (yyvsp[-3].lex_str).str,
				(enum enum_field_types) (yyvsp[-1].num),
				lex->length,lex->dec,lex->type,
				lex->default_value, lex->on_update_value, 
                                &lex->comment,
				lex->change,&lex->interval_list,lex->charset,
				lex->uint_geom_type))
	    MYSQL_YYABORT;
	}
    break;

  case 344:
#line 3131 "sql_yacc.yy"
    { (yyval.num)=(yyvsp[-2].num); }
    break;

  case 345:
#line 3132 "sql_yacc.yy"
    { (yyval.num)=(yyvsp[-2].num); }
    break;

  case 346:
#line 3133 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_FLOAT; }
    break;

  case 347:
#line 3134 "sql_yacc.yy"
    { Lex->length= (char*) "1";
					  (yyval.num)=FIELD_TYPE_BIT; }
    break;

  case 348:
#line 3136 "sql_yacc.yy"
    { Lex->length= (yyvsp[-1].lex_str).str;
					  (yyval.num)=FIELD_TYPE_BIT; }
    break;

  case 349:
#line 3138 "sql_yacc.yy"
    { Lex->length=(char*) "1";
					  (yyval.num)=FIELD_TYPE_TINY; }
    break;

  case 350:
#line 3140 "sql_yacc.yy"
    { Lex->length=(char*) "1";
					  (yyval.num)=FIELD_TYPE_TINY; }
    break;

  case 351:
#line 3142 "sql_yacc.yy"
    { Lex->length=(yyvsp[-2].lex_str).str;
					  (yyval.num)=FIELD_TYPE_STRING; }
    break;

  case 352:
#line 3144 "sql_yacc.yy"
    { Lex->length=(char*) "1";
					  (yyval.num)=FIELD_TYPE_STRING; }
    break;

  case 353:
#line 3146 "sql_yacc.yy"
    { Lex->length=(yyvsp[-2].lex_str).str;
					  (yyval.num)=FIELD_TYPE_STRING;
					  Lex->charset=national_charset_info; }
    break;

  case 354:
#line 3149 "sql_yacc.yy"
    { Lex->length=(char*) "1";
					  (yyval.num)=FIELD_TYPE_STRING;
					  Lex->charset=national_charset_info; }
    break;

  case 355:
#line 3152 "sql_yacc.yy"
    { Lex->length=(yyvsp[-1].lex_str).str;
					  Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_STRING; }
    break;

  case 356:
#line 3155 "sql_yacc.yy"
    { Lex->length= (char*) "1";
					  Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_STRING; }
    break;

  case 357:
#line 3158 "sql_yacc.yy"
    { Lex->length=(yyvsp[-2].lex_str).str;
					  (yyval.num)= MYSQL_TYPE_VARCHAR; }
    break;

  case 358:
#line 3160 "sql_yacc.yy"
    { Lex->length=(yyvsp[-2].lex_str).str;
					  (yyval.num)= MYSQL_TYPE_VARCHAR;
					  Lex->charset=national_charset_info; }
    break;

  case 359:
#line 3163 "sql_yacc.yy"
    { Lex->length=(yyvsp[-1].lex_str).str;
					  Lex->charset=&my_charset_bin;
					  (yyval.num)= MYSQL_TYPE_VARCHAR; }
    break;

  case 360:
#line 3166 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_YEAR; }
    break;

  case 361:
#line 3167 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_DATE; }
    break;

  case 362:
#line 3168 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_TIME; }
    break;

  case 363:
#line 3170 "sql_yacc.yy"
    {
	    if (YYTHD->variables.sql_mode & MODE_MAXDB)
	      (yyval.num)=FIELD_TYPE_DATETIME;
	    else
            {
              /* 
                Unlike other types TIMESTAMP fields are NOT NULL by default.
              */
              Lex->type|= NOT_NULL_FLAG;
	      (yyval.num)=FIELD_TYPE_TIMESTAMP;
            }
	   }
    break;

  case 364:
#line 3182 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_DATETIME; }
    break;

  case 365:
#line 3183 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_TINY_BLOB; }
    break;

  case 366:
#line 3185 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_BLOB; }
    break;

  case 367:
#line 3188 "sql_yacc.yy"
    {
#ifdef HAVE_SPATIAL
            Lex->charset=&my_charset_bin;
            Lex->uint_geom_type= (uint)(yyvsp[0].num);
            (yyval.num)=FIELD_TYPE_GEOMETRY;
#else
            my_error(ER_FEATURE_DISABLED, MYF(0),
                     sym_group_geom.name, sym_group_geom.needed_define);
            MYSQL_YYABORT;
#endif
          }
    break;

  case 368:
#line 3199 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_MEDIUM_BLOB; }
    break;

  case 369:
#line 3201 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_LONG_BLOB; }
    break;

  case 370:
#line 3203 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_MEDIUM_BLOB; }
    break;

  case 371:
#line 3205 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_MEDIUM_BLOB; }
    break;

  case 372:
#line 3206 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_TINY_BLOB; }
    break;

  case 373:
#line 3207 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_BLOB; }
    break;

  case 374:
#line 3208 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_MEDIUM_BLOB; }
    break;

  case 375:
#line 3209 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_LONG_BLOB; }
    break;

  case 376:
#line 3211 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_NEWDECIMAL;}
    break;

  case 377:
#line 3213 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_NEWDECIMAL;}
    break;

  case 378:
#line 3215 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_NEWDECIMAL;}
    break;

  case 379:
#line 3216 "sql_yacc.yy"
    {Lex->interval_list.empty();}
    break;

  case 380:
#line 3217 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_ENUM; }
    break;

  case 381:
#line 3218 "sql_yacc.yy"
    { Lex->interval_list.empty();}
    break;

  case 382:
#line 3219 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_SET; }
    break;

  case 383:
#line 3220 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_MEDIUM_BLOB; }
    break;

  case 384:
#line 3222 "sql_yacc.yy"
    {
	    (yyval.num)=FIELD_TYPE_LONGLONG;
	    Lex->type|= (AUTO_INCREMENT_FLAG | NOT_NULL_FLAG | UNSIGNED_FLAG |
		         UNIQUE_FLAG);
	  }
    break;

  case 385:
#line 3230 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_GEOMETRY; }
    break;

  case 386:
#line 3231 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_GEOMETRYCOLLECTION; }
    break;

  case 387:
#line 3232 "sql_yacc.yy"
    { Lex->length= (char*)"21";
                                (yyval.num)= Field::GEOM_POINT;
                              }
    break;

  case 388:
#line 3235 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_MULTIPOINT; }
    break;

  case 389:
#line 3236 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_LINESTRING; }
    break;

  case 390:
#line 3237 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_MULTILINESTRING; }
    break;

  case 391:
#line 3238 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_POLYGON; }
    break;

  case 392:
#line 3239 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_MULTIPOLYGON; }
    break;

  case 393:
#line 3243 "sql_yacc.yy"
    {}
    break;

  case 394:
#line 3247 "sql_yacc.yy"
    {}
    break;

  case 395:
#line 3248 "sql_yacc.yy"
    {}
    break;

  case 396:
#line 3252 "sql_yacc.yy"
    {}
    break;

  case 397:
#line 3253 "sql_yacc.yy"
    {}
    break;

  case 398:
#line 3257 "sql_yacc.yy"
    {}
    break;

  case 399:
#line 3258 "sql_yacc.yy"
    {}
    break;

  case 400:
#line 3259 "sql_yacc.yy"
    {}
    break;

  case 401:
#line 3260 "sql_yacc.yy"
    {}
    break;

  case 402:
#line 3261 "sql_yacc.yy"
    {}
    break;

  case 403:
#line 3265 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_LONG; }
    break;

  case 404:
#line 3266 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_TINY; }
    break;

  case 405:
#line 3267 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_SHORT; }
    break;

  case 406:
#line 3268 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_INT24; }
    break;

  case 407:
#line 3269 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_LONGLONG; }
    break;

  case 408:
#line 3272 "sql_yacc.yy"
    { (yyval.num)= YYTHD->variables.sql_mode & MODE_REAL_AS_FLOAT ?
			      FIELD_TYPE_FLOAT : FIELD_TYPE_DOUBLE; }
    break;

  case 409:
#line 3274 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_DOUBLE; }
    break;

  case 410:
#line 3275 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_DOUBLE; }
    break;

  case 411:
#line 3279 "sql_yacc.yy"
    { Lex->dec=Lex->length= (char*)0; }
    break;

  case 412:
#line 3280 "sql_yacc.yy"
    { Lex->length=(yyvsp[-1].lex_str).str; Lex->dec= (char*)0; }
    break;

  case 413:
#line 3281 "sql_yacc.yy"
    {}
    break;

  case 414:
#line 3285 "sql_yacc.yy"
    {
	  LEX *lex=Lex;
	  lex->length=(yyvsp[-3].lex_str).str; lex->dec=(yyvsp[-1].lex_str).str;
	}
    break;

  case 415:
#line 3291 "sql_yacc.yy"
    {}
    break;

  case 416:
#line 3292 "sql_yacc.yy"
    {}
    break;

  case 417:
#line 3295 "sql_yacc.yy"
    {}
    break;

  case 418:
#line 3296 "sql_yacc.yy"
    {}
    break;

  case 419:
#line 3299 "sql_yacc.yy"
    {}
    break;

  case 420:
#line 3300 "sql_yacc.yy"
    { Lex->type|= UNSIGNED_FLAG;}
    break;

  case 421:
#line 3301 "sql_yacc.yy"
    { Lex->type|= UNSIGNED_FLAG | ZEROFILL_FLAG; }
    break;

  case 422:
#line 3304 "sql_yacc.yy"
    { Lex->length=(char*) 0; }
    break;

  case 423:
#line 3305 "sql_yacc.yy"
    { Lex->length= (yyvsp[-1].lex_str).str; }
    break;

  case 424:
#line 3308 "sql_yacc.yy"
    {}
    break;

  case 425:
#line 3309 "sql_yacc.yy"
    {}
    break;

  case 426:
#line 3312 "sql_yacc.yy"
    {}
    break;

  case 427:
#line 3313 "sql_yacc.yy"
    {}
    break;

  case 428:
#line 3316 "sql_yacc.yy"
    {}
    break;

  case 430:
#line 3320 "sql_yacc.yy"
    { Lex->type&= ~ NOT_NULL_FLAG; }
    break;

  case 431:
#line 3321 "sql_yacc.yy"
    { Lex->type|= NOT_NULL_FLAG; }
    break;

  case 432:
#line 3322 "sql_yacc.yy"
    { Lex->default_value=(yyvsp[0].item); }
    break;

  case 433:
#line 3324 "sql_yacc.yy"
    { Lex->on_update_value= new Item_func_now_local(); }
    break;

  case 434:
#line 3325 "sql_yacc.yy"
    { Lex->type|= AUTO_INCREMENT_FLAG | NOT_NULL_FLAG; }
    break;

  case 435:
#line 3327 "sql_yacc.yy"
    { 
	    LEX *lex=Lex;
	    lex->type|= AUTO_INCREMENT_FLAG | NOT_NULL_FLAG | UNIQUE_FLAG; 
	    lex->alter_info.flags|= ALTER_ADD_INDEX; 
	  }
    break;

  case 436:
#line 3333 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->type|= PRI_KEY_FLAG | NOT_NULL_FLAG; 
	    lex->alter_info.flags|= ALTER_ADD_INDEX; 
	  }
    break;

  case 437:
#line 3339 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->type|= UNIQUE_FLAG; 
	    lex->alter_info.flags|= ALTER_ADD_INDEX; 
	  }
    break;

  case 438:
#line 3345 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->type|= UNIQUE_KEY_FLAG; 
	    lex->alter_info.flags|= ALTER_ADD_INDEX; 
	  }
    break;

  case 439:
#line 3350 "sql_yacc.yy"
    { Lex->comment= (yyvsp[0].lex_str); }
    break;

  case 440:
#line 3352 "sql_yacc.yy"
    {
	    if (Lex->charset && !my_charset_same(Lex->charset,(yyvsp[0].charset)))
	    {
	      my_error(ER_COLLATION_CHARSET_MISMATCH, MYF(0),
                       (yyvsp[0].charset)->name,Lex->charset->csname);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      Lex->charset=(yyvsp[0].charset);
	    }
	  }
    break;

  case 441:
#line 3367 "sql_yacc.yy"
    { (yyval.item)= new Item_func_now_local(); }
    break;

  case 442:
#line 3368 "sql_yacc.yy"
    { (yyval.item)=(yyvsp[0].item); }
    break;

  case 443:
#line 3372 "sql_yacc.yy"
    {}
    break;

  case 444:
#line 3373 "sql_yacc.yy"
    {}
    break;

  case 445:
#line 3378 "sql_yacc.yy"
    {
	  if (!((yyval.charset)=get_charset_by_csname((yyvsp[0].lex_str).str,MY_CS_PRIMARY,MYF(0))))
	  {
	    my_error(ER_UNKNOWN_CHARACTER_SET, MYF(0), (yyvsp[0].lex_str).str);
	    MYSQL_YYABORT;
	  }
	}
    break;

  case 446:
#line 3385 "sql_yacc.yy"
    { (yyval.charset)= &my_charset_bin; }
    break;

  case 447:
#line 3389 "sql_yacc.yy"
    { (yyval.charset)=(yyvsp[0].charset);   }
    break;

  case 448:
#line 3390 "sql_yacc.yy"
    { (yyval.charset)=NULL; }
    break;

  case 449:
#line 3393 "sql_yacc.yy"
    { (yyval.charset)= NULL; }
    break;

  case 450:
#line 3394 "sql_yacc.yy"
    { (yyval.charset)= (yyvsp[0].charset); }
    break;

  case 451:
#line 3399 "sql_yacc.yy"
    {
	  if (!((yyval.charset)=get_charset_by_csname((yyvsp[0].lex_str).str,MY_CS_PRIMARY,MYF(0))) &&
	      !((yyval.charset)=get_old_charset_by_name((yyvsp[0].lex_str).str)))
	  {
	    my_error(ER_UNKNOWN_CHARACTER_SET, MYF(0), (yyvsp[0].lex_str).str);
	    MYSQL_YYABORT;
	  }
	}
    break;

  case 452:
#line 3407 "sql_yacc.yy"
    { (yyval.charset)= &my_charset_bin; }
    break;

  case 453:
#line 3411 "sql_yacc.yy"
    { (yyval.charset)=(yyvsp[0].charset);   }
    break;

  case 454:
#line 3412 "sql_yacc.yy"
    { (yyval.charset)=NULL; }
    break;

  case 455:
#line 3416 "sql_yacc.yy"
    {
	  if (!((yyval.charset)=get_charset_by_name((yyvsp[0].lex_str).str,MYF(0))))
	  {
	    my_error(ER_UNKNOWN_COLLATION, MYF(0), (yyvsp[0].lex_str).str);
	    MYSQL_YYABORT;
	  }
	}
    break;

  case 456:
#line 3425 "sql_yacc.yy"
    { (yyval.charset)=NULL; }
    break;

  case 457:
#line 3426 "sql_yacc.yy"
    { (yyval.charset)=(yyvsp[0].charset); }
    break;

  case 458:
#line 3430 "sql_yacc.yy"
    { (yyval.charset)=(yyvsp[0].charset);   }
    break;

  case 459:
#line 3431 "sql_yacc.yy"
    { (yyval.charset)=NULL; }
    break;

  case 460:
#line 3434 "sql_yacc.yy"
    {}
    break;

  case 461:
#line 3435 "sql_yacc.yy"
    {}
    break;

  case 462:
#line 3438 "sql_yacc.yy"
    { Lex->charset=NULL; }
    break;

  case 463:
#line 3439 "sql_yacc.yy"
    { Lex->charset=&my_charset_latin1; }
    break;

  case 464:
#line 3440 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin; }
    break;

  case 465:
#line 3442 "sql_yacc.yy"
    {
	  if (!(Lex->charset=get_charset_by_csname("ucs2",
                                                   MY_CS_PRIMARY,MYF(0))))
	  {
	    my_error(ER_UNKNOWN_CHARACTER_SET, MYF(0), "ucs2");
	    MYSQL_YYABORT;
	  }
	}
    break;

  case 466:
#line 3450 "sql_yacc.yy"
    { Lex->charset=(yyvsp[-1].charset); }
    break;

  case 467:
#line 3451 "sql_yacc.yy"
    { Lex->type|= BINCMP_FLAG; }
    break;

  case 468:
#line 3454 "sql_yacc.yy"
    { }
    break;

  case 469:
#line 3455 "sql_yacc.yy"
    { Lex->type|= BINCMP_FLAG; }
    break;

  case 470:
#line 3458 "sql_yacc.yy"
    { Lex->charset= NULL; }
    break;

  case 471:
#line 3459 "sql_yacc.yy"
    { Lex->charset=&my_charset_latin1; }
    break;

  case 472:
#line 3461 "sql_yacc.yy"
    {
	  if (!(Lex->charset=get_charset_by_csname("ucs2",
                                                   MY_CS_PRIMARY,MYF(0))))
	  {
	    my_error(ER_UNKNOWN_CHARACTER_SET, MYF(0), "ucs2");
	    MYSQL_YYABORT;
	  }
	}
    break;

  case 473:
#line 3469 "sql_yacc.yy"
    { Lex->charset=(yyvsp[0].charset); }
    break;

  case 476:
#line 3478 "sql_yacc.yy"
    {
	  LEX *lex=Lex;
	  lex->fk_delete_opt= lex->fk_update_opt= lex->fk_match_option= 0;
	  lex->ref_list.empty();
	}
    break;

  case 477:
#line 3484 "sql_yacc.yy"
    {
	  (yyval.table)=(yyvsp[-2].table);
	}
    break;

  case 478:
#line 3489 "sql_yacc.yy"
    {}
    break;

  case 479:
#line 3490 "sql_yacc.yy"
    {}
    break;

  case 480:
#line 3493 "sql_yacc.yy"
    { Lex->ref_list.push_back(new key_part_spec((yyvsp[0].lex_str).str)); }
    break;

  case 481:
#line 3494 "sql_yacc.yy"
    { Lex->ref_list.push_back(new key_part_spec((yyvsp[0].lex_str).str)); }
    break;

  case 482:
#line 3498 "sql_yacc.yy"
    {}
    break;

  case 483:
#line 3499 "sql_yacc.yy"
    {}
    break;

  case 484:
#line 3502 "sql_yacc.yy"
    {}
    break;

  case 485:
#line 3503 "sql_yacc.yy"
    {}
    break;

  case 486:
#line 3506 "sql_yacc.yy"
    { Lex->fk_delete_opt= (yyvsp[0].num); }
    break;

  case 487:
#line 3507 "sql_yacc.yy"
    { Lex->fk_update_opt= (yyvsp[0].num); }
    break;

  case 488:
#line 3508 "sql_yacc.yy"
    { Lex->fk_match_option= foreign_key::FK_MATCH_FULL; }
    break;

  case 489:
#line 3509 "sql_yacc.yy"
    { Lex->fk_match_option= foreign_key::FK_MATCH_PARTIAL; }
    break;

  case 490:
#line 3510 "sql_yacc.yy"
    { Lex->fk_match_option= foreign_key::FK_MATCH_SIMPLE; }
    break;

  case 491:
#line 3513 "sql_yacc.yy"
    { (yyval.num)= (int) foreign_key::FK_OPTION_RESTRICT; }
    break;

  case 492:
#line 3514 "sql_yacc.yy"
    { (yyval.num)= (int) foreign_key::FK_OPTION_CASCADE; }
    break;

  case 493:
#line 3515 "sql_yacc.yy"
    { (yyval.num)= (int) foreign_key::FK_OPTION_SET_NULL; }
    break;

  case 494:
#line 3516 "sql_yacc.yy"
    { (yyval.num)= (int) foreign_key::FK_OPTION_NO_ACTION; }
    break;

  case 495:
#line 3517 "sql_yacc.yy"
    { (yyval.num)= (int) foreign_key::FK_OPTION_DEFAULT;  }
    break;

  case 496:
#line 3520 "sql_yacc.yy"
    { (yyval.key_type)= Key::MULTIPLE; }
    break;

  case 497:
#line 3521 "sql_yacc.yy"
    { (yyval.key_type)= Key::FULLTEXT; }
    break;

  case 498:
#line 3523 "sql_yacc.yy"
    {
#ifdef HAVE_SPATIAL
	    (yyval.key_type)= Key::SPATIAL;
#else
	    my_error(ER_FEATURE_DISABLED, MYF(0),
                     sym_group_geom.name, sym_group_geom.needed_define);
	    MYSQL_YYABORT;
#endif
	  }
    break;

  case 499:
#line 3534 "sql_yacc.yy"
    { (yyval.key_type)= Key::PRIMARY; }
    break;

  case 500:
#line 3535 "sql_yacc.yy"
    { (yyval.key_type)= Key::UNIQUE; }
    break;

  case 501:
#line 3538 "sql_yacc.yy"
    {}
    break;

  case 502:
#line 3539 "sql_yacc.yy"
    {}
    break;

  case 503:
#line 3542 "sql_yacc.yy"
    {}
    break;

  case 505:
#line 3547 "sql_yacc.yy"
    {}
    break;

  case 506:
#line 3548 "sql_yacc.yy"
    {}
    break;

  case 507:
#line 3549 "sql_yacc.yy"
    {}
    break;

  case 508:
#line 3552 "sql_yacc.yy"
    { (yyval.key_type)= Key::MULTIPLE; }
    break;

  case 509:
#line 3553 "sql_yacc.yy"
    { (yyval.key_type)= Key::UNIQUE; }
    break;

  case 510:
#line 3554 "sql_yacc.yy"
    { (yyval.key_type)= Key::FULLTEXT;}
    break;

  case 511:
#line 3556 "sql_yacc.yy"
    {
#ifdef HAVE_SPATIAL
	    (yyval.key_type)= Key::SPATIAL;
#else
            my_error(ER_FEATURE_DISABLED, MYF(0),
                     sym_group_geom.name, sym_group_geom.needed_define);
	    MYSQL_YYABORT;
#endif
	  }
    break;

  case 512:
#line 3568 "sql_yacc.yy"
    { (yyval.key_alg)= HA_KEY_ALG_UNDEF; }
    break;

  case 513:
#line 3569 "sql_yacc.yy"
    { (yyval.key_alg)= (yyvsp[0].key_alg); }
    break;

  case 514:
#line 3570 "sql_yacc.yy"
    { (yyval.key_alg)= (yyvsp[0].key_alg); }
    break;

  case 515:
#line 3573 "sql_yacc.yy"
    { (yyval.key_alg)= HA_KEY_ALG_BTREE; }
    break;

  case 516:
#line 3575 "sql_yacc.yy"
    {
	    (yyval.key_alg)= HA_KEY_ALG_RTREE;
	  }
    break;

  case 517:
#line 3578 "sql_yacc.yy"
    { (yyval.key_alg)= HA_KEY_ALG_HASH; }
    break;

  case 518:
#line 3581 "sql_yacc.yy"
    { Lex->col_list.push_back((yyvsp[-1].key_part)); }
    break;

  case 519:
#line 3582 "sql_yacc.yy"
    { Lex->col_list.push_back((yyvsp[-1].key_part)); }
    break;

  case 520:
#l