#!/bin/sh
DEVNAME="$1"
COMMAND="$2"
TESTNAME="net.$RANDOM"
LOCKFILE="/dev/net-lockfile"

. /etc/udev/udev.conf

PERM_RULES="${udev_rules}/75-network-devices.rules"
TEMP_RULES="${udev_root}/75-network-devices.rules"

getlock() {
	until ( mkdir $LOCKFILE ) 2>/dev/null
	do
	   sleep 1
	done
}

givelock() {
	if [ -e $LOCKFILE ]; then
		rm -rf $LOCKFILE
	fi
}

checkrules() {
	if grep $1 ${udev_root}/*.rules &>/dev/null ; then
		return 0
	fi
	if grep $1 ${udev_rules}/*.rules &>/dev/null ; then
		return 0
	fi
	return 1
}

testwrite() { 
	if ln -s /dev/null ${udev_rules}/$TESTNAME 2>/dev/null ; then
		rm -rf ${udev_rules}/$TESTNAME
		RW=1
		if [ -e $TEMP_RULES ]; then
			mv $TEMP_RULES $PERM_RULES
		fi
		UDEV_RULES="$PERM_RULES"
	else
		if [ -e $PERM_RULES ] && [ ! -e $TEMP_RULES ]; then
			cp $PERM_RULES $TEMP_RULES
		fi
		UDEV_RULES="$TEMP_RULES"
	fi
}

case $DEVNAME in
	ppp*|ippp*|isdn*|plip*|lo*|irda*|dummy*|tun*|tap*|sit*|ipsec*|cipsec*)
		exit 0
		;;
	eth*|ath*|wlan*|ra*|sta*)
		case $COMMAND in
			'start')
				getlock
				# Test if the root filesystem is mounted RW
				testwrite

				ADDRESS=`cat /sys/class/net/${DEVNAME}/address`
				if ! checkrules $ADDRESS ; then 
					if [ ! -e $UDEV_RULES ]; then 
					    echo "# Local network rules to name your network cards.
#
# These rules were generated by nethelper.sh, but you can
# customize them.
#
# You may edit them as needed.
# (If, for example, your machine has more than one network
# card and you need to be sure they will always be given
# the same name, like eth0, based on the MAC address)
#
# If you delete this file, /lib/udev/nethelper.sh will try to
# generate it again the next time udev is started.
" > $UDEV_RULES
					fi
					KRN_NAME=`echo $DEVNAME | sed -ne 's#\(\w*\)[0-9].*#\1#p'`
					if checkrules "\"$DEVNAME\"" &>/dev/null ; then
						NUMBER=`grep -c "NAME=\"${KRN_NAME}.\"" $UDEV_RULES`
						while [ `grep -c "\"${KRN_NAME}${NUMBER}\"" \
							 $UDEV_RULES` -ne 0 ]; do 
							NUMBER=$(($NUMBER+1))
						done
						NAME="${KRN_NAME}${NUMBER}"
					else
						NAME="${DEVNAME}"
					fi
					echo "KERNEL==\"${KRN_NAME}?\", ATTR{address}==\"$ADDRESS\", NAME=\"${NAME}\"" >> $UDEV_RULES 
					if [ "$NAME" != "$DEVNAME" ]; then
						/sbin/nameif ${NAME} ${ADDRESS}
						DEVNAME=${NAME}
					fi
				fi
				givelock
				if [ $RW ]; then
					if [ -x /etc/rc.d/rc.inet1 ]; then
						if ! /sbin/ifconfig | /bin/grep -q "^${DEVNAME} "; then
							/etc/rc.d/rc.inet1 ${DEVNAME}_start
						fi
					fi
					exit 0
				else
					exit 1
				fi
				;;
			'stop')
	                        if [ -x /etc/rc.d/rc.inet1 ]; then
                                     if /sbin/ifconfig | /bin/grep -q "^${DEVNAME} "; then
                                        /etc/rc.d/rc.inet1 ${DEVNAME}_stop
                                     fi
                                fi
                                # Does dhcpcd appear to still be running on the
				# interface?  If so, try to stop it.
                                if [ -r /etc/dhcpc/dhcpcd-$DEVNAME.pid -o -r /var/run/dhcpcd-$DEVNAME.pid ]; then
                                  /sbin/dhcpcd -k -d $DEVNAME
                                  # Force garbage removal, if needed:
                                  if [ -r /etc/dhcpc/dhcpcd-$DEVNAME.pid ]; then
                                     /bin/rm -f /etc/dhcpc/dhcpcd-$DEVNAME.pid
                                  elif [ -r /var/run/dhcpcd-$DEVNAME.pid ]; then
                                     /bin/rm -f /var/run/dhcpcd-$DEVNAME.pid
                                  fi
                                fi
                                # If the interface is now down, exit with a status of 0:
                                if /sbin/ifconfig | /bin/grep -q "^${DEVNAME} " ; then
                                  exit 0
                                fi
                                ;;
			*)
				echo "usage $0 interface start|stop|create_rule"
				exit 1
				;;
		esac
esac
exit 0
