/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.cookie;

import com.sun.deploy.net.cookie.RfcDateParser;
import java.net.URL;
import java.util.Date;
import java.util.StringTokenizer;

class HttpCookie
implements Comparable {
    private static final int SIZE_LIMIT = 4096;
    private Date expirationDate = null;
    private String nameAndValue = null;
    private String path = null;
    private String domain = null;
    private boolean isSecure = false;

    private HttpCookie() {
    }

    private HttpCookie(Date date, String string, String string2, String string3, boolean bl) {
        this.expirationDate = date;
        this.nameAndValue = string;
        this.path = string2;
        this.domain = HttpCookie.stripPort(string3);
        this.isSecure = bl;
    }

    private static String stripPort(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    static HttpCookie create(Date date, String string, String string2, String string3, boolean bl) {
        if (string == null || string2 == null || string3 == null) {
            return null;
        }
        if (string2.equals("")) {
            string2 = "/";
        }
        if (string.length() > 4096) {
            string = string.substring(0, 4096);
        }
        return new HttpCookie(date, string, string2, string3, bl);
    }

    static HttpCookie create(URL uRL, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        if (!stringTokenizer.hasMoreTokens()) {
            return null;
        }
        HttpCookie httpCookie = new HttpCookie();
        httpCookie.nameAndValue = stringTokenizer.nextToken().trim();
        if (httpCookie.nameAndValue.length() > 4096) {
            httpCookie.nameAndValue = httpCookie.nameAndValue.substring(0, 4096);
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.equalsIgnoreCase("secure")) {
                httpCookie.isSecure = true;
                continue;
            }
            int n = string2.indexOf("=");
            if (n < 0) continue;
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            if (string3.equalsIgnoreCase("path")) {
                httpCookie.path = string4;
                continue;
            }
            if (string3.equalsIgnoreCase("domain")) {
                if (string4.indexOf(".") == 0) {
                    httpCookie.domain = HttpCookie.stripPort(string4.substring(1));
                    continue;
                }
                httpCookie.domain = HttpCookie.stripPort(string4);
                continue;
            }
            if (!string3.equalsIgnoreCase("expires")) continue;
            httpCookie.expirationDate = HttpCookie.parseExpireDate(string4);
        }
        if (httpCookie.domain == null) {
            httpCookie.domain = uRL.getHost();
        }
        if (httpCookie.path == null) {
            httpCookie.path = uRL.getFile();
            int n = httpCookie.path.lastIndexOf("/");
            if (n > -1) {
                httpCookie.path = httpCookie.path.substring(0, n);
            }
        }
        return httpCookie;
    }

    public String getNameValue() {
        return this.nameAndValue;
    }

    public String getName() {
        int n = this.nameAndValue.indexOf("=");
        return this.nameAndValue.substring(0, n);
    }

    public String getValue() {
        int n = this.nameAndValue.indexOf("=");
        return this.nameAndValue.substring(n + 1);
    }

    public String getDomain() {
        return this.domain;
    }

    public String getPath() {
        return this.path;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    boolean hasExpired() {
        if (this.expirationDate == null) {
            return false;
        }
        return this.expirationDate.getTime() <= System.currentTimeMillis();
    }

    boolean isSaveable() {
        return this.expirationDate != null && this.expirationDate.getTime() > System.currentTimeMillis();
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    private static Date parseExpireDate(String string) {
        RfcDateParser rfcDateParser = new RfcDateParser(string);
        Date date = rfcDateParser.getDate();
        return date;
    }

    public String toString() {
        String string = this.nameAndValue;
        if (this.expirationDate != null) {
            string = string + "; expires=" + this.expirationDate;
        }
        if (this.path != null) {
            string = string + "; path=" + this.path;
        }
        if (this.domain != null) {
            string = string + "; domain=" + this.domain;
        }
        if (this.isSecure) {
            string = string + "; secure";
        }
        return string;
    }

    public int compareTo(Object object) {
        HttpCookie httpCookie = (HttpCookie)object;
        if (httpCookie == this) {
            return 0;
        }
        int n = this.getDomain().compareTo(httpCookie.getDomain());
        if (n != 0) {
            return n;
        }
        n = this.getPath().compareTo(httpCookie.getPath());
        if (n != 0) {
            return n;
        }
        return this.getNameValue().compareTo(httpCookie.getNameValue());
    }
}

