/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.javaws.JnlpxArgs;
import com.sun.javaws.jnl.ExtensionDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.PackageDesc;
import com.sun.javaws.jnl.PropertyDesc;
import com.sun.javaws.jnl.ResourceVisitor;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.util.VersionID;
import com.sun.javaws.util.VersionString;
import java.io.File;
import java.net.URL;
import java.util.StringTokenizer;

public class LaunchSelection {
    public static JREInfo selectJRE(LaunchDesc launchDesc) {
        final JREDesc[] jREDescArray = new JREDesc[1];
        final JREInfo[] jREInfoArray = new JREInfo[1];
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        resourcesDesc.visit(new ResourceVisitor(){

            public void visitJARDesc(JARDesc jARDesc) {
            }

            public void visitPropertyDesc(PropertyDesc propertyDesc) {
            }

            public void visitPackageDesc(PackageDesc packageDesc) {
            }

            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
            }

            public void visitJREDesc(JREDesc jREDesc) {
                if (jREInfoArray[0] == null) {
                    LaunchSelection.handleJREDesc(jREDesc, jREInfoArray, jREDescArray);
                }
            }
        });
        jREDescArray[0].markAsSelected();
        resourcesDesc.addNested(jREDescArray[0].getNestedResources());
        return jREInfoArray[0];
    }

    public static JREInfo selectJRE(URL uRL, String string) {
        JREInfo[] jREInfoArray = JREInfo.get();
        if (jREInfoArray == null) {
            return null;
        }
        VersionString versionString = new VersionString(string);
        for (int i = 0; i < jREInfoArray.length; ++i) {
            if (!jREInfoArray[i].isOsInfoMatch(Config.getOSName(), Config.getOSArch()) || !jREInfoArray[i].isEnabled() || !(uRL == null ? LaunchSelection.isPlatformMatch(jREInfoArray[i], versionString) : LaunchSelection.isProductMatch(jREInfoArray[i], uRL, versionString))) continue;
            return jREInfoArray[i];
        }
        return null;
    }

    private static void handleJREDesc(JREDesc jREDesc, JREInfo[] jREInfoArray, JREDesc[] jREDescArray) {
        URL uRL = jREDesc.getHref();
        String string = jREDesc.getVersion();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ", false);
        int n = stringTokenizer.countTokens();
        if (n > 0) {
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = stringTokenizer.nextToken();
            }
            LaunchSelection.matchJRE(jREDesc, stringArray, jREInfoArray, jREDescArray);
            if (jREInfoArray[0] != null) {
                return;
            }
        }
    }

    private static void matchJRE(JREDesc jREDesc, String[] stringArray, JREInfo[] jREInfoArray, JREDesc[] jREDescArray) {
        URL uRL = jREDesc.getHref();
        JREInfo[] jREInfoArray2 = JREInfo.get();
        if (jREInfoArray2 == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            VersionString versionString = new VersionString(stringArray[i]);
            for (int j = 0; j < jREInfoArray2.length; ++j) {
                if (!jREInfoArray2[j].isOsInfoMatch(Config.getOSName(), Config.getOSArch()) || !jREInfoArray2[j].isEnabled()) continue;
                boolean bl = uRL == null ? LaunchSelection.isPlatformMatch(jREInfoArray2[j], versionString) : LaunchSelection.isProductMatch(jREInfoArray2[j], uRL, versionString);
                boolean bl2 = JnlpxArgs.getJVMCommand().equals(new File(jREInfoArray2[j].getPath()));
                boolean bl3 = JnlpxArgs.isCurrentRunningJREHeap(jREDesc.getMinHeap(), jREDesc.getMaxHeap());
                if (bl && bl2 && bl3) {
                    Trace.println((String)"LaunchSelection: findJRE: Match on current JRE", (TraceLevel)TraceLevel.BASIC);
                    jREInfoArray[0] = jREInfoArray2[j];
                    jREDescArray[0] = jREDesc;
                    return;
                }
                if (!bl) continue;
                Trace.print((String)"LaunchSelection: findJRE: No match on current JRE because ", (TraceLevel)TraceLevel.BASIC);
                if (!bl) {
                    Trace.print((String)"versions dont match, ", (TraceLevel)TraceLevel.BASIC);
                }
                if (!bl2) {
                    Trace.print((String)"paths dont match, ", (TraceLevel)TraceLevel.BASIC);
                }
                if (!bl3) {
                    Trace.print((String)"heap sizes dont match", (TraceLevel)TraceLevel.BASIC);
                }
                Trace.println((String)"", (TraceLevel)TraceLevel.BASIC);
                VersionID versionID = new VersionID(jREInfoArray2[j].getProduct());
                VersionID versionID2 = null;
                if (jREInfoArray[0] != null) {
                    versionID2 = new VersionID(jREInfoArray[0].getProduct());
                }
                if (versionID2 != null && !versionID.isGreaterThan(versionID2)) continue;
                jREInfoArray[0] = jREInfoArray2[j];
                jREDescArray[0] = jREDesc;
            }
        }
        if (jREDescArray[0] == null) {
            jREDescArray[0] = jREDesc;
        }
    }

    private static boolean isPlatformMatch(JREInfo jREInfo, VersionString versionString) {
        String string = jREInfo.getProduct();
        boolean bl = string == null || string.indexOf(45) == -1 || string.startsWith("1.2") || LaunchSelection.isInstallJRE(jREInfo);
        if (new File(jREInfo.getPath()).exists()) {
            return versionString.contains(jREInfo.getPlatform()) && bl;
        }
        return false;
    }

    private static boolean isProductMatch(JREInfo jREInfo, URL uRL, VersionString versionString) {
        if (new File(jREInfo.getPath()).exists()) {
            return jREInfo.getLocation().equals(uRL.toString()) && versionString.contains(jREInfo.getProduct());
        }
        return false;
    }

    private static boolean isInstallJRE(JREInfo jREInfo) {
        File file = new File(Config.getJavaHome());
        File file2 = new File(jREInfo.getPath());
        File file3 = file2.getParentFile();
        return file.equals(file3.getParentFile());
    }
}

