/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image.renderable;

import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ContextualRenderedImageFactory;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderableImageOp
implements RenderableImage {
    ParameterBlock paramBlock;
    ContextualRenderedImageFactory myCRIF;
    Rectangle2D boundingBox;

    public RenderableImageOp(ContextualRenderedImageFactory contextualRenderedImageFactory, ParameterBlock parameterBlock) {
        this.myCRIF = contextualRenderedImageFactory;
        this.paramBlock = (ParameterBlock)parameterBlock.clone();
    }

    @Override
    public Vector<RenderableImage> getSources() {
        return this.getRenderableSources();
    }

    private Vector getRenderableSources() {
        Vector<RenderableImage> vector = null;
        if (this.paramBlock.getNumSources() > 0) {
            Object object;
            vector = new Vector<RenderableImage>();
            for (int i = 0; i < this.paramBlock.getNumSources() && (object = this.paramBlock.getSource(i)) instanceof RenderableImage; ++i) {
                vector.add((RenderableImage)object);
            }
        }
        return vector;
    }

    @Override
    public Object getProperty(String string) {
        return this.myCRIF.getProperty(this.paramBlock, string);
    }

    @Override
    public String[] getPropertyNames() {
        return this.myCRIF.getPropertyNames();
    }

    @Override
    public boolean isDynamic() {
        return this.myCRIF.isDynamic();
    }

    @Override
    public float getWidth() {
        if (this.boundingBox == null) {
            this.boundingBox = this.myCRIF.getBounds2D(this.paramBlock);
        }
        return (float)this.boundingBox.getWidth();
    }

    @Override
    public float getHeight() {
        if (this.boundingBox == null) {
            this.boundingBox = this.myCRIF.getBounds2D(this.paramBlock);
        }
        return (float)this.boundingBox.getHeight();
    }

    @Override
    public float getMinX() {
        if (this.boundingBox == null) {
            this.boundingBox = this.myCRIF.getBounds2D(this.paramBlock);
        }
        return (float)this.boundingBox.getMinX();
    }

    @Override
    public float getMinY() {
        if (this.boundingBox == null) {
            this.boundingBox = this.myCRIF.getBounds2D(this.paramBlock);
        }
        return (float)this.boundingBox.getMinY();
    }

    public ParameterBlock setParameterBlock(ParameterBlock parameterBlock) {
        ParameterBlock parameterBlock2 = this.paramBlock;
        this.paramBlock = (ParameterBlock)parameterBlock.clone();
        return parameterBlock2;
    }

    public ParameterBlock getParameterBlock() {
        return this.paramBlock;
    }

    @Override
    public RenderedImage createScaledRendering(int n, int n2, RenderingHints renderingHints) {
        double d;
        double d2 = (double)n / (double)this.getWidth();
        if (Math.abs(d2 / (d = (double)n2 / (double)this.getHeight()) - 1.0) < 0.01) {
            d2 = d;
        }
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d2, d);
        RenderContext renderContext = new RenderContext(affineTransform, renderingHints);
        return this.createRendering(renderContext);
    }

    @Override
    public RenderedImage createDefaultRendering() {
        AffineTransform affineTransform = new AffineTransform();
        RenderContext renderContext = new RenderContext(affineTransform);
        return this.createRendering(renderContext);
    }

    @Override
    public RenderedImage createRendering(RenderContext renderContext) {
        Object var2_2 = null;
        RenderContext renderContext2 = null;
        ParameterBlock parameterBlock = (ParameterBlock)this.paramBlock.clone();
        Vector vector = this.getRenderableSources();
        try {
            if (vector != null) {
                Vector<Object> vector2 = new Vector<Object>();
                for (int i = 0; i < vector.size(); ++i) {
                    renderContext2 = this.myCRIF.mapRenderContext(i, renderContext, this.paramBlock, this);
                    RenderedImage renderedImage = ((RenderableImage)vector.elementAt(i)).createRendering(renderContext2);
                    if (renderedImage == null) {
                        return null;
                    }
                    vector2.addElement(renderedImage);
                }
                if (vector2.size() > 0) {
                    parameterBlock.setSources(vector2);
                }
            }
            return this.myCRIF.create(renderContext, parameterBlock);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }
}

