/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding.soap.server;

import com.sun.xml.internal.ws.encoding.JAXWSAttachmentMarshaller;
import com.sun.xml.internal.ws.encoding.soap.message.SOAP12FaultInfo;
import com.sun.xml.internal.ws.encoding.soap.message.SOAPFaultInfo;
import com.sun.xml.internal.ws.encoding.soap.server.SOAPXMLEncoder;
import com.sun.xml.internal.ws.handler.MessageContextUtil;
import com.sun.xml.internal.ws.pept.ept.MessageInfo;
import com.sun.xml.internal.ws.server.ServerRtException;
import com.sun.xml.internal.ws.util.MessageInfoUtil;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.handler.MessageContext;

public class SOAP12XMLEncoder
extends SOAPXMLEncoder {
    protected void startEnvelope(XMLStreamWriter xMLStreamWriter) {
        try {
            xMLStreamWriter.writeStartElement("soapenv", "Envelope", "http://www.w3.org/2003/05/soap-envelope");
            xMLStreamWriter.setPrefix("soapenv", "http://www.w3.org/2003/05/soap-envelope");
            xMLStreamWriter.writeNamespace("soapenv", "http://www.w3.org/2003/05/soap-envelope");
        }
        catch (XMLStreamException xMLStreamException) {
            throw new ServerRtException(xMLStreamException);
        }
    }

    protected void startBody(XMLStreamWriter xMLStreamWriter) {
        try {
            xMLStreamWriter.writeStartElement("soapenv", "Body", "http://www.w3.org/2003/05/soap-envelope");
        }
        catch (XMLStreamException xMLStreamException) {
            throw new ServerRtException(xMLStreamException);
        }
    }

    protected void startHeader(XMLStreamWriter xMLStreamWriter) {
        try {
            xMLStreamWriter.writeStartElement("soapenv", "Header", "http://www.w3.org/2003/05/soap-envelope");
        }
        catch (XMLStreamException xMLStreamException) {
            throw new ServerRtException(xMLStreamException);
        }
    }

    protected void writeFault(SOAPFaultInfo sOAPFaultInfo, MessageInfo messageInfo, XMLStreamWriter xMLStreamWriter) {
        if (!(sOAPFaultInfo instanceof SOAP12FaultInfo)) {
            return;
        }
        MessageContext messageContext = MessageInfoUtil.getMessageContext(messageInfo);
        if (MessageContextUtil.getHttpStatusCode(messageContext) == null) {
            MessageContextUtil.setHttpStatusCode(messageContext, 500);
        }
        ((SOAP12FaultInfo)sOAPFaultInfo).write(xMLStreamWriter, messageInfo);
    }

    protected String getContentType(MessageInfo messageInfo, JAXWSAttachmentMarshaller jAXWSAttachmentMarshaller) {
        String string = (String)messageInfo.getMetaData("com.sun.xml.ws.client.ContentNegotiation");
        if (jAXWSAttachmentMarshaller == null) {
            jAXWSAttachmentMarshaller = this.getAttachmentMarshaller(messageInfo);
        }
        if (jAXWSAttachmentMarshaller != null && jAXWSAttachmentMarshaller.isXopped()) {
            return "application/xop+xml;type=\"application/soap+xml\"";
        }
        return string == "optimistic" ? "application/soap+fastinfoset" : "application/soap+xml";
    }

    protected String getBindingId() {
        return "http://www.w3.org/2003/05/soap/bindings/HTTP/";
    }
}

