/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.client.dispatch.impl.encoding;

import com.sun.xml.internal.ws.client.dispatch.impl.encoding.DispatchUtil;
import com.sun.xml.internal.ws.encoding.jaxb.JAXBBeanInfo;
import com.sun.xml.internal.ws.encoding.soap.SOAP12Constants;
import com.sun.xml.internal.ws.encoding.soap.SOAPConstants;
import com.sun.xml.internal.ws.encoding.soap.SerializationException;
import com.sun.xml.internal.ws.streaming.Attributes;
import com.sun.xml.internal.ws.streaming.SourceReaderFactory;
import com.sun.xml.internal.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.internal.ws.streaming.XMLStreamWriterFactory;
import com.sun.xml.internal.ws.util.ByteArrayBuffer;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.WebServiceException;

public final class DispatchSerializer {
    private static final Logger logger = Logger.getLogger(new StringBuffer().append("javax.enterprise.resource.webservices.jaxws").append(".client.dispatch").toString());
    private final QName bodyTagName;
    public static final DispatchSerializer SOAP_1_0 = new DispatchSerializer(SOAPConstants.QNAME_SOAP_BODY);
    public static final DispatchSerializer SOAP_1_2 = new DispatchSerializer(SOAP12Constants.QNAME_SOAP_BODY);

    private DispatchSerializer(QName qName) {
        this.bodyTagName = qName;
    }

    public void serialize(Object object, XMLStreamWriter xMLStreamWriter, JAXBContext jAXBContext) {
        if (object instanceof Source) {
            this.serializeSource(object, xMLStreamWriter);
        } else if (object instanceof JAXBBeanInfo) {
            ((JAXBBeanInfo)object).writeTo(xMLStreamWriter);
        } else {
            throw new WebServiceException("Unable to serialize object type " + object.getClass().getName());
        }
    }

    private static String convertNull(String string) {
        return string != null ? string : "";
    }

    public Source deserializeSource(XMLStreamReader xMLStreamReader, DispatchUtil dispatchUtil) {
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
        XMLStreamWriter xMLStreamWriter = XMLStreamWriterFactory.createXMLStreamWriter(byteArrayBuffer);
        dispatchUtil.populatePrefixes(xMLStreamWriter);
        try {
            while (xMLStreamReader.hasNext()) {
                int n = xMLStreamReader.getEventType();
                switch (n) {
                    case 1: {
                        String string = xMLStreamReader.getNamespaceURI();
                        String string2 = xMLStreamReader.getPrefix();
                        String string3 = xMLStreamReader.getLocalName();
                        this.setWriterPrefixes(string2, string, xMLStreamWriter);
                        String string4 = null;
                        String string5 = xMLStreamWriter.getNamespaceContext().getPrefix(string);
                        if (string5 != null && !"".equals(string5) && string5.length() > 0) {
                            string4 = string5;
                        } else if (string2 != null && !"".equals(string2) && string != null && !"null".equals(string)) {
                            string4 = this.setWriterPrefixes(xMLStreamReader, string, xMLStreamWriter);
                        } else {
                            string4 = DispatchSerializer.convertNull(string4);
                            string = DispatchSerializer.convertNull(string);
                        }
                        xMLStreamWriter.writeStartElement(string4, string3, string);
                        xMLStreamWriter.writeNamespace(string4, string);
                        Attributes attributes = XMLStreamReaderUtil.getAttributes(xMLStreamReader);
                        xMLStreamWriter.flush();
                        this.writeAttributes(attributes, xMLStreamWriter, string4, string);
                        break;
                    }
                    case 2: {
                        xMLStreamWriter.writeEndElement();
                        break;
                    }
                    case 4: {
                        xMLStreamWriter.writeCharacters(xMLStreamReader.getText());
                    }
                }
                n = XMLStreamReaderUtil.next(xMLStreamReader);
                if (xMLStreamReader.getEventType() != 2 || !xMLStreamReader.getName().equals(this.bodyTagName)) continue;
                break;
            }
            xMLStreamWriter.flush();
            xMLStreamWriter.close();
            xMLStreamReader.close();
        }
        catch (XMLStreamException xMLStreamException) {
            xMLStreamException.printStackTrace();
        }
        return new StreamSource(byteArrayBuffer.newInputStream());
    }

    private void writeAttributes(Attributes attributes, XMLStreamWriter xMLStreamWriter, String string, String string2) throws XMLStreamException {
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string3 = attributes.getValue(i);
            String string4 = attributes.getName(i).getLocalPart();
            String string5 = attributes.getPrefix(i);
            String string6 = attributes.getURI(i);
            this.setWriterPrefix(string4, string3, string5, xMLStreamWriter);
            if (attributes.isNamespaceDeclaration(i)) {
                this.writeAttrNamespace(string5, string6, xMLStreamWriter, string4, string, string2, string3);
                continue;
            }
            this.writeAttribute(attributes, i, xMLStreamWriter);
        }
    }

    private void setWriterPrefix(String string, String string2, String string3, XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        if (string.equals("xsi") && string2.equals("http://www.w3.org/2001/XMLSchema-instance") && string3.equals("xmlns")) {
            xMLStreamWriter.setPrefix(string, string2);
        }
    }

    private String setWriterPrefixes(XMLStreamReader xMLStreamReader, String string, XMLStreamWriter xMLStreamWriter) {
        String string2 = xMLStreamReader.getNamespaceContext().getPrefix(string);
        if (string2 == null) {
            string2 = DispatchSerializer.convertNull(string2);
        }
        if (string2 != null && string2.length() > 0 && string != null && !string2.equals("xmlns")) {
            try {
                xMLStreamWriter.setPrefix(string2, string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return string2;
    }

    private void setWriterPrefixes(String string, String string2, XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        if (string != null && string.length() > 0 && string2.length() > 0 && string2 != null && (string.equals("null") || string2.equals("null"))) {
            xMLStreamWriter.setPrefix(string, string2);
        }
    }

    private void writeAttrNamespace(String string, String string2, XMLStreamWriter xMLStreamWriter, String string3, String string4, String string5, String string6) throws XMLStreamException {
        if (string == null || !string.equals("") || string.equals("xmlns")) {
            String string7 = string;
            if (string2 != null) {
                String string8 = xMLStreamWriter.getNamespaceContext().getPrefix(string2);
                if (string.equals("xmlns") && !string3.equals("xsi")) {
                    string = string4;
                    string2 = string5;
                } else if (string8 != null && !string8.equals("xmlns")) {
                    string = string8;
                }
                if (string == null) {
                    DispatchSerializer.convertNull(string);
                }
            }
            this.writeNamespace(string, string4, string2, string5, xMLStreamWriter);
            this.writeXSINamspece(string3, string6, string7, xMLStreamWriter, string, string2);
        }
    }

    private void writeNamespace(String string, String string2, String string3, String string4, XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        if (!(string.equals(string2) && string3.equals(string4) || string.equals("xmlns"))) {
            xMLStreamWriter.writeNamespace(string, string3);
        }
    }

    private void writeXSINamspece(String string, String string2, String string3, XMLStreamWriter xMLStreamWriter, String string4, String string5) throws XMLStreamException {
        if (string.equals("xsi") && string2.equals("http://www.w3.org/2001/XMLSchema-instance") && string3.equals("xmlns")) {
            xMLStreamWriter.setPrefix(string, string2);
            xMLStreamWriter.writeAttribute(string4, string5, string, string2);
        }
    }

    private void writeAttribute(Attributes attributes, int n, XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        if (attributes.getURI(n) == null && attributes.getPrefix(n) != null) {
            String string = xMLStreamWriter.getNamespaceContext().getNamespaceURI(attributes.getURI(n));
            xMLStreamWriter.writeAttribute(attributes.getPrefix(n), string, attributes.getLocalName(n), attributes.getValue(n));
        }
        xMLStreamWriter.writeAttribute(attributes.getPrefix(n), attributes.getURI(n), attributes.getLocalName(n), attributes.getValue(n));
    }

    void serializeSource(Object object, XMLStreamWriter xMLStreamWriter) {
        try {
            int n;
            XMLStreamReader xMLStreamReader = SourceReaderFactory.createSourceReader((Source)object, true);
            block7: do {
                n = XMLStreamReaderUtil.next(xMLStreamReader);
                switch (n) {
                    case 1: {
                        QName qName = xMLStreamReader.getName();
                        String string = qName.getLocalPart();
                        String string2 = qName.getNamespaceURI();
                        String string3 = qName.getPrefix();
                        xMLStreamWriter.writeStartElement(string3, string, string2);
                        Attributes attributes = XMLStreamReaderUtil.getAttributes(xMLStreamReader);
                        xMLStreamWriter.flush();
                        for (int i = 0; i < attributes.getLength(); ++i) {
                            if (attributes.isNamespaceDeclaration(i)) {
                                String string4 = attributes.getValue(i);
                                String string5 = attributes.getName(i).getLocalPart();
                                xMLStreamWriter.setPrefix(string5, string4);
                                xMLStreamWriter.writeNamespace(string5, string4);
                                continue;
                            }
                            xMLStreamWriter.writeAttribute(attributes.getPrefix(i), attributes.getURI(i), attributes.getLocalName(i), attributes.getValue(i));
                        }
                        continue block7;
                    }
                    case 2: {
                        xMLStreamWriter.writeEndElement();
                        break;
                    }
                    case 4: {
                        xMLStreamWriter.writeCharacters(xMLStreamReader.getText());
                    }
                }
            } while (n != 8);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SerializationException(xMLStreamException);
        }
    }
}

