/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.directory;

import java.util.NoSuchElementException;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;

public class BasicAttribute
implements Attribute {
    private static final long serialVersionUID = 6743528196119291326L;
    protected String attrID;
    protected boolean ordered;
    protected transient Vector values;

    private BasicAttribute() {
    }

    public BasicAttribute(String id) {
        this(id, false);
    }

    public BasicAttribute(String id, boolean ordered) {
        this.attrID = id;
        this.ordered = ordered;
        this.values = new Vector();
    }

    public BasicAttribute(String id, Object value) {
        this(id, value, false);
    }

    public BasicAttribute(String id, Object value, boolean ordered) {
        this.attrID = id;
        this.ordered = ordered;
        this.values = new Vector();
        this.values.add(value);
    }

    public void add(int index, Object val) {
        if (!this.ordered && this.contains(val)) {
            throw new IllegalStateException("value already in attribute");
        }
        this.values.add(index, val);
    }

    public boolean add(Object val) {
        if (!this.ordered && this.contains(val)) {
            throw new IllegalStateException("value already in attribute");
        }
        return this.values.add(val);
    }

    public void clear() {
        this.values.clear();
    }

    public Object clone() {
        BasicAttribute c = new BasicAttribute();
        c.attrID = this.attrID;
        c.ordered = this.ordered;
        c.values = (Vector)this.values.clone();
        return c;
    }

    public boolean contains(Object val) {
        for (int i = 0; i < this.values.size(); ++i) {
            if (!this.equals(val, this.values.get(i))) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BasicAttribute)) {
            return false;
        }
        BasicAttribute b = (BasicAttribute)obj;
        if (this.ordered != b.ordered || !this.attrID.equals(b.attrID) || this.values.size() != b.values.size()) {
            return false;
        }
        for (int i = 0; i < this.values.size(); ++i) {
            boolean ok = false;
            if (this.ordered) {
                ok = this.equals(this.values.get(i), b.values.get(i));
            } else {
                for (int j = 0; j < b.values.size(); ++j) {
                    if (!this.equals(this.values.get(i), b.values.get(j))) continue;
                    ok = true;
                    break;
                }
            }
            if (ok) continue;
            return false;
        }
        return true;
    }

    public Object get() throws NamingException {
        if (this.values.size() == 0) {
            throw new NoSuchElementException("no values");
        }
        return this.get(0);
    }

    public Object get(int index) throws NamingException {
        return this.values.get(index);
    }

    public NamingEnumeration getAll() throws NamingException {
        return new BasicAttributeEnumeration(this);
    }

    public DirContext getAttributeDefinition() throws OperationNotSupportedException, NamingException {
        throw new OperationNotSupportedException();
    }

    public DirContext getAttributeSyntaxDefinition() throws OperationNotSupportedException, NamingException {
        throw new OperationNotSupportedException();
    }

    public String getID() {
        return this.attrID;
    }

    public int hashCode() {
        int val = this.attrID.hashCode();
        for (int i = 0; i < this.values.size(); ++i) {
            Object o = this.values.get(i);
            if (o == null) continue;
            if (o instanceof Object[]) {
                Object[] a = (Object[])o;
                for (int j = 0; j < a.length; ++j) {
                    val += a[j].hashCode();
                }
                continue;
            }
            val += o.hashCode();
        }
        return val;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public Object remove(int index) {
        return this.values.remove(index);
    }

    public boolean remove(Object val) {
        for (int i = 0; i < this.values.size(); ++i) {
            if (!this.equals(val, this.values.get(i))) continue;
            this.values.remove(i);
            return true;
        }
        return false;
    }

    public Object set(int index, Object val) {
        if (!this.ordered && this.contains(val)) {
            throw new IllegalStateException("value already in attribute");
        }
        return this.values.set(index, val);
    }

    public int size() {
        return this.values.size();
    }

    public String toString() {
        String r = this.attrID;
        for (int i = 0; i < this.values.size(); ++i) {
            r = r + new StringBuffer(";").append(this.values.get(i).toString());
        }
        return r;
    }

    private boolean equals(Object one, Object two) {
        if (one == null) {
            return two == null;
        }
        if (one instanceof Object[]) {
            if (!(two instanceof Object[])) {
                return false;
            }
            Object[] aone = (Object[])one;
            Object[] atwo = (Object[])two;
            if (aone.length != atwo.length) {
                return false;
            }
            for (int i = 0; i < aone.length; ++i) {
                if (aone[i].equals(atwo[i])) continue;
                return false;
            }
            return true;
        }
        return one.equals(two);
    }

    private class BasicAttributeEnumeration
    implements NamingEnumeration {
        private /* synthetic */ BasicAttribute this$0;
        int where;

        private /* synthetic */ void finit$() {
            this.where = -1;
        }

        public BasicAttributeEnumeration(BasicAttribute this$0) {
            this.this$0 = this$0;
            this.finit$();
        }

        public void close() throws NamingException {
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public boolean hasMoreElements() {
            return this.where < this.this$0.values.size();
        }

        public Object nextElement() throws NoSuchElementException {
            if (this.where + 1 >= this.this$0.values.size()) {
                throw new NoSuchElementException("no more elements");
            }
            ++this.where;
            return this.this$0.values.get(this.where);
        }
    }
}

