/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.ByteOrder;
import java.nio.IntBufferImpl;
import java.nio.ReadOnlyBufferException;

public abstract class IntBuffer
extends Buffer
implements Comparable {
    int array_offset;
    int[] backing_buffer;

    IntBuffer(int capacity, int limit, int position, int mark) {
        super(capacity, limit, position, mark);
        this.array_offset = 0;
    }

    IntBuffer(int[] buffer, int offset, int capacity, int limit, int position, int mark) {
        super(capacity, limit, position, mark);
        this.backing_buffer = buffer;
        this.array_offset = offset;
    }

    public static IntBuffer allocate(int capacity) {
        return new IntBufferImpl(capacity);
    }

    public static final IntBuffer wrap(int[] array, int offset, int length) {
        return new IntBufferImpl(array, 0, array.length, offset + length, offset, -1, false);
    }

    public static final IntBuffer wrap(int[] array) {
        return IntBuffer.wrap(array, 0, array.length);
    }

    public IntBuffer get(int[] dst, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            dst[i] = this.get();
        }
        return this;
    }

    public IntBuffer get(int[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public IntBuffer put(IntBuffer src) {
        if (src == this) {
            throw new IllegalArgumentException();
        }
        if (src.remaining() > this.remaining()) {
            throw new BufferOverflowException();
        }
        if (src.remaining() > 0) {
            int[] toPut = new int[src.remaining()];
            src.get(toPut);
            src.put(toPut);
        }
        return this;
    }

    public IntBuffer put(int[] src, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            this.put(src[i]);
        }
        return this;
    }

    public final IntBuffer put(int[] src) {
        return this.put(src, 0, src.length);
    }

    public final boolean hasArray() {
        return this.backing_buffer != null && this.isReadOnly() ^ true;
    }

    public final int[] array() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        return this.backing_buffer;
    }

    public final int arrayOffset() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        return this.array_offset;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IntBuffer) {
            return this.compareTo(obj) == 0;
        }
        return false;
    }

    public int compareTo(Object obj) {
        IntBuffer a = (IntBuffer)obj;
        if (a.remaining() != this.remaining()) {
            return 1;
        }
        if (!this.hasArray() || !a.hasArray()) {
            return 1;
        }
        int r = this.remaining();
        int i1 = this.position();
        int i2 = a.position();
        for (int i = 0; i < r; ++i) {
            int t = this.get(i1) - a.get(i2);
            if (t == 0) continue;
            return t;
        }
        return 0;
    }

    public abstract ByteOrder order();

    public abstract int get();

    public abstract IntBuffer put(int var1);

    public abstract int get(int var1);

    public abstract IntBuffer put(int var1, int var2);

    public abstract IntBuffer compact();

    public abstract boolean isDirect();

    public abstract IntBuffer slice();

    public abstract IntBuffer duplicate();

    public abstract IntBuffer asReadOnlyBuffer();
}

