/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Integer
extends Number
implements Comparable {
    private static final long serialVersionUID = 1360826667806852920L;
    public static final int MIN_VALUE = -2147483648;
    public static final int MAX_VALUE = 0x7FFFFFFF;
    public static final Class TYPE = VMClassLoader.getPrimitiveClass('I');
    private final int value;

    public Integer(int value) {
        this.value = value;
    }

    public Integer(String s) {
        this.value = Integer.parseInt(s, 10, false);
    }

    public static String toString(int num, int radix) {
        if (radix < 2 || radix > 36) {
            radix = 10;
        }
        char[] buffer = new char[33];
        int i = 33;
        boolean isNeg = false;
        if (num < 0) {
            isNeg = true;
            if ((num = -num) < 0) {
                buffer[--i] = Number.digits[-(num + radix) % radix];
                num = -(num / radix);
            }
        }
        do {
            buffer[--i] = Number.digits[num % radix];
        } while ((num /= radix) > 0);
        if (isNeg) {
            buffer[--i] = 45;
        }
        return new String(buffer, i, 33 - i, true);
    }

    public static String toHexString(int i) {
        return Integer.toUnsignedString(i, 4);
    }

    public static String toOctalString(int i) {
        return Integer.toUnsignedString(i, 3);
    }

    public static String toBinaryString(int i) {
        return Integer.toUnsignedString(i, 1);
    }

    public static String toString(int i) {
        return String.valueOf(i);
    }

    public static int parseInt(String str, int radix) {
        return Integer.parseInt(str, radix, false);
    }

    public static int parseInt(String s) {
        return Integer.parseInt(s, 10, false);
    }

    public static Integer valueOf(String s, int radix) {
        return new Integer(Integer.parseInt(s, radix, false));
    }

    public static Integer valueOf(String s) {
        return new Integer(Integer.parseInt(s, 10, false));
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        return obj instanceof Integer && this.value == ((Integer)obj).value;
    }

    public static Integer getInteger(String nm) {
        return Integer.getInteger(nm, null);
    }

    public static Integer getInteger(String nm, int val) {
        Integer result = Integer.getInteger(nm, null);
        if (result == null) {
            return new Integer(val);
        }
        return result;
    }

    public static Integer getInteger(String nm, Integer def) {
        if (nm == null || "".equals(nm)) {
            return def;
        }
        if ((nm = System.getProperty(nm)) == null) {
            return def;
        }
        try {
            return Integer.decode(nm);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public static Integer decode(String str) {
        return new Integer(Integer.parseInt(str, 10, true));
    }

    public int compareTo(Integer i) {
        if (this.value == i.value) {
            return 0;
        }
        if (this.value > i.value) {
            return 1;
        }
        return -1;
    }

    public int compareTo(Object o) {
        return this.compareTo((Integer)o);
    }

    static String toUnsignedString(int num, int exp) {
        int mask = (1 << (exp & 0x1F)) - 1;
        char[] buffer = new char[32];
        int i = 32;
        do {
            buffer[--i] = Number.digits[num & mask];
        } while ((num >>>= exp & 0x1F) != 0);
        return new String(buffer, i, 32 - i, true);
    }

    static int parseInt(String str, int radix, boolean decode) {
        if (!decode && str == null) {
            throw new NumberFormatException();
        }
        int index = 0;
        int len = str.length();
        boolean isNeg = false;
        if (len == 0) {
            throw new NumberFormatException();
        }
        int ch = str.charAt(index);
        if (ch == 45) {
            if (len == 1) {
                throw new NumberFormatException();
            }
            isNeg = true;
            ch = str.charAt(++index);
        }
        if (decode) {
            if (ch == 48) {
                if (++index == len) {
                    return 0;
                }
                if ((str.charAt(index) & 0xFFFFFFDF) == 88) {
                    radix = 16;
                    ++index;
                } else {
                    radix = 8;
                }
            } else if (ch == 35) {
                radix = 16;
                ++index;
            }
        }
        if (index == len) {
            throw new NumberFormatException();
        }
        int max = Integer.MAX_VALUE / radix;
        if (isNeg && Integer.MAX_VALUE % radix == radix - 1) {
            ++max;
        }
        int val = 0;
        while (index < len) {
            if (val < 0 || val > max) {
                throw new NumberFormatException();
            }
            ch = Character.digit(str.charAt(index++), radix);
            val = val * radix + ch;
            if (ch >= 0 && (val >= 0 || isNeg && val == Integer.MIN_VALUE)) continue;
            throw new NumberFormatException();
        }
        if (isNeg) {
            return -val;
        }
        return val;
    }
}

