/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileChannelImpl;

public class FileOutputStream
extends OutputStream {
    private FileDescriptor fd;
    private FileChannel ch;

    public FileOutputStream(String path, boolean append) throws SecurityException, FileNotFoundException {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkWrite(path);
        }
        this.fd = new FileDescriptor(path, append ? 6 : 2);
    }

    public FileOutputStream(String path) throws SecurityException, FileNotFoundException {
        this(path, false);
    }

    public FileOutputStream(File file) throws SecurityException, FileNotFoundException {
        this(file.getPath(), false);
    }

    public FileOutputStream(File file, boolean append) throws FileNotFoundException {
        this(file.getPath(), append);
    }

    public FileOutputStream(FileDescriptor fdObj) throws SecurityException {
        if (!fdObj.valid()) {
            throw new SecurityException("Invalid FileDescriptor");
        }
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkWrite(fdObj);
        }
        this.fd = fdObj;
    }

    protected void finalize() throws IOException {
    }

    public final FileDescriptor getFD() throws IOException {
        if (!this.fd.valid()) {
            throw new IOException();
        }
        return this.fd;
    }

    public void write(int b) throws IOException {
        this.fd.write(b);
    }

    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(byte[] buf, int offset, int len) throws IOException {
        if (offset < 0 || len < 0 || offset + len > buf.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.fd.write(buf, offset, len);
    }

    public void close() throws IOException {
        if (this.fd.valid()) {
            this.fd.close();
        }
    }

    public synchronized FileChannel getChannel() {
        if (this.ch == null) {
            this.ch = new FileChannelImpl(this.fd, true, this);
        }
        return this.ch;
    }
}

