/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.proxy;

import com.sun.deploy.config.Config;
import com.sun.deploy.net.protocol.rmi.DeployRMISocketFactory;
import com.sun.deploy.net.proxy.BrowserProxyConfigCanonicalizer;
import com.sun.deploy.net.proxy.BrowserProxyInfo;
import com.sun.deploy.net.proxy.UserDefinedProxyConfig;
import com.sun.deploy.services.Service;
import com.sun.deploy.services.ServiceManager;
import com.sun.deploy.ui.UIFactory;
import com.sun.deploy.util.Trace;
import java.rmi.server.RMISocketFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;

public class StaticProxyManager {
    public static void reset() {
        try {
            Object object;
            UserDefinedProxyConfig userDefinedProxyConfig = new UserDefinedProxyConfig();
            BrowserProxyInfo browserProxyInfo = userDefinedProxyConfig.getBrowserProxyInfo();
            Service service = ServiceManager.getService();
            if (browserProxyInfo.getType() == 3) {
                object = service.getProxyConfig();
                browserProxyInfo = object.getBrowserProxyInfo();
            } else if (browserProxyInfo.getType() == 2) {
                object = new BrowserProxyConfigCanonicalizer(userDefinedProxyConfig, service.getAutoProxyHandler());
                browserProxyInfo = ((BrowserProxyConfigCanonicalizer)object).getBrowserProxyInfo();
            }
            try {
                if (browserProxyInfo.getType() != 0) {
                    RMISocketFactory.setSocketFactory((RMISocketFactory)((Object)new DeployRMISocketFactory()));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            object = browserProxyInfo;
            AccessController.doPrivileged(new PrivilegedAction((BrowserProxyInfo)object){
                private final /* synthetic */ BrowserProxyInfo val$info;
                {
                    this.val$info = browserProxyInfo;
                }

                public Object run() {
                    StaticProxyManager.setProperties(this.val$info);
                    return null;
                }
            });
            Trace.msgNetPrintln(browserProxyInfo.toString());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            UIFactory.showExceptionDialog(null, throwable, null, null);
        }
    }

    private static void setProperties(BrowserProxyInfo browserProxyInfo) {
        Properties properties = System.getProperties();
        boolean bl = !Config.isJavaVersionAtLeast14();
        switch (browserProxyInfo.getType()) {
            case 0: {
                properties.remove("trustProxy");
                if (bl) {
                    properties.remove("proxyHost");
                    properties.remove("proxyPort");
                }
                properties.remove("http.proxyHost");
                properties.remove("http.proxyPort");
                properties.remove("http.nonProxyHosts");
                properties.remove("https.proxyHost");
                properties.remove("https.proxyPort");
                properties.remove("https.nonProxyHosts");
                properties.remove("ftp.proxyHost");
                properties.remove("ftp.proxyPort");
                properties.remove("ftp.nonProxyHosts");
                properties.remove("gopherProxySet");
                properties.remove("gopherProxyHost");
                properties.remove("gopherProxyPort");
                properties.remove("socksProxyHost");
                properties.remove("socksProxyPort");
                break;
            }
            case 1: 
            case 2: {
                properties.put("trustProxy", "true");
                if (browserProxyInfo.getHttpHost() != null) {
                    if (bl) {
                        properties.put("proxyHost", browserProxyInfo.getHttpHost());
                        properties.put("proxyPort", String.valueOf(browserProxyInfo.getHttpPort()));
                    }
                    properties.put("http.proxyHost", browserProxyInfo.getHttpHost());
                    properties.put("http.proxyPort", String.valueOf(browserProxyInfo.getHttpPort()));
                    properties.put("http.nonProxyHosts", browserProxyInfo.getOverridesString());
                }
                if (browserProxyInfo.getHttpsHost() != null) {
                    properties.put("https.proxyHost", browserProxyInfo.getHttpsHost());
                    properties.put("https.proxyPort", String.valueOf(browserProxyInfo.getHttpsPort()));
                    properties.put("https.nonProxyHosts", browserProxyInfo.getOverridesString());
                }
                if (browserProxyInfo.getFtpHost() != null) {
                    properties.put("ftp.proxyHost", browserProxyInfo.getFtpHost());
                    properties.put("ftp.proxyPort", String.valueOf(browserProxyInfo.getFtpPort()));
                    properties.put("ftp.nonProxyHosts", browserProxyInfo.getOverridesString());
                }
                if (browserProxyInfo.getGopherHost() != null) {
                    properties.put("gopherProxySet", "true");
                    properties.put("gopherProxyHost", browserProxyInfo.getGopherHost());
                    properties.put("gopherProxyPort", String.valueOf(browserProxyInfo.getGopherPort()));
                }
                if (browserProxyInfo.getHttpHost() != null || browserProxyInfo.getSocksHost() == null) break;
                properties.put("socksProxyHost", browserProxyInfo.getSocksHost());
                properties.put("socksProxyPort", String.valueOf(browserProxyInfo.getSocksPort()));
                break;
            }
            case 3: {
                throw new IllegalStateException("StaticProxyManager:  ProxyType should not be BROWSER");
            }
        }
        System.setProperties(properties);
    }
}

