/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Clipping;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java2d.AnimatingControlsSurface;
import java2d.CustomControls;
import javax.swing.AbstractButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class ClipAnim
extends AnimatingControlsSurface {
    private static Image dimg;
    private static Image cimg;
    private static Color redBlend;
    private static Color greenBlend;
    private static BasicStroke bs;
    static TexturePaint texture;
    private AnimVal[] animval = new AnimVal[3];
    protected boolean doObjects = true;
    private Font originalFont = new Font("serif", 0, 12);
    private Font font;
    private GradientPaint gradient;
    private int strX;
    private int strY;
    private int dukeX;
    private int dukeY;

    public ClipAnim() {
        cimg = this.getImage("clouds.jpg");
        dimg = this.getImage("duke.gif");
        this.setBackground(Color.WHITE);
        this.animval[0] = new AnimVal(true);
        this.animval[1] = new AnimVal(false);
        this.animval[2] = new AnimVal(false);
        this.setControls(new Component[]{new DemoControls(this)});
    }

    public void reset(int n, int n2) {
        for (AnimVal animVal : this.animval) {
            animVal.reset(n, n2);
        }
        this.gradient = new GradientPaint(0.0f, n2 / 2, Color.RED, (float)n * 0.4f, (float)n2 * 0.9f, Color.YELLOW);
        this.dukeX = (int)((double)n * 0.25 - (double)(dimg.getWidth(this) / 2));
        this.dukeY = (int)((double)n2 * 0.25 - (double)(dimg.getHeight(this) / 2));
        Object object = this.getFontMetrics(this.originalFont);
        double d = ((FontMetrics)object).stringWidth("CLIPPING");
        double d2 = ((FontMetrics)object).getAscent() + ((FontMetrics)object).getDescent();
        double d3 = (double)(n / 2 - 30) / d;
        double d4 = (double)(n2 / 2 - 30) / d2;
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d3, d4);
        this.font = this.originalFont.deriveFont(affineTransform);
        object = this.getFontMetrics(this.font);
        this.strX = (int)((double)n * 0.75 - (double)(((FontMetrics)object).stringWidth("CLIPPING") / 2));
        this.strY = (int)((double)n2 * 0.72 + (double)(((FontMetrics)object).getAscent() / 2));
    }

    public void step(int n, int n2) {
        for (AnimVal animVal : this.animval) {
            if (!animVal.isSelected) continue;
            animVal.step(n, n2);
        }
    }

    public void render(int n, int n2, Graphics2D graphics2D) {
        GeneralPath generalPath = new GeneralPath();
        GeneralPath generalPath2 = new GeneralPath();
        for (AnimVal animVal : this.animval) {
            if (!animVal.isSelected) continue;
            double d = animVal.x;
            double d2 = animVal.y;
            double d3 = animVal.ew;
            double d4 = animVal.eh;
            generalPath.append(new Ellipse2D.Double(d, d2, d3, d4), false);
            generalPath2.append(new Rectangle2D.Double(d + 5.0, d2 + 5.0, d3 - 10.0, d4 - 10.0), false);
        }
        if (this.animval[0].isSelected || this.animval[1].isSelected || this.animval[2].isSelected) {
            graphics2D.setClip(generalPath);
            graphics2D.clip(generalPath2);
        }
        if (this.doObjects) {
            int n3 = n / 2;
            int n4 = n2 / 2;
            graphics2D.drawImage(cimg, 0, 0, n3, n4, null);
            graphics2D.drawImage(dimg, this.dukeX, this.dukeY, null);
            graphics2D.setPaint(texture);
            graphics2D.fillRect(n3, 0, n3, n4);
            graphics2D.setPaint(this.gradient);
            graphics2D.fillRect(0, n4, n3, n4);
            graphics2D.setColor(Color.LIGHT_GRAY);
            graphics2D.fillRect(n3, n4, n3, n4);
            graphics2D.setColor(Color.RED);
            graphics2D.drawOval(n3, n4, n3 - 1, n4 - 1);
            graphics2D.setFont(this.font);
            graphics2D.drawString("CLIPPING", this.strX, this.strY);
        } else {
            graphics2D.setColor(Color.LIGHT_GRAY);
            graphics2D.fillRect(0, 0, n, n2);
        }
    }

    public static void main(String[] stringArray) {
        ClipAnim.createDemoFrame(new ClipAnim());
    }

    static {
        redBlend = new Color(255, 0, 0, 120);
        greenBlend = new Color(0, 255, 0, 120);
        bs = new BasicStroke(20.0f);
        BufferedImage bufferedImage = new BufferedImage(5, 5, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setBackground(Color.YELLOW);
        graphics2D.clearRect(0, 0, 5, 5);
        graphics2D.setColor(Color.RED);
        graphics2D.fillRect(0, 0, 3, 3);
        texture = new TexturePaint(bufferedImage, new Rectangle(0, 0, 5, 5));
    }

    static class DemoControls
    extends CustomControls
    implements ActionListener {
        ClipAnim demo;
        JToolBar toolbar;

        public DemoControls(ClipAnim clipAnim) {
            super(clipAnim.name);
            this.demo = clipAnim;
            this.toolbar = new JToolBar();
            this.add(this.toolbar);
            this.toolbar.setFloatable(false);
            this.addTool("Objects", true);
            this.addTool("Clip1", true);
            this.addTool("Clip2", false);
            this.addTool("Clip3", false);
        }

        public void addTool(String string, boolean bl) {
            JToggleButton jToggleButton = (JToggleButton)this.toolbar.add(new JToggleButton(string));
            jToggleButton.setFocusPainted(false);
            jToggleButton.setSelected(bl);
            jToggleButton.addActionListener(this);
            int n = jToggleButton.getPreferredSize().width;
            Dimension dimension = new Dimension(n, 21);
            jToggleButton.setPreferredSize(dimension);
            jToggleButton.setMaximumSize(dimension);
            jToggleButton.setMinimumSize(dimension);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
            if (jToggleButton.getText().equals("Objects")) {
                this.demo.doObjects = jToggleButton.isSelected();
            } else if (jToggleButton.getText().equals("Clip1")) {
                ((ClipAnim)this.demo).animval[0].isSelected = jToggleButton.isSelected();
            } else if (jToggleButton.getText().equals("Clip2")) {
                ((ClipAnim)this.demo).animval[1].isSelected = jToggleButton.isSelected();
            } else if (jToggleButton.getText().equals("Clip3")) {
                ((ClipAnim)this.demo).animval[2].isSelected = jToggleButton.isSelected();
            }
            if (this.demo.animating.thread == null) {
                this.demo.repaint();
            }
        }

        public Dimension getPreferredSize() {
            return new Dimension(200, 40);
        }

        public void run() {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            ((AbstractButton)this.toolbar.getComponentAtIndex(2)).doClick();
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            if (this.getSize().width > 400) {
                ((AbstractButton)this.toolbar.getComponentAtIndex(3)).doClick();
            }
            this.thread = null;
        }
    }

    public class AnimVal {
        double ix = 5.0;
        double iy = 3.0;
        double iw = 5.0;
        double ih = 3.0;
        double x;
        double y;
        double ew;
        double eh;
        boolean isSelected;

        public AnimVal(boolean bl) {
            this.isSelected = bl;
        }

        public void step(int n, int n2) {
            this.x += this.ix;
            this.y += this.iy;
            this.ew += this.iw;
            this.eh += this.ih;
            if (this.ew > (double)(n / 2)) {
                this.ew = n / 2;
                this.iw = Math.random() * (double)(-n) / 16.0 - 1.0;
            }
            if (this.ew < (double)(n / 8)) {
                this.ew = n / 8;
                this.iw = Math.random() * (double)n / 16.0 + 1.0;
            }
            if (this.eh > (double)(n2 / 2)) {
                this.eh = n2 / 2;
                this.ih = Math.random() * (double)(-n2) / 16.0 - 1.0;
            }
            if (this.eh < (double)(n2 / 8)) {
                this.eh = n2 / 8;
                this.ih = Math.random() * (double)n2 / 16.0 + 1.0;
            }
            if (this.x + this.ew > (double)n) {
                this.x = (double)n - this.ew - 1.0;
                this.ix = Math.random() * (double)(-n) / 32.0 - 1.0;
            }
            if (this.y + this.eh > (double)n2) {
                this.y = (double)n2 - this.eh - 2.0;
                this.iy = Math.random() * (double)(-n2) / 32.0 - 1.0;
            }
            if (this.x < 0.0) {
                this.x = 2.0;
                this.ix = Math.random() * (double)n / 32.0 + 1.0;
            }
            if (this.y < 0.0) {
                this.y = 2.0;
                this.iy = Math.random() * (double)n2 / 32.0 + 1.0;
            }
        }

        public void reset(int n, int n2) {
            this.x = Math.random() * (double)n;
            this.y = Math.random() * (double)n2;
            this.ew = Math.random() * (double)n / 2.0;
            this.eh = Math.random() * (double)n2 / 2.0;
        }
    }
}

