/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.io.IOException;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerDelegate;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.swing.Icon;
import sun.tools.jconsole.MBeansTab;
import sun.tools.jconsole.inspector.IconManager;

public class XMBean {
    private ObjectName objectName;
    private Icon icon;
    private String text;
    private boolean broadcaster;
    private MBeanInfo mbeanInfo;
    private MBeansTab mbeansTab;

    public XMBean(ObjectName objectName, MBeansTab mBeansTab) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        this.mbeansTab = mBeansTab;
        this.setObjectName(objectName);
        this.icon = MBeanServerDelegate.DELEGATE_NAME.equals(objectName) ? IconManager.MBEANSERVERDELEGATE : IconManager.MBEAN;
        this.broadcaster = this.isBroadcaster(objectName);
        this.mbeanInfo = this.getMBeanInfo(objectName);
    }

    MBeanServerConnection getMBeanServerConnection() {
        return this.mbeansTab.getMBeanServerConnection();
    }

    public boolean isBroadcaster() {
        return this.broadcaster;
    }

    private boolean isBroadcaster(ObjectName objectName) {
        try {
            return this.getMBeanServerConnection().isInstanceOf(objectName, "javax.management.NotificationBroadcaster");
        }
        catch (Exception exception) {
            System.out.println("Error calling isBroadcaster: " + exception.getMessage());
            return false;
        }
    }

    public Object invoke(String string) throws Exception {
        Object object = this.getMBeanServerConnection().invoke(this.getObjectName(), string, new Object[0], new String[0]);
        return object;
    }

    public Object invoke(String string, Object[] objectArray, String[] stringArray) throws Exception {
        Object object = this.getMBeanServerConnection().invoke(this.getObjectName(), string, objectArray, stringArray);
        return object;
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InstanceNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        this.getMBeanServerConnection().setAttribute(this.getObjectName(), attribute);
    }

    public Object getAttribute(String string) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        return this.getMBeanServerConnection().getAttribute(this.getObjectName(), string);
    }

    public AttributeList getAttributes(String[] stringArray) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        return this.getMBeanServerConnection().getAttributes(this.getObjectName(), stringArray);
    }

    public AttributeList getAttributes(MBeanAttributeInfo[] mBeanAttributeInfoArray) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        String[] stringArray = new String[mBeanAttributeInfoArray.length];
        for (int i = 0; i < mBeanAttributeInfoArray.length; ++i) {
            stringArray[i] = mBeanAttributeInfoArray[i].getName();
        }
        return this.getAttributes(stringArray);
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    private void setObjectName(ObjectName objectName) {
        this.objectName = objectName;
        String string = this.getObjectName().getKeyProperty("name");
        if (string == null) {
            this.setText(this.getObjectName().getDomain());
        } else {
            this.setText(string);
        }
    }

    public MBeanInfo getMBeanInfo() {
        return this.mbeanInfo;
    }

    private MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        return this.getMBeanServerConnection().getMBeanInfo(objectName);
    }

    public boolean equals(Object object) {
        if (object instanceof XMBean) {
            XMBean xMBean = (XMBean)object;
            return this.getObjectName().equals(xMBean.getObjectName());
        }
        return false;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public String toString() {
        return this.getText();
    }
}

