/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.ToolTipManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import sun.tools.jconsole.BorderedComponent;
import sun.tools.jconsole.Formatter;
import sun.tools.jconsole.HTMLPane;
import sun.tools.jconsole.LabeledComponent;
import sun.tools.jconsole.OverviewPanel;
import sun.tools.jconsole.Plotter;
import sun.tools.jconsole.PlotterPanel;
import sun.tools.jconsole.ProxyClient;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.Tab;
import sun.tools.jconsole.TimeComboBox;
import sun.tools.jconsole.Utilities;
import sun.tools.jconsole.VMPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MemoryTab
extends Tab
implements ActionListener,
ItemListener {
    JComboBox plotterChoice;
    TimeComboBox timeComboBox;
    JButton gcButton;
    PlotterPanel plotterPanel;
    JPanel bottomPanel;
    HTMLPane details;
    PoolChart poolChart;
    ArrayList<Plotter> plotterList;
    Plotter heapPlotter;
    Plotter nonHeapPlotter;
    private MemoryOverviewPanel overviewPanel;
    private static final String usedKey = "used";
    private static final String committedKey = "committed";
    private static final String maxKey = "max";
    private static final String thresholdKey = "threshold";
    private static final String usedName = Resources.getText("Used", new Object[0]);
    private static final String committedName = Resources.getText("Committed", new Object[0]);
    private static final String maxName = Resources.getText("Max", new Object[0]);
    private static final String thresholdName = Resources.getText("Threshold", new Object[0]);
    private static final Color usedColor = Plotter.defaultColor;
    private static final Color committedColor = null;
    private static final Color maxColor = null;
    private static final Color thresholdColor = Color.red;
    private static final String infoLabelFormat = "MemoryTab.infoLabelFormat";

    public static String getTabName() {
        return Resources.getText("Memory", new Object[0]);
    }

    public MemoryTab(VMPanel vMPanel) {
        super(vMPanel, MemoryTab.getTabName());
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(new EmptyBorder(4, 4, 3, 4));
        JPanel jPanel = new JPanel(new BorderLayout());
        this.plotterPanel = new PlotterPanel(null);
        this.bottomPanel = new JPanel(new BorderLayout());
        this.add((Component)jPanel, "North");
        this.add((Component)this.plotterPanel, "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout(3, 20, 5));
        jPanel.add((Component)jPanel2, "Center");
        this.plotterChoice = new JComboBox();
        this.plotterChoice.addItemListener(this);
        jPanel2.add(new LabeledComponent(Resources.getText("Chart:", new Object[0]), Resources.getMnemonicInt("Chart:"), this.plotterChoice));
        this.timeComboBox = new TimeComboBox(new Plotter[0]);
        jPanel2.add(new LabeledComponent(Resources.getText("Time Range:", new Object[0]), Resources.getMnemonicInt("Time Range:"), this.timeComboBox));
        this.gcButton = new JButton(Resources.getText("Perform GC", new Object[0]));
        this.gcButton.setMnemonic(Resources.getMnemonicInt("Perform GC"));
        this.gcButton.addActionListener(this);
        this.gcButton.setToolTipText(Resources.getText("Perform GC.toolTip", new Object[0]));
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(new EmptyBorder(0, 57, 0, 70));
        jPanel3.add(this.gcButton);
        jPanel.add((Component)jPanel3, "After");
        this.bottomPanel.setBorder(new CompoundBorder(new TitledBorder(Resources.getText("Details", new Object[0])), new EmptyBorder(10, 10, 10, 10)));
        this.details = new HTMLPane();
        Utilities.setAccessibleName(this.details, Resources.getText("Details", new Object[0]));
        this.bottomPanel.add((Component)new JScrollPane(this.details), "Center");
        this.poolChart = new PoolChart();
        this.bottomPanel.add((Component)this.poolChart, "After");
    }

    private void createPlotters() throws IOException {
        this.plotterList = new ArrayList();
        ProxyClient proxyClient = this.vmPanel.getProxyClient();
        this.heapPlotter = new Plotter(Plotter.Unit.BYTES){

            public String toString() {
                return Resources.getText("Heap Memory Usage", new Object[0]);
            }
        };
        proxyClient.addWeakPropertyChangeListener(this.heapPlotter);
        this.nonHeapPlotter = new Plotter(Plotter.Unit.BYTES){

            public String toString() {
                return Resources.getText("Non-Heap Memory Usage", new Object[0]);
            }
        };
        Utilities.setAccessibleName(this.heapPlotter, Resources.getText("MemoryTab.heapPlotter.accessibleName", new Object[0]));
        Utilities.setAccessibleName(this.nonHeapPlotter, Resources.getText("MemoryTab.nonHeapPlotter.accessibleName", new Object[0]));
        proxyClient.addWeakPropertyChangeListener(this.nonHeapPlotter);
        this.heapPlotter.createSequence(usedKey, usedName, usedColor, true);
        this.heapPlotter.createSequence(committedKey, committedName, committedColor, false);
        this.heapPlotter.createSequence(maxKey, maxName, maxColor, false);
        this.nonHeapPlotter.createSequence(usedKey, usedName, usedColor, true);
        this.nonHeapPlotter.createSequence(committedKey, committedName, committedColor, false);
        this.nonHeapPlotter.createSequence(maxKey, maxName, maxColor, false);
        this.plotterList.add(this.heapPlotter);
        this.plotterList.add(this.nonHeapPlotter);
        Map<ObjectName, MBeanInfo> map = proxyClient.getMBeans("java.lang");
        Set<ObjectName> set = map.keySet();
        ObjectName[] objectNameArray = set.toArray(new ObjectName[set.size()]);
        ArrayList<PoolPlotter> arrayList = new ArrayList<PoolPlotter>(2);
        for (ObjectName objectName : objectNameArray) {
            String string = objectName.getKeyProperty("type");
            if (!string.equals("MemoryPool")) continue;
            String string2 = Resources.getText("MemoryPoolLabel", objectName.getKeyProperty("name"));
            boolean bl = false;
            AttributeList attributeList = proxyClient.getAttributes(objectName, new String[]{"Type"});
            if (attributeList.size() > 0) {
                bl = MemoryType.HEAP.name().equals(((Attribute)attributeList.get(0)).getValue());
            }
            PoolPlotter poolPlotter = new PoolPlotter(objectName, string2, bl);
            proxyClient.addWeakPropertyChangeListener(poolPlotter);
            poolPlotter.createSequence(usedKey, usedName, usedColor, true);
            poolPlotter.createSequence(committedKey, committedName, committedColor, false);
            poolPlotter.createSequence(maxKey, maxName, maxColor, false);
            poolPlotter.createSequence(thresholdKey, thresholdName, thresholdColor, false);
            poolPlotter.setUseDashedTransitions(thresholdKey, true);
            if (bl) {
                this.plotterList.add(poolPlotter);
                continue;
            }
            arrayList.add(poolPlotter);
        }
        for (PoolPlotter poolPlotter : arrayList) {
            this.plotterList.add(poolPlotter);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            Plotter plotter = (Plotter)this.plotterChoice.getSelectedItem();
            this.plotterPanel.setPlotter(plotter);
        }
    }

    public void gc() {
        new Thread("MemoryPanel.gc"){

            public void run() {
                ProxyClient proxyClient = MemoryTab.this.vmPanel.getProxyClient();
                try {
                    proxyClient.getMemoryMXBean().gc();
                }
                catch (UndeclaredThrowableException undeclaredThrowableException) {
                    proxyClient.markAsDead();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }.start();
    }

    @Override
    public SwingWorker<?, ?> newSwingWorker() {
        return new SwingWorker<Boolean, Object>(){
            private long[] used;
            private long[] committed;
            private long[] max;
            private long[] threshold;
            private long timeStamp;
            private String detailsStr;
            private boolean initialRun = false;

            @Override
            public Boolean doInBackground() {
                ProxyClient proxyClient = MemoryTab.this.vmPanel.getProxyClient();
                if (MemoryTab.this.plotterList == null) {
                    try {
                        MemoryTab.this.createPlotters();
                    }
                    catch (UndeclaredThrowableException undeclaredThrowableException) {
                        proxyClient.markAsDead();
                        return false;
                    }
                    catch (IOException iOException) {
                        return false;
                    }
                    this.initialRun = true;
                }
                int n = MemoryTab.this.plotterList.size();
                this.used = new long[n];
                this.committed = new long[n];
                this.max = new long[n];
                this.threshold = new long[n];
                this.timeStamp = System.currentTimeMillis();
                boolean bl = false;
                for (int i = 0; i < n; ++i) {
                    Plotter plotter = MemoryTab.this.plotterList.get(i);
                    MemoryUsage memoryUsage = null;
                    this.used[i] = -1L;
                    this.threshold[i] = -1L;
                    try {
                        if (plotter instanceof PoolPlotter) {
                            PoolPlotter poolPlotter = (PoolPlotter)plotter;
                            ObjectName objectName = poolPlotter.objectName;
                            AttributeList attributeList = proxyClient.getAttributes(objectName, new String[]{"Usage", "UsageThreshold"});
                            if (attributeList.size() > 0) {
                                CompositeData compositeData = (CompositeData)((Attribute)attributeList.get(0)).getValue();
                                memoryUsage = MemoryUsage.from(compositeData);
                                if (attributeList.size() > 1) {
                                    this.threshold[i] = (Long)((Attribute)attributeList.get(1)).getValue();
                                }
                            }
                        } else if (plotter == MemoryTab.this.heapPlotter) {
                            memoryUsage = proxyClient.getMemoryMXBean().getHeapMemoryUsage();
                        } else if (plotter == MemoryTab.this.nonHeapPlotter) {
                            memoryUsage = proxyClient.getMemoryMXBean().getNonHeapMemoryUsage();
                        }
                    }
                    catch (UndeclaredThrowableException undeclaredThrowableException) {
                        proxyClient.markAsDead();
                        return false;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (memoryUsage == null) continue;
                    this.used[i] = memoryUsage.getUsed();
                    this.committed[i] = memoryUsage.getCommitted();
                    this.max[i] = memoryUsage.getMax();
                }
                this.detailsStr = MemoryTab.this.formatDetails();
                return true;
            }

            @Override
            protected void done() {
                try {
                    if (!((Boolean)this.get()).booleanValue()) {
                        return;
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                catch (ExecutionException executionException) {
                    return;
                }
                if (this.initialRun) {
                    for (Plotter plotter : MemoryTab.this.plotterList) {
                        MemoryTab.this.plotterChoice.addItem(plotter);
                        MemoryTab.this.timeComboBox.addPlotter(plotter);
                    }
                    MemoryTab.this.add((Component)MemoryTab.this.bottomPanel, "South");
                }
                int n = MemoryTab.this.plotterList.size();
                int n2 = 0;
                for (int i = 0; i < n; ++i) {
                    Plotter plotter = MemoryTab.this.plotterList.get(i);
                    if (this.used[i] < 0L) continue;
                    if (plotter instanceof PoolPlotter) {
                        plotter.addValues(this.timeStamp, this.used[i], this.committed[i], this.max[i], this.threshold[i]);
                        if (this.threshold[i] > 0L) {
                            plotter.setIsPlotted(MemoryTab.thresholdKey, true);
                        }
                        MemoryTab.this.poolChart.setValue(n2++, (PoolPlotter)plotter, this.used[i], this.threshold[i], this.max[i]);
                    } else {
                        plotter.addValues(this.timeStamp, this.used[i], this.committed[i], this.max[i]);
                    }
                    if (plotter != MemoryTab.this.heapPlotter || MemoryTab.this.overviewPanel == null) continue;
                    MemoryTab.this.overviewPanel.getPlotter().addValues(this.timeStamp, this.used[i]);
                    MemoryTab.this.overviewPanel.updateMemoryInfo(this.used[i], this.committed[i], this.max[i]);
                }
                MemoryTab.this.details.setText(this.detailsStr);
            }
        };
    }

    private String formatDetails() {
        ProxyClient proxyClient = this.vmPanel.getProxyClient();
        if (proxyClient.isDead()) {
            return "";
        }
        String string = "<table cellspacing=0 cellpadding=0>";
        Plotter plotter = (Plotter)this.plotterChoice.getSelectedItem();
        if (plotter == null) {
            return "";
        }
        long l = System.currentTimeMillis();
        String string2 = Formatter.formatDateTime(l);
        string = string + Formatter.newRow(Resources.getText("Time", new Object[0]), string2);
        long l2 = plotter.getLastValue(usedKey);
        long l3 = plotter.getLastValue(committedKey);
        long l4 = plotter.getLastValue(maxKey);
        long l5 = plotter.getLastValue(thresholdKey);
        string = string + Formatter.newRow(Resources.getText("Used", new Object[0]), Formatter.formatKBytes(l2));
        if (l3 > 0L) {
            string = string + Formatter.newRow(Resources.getText("Committed", new Object[0]), Formatter.formatKBytes(l3));
        }
        if (l4 > 0L) {
            string = string + Formatter.newRow(Resources.getText("Max", new Object[0]), Formatter.formatKBytes(l4));
        }
        if (l5 > 0L) {
            string = string + Formatter.newRow(Resources.getText("Usage Threshold", new Object[0]), Formatter.formatKBytes(l5));
        }
        try {
            Collection<GarbageCollectorMXBean> collection = proxyClient.getGarbageCollectorMXBeans();
            boolean bl = false;
            for (GarbageCollectorMXBean garbageCollectorMXBean : collection) {
                String string3 = garbageCollectorMXBean.getName();
                long l6 = garbageCollectorMXBean.getCollectionCount();
                long l7 = garbageCollectorMXBean.getCollectionTime();
                String string4 = Resources.getText("GC time details", Formatter.justify(Formatter.formatTime(l7), 14), string3, String.format("%,d", l6));
                if (!bl) {
                    string = string + Formatter.newRow(Resources.getText("GC time", new Object[0]), string4);
                    bl = true;
                    continue;
                }
                string = string + Formatter.newRow(null, string4);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.gcButton) {
            this.gc();
        }
    }

    @Override
    OverviewPanel[] getOverviewPanels() {
        if (this.overviewPanel == null) {
            this.overviewPanel = new MemoryOverviewPanel();
        }
        return new OverviewPanel[]{this.overviewPanel};
    }

    private static class MemoryOverviewPanel
    extends OverviewPanel {
        MemoryOverviewPanel() {
            super(Resources.getText("Heap Memory Usage", new Object[0]), MemoryTab.usedKey, usedName, Plotter.Unit.BYTES);
        }

        private void updateMemoryInfo(long l, long l2, long l3) {
            this.getInfoLabel().setText(Resources.getText(MemoryTab.infoLabelFormat, Formatter.formatBytes(l, true), Formatter.formatBytes(l2, true), Formatter.formatBytes(l3, true)));
        }
    }

    private class PoolChart
    extends BorderedComponent
    implements Accessible,
    MouseListener {
        final int height = 150;
        final int leftMargin = 50;
        final int rightMargin = 23;
        final int bottomMargin = 35;
        final int barWidth = 22;
        final int barGap = 3;
        final int groupGap = 8;
        final int barHeight = 100;
        final Color greenBar;
        final Color greenBarBackground;
        final Color redBarBackground;
        Font smallFont;
        ArrayList<PoolPlotter> poolPlotters;
        int nHeapPools;
        int nNonHeapPools;
        Rectangle heapRect;
        Rectangle nonHeapRect;

        public PoolChart() {
            super(null, null);
            this.height = 150;
            this.leftMargin = 50;
            this.rightMargin = 23;
            this.bottomMargin = 35;
            this.barWidth = 22;
            this.barGap = 3;
            this.groupGap = 8;
            this.barHeight = 100;
            this.greenBar = new Color(100, 255, 100);
            this.greenBarBackground = new Color(210, 255, 210);
            this.redBarBackground = new Color(255, 210, 210);
            this.smallFont = null;
            this.poolPlotters = new ArrayList(5);
            this.nHeapPools = 0;
            this.nNonHeapPools = 0;
            this.heapRect = new Rectangle(50, 121, 22, 20);
            this.nonHeapRect = new Rectangle(58, 121, 22, 20);
            this.setFocusable(true);
            this.addMouseListener(this);
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        public void setValue(int n, PoolPlotter poolPlotter, long l, long l2, long l3) {
            poolPlotter.value = l;
            poolPlotter.threshold = l2;
            poolPlotter.max = l3;
            if (n == this.poolPlotters.size()) {
                this.poolPlotters.add(poolPlotter);
                if (poolPlotter.isHeap) {
                    poolPlotter.barX = this.nHeapPools * 25;
                    ++this.nHeapPools;
                    this.heapRect.width = this.nHeapPools * 22 + (this.nHeapPools - 1) * 3;
                    this.nonHeapRect.x = 50 + this.heapRect.width + 8;
                } else {
                    poolPlotter.barX = this.nonHeapRect.x - 50 + this.nNonHeapPools * 25;
                    ++this.nNonHeapPools;
                    this.nonHeapRect.width = this.nNonHeapPools * 22 + (this.nNonHeapPools - 1) * 3;
                }
            } else {
                this.poolPlotters.set(n, poolPlotter);
            }
            this.repaint();
        }

        private void paintPoolBar(Graphics graphics, PoolPlotter poolPlotter) {
            Rectangle rectangle = this.getBarRect(poolPlotter);
            graphics.setColor(Color.gray);
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            long l = poolPlotter.value;
            long l2 = poolPlotter.max;
            if (l2 > 0L) {
                graphics.translate(rectangle.x, rectangle.y);
                graphics.setColor(this.greenBarBackground);
                graphics.fillRect(1, 1, rectangle.width - 1, rectangle.height - 1);
                int n = (int)(l * (long)rectangle.height / l2);
                long l3 = poolPlotter.threshold;
                if (l3 > 0L) {
                    int n2 = (int)(l3 * (long)rectangle.height / l2);
                    graphics.setColor(this.redBarBackground);
                    graphics.fillRect(1, 1, rectangle.width - 1, rectangle.height - n2);
                    if (l > l3) {
                        graphics.setColor(thresholdColor);
                        graphics.fillRect(1, rectangle.height - n, rectangle.width - 1, n - n2);
                        n = n2;
                    }
                }
                graphics.setColor(this.greenBar);
                graphics.fillRect(1, rectangle.height - n, rectangle.width - 1, n);
                graphics.translate(-rectangle.x, -rectangle.y);
            }
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.poolPlotters.size() == 0) {
                return;
            }
            if (this.smallFont == null) {
                this.smallFont = graphics.getFont().deriveFont(9.0f);
            }
            graphics.setColor(this.getBackground());
            Rectangle rectangle = graphics.getClipRect();
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setFont(this.smallFont);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = fontMetrics.getDescent();
            graphics.setColor(this.getForeground());
            for (int n2 : new int[]{0, 25, 50, 75, 100}) {
                String string = n2 + "% --";
                graphics.drawString(string, 50 - fontMetrics.stringWidth(string) - 4, 115 - n2 * 100 / 100 + n + 1);
            }
            Object object = this.poolPlotters.iterator();
            while (object.hasNext()) {
                PoolPlotter poolPlotter = (PoolPlotter)object.next();
                this.paintPoolBar(graphics, poolPlotter);
            }
            graphics.setColor(Color.gray);
            graphics.drawRect(this.heapRect.x, this.heapRect.y, this.heapRect.width, this.heapRect.height);
            graphics.drawRect(this.nonHeapRect.x, this.nonHeapRect.y, this.nonHeapRect.width, this.nonHeapRect.height);
            object = this.greenBar;
            Color color = this.greenBar;
            for (PoolPlotter poolPlotter : this.poolPlotters) {
                if (poolPlotter.threshold <= 0L || poolPlotter.value <= poolPlotter.threshold) continue;
                if (poolPlotter.isHeap) {
                    object = thresholdColor;
                    continue;
                }
                color = thresholdColor;
            }
            graphics.setColor((Color)object);
            graphics.fillRect(this.heapRect.x + 1, this.heapRect.y + 1, this.heapRect.width - 1, this.heapRect.height - 1);
            graphics.setColor(color);
            graphics.fillRect(this.nonHeapRect.x + 1, this.nonHeapRect.y + 1, this.nonHeapRect.width - 1, this.nonHeapRect.height - 1);
            Object object2 = Resources.getText("Heap", new Object[0]);
            int n3 = fontMetrics.stringWidth((String)object2);
            int n4 = this.heapRect.x + (this.heapRect.width - n3) / 2;
            int n5 = this.heapRect.y + this.heapRect.height - 6;
            graphics.setColor(Color.white);
            graphics.drawString((String)object2, n4 - 1, n5 - 1);
            graphics.drawString((String)object2, n4 + 1, n5 - 1);
            graphics.drawString((String)object2, n4 - 1, n5 + 1);
            graphics.drawString((String)object2, n4 + 1, n5 + 1);
            graphics.setColor(Color.black);
            graphics.drawString((String)object2, n4, n5);
            object2 = Resources.getText("Non-Heap", new Object[0]);
            n3 = fontMetrics.stringWidth((String)object2);
            n4 = this.nonHeapRect.x + (this.nonHeapRect.width - n3) / 2;
            n5 = this.nonHeapRect.y + this.nonHeapRect.height - 6;
            graphics.setColor(Color.white);
            graphics.drawString((String)object2, n4 - 1, n5 - 1);
            graphics.drawString((String)object2, n4 + 1, n5 - 1);
            graphics.drawString((String)object2, n4 - 1, n5 + 1);
            graphics.drawString((String)object2, n4 + 1, n5 + 1);
            graphics.setColor(Color.black);
            graphics.drawString((String)object2, n4, n5);
            graphics.setColor(Color.blue);
            rectangle = null;
            Plotter plotter = (Plotter)MemoryTab.this.plotterChoice.getSelectedItem();
            if (plotter == MemoryTab.this.heapPlotter) {
                rectangle = this.heapRect;
            } else if (plotter == MemoryTab.this.nonHeapPlotter) {
                rectangle = this.nonHeapRect;
            } else if (plotter instanceof PoolPlotter) {
                rectangle = this.getBarRect((PoolPlotter)plotter);
            }
            if (rectangle != null) {
                graphics.drawRect(rectangle.x - 1, rectangle.y - 1, rectangle.width + 2, rectangle.height + 2);
            }
        }

        private Rectangle getBarRect(PoolPlotter poolPlotter) {
            return new Rectangle(50 + poolPlotter.barX, 15, 22, 100);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.nonHeapRect.x + this.nonHeapRect.width + 23, 150);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.requestFocusInWindow();
            Plotter plotter = this.getPlotter(mouseEvent);
            if (plotter != null && plotter != MemoryTab.this.plotterChoice.getSelectedItem()) {
                MemoryTab.this.plotterChoice.setSelectedItem(plotter);
                this.repaint();
            }
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            Plotter plotter = this.getPlotter(mouseEvent);
            return plotter != null ? plotter.toString() : null;
        }

        private Plotter getPlotter(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            Plotter plotter = null;
            if (this.heapRect.contains(point)) {
                plotter = MemoryTab.this.heapPlotter;
            } else if (this.nonHeapRect.contains(point)) {
                plotter = MemoryTab.this.nonHeapPlotter;
            } else {
                for (PoolPlotter poolPlotter : this.poolPlotters) {
                    if (!this.getBarRect(poolPlotter).contains(point)) continue;
                    plotter = poolPlotter;
                    break;
                }
            }
            return plotter;
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessiblePoolChart();
            }
            return this.accessibleContext;
        }

        protected class AccessiblePoolChart
        extends JPanel.AccessibleJPanel {
            protected AccessiblePoolChart() {
                super(PoolChart.this);
            }

            public String getAccessibleName() {
                String string = Resources.getText("MemoryTab.poolChart.accessibleName", new Object[0]);
                String string2 = "";
                for (PoolPlotter poolPlotter : PoolChart.this.poolPlotters) {
                    String string3 = poolPlotter.value * 100L / poolPlotter.max + "%";
                    string2 = string2 + Resources.getText("Plotter.accessibleName.keyAndValue", poolPlotter.toString(), string3);
                    if (poolPlotter.threshold <= 0L) continue;
                    String string4 = poolPlotter.threshold * 100L / poolPlotter.max + "%";
                    if (poolPlotter.value > poolPlotter.threshold) {
                        string2 = string2 + Resources.getText("MemoryTab.poolChart.aboveThreshold", string4);
                        continue;
                    }
                    string2 = string2 + Resources.getText("MemoryTab.poolChart.belowThreshold", string4);
                }
                return string + "\n" + string2 + ".";
            }
        }
    }

    private class PoolPlotter
    extends Plotter {
        ObjectName objectName;
        String name;
        boolean isHeap;
        long value;
        long threshold;
        long max;
        int barX;

        public PoolPlotter(ObjectName objectName, String string, boolean bl) {
            super(Plotter.Unit.BYTES);
            this.objectName = objectName;
            this.name = string;
            this.isHeap = bl;
            Utilities.setAccessibleName(this, Resources.getText("MemoryTab.poolPlotter.accessibleName", string));
        }

        public String toString() {
            return this.name;
        }
    }
}

