/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.PrintStream;
import sun.jvm.hotspot.runtime.ClassConstants;

public class AccessFlags
implements ClassConstants {
    private long flags;

    public AccessFlags(long flags) {
        this.flags = flags;
    }

    public boolean isPublic() {
        return (this.flags & 1L) != 0L;
    }

    public boolean isPrivate() {
        return (this.flags & 2L) != 0L;
    }

    public boolean isProtected() {
        return (this.flags & 4L) != 0L;
    }

    public boolean isStatic() {
        return (this.flags & 8L) != 0L;
    }

    public boolean isFinal() {
        return (this.flags & 0x10L) != 0L;
    }

    public boolean isSynchronized() {
        return (this.flags & 0x20L) != 0L;
    }

    public boolean isSuper() {
        return (this.flags & 0x20L) != 0L;
    }

    public boolean isVolatile() {
        return (this.flags & 0x40L) != 0L;
    }

    public boolean isBridge() {
        return (this.flags & 0x40L) != 0L;
    }

    public boolean isTransient() {
        return (this.flags & 0x80L) != 0L;
    }

    public boolean isVarArgs() {
        return (this.flags & 0x80L) != 0L;
    }

    public boolean isNative() {
        return (this.flags & 0x100L) != 0L;
    }

    public boolean isEnum() {
        return (this.flags & 0x4000L) != 0L;
    }

    public boolean isAnnotation() {
        return (this.flags & 0x2000L) != 0L;
    }

    public boolean isInterface() {
        return (this.flags & 0x200L) != 0L;
    }

    public boolean isAbstract() {
        return (this.flags & 0x400L) != 0L;
    }

    public boolean isStrict() {
        return (this.flags & 0x800L) != 0L;
    }

    public boolean isSynthetic() {
        return (this.flags & 0x1000L) != 0L;
    }

    public long getValue() {
        return this.flags;
    }

    public boolean isMonitorMatching() {
        return (this.flags & 0x10000000L) != 0L;
    }

    public boolean hasMonitorBytecodes() {
        return (this.flags & 0x20000000L) != 0L;
    }

    public boolean hasLoops() {
        return (this.flags & 0x40000000L) != 0L;
    }

    public boolean loopsFlagInit() {
        return (this.flags & Integer.MIN_VALUE) != 0L;
    }

    public boolean queuedForCompilation() {
        return (this.flags & 0x1000000L) != 0L;
    }

    public boolean isNotOsrCompilable() {
        return (this.flags & 0x8000000L) != 0L;
    }

    public boolean hasLineNumberTable() {
        return (this.flags & 0x100000L) != 0L;
    }

    public boolean hasCheckedExceptions() {
        return (this.flags & 0x400000L) != 0L;
    }

    public boolean hasJsrs() {
        return (this.flags & 0x800000L) != 0L;
    }

    public boolean isObsolete() {
        return (this.flags & 0x10000L) != 0L;
    }

    public boolean canBeFastPathAllocated() {
        return (this.flags & 0x8000000L) != 0L;
    }

    public boolean hasMirandaMethods() {
        return (this.flags & 0x10000000L) != 0L;
    }

    public boolean hasVanillaConstructor() {
        return (this.flags & 0x20000000L) != 0L;
    }

    public boolean hasFinalizer() {
        return (this.flags & 0x40000000L) != 0L;
    }

    public boolean isCloneable() {
        return (this.flags & Integer.MIN_VALUE) != 0L;
    }

    public boolean hasLocalVariableTable() {
        return (this.flags & 0x200000L) != 0L;
    }

    public boolean fieldAccessWatched() {
        return (this.flags & 0x2000L) != 0L;
    }

    public boolean fieldModificationWatched() {
        return (this.flags & 0x8000L) != 0L;
    }

    public void printOn(PrintStream tty) {
        if (this.isPublic()) {
            tty.print("public ");
        }
        if (this.isPrivate()) {
            tty.print("private ");
        }
        if (this.isProtected()) {
            tty.print("protected ");
        }
        if (this.isStatic()) {
            tty.print("static ");
        }
        if (this.isFinal()) {
            tty.print("final ");
        }
        if (this.isSynchronized()) {
            tty.print("synchronized ");
        }
        if (this.isVolatile()) {
            tty.print("volatile ");
        }
        if (this.isBridge()) {
            tty.print("bridge ");
        }
        if (this.isTransient()) {
            tty.print("transient ");
        }
        if (this.isVarArgs()) {
            tty.print("varargs ");
        }
        if (this.isNative()) {
            tty.print("native ");
        }
        if (this.isEnum()) {
            tty.print("enum ");
        }
        if (this.isInterface()) {
            tty.print("interface ");
        }
        if (this.isAbstract()) {
            tty.print("abstract ");
        }
        if (this.isStrict()) {
            tty.print("strict ");
        }
        if (this.isSynthetic()) {
            tty.print("synthetic ");
        }
    }

    public int getStandardFlags() {
        return (int)(this.flags & 0x7FFFL);
    }
}

