dnl Check for Spidermonkey in four locations.
dnl This is necessary because in Debian, libjs.so is already taken by the
dnl NGS Javascript interpreter (ngs-js); consequently, the Spidermonkey
dnl library is named libsmjs.so and has its include files in
dnl /usr/include/smjs rather than /usr/include/js.
dnl And not everybody puts it in a subdirectory...
dnl
dnl Then there's /usr/include/mozilla/js, /usr/include/firefox/js and -lmozjs.

m4_define([spidermonkey_locate_header],
   [if test -f /usr/include/"$1$2"; then
	echo /usr/include/"$1"
    else
	echo /usr/local/include/"$1"
    fi
   ])

m4_define([spidermonkey_locate_lib],
   [case "$JS_CFLAGS" in
	/usr/local/include/*)
	  echo -L/usr/local/lib -l"$1"
	  ;;
	*)
	  echo -l"$1"
	  ;;
    esac
   ])

m4_define([spidermonkey_locate],
    [AC_CHECK_HEADER([$1jsapi.h],
	[JS_CFLAGS="-I`spidermonkey_locate_header([$1], [jsapi.h])`"
	 JS_LIBS="`spidermonkey_locate_lib([$2])`"
	],
	[unset JS_CFLAGS JS_LIBS],
	[#define XP_UNIX])
    ])

AC_DEFUN([AC_PATH_SPIDERMONKEY],
   [AC_ARG_WITH([spidermonkey],
		[AS_HELP_STRING([--with-spidermonkey],[prefix where libjs/libsmjs is installed (optional)])],
		[JS_CFLAGS="-I$withval"], [JS_CFLAGS=''])

    AC_ARG_ENABLE([libjs],
	[AS_HELP_STRING([--disable-libjs],[don't look for libjs/libsmjs])])
    AC_ARG_ENABLE([mozjs],
	[AS_HELP_STRING([--disable-mozjs],[don't look for Mozilla libmozjs])])
    AC_ARG_ENABLE([ffjs],
	[AS_HELP_STRING([--disable-ffjs], [don't look for Firefox libmozjs])])

    test "$enable_libjs$enable_mozjs$enable_ffjs" = "nonono" &&
      AC_MSG_ERROR([cannot search for no JS library - try removing a --disable-*js option])

    if test x"$JS_CFLAGS" = x; then
      AC_MSG_NOTICE([looking for the Spidermonkey Javascript library in various places.])

      # Try libsmjs/libjs

      AC_MSG_NOTICE([trying mozjs via pkgconfig xulrunner-js])
      PKG_CHECK_MODULES([JS],[xulrunner-js],[],[AC_MSG_RESULT([no])])

      # Try libsmjs/libjs

     if test "$enable_libjs" != "no"; then
      if test x"$JS_CFLAGS" = x; then
	# Note: this could be confused with NGS JS
        AC_MSG_NOTICE([trying libjs via pkgconfig])
	PKG_CHECK_MODULES([JS],[libjs],[],[AC_MSG_RESULT([no])])
      fi

      if test x"$JS_CFLAGS" = x; then
        AC_MSG_NOTICE([trying smjs])
	spidermonkey_locate([smjs/], [smjs])
      fi
      if test x"$JS_CFLAGS" = x; then
        AC_MSG_NOTICE([trying js, includes in /usr/include/js])
	spidermonkey_locate([js/], [js])
      fi
      if test x"$JS_CFLAGS" = x; then
        AC_MSG_NOTICE([trying js, includes in /usr/include/js-1.5])
	spidermonkey_locate([js-1.5/], [js])
      fi
      if test x"$JS_CFLAGS" = x; then
        AC_MSG_NOTICE([trying js, includes in /usr/include])
	spidermonkey_locate([], [js])
      fi
     fi

      # Try Mozilla

      if test x"$JS_CFLAGS" = x && test "$enable_mozjs" != "no"; then
        AC_MSG_NOTICE([trying mozjs via pkgconfig mozilla-js])
	PKG_CHECK_MODULES([JS],[mozilla-js],[],[AC_MSG_RESULT([no])])
	if test x"$JS_CFLAGS" != x; then
	  AC_MSG_WARN([gxine may fail if libmozjs.so is not in the usual locations. You may need to set LD_LIBRARY_PATH.])
	fi
      fi
      if test x"$JS_CFLAGS" = x && test "$enable_ffjs" != "no"; then
        AC_MSG_NOTICE([trying mozjs via pkgconfig firefox-js])
	PKG_CHECK_MODULES([JS],[firefox-js],[],[AC_MSG_RESULT([no])])
	if test x"$JS_CFLAGS" != x; then
	  AC_MSG_WARN([gxine may fail if libmozjs.so is not in the usual locations. You may need to set LD_LIBRARY_PATH.])
	fi
      fi

      if test x"$JS_CFLAGS" = x && test "$enable_mozjs" != "no"; then
        AC_MSG_NOTICE([trying mozjs, includes in /usr/include/mozilla/js])
	spidermonkey_locate([mozilla/js/], [mozjs])
      fi
      if test x"$JS_CFLAGS" = x && test "$enable_ffjs" != "no"; then
        AC_MSG_NOTICE([trying mozjs, includes in /usr/include/firefox/js])
	spidermonkey_locate([firefox/js/], [mozjs])
      fi

      # Failed...

      if test x"$JS_CFLAGS" = x; then
	AC_MSG_ERROR([libjs not found])
      fi
    else
      saved_CFLAGS="$CFLAGS"
      CFLAGS="$CFLAGS $JS_CFLAGS"
      AC_MSG_NOTICE([using path $JS_CFLAGS for spidermonkey])
      AC_CHECK_HEADER([jsapi.h],
	[JS_LIBS="`case "$JS_CFLAGS" in
			*/smjs|*/smjs/)
			  echo sm
			  ;;
			*/mozilla/js|*/mozilla/js*|*/firefox/js|*/firefox/js*)
			  echo moz
			  ;;
		   esac`"
	 JS_LIBS="`spidermonkey_locate_lib([$JS_LIBS])`js"
	 AC_DEFINE(HAVE_LIBSMJS, 1, [Define if you have jsapi.h])
	],
	[AC_MSG_ERROR([libjs not found])],
	[#define XP_UNIX])
      CFLAGS="$saved_CFLAGS"
    fi
    AC_SUBST(JS_CFLAGS)
    AC_SUBST(JS_LIBS)
   ])
