/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.Debug;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class X509KeyManagerImpl
extends X509ExtendedKeyManager
implements X509KeyManager {
    private static final Debug debug = Debug.getInstance("ssl");
    private static final boolean useDebug = debug != null && Debug.isOn("keymanager");
    private static Date verificationDate;
    private final List<KeyStore.Builder> builders;
    private final AtomicLong uidCounter;
    private final Map<String, Reference<KeyStore.PrivateKeyEntry>> entryCacheMap;

    X509KeyManagerImpl(KeyStore.Builder builder) {
        this(Collections.singletonList(builder));
    }

    X509KeyManagerImpl(List<KeyStore.Builder> list) {
        this.builders = list;
        this.uidCounter = new AtomicLong();
        this.entryCacheMap = Collections.synchronizedMap(new SizedMap());
    }

    @Override
    public X509Certificate[] getCertificateChain(String string) {
        return (X509Certificate[])this.getEntry(string).getCertificateChain();
    }

    @Override
    public PrivateKey getPrivateKey(String string) {
        return this.getEntry(string).getPrivateKey();
    }

    @Override
    public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
        return this.chooseAlias(X509KeyManagerImpl.getKeyTypes(stringArray), principalArray, CheckType.CLIENT);
    }

    @Override
    public String chooseEngineClientAlias(String[] stringArray, Principal[] principalArray, SSLEngine sSLEngine) {
        return this.chooseAlias(X509KeyManagerImpl.getKeyTypes(stringArray), principalArray, CheckType.CLIENT);
    }

    @Override
    public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
        return this.chooseAlias(X509KeyManagerImpl.getKeyTypes(string), principalArray, CheckType.SERVER);
    }

    @Override
    public String chooseEngineServerAlias(String string, Principal[] principalArray, SSLEngine sSLEngine) {
        return this.chooseAlias(X509KeyManagerImpl.getKeyTypes(string), principalArray, CheckType.SERVER);
    }

    @Override
    public String[] getClientAliases(String string, Principal[] principalArray) {
        return this.getAliases(string, principalArray, CheckType.CLIENT);
    }

    @Override
    public String[] getServerAliases(String string, Principal[] principalArray) {
        return this.getAliases(string, principalArray, CheckType.SERVER);
    }

    private String makeAlias(EntryStatus entryStatus) {
        return this.uidCounter.incrementAndGet() + "." + entryStatus.builderIndex + "." + entryStatus.alias;
    }

    private KeyStore.PrivateKeyEntry getEntry(String string) {
        KeyStore.PrivateKeyEntry privateKeyEntry;
        Reference<KeyStore.PrivateKeyEntry> reference = this.entryCacheMap.get(string);
        KeyStore.PrivateKeyEntry privateKeyEntry2 = privateKeyEntry = reference != null ? reference.get() : null;
        if (privateKeyEntry != null) {
            return privateKeyEntry;
        }
        int n = string.indexOf(46);
        int n2 = string.indexOf(46, n + 1);
        if (n == -1 || n2 == n) {
            throw new ProviderException("Invalid alias " + string);
        }
        try {
            int n3 = Integer.parseInt(string.substring(n + 1, n2));
            String string2 = string.substring(n2 + 1);
            KeyStore.Builder builder = this.builders.get(n3);
            KeyStore keyStore = builder.getKeyStore();
            KeyStore.Entry entry = keyStore.getEntry(string2, builder.getProtectionParameter(string));
            if (!(entry instanceof KeyStore.PrivateKeyEntry)) {
                throw new ProviderException("Unexpected type of entry: " + entry);
            }
            privateKeyEntry = (KeyStore.PrivateKeyEntry)entry;
            this.entryCacheMap.put(string, new SoftReference<KeyStore.PrivateKeyEntry>(privateKeyEntry));
            return privateKeyEntry;
        }
        catch (ProviderException providerException) {
            throw providerException;
        }
        catch (Exception exception) {
            throw new ProviderException(exception);
        }
    }

    private static Collection<String> getKeyTypes(String string) {
        if (string.startsWith("DH_")) {
            return Collections.singleton("DH");
        }
        return Collections.singleton(string);
    }

    private static Collection<String> getKeyTypes(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (String string : stringArray) {
            arrayList.add(string.startsWith("DH_") ? "DH" : string);
        }
        return arrayList;
    }

    private String chooseAlias(Collection<String> collection, Principal[] principalArray, CheckType checkType) {
        Set<Principal> set = this.getIssuerSet(principalArray);
        ArrayList<EntryStatus> arrayList = null;
        int n = this.builders.size();
        for (int i = 0; i < n; ++i) {
            try {
                List<EntryStatus> list = this.getAliases(i, collection, set, false, checkType);
                if (list == null) continue;
                EntryStatus entryStatus = list.get(0);
                if (entryStatus.checkResult == CheckResult.OK) {
                    if (useDebug) {
                        debug.println("KeyMgr: choosing key: " + entryStatus);
                    }
                    return this.makeAlias(entryStatus);
                }
                if (arrayList == null) {
                    arrayList = new ArrayList<EntryStatus>();
                }
                arrayList.addAll(list);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (arrayList == null) {
            if (useDebug) {
                debug.println("KeyMgr: no matching key found");
            }
            return null;
        }
        Collections.sort(arrayList);
        if (useDebug) {
            debug.println("KeyMgr: no good matching key found, returning best match out of:");
            debug.println(((Object)arrayList).toString());
        }
        return this.makeAlias((EntryStatus)arrayList.get(0));
    }

    public String[] getAliases(String string, Principal[] principalArray, CheckType checkType) {
        Set<Principal> set = this.getIssuerSet(principalArray);
        Collection<String> collection = X509KeyManagerImpl.getKeyTypes(string);
        ArrayList<EntryStatus> arrayList = new ArrayList<EntryStatus>();
        int n = this.builders.size();
        for (int i = 0; i < n; ++i) {
            try {
                List<EntryStatus> list = this.getAliases(i, collection, set, true, checkType);
                if (list == null) continue;
                arrayList.addAll(list);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Collections.sort(arrayList);
        if (useDebug) {
            debug.println("KeyMgr: getting aliases: " + arrayList);
        }
        return this.toAliases(arrayList);
    }

    private String[] toAliases(List<EntryStatus> list) {
        String[] stringArray = new String[list.size()];
        int n = 0;
        for (EntryStatus entryStatus : list) {
            stringArray[n++] = this.makeAlias(entryStatus);
        }
        return stringArray;
    }

    private Set<Principal> getIssuerSet(Principal[] principalArray) {
        if (principalArray != null && principalArray.length != 0) {
            return new HashSet<Principal>(Arrays.asList(principalArray));
        }
        return null;
    }

    private List<EntryStatus> getAliases(int n, Collection<String> collection, Set<Principal> set, boolean bl, CheckType checkType) throws Exception {
        KeyStore.Builder builder = this.builders.get(n);
        KeyStore keyStore = builder.getKeyStore();
        ArrayList<EntryStatus> arrayList = null;
        Date date = verificationDate;
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            Certificate[] certificateArray;
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string) || (certificateArray = keyStore.getCertificateChain(string)) == null || certificateArray.length == 0) continue;
            String string2 = certificateArray[0].getPublicKey().getAlgorithm();
            if (!collection.contains(string2)) {
                if (!useDebug) continue;
                debug.println("Ignoring alias " + string + ": key algorithm does not match");
                continue;
            }
            if (set != null) {
                boolean bl2 = false;
                for (Certificate certificate : certificateArray) {
                    if (!(certificate instanceof X509Certificate)) break;
                    X509Certificate x509Certificate = (X509Certificate)certificate;
                    if (!set.contains(x509Certificate.getIssuerX500Principal())) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    if (!useDebug) continue;
                    debug.println("Ignoring alias " + string + ": issuers do not match");
                    continue;
                }
            }
            if (date == null) {
                date = new Date();
            }
            CheckResult checkResult = checkType.check((X509Certificate)certificateArray[0], date);
            EntryStatus entryStatus = new EntryStatus(n, string, certificateArray, checkResult);
            if (checkResult == CheckResult.OK && !bl) {
                return Collections.singletonList(entryStatus);
            }
            if (arrayList == null) {
                arrayList = new ArrayList<EntryStatus>();
            }
            arrayList.add(entryStatus);
        }
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CheckResult {
        OK,
        EXPIRED,
        EXTENSION_MISMATCH;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CheckType {
        NONE(Collections.<String>emptySet()),
        CLIENT(new HashSet<String>(Arrays.asList("2.5.29.37.0", "1.3.6.1.5.5.7.3.2"))),
        SERVER(new HashSet<String>(Arrays.asList("2.5.29.37.0", "1.3.6.1.5.5.7.3.1", "2.16.840.1.113730.4.1", "1.3.6.1.4.1.311.10.3.3")));

        final Set<String> validEku;

        private CheckType(Set<String> set) {
            this.validEku = set;
        }

        private static boolean getBit(boolean[] blArray, int n) {
            return n < blArray.length && blArray[n];
        }

        CheckResult check(X509Certificate x509Certificate, Date date) {
            if (this == NONE) {
                return CheckResult.OK;
            }
            try {
                List<String> list = x509Certificate.getExtendedKeyUsage();
                if (list != null && Collections.disjoint(this.validEku, list)) {
                    return CheckResult.EXTENSION_MISMATCH;
                }
                boolean[] blArray = x509Certificate.getKeyUsage();
                if (blArray != null) {
                    String string = x509Certificate.getPublicKey().getAlgorithm();
                    boolean bl = CheckType.getBit(blArray, 0);
                    if (string.equals("RSA") ? !bl && (this == CLIENT || !CheckType.getBit(blArray, 2)) : (string.equals("DSA") ? !bl : string.equals("DH") && !CheckType.getBit(blArray, 4))) {
                        return CheckResult.EXTENSION_MISMATCH;
                    }
                }
            }
            catch (CertificateException certificateException) {
                return CheckResult.EXTENSION_MISMATCH;
            }
            try {
                x509Certificate.checkValidity(date);
                return CheckResult.OK;
            }
            catch (CertificateException certificateException) {
                return CheckResult.EXPIRED;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EntryStatus
    implements Comparable<EntryStatus> {
        final int builderIndex;
        final String alias;
        final CheckResult checkResult;

        EntryStatus(int n, String string, Certificate[] certificateArray, CheckResult checkResult) {
            this.builderIndex = n;
            this.alias = string;
            this.checkResult = checkResult;
        }

        @Override
        public int compareTo(EntryStatus entryStatus) {
            return this.checkResult.compareTo(entryStatus.checkResult);
        }

        public String toString() {
            String string = this.alias + " (verified: " + (Object)((Object)this.checkResult) + ")";
            if (this.builderIndex == 0) {
                return string;
            }
            return "Builder #" + this.builderIndex + ", alias: " + string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SizedMap<K, V>
    extends LinkedHashMap<K, V> {
        private SizedMap() {
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
            return this.size() > 10;
        }
    }
}

