/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.EphemeralKeyManager;
import com.sun.net.ssl.internal.ssl.JsseX509KeyManager;
import com.sun.net.ssl.internal.ssl.JsseX509TrustManager;
import com.sun.net.ssl.internal.ssl.SSLEngineImpl;
import com.sun.net.ssl.internal.ssl.SSLServerSocketFactoryImpl;
import com.sun.net.ssl.internal.ssl.SSLSessionContextImpl;
import com.sun.net.ssl.internal.ssl.SSLSocketFactoryImpl;
import com.sun.net.ssl.internal.ssl.TrustManagerFactoryImpl;
import java.io.FileInputStream;
import java.security.AccessController;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;

public final class SSLContextImpl
extends SSLContextSpi {
    private static SSLContextImpl defaultContext;
    private X509ExtendedKeyManager keyManager;
    private X509TrustManager trustManager;
    private SecureRandom secureRandom;
    private EphemeralKeyManager ephemeralKeyManager = new EphemeralKeyManager();
    private SSLSessionContextImpl clientCache = new SSLSessionContextImpl();
    private SSLSessionContextImpl serverCache = new SSLSessionContextImpl();
    private static final String NONE = "NONE";
    private static final String P11KEYSTORE = "PKCS11";
    private static final Debug debug;
    private boolean isInitialized = false;

    protected void engineInit(KeyManager[] keyManagerArray, TrustManager[] trustManagerArray, SecureRandom secureRandom) throws KeyManagementException {
        this.keyManager = new JsseX509KeyManager(keyManagerArray);
        if (trustManagerArray == null) {
            try {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
                trustManagerFactory.init((KeyStore)null);
                trustManagerArray = trustManagerFactory.getTrustManagers();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.trustManager = new JsseX509TrustManager(trustManagerArray);
        if (secureRandom == null) {
            secureRandom = new SecureRandom();
        }
        this.secureRandom = secureRandom;
        if (debug != null && Debug.isOn("sslctx")) {
            System.out.println("trigger seeding of SecureRandom");
        }
        this.secureRandom.nextInt();
        if (debug != null && Debug.isOn("sslctx")) {
            System.out.println("done seeding SecureRandom");
        }
        this.isInitialized = true;
    }

    protected SSLSocketFactory engineGetSocketFactory() {
        if (!this.isInitialized) {
            throw new IllegalStateException("SSLContextImpl is not initialized");
        }
        return new SSLSocketFactoryImpl(this);
    }

    protected SSLServerSocketFactory engineGetServerSocketFactory() {
        if (!this.isInitialized) {
            throw new IllegalStateException("SSLContext is not initialized");
        }
        return new SSLServerSocketFactoryImpl(this);
    }

    protected SSLEngine engineCreateSSLEngine() {
        if (!this.isInitialized) {
            throw new IllegalStateException("SSLContextImpl is not initialized");
        }
        return new SSLEngineImpl(this);
    }

    protected SSLEngine engineCreateSSLEngine(String string, int n) {
        if (!this.isInitialized) {
            throw new IllegalStateException("SSLContextImpl is not initialized");
        }
        return new SSLEngineImpl(this, string, n);
    }

    protected SSLSessionContext engineGetClientSessionContext() {
        return this.clientCache;
    }

    protected SSLSessionContext engineGetServerSessionContext() {
        return this.serverCache;
    }

    SecureRandom getSecureRandom() {
        return this.secureRandom;
    }

    X509ExtendedKeyManager getX509KeyManager() {
        return this.keyManager;
    }

    X509TrustManager getX509TrustManager() {
        return this.trustManager;
    }

    EphemeralKeyManager getEphemeralKeyManager() {
        return this.ephemeralKeyManager;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static synchronized SSLContextImpl getDefaultContext() {
        if (defaultContext != null) {
            return defaultContext;
        }
        char[] cArray = null;
        try {
            String string = null;
            final HashMap hashMap = new HashMap();
            FileInputStream fileInputStream = null;
            KeyStore keyStore = null;
            SSLContextImpl sSLContextImpl = null;
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    hashMap.put("keyStore", System.getProperty("javax.net.ssl.keyStore", ""));
                    hashMap.put("keyStoreType", System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType()));
                    hashMap.put("keyStoreProvider", System.getProperty("javax.net.ssl.keyStoreProvider", ""));
                    hashMap.put("keyStorePasswd", System.getProperty("javax.net.ssl.keyStorePassword", ""));
                    return null;
                }
            });
            final String string2 = (String)hashMap.get("keyStore");
            String string3 = (String)hashMap.get("keyStoreType");
            String string4 = (String)hashMap.get("keyStoreProvider");
            if (debug != null && Debug.isOn("defaultctx")) {
                System.out.println("keyStore is : " + string2);
                System.out.println("keyStore type is : " + string3);
                System.out.println("keyStore provider is : " + string4);
            }
            if (P11KEYSTORE.equals(string3) && !NONE.equals(string2)) {
                throw new IllegalArgumentException("if keyStoreType is PKCS11, then keyStore must be NONE");
            }
            if (string2.length() != 0 && !NONE.equals(string2)) {
                fileInputStream = (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return new FileInputStream(string2);
                    }
                });
            }
            if ((string = (String)hashMap.get("keyStorePasswd")).length() != 0) {
                cArray = string.toCharArray();
            }
            if (string3.length() != 0) {
                if (debug != null && Debug.isOn("defaultctx")) {
                    System.out.println("init keystore");
                }
                keyStore = string4.length() == 0 ? KeyStore.getInstance(string3) : KeyStore.getInstance(string3, string4);
                keyStore.load(fileInputStream, cArray);
            }
            if (fileInputStream != null) {
                fileInputStream.close();
                fileInputStream = null;
            }
            if (debug != null && Debug.isOn("defaultctx")) {
                System.out.println("init keymanager of type " + KeyManagerFactory.getDefaultAlgorithm());
            }
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            if (P11KEYSTORE.equals(string3)) {
                keyManagerFactory.init(keyStore, null);
            } else {
                keyManagerFactory.init(keyStore, cArray);
            }
            KeyManager[] keyManagerArray = keyManagerFactory.getKeyManagers();
            keyStore = TrustManagerFactoryImpl.getCacertsKeyStore("defaultctx");
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            TrustManager[] trustManagerArray = null;
            trustManagerFactory.init(keyStore);
            trustManagerArray = trustManagerFactory.getTrustManagers();
            if (debug != null && Debug.isOn("defaultctx")) {
                System.out.println("init context");
            }
            sSLContextImpl = new SSLContextImpl();
            sSLContextImpl.engineInit(keyManagerArray, trustManagerArray, null);
            defaultContext = sSLContextImpl;
            if (cArray == null) return defaultContext;
        }
        catch (RuntimeException runtimeException) {
            try {
                if (debug == null) throw runtimeException;
                if (!Debug.isOn("defaultctx")) throw runtimeException;
                System.out.println("default context init failed: " + runtimeException);
                throw runtimeException;
                catch (Exception exception) {
                    if (debug == null) throw new RuntimeException("Default SSL context init failed: " + exception.getMessage());
                    if (!Debug.isOn("defaultctx")) throw new RuntimeException("Default SSL context init failed: " + exception.getMessage());
                    System.out.println("default context init failed: " + exception);
                    throw new RuntimeException("Default SSL context init failed: " + exception.getMessage());
                }
                catch (Error error) {
                    if (debug == null) throw error;
                    if (!Debug.isOn("defaultctx")) throw error;
                    System.out.println("default context init failed: " + error);
                    throw error;
                }
            }
            catch (Throwable throwable) {
                if (cArray == null) throw throwable;
                Arrays.fill(cArray, ' ');
                throw throwable;
            }
        }
        Arrays.fill(cArray, ' ');
        return defaultContext;
    }

    static {
        debug = Debug.getInstance("ssl");
    }
}

