/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.panel;

import com.sun.deploy.panel.CertificatesInfo;
import com.sun.deploy.panel.ReadOnlyTableModel;
import com.sun.deploy.security.CertUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;

class CertificateTabPanel
extends JPanel {
    private JTable certsTable;

    CertificateTabPanel(CertificatesInfo certificatesInfo, int n) {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setAutoscrolls(true);
        Collection collection = certificatesInfo.getTrustedCertificates(n);
        if (collection == null || collection.size() == 0) {
            ReadOnlyTableModel readOnlyTableModel = new ReadOnlyTableModel();
            this.certsTable = new JTable(readOnlyTableModel);
        } else {
            ReadOnlyTableModel readOnlyTableModel = new ReadOnlyTableModel(collection.size());
            int n2 = 0;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                X509Certificate x509Certificate = (X509Certificate)iterator.next();
                readOnlyTableModel.setValueAt(CertUtils.extractSubjectAliasName(x509Certificate), n2, 0);
                readOnlyTableModel.setValueAt(CertUtils.extractIssuerAliasName(x509Certificate), n2, 1);
                ++n2;
            }
            this.certsTable = new JTable(readOnlyTableModel);
        }
        this.certsTable.setDragEnabled(false);
        this.certsTable.setSelectionMode(0);
        this.certsTable.setColumnSelectionAllowed(false);
        if (collection != null && collection.size() > 0) {
            this.certsTable.setRowSelectionInterval(0, 0);
        }
        jScrollPane.setViewportView(this.certsTable);
        this.add((Component)jScrollPane, "Center");
    }

    void setCertificateTableModel(TableModel tableModel) {
        this.certsTable.setModel(tableModel);
        this.certsTable.setDragEnabled(false);
        this.certsTable.setSelectionMode(0);
        this.certsTable.setColumnSelectionAllowed(false);
        if (tableModel.getRowCount() > 0) {
            this.certsTable.setRowSelectionInterval(0, 0);
        }
        this.certsTable.updateUI();
    }

    int getSelectedCertificateTableRow() {
        return this.certsTable.getSelectedRow();
    }

    boolean isCertificateSelected() {
        return this.getSelectedCertificateTableRow() != -1;
    }
}

