/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.MalformedURLException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTop
extends JPanel {
    private static MBeanServerConnection server;
    private static ThreadMXBean tmbean;
    private static MyTableModel tmodel;

    public JTop() {
        super(new GridLayout(1, 0));
        tmodel = new MyTableModel();
        JTable jTable = new JTable(tmodel);
        jTable.setPreferredScrollableViewportSize(new Dimension(500, 300));
        jTable.setDefaultRenderer(Double.class, new DoubleRenderer());
        jTable.setIntercellSpacing(new Dimension(6, 3));
        jTable.setRowHeight(jTable.getRowHeight() + 4);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        this.add(jScrollPane);
    }

    public static void main(String[] stringArray) throws Exception {
        String[] stringArray2;
        if (stringArray.length != 1) {
            JTop.usage();
        }
        if ((stringArray2 = stringArray[0].split(":")).length != 2) {
            JTop.usage();
        }
        String string = stringArray2[0];
        int n = -1;
        try {
            n = Integer.parseInt(stringArray2[1]);
        }
        catch (NumberFormatException numberFormatException) {
            JTop.usage();
        }
        if (n < 0) {
            JTop.usage();
        }
        if (!(tmbean = ManagementFactory.newPlatformMXBeanProxy(server = JTop.connect(string, n), "java.lang:type=Threading", ThreadMXBean.class)).isThreadCpuTimeSupported()) {
            System.err.println("This VM does not support thread CPU time monitoring");
            System.exit(1);
        }
        tmbean.setThreadCpuTimeEnabled(true);
        TimerTask timerTask = new TimerTask(){

            public void run() {
                tmodel.refresh();
            }
        };
        SwingUtilities.invokeAndWait(new Runnable(){

            public void run() {
                JTop.createAndShowGUI();
            }
        });
        Timer timer = new Timer("JTop Sampling thread");
        timer.schedule(timerTask, 0L, 2000L);
    }

    private static MBeanServerConnection connect(String string, int n) {
        String string2 = "/jndi/rmi://" + string + ":" + n + "/jmxrmi";
        MBeanServerConnection mBeanServerConnection = null;
        try {
            JMXServiceURL jMXServiceURL = new JMXServiceURL("rmi", "", 0, string2);
            JMXConnector jMXConnector = JMXConnectorFactory.connect(jMXServiceURL);
            mBeanServerConnection = jMXConnector.getMBeanServerConnection();
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
            System.err.println("\nCommunication error: " + iOException.getMessage());
            System.exit(1);
        }
        return mBeanServerConnection;
    }

    private static void usage() {
        System.out.println("Usage: java JTop <hostname>:<port>");
        System.exit(1);
    }

    private static List<Map.Entry<Long, ThreadInfo>> getThreadList() {
        long[] lArray = tmbean.getAllThreadIds();
        ThreadInfo[] threadInfoArray = tmbean.getThreadInfo(lArray);
        TreeMap<Long, ThreadInfo> treeMap = new TreeMap<Long, ThreadInfo>();
        for (int i = 0; i < lArray.length; ++i) {
            long l = tmbean.getThreadCpuTime(lArray[i]);
            if (l == -1L || threadInfoArray[i] == null) continue;
            treeMap.put(new Long(l), threadInfoArray[i]);
        }
        Set set = treeMap.entrySet();
        ArrayList<Map.Entry<Long, ThreadInfo>> arrayList = new ArrayList<Map.Entry<Long, ThreadInfo>>(set);
        Collections.reverse(arrayList);
        return arrayList;
    }

    private static void createAndShowGUI() {
        JFrame jFrame = new JFrame("JTop");
        jFrame.setDefaultCloseOperation(3);
        JComponent jComponent = (JComponent)jFrame.getContentPane();
        jComponent.add((Component)new JTop(), "Center");
        jComponent.setOpaque(true);
        jComponent.setBorder(new EmptyBorder(12, 12, 12, 12));
        jFrame.setContentPane(jComponent);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    static class DoubleRenderer
    extends DefaultTableCellRenderer {
        NumberFormat formatter;

        public DoubleRenderer() {
            this.setHorizontalAlignment(4);
            System.out.println(this.getVerticalAlignment());
        }

        public void setValue(Object object) {
            if (this.formatter == null) {
                this.formatter = NumberFormat.getInstance();
                this.formatter.setMinimumFractionDigits(4);
            }
            this.setText(object == null ? "" : this.formatter.format(object));
        }
    }

    static class MyTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{"ThreadName", "CPU(sec)", "State"};
        private List<Map.Entry<Long, ThreadInfo>> threadList;

        public MyTableModel() {
            this.refresh();
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.threadList.size();
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            Map.Entry<Long, ThreadInfo> entry = this.threadList.get(n);
            switch (n2) {
                case 0: {
                    return entry.getValue().getThreadName();
                }
                case 1: {
                    long l = entry.getKey();
                    double d = l / 1000000000L;
                    return new Double(d);
                }
                case 2: {
                    return entry.getValue().getThreadState();
                }
            }
            return null;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public void refresh() {
            this.threadList = JTop.getThreadList();
            this.fireTableDataChanged();
        }
    }
}

