/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.inspector.XArrayDataViewer;
import sun.tools.jconsole.inspector.XMBean;

public class XMBeanInfo
extends JTable {
    private final int NAME_COLUMN = 0;
    private final int VALUE_COLUMN = 1;
    private final String[] columnNames = new String[]{Resources.getText("Name", new Object[0]), Resources.getText("Value", new Object[0])};
    private Font normalFont;
    private Font boldFont;
    private int rowMinHeight = -1;

    public XMBeanInfo() {
        this.setCellSelectionEnabled(false);
        this.setRowSelectionAllowed(false);
        this.setColumnSelectionAllowed(false);
        this.getTableHeader().setReorderingAllowed(false);
        ((DefaultTableModel)this.getModel()).setColumnIdentifiers(this.columnNames);
        this.getColumnModel().getColumn(0).setPreferredWidth(140);
        this.getColumnModel().getColumn(0).setMaxWidth(140);
        this.setAutoResizeMode(2);
        this.addMouseListener(new NotifMouseListener());
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void emptyTable() {
        this.invalidate();
        while (this.getModel().getRowCount() > 0) {
            ((DefaultTableModel)this.getModel()).removeRow(0);
        }
        this.validate();
    }

    public void loadInfo(XMBean xMBean, MBeanInfo mBeanInfo) {
        this.emptyTable();
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
        MBeanNotificationInfo[] mBeanNotificationInfoArray = mBeanInfo.getNotifications();
        Object[] objectArray = new Object[]{Resources.getText("MBean Name", new Object[0]), xMBean.getObjectName()};
        defaultTableModel.addRow(objectArray);
        objectArray[0] = Resources.getText("MBean Java Class", new Object[0]);
        try {
            objectArray[1] = xMBean.getClassName();
        }
        catch (Exception exception) {
            objectArray[1] = Resources.getText("Unavailable", new Object[0]);
        }
        defaultTableModel.addRow(objectArray);
        if (mBeanNotificationInfoArray != null) {
            for (int i = 0; i < mBeanNotificationInfoArray.length; ++i) {
                objectArray[0] = Resources.getText("MBean Notification", new Object[0]);
                objectArray[1] = null;
                NotifCell notifCell = new NotifCell(mBeanNotificationInfoArray[i]);
                objectArray[1] = notifCell;
                defaultTableModel.addRow(objectArray);
            }
        }
        defaultTableModel.newDataAvailable(new TableModelEvent(defaultTableModel));
    }

    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        if (this.normalFont == null) {
            this.normalFont = component.getFont();
            this.boldFont = this.normalFont.deriveFont(1);
        }
        if (n2 == 1 && this.getNotifCell(n, 1) != null) {
            component.setFont(this.boldFont);
        } else {
            component.setFont(this.normalFont);
        }
        return component;
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        NotifCell notifCell = this.getNotifCell(n, n2);
        DefaultTableCellRenderer defaultTableCellRenderer = notifCell != null && notifCell.isInited() ? (DefaultTableCellRenderer)notifCell.getRenderer() : (DefaultTableCellRenderer)super.getCellRenderer(n, n2);
        if (notifCell != null) {
            defaultTableCellRenderer.setToolTipText(Resources.getText("Double click to expand/collapse", new Object[0]) + ". " + notifCell.toString());
        }
        return defaultTableCellRenderer;
    }

    private NotifCell getNotifCell(int n, int n2) {
        Object object = ((DefaultTableModel)this.getModel()).getValueAt(n, n2);
        if (object instanceof NotifCell) {
            return (NotifCell)object;
        }
        return null;
    }

    void updateNotifCell(int n, int n2) {
        Object object = this.getModel().getValueAt(n, 1);
        if (object instanceof NotifCell) {
            NotifCell notifCell = (NotifCell)object;
            if (!notifCell.isInited()) {
                if (this.rowMinHeight == -1) {
                    this.rowMinHeight = this.getRowHeight(n);
                }
                notifCell.init(super.getCellRenderer(n, n2), this.rowMinHeight);
            }
            notifCell.switchState();
            this.setRowHeight(n, notifCell.getHeight());
            this.invalidate();
            this.repaint();
        }
    }

    class NotifMouseListener
    extends MouseAdapter {
        NotifMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() >= 2) {
                int n = XMBeanInfo.this.getSelectedRow();
                int n2 = XMBeanInfo.this.getSelectedColumn();
                if (n2 != 1) {
                    return;
                }
                if (n2 == -1 || n == -1) {
                    return;
                }
                XMBeanInfo.this.updateNotifCell(n, n2);
            }
        }
    }

    class NotifCell {
        TableCellRenderer minRenderer;
        NotifCellRenderer maxRenderer;
        int minHeight;
        boolean minimized = true;
        boolean init = false;
        String name;
        String description;
        String[] types;

        NotifCell(MBeanNotificationInfo mBeanNotificationInfo) {
            this.types = mBeanNotificationInfo.getNotifTypes();
            this.name = mBeanNotificationInfo.getName();
            this.description = mBeanNotificationInfo.getDescription();
        }

        public String toString() {
            return this.description;
        }

        boolean isInited() {
            return this.init;
        }

        void init(TableCellRenderer tableCellRenderer, int n) {
            Component component = XArrayDataViewer.loadArray(this.types);
            this.minRenderer = tableCellRenderer;
            this.maxRenderer = new NotifCellRenderer(component);
            this.minHeight = n;
            this.init = true;
        }

        void switchState() {
            this.minimized = !this.minimized;
        }

        boolean isMaximized() {
            return !this.minimized;
        }

        void minimize() {
            this.minimized = true;
        }

        void maximize() {
            this.minimized = false;
        }

        int getHeight() {
            if (this.minimized) {
                return this.minHeight;
            }
            return (int)this.maxRenderer.getComponent().getPreferredSize().getHeight();
        }

        TableCellRenderer getRenderer() {
            if (this.minimized) {
                return this.minRenderer;
            }
            return this.maxRenderer;
        }
    }

    class NotifCellRenderer
    extends DefaultTableCellRenderer {
        Component comp;

        NotifCellRenderer(Component component) {
            this.comp = component;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return this.comp;
        }

        public Component getComponent() {
            return this.comp;
        }
    }
}

