/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import sun.font.CharToGlyphMapper;
import sun.font.FileFont;
import sun.font.FontManager;
import sun.font.FontStrikeDesc;
import sun.font.FontStrikeDisposer;
import sun.font.NativeStrike;
import sun.font.PhysicalStrike;
import sun.font.StrikeCache;
import sun.font.StrikeMetrics;
import sun.font.TrueTypeFont;

public class FileFontStrike
extends PhysicalStrike {
    static final int INVISIBLE_GLYPHS = 65534;
    private FileFont fileFont;
    protected float[] horizontalAdvances;
    ConcurrentHashMap boundsMap;
    SoftReference glyphMetricsMapRef;
    AffineTransform invertDevTx;
    boolean useNatives;
    NativeStrike[] nativeStrikes;
    private static final int SLOTZEROMAX = 0xFFFFFF;

    FileFontStrike(FileFont fileFont, FontStrikeDesc fontStrikeDesc) {
        super(fileFont, fontStrikeDesc);
        int n;
        this.fileFont = fileFont;
        if (fontStrikeDesc.style != fileFont.style) {
            if ((fontStrikeDesc.style & 2) == 2 && (fileFont.style & 2) == 0) {
                this.algoStyle = true;
                this.italic = 0.7f;
            }
            if ((fontStrikeDesc.style & 1) == 1 && (fileFont.style & 1) == 0) {
                this.algoStyle = true;
                this.boldness = 1.33f;
            }
        }
        double[] dArray = new double[4];
        AffineTransform affineTransform = fontStrikeDesc.glyphTx;
        affineTransform.getMatrix(dArray);
        if (!fontStrikeDesc.devTx.isIdentity() && fontStrikeDesc.devTx.getType() != 1) {
            try {
                this.invertDevTx = fontStrikeDesc.devTx.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }
        this.pScalerContext = this.createScalerContext(fileFont.getScaler(), dArray, fileFont instanceof TrueTypeFont, fontStrikeDesc.aaHint, fontStrikeDesc.fmHint, this.algoStyle, this.boldness, this.italic);
        this.mapper = fileFont.getMapper();
        int n2 = this.mapper.getNumGlyphs();
        if (this.pScalerContext == 0L) {
            if (FontManager.longAddresses) {
                this.longGlyphImages = new long[n2];
            } else {
                this.intGlyphImages = new int[n2];
            }
            this.pScalerContext = FileFontStrike.getNullScalerContext(fileFont.getNullScaler());
            FontManager.deRegisterBadFont(fileFont);
            return;
        }
        if (fileFont.useNatives && !fontStrikeDesc.aaHint && !this.algoStyle && dArray[1] == 0.0 && dArray[2] == 0.0 && dArray[0] >= 6.0 && dArray[0] <= 36.0 && dArray[0] == dArray[3]) {
            this.useNatives = true;
            n = fileFont.nativeFonts.length;
            this.nativeStrikes = new NativeStrike[n];
            for (int i = 0; i < n; ++i) {
                this.nativeStrikes[i] = new NativeStrike(fileFont.nativeFonts[i], fontStrikeDesc, false);
            }
        }
        this.disposer = new FontStrikeDisposer(fileFont, fontStrikeDesc, this.pScalerContext);
        boolean bl = this.getImageWithAdvance = this.useNatives || affineTransform.getScaleY() < 20.0 && (affineTransform.getType() & 0x7C) == 0;
        if (this.getImageWithAdvance && n2 < 1000) {
            this.horizontalAdvances = new float[n2];
            for (n = 0; n < n2; ++n) {
                this.horizontalAdvances[n] = Float.MAX_VALUE;
            }
        }
    }

    private boolean usingIntGlyphImages() {
        if (this.intGlyphImages != null) {
            return true;
        }
        if (FontManager.longAddresses) {
            return false;
        }
        this.intGlyphImages = new int[this.mapper.getNumGlyphs()];
        this.disposer.intGlyphImages = this.intGlyphImages;
        return true;
    }

    private long[] getLongGlyphImages() {
        if (this.longGlyphImages == null && FontManager.longAddresses) {
            this.longGlyphImages = new long[this.mapper.getNumGlyphs()];
            this.disposer.longGlyphImages = this.longGlyphImages;
        }
        return this.longGlyphImages;
    }

    static synchronized native long getNullScalerContext(long var0);

    private native long createScalerContext(long var1, double[] var3, boolean var4, boolean var5, boolean var6, boolean var7, float var8, float var9);

    public int getNumGlyphs() {
        return this.fileFont.getNumGlyphs();
    }

    long getGlyphImageFromNative(int n) {
        char c = this.fileFont.glyphToCharMap[n];
        for (int i = 0; i < this.nativeStrikes.length; ++i) {
            long l;
            CharToGlyphMapper charToGlyphMapper = this.fileFont.nativeFonts[i].getMapper();
            int n2 = charToGlyphMapper.charToGlyph(c) & 0xFFFF;
            if (n2 == charToGlyphMapper.getMissingGlyphCode() || (l = this.nativeStrikes[i].getGlyphImagePtrNoCache(n2)) == 0L) continue;
            return l;
        }
        return this.fileFont.getGlyphImage(this.pScalerContext, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getGlyphImagePtr(int n) {
        if (n >= 65534) {
            return StrikeCache.invisibleGlyphPtr;
        }
        if (this.usingIntGlyphImages()) {
            long l = (long)this.intGlyphImages[n] & 0xFFFFFFFFL;
            if (l != 0L) {
                return l;
            }
            l = this.useNatives ? this.getGlyphImageFromNative(n) : this.fileFont.getGlyphImage(this.pScalerContext, n);
            FileFontStrike fileFontStrike = this;
            synchronized (fileFontStrike) {
                if (this.intGlyphImages[n] == 0) {
                    this.intGlyphImages[n] = (int)l;
                    return l;
                }
                StrikeCache.freeIntPointer((int)l);
                return (long)this.intGlyphImages[n] & 0xFFFFFFFFL;
            }
        }
        long l = this.getLongGlyphImages()[n];
        if (l != 0L) {
            return l;
        }
        l = this.useNatives ? this.getGlyphImageFromNative(n) : this.fileFont.getGlyphImage(this.pScalerContext, n);
        FileFontStrike fileFontStrike = this;
        synchronized (fileFontStrike) {
            if (this.longGlyphImages[n] == 0L) {
                this.longGlyphImages[n] = l;
                return l;
            }
            StrikeCache.freeLongPointer(l);
            return this.longGlyphImages[n];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getGlyphImagePtrs(int[] nArray, long[] lArray, int n) {
        if (this.usingIntGlyphImages()) {
            for (int i = 0; i < n; ++i) {
                int n2 = nArray[i];
                if (n2 >= 65534) {
                    lArray[i] = StrikeCache.invisibleGlyphPtr;
                    continue;
                }
                lArray[i] = (long)this.intGlyphImages[n2] & 0xFFFFFFFFL;
                if (lArray[i] != 0L) continue;
                long l = this.useNatives ? this.getGlyphImageFromNative(n2) : this.fileFont.getGlyphImage(this.pScalerContext, n2);
                FileFontStrike fileFontStrike = this;
                synchronized (fileFontStrike) {
                    if (this.intGlyphImages[n2] == 0) {
                        this.intGlyphImages[n2] = (int)l;
                        lArray[i] = l;
                    } else {
                        StrikeCache.freeIntPointer((int)l);
                        lArray[i] = (long)this.intGlyphImages[n2] & 0xFFFFFFFFL;
                    }
                    continue;
                }
            }
        } else {
            long[] lArray2 = this.getLongGlyphImages();
            for (int i = 0; i < n; ++i) {
                int n3 = nArray[i];
                if (n3 >= 65534) {
                    lArray[i] = StrikeCache.invisibleGlyphPtr;
                    continue;
                }
                lArray[i] = lArray2[n3];
                if (lArray[i] != 0L) continue;
                long l = this.useNatives ? this.getGlyphImageFromNative(n3) : this.fileFont.getGlyphImage(this.pScalerContext, n3);
                FileFontStrike fileFontStrike = this;
                synchronized (fileFontStrike) {
                    if (lArray2[n3] == 0L) {
                        lArray2[n3] = l;
                        lArray[i] = l;
                    } else {
                        StrikeCache.freeLongPointer(l);
                        lArray[i] = lArray2[n3];
                    }
                    continue;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getSlot0GlyphImagePtrs(int[] nArray, long[] lArray, int n) {
        int n2 = 0;
        if (this.usingIntGlyphImages()) {
            for (int i = 0; i < n; ++i) {
                int n3 = nArray[i];
                if (n3 >= 0xFFFFFF) {
                    return n2;
                }
                ++n2;
                if (n3 >= 65534) {
                    lArray[i] = StrikeCache.invisibleGlyphPtr;
                    continue;
                }
                lArray[i] = (long)this.intGlyphImages[n3] & 0xFFFFFFFFL;
                if (lArray[i] != 0L) continue;
                long l = this.useNatives ? this.getGlyphImageFromNative(n3) : this.fileFont.getGlyphImage(this.pScalerContext, n3);
                FileFontStrike fileFontStrike = this;
                synchronized (fileFontStrike) {
                    if (this.intGlyphImages[n3] == 0) {
                        this.intGlyphImages[n3] = (int)l;
                        lArray[i] = l;
                    } else {
                        StrikeCache.freeIntPointer((int)l);
                        lArray[i] = (long)this.intGlyphImages[n3] & 0xFFFFFFFFL;
                    }
                    continue;
                }
            }
        } else {
            long[] lArray2 = this.getLongGlyphImages();
            for (int i = 0; i < n; ++i) {
                int n4 = nArray[i];
                if (n4 >= 0xFFFFFF) {
                    return n2;
                }
                ++n2;
                if (n4 >= 65534) {
                    lArray[i] = StrikeCache.invisibleGlyphPtr;
                    continue;
                }
                lArray[i] = lArray2[n4];
                if (lArray[i] != 0L) continue;
                long l = this.fileFont.getGlyphImage(this.pScalerContext, n4);
                FileFontStrike fileFontStrike = this;
                synchronized (fileFontStrike) {
                    if (lArray2[n4] == 0L) {
                        lArray2[n4] = l;
                        lArray[i] = l;
                    } else {
                        StrikeCache.freeLongPointer(l);
                        lArray[i] = lArray2[n4];
                    }
                    continue;
                }
            }
        }
        return n2;
    }

    long getCachedGlyphPtr(int n) {
        if (this.intGlyphImages != null) {
            return (long)this.intGlyphImages[n] & 0xFFFFFFFFL;
        }
        if (this.longGlyphImages != null) {
            return this.longGlyphImages[n];
        }
        return 0L;
    }

    float getGlyphAdvance(int n) {
        float f;
        if (n >= 65534) {
            return 0.0f;
        }
        if (this.horizontalAdvances != null && (f = this.horizontalAdvances[n]) != Float.MAX_VALUE) {
            return f;
        }
        if (this.invertDevTx != null) {
            f = this.getGlyphMetrics((int)n).x;
        } else {
            long l = this.getImageWithAdvance ? this.getGlyphImagePtr(n) : this.getCachedGlyphPtr(n);
            f = l != 0L ? StrikeCache.unsafe.getFloat(l + (long)StrikeCache.xAdvanceOffset) : this.fileFont.getGlyphAdvance(this.pScalerContext, n);
        }
        if (this.horizontalAdvances != null) {
            this.horizontalAdvances[n] = f;
        }
        return f;
    }

    float getCodePointAdvance(int n) {
        return this.getGlyphAdvance(this.mapper.charToGlyph(n));
    }

    void getGlyphImageBounds(int n, Point2D.Float float_, Rectangle rectangle) {
        long l = this.getGlyphImagePtr(n);
        float f = StrikeCache.unsafe.getFloat(l + (long)StrikeCache.topLeftXOffset);
        float f2 = StrikeCache.unsafe.getFloat(l + (long)StrikeCache.topLeftYOffset);
        rectangle.x = (int)Math.floor(float_.x + f);
        rectangle.y = (int)Math.floor(float_.y + f2);
        rectangle.width = StrikeCache.unsafe.getShort(l + (long)StrikeCache.widthOffset) & 0xFFFF;
        rectangle.height = StrikeCache.unsafe.getShort(l + (long)StrikeCache.heightOffset) & 0xFFFF;
    }

    StrikeMetrics getFontMetrics() {
        if (this.strikeMetrics == null) {
            this.strikeMetrics = this.fileFont.getFontMetrics(this.pScalerContext);
            if (this.invertDevTx != null) {
                this.strikeMetrics.convertToUserSpace(this.invertDevTx);
            }
        }
        return this.strikeMetrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Point2D.Float getGlyphMetrics(int n) {
        Point2D.Float float_ = new Point2D.Float();
        if (n >= 65534) {
            return float_;
        }
        long l = this.getImageWithAdvance ? this.getGlyphImagePtr(n) : this.getCachedGlyphPtr(n);
        if (l != 0L) {
            float_ = new Point2D.Float();
            float_.x = StrikeCache.unsafe.getFloat(l + (long)StrikeCache.xAdvanceOffset);
            float_.y = StrikeCache.unsafe.getFloat(l + (long)StrikeCache.yAdvanceOffset);
            if (this.invertDevTx != null) {
                this.invertDevTx.deltaTransform(float_, float_);
            }
        } else {
            FileFontStrike fileFontStrike;
            Integer n2 = new Integer(n);
            Point2D.Float float_2 = null;
            HashMap<Integer, Point2D.Float> hashMap = null;
            if (this.glyphMetricsMapRef != null) {
                hashMap = (HashMap<Integer, Point2D.Float>)this.glyphMetricsMapRef.get();
            }
            if (hashMap != null) {
                fileFontStrike = this;
                synchronized (fileFontStrike) {
                    float_2 = (Point2D.Float)hashMap.get(n2);
                    if (float_2 != null) {
                        float_.x = float_2.x;
                        float_.y = float_2.y;
                        return float_;
                    }
                }
            }
            if (float_2 == null) {
                this.fileFont.getGlyphMetrics(this.pScalerContext, n, float_);
                if (this.invertDevTx != null) {
                    this.invertDevTx.deltaTransform(float_, float_);
                }
                float_2 = new Point2D.Float(float_.x, float_.y);
                fileFontStrike = this;
                synchronized (fileFontStrike) {
                    if (hashMap == null) {
                        hashMap = new HashMap<Integer, Point2D.Float>();
                        this.glyphMetricsMapRef = new SoftReference(hashMap);
                    }
                    hashMap.put(n2, float_2);
                }
            }
        }
        return float_;
    }

    Point2D.Float getCharMetrics(char c) {
        return this.getGlyphMetrics(this.mapper.charToGlyph(c));
    }

    Rectangle2D.Float getGlyphOutlineBounds(int n) {
        Integer n2;
        Rectangle2D.Float float_;
        if (this.boundsMap == null) {
            this.boundsMap = new ConcurrentHashMap();
        }
        if ((float_ = (Rectangle2D.Float)this.boundsMap.get(n2 = new Integer(n))) == null) {
            float_ = this.fileFont.getGlyphOutlineBounds(this.pScalerContext, n);
            this.boundsMap.put(n2, float_);
        }
        return float_;
    }

    public Rectangle2D getOutlineBounds(int n) {
        return this.fileFont.getGlyphOutlineBounds(this.pScalerContext, n);
    }

    GeneralPath getGlyphOutline(int n, float f, float f2) {
        return this.fileFont.getGlyphOutline(this.pScalerContext, n, f, f2);
    }

    GeneralPath getGlyphVectorOutline(int[] nArray, float f, float f2) {
        return this.fileFont.getGlyphVectorOutline(this.pScalerContext, nArray, nArray.length, f, f2);
    }

    protected void adjustPoint(Point2D.Float float_) {
        if (this.invertDevTx != null) {
            this.invertDevTx.deltaTransform(float_, float_);
        }
    }
}

