/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.X11.IXAnyEvent;
import sun.awt.X11.XAnyEvent;
import sun.awt.X11.XAtom;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XDestroyWindowEvent;
import sun.awt.X11.XEventDispatcher;
import sun.awt.X11.XMSelectionListener;
import sun.awt.X11.XPropertyEvent;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XlibWrapper;

public class XMSelection {
    private static Logger log = Logger.getLogger("sun.awt.X11.XMSelection");
    String selectionName;
    Vector listeners;
    XAtom[] atoms;
    long[] owners;
    long eventMask;
    static int numScreens;
    static XAtom XA_MANAGER;
    static HashMap selectionMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initScreen(long l, final int n) {
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            long l2 = XlibWrapper.RootWindow(l, n);
            XlibWrapper.XSelectInput(l, l2, 131072L);
            XToolkit.addEventDispatcher(l2, new XEventDispatcher(){

                public void dispatchEvent(IXAnyEvent iXAnyEvent) {
                    XMSelection.processRootEvent((XAnyEvent)iXAnyEvent, n);
                }
            });
        }
    }

    public int getNumberOfScreens() {
        return numScreens;
    }

    void select(long l) {
        this.eventMask = l;
        for (int i = 0; i < numScreens; ++i) {
            this.selectPerScreen(i, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetOwner(long l, final int n) {
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            long l2 = XToolkit.getDisplay();
            XMSelection xMSelection = this;
            synchronized (xMSelection) {
                this.setOwner(l, n);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("New Selection Owner for screen " + n + " = " + l);
                }
                XlibWrapper.XSelectInput(l2, l, 0x20000L | this.eventMask);
                XToolkit.addEventDispatcher(l, new XEventDispatcher(){

                    public void dispatchEvent(IXAnyEvent iXAnyEvent) {
                        XMSelection.this.dispatchSelectionEvent(iXAnyEvent, n);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void selectPerScreen(final int n, long l) {
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            try {
                long l2 = XToolkit.getDisplay();
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Grabbing XServer");
                }
                XlibWrapper.XGrabServer(l2);
                XMSelection xMSelection = this;
                synchronized (xMSelection) {
                    String string = this.getName() + "_S" + n;
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Screen = " + n + " selection name = " + string);
                    }
                    XAtom xAtom = XAtom.get(string);
                    selectionMap.put(new Long(xAtom.getAtom()), this);
                    this.setAtom(xAtom, n);
                    long l3 = XlibWrapper.XGetSelectionOwner(l2, xAtom.getAtom());
                    if (l3 != 0L) {
                        this.setOwner(l3, n);
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Selection Owner for screen " + n + " = " + l3);
                        }
                        XlibWrapper.XSelectInput(l2, l3, 0x20000L | l);
                        XToolkit.addEventDispatcher(l3, new XEventDispatcher(){

                            public void dispatchEvent(IXAnyEvent iXAnyEvent) {
                                XMSelection.this.dispatchSelectionEvent(iXAnyEvent, n);
                            }
                        });
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("UnGrabbing XServer");
                }
                XlibWrapper.XUngrabServer(XToolkit.getDisplay());
            }
        }
    }

    static boolean processClientMessage(XClientMessageEvent xClientMessageEvent, int n) {
        if (xClientMessageEvent.get_message_type() == XA_MANAGER.getAtom()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("client messags = " + xClientMessageEvent);
            }
            long l = xClientMessageEvent.get_data(0);
            long l2 = xClientMessageEvent.get_data(1);
            long l3 = xClientMessageEvent.get_data(2);
            long l4 = xClientMessageEvent.get_data(3);
            XMSelection xMSelection = XMSelection.getInstance(l2);
            if (xMSelection != null) {
                xMSelection.resetOwner(l3, n);
                xMSelection.dispatchOwnerChangedEvent(xClientMessageEvent, n, l3, l4, l);
            }
        }
        return false;
    }

    static boolean processRootEvent(XAnyEvent xAnyEvent, int n) {
        switch (xAnyEvent.get_type()) {
            case 33: {
                XClientMessageEvent xClientMessageEvent = new XClientMessageEvent(xAnyEvent.pData);
                return XMSelection.processClientMessage(xClientMessageEvent, n);
            }
        }
        return false;
    }

    static XMSelection getInstance(long l) {
        return (XMSelection)selectionMap.get(new Long(l));
    }

    public XMSelection(String string) {
        this(string, 0x400000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMSelection(String string, long l) {
        XMSelection xMSelection = this;
        synchronized (xMSelection) {
            this.selectionName = string;
            this.atoms = new XAtom[this.getNumberOfScreens()];
            this.owners = new long[this.getNumberOfScreens()];
        }
        this.select(l);
    }

    public synchronized void addSelectionListener(XMSelectionListener xMSelectionListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.add(xMSelectionListener);
    }

    public synchronized void removeSelectionListener(XMSelectionListener xMSelectionListener) {
        if (this.listeners == null) {
            this.listeners.remove(xMSelectionListener);
        }
    }

    synchronized Collection getListeners() {
        return this.listeners;
    }

    synchronized XAtom getAtom(int n) {
        if (this.atoms != null) {
            return this.atoms[n];
        }
        return null;
    }

    synchronized void setAtom(XAtom xAtom, int n) {
        if (this.atoms != null) {
            this.atoms[n] = xAtom;
        }
    }

    synchronized long getOwner(int n) {
        if (this.owners != null) {
            return this.owners[n];
        }
        return 0L;
    }

    synchronized void setOwner(long l, int n) {
        if (this.owners != null) {
            this.owners[n] = l;
        }
    }

    synchronized String getName() {
        return this.selectionName;
    }

    synchronized void dispatchSelectionChanged(XPropertyEvent xPropertyEvent, int n) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Selection Changed : Screen = " + n + "Event =" + xPropertyEvent);
        }
        if (this.listeners != null) {
            for (XMSelectionListener xMSelectionListener : this.listeners) {
                xMSelectionListener.selectionChanged(n, this, xPropertyEvent.get_window(), xPropertyEvent);
            }
        }
    }

    synchronized void dispatchOwnerDeath(XDestroyWindowEvent xDestroyWindowEvent, int n) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Owner dead : Screen = " + n + "Event =" + xDestroyWindowEvent);
        }
        if (this.listeners != null) {
            for (XMSelectionListener xMSelectionListener : this.listeners) {
                xMSelectionListener.ownerDeath(n, this, xDestroyWindowEvent.get_window());
            }
        }
    }

    void dispatchSelectionEvent(IXAnyEvent iXAnyEvent, int n) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Event =" + iXAnyEvent);
        }
        if (iXAnyEvent.get_type() == 17) {
            XDestroyWindowEvent xDestroyWindowEvent = new XDestroyWindowEvent(iXAnyEvent.getPData());
            this.dispatchOwnerDeath(xDestroyWindowEvent, n);
        } else if (iXAnyEvent.get_type() == 28) {
            XPropertyEvent xPropertyEvent = new XPropertyEvent(iXAnyEvent.getPData());
            this.dispatchSelectionChanged(xPropertyEvent, n);
        }
    }

    synchronized void dispatchOwnerChangedEvent(IXAnyEvent iXAnyEvent, int n, long l, long l2, long l3) {
        if (this.listeners != null) {
            for (XMSelectionListener xMSelectionListener : this.listeners) {
                xMSelectionListener.ownerChanged(n, this, l, l2, l3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        long l = XToolkit.getDisplay();
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            numScreens = XlibWrapper.ScreenCount(l);
        }
        XA_MANAGER = XAtom.get("MANAGER");
        for (int i = 0; i < numScreens; ++i) {
            XMSelection.initScreen(l, i);
        }
        selectionMap = new HashMap();
    }
}

