/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import java.util.Timer;
import java.util.TimerTask;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.monitor.GaugeMonitorMBean;
import javax.management.monitor.Monitor;

public class GaugeMonitor
extends Monitor
implements GaugeMonitorMBean {
    private static final Integer INTEGER_ZERO = new Integer(0);
    private Number highThreshold = INTEGER_ZERO;
    private Number lowThreshold = INTEGER_ZERO;
    private boolean notifyHigh = false;
    private boolean notifyLow = false;
    private boolean differenceMode = false;
    private Number[] derivedGauge = new Number[16];
    private long[] derivedGaugeTimestamp = new long[16];
    private Number[] previousScanGauge = new Number[16];
    private int[] status = new int[16];
    private int[] type = new int[16];
    private static final int RISING = 0;
    private static final int FALLING = 1;
    private static final int RISING_OR_FALLING = 2;
    private static final int INTEGER = 0;
    private static final int BYTE = 1;
    private static final int SHORT = 2;
    private static final int LONG = 3;
    private static final int FLOAT = 4;
    private static final int DOUBLE = 5;
    private static final int THRESHOLD_ERROR_NOTIFIED = 16;
    private Timer timer = null;

    String makeDebugTag() {
        return "GaugeMonitor";
    }

    public GaugeMonitor() {
        this.dbgTag = this.makeDebugTag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (GaugeMonitor.isTraceOn()) {
            this.trace("start", "start the gauge monitor");
        }
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            if (this.isActive) {
                if (GaugeMonitor.isTraceOn()) {
                    this.trace("start", "the gauge monitor is already activated");
                }
                return;
            }
            this.isActive = true;
            for (int i = 0; i < this.elementCount; ++i) {
                this.status[i] = 2;
                this.previousScanGauge[i] = null;
            }
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new GaugeAlarmClock(this), this.getGranularityPeriod(), this.getGranularityPeriod());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.trace("stop", "stop the gauge monitor");
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            if (!this.isActive) {
                if (GaugeMonitor.isTraceOn()) {
                    this.trace("stop", "the counter monitor is already started");
                }
                return;
            }
            this.isActive = false;
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
        }
    }

    public synchronized void setGranularityPeriod(long l) throws IllegalArgumentException {
        super.setGranularityPeriod(l);
        if (this.isActive()) {
            this.timer.cancel();
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new GaugeAlarmClock(this), this.getGranularityPeriod(), this.getGranularityPeriod());
        }
    }

    public synchronized Number getDerivedGauge(ObjectName objectName) {
        int n = this.indexOf(objectName);
        if (n != -1) {
            return this.derivedGauge[n];
        }
        return null;
    }

    public synchronized long getDerivedGaugeTimeStamp(ObjectName objectName) {
        int n = this.indexOf(objectName);
        if (n != -1) {
            return this.derivedGaugeTimestamp[n];
        }
        return 0L;
    }

    @Deprecated
    public synchronized Number getDerivedGauge() {
        return this.derivedGauge[0];
    }

    @Deprecated
    public synchronized long getDerivedGaugeTimeStamp() {
        return this.derivedGaugeTimestamp[0];
    }

    public synchronized Number getHighThreshold() {
        return this.highThreshold;
    }

    public synchronized Number getLowThreshold() {
        return this.lowThreshold;
    }

    public synchronized void setThresholds(Number number, Number number2) throws IllegalArgumentException {
        if (number == null || number2 == null) {
            throw new IllegalArgumentException("Null threshold value");
        }
        if (number.getClass() != number2.getClass()) {
            throw new IllegalArgumentException("Different type threshold values");
        }
        if (this.isFirstStrictlyGreaterThanLast(number2, number, number.getClass().getName())) {
            throw new IllegalArgumentException("High threshold less than low threshold");
        }
        this.highThreshold = number;
        this.lowThreshold = number2;
        for (int i = 0; i < this.elementCount; ++i) {
            this.resetAlreadyNotified(i, 16);
            this.status[i] = 2;
        }
    }

    public synchronized boolean getNotifyHigh() {
        return this.notifyHigh;
    }

    public synchronized void setNotifyHigh(boolean bl) {
        this.notifyHigh = bl;
    }

    public synchronized boolean getNotifyLow() {
        return this.notifyLow;
    }

    public synchronized void setNotifyLow(boolean bl) {
        this.notifyLow = bl;
    }

    public synchronized boolean getDifferenceMode() {
        return this.differenceMode;
    }

    public synchronized void setDifferenceMode(boolean bl) {
        this.differenceMode = bl;
        for (int i = 0; i < this.elementCount; ++i) {
            this.status[i] = 2;
            this.previousScanGauge[i] = null;
        }
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] stringArray = new String[]{"jmx.monitor.error.runtime", "jmx.monitor.error.mbean", "jmx.monitor.error.attribute", "jmx.monitor.error.type", "jmx.monitor.error.threshold", "jmx.monitor.gauge.high", "jmx.monitor.gauge.low"};
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[]{new MBeanNotificationInfo(stringArray, "javax.management.monitor.MonitorNotification", "Notifications sent by the GaugeMonitor MBean")};
        return mBeanNotificationInfoArray;
    }

    private synchronized boolean updateDerivedGauge(Object object, int n) {
        boolean bl;
        this.derivedGaugeTimestamp[n] = System.currentTimeMillis();
        if (this.differenceMode) {
            if (this.previousScanGauge[n] != null) {
                this.setDerivedGaugeWithDifference((Number)object, n);
                bl = true;
            } else {
                bl = false;
            }
            this.previousScanGauge[n] = (Number)object;
        } else {
            this.derivedGauge[n] = (Number)object;
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNotifications(int n) {
        boolean bl = false;
        String string = null;
        long l = 0L;
        String string2 = null;
        Number number = null;
        Number number2 = null;
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            if (this.status[n] == 2) {
                if (this.isFirstGreaterThanLast(this.derivedGauge[n], this.highThreshold, this.type[n])) {
                    if (this.notifyHigh) {
                        bl = true;
                        string = "jmx.monitor.gauge.high";
                        l = this.derivedGaugeTimestamp[n];
                        string2 = "";
                        number = this.derivedGauge[n];
                        number2 = this.highThreshold;
                    }
                    this.status[n] = 1;
                } else if (this.isFirstGreaterThanLast(this.lowThreshold, this.derivedGauge[n], this.type[n])) {
                    if (this.notifyLow) {
                        bl = true;
                        string = "jmx.monitor.gauge.low";
                        l = this.derivedGaugeTimestamp[n];
                        string2 = "";
                        number = this.derivedGauge[n];
                        number2 = this.lowThreshold;
                    }
                    this.status[n] = 0;
                }
            } else if (this.status[n] == 0) {
                if (this.isFirstGreaterThanLast(this.derivedGauge[n], this.highThreshold, this.type[n])) {
                    if (this.notifyHigh) {
                        bl = true;
                        string = "jmx.monitor.gauge.high";
                        l = this.derivedGaugeTimestamp[n];
                        string2 = "";
                        number = this.derivedGauge[n];
                        number2 = this.highThreshold;
                    }
                    this.status[n] = 1;
                }
            } else if (this.status[n] == 1 && this.isFirstGreaterThanLast(this.lowThreshold, this.derivedGauge[n], this.type[n])) {
                if (this.notifyLow) {
                    bl = true;
                    string = "jmx.monitor.gauge.low";
                    l = this.derivedGaugeTimestamp[n];
                    string2 = "";
                    number = this.derivedGauge[n];
                    number2 = this.lowThreshold;
                }
                this.status[n] = 0;
            }
        }
        if (bl) {
            this.sendNotification(string, l, string2, number, number2, n);
        }
    }

    private synchronized boolean isThresholdTypeValid(int n) {
        switch (this.type[n]) {
            case 0: {
                return !(this.highThreshold != INTEGER_ZERO && !(this.highThreshold instanceof Integer) || this.lowThreshold != INTEGER_ZERO && !(this.lowThreshold instanceof Integer));
            }
            case 1: {
                return !(this.highThreshold != INTEGER_ZERO && !(this.highThreshold instanceof Byte) || this.lowThreshold != INTEGER_ZERO && !(this.lowThreshold instanceof Byte));
            }
            case 2: {
                return !(this.highThreshold != INTEGER_ZERO && !(this.highThreshold instanceof Short) || this.lowThreshold != INTEGER_ZERO && !(this.lowThreshold instanceof Short));
            }
            case 3: {
                return !(this.highThreshold != INTEGER_ZERO && !(this.highThreshold instanceof Long) || this.lowThreshold != INTEGER_ZERO && !(this.lowThreshold instanceof Long));
            }
            case 4: {
                return !(this.highThreshold != INTEGER_ZERO && !(this.highThreshold instanceof Float) || this.lowThreshold != INTEGER_ZERO && !(this.lowThreshold instanceof Float));
            }
            case 5: {
                return !(this.highThreshold != INTEGER_ZERO && !(this.highThreshold instanceof Double) || this.lowThreshold != INTEGER_ZERO && !(this.lowThreshold instanceof Double));
            }
        }
        if (GaugeMonitor.isDebugOn()) {
            this.debug("isThresholdTypeValid", "The threshold type is invalid");
        }
        return false;
    }

    private synchronized void setDerivedGaugeWithDifference(Number number, int n) {
        Number number2;
        Number number3 = this.previousScanGauge[n];
        switch (this.type[n]) {
            case 0: {
                number2 = new Integer((Integer)number - (Integer)number3);
                break;
            }
            case 1: {
                number2 = new Byte((byte)((Byte)number - (Byte)number3));
                break;
            }
            case 2: {
                number2 = new Short((short)((Short)number - (Short)number3));
                break;
            }
            case 3: {
                number2 = new Long((Long)number - (Long)number3);
                break;
            }
            case 4: {
                number2 = new Float(((Float)number).floatValue() - ((Float)number3).floatValue());
                break;
            }
            case 5: {
                Double d = new Double((Double)number - (Double)number3);
            }
            default: {
                if (GaugeMonitor.isDebugOn()) {
                    this.debug("setDerivedGaugeWithDifference", "the threshold type is invalid");
                }
                return;
            }
        }
        this.derivedGauge[n] = number2;
    }

    private boolean isFirstGreaterThanLast(Number number, Number number2, int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return number.longValue() >= number2.longValue();
            }
            case 4: 
            case 5: {
                return number.doubleValue() >= number2.doubleValue();
            }
        }
        if (GaugeMonitor.isDebugOn()) {
            this.debug("isFirstGreaterThanLast", "the threshold type is invalid");
        }
        return false;
    }

    private boolean isFirstStrictlyGreaterThanLast(Number number, Number number2, String string) {
        if (string.equals("java.lang.Integer") || string.equals("java.lang.Byte") || string.equals("java.lang.Short") || string.equals("java.lang.Long")) {
            return number.longValue() > number2.longValue();
        }
        if (string.equals("java.lang.Float") || string.equals("java.lang.Double")) {
            return number.doubleValue() > number2.doubleValue();
        }
        if (GaugeMonitor.isDebugOn()) {
            this.debug("isFirstStrictlyGreaterThanLast", "the threshold type is invalid");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyAlarmClock(int n) {
        long l = 0L;
        String string = null;
        Number number = null;
        Object object = null;
        String string2 = null;
        GaugeMonitor gaugeMonitor = this;
        synchronized (gaugeMonitor) {
            if (!this.isActive()) {
                return;
            }
            if (this.getObservedObject(n) == null || this.getObservedAttribute() == null) {
                return;
            }
            try {
                object = this.server.getAttribute(this.getObservedObject(n), this.getObservedAttribute());
                if (object == null) {
                    return;
                }
            }
            catch (NullPointerException nullPointerException) {
                if (this.alreadyNotified(n, 8)) {
                    return;
                }
                string2 = "jmx.monitor.error.runtime";
                this.setAlreadyNotified(n, 8);
                string = "The gauge monitor must be registered in the MBean server.";
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                if (this.alreadyNotified(n, 1)) {
                    return;
                }
                string2 = "jmx.monitor.error.mbean";
                this.setAlreadyNotified(n, 1);
                string = "The observed object must be registered in the MBean server.";
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                if (this.alreadyNotified(n, 2)) {
                    return;
                }
                string2 = "jmx.monitor.error.attribute";
                this.setAlreadyNotified(n, 2);
                string = "The observed attribute must be accessible in the observed object.";
            }
            catch (MBeanException mBeanException) {
                if (this.alreadyNotified(n, 8)) {
                    return;
                }
                string2 = "jmx.monitor.error.runtime";
                this.setAlreadyNotified(n, 8);
                string = mBeanException.getMessage();
            }
            catch (ReflectionException reflectionException) {
                if (this.alreadyNotified(n, 2)) {
                    return;
                }
                string2 = "jmx.monitor.error.attribute";
                this.setAlreadyNotified(n, 2);
                string = reflectionException.getMessage();
            }
            if (string == null) {
                if (object instanceof Integer) {
                    this.type[n] = 0;
                } else if (object instanceof Byte) {
                    this.type[n] = 1;
                } else if (object instanceof Short) {
                    this.type[n] = 2;
                } else if (object instanceof Long) {
                    this.type[n] = 3;
                } else if (object instanceof Float) {
                    this.type[n] = 4;
                } else if (object instanceof Double) {
                    this.type[n] = 5;
                } else {
                    if (this.alreadyNotified(n, 4)) {
                        return;
                    }
                    string2 = "jmx.monitor.error.type";
                    this.setAlreadyNotified(n, 4);
                    string = "The observed attribute type must be an integer type or a floating-point type.";
                }
            }
            if (string == null && !this.isThresholdTypeValid(n)) {
                if (this.alreadyNotified(n, 16)) {
                    return;
                }
                string2 = "jmx.monitor.error.threshold";
                this.setAlreadyNotified(n, 16);
                string = "The threshold high and threshold low must be of the same type as the gauge.";
            }
            if (string == null) {
                this.resetAllAlreadyNotified(n);
                boolean bl = this.updateDerivedGauge(object, n);
                if (bl) {
                    this.updateNotifications(n);
                }
            } else {
                l = this.derivedGaugeTimestamp[n];
                number = this.derivedGauge[n];
                this.status[n] = 2;
                this.previousScanGauge[n] = null;
            }
        }
        if (string != null) {
            this.sendNotification(string2, l, string, number, null, n);
        }
    }

    synchronized void insertSpecificElementAt(int n) {
        if (n != this.elementCount) {
            throw new Error("Internal error: index != elementCount");
        }
        if (this.elementCount >= this.derivedGauge.length) {
            this.derivedGauge = this.expandArray(this.derivedGauge);
            this.previousScanGauge = this.expandArray(this.previousScanGauge);
            this.derivedGaugeTimestamp = this.expandArray(this.derivedGaugeTimestamp);
            this.status = this.expandArray(this.status);
            this.type = this.expandArray(this.type);
        }
        this.derivedGauge[n] = INTEGER_ZERO;
        this.previousScanGauge[n] = null;
        this.derivedGaugeTimestamp[n] = System.currentTimeMillis();
        this.status[n] = 2;
        this.type[n] = 0;
    }

    synchronized void removeSpecificElementAt(int n) {
        if (n < 0 || n >= this.elementCount) {
            return;
        }
        this.removeElementAt(this.derivedGauge, n);
        this.removeElementAt(this.previousScanGauge, n);
        this.removeElementAt(this.derivedGaugeTimestamp, n);
        this.removeElementAt(this.status, n);
        this.removeElementAt(this.type, n);
    }

    private static class GaugeAlarmClock
    extends TimerTask {
        GaugeMonitor listener = null;

        public GaugeAlarmClock(GaugeMonitor gaugeMonitor) {
            this.listener = gaugeMonitor;
        }

        public void run() {
            if (this.listener.isActive()) {
                for (int i = 0; i < this.listener.elementCount; ++i) {
                    this.listener.notifyAlarmClock(i);
                }
            }
        }
    }
}

