/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Map;
import java.util.WeakHashMap;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;

public class MBeanInfo
implements Cloneable,
Serializable {
    static final long serialVersionUID = -6451021435135161911L;
    private final String description;
    private final String className;
    private final MBeanAttributeInfo[] attributes;
    private final MBeanOperationInfo[] operations;
    private final MBeanConstructorInfo[] constructors;
    private final MBeanNotificationInfo[] notifications;
    private transient int hashCode;
    private final transient boolean immutable;
    private static final Map immutability = new WeakHashMap();

    public MBeanInfo(String string, String string2, MBeanAttributeInfo[] mBeanAttributeInfoArray, MBeanConstructorInfo[] mBeanConstructorInfoArray, MBeanOperationInfo[] mBeanOperationInfoArray, MBeanNotificationInfo[] mBeanNotificationInfoArray) throws IllegalArgumentException {
        this.className = string;
        this.description = string2;
        if (mBeanAttributeInfoArray == null) {
            mBeanAttributeInfoArray = MBeanAttributeInfo.NO_ATTRIBUTES;
        }
        this.attributes = mBeanAttributeInfoArray;
        if (mBeanOperationInfoArray == null) {
            mBeanOperationInfoArray = MBeanOperationInfo.NO_OPERATIONS;
        }
        this.operations = mBeanOperationInfoArray;
        if (mBeanConstructorInfoArray == null) {
            mBeanConstructorInfoArray = MBeanConstructorInfo.NO_CONSTRUCTORS;
        }
        this.constructors = mBeanConstructorInfoArray;
        if (mBeanNotificationInfoArray == null) {
            mBeanNotificationInfoArray = MBeanNotificationInfo.NO_NOTIFICATIONS;
        }
        this.notifications = mBeanNotificationInfoArray;
        this.immutable = MBeanInfo.isImmutableClass(this.getClass(), MBeanInfo.class);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String getClassName() {
        return this.className;
    }

    public String getDescription() {
        return this.description;
    }

    public MBeanAttributeInfo[] getAttributes() {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = this.nonNullAttributes();
        if (mBeanAttributeInfoArray.length == 0) {
            return mBeanAttributeInfoArray;
        }
        return (MBeanAttributeInfo[])mBeanAttributeInfoArray.clone();
    }

    private MBeanAttributeInfo[] fastGetAttributes() {
        if (this.immutable) {
            return this.nonNullAttributes();
        }
        return this.getAttributes();
    }

    private MBeanAttributeInfo[] nonNullAttributes() {
        return this.attributes == null ? MBeanAttributeInfo.NO_ATTRIBUTES : this.attributes;
    }

    public MBeanOperationInfo[] getOperations() {
        MBeanOperationInfo[] mBeanOperationInfoArray = this.nonNullOperations();
        if (mBeanOperationInfoArray.length == 0) {
            return mBeanOperationInfoArray;
        }
        return (MBeanOperationInfo[])mBeanOperationInfoArray.clone();
    }

    private MBeanOperationInfo[] fastGetOperations() {
        if (this.immutable) {
            return this.nonNullOperations();
        }
        return this.getOperations();
    }

    private MBeanOperationInfo[] nonNullOperations() {
        return this.operations == null ? MBeanOperationInfo.NO_OPERATIONS : this.operations;
    }

    public MBeanConstructorInfo[] getConstructors() {
        MBeanConstructorInfo[] mBeanConstructorInfoArray = this.nonNullConstructors();
        if (mBeanConstructorInfoArray.length == 0) {
            return mBeanConstructorInfoArray;
        }
        return (MBeanConstructorInfo[])mBeanConstructorInfoArray.clone();
    }

    private MBeanConstructorInfo[] fastGetConstructors() {
        if (this.immutable) {
            return this.nonNullConstructors();
        }
        return this.getConstructors();
    }

    private MBeanConstructorInfo[] nonNullConstructors() {
        return this.constructors == null ? MBeanConstructorInfo.NO_CONSTRUCTORS : this.constructors;
    }

    public MBeanNotificationInfo[] getNotifications() {
        MBeanNotificationInfo[] mBeanNotificationInfoArray = this.nonNullNotifications();
        if (mBeanNotificationInfoArray.length == 0) {
            return mBeanNotificationInfoArray;
        }
        return (MBeanNotificationInfo[])mBeanNotificationInfoArray.clone();
    }

    private MBeanNotificationInfo[] fastGetNotifications() {
        if (this.immutable) {
            return this.nonNullNotifications();
        }
        return this.getNotifications();
    }

    private MBeanNotificationInfo[] nonNullNotifications() {
        return this.notifications == null ? MBeanNotificationInfo.NO_NOTIFICATIONS : this.notifications;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MBeanInfo)) {
            return false;
        }
        MBeanInfo mBeanInfo = (MBeanInfo)object;
        if (!mBeanInfo.getClassName().equals(this.getClassName()) || !mBeanInfo.getDescription().equals(this.getDescription())) {
            return false;
        }
        return Arrays.equals(mBeanInfo.fastGetAttributes(), this.fastGetAttributes()) && Arrays.equals(mBeanInfo.fastGetOperations(), this.fastGetOperations()) && Arrays.equals(mBeanInfo.fastGetConstructors(), this.fastGetConstructors()) && Arrays.equals(mBeanInfo.fastGetNotifications(), this.fastGetNotifications());
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        this.hashCode = this.getClassName().hashCode() ^ MBeanInfo.arrayHashCode(this.fastGetAttributes()) ^ MBeanInfo.arrayHashCode(this.fastGetOperations()) ^ MBeanInfo.arrayHashCode(this.fastGetConstructors()) ^ MBeanInfo.arrayHashCode(this.fastGetNotifications());
        return this.hashCode;
    }

    private static int arrayHashCode(Object[] objectArray) {
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            n ^= objectArray[i].hashCode();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isImmutableClass(Class clazz, Class clazz2) {
        if (clazz == clazz2) {
            return true;
        }
        Map map = immutability;
        synchronized (map) {
            Boolean bl = (Boolean)immutability.get(clazz);
            if (bl == null) {
                try {
                    ImmutabilityAction immutabilityAction = new ImmutabilityAction(clazz, clazz2);
                    bl = (Boolean)AccessController.doPrivileged(immutabilityAction);
                }
                catch (Exception exception) {
                    bl = Boolean.FALSE;
                }
                immutability.put(clazz, bl);
            }
            return bl;
        }
    }

    private static class ImmutabilityAction
    implements PrivilegedAction {
        private final Class subclass;
        private final Class immutableClass;

        ImmutabilityAction(Class clazz, Class clazz2) {
            this.subclass = clazz;
            this.immutableClass = clazz2;
        }

        public Object run() {
            Method[] methodArray = this.immutableClass.getMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                Method method = methodArray[i];
                String string = method.getName();
                if (!string.startsWith("get") && !string.startsWith("is")) continue;
                Class[] classArray = method.getParameterTypes();
                try {
                    Method method2 = this.subclass.getMethod(string, classArray);
                    if (method2.equals(method)) continue;
                    return Boolean.FALSE;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    return Boolean.FALSE;
                }
            }
            return Boolean.TRUE;
        }
    }
}

