/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.InputMismatchException;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.misc.LRUCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Scanner
implements Iterator<String> {
    private CharBuffer buf;
    private static final int BUFFER_SIZE = 1024;
    private int position;
    private Matcher matcher;
    private Pattern delimPattern;
    private Pattern hasNextPattern;
    private int hasNextPosition;
    private String hasNextResult;
    private Readable source;
    private boolean sourceClosed = false;
    private boolean needInput = false;
    private boolean skipped = false;
    private int savedScannerPosition = -1;
    private Object typeCache = null;
    private boolean matchValid = false;
    private boolean closed = false;
    private int radix = 10;
    private int defaultRadix = 10;
    private Locale locale = null;
    private LRUCache<String, Pattern> patternCache = new LRUCache<String, Pattern>(7){

        @Override
        protected Pattern create(String string) {
            return Pattern.compile(string);
        }

        @Override
        protected boolean hasName(Pattern pattern, String string) {
            return pattern.pattern().equals(string);
        }
    };
    private IOException lastException;
    private static Pattern WHITESPACE_PATTERN = Pattern.compile("\\p{javaWhitespace}+");
    private static Pattern FIND_ANY_PATTERN = Pattern.compile("(?s).*");
    private static Pattern NON_ASCII_DIGIT = Pattern.compile("[\\p{javaDigit}&&[^0-9]]");
    private String groupSeparator = "\\,";
    private String decimalSeparator = "\\.";
    private String nanString = "NaN";
    private String infinityString = "Infinity";
    private String positivePrefix = "";
    private String negativePrefix = "\\-";
    private String positiveSuffix = "";
    private String negativeSuffix = "";
    private static volatile Pattern boolPattern;
    private static final String BOOLEAN_PATTERN = "true|false";
    private Pattern integerPattern;
    private String digits = "0123456789abcdefghijklmnopqrstuvwxyz";
    private String non0Digit = "[\\p{javaDigit}&&[^0]]";
    private int SIMPLE_GROUP_INDEX = 5;
    private static volatile Pattern separatorPattern;
    private static final String LINE_SEPARATOR_PATTERN = "\r\n|[\n\r\u2028\u2029\u0085]";
    private Pattern floatPattern;
    private Pattern decimalPattern;

    private static Pattern boolPattern() {
        Pattern pattern = boolPattern;
        if (pattern == null) {
            boolPattern = pattern = Pattern.compile(BOOLEAN_PATTERN, 2);
        }
        return pattern;
    }

    private String buildIntegerPatternString() {
        String string = this.digits.substring(0, this.radix);
        String string2 = "((?i)[" + string + "]|\\p{javaDigit})";
        String string3 = "(" + this.non0Digit + string2 + "?" + string2 + "?(" + this.groupSeparator + string2 + string2 + string2 + ")+)";
        String string4 = "((" + string2 + "++)|" + string3 + ")";
        String string5 = "([-+]?(" + string4 + "))";
        String string6 = this.negativePrefix + string4 + this.negativeSuffix;
        String string7 = this.positivePrefix + string4 + this.positiveSuffix;
        return "(" + string5 + ")|(" + string7 + ")|(" + string6 + ")";
    }

    private Pattern integerPattern() {
        if (this.integerPattern == null) {
            this.integerPattern = this.patternCache.forName(this.buildIntegerPatternString());
        }
        return this.integerPattern;
    }

    private static Pattern separatorPattern() {
        Pattern pattern = separatorPattern;
        if (pattern == null) {
            separatorPattern = pattern = Pattern.compile(LINE_SEPARATOR_PATTERN);
        }
        return pattern;
    }

    private void buildFloatAndDecimalPattern() {
        String string = "([0-9]|(\\p{javaDigit}))";
        String string2 = "([eE][+-]?" + string + "+)?";
        String string3 = "(" + this.non0Digit + string + "?" + string + "?(" + this.groupSeparator + string + string + string + ")+)";
        String string4 = "((" + string + "++)|" + string3 + ")";
        String string5 = "(" + string4 + "|" + string4 + this.decimalSeparator + string + "*+|" + this.decimalSeparator + string + "++)";
        String string6 = "(NaN|" + this.nanString + "|Infinity|" + this.infinityString + ")";
        String string7 = "(" + this.positivePrefix + string5 + this.positiveSuffix + string2 + ")";
        String string8 = "(" + this.negativePrefix + string5 + this.negativeSuffix + string2 + ")";
        String string9 = "(([-+]?" + string5 + string2 + ")|" + string7 + "|" + string8 + ")";
        String string10 = "[-+]?0[xX][0-9a-fA-F]*\\.[0-9a-fA-F]+([pP][-+]?[0-9]+)?";
        String string11 = "(" + this.positivePrefix + string6 + this.positiveSuffix + ")";
        String string12 = "(" + this.negativePrefix + string6 + this.negativeSuffix + ")";
        String string13 = "(([-+]?" + string6 + ")|" + string11 + "|" + string12 + ")";
        this.floatPattern = Pattern.compile(string9 + "|" + string10 + "|" + string13);
        this.decimalPattern = Pattern.compile(string9);
    }

    private Pattern floatPattern() {
        if (this.floatPattern == null) {
            this.buildFloatAndDecimalPattern();
        }
        return this.floatPattern;
    }

    private Pattern decimalPattern() {
        if (this.decimalPattern == null) {
            this.buildFloatAndDecimalPattern();
        }
        return this.decimalPattern;
    }

    private Scanner(Readable readable, Pattern pattern) {
        if (readable == null) {
            throw new NullPointerException("source");
        }
        if (pattern == null) {
            throw new NullPointerException("pattern");
        }
        this.source = readable;
        this.delimPattern = pattern;
        this.buf = CharBuffer.allocate(1024);
        this.buf.limit(0);
        this.matcher = this.delimPattern.matcher(this.buf);
        this.matcher.useTransparentBounds(true);
        this.matcher.useAnchoringBounds(false);
        this.useLocale(Locale.getDefault());
    }

    public Scanner(Readable readable) {
        this(readable, WHITESPACE_PATTERN);
    }

    public Scanner(InputStream inputStream) {
        this(new InputStreamReader(inputStream), WHITESPACE_PATTERN);
    }

    public Scanner(InputStream inputStream, String string) {
        this(Scanner.makeReadable(inputStream, string), WHITESPACE_PATTERN);
    }

    private static Readable makeReadable(InputStream inputStream, String string) {
        if (inputStream == null) {
            throw new NullPointerException("source");
        }
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            illegalArgumentException.initCause(unsupportedEncodingException);
            throw illegalArgumentException;
        }
        return inputStreamReader;
    }

    public Scanner(File file) throws FileNotFoundException {
        this(new FileInputStream(file).getChannel());
    }

    public Scanner(File file, String string) throws FileNotFoundException {
        this(new FileInputStream(file).getChannel(), string);
    }

    public Scanner(String string) {
        this(new StringReader(string), WHITESPACE_PATTERN);
    }

    public Scanner(ReadableByteChannel readableByteChannel) {
        this(Scanner.makeReadable(readableByteChannel), WHITESPACE_PATTERN);
    }

    private static Readable makeReadable(ReadableByteChannel readableByteChannel) {
        if (readableByteChannel == null) {
            throw new NullPointerException("source");
        }
        String string = Charset.defaultCharset().name();
        return Channels.newReader(readableByteChannel, Charset.defaultCharset().name());
    }

    public Scanner(ReadableByteChannel readableByteChannel, String string) {
        this(Scanner.makeReadable(readableByteChannel, string), WHITESPACE_PATTERN);
    }

    private static Readable makeReadable(ReadableByteChannel readableByteChannel, String string) {
        if (readableByteChannel == null) {
            throw new NullPointerException("source");
        }
        if (!Charset.isSupported(string)) {
            throw new IllegalArgumentException(string);
        }
        return Channels.newReader(readableByteChannel, string);
    }

    private void saveState() {
        this.savedScannerPosition = this.position;
    }

    private void revertState() {
        this.position = this.savedScannerPosition;
        this.savedScannerPosition = -1;
        this.skipped = false;
    }

    private boolean revertState(boolean bl) {
        this.position = this.savedScannerPosition;
        this.savedScannerPosition = -1;
        this.skipped = false;
        return bl;
    }

    private void cacheResult(Pattern pattern) {
        this.hasNextPattern = pattern;
        this.hasNextResult = this.matcher.group();
        this.hasNextPosition = this.matcher.end();
    }

    private void clearCaches() {
        this.hasNextPattern = null;
        this.typeCache = null;
    }

    private String getCachedResult() {
        this.position = this.hasNextPosition;
        this.hasNextPattern = null;
        this.typeCache = null;
        return this.hasNextResult;
    }

    private void useTypeCache() {
        if (this.closed) {
            throw new IllegalStateException("Scanner closed");
        }
        this.position = this.hasNextPosition;
        this.hasNextPattern = null;
        this.typeCache = null;
    }

    private void readInput() {
        if (this.buf.limit() == this.buf.capacity()) {
            this.makeSpace();
        }
        int n = this.buf.position();
        this.buf.position(this.buf.limit());
        this.buf.limit(this.buf.capacity());
        int n2 = 0;
        try {
            n2 = this.source.read(this.buf);
        }
        catch (IOException iOException) {
            this.lastException = iOException;
            n2 = -1;
        }
        if (n2 == -1) {
            this.sourceClosed = true;
            this.needInput = false;
        }
        if (n2 > 0) {
            this.needInput = false;
        }
        this.buf.limit(this.buf.position());
        this.buf.position(n);
    }

    private boolean makeSpace() {
        this.clearCaches();
        int n = this.savedScannerPosition == -1 ? this.position : this.savedScannerPosition;
        this.buf.position(n);
        if (n > 0) {
            this.buf.compact();
            this.translateSavedIndexes(n);
            this.position -= n;
            this.buf.flip();
            return true;
        }
        int n2 = this.buf.capacity() * 2;
        CharBuffer charBuffer = CharBuffer.allocate(n2);
        charBuffer.put(this.buf);
        charBuffer.flip();
        this.translateSavedIndexes(n);
        this.position -= n;
        this.buf = charBuffer;
        this.matcher.reset(this.buf);
        return true;
    }

    private void translateSavedIndexes(int n) {
        if (this.savedScannerPosition != -1) {
            this.savedScannerPosition -= n;
        }
    }

    private void throwFor() {
        this.skipped = false;
        if (this.sourceClosed && this.position == this.buf.limit()) {
            throw new NoSuchElementException();
        }
        throw new InputMismatchException();
    }

    private boolean hasTokenInBuffer() {
        this.matchValid = false;
        this.matcher.usePattern(this.delimPattern);
        this.matcher.region(this.position, this.buf.limit());
        if (this.matcher.lookingAt()) {
            this.position = this.matcher.end();
        }
        return this.position != this.buf.limit();
    }

    private String getCompleteTokenInBuffer(Pattern pattern) {
        this.matchValid = false;
        this.matcher.usePattern(this.delimPattern);
        if (!this.skipped) {
            this.matcher.region(this.position, this.buf.limit());
            if (this.matcher.lookingAt()) {
                if (this.matcher.hitEnd() && !this.sourceClosed) {
                    this.needInput = true;
                    return null;
                }
                this.skipped = true;
                this.position = this.matcher.end();
            }
        }
        if (this.position == this.buf.limit()) {
            if (this.sourceClosed) {
                return null;
            }
            this.needInput = true;
            return null;
        }
        this.matcher.region(this.position, this.buf.limit());
        boolean bl = this.matcher.find();
        if (bl && this.matcher.end() == this.position) {
            bl = this.matcher.find();
        }
        if (bl) {
            if (this.matcher.requireEnd() && !this.sourceClosed) {
                this.needInput = true;
                return null;
            }
            int n = this.matcher.start();
            if (pattern == null) {
                pattern = FIND_ANY_PATTERN;
            }
            this.matcher.usePattern(pattern);
            this.matcher.region(this.position, n);
            if (this.matcher.matches()) {
                String string = this.matcher.group();
                this.position = this.matcher.end();
                return string;
            }
            return null;
        }
        if (this.sourceClosed) {
            if (pattern == null) {
                pattern = FIND_ANY_PATTERN;
            }
            this.matcher.usePattern(pattern);
            this.matcher.region(this.position, this.buf.limit());
            if (this.matcher.matches()) {
                String string = this.matcher.group();
                this.position = this.matcher.end();
                return string;
            }
            return null;
        }
        this.needInput = true;
        return null;
    }

    private String findPatternInBuffer(Pattern pattern, int n) {
        this.matchValid = false;
        this.matcher.usePattern(pattern);
        int n2 = this.buf.limit();
        int n3 = -1;
        int n4 = n2;
        if (n > 0 && (n3 = this.position + n) < n2) {
            n4 = n3;
        }
        this.matcher.region(this.position, n4);
        if (this.matcher.find()) {
            if (this.matcher.hitEnd() && !this.sourceClosed) {
                if (n4 != n3) {
                    this.needInput = true;
                    return null;
                }
                if (n4 == n3 && this.matcher.requireEnd()) {
                    this.needInput = true;
                    return null;
                }
            }
            this.position = this.matcher.end();
            return this.matcher.group();
        }
        if (this.sourceClosed) {
            return null;
        }
        if (n == 0 || n4 != n3) {
            this.needInput = true;
        }
        return null;
    }

    private String matchPatternInBuffer(Pattern pattern) {
        this.matchValid = false;
        this.matcher.usePattern(pattern);
        this.matcher.region(this.position, this.buf.limit());
        if (this.matcher.lookingAt()) {
            if (this.matcher.hitEnd() && !this.sourceClosed) {
                this.needInput = true;
                return null;
            }
            this.position = this.matcher.end();
            return this.matcher.group();
        }
        if (this.sourceClosed) {
            return null;
        }
        this.needInput = true;
        return null;
    }

    private void ensureOpen() {
        if (this.closed) {
            throw new IllegalStateException("Scanner closed");
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        if (this.source instanceof Closeable) {
            try {
                ((Closeable)((Object)this.source)).close();
            }
            catch (IOException iOException) {
                this.lastException = iOException;
            }
        }
        this.sourceClosed = true;
        this.source = null;
        this.closed = true;
    }

    public IOException ioException() {
        return this.lastException;
    }

    public Pattern delimiter() {
        return this.delimPattern;
    }

    public Scanner useDelimiter(Pattern pattern) {
        this.delimPattern = pattern;
        return this;
    }

    public Scanner useDelimiter(String string) {
        this.delimPattern = this.patternCache.forName(string);
        return this;
    }

    public Locale locale() {
        return this.locale;
    }

    public Scanner useLocale(Locale locale) {
        if (locale.equals(this.locale)) {
            return this;
        }
        this.locale = locale;
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance(locale);
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
        this.groupSeparator = "\\" + decimalFormatSymbols.getGroupingSeparator();
        this.decimalSeparator = "\\" + decimalFormatSymbols.getDecimalSeparator();
        this.nanString = "\\Q" + decimalFormatSymbols.getNaN() + "\\E";
        this.infinityString = "\\Q" + decimalFormatSymbols.getInfinity() + "\\E";
        this.positivePrefix = decimalFormat.getPositivePrefix();
        if (this.positivePrefix.length() > 0) {
            this.positivePrefix = "\\Q" + this.positivePrefix + "\\E";
        }
        this.negativePrefix = decimalFormat.getNegativePrefix();
        if (this.negativePrefix.length() > 0) {
            this.negativePrefix = "\\Q" + this.negativePrefix + "\\E";
        }
        this.positiveSuffix = decimalFormat.getPositiveSuffix();
        if (this.positiveSuffix.length() > 0) {
            this.positiveSuffix = "\\Q" + this.positiveSuffix + "\\E";
        }
        this.negativeSuffix = decimalFormat.getNegativeSuffix();
        if (this.negativeSuffix.length() > 0) {
            this.negativeSuffix = "\\Q" + this.negativeSuffix + "\\E";
        }
        this.integerPattern = null;
        this.floatPattern = null;
        return this;
    }

    public int radix() {
        return this.defaultRadix;
    }

    public Scanner useRadix(int n) {
        if (n < 2 || n > 36) {
            throw new IllegalArgumentException("radix:" + n);
        }
        if (this.defaultRadix == n) {
            return this;
        }
        this.defaultRadix = n;
        this.integerPattern = null;
        return this;
    }

    private void setRadix(int n) {
        if (this.radix != n) {
            this.integerPattern = null;
            this.radix = n;
        }
    }

    public MatchResult match() {
        if (!this.matchValid) {
            throw new IllegalStateException("No match result available");
        }
        return this.matcher.toMatchResult();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("java.util.Scanner");
        stringBuilder.append("[delimiters=" + this.delimPattern + "]");
        stringBuilder.append("[position=" + this.position + "]");
        stringBuilder.append("[match valid=" + this.matchValid + "]");
        stringBuilder.append("[need input=" + this.needInput + "]");
        stringBuilder.append("[source closed=" + this.sourceClosed + "]");
        stringBuilder.append("[skipped=" + this.skipped + "]");
        stringBuilder.append("[group separator=" + this.groupSeparator + "]");
        stringBuilder.append("[decimal separator=" + this.decimalSeparator + "]");
        stringBuilder.append("[positive prefix=" + this.positivePrefix + "]");
        stringBuilder.append("[negative prefix=" + this.negativePrefix + "]");
        stringBuilder.append("[positive suffix=" + this.positiveSuffix + "]");
        stringBuilder.append("[negative suffix=" + this.negativeSuffix + "]");
        stringBuilder.append("[NaN string=" + this.nanString + "]");
        stringBuilder.append("[infinity string=" + this.infinityString + "]");
        return stringBuilder.toString();
    }

    @Override
    public boolean hasNext() {
        this.ensureOpen();
        this.saveState();
        while (!this.sourceClosed) {
            if (this.hasTokenInBuffer()) {
                return this.revertState(true);
            }
            this.readInput();
        }
        boolean bl = this.hasTokenInBuffer();
        return this.revertState(bl);
    }

    @Override
    public String next() {
        this.ensureOpen();
        this.clearCaches();
        while (true) {
            String string;
            if ((string = this.getCompleteTokenInBuffer(null)) != null) {
                this.matchValid = true;
                this.skipped = false;
                return string;
            }
            if (this.needInput) {
                this.readInput();
                continue;
            }
            this.throwFor();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean hasNext(String string) {
        return this.hasNext(this.patternCache.forName(string));
    }

    public String next(String string) {
        return this.next(this.patternCache.forName(string));
    }

    public boolean hasNext(Pattern pattern) {
        this.ensureOpen();
        if (pattern == null) {
            throw new NullPointerException();
        }
        this.hasNextPattern = null;
        this.saveState();
        while (true) {
            if (this.getCompleteTokenInBuffer(pattern) != null) {
                this.matchValid = true;
                this.cacheResult(pattern);
                return this.revertState(true);
            }
            if (!this.needInput) break;
            this.readInput();
        }
        return this.revertState(false);
    }

    public String next(Pattern pattern) {
        this.ensureOpen();
        if (pattern == null) {
            throw new NullPointerException();
        }
        if (this.hasNextPattern == pattern) {
            return this.getCachedResult();
        }
        this.clearCaches();
        while (true) {
            String string;
            if ((string = this.getCompleteTokenInBuffer(pattern)) != null) {
                this.matchValid = true;
                this.skipped = false;
                return string;
            }
            if (this.needInput) {
                this.readInput();
                continue;
            }
            this.throwFor();
        }
    }

    public boolean hasNextLine() {
        this.saveState();
        String string = this.findWithinHorizon(".*(\r\n|[\n\r\u2028\u2029\u0085])|.+$", 0);
        this.revertState();
        return string != null;
    }

    public String nextLine() {
        String string = this.findWithinHorizon(".*(\r\n|[\n\r\u2028\u2029\u0085])|.+$", 0);
        if (string == null) {
            throw new NoSuchElementException("No line found");
        }
        MatchResult matchResult = this.match();
        String string2 = matchResult.group(1);
        if (string2 != null) {
            string = string.substring(0, string.length() - string2.length());
        }
        if (string == null) {
            throw new NoSuchElementException();
        }
        return string;
    }

    public String findInLine(String string) {
        return this.findInLine(this.patternCache.forName(string));
    }

    public String findInLine(Pattern pattern) {
        int n;
        block3: {
            this.ensureOpen();
            if (pattern == null) {
                throw new NullPointerException();
            }
            this.clearCaches();
            n = 0;
            this.saveState();
            while (true) {
                String string;
                if ((string = this.findPatternInBuffer(Scanner.separatorPattern(), 0)) != null) {
                    n = this.matcher.start();
                    break block3;
                }
                if (!this.needInput) break;
                this.readInput();
            }
            n = this.buf.limit();
        }
        this.revertState();
        int n2 = n - this.position;
        return this.findWithinHorizon(pattern, n2);
    }

    public String findWithinHorizon(String string, int n) {
        return this.findWithinHorizon(this.patternCache.forName(string), n);
    }

    public String findWithinHorizon(Pattern pattern, int n) {
        this.ensureOpen();
        if (pattern == null) {
            throw new NullPointerException();
        }
        if (n < 0) {
            throw new IllegalArgumentException("horizon < 0");
        }
        this.clearCaches();
        while (true) {
            String string;
            if ((string = this.findPatternInBuffer(pattern, n)) != null) {
                this.matchValid = true;
                return string;
            }
            if (!this.needInput) break;
            this.readInput();
        }
        return null;
    }

    public Scanner skip(Pattern pattern) {
        this.ensureOpen();
        if (pattern == null) {
            throw new NullPointerException();
        }
        this.clearCaches();
        while (true) {
            String string;
            if ((string = this.matchPatternInBuffer(pattern)) != null) {
                this.matchValid = true;
                this.position = this.matcher.end();
                return this;
            }
            if (!this.needInput) break;
            this.readInput();
        }
        throw new NoSuchElementException();
    }

    public Scanner skip(String string) {
        return this.skip(this.patternCache.forName(string));
    }

    public boolean hasNextBoolean() {
        return this.hasNext(Scanner.boolPattern());
    }

    public boolean nextBoolean() {
        this.clearCaches();
        return Boolean.parseBoolean(this.next(Scanner.boolPattern()));
    }

    public boolean hasNextByte() {
        return this.hasNextByte(this.defaultRadix);
    }

    public boolean hasNextByte(int n) {
        this.setRadix(n);
        boolean bl = this.hasNext(this.integerPattern());
        if (bl) {
            try {
                String string = this.matcher.group(this.SIMPLE_GROUP_INDEX) == null ? this.processIntegerToken(this.hasNextResult) : this.hasNextResult;
                this.typeCache = Byte.parseByte(string, n);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        }
        return bl;
    }

    public byte nextByte() {
        return this.nextByte(this.defaultRadix);
    }

    public byte nextByte(int n) {
        if (this.typeCache != null && this.typeCache instanceof Byte) {
            byte by = (Byte)this.typeCache;
            this.useTypeCache();
            return by;
        }
        this.setRadix(n);
        this.clearCaches();
        try {
            String string = this.next(this.integerPattern());
            if (this.matcher.group(this.SIMPLE_GROUP_INDEX) == null) {
                string = this.processIntegerToken(string);
            }
            return Byte.parseByte(string, n);
        }
        catch (NumberFormatException numberFormatException) {
            this.position = this.matcher.start();
            throw new InputMismatchException(numberFormatException.getMessage());
        }
    }

    public boolean hasNextShort() {
        return this.hasNextShort(this.defaultRadix);
    }

    public boolean hasNextShort(int n) {
        this.setRadix(n);
        boolean bl = this.hasNext(this.integerPattern());
        if (bl) {
            try {
                String string = this.matcher.group(this.SIMPLE_GROUP_INDEX) == null ? this.processIntegerToken(this.hasNextResult) : this.hasNextResult;
                this.typeCache = Short.parseShort(string, n);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        }
        return bl;
    }

    public short nextShort() {
        return this.nextShort(this.defaultRadix);
    }

    public short nextShort(int n) {
        if (this.typeCache != null && this.typeCache instanceof Short) {
            short s = (Short)this.typeCache;
            this.useTypeCache();
            return s;
        }
        this.setRadix(n);
        this.clearCaches();
        try {
            String string = this.next(this.integerPattern());
            if (this.matcher.group(this.SIMPLE_GROUP_INDEX) == null) {
                string = this.processIntegerToken(string);
            }
            return Short.parseShort(string, n);
        }
        catch (NumberFormatException numberFormatException) {
            this.position = this.matcher.start();
            throw new InputMismatchException(numberFormatException.getMessage());
        }
    }

    public boolean hasNextInt() {
        return this.hasNextInt(this.defaultRadix);
    }

    public boolean hasNextInt(int n) {
        this.setRadix(n);
        boolean bl = this.hasNext(this.integerPattern());
        if (bl) {
            try {
                String string = this.matcher.group(this.SIMPLE_GROUP_INDEX) == null ? this.processIntegerToken(this.hasNextResult) : this.hasNextResult;
                this.typeCache = Integer.parseInt(string, n);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        }
        return bl;
    }

    private String processIntegerToken(String string) {
        int n;
        String string2 = string.replaceAll("" + this.groupSeparator, "");
        boolean bl = false;
        int n2 = this.negativePrefix.length();
        if (n2 > 0 && string2.startsWith(this.negativePrefix)) {
            bl = true;
            string2 = string2.substring(n2);
        }
        if ((n = this.negativeSuffix.length()) > 0 && string2.endsWith(this.negativeSuffix)) {
            bl = true;
            string2 = string2.substring(string2.length() - n, string2.length());
        }
        if (bl) {
            string2 = "-" + string2;
        }
        return string2;
    }

    public int nextInt() {
        return this.nextInt(this.defaultRadix);
    }

    public int nextInt(int n) {
        if (this.typeCache != null && this.typeCache instanceof Integer) {
            int n2 = (Integer)this.typeCache;
            this.useTypeCache();
            return n2;
        }
        this.setRadix(n);
        this.clearCaches();
        try {
            String string = this.next(this.integerPattern());
            if (this.matcher.group(this.SIMPLE_GROUP_INDEX) == null) {
                string = this.processIntegerToken(string);
            }
            return Integer.parseInt(string, n);
        }
        catch (NumberFormatException numberFormatException) {
            this.position = this.matcher.start();
            throw new InputMismatchException(numberFormatException.getMessage());
        }
    }

    public boolean hasNextLong() {
        return this.hasNextLong(this.defaultRadix);
    }

    public boolean hasNextLong(int n) {
        this.setRadix(n);
        boolean bl = this.hasNext(this.integerPattern());
        if (bl) {
            try {
                String string = this.matcher.group(this.SIMPLE_GROUP_INDEX) == null ? this.processIntegerToken(this.hasNextResult) : this.hasNextResult;
                this.typeCache = Long.parseLong(string, n);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        }
        return bl;
    }

    public long nextLong() {
        return this.nextLong(this.defaultRadix);
    }

    public long nextLong(int n) {
        if (this.typeCache != null && this.typeCache instanceof Long) {
            long l = (Long)this.typeCache;
            this.useTypeCache();
            return l;
        }
        this.setRadix(n);
        this.clearCaches();
        try {
            String string = this.next(this.integerPattern());
            if (this.matcher.group(this.SIMPLE_GROUP_INDEX) == null) {
                string = this.processIntegerToken(string);
            }
            return Long.parseLong(string, n);
        }
        catch (NumberFormatException numberFormatException) {
            this.position = this.matcher.start();
            throw new InputMismatchException(numberFormatException.getMessage());
        }
    }

    private String processFloatToken(String string) {
        Matcher matcher;
        int n;
        String string2 = string.replaceAll(this.groupSeparator, "");
        if (!this.decimalSeparator.equals("\\.")) {
            string2 = string2.replaceAll(this.decimalSeparator, ".");
        }
        boolean bl = false;
        int n2 = this.negativePrefix.length();
        if (n2 > 0 && string2.startsWith(this.negativePrefix)) {
            bl = true;
            string2 = string2.substring(n2);
        }
        if ((n = this.negativeSuffix.length()) > 0 && string2.endsWith(this.negativeSuffix)) {
            bl = true;
            string2 = string2.substring(string2.length() - n, string2.length());
        }
        if (string2.equals(this.nanString)) {
            string2 = "NaN";
        }
        if (string2.equals(this.infinityString)) {
            string2 = "Infinity";
        }
        if (bl) {
            string2 = "-" + string2;
        }
        if ((matcher = NON_ASCII_DIGIT.matcher(string2)).find()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < string2.length(); ++i) {
                char c = string2.charAt(i);
                if (Character.isDigit(c)) {
                    int n3 = Character.digit(c, 10);
                    if (n3 != -1) {
                        stringBuilder.append(n3);
                        continue;
                    }
                    stringBuilder.append(c);
                    continue;
                }
                stringBuilder.append(c);
            }
            string2 = stringBuilder.toString();
        }
        return string2;
    }

    public boolean hasNextFloat() {
        this.setRadix(10);
        boolean bl = this.hasNext(this.floatPattern());
        if (bl) {
            try {
                String string = this.processFloatToken(this.hasNextResult);
                this.typeCache = Float.valueOf(Float.parseFloat(string));
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        }
        return bl;
    }

    public float nextFloat() {
        if (this.typeCache != null && this.typeCache instanceof Float) {
            float f = ((Float)this.typeCache).floatValue();
            this.useTypeCache();
            return f;
        }
        this.setRadix(10);
        this.clearCaches();
        try {
            return Float.parseFloat(this.processFloatToken(this.next(this.floatPattern())));
        }
        catch (NumberFormatException numberFormatException) {
            this.position = this.matcher.start();
            throw new InputMismatchException(numberFormatException.getMessage());
        }
    }

    public boolean hasNextDouble() {
        this.setRadix(10);
        boolean bl = this.hasNext(this.floatPattern());
        if (bl) {
            try {
                String string = this.processFloatToken(this.hasNextResult);
                this.typeCache = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        }
        return bl;
    }

    public double nextDouble() {
        if (this.typeCache != null && this.typeCache instanceof Double) {
            double d = (Double)this.typeCache;
            this.useTypeCache();
            return d;
        }
        this.setRadix(10);
        this.clearCaches();
        try {
            return Double.parseDouble(this.processFloatToken(this.next(this.floatPattern())));
        }
        catch (NumberFormatException numberFormatException) {
            this.position = this.matcher.start();
            throw new InputMismatchException(numberFormatException.getMessage());
        }
    }

    public boolean hasNextBigInteger() {
        return this.hasNextBigInteger(this.defaultRadix);
    }

    public boolean hasNextBigInteger(int n) {
        this.setRadix(n);
        boolean bl = this.hasNext(this.integerPattern());
        if (bl) {
            try {
                String string = this.matcher.group(this.SIMPLE_GROUP_INDEX) == null ? this.processIntegerToken(this.hasNextResult) : this.hasNextResult;
                this.typeCache = new BigInteger(string, n);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        }
        return bl;
    }

    public BigInteger nextBigInteger() {
        return this.nextBigInteger(this.defaultRadix);
    }

    public BigInteger nextBigInteger(int n) {
        if (this.typeCache != null && this.typeCache instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)this.typeCache;
            this.useTypeCache();
            return bigInteger;
        }
        this.setRadix(n);
        this.clearCaches();
        try {
            String string = this.next(this.integerPattern());
            if (this.matcher.group(this.SIMPLE_GROUP_INDEX) == null) {
                string = this.processIntegerToken(string);
            }
            return new BigInteger(string, n);
        }
        catch (NumberFormatException numberFormatException) {
            this.position = this.matcher.start();
            throw new InputMismatchException(numberFormatException.getMessage());
        }
    }

    public boolean hasNextBigDecimal() {
        this.setRadix(10);
        boolean bl = this.hasNext(this.decimalPattern());
        if (bl) {
            try {
                String string = this.processFloatToken(this.hasNextResult);
                this.typeCache = new BigDecimal(string);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        }
        return bl;
    }

    public BigDecimal nextBigDecimal() {
        if (this.typeCache != null && this.typeCache instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)this.typeCache;
            this.useTypeCache();
            return bigDecimal;
        }
        this.setRadix(10);
        this.clearCaches();
        try {
            String string = this.processFloatToken(this.next(this.decimalPattern()));
            return new BigDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.position = this.matcher.start();
            throw new InputMismatchException(numberFormatException.getMessage());
        }
    }
}

