/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.PlainSocketImpl;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.FileChannel;
import sun.net.ConnectionResetException;

class SocketInputStream
extends FileInputStream {
    private boolean eof;
    private PlainSocketImpl impl = null;
    private byte[] temp;
    private Socket socket = null;
    private boolean closing = false;

    SocketInputStream(PlainSocketImpl plainSocketImpl) throws IOException {
        super(plainSocketImpl.getFileDescriptor());
        this.impl = plainSocketImpl;
        this.socket = plainSocketImpl.getSocket();
    }

    public final FileChannel getChannel() {
        return null;
    }

    private native int socketRead0(FileDescriptor var1, byte[] var2, int var3, int var4, int var5) throws IOException;

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.eof) {
            return -1;
        }
        if (this.impl.isConnectionReset()) {
            throw new SocketException("Connection reset");
        }
        if (n2 <= 0 || n < 0 || n + n2 > byArray.length) {
            if (n2 == 0) {
                return 0;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        boolean bl = false;
        FileDescriptor fileDescriptor = this.impl.acquireFD();
        try {
            n3 = this.socketRead0(fileDescriptor, byArray, n, n2, this.impl.getTimeout());
            if (n3 > 0) {
                int n4 = n3;
                return n4;
            }
        }
        catch (ConnectionResetException connectionResetException) {
            bl = true;
        }
        finally {
            this.impl.releaseFD();
        }
        if (bl) {
            this.impl.setConnectionResetPending();
            this.impl.acquireFD();
            try {
                n3 = this.socketRead0(fileDescriptor, byArray, n, n2, this.impl.getTimeout());
                if (n3 > 0) {
                    int n5 = n3;
                    return n5;
                }
            }
            catch (ConnectionResetException connectionResetException) {
            }
            finally {
                this.impl.releaseFD();
            }
        }
        if (this.impl.isClosedOrPending()) {
            throw new SocketException("Socket closed");
        }
        if (this.impl.isConnectionResetPending()) {
            this.impl.setConnectionReset();
        }
        if (this.impl.isConnectionReset()) {
            throw new SocketException("Connection reset");
        }
        this.eof = true;
        return -1;
    }

    public int read() throws IOException {
        if (this.eof) {
            return -1;
        }
        this.temp = new byte[1];
        int n = this.read(this.temp, 0, 1);
        if (n <= 0) {
            return -1;
        }
        return this.temp[0] & 0xFF;
    }

    public long skip(long l) throws IOException {
        int n;
        long l2;
        if (l <= 0L) {
            return 0L;
        }
        int n2 = (int)Math.min(1024L, l2);
        byte[] byArray = new byte[n2];
        for (l2 = l; l2 > 0L && (n = this.read(byArray, 0, (int)Math.min((long)n2, l2))) >= 0; l2 -= (long)n) {
        }
        return l - l2;
    }

    public int available() throws IOException {
        return this.impl.available();
    }

    public void close() throws IOException {
        if (this.closing) {
            return;
        }
        this.closing = true;
        if (this.socket != null) {
            if (!this.socket.isClosed()) {
                this.socket.close();
            }
        } else {
            this.impl.close();
        }
        this.closing = false;
    }

    void setEOF(boolean bl) {
        this.eof = bl;
    }

    protected void finalize() {
    }

    private static native void init();

    static {
        SocketInputStream.init();
    }
}

