/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.Debugger;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.memory.SymbolTable;
import sun.jvm.hotspot.oops.BooleanField;
import sun.jvm.hotspot.oops.ByteField;
import sun.jvm.hotspot.oops.CharField;
import sun.jvm.hotspot.oops.DefaultHeapVisitor;
import sun.jvm.hotspot.oops.DoubleField;
import sun.jvm.hotspot.oops.Field;
import sun.jvm.hotspot.oops.FloatField;
import sun.jvm.hotspot.oops.Instance;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.IntField;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.LongField;
import sun.jvm.hotspot.oops.ObjArray;
import sun.jvm.hotspot.oops.ObjArrayKlass;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopField;
import sun.jvm.hotspot.oops.OopUtilities;
import sun.jvm.hotspot.oops.ShortField;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.oops.TypeArray;
import sun.jvm.hotspot.oops.TypeArrayKlass;
import sun.jvm.hotspot.runtime.AddressVisitor;
import sun.jvm.hotspot.runtime.JNIHandleBlock;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.utilities.AbstractHeapGraphWriter;

public class HeapHprofBinWriter
extends AbstractHeapGraphWriter {
    private static final String HPROF_HEADER = "JAVA PROFILE 1.0.1";
    private static final int HPROF_UTF8 = 1;
    private static final int HPROF_LOAD_CLASS = 2;
    private static final int HPROF_UNLOAD_CLASS = 3;
    private static final int HPROF_FRAME = 4;
    private static final int HPROF_TRACE = 5;
    private static final int HPROF_ALLOC_SITES = 6;
    private static final int HPROF_HEAP_SUMMARY = 7;
    private static final int HPROF_START_THREAD = 10;
    private static final int HPROF_END_THREAD = 11;
    private static final int HPROF_HEAP_DUMP = 12;
    private static final int HPROF_CPU_SAMPLES = 13;
    private static final int HPROF_CONTROL_SETTINGS = 14;
    private static final int HPROF_GC_ROOT_UNKNOWN = 255;
    private static final int HPROF_GC_ROOT_JNI_GLOBAL = 1;
    private static final int HPROF_GC_ROOT_JNI_LOCAL = 2;
    private static final int HPROF_GC_ROOT_JAVA_FRAME = 3;
    private static final int HPROF_GC_ROOT_NATIVE_STACK = 4;
    private static final int HPROF_GC_ROOT_STICKY_CLASS = 5;
    private static final int HPROF_GC_ROOT_THREAD_BLOCK = 6;
    private static final int HPROF_GC_ROOT_MONITOR_USED = 7;
    private static final int HPROF_GC_ROOT_THREAD_OBJ = 8;
    private static final int HPROF_GC_CLASS_DUMP = 32;
    private static final int HPROF_GC_INSTANCE_DUMP = 33;
    private static final int HPROF_GC_OBJ_ARRAY_DUMP = 34;
    private static final int HPROF_GC_PRIM_ARRAY_DUMP = 35;
    private static final int HPROF_ARRAY_OBJECT = 1;
    private static final int HPROF_NORMAL_OBJECT = 2;
    private static final int HPROF_BOOLEAN = 4;
    private static final int HPROF_CHAR = 5;
    private static final int HPROF_FLOAT = 6;
    private static final int HPROF_DOUBLE = 7;
    private static final int HPROF_BYTE = 8;
    private static final int HPROF_SHORT = 9;
    private static final int HPROF_INT = 10;
    private static final int HPROF_LONG = 11;
    private static final int JVM_SIGNATURE_BOOLEAN = 90;
    private static final int JVM_SIGNATURE_CHAR = 67;
    private static final int JVM_SIGNATURE_BYTE = 66;
    private static final int JVM_SIGNATURE_SHORT = 83;
    private static final int JVM_SIGNATURE_INT = 73;
    private static final int JVM_SIGNATURE_LONG = 74;
    private static final int JVM_SIGNATURE_FLOAT = 70;
    private static final int JVM_SIGNATURE_DOUBLE = 68;
    private static final int JVM_SIGNATURE_ARRAY = 91;
    private static final int JVM_SIGNATURE_CLASS = 76;
    private static final int INVALID_STACK_TRACE_ID = 0;
    private static final int EMPTY_FRAME_DEPTH = -1;
    private DataOutputStream out;
    private List classes;
    private Debugger dbg;
    private ObjectHeap objectHeap;
    private SymbolTable symTbl;
    private int OBJ_ID_SIZE;

    public synchronized void write(OutputStream stream) throws IOException {
        File hprofTmpFile = File.createTempFile("jmapdump", null, null);
        hprofTmpFile.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(hprofTmpFile);
        BufferedOutputStream bufStream = new BufferedOutputStream(fos);
        this.out = new DataOutputStream(bufStream);
        VM vm = VM.getVM();
        this.dbg = vm.getDebugger();
        this.objectHeap = vm.getObjectHeap();
        this.symTbl = vm.getSymbolTable();
        this.OBJ_ID_SIZE = (int)vm.getOopSize();
        this.classes = new ArrayList();
        super.write();
        this.out.close();
        this.out = new DataOutputStream(new BufferedOutputStream(stream));
        this.writeFileHeader();
        this.writeSymbols();
        this.writeClasses();
        this.out.writeByte(12);
        this.out.writeInt(0);
        int len = (int)hprofTmpFile.length();
        this.out.writeInt(len);
        this.copyHeapData(hprofTmpFile);
        this.out.flush();
        this.out = null;
    }

    protected void writeClass(Instance instance) throws IOException {
        Klass reflectedKlass = OopUtilities.classOopToKlass(instance);
        this.classes.add(instance);
        if (reflectedKlass != null && reflectedKlass instanceof InstanceKlass) {
            InstanceKlass ik = (InstanceKlass)reflectedKlass;
            this.out.writeByte(32);
            this.writeObjectID(instance);
            this.out.writeInt(0);
            Klass superKlass = ik.getSuper();
            if (superKlass != null) {
                this.writeObjectID(ik.getSuper().getJavaMirror());
            } else {
                this.writeObjectID(null);
            }
            this.writeObjectID(ik.getClassLoader());
            this.writeObjectID(ik.getSigners());
            this.writeObjectID(ik.getProtectionDomain());
            this.writeObjectID(null);
            this.writeObjectID(null);
            List fields = HeapHprofBinWriter.getInstanceFields(ik);
            int instSize = this.getSizeForFields(fields);
            this.out.writeInt(instSize);
            this.out.writeShort(0);
            List declaredFields = ik.getImmediateFields();
            ArrayList<Field> staticFields = new ArrayList<Field>();
            ArrayList<Field> instanceFields = new ArrayList<Field>();
            Iterator itr = null;
            itr = declaredFields.iterator();
            while (itr.hasNext()) {
                Field field = (Field)itr.next();
                if (field.isStatic()) {
                    staticFields.add(field);
                    continue;
                }
                instanceFields.add(field);
            }
            this.writeFieldDescriptors(staticFields, ik);
            this.writeFieldDescriptors(instanceFields, null);
        } else {
            this.writeInstance(instance);
        }
    }

    protected void writeJavaThread(JavaThread jt, int index) throws IOException {
        this.out.writeByte(8);
        this.writeObjectID(jt.getThreadObj());
        this.out.writeInt(index);
        this.out.writeInt(0);
        this.writeLocalJNIHandles(jt, index);
    }

    protected void writeLocalJNIHandles(JavaThread jt, int index) throws IOException {
        final int threadIndex = index;
        JNIHandleBlock blk = jt.activeHandles();
        if (blk != null) {
            try {
                blk.oopsDo(new AddressVisitor(){

                    public void visitAddress(Address handleAddr) {
                        try {
                            if (handleAddr != null) {
                                OopHandle oopHandle = handleAddr.getOopHandleAt(0L);
                                Oop oop = HeapHprofBinWriter.this.objectHeap.newOop(oopHandle);
                                if (oop != null && HeapHprofBinWriter.this.isJavaVisible(oop)) {
                                    HeapHprofBinWriter.this.out.writeByte(2);
                                    HeapHprofBinWriter.this.writeObjectID(oop);
                                    HeapHprofBinWriter.this.out.writeInt(threadIndex);
                                    HeapHprofBinWriter.this.out.writeInt(-1);
                                }
                            }
                        }
                        catch (IOException exp) {
                            throw new RuntimeException(exp);
                        }
                    }
                });
            }
            catch (RuntimeException re) {
                this.handleRuntimeException(re);
            }
        }
    }

    protected void writeGlobalJNIHandle(Address handleAddr) throws IOException {
        OopHandle oopHandle = handleAddr.getOopHandleAt(0L);
        Oop oop = this.objectHeap.newOop(oopHandle);
        if (oop != null && this.isJavaVisible(oop)) {
            this.out.writeByte(1);
            this.writeObjectID(oop);
            this.writeObjectID(this.getAddressValue(handleAddr));
        }
    }

    protected void writeInstance(Instance instance) throws IOException {
        this.out.writeByte(33);
        this.writeObjectID(instance);
        this.out.writeInt(0);
        this.writeObjectID(instance.getKlass().getJavaMirror());
        List fields = HeapHprofBinWriter.getInstanceFields((InstanceKlass)instance.getKlass());
        int size = this.getSizeForFields(fields);
        this.out.writeInt(size);
        Iterator itr = fields.iterator();
        while (itr.hasNext()) {
            this.writeField((Field)itr.next(), instance);
        }
    }

    protected void writePrimitiveArray(TypeArray array) throws IOException {
        this.out.writeByte(35);
        this.writeObjectID(array);
        this.out.writeInt(0);
        this.out.writeInt((int)array.getLength());
        TypeArrayKlass tak = (TypeArrayKlass)array.getKlass();
        this.out.writeByte((byte)tak.getType());
        this.writeObjectFields(array);
    }

    protected void writeObjectArray(ObjArray array) throws IOException {
        this.out.writeByte(34);
        this.writeObjectID(array);
        this.out.writeInt(0);
        this.out.writeInt((int)array.getLength());
        ObjArrayKlass oak = (ObjArrayKlass)array.getKlass();
        Klass elementKlass = oak.getElementKlass();
        this.writeObjectID(elementKlass.getJavaMirror());
        this.writeObjectFields(array);
    }

    protected void writeInternalReferenceField(Oop oop, OopField field) throws IOException {
        this.writeObjectID(null);
    }

    protected void writeReferenceField(Oop oop, OopField field) throws IOException {
        this.writeObjectID(field.getValue(oop));
    }

    protected void writeByteField(Oop oop, ByteField field) throws IOException {
        this.out.writeByte(field.getValue(oop));
    }

    protected void writeCharField(Oop oop, CharField field) throws IOException {
        this.out.writeChar(field.getValue(oop));
    }

    protected void writeBooleanField(Oop oop, BooleanField field) throws IOException {
        this.out.writeBoolean(field.getValue(oop));
    }

    protected void writeShortField(Oop oop, ShortField field) throws IOException {
        this.out.writeShort(field.getValue(oop));
    }

    protected void writeIntField(Oop oop, IntField field) throws IOException {
        this.out.writeInt(field.getValue(oop));
    }

    protected void writeLongField(Oop oop, LongField field) throws IOException {
        this.out.writeLong(field.getValue(oop));
    }

    protected void writeFloatField(Oop oop, FloatField field) throws IOException {
        this.out.writeFloat(field.getValue(oop));
    }

    protected void writeDoubleField(Oop oop, DoubleField field) throws IOException {
        this.out.writeDouble(field.getValue(oop));
    }

    private void copyHeapData(File hprofTmpFile) throws IOException {
        FileInputStream fis = new FileInputStream(hprofTmpFile);
        byte[] buf = new byte[1024];
        int len = 0;
        while ((len = fis.read(buf)) != -1) {
            this.out.write(buf, 0, len);
        }
        fis.close();
    }

    private void writeFieldDescriptors(List fields, InstanceKlass ik) throws IOException {
        this.out.writeShort((short)fields.size());
        Iterator itr = fields.iterator();
        while (itr.hasNext()) {
            Field field = (Field)itr.next();
            Symbol name = this.symTbl.probe(field.getID().getName());
            this.writeObjectID(name);
            String sig = field.getSignature().asString();
            int type = HeapHprofBinWriter.signatureToHprofKind(sig.charAt(0));
            this.out.writeByte((byte)type);
            if (ik == null) continue;
            this.writeField(field, ik);
        }
    }

    public static int signatureToHprofKind(char ch) {
        switch (ch) {
            case 'L': 
            case '[': {
                return 2;
            }
            case 'Z': {
                return 4;
            }
            case 'C': {
                return 5;
            }
            case 'F': {
                return 6;
            }
            case 'D': {
                return 7;
            }
            case 'B': {
                return 8;
            }
            case 'S': {
                return 9;
            }
            case 'I': {
                return 10;
            }
            case 'J': {
                return 11;
            }
        }
        throw new RuntimeException("should not reach here");
    }

    private void writeField(Field field, Oop oop) throws IOException {
        String type = field.getSignature().asString();
        char typeCode = type.charAt(0);
        switch (typeCode) {
            case 'Z': {
                this.out.writeBoolean(((BooleanField)field).getValue(oop));
                break;
            }
            case 'C': {
                this.out.writeChar(((CharField)field).getValue(oop));
                break;
            }
            case 'B': {
                this.out.writeByte(((ByteField)field).getValue(oop));
                break;
            }
            case 'S': {
                this.out.writeShort(((ShortField)field).getValue(oop));
                break;
            }
            case 'I': {
                this.out.writeInt(((IntField)field).getValue(oop));
                break;
            }
            case 'J': {
                this.out.writeLong(((LongField)field).getValue(oop));
                break;
            }
            case 'F': {
                this.out.writeFloat(((FloatField)field).getValue(oop));
                break;
            }
            case 'D': {
                this.out.writeDouble(((DoubleField)field).getValue(oop));
                break;
            }
            case 'L': 
            case '[': {
                this.writeObjectID(((OopField)field).getValue(oop));
                break;
            }
            default: {
                throw new RuntimeException("should not reach here");
            }
        }
    }

    private void writeSymbols() throws IOException {
        ObjectHeap oheap = VM.getVM().getObjectHeap();
        try {
            oheap.iterate(new DefaultHeapVisitor(){

                public void doObj(Oop oop) {
                    try {
                        if (oop instanceof Symbol) {
                            HeapHprofBinWriter.this.writeSymbol((Symbol)oop);
                        }
                    }
                    catch (IOException exp) {
                        throw new RuntimeException(exp);
                    }
                }
            });
        }
        catch (RuntimeException re) {
            this.handleRuntimeException(re);
        }
    }

    private void writeSymbol(Symbol sym) throws IOException {
        this.out.writeByte(1);
        byte[] buf = sym.asString().getBytes("UTF-8");
        this.out.writeInt(0);
        this.out.writeInt(buf.length + this.OBJ_ID_SIZE);
        this.writeObjectID(sym);
        this.out.write(buf);
    }

    private void writeClasses() throws IOException {
        int serialNum = 1;
        Iterator itr = this.classes.iterator();
        while (itr.hasNext()) {
            Instance clazz = (Instance)itr.next();
            Klass k = OopUtilities.classOopToKlass(clazz);
            if (k == null) continue;
            this.out.writeByte(2);
            this.out.writeInt(0);
            this.out.writeInt(2 * (this.OBJ_ID_SIZE + 4));
            this.out.writeInt(serialNum);
            this.writeObjectID(clazz);
            this.out.writeInt(0);
            this.writeObjectID(k.getName());
            ++serialNum;
        }
        this.classes = null;
    }

    private void writeFileHeader() throws IOException {
        this.out.writeBytes(HPROF_HEADER);
        this.out.writeByte(0);
        this.out.writeInt(this.OBJ_ID_SIZE);
        this.out.writeLong(System.currentTimeMillis());
    }

    private void writeObjectID(Oop oop) throws IOException {
        OopHandle handle = oop != null ? oop.getHandle() : null;
        long address = this.getAddressValue(handle);
        this.writeObjectID(address);
    }

    private void writeObjectID(long address) throws IOException {
        if (this.OBJ_ID_SIZE == 4) {
            this.out.writeInt((int)address);
        } else {
            this.out.writeLong(address);
        }
    }

    private long getAddressValue(Address addr) {
        return this.dbg.getAddressValue(addr);
    }

    private static List getInstanceFields(InstanceKlass ik) {
        ArrayList<Field> res = new ArrayList<Field>();
        for (InstanceKlass klass = ik; klass != null; klass = (InstanceKlass)klass.getSuper()) {
            List curFields = klass.getImmediateFields();
            Iterator itr = curFields.iterator();
            while (itr.hasNext()) {
                Field f = (Field)itr.next();
                if (f.isStatic()) continue;
                res.add(f);
            }
        }
        return res;
    }

    private int getSizeForFields(List fields) {
        int size = 0;
        Iterator itr = fields.iterator();
        block7: while (itr.hasNext()) {
            Field field = (Field)itr.next();
            String type = field.getSignature().asString();
            char typeCode = type.charAt(0);
            switch (typeCode) {
                case 'B': 
                case 'Z': {
                    ++size;
                    continue block7;
                }
                case 'C': 
                case 'S': {
                    size += 2;
                    continue block7;
                }
                case 'F': 
                case 'I': {
                    size += 4;
                    continue block7;
                }
                case 'L': 
                case '[': {
                    size += this.OBJ_ID_SIZE;
                    continue block7;
                }
                case 'D': 
                case 'J': {
                    size += 8;
                    continue block7;
                }
            }
            throw new RuntimeException("should not reach here");
        }
        return size;
    }
}

