/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMReg;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.utilities.Assert;

public abstract class RegisterMap
implements Cloneable {
    protected Address[] location;
    protected int[] locationValid;
    protected boolean includeArgumentOops;
    protected JavaThread thread;
    protected boolean updateMap;
    protected Address notAtCallID;
    protected static int regCount;
    protected static int locationValidSize;

    private static void initialize(TypeDataBase db) {
        regCount = VM.getVM().isCore() ? db.lookupIntConstant("RegisterImpl::number_of_registers").intValue() : db.lookupIntConstant("REG_COUNT").intValue();
        locationValidSize = (regCount + 32 - 1) / 32;
    }

    protected RegisterMap(JavaThread thread, boolean updateMap) {
        this.thread = thread;
        this.updateMap = updateMap;
        this.location = new Address[regCount];
        this.locationValid = new int[locationValidSize];
        this.clear(thread.getNotAtCallID());
    }

    protected RegisterMap(RegisterMap map) {
        Assert.that(map != null, "RegisterMap must be present");
        this.thread = map.getThread();
        this.updateMap = map.getUpdateMap();
        this.includeArgumentOops = map.getIncludeArgumentOops();
        this.notAtCallID = map.notAtCallID;
        this.location = new Address[map.location.length];
        this.locationValid = new int[map.locationValid.length];
        this.initializeFromPD(map);
        if (this.updateMap) {
            for (int i = 0; i < locationValidSize; ++i) {
                int bits;
                this.locationValid[i] = bits = !this.getUpdateMap() ? 0 : map.locationValid[i];
                int j = i * 32;
                while (bits != 0) {
                    if ((bits & 1) != 0) {
                        Assert.that(0 <= j && j < regCount, "range check");
                        this.location[j] = map.location[j];
                    }
                    bits >>>= 1;
                    ++j;
                }
            }
        }
    }

    public abstract Object clone();

    public RegisterMap copy() {
        return (RegisterMap)this.clone();
    }

    public void clear(Address notAtCallID) {
        this.setIncludeArgumentOops(true);
        this.notAtCallID = notAtCallID;
        if (!VM.getVM().isCore()) {
            if (this.updateMap) {
                for (int i = 0; i < this.locationValid.length; ++i) {
                    this.locationValid[i] = 0;
                }
                this.clearPD();
            } else {
                this.initializePD();
            }
        }
    }

    public Address getLocation(VMReg reg) {
        int i = reg.getValue();
        int index = i / 32;
        Assert.that(0 <= i && i < regCount, "sanity check");
        Assert.that(0 <= index && index < locationValidSize, "sanity check");
        if ((this.locationValid[index] & 1 << i % 32) != 0) {
            return this.location[i];
        }
        return this.getLocationPD(reg);
    }

    public void setLocation(VMReg reg, Address loc) {
        int i = reg.getValue();
        int index = i / 32;
        Assert.that(0 <= i && i < regCount, "sanity check");
        Assert.that(0 <= index && index < locationValidSize, "sanity check");
        Assert.that(this.updateMap, "updating map that does not need updating");
        this.location[i] = loc;
        int n = index;
        this.locationValid[n] = this.locationValid[n] | 1 << i % 32;
    }

    public boolean getIncludeArgumentOops() {
        return this.includeArgumentOops;
    }

    public void setIncludeArgumentOops(boolean f) {
        this.includeArgumentOops = f;
    }

    public JavaThread getThread() {
        return this.thread;
    }

    public boolean getUpdateMap() {
        return this.updateMap;
    }

    public void print() {
        this.printOn(System.out);
    }

    public void printOn(PrintStream tty) {
        tty.println("Register map");
        for (int i = 0; i < this.location.length; ++i) {
            Address src = this.getLocation(new VMReg(i));
            if (src == null) continue;
            tty.println("  " + this.getRegisterNamePD(i) + " [" + src + "] = " + src.getAddressAt(0L));
        }
    }

    public boolean isPCAtCall(Address id) {
        if (this.notAtCallID == null) {
            return this.notAtCallID != id;
        }
        return !((Object)this.notAtCallID).equals(id);
    }

    protected abstract void clearPD();

    protected abstract void initializePD();

    protected abstract void initializeFromPD(RegisterMap var1);

    protected abstract Address getLocationPD(VMReg var1);

    protected abstract String getRegisterNamePD(int var1);

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                RegisterMap.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

