/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.BasicLock;
import sun.jvm.hotspot.runtime.ObjectMonitor;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;
import sun.jvm.hotspot.utilities.Assert;
import sun.jvm.hotspot.utilities.Bits;

public class Mark
extends VMObject {
    private static CIntegerField markField;
    private static long ageBits;
    private static long lockBits;
    private static long maxHashBits;
    private static long hashBits;
    private static long lockShift;
    private static long ageShift;
    private static long hashShift;
    private static long lockMask;
    private static long lockMaskInPlace;
    private static long ageMask;
    private static long ageMaskInPlace;
    private static long hashMask;
    private static long hashMaskInPlace;
    private static long lockedValue;
    private static long unlockedValue;
    private static long monitorValue;
    private static long markedValue;
    private static long noHash;
    private static long noHashInPlace;
    private static long noLockInPlace;
    private static long maxAge;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("oopDesc");
        markField = type.getCIntegerField("_mark");
        ageBits = db.lookupLongConstant("markOopDesc::age_bits");
        lockBits = db.lookupLongConstant("markOopDesc::lock_bits");
        maxHashBits = db.lookupLongConstant("markOopDesc::max_hash_bits");
        hashBits = db.lookupLongConstant("markOopDesc::hash_bits");
        lockShift = db.lookupLongConstant("markOopDesc::lock_shift");
        ageShift = db.lookupLongConstant("markOopDesc::age_shift");
        hashShift = db.lookupLongConstant("markOopDesc::hash_shift");
        lockMask = db.lookupLongConstant("markOopDesc::lock_mask");
        lockMaskInPlace = db.lookupLongConstant("markOopDesc::lock_mask_in_place");
        ageMask = db.lookupLongConstant("markOopDesc::age_mask");
        ageMaskInPlace = db.lookupLongConstant("markOopDesc::age_mask_in_place");
        hashMask = db.lookupLongConstant("markOopDesc::hash_mask");
        hashMaskInPlace = db.lookupLongConstant("markOopDesc::hash_mask_in_place");
        lockedValue = db.lookupLongConstant("markOopDesc::locked_value");
        unlockedValue = db.lookupLongConstant("markOopDesc::unlocked_value");
        monitorValue = db.lookupLongConstant("markOopDesc::monitor_value");
        markedValue = db.lookupLongConstant("markOopDesc::marked_value");
        noHash = db.lookupLongConstant("markOopDesc::no_hash");
        noHashInPlace = db.lookupLongConstant("markOopDesc::no_hash_in_place");
        noLockInPlace = db.lookupLongConstant("markOopDesc::no_lock_in_place");
        maxAge = db.lookupLongConstant("markOopDesc::max_age");
    }

    public Mark(Address addr) {
        super(addr);
    }

    public long value() {
        return markField.getValue(this.addr);
    }

    public Address valueAsAddress() {
        return this.addr.getAddressAt(markField.getOffset());
    }

    public boolean isLocked() {
        return Bits.maskBitsLong(this.value(), lockMaskInPlace) != unlockedValue;
    }

    public boolean isUnlocked() {
        return Bits.maskBitsLong(this.value(), lockMaskInPlace) == unlockedValue;
    }

    public boolean isMarked() {
        return Bits.maskBitsLong(this.value(), lockMaskInPlace) == markedValue;
    }

    public boolean mustBePreserved() {
        return !this.isUnlocked() || !this.hasNoHash();
    }

    public boolean hasLocker() {
        return (this.value() & lockMaskInPlace) == lockedValue;
    }

    public BasicLock locker() {
        Assert.that(this.hasLocker(), "check");
        return new BasicLock(this.valueAsAddress());
    }

    public boolean hasMonitor() {
        return (this.value() & monitorValue) != 0L;
    }

    public ObjectMonitor monitor() {
        Assert.that(this.hasMonitor(), "check");
        Address monAddr = this.valueAsAddress().xorWithMask(monitorValue);
        return new ObjectMonitor(monAddr);
    }

    public boolean hasDisplacedMarkHelper() {
        return (this.value() & unlockedValue) == 0L;
    }

    public Mark displacedMarkHelper() {
        Assert.that(this.hasDisplacedMarkHelper(), "check");
        Address addr = this.valueAsAddress().andWithMask(monitorValue ^ 0xFFFFFFFFFFFFFFFFL);
        return new Mark(addr.getAddressAt(0L));
    }

    public int age() {
        return (int)Bits.maskBitsLong(this.value() >> (int)ageShift, ageMask);
    }

    public long hash() {
        return Bits.maskBitsLong(this.value() >> (int)hashShift, hashMask);
    }

    public boolean hasNoHash() {
        return this.hash() == noHash;
    }

    public void printOn(PrintStream tty) {
        if (this.isLocked()) {
            tty.print("locked(0x" + Long.toHexString(this.value()) + ")->");
            this.displacedMarkHelper().printOn(tty);
        } else {
            Assert.that(this.isUnlocked(), "just checking");
            tty.print("mark(");
            tty.print("hash " + Long.toHexString(this.hash()) + ",");
            tty.print("age " + this.age() + ")");
        }
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                Mark.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

