/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.memory;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.memory.CarTable;
import sun.jvm.hotspot.memory.CarTableDesc;
import sun.jvm.hotspot.memory.CardGeneration;
import sun.jvm.hotspot.memory.Generation;
import sun.jvm.hotspot.memory.SpaceClosure;
import sun.jvm.hotspot.memory.Train;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class TrainGeneration
extends CardGeneration {
    private static AddressField firstTrainField;
    private static AddressField lastTrainField;
    private static AddressField specialNonOopTrainField;
    private static AddressField firstCarDescField;
    private static AddressField carTabField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("TrainGeneration");
        firstTrainField = type.getAddressField("_first_train");
        lastTrainField = type.getAddressField("_last_train");
        specialNonOopTrainField = type.getAddressField("_special_nonoop_train");
        firstCarDescField = type.getAddressField("_first_car_desc");
        carTabField = type.getAddressField("_car_tab");
    }

    public Train firstTrain() {
        return (Train)VMObjectFactory.newObject(Train.class, firstTrainField.getValue(this.addr));
    }

    public Train lastTrain() {
        return (Train)VMObjectFactory.newObject(Train.class, lastTrainField.getValue(this.addr));
    }

    public Train specialNonOopTrain() {
        return (Train)VMObjectFactory.newObject(Train.class, specialNonOopTrainField.getValue(this.addr));
    }

    public CarTableDesc firstCarDesc() {
        return (CarTableDesc)VMObjectFactory.newObject(CarTableDesc.class, firstCarDescField.getValue(this.addr));
    }

    public CarTable carTable() {
        return (CarTable)VMObjectFactory.newObject(CarTable.class, carTabField.getValue(this.addr));
    }

    public TrainGeneration(Address addr) {
        super(addr);
    }

    public long capacity() {
        return this.virtualSpace().committedSize();
    }

    public long used() {
        long size = 0L;
        Train nonOopTrain = this.specialNonOopTrain();
        if (nonOopTrain != null) {
            size += nonOopTrain.used();
        }
        for (Train t = this.firstTrain(); t != null; t = t.nextTrain()) {
            size += t.used();
        }
        return size;
    }

    public long free() {
        return this.capacity() - this.used();
    }

    public long contiguousAvailable() {
        throw new RuntimeException("not yet implemented");
    }

    public boolean contains(Address p) {
        throw new RuntimeException("not yet implemented");
    }

    public String name() {
        return "train generation";
    }

    public void spaceIterate(SpaceClosure blk, boolean usedOnly) {
        Train nonOopTrain = this.specialNonOopTrain();
        if (nonOopTrain != null) {
            nonOopTrain.spaceIterate(blk, usedOnly);
        }
        for (Train t = this.firstTrain(); t != null; t = t.nextTrain()) {
            t.spaceIterate(blk, usedOnly);
        }
    }

    public void printOn(PrintStream tty) {
        Train nonOopTrain = this.specialNonOopTrain();
        if (nonOopTrain != null) {
            nonOopTrain.printOn(tty);
        }
        for (Train t = this.firstTrain(); t != null; t = t.nextTrain()) {
            t.printOn(tty);
        }
    }

    public Generation.Name kind() {
        return Generation.Name.TRAIN_GEN;
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                TrainGeneration.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

