/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class TitledBorder
extends AbstractBorder {
    public static final int DEFAULT_POSITION = 0;
    public static final int ABOVE_TOP = 1;
    public static final int TOP = 2;
    public static final int BELOW_TOP = 3;
    public static final int ABOVE_BOTTOM = 4;
    public static final int BOTTOM = 5;
    public static final int BELOW_BOTTOM = 6;
    public static final int DEFAULT_JUSTIFICATION = 0;
    public static final int LEFT = 1;
    public static final int CENTER = 2;
    public static final int RIGHT = 3;
    public static final int LEADING = 4;
    public static final int TRAILING = 5;
    protected static final int EDGE_SPACING = 2;
    protected static final int TEXT_INSET_H = 5;
    protected static final int TEXT_SPACING = 2;
    static final long serialVersionUID = 8012999415147721601L;
    protected String title;
    protected Border border;
    protected int titlePosition;
    protected int titleJustification;
    protected Font titleFont;
    protected Color titleColor;

    public TitledBorder(String title) {
        this(null, title, 0, 0, null, null);
    }

    public TitledBorder(Border border) {
        this(border, "", 0, 0, null, null);
    }

    public TitledBorder(Border border, String title) {
        this(border, title, 0, 0, null, null);
    }

    public TitledBorder(Border border, String title, int titleJustification, int titlePosition) {
        this(border, title, titleJustification, titlePosition, null, null);
    }

    public TitledBorder(Border border, String title, int titleJustification, int titlePosition, Font titleFont) {
        this(border, title, titleJustification, titlePosition, titleFont, null);
    }

    public TitledBorder(Border border, String title, int titleJustification, int titlePosition, Font titleFont, Color titleColor) {
        this.border = border;
        this.title = title;
        this.setTitleJustification(titleJustification);
        this.setTitlePosition(titlePosition);
        this.titleFont = titleFont;
        this.titleColor = titleColor;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int textY;
        int textX;
        Measurements mes = this.getMeasurements(c);
        Font oldFont = g.getFont();
        Color oldColor = g.getColor();
        int borderWidth = width - (mes.borderSpacing.left + mes.borderSpacing.right);
        int borderHeight = height - (mes.borderSpacing.top + mes.borderSpacing.bottom);
        1.BorderPainter bp = new 1.BorderPainter(this, c, this.getBorder(), x + mes.borderSpacing.left, y + mes.borderSpacing.top, borderWidth, borderHeight);
        switch (this.getRealTitleJustification(c)) {
            case 1: {
                textX = x + 5;
                break;
            }
            case 2: {
                textX = x + (borderWidth - mes.textWidth) / 2;
                break;
            }
            case 3: {
                textX = x + borderWidth - (mes.textWidth + 5);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        switch (this.titlePosition) {
            case 1: {
                textY = y;
                break;
            }
            default: {
                textY = y + mes.borderSpacing.top + mes.borderInsets.top - mes.textAscent;
                break;
            }
            case 3: {
                textY = y + mes.borderSpacing.top + mes.borderInsets.top + 2;
                break;
            }
            case 4: {
                textY = y + height - mes.borderSpacing.bottom - mes.borderInsets.bottom - 2 - (mes.textAscent + mes.textDescent);
                break;
            }
            case 5: 
            case 6: {
                textY = y + height - (mes.textAscent + mes.textDescent);
            }
        }
        if (mes.trimmedText == null) {
            bp.paint(g);
        } else {
            try {
                g.setFont(mes.font);
                g.setColor(this.getTitleColor());
                g.drawString(mes.trimmedText, textX, textY + mes.textAscent);
            }
            finally {
                Object var15_15 = null;
                g.setFont(oldFont);
                g.setColor(oldColor);
            }
            bp.paintExcept(g, textX - 2, textY, mes.textWidth + 2, mes.textAscent + mes.textDescent);
        }
    }

    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        return this.getMeasurements(c).getContentInsets(insets);
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public String getTitle() {
        return this.title;
    }

    public Border getBorder() {
        if (this.border != null) {
            return this.border;
        }
        return UIManager.getBorder("TitledBorder.border");
    }

    public int getTitlePosition() {
        return this.titlePosition;
    }

    public int getTitleJustification() {
        return this.titleJustification;
    }

    public Font getTitleFont() {
        if (this.titleFont != null) {
            return this.titleFont;
        }
        return UIManager.getFont("TitledBorder.font");
    }

    public Color getTitleColor() {
        if (this.titleColor != null) {
            return this.titleColor;
        }
        return UIManager.getColor("TitledBorder.titleColor");
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setBorder(Border border) {
        this.border = border;
    }

    public void setTitlePosition(int titlePosition) {
        if (titlePosition < 0 || titlePosition > 6) {
            throw new IllegalArgumentException();
        }
        this.titlePosition = titlePosition;
    }

    public void setTitleJustification(int titleJustification) {
        if (titleJustification < 0 || titleJustification > 5) {
            throw new IllegalArgumentException();
        }
        this.titleJustification = titleJustification;
    }

    public void setTitleFont(Font titleFont) {
        this.titleFont = titleFont;
    }

    public void setTitleColor(Color titleColor) {
        this.titleColor = titleColor;
    }

    public Dimension getMinimumSize(Component c) {
        return this.getMeasurements(c).getMinimumSize();
    }

    protected Font getFont(Component c) {
        Font f = this.getTitleFont();
        if (f != null) {
            return f;
        }
        return new Font("Dialog", 0, 12);
    }

    private int getRealTitleJustification(Component c) {
        switch (this.titleJustification) {
            case 0: 
            case 4: {
                if (c == null || c.getComponentOrientation().isLeftToRight()) {
                    return 1;
                }
                return 3;
            }
            case 5: {
                if (c == null || c.getComponentOrientation().isLeftToRight()) {
                    return 3;
                }
                return 1;
            }
        }
        return this.titleJustification;
    }

    private Measurements getMeasurements(Component c) {
        Measurements m = new Measurements();
        m.font = this.getFont(c);
        FontMetrics fmet = c.getFontMetrics(m.font);
        m.border = this.getBorder();
        m.borderInsets = m.border != null ? m.border.getBorderInsets(c) : new Insets(0, 0, 0, 0);
        if (this.title != null) {
            m.trimmedText = this.title.trim();
            if (m.trimmedText.length() == 0) {
                m.trimmedText = null;
            }
        }
        m.textAscent = fmet.getAscent();
        m.textDescent = fmet.getDescent();
        if (m.trimmedText != null) {
            m.textWidth = fmet.stringWidth(m.trimmedText) + 3;
        }
        m.edgeSpacing = new Insets(2, 2, 2, 2);
        m.borderSpacing = new Insets(0, 0, 0, 0);
        switch (this.titlePosition) {
            case 1: {
                m.borderSpacing.top += m.textAscent + m.textDescent + 2;
                break;
            }
            case 3: {
                m.edgeSpacing.top += m.textAscent + m.textDescent + 2;
                break;
            }
            case 4: {
                m.edgeSpacing.bottom += m.textAscent + m.textDescent + 2;
                break;
            }
            case 5: {
                m.edgeSpacing.bottom += Math.max(m.textAscent - m.borderInsets.bottom, 0);
                m.borderSpacing.bottom += m.textDescent;
                break;
            }
            case 6: {
                m.borderSpacing.bottom += m.textAscent + m.textDescent + 2;
                break;
            }
            default: {
                m.borderSpacing.top += m.textAscent;
            }
        }
        return m;
    }

    private static class Measurements {
        Font font;
        int textAscent;
        int textDescent;
        String trimmedText;
        int textWidth;
        Border border;
        Insets borderSpacing;
        Insets borderInsets;
        Insets edgeSpacing;

        public Insets getContentInsets(Insets i) {
            if (i == null) {
                i = new Insets(0, 0, 0, 0);
            }
            i.left = this.borderSpacing.left + this.borderInsets.left + this.edgeSpacing.left;
            i.right = this.borderSpacing.right + this.borderInsets.right + this.edgeSpacing.right;
            i.top = this.borderSpacing.top + this.borderInsets.top + this.edgeSpacing.top;
            i.bottom = this.borderSpacing.bottom + this.borderInsets.bottom + this.edgeSpacing.bottom;
            return i;
        }

        public Dimension getMinimumSize() {
            Insets insets = this.getContentInsets(null);
            int width = Math.max(insets.left + insets.right, this.textWidth + 10);
            return new Dimension(width, insets.top + insets.bottom);
        }

        Measurements() {
        }
    }
}

