/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

class FormatCharacterIterator
implements AttributedCharacterIterator {
    private String formattedString;
    private int charIndex;
    private int attributeIndex;
    private int[] ranges;
    private HashMap[] attributes;

    FormatCharacterIterator() {
        this.formattedString = "";
        this.ranges = new int[0];
        this.attributes = new HashMap[0];
    }

    FormatCharacterIterator(String s, int[] ranges, HashMap[] attributes) {
        this.formattedString = s;
        this.ranges = ranges;
        this.attributes = attributes;
    }

    public Set getAllAttributeKeys() {
        if (this.attributes != null && this.attributes[this.attributeIndex] != null) {
            return this.attributes[this.attributeIndex].keySet();
        }
        return new HashSet();
    }

    public Map getAttributes() {
        if (this.attributes != null && this.attributes[this.attributeIndex] != null) {
            return this.attributes[this.attributeIndex];
        }
        return new HashMap();
    }

    public Object getAttribute(AttributedCharacterIterator.Attribute attrib) {
        if (this.attributes != null && this.attributes[this.attributeIndex] != null) {
            return this.attributes[this.attributeIndex].get(attrib);
        }
        return null;
    }

    public int getRunLimit(Set reqAttrs) {
        Set newKeys;
        if (this.attributes == null) {
            return this.formattedString.length();
        }
        int currentAttrIndex = this.attributeIndex;
        do {
            if (++currentAttrIndex != this.attributes.length) continue;
            return this.formattedString.length();
        } while (this.attributes[currentAttrIndex] != null && (newKeys = this.attributes[currentAttrIndex].keySet()).containsAll(reqAttrs));
        return this.ranges[currentAttrIndex - 1];
    }

    public int getRunLimit(AttributedCharacterIterator.Attribute attribute) {
        HashSet s = new HashSet();
        s.add(attribute);
        return this.getRunLimit(s);
    }

    public int getRunLimit() {
        if (this.attributes == null) {
            return this.formattedString.length();
        }
        if (this.attributes[this.attributeIndex] == null) {
            for (int i = this.attributeIndex + 1; i < this.attributes.length; ++i) {
                if (this.attributes[i] == null) continue;
                return this.ranges[i - 1];
            }
            return this.formattedString.length();
        }
        return this.getRunLimit(this.attributes[this.attributeIndex].keySet());
    }

    public int getRunStart(Set reqAttrs) {
        if (this.attributes == null) {
            return this.formattedString.length();
        }
        int currentAttrIndex = this.attributeIndex;
        Set newKeys = null;
        do {
            if (currentAttrIndex != 0) continue;
            return 0;
        } while (this.attributes[--currentAttrIndex] != null && (newKeys = this.attributes[currentAttrIndex].keySet()).containsAll(reqAttrs));
        if (currentAttrIndex > 0) {
            return this.ranges[currentAttrIndex - 1];
        }
        return 0;
    }

    public int getRunStart() {
        if (this.attributes == null) {
            return 0;
        }
        if (this.attributes[this.attributeIndex] == null) {
            for (int i = this.attributeIndex; i > 0; --i) {
                if (this.attributes[i] == null) continue;
                return this.ranges[this.attributeIndex - 1];
            }
            return 0;
        }
        return this.getRunStart(this.attributes[this.attributeIndex].keySet());
    }

    public int getRunStart(AttributedCharacterIterator.Attribute attribute) {
        HashSet s = new HashSet();
        s.add(attribute);
        return this.getRunStart(s);
    }

    public Object clone() {
        return new FormatCharacterIterator(this.formattedString, this.ranges, this.attributes);
    }

    public char current() {
        return this.formattedString.charAt(this.charIndex);
    }

    public char first() {
        this.charIndex = 0;
        this.attributeIndex = 0;
        return this.formattedString.charAt(0);
    }

    public int getBeginIndex() {
        return 0;
    }

    public int getEndIndex() {
        return this.formattedString.length();
    }

    public int getIndex() {
        return this.charIndex;
    }

    public char last() {
        this.charIndex = this.formattedString.length() - 1;
        if (this.attributes != null) {
            this.attributeIndex = this.attributes.length - 1;
        }
        return this.formattedString.charAt(this.charIndex);
    }

    public char next() {
        ++this.charIndex;
        if (this.charIndex >= this.formattedString.length()) {
            this.charIndex = this.getEndIndex();
            return '\uffff';
        }
        if (this.attributes != null && this.charIndex >= this.ranges[this.attributeIndex]) {
            ++this.attributeIndex;
        }
        return this.formattedString.charAt(this.charIndex);
    }

    public char previous() {
        --this.charIndex;
        if (this.charIndex < 0) {
            this.charIndex = 0;
            return '\uffff';
        }
        if (this.attributes != null && this.charIndex < this.ranges[this.attributeIndex]) {
            --this.attributeIndex;
        }
        return this.formattedString.charAt(this.charIndex);
    }

    public char setIndex(int position) {
        if (position < 0 || position > this.formattedString.length()) {
            throw new IllegalArgumentException("position is out of range");
        }
        this.charIndex = position;
        if (this.attributes != null) {
            this.attributeIndex = 0;
            while (this.attributeIndex < this.attributes.length && this.ranges[this.attributeIndex] <= this.charIndex) {
                ++this.attributeIndex;
            }
            --this.attributeIndex;
        }
        if (this.charIndex == this.formattedString.length()) {
            return '\uffff';
        }
        return this.formattedString.charAt(this.charIndex);
    }

    protected void mergeAttributes(HashMap[] attributes, int[] ranges) {
        Vector new_ranges = new Vector();
        Vector new_attributes = new Vector();
        int i = 0;
        int j = 0;
        while (i < this.ranges.length && j < ranges.length) {
            if (this.attributes[i] != null) {
                new_attributes.add(this.attributes[i]);
                if (attributes[j] != null) {
                    this.attributes[i].putAll(attributes[j]);
                }
            } else {
                new_attributes.add(attributes[j]);
            }
            if (this.ranges[i] == ranges[j]) {
                new_ranges.add(new Integer(ranges[j]));
                ++i;
                ++j;
                continue;
            }
            if (this.ranges[i] < ranges[j]) {
                new_ranges.add(new Integer(this.ranges[i]));
                ++i;
                continue;
            }
            new_ranges.add(new Integer(ranges[j]));
            ++j;
        }
        if (i != this.ranges.length) {
            while (i < this.ranges.length) {
                new_attributes.add(this.attributes[i]);
                new_ranges.add(new Integer(this.ranges[i]));
                ++i;
            }
        }
        if (j != ranges.length) {
            while (j < ranges.length) {
                new_attributes.add(attributes[j]);
                new_ranges.add(new Integer(ranges[j]));
                ++j;
            }
        }
        this.attributes = new HashMap[new_attributes.size()];
        this.ranges = new int[new_ranges.size()];
        System.arraycopy(new_attributes.toArray(), 0, this.attributes, 0, this.attributes.length);
        for (i = 0; i < new_ranges.size(); ++i) {
            this.ranges[i] = (Integer)new_ranges.elementAt(i);
        }
    }

    protected void append(AttributedCharacterIterator iterator) {
        char c = iterator.first();
        Vector more_ranges = new Vector();
        Vector more_attributes = new Vector();
        do {
            this.formattedString = this.formattedString + String.valueOf(c);
            more_attributes.add(iterator.getAttributes());
            more_ranges.add(new Integer(this.formattedString.length()));
            c = iterator.next();
        } while (c != '\uffff');
        HashMap[] new_attributes = new HashMap[this.attributes.length + more_attributes.size()];
        int[] new_ranges = new int[this.ranges.length + more_ranges.size()];
        System.arraycopy(this.attributes, 0, new_attributes, 0, this.attributes.length);
        System.arraycopy(more_attributes.toArray(), 0, new_attributes, this.attributes.length, more_attributes.size());
        System.arraycopy(this.ranges, 0, new_ranges, 0, this.ranges.length);
        Object[] new_ranges_array = more_ranges.toArray();
        for (int i = 0; i < more_ranges.size(); ++i) {
            new_ranges[i + this.ranges.length] = (Integer)new_ranges_array[i];
        }
        this.attributes = new_attributes;
        this.ranges = new_ranges;
    }

    protected void append(String text, HashMap local_attributes) {
        int[] new_ranges = new int[this.ranges.length + 1];
        HashMap[] new_attributes = new HashMap[this.attributes.length + 1];
        this.formattedString = this.formattedString + text;
        System.arraycopy(this.attributes, 0, new_attributes, 0, this.attributes.length);
        System.arraycopy(this.ranges, 0, new_ranges, 0, this.ranges.length);
        new_ranges[this.ranges.length] = this.formattedString.length();
        new_attributes[this.attributes.length] = local_attributes;
        this.ranges = new_ranges;
        this.attributes = new_attributes;
    }

    protected void append(String text) {
        this.append(text, null);
    }
}

